# -*- coding: UTF-8 -*-
"""
Test unitaires pour le module dpatterns.py
"""

import autopath
from era.noyau import dpatterns

def setup_module(module):
    module.sglton = SingletonImpl(10)
    module.observable = dpatterns.Observable()
    module.observer1 = ObserverImpl()
    module.observer2 = ObserverImpl()
    module.observable.register_observer(observer1)
    module.observable.register_observer(observer2)

# ____________________________________________________________
        
class SingletonImpl(dpatterns.Singleton):
    """Simple Implantation du Singleton
    """
    def __init__(self, val):
        self.val = val

def test_singleton():
    """Test pour vérifier qu'on a bien une unique instance, et qu'elle
    est bien réinitialisée à chaque fois
    """
    sglton2 = SingletonImpl(15)
    assert id(sglton2) == id(sglton)
    assert sglton.val == 15

# ____________________________________________________________

class ObserverImpl(dpatterns.Observer):
    """Simple Implantation de l'observer
    Pour éviter d'avoir un raise NotImplementedError
    """

    def __init__(self):
        self.notified = False
    
    def update(self):
        self.notified = True    

def test_observer_notify():
    """Test pour vérifier que tous les observers sont bien prévenus
    """
    observable.notify_observers()
    assert observer1.notified == True
    assert observer2.notified == True
    
def test_unregister_observer():
    """Test pour vérifier que les observers sont bien enlevés de la liste
    """
    observable.unregister_observer(observer1)
    assert observer1 not in observable.observers

# ____________________________________________________________

