#!/bin/bash

container_path_web=$(CreoleGet container_path_web)
container_ip_mysql=$(CreoleGet container_ip_mysql)
adresse_ip_mysql=$(CreoleGet adresse_ip_mysql)

if [ "$(CreoleGet mode_conteneur_actif)" = "oui" ]; then
    adresse_ip=$(CreoleGet container_ip_web)
else
    adresse_ip=$(CreoleGet adresse_ip_eth0)
fi

PWD=$(grep -R 'dbpassword' $container_path_web/var/www/html/glpi/config/config_db.php |cut -d'"' -f2)

VERSION=$(/usr/bin/mysql -u admin_glpi -p$PWD -h$adresse_ip_mysql -e "select version FROM glpi.glpi_configs" 2>/dev/null| tail -1)
echo $VERSION | grep -q "0.83.6"
if [ ! $? = 0 ]; then
    echo "Mise à jour de la base de données GLPI"
    wget -nv --delete-after --no-check-certificate --post-data 'from_update=Mise+%C3%A0+jour' http://$adresse_ip/glpi/install/update.php
fi

exit 0
