-- ------------------------------------------------- --
-- configuration de l'authentification CAS dans GLPI --
-- ------------------------------------------------- --

\r glpi

%if %%glpi_config_email == 'oui'
-- mail admin glpi --
LOCK TABLES `glpi_configs` WRITE;
    %if not %%is_empty(%%glpi_admin_email)
UPDATE `glpi`.`glpi_configs` SET `admin_email` = '%%glpi_admin_email' WHERE `glpi_configs`.`ID` =1 LIMIT 1 ;
    %end if
    %if not %%is_empty(%%system_mail_from)
UPDATE `glpi`.`glpi_configs` SET `admin_reply` = '%%system_mail_from' WHERE `glpi_configs`.`ID` =1 LIMIT 1 ;
    %end if
UNLOCK TABLES;
%end if


%if %%glpi_ldap_auth == "oui"
-- LDAP --
-- procedure de MAJ du groupe DomainAdmins si auth_ldap --
DELIMITER //
DROP PROCEDURE IF EXISTS AddDomainAdmins//
CREATE PROCEDURE AddDomainAdmins()
BEGIN
	DECLARE compteur int(5) default 0;
	SELECT count(*) FROM `glpi_groups` WHERE `name`='LDAPAdmins' INTO compteur;
	IF compteur = 0 THEN INSERT INTO `glpi_groups` (`id`, `entities_id`, `is_recursive`, `name`, `comment`, `groups_id`, `ldap_field`, `ldap_value`, `ldap_group_dn`, `completename`,`level`,`is_requester`, `is_assign`, `is_notify`, `is_itemgroup`, `is_usergroup`) VALUES (1,0,0,'LDAPAdmins',NULL,0,NULL,NULL,'%%glpi_domainadmins_dn','LDAPAdmins',1,1,1,1,1,1);
	INSERT INTO `glpi_authldaps` (`id`) VALUES (1);
	INSERT INTO `glpi_rulecriterias` (`id`, `rules_id`, `criteria`, `condition`, `pattern`) VALUES (9,7,'GROUPS',0,'1');
	INSERT INTO `glpi_rules` (`id`, `entities_id`, `sub_type`, `ranking`, `name`, `description`, `match`, `is_active`, `comment`, `is_recursive`) VALUES (7,0,'RuleRight',2,'LDAPAdmins','','OR',1,'',0);
	INSERT INTO `glpi_ruleactions` (`id`, `rules_id`, `action_type`, `field`, `value`) VALUES (6,7,'assign','profiles_id','4');
	ELSE UPDATE `glpi`.`glpi_groups` SET `ldap_group_dn`='%%glpi_domainadmins_dn' WHERE name='LDAPAdmins';
	END IF;
END//
DELIMITER ;
-- Fin procedure --

LOCK TABLES `glpi_configs` WRITE;
UPDATE `glpi`.`glpi_configs` SET `authldaps_id_extra` = 1 WHERE `glpi_configs`.`ID` =1 LIMIT 1 ;
UNLOCK TABLES;
CALL AddDomainAdmins();
DROP PROCEDURE IF EXISTS AddDomainAdmins;
LOCK TABLES `glpi_authldaps` WRITE;
    %if %%ldap_tls == 'oui'
-- probleme de certificat pour TLS, desactive (#3936)
-- %set %%use_tls = 1
        %set %%use_tls = 0
    %else
        %set %%use_tls = 0
    %end if
UPDATE `glpi`.`glpi_authldaps` SET `name` = 'LDAP', `host` = '%%adresse_ip_ldap', `basedn` = '%%ldap_base_dn', `port` = 389,
`login_field` = 'uid', `use_tls` = %%use_tls, `group_condition` = '(objectClass=posixGroup)', `group_search_type` = 1,
`group_member_field` = 'memberuid', `email1_field` = 'mail', `realname_field` = 'sn', `firstname_field` = 'givenname', `use_dn` = 0,
`is_default` = 1, `is_active` = 1 WHERE `glpi_authldaps`.`id` =1 LIMIT 1 ;
UNLOCK TABLES;
%elif %%glpi_ldap_auth == 'non'
LOCK TABLES `glpi_configs` WRITE;
UPDATE `glpi`.`glpi_configs` SET `authldaps_id_extra` = 0 WHERE `glpi_configs`.`ID` =1 LIMIT 1 ;
UNLOCK TABLES;
LOCK TABLES `glpi_authldaps` WRITE;
UPDATE `glpi`.`glpi_authldaps` SET `is_active` = 0 WHERE `glpi_authldaps`.`ID` =1 LIMIT 1 ;
UNLOCK TABLES;
%end if

LOCK TABLES `glpi_configs` WRITE;
%if %%glpi_cas_auth == "oui"
-- CAS --
UPDATE `glpi`.`glpi_configs` SET `cas_host` =  '%%eolesso_adresse',
`cas_port` = '%%eolesso_port',
`cas_uri` =  '%%eolesso_dossier',
`cas_logout` = 'https://%%eolesso_adresse:%%eolesso_port%%eolesso_dossier/logout?service=?https://%%web_url/glpi/login.php' WHERE `glpi_configs`.`ID` =1 LIMIT 1 ;
%elif %%glpi_cas_auth == "non"
UPDATE `glpi`.`glpi_configs` SET `cas_host` =  '',
`cas_port` = '',
`cas_logout` = '' WHERE `glpi_configs`.`ID` =1 LIMIT 1 ;
%end if
UNLOCK TABLES;
