<?php
/*
 * @version $Id: dropdownTrackingDeviceType.php 23346 2015-02-03 15:11:10Z moyo $
 -------------------------------------------------------------------------
 GLPI - Gestionnaire Libre de Parc Informatique
 Copyright (C) 2003-2014 by the INDEPNET Development Team.

 http://indepnet.net/   http://glpi-project.org
 -------------------------------------------------------------------------

 LICENSE

 This file is part of GLPI.

 GLPI is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 2 of the License, or
 (at your option) any later version.

 GLPI is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with GLPI. If not, see <http://www.gnu.org/licenses/>.
 --------------------------------------------------------------------------
 */

/** @file
* @brief
*/

include ('../inc/includes.php');
header("Content-Type: text/html; charset=UTF-8");
Html::header_nocache();

Session::checkLoginUser();

// Make a select box
if (isset($_POST["itemtype"])
    && CommonITILObject::isPossibleToAssignType($_POST["itemtype"])) {
   $table = getTableForItemType($_POST["itemtype"]);
   $rand  = mt_rand();

   // Message for post-only
   if (!isset($_POST["admin"]) || ($_POST["admin"] == 0)) {
      echo "<br>".__('Enter the first letters (user, item name, serial or asset number)');
   }

   echo "<br>";
   $field_id = Html::cleanId("dropdown_".$_POST['myname'].$rand);

   $p = array('itemtype'            => $_POST["itemtype"],
              'entity_restrict'     => $_POST['entity_restrict'],
              'table'               => $table,
              'myname'              => $_POST["myname"]);

   if(isset($_POST["used"]) && !empty($_POST["used"])){
      if(isset($_POST["used"][$_POST["itemtype"]])){
         $p["used"] = $_POST["used"][$_POST["itemtype"]];
      }
   }
   
   echo Html::jsAjaxDropdown($_POST['myname'], $field_id,
                              $CFG_GLPI['root_doc']."/ajax/getDropdownFindNum.php",
                              $p);
   // Auto update summary of active or just solved tickets
   $params = array('items_id' => '__VALUE__',
                   'itemtype' => $_POST['itemtype']);

   Ajax::updateItemOnSelectEvent($field_id,"item_ticket_selection_information",
                                 $CFG_GLPI["root_doc"]."/ajax/ticketiteminformation.php",
                                 $params);

}
?>
