ifndef PERL
	PERL = /usr/bin/perl
endif
REPORT_DIR="$(DESTDIR)/usr/share/ocsinventory-reports"
SERVER_DIR="$(DESTDIR)/usr/share/ocsinventory-server"
SRC_DIR="src/$(SOURCE)-$(VERSION)"
CONF_DIR="etc/ocsinventory"
VARPATH="$(DESTDIR)/var/lib/ocsinventory-reports"
VARPATH_SERVER="$(DESTDIR)/var/lib/ocsinventory-server"
LOG="$(DESTDIR)/var/log/ocsinventory-server"
export PERL_MM_USE_DEFAULT=1

install::
	cd $(SRC_DIR)/Apache && perl Makefile.PL INSTALLDIRS=vendor
	$(MAKE) -C $(SRC_DIR)/Apache
	$(MAKE) -C $(SRC_DIR)/Apache DESTDIR=$(DESTDIR) install PREFIX=/usr
	mkdir -p $(SERVER_DIR)
	mkdir -p $(REPORT_DIR)
	mkdir -p $(DESTDIR)/$(CONF_DIR)
	mkdir -p $(VARPATH)/ipd $(VARPATH)/download $(VARPATH)/snmp $(VARPATH_SERVER) $(LOG)
	cp -r $(SRC_DIR)/binutils $(SERVER_DIR)
	cp -r $(SRC_DIR)/ocsreports/* $(REPORT_DIR)
	#ne pas inclure le fichier de configuration
	rm -f $(REPORT_DIR)/dbconfig.inc.php
	cp -r $(SRC_DIR)/client/ $(REPORT_DIR)
	find $(SERVER_DIR) -name '*.pl' -exec chmod +x {} \;
	find $(REPORT_DIR) -type f -exec chmod a-x {} \;
	# Création d'un répertoire manquant dans le dossier ocsreports initial
	mkdir -p $(REPORT_DIR)/plugins/main_sections/conf/old_conf/
	# MakeMaker creates the dirs, we delete them from the deb:
	[ ! -d $(CURDIR)/debian/esbl-ocs/usr/lib/perl5 ] || rmdir --ignore-fail-on-non-empty --parents $(CURDIR)/debian/esbl-ocs/usr/lib/perl5

