-- table engines
DELIMITER //
CREATE FUNCTION EngineMigration(table_name CHAR ,engine_type CHAR)
  RETURNS INT
  BEGIN
	DECLARE code INT;
	IF SHOW TABLE STATUS LIKE table_name THEN ALTER TABLE table_name engine=engine_type;
	END IF;
	RETURN 0;
  END //

DELIMITER ;

EngineMigration('hardware', 'InnoDB');
EngineMigration('accesslog', 'InnoDB');
EngineMigration('bios', 'InnoDB');
EngineMigration('memories', 'InnoDB');
EngineMigration('slots', 'InnoDB');
EngineMigration('registry', 'InnoDB');
EngineMigration('monitors', 'InnoDB');
EngineMigration('ports', 'InnoDB');
EngineMigration('storages', 'InnoDB');
EngineMigration('drives', 'InnoDB');
EngineMigration('inputs', 'InnoDB');
EngineMigration('modems', 'InnoDB');
EngineMigration('networks', 'InnoDB');
EngineMigration('printers', 'InnoDB');
EngineMigration('sounds', 'InnoDB');
EngineMigration('videos', 'InnoDB');
EngineMigration('softwares', 'InnoDB');
EngineMigration('accountinfo', 'InnoDB');
EngineMigration('netmap', 'InnoDB');
EngineMigration('devices', 'InnoDB');
EngineMigration('locks', 'HEAP');
-- hardware
DELETE FROM accountinfo WHERE hardware_id NOT IN (SELECT DISTINCT(id) FROM hardware);
DELETE FROM bios WHERE hardware_id NOT IN (SELECT DISTINCT(id) FROM hardware);
DELETE FROM controllers WHERE hardware_id NOT IN (SELECT DISTINCT(id) FROM hardware);
DELETE FROM drives WHERE hardware_id NOT IN (SELECT DISTINCT(id) FROM hardware);
DELETE FROM inputs WHERE hardware_id NOT IN (SELECT DISTINCT(id) FROM hardware);
DELETE FROM memories WHERE hardware_id NOT IN (SELECT DISTINCT(id) FROM hardware);
DELETE FROM modems WHERE hardware_id NOT IN (SELECT DISTINCT(id) FROM hardware);
DELETE FROM monitors WHERE hardware_id NOT IN (SELECT DISTINCT(id) FROM hardware);
DELETE FROM networks WHERE hardware_id NOT IN (SELECT DISTINCT(id) FROM hardware);
DELETE FROM ports WHERE hardware_id NOT IN (SELECT DISTINCT(id) FROM hardware);
DELETE FROM printers WHERE hardware_id NOT IN (SELECT DISTINCT(id) FROM hardware);
DELETE FROM registry WHERE hardware_id NOT IN (SELECT DISTINCT(id) FROM hardware);
DELETE FROM slots WHERE hardware_id NOT IN (SELECT DISTINCT(id) FROM hardware);
DELETE FROM softwares WHERE hardware_id NOT IN (SELECT DISTINCT(id) FROM hardware);
DELETE FROM sounds WHERE hardware_id NOT IN (SELECT DISTINCT(id) FROM hardware);
DELETE FROM storages WHERE hardware_id NOT IN (SELECT DISTINCT(id) FROM hardware);
DELETE FROM videos WHERE hardware_id NOT IN (SELECT DISTINCT(id) FROM hardware);
DELETE FROM devices WHERE hardware_id NOT IN (SELECT DISTINCT(id) FROM hardware);
-- netmap
DELETE FROM netmap WHERE netid NOT IN(SELECT DISTINCT(ipsubnet) FROM networks);
