-- table engines
DELIMITER //
DROP PROCEDURE IF EXISTS EngineMigration//
CREATE PROCEDURE EngineMigration(IN table_name VARCHAR(255) ,IN engine_type VARCHAR(255))
BEGIN
    DECLARE cur_engine VARCHAR(255);
    DECLARE stmt VARCHAR(255);
    SELECT Engine INTO cur_engine FROM information_schema.tables WHERE table_schema=DATABASE() and table_name=table_name LIMIT 1;
    SET @SQL = CONCAT('ALTER TABLE ',table_name,' engine=',engine_type);
    IF cur_engine != engine_type
    THEN
	    PREPARE stmt FROM @SQL;
	    EXECUTE stmt;
	    DEALLOCATE PREPARE stmt;
    END IF;

  END//

DELIMITER ;

CALL EngineMigration('hardware', 'InnoDB');
CALL EngineMigration('accesslog', 'InnoDB');
CALL EngineMigration('bios', 'InnoDB');
CALL EngineMigration('memories', 'InnoDB');
CALL EngineMigration('slots', 'InnoDB');
CALL EngineMigration('registry', 'InnoDB');
CALL EngineMigration('monitors', 'InnoDB');
CALL EngineMigration('ports', 'InnoDB');
CALL EngineMigration('storages', 'InnoDB');
CALL EngineMigration('drives', 'InnoDB');
CALL EngineMigration('inputs', 'InnoDB');
CALL EngineMigration('modems', 'InnoDB');
CALL EngineMigration('networks', 'InnoDB');
CALL EngineMigration('printers', 'InnoDB');
CALL EngineMigration('sounds', 'InnoDB');
CALL EngineMigration('videos', 'InnoDB');
CALL EngineMigration('softwares', 'InnoDB');
CALL EngineMigration('accountinfo', 'InnoDB');
CALL EngineMigration('netmap', 'InnoDB');
CALL EngineMigration('devices', 'InnoDB');
CALL EngineMigration('locks', 'HEAP');
-- hardware
DELETE FROM accountinfo WHERE hardware_id NOT IN (SELECT DISTINCT(id) FROM hardware);
DELETE FROM bios WHERE hardware_id NOT IN (SELECT DISTINCT(id) FROM hardware);
DELETE FROM controllers WHERE hardware_id NOT IN (SELECT DISTINCT(id) FROM hardware);
DELETE FROM drives WHERE hardware_id NOT IN (SELECT DISTINCT(id) FROM hardware);
DELETE FROM inputs WHERE hardware_id NOT IN (SELECT DISTINCT(id) FROM hardware);
DELETE FROM memories WHERE hardware_id NOT IN (SELECT DISTINCT(id) FROM hardware);
DELETE FROM modems WHERE hardware_id NOT IN (SELECT DISTINCT(id) FROM hardware);
DELETE FROM monitors WHERE hardware_id NOT IN (SELECT DISTINCT(id) FROM hardware);
DELETE FROM networks WHERE hardware_id NOT IN (SELECT DISTINCT(id) FROM hardware);
DELETE FROM ports WHERE hardware_id NOT IN (SELECT DISTINCT(id) FROM hardware);
DELETE FROM printers WHERE hardware_id NOT IN (SELECT DISTINCT(id) FROM hardware);
DELETE FROM registry WHERE hardware_id NOT IN (SELECT DISTINCT(id) FROM hardware);
DELETE FROM slots WHERE hardware_id NOT IN (SELECT DISTINCT(id) FROM hardware);
DELETE FROM softwares WHERE hardware_id NOT IN (SELECT DISTINCT(id) FROM hardware);
DELETE FROM sounds WHERE hardware_id NOT IN (SELECT DISTINCT(id) FROM hardware);
DELETE FROM storages WHERE hardware_id NOT IN (SELECT DISTINCT(id) FROM hardware);
DELETE FROM videos WHERE hardware_id NOT IN (SELECT DISTINCT(id) FROM hardware);
DELETE FROM devices WHERE hardware_id NOT IN (SELECT DISTINCT(id) FROM hardware);
-- netmap
DELETE FROM netmap WHERE netid NOT IN(SELECT DISTINCT(ipsubnet) FROM networks);
