# ewt-portal

## Règles de style Javascript

Afin de maintenir une cohérence de style dans le code Javascript du projet, des règles ESLint sont fournies dans le dépôt.

### Installer ESLint localement

#### Dépendances

- [NodeJS](https://nodejs.org/en/) (et NPM, normalement installé par défaut avec NodeJS), dernière version stable.

```bash
cd ewt-portal
npm install
```

### Lancer la validation des éléments Polymer EWT

**Attention** Cette commande est configurée pour ne valider que les éléments présents dans `src/elements` et suivant la nomenclature de nommage `{ewt,salt}-*`.

Exemple: `src/elements/ewt-session` ou `src/elements/salt-action`.

```bash
cd ewt-portal
npm run lint -- <chemin vers fichier à valider, html ou js>
```
### Ajouter un hook de `pre-commit` Git

Pour lancer automatiquement la validation des éléments avant un commit (**fortement conseillé**), ajouter le code suivant dans votre script `.git/hooks/pre-commit` (ou créez le si il n'existe pas puis rendez le exécutable).

```bash
#!/usr/bin/env bash

export PATH=$PATH:./node_modules/.bin

commit_files=$(git diff --cached --name-only --diff-filter=ACM)

has_error=0
for file in $commit_files; do

  # Validation du code Javascript via ESLint
  if [[ "$file" =~ .(html|js)$ ]]; then
    eslint "$file"
    exit_code=$?
    [ "$exit_code" != '0' ] && has_error=1;
  fi

done

exit $has_error
```

## Tests unitaires

[Guide d'écriture de tests pour polymer](https://www.polymer-project.org/1.0/docs/tools/tests)

Rédiger les tests unitaires dans `src/test/` (1 répertoire par élément à
tester). Puis, pour lancer l'ensemble des tests unitaires :

    cd src/
    polymer test

La commande est supposée lancer un navigateur (ou plusieurs si besoin)
et effectuer les tests de manière séquentielle.
