# borrowed from http://code.activestate.com/recipes/391367/
import warnings

import pyeole.decorator

def deprecated(func):
    """Decorator to mark a functions as deprecated.

    Use the new deprecated from pyeole.decorator.

    This is a decorator which can be used to mark functions as
    deprecated. It will result in a warning being emmitted when the
    function is used.
    """
    @pyeole.decorator.deprecated(message="use pyeole.decorator.deprecated.")
    def deprecate(*args, **kwargs):
        warnings.warn("Call to deprecated function %s." % func.__name__,
                      category=DeprecationWarning)
        return func(*args, **kwargs)
    deprecate.__name__ = func.__name__
    deprecate.__doc__ = func.__doc__
    deprecate.__dict__.update(func.__dict__)
    return deprecate
