#!/usr/bin/env python
# -*- coding: UTF-8 -*-


import unittest
import os, shutil, glob, time

from zephir.monitor.lanceur import *
from zephir.monitor.website import *

def lancement():

    lance = Lanceur()
    lance.create()
    time.sleep(5)            
    reactor.stop()


class TestAgents(unittest.TestCase):
    def setUp(self):
        """Mise en place d'artéfacts de fichiers de configurations 
        """
        # fichiers de configuration de test
        # agents.cfg
        shutil.copy("../agents.cfg", "../agents.cfg.bak")
        shutil.copy("agents.cfg", "../agents.cfg")
        # config.py
        shutil.copy("../config.py", "../config.py.bak")
        shutil.copy("config_agents.py", "../config.py")

        # purge au cas où
        # purge des fichiers xml
        for f in glob.glob("./xml_agents/*.xml"):
            os.unlink(f)
        # purge des fichiers html
        for f in glob.glob("./htm/*.htm"):
            os.unlink(f)
        # purge du site
        for f in glob.glob("./site/*.htm"):
            os.unlink(f)
            
    def tearDown(self):
        """Restauration des fichiers de configuration usuels
        """
        # restauration des fichiers de configuration
        os.rename("../agents.cfg.bak", "../agents.cfg")
        os.rename("../config.py.bak", "../config.py")

        # purge des fichiers xml
        for f in glob.glob("./xml_agents/*.xml"):
            os.unlink(f)
        # purge des fichiers html
        for f in glob.glob("./htm/*.htm"):
            os.unlink(f)
        # purge du site
        for f in glob.glob("./site/*.htm"):
            os.unlink(f)

    def test_lanceur(self):
        """Lanceur d'agents. Sortie xml et html
        (côté module eole)
        """
        lancement()
        reactor.run()
        if len(glob.glob("./xml_agents/*.xml") ) == 0 :
            raise Exception
        if len(glob.glob("./htm/*.htm") ) == 0 :
            raise Exception

class TestWebsite(unittest.TestCase):
    """Génération du site web
    """
    def setUp(self):
        """Mise en place d'artéfacts de fichiers de configurations 
        """
        # fichiers de configuration de test
        # agents.cfg
        shutil.copy("../agents.cfg", "../agents.cfg.bak")
        shutil.copy("agents.cfg", "../agents.cfg")
        # config.py
        shutil.copy("../config.py", "../config.py.bak")
        shutil.copy("config_agents.py", "../config.py")

        # génération du xml
        lancement()
        reactor.run()
        if len(glob.glob("./xml_agents/*.xml") ) == 0 :
            raise Exception
        if len(glob.glob("./htm/*.htm") ) == 0 :
            raise Exception

        # purge du site
        for f in glob.glob("./site/*.htm"):
            os.unlink(f)
            
    def tearDown(self):
        """Restauration des fichiers de configuration usuels
        """
        # restauration des fichiers de configuration
        os.rename("../agents.cfg.bak", "../agents.cfg")
        os.rename("../config.py.bak", "../config.py")

        # purge des fichiers xml
        for f in glob.glob("./xml_agents/*.xml"):
            os.unlink(f)
        # purge des fichiers html
        for f in glob.glob("./htm/*.htm"):
            os.unlink(f)
        # purge du site
        for f in glob.glob("./site/*.htm"):
            os.unlink(f)
        
    def test_website(self):
        """Génération du site web
        """

        Site()

        if len(glob.glob("./site/*.htm") ) == 0 :
            raise Exception

        
if __name__ == "__main__" :
    unittest.main()
    
