# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
###########################################################################
"""
Agent zephir pour l'étude des logs de scannedonly
"""
import time
import random
import locale
from os.path import isfile
from calendar import month_abbr
from zephir.monitor.agentmanager.agent import Agent
from zephir.monitor.agentmanager.data import HTMLData, TableData
from zephir.monitor.agentmanager import status

# FIXME: code sensible à l'environnement
locale.setlocale(locale.LC_ALL, ('en_US', 'UTF8'))
MONTH_ABBR = list(month_abbr)

class ClamLog(Agent):

    def __init__(self, name, **params):
        Agent.__init__(self, name, **params)
        self.lastcolor = None
        self.status = status.OK()
        # cas où on met direct le résultat :)
        #self.data=[HTMLData(self.result())]
        self.table = TableData([
            ('vir', 'Virus', {'align':'center'}, None),
#            ('com', 'Poste client', {'align':'center'}, None),
            ('nb', 'Occurences', {'align':'center'}, None)])
        title1 = HTMLData("<h3>Derniers virus détectés<h3>")
        self.table2 = TableData([
            #('day', 'Jour', {'align':'center'}, None),
            ('nb', 'Nombre de virus pour aujourd\'hui',
                {'align':'center'}, None)])
        self.data = [title1, self.table, HTMLData('<br>'), self.table2]

    def _color(self, vir):
        """
        astuce pour réaliser un affichage sympa
        """
        color = self.lastcolor
        while color == self.lastcolor :
            color = random.choice(('red', 'green', 'blue', 'deeppink' ))
        self.lastcolor = color
        return "<font color=\"%s\">%s</font>" % (color, vir)

    def measure(self):
        self.status = status.OK()
        fichier = '/var/log/rsyslog/local/scannedonlyd_clamav/scannedonlyd_clamav.warning.log'
        date = time.localtime()
        today = date.tm_mday
        mymonth = date.tm_mon
        if not isfile(fichier):
            lignes = []
        else:
            fp = open(fichier, 'r')
            # lecture limitée à 10Mo
            lignes = fp.readlines(10000000)
            fp.close()
        dico = {}
        totalday = 0
        #lignes.reverse() # si on veut trier par date
        for ligne in lignes:
            if ligne.find("contains virus") != -1:
                data = ligne.split()
                day = data[1]
                month = data[0]
                virus = data[-1][0:-1]
                # FIXME: on ne connait plus la station avec scannedonly
                client = 'unknown'
                # tri par couple (virus, station)
                if (virus, client) in dico :
                    dico[(virus, client)] += 1
                else:
                    dico[(virus, client)] = 1
                if int(day) == today and month == MONTH_ABBR[mymonth]:
                    totalday += 1
        # status (plus de 10 virus aujourd'hui ?)
        warninglevel = 1
        errorlevel = 10
        if totalday >= errorlevel :
            self.status = status.Error()
        elif totalday >= warninglevel :
            self.status = status.Warn()
        self.measure_data['nb'] = str(totalday)

        res2 = { 'nb'  : str(totalday) }

        if dico != {} :
            result = []
            cles = dico.keys()
            for cle in cles :
                result.append({ 'vir' : self._color(cle[0]),
#                                'com' : cle[1],
                                'nb'  : dico[cle]
                              })
            return { 'statistics' : result,
                     'statistics2' : [ res2 ] }
        return { 'statistics' : [ {'vir' : 'Aucun',
#                                   'com' : '----',
                                   'nb'  : '----'  } ],
                 'statistics2' : [ res2 ] }


    def write_data(self):
        Agent.write_data(self)
        if self.last_measure is not None:
            self.table.table_data = self.last_measure.value['statistics']
            self.table2.table_data = self.last_measure.value['statistics2']

    def check_status(self):
        return self.status

