# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2011
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
###########################################################################

"""
Agent zephir pour la page d'authentification d'EoleSSO (service local)
"""

from zephir.monitor.agentmanager.agent import Agent
from zephir.monitor.agentmanager.data import TableData
from zephir.monitor.agentmanager import status
from zephir.monitor.agentmanager.util import status_to_img
from os import system

class SSO(Agent):

    def __init__(self, name, host, cas_folder, sso_port, **params):
        self.sso_port = sso_port
        self.sso_cas_folder = cas_folder
        self.sso_host = host
        Agent.__init__(self, name, **params)
        self.table = TableData([
            ('status', "État", {'align':'center'}, status_to_img),
            ('service', "Service", {'align':'left'}, None),
            ])
        self.data = [self.table]

    def measure(self):
        mesures = []
        # test de récupération des métadata
        meta_url = "https://{host}:{port}{folder}/saml/metadata".format(host=self.sso_host, port=self.sso_port, folder=self.sso_cas_folder)
        stat = "On"
        cmd_test = "/usr/bin/wget -q -t2 --no-check-certificate --timeout=10 --delete-after {}".format(meta_url)
        code = system(cmd_test)
        if code != 0:
            stat = "Off"
        mesures.append({'status':stat, 'service':'Application web EoleSSO'})
        if self.sso_port != 8443:
            meta_url = "https://localhost:8443/saml/metadata"
            stat = "On"
            cmd_test = "/usr/bin/wget -q -t2 --no-check-certificate --timeout=10 --delete-after {}".format(meta_url)
            code = system(cmd_test)
            if code != 0:
                stat = "Off"
            mesures.append({'status':stat, 'service':'Serveur EoleSSO sur 8443'})
        return mesures

    def write_data(self):
        Agent.write_data(self)
        if self.last_measure is not None:
            self.table.table_data = self.last_measure.value

    def check_status(self):
        """remonte une erreur si un des services est tombé"""
        if self.last_measure is not None:
            for service in self.last_measure.value:
                self.measure_data[service['service']] = service['status']
                if service['status'] != 'On':
                    return status.Error()
        else:
            # pas de mesure connue
            return status.Unknown()
        return status.OK()

