# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
###########################################################################

"""
Agent zephir de récolte d'informations pour sentinelle
"""

from zephir.monitor.agentmanager.agent import Agent
from zephir.monitor.agentmanager.data import TableData
from zephir.monitor.agentmanager import status
from os.path import isfile

class Sentinelle(Agent):

    def __init__(self, name, **params):
        Agent.__init__(self, name, **params)
        self.table = TableData([
            ('description', '', {'align':'center'}, None),
            ('valeur', 'valeur actuelle', {'align':'center'}, None)])
        self.data = [self.table]
 
    def measure(self):
        """ Maj-Auto  (activation , date) """
        res = []
        cron_maj = '/usr/share/ead2/backend/tmp/cron.txt'
        if not isfile(cron_maj):
            self.measure_data['maj_auto'] = ''
            res.append({ 'description':'Mise à jour automatique',
                         'valeur':'désactivée' })
        else:
            f_cron = open(cron_maj)
            data = f_cron.read().strip()
            f_cron.close()
            self.measure_data['maj_auto'] = data
            res.append({ 'description':'Mise à jour automatique',
                         'valeur':data })

        return { 'statistics' : res }

    def write_data(self):
        """ enregistrement """
        Agent.write_data(self)
        if self.last_measure is not None:
            self.table.table_data = self.last_measure.value['statistics']
            
    def check_status(self):
        """ envoi du statut (toujours OK) """
        return status.OK()
 
