# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
###########################################################################

"""
Agent zephir pour les services TCP
"""

from zephir.monitor.agentmanager.agent import Agent
from zephir.monitor.agentmanager.data import HTMLData, TableData
from zephir.monitor.agentmanager.util import status_to_img
from zephir.monitor.agentmanager import status


def compare_hostports(hp1, hp2):
    h1, p1 = hp1.split(':')
    h2, p2 = hp2.split(':')
    result = h1 < h2 # alpha comparison on hosts
    if result != 0:
        return result
    else: # numeric comparison on ports
        return int(p1) < int(p2)


class TCPServices(Agent):

    def __init__(self, name,
                 tcp_services, # dict {"host:port": "comment"}
                 **params):
        Agent.__init__(self, name, **params)
        self.tcp_services = tcp_services
        self.table = TableData([
            ('description', "Description", {'align':'left'}, None),
            ('status', "état", {'align':'center'}, status_to_img),
            ('stats', "Historique", {'align':'left'}, None),
            ('host', "Hôte", {'align':'left'}, None),
            ('port', "Port", {'align':'left'}, None),
            ])
        self.data = [self.table]


    def measure(self):
        mesures = []
        try:
            # recherche de l'identifiant zephir
            # (nécessaire pour l'url du graphe de status des 'sous agents')
            from zephir.zephir_conf.zephir_conf import id_serveur
        except:
            # si on est pas enregistré : 0
            id_serveur = 0

        for service in self.tcp_services:
            if service in self.manager.agents:
               serv_agent = self.manager.agents[service]
               if serv_agent.last_measure is not None:
                   status = serv_agent.last_measure.value['services'][0]['status']
                   description = serv_agent.last_measure.value['services'][0]['description']
                   mesures.append({ 'description': description,
                                    'host': serv_agent.last_measure.value['services'][0]['host'],
                                    'port': serv_agent.last_measure.value['services'][0]['port'],
                                    'status': status,
                                    'stats': '<img src=/agents/%s/%s/status.png alt="Historique (%s)"/>' % (id_serveur,service,service)})
                   self.measure_data[service]=[status,description]
               else:
                   mesures.append({ 'description': service,
                                    'host': '',
                                    'port': '',
                                    'status': '',
                                    'stats': ''})
        return {'services': mesures}


    def write_data(self):
        Agent.write_data(self)
        if self.last_measure is not None:
            self.table.table_data = self.last_measure.value['services']


    def check_status(self):
        """remonte une erreur si un des services est tombé"""
        if self.last_measure is not None:
            for service in self.last_measure.value['services']:
                if service['status'] == 'Off':
                    return status.Error()
        else:
            # pas de mesure connue
            return status.Unknown()
        return status.OK()


