#!/usr/bin/env python
# -*- coding: UTF-8 -*-
###################################
#
# script basique pour récupérer des valeurs de configuration sur un groupe de serveurs
#

import xmlrpclib, getpass, sys


def selection_serveurs(zephir_proxy):

    # exemple : utiliser un groupe existant
    rc, liste_groupes = zephir_proxy.serveurs.get_groups()
    print "* groupes disponibles *"
    # affichage id et libelle des groupes
    groupes = {}
    for groupe in liste_groupes:
        print groupe[0], " - ", groupe[1]
        # dictionnaire id_groupe -> libelle, liste des serveurs
        groupes[groupe[0]] = (groupe[1], groupe[2])
    print ""
    id_groupe = raw_input('choix du groupe (rien pour choisir un module) : ')
    if id_groupe != '':
        try:
            id_groupe = int(id_groupe)
            assert id_groupe in groupes.keys()
        except:
            sys.exit('Erreur, groupe inconnu')
        # récupération des serveurs de ce groupe
        rc, groupe_serv = zephir_proxy.serveurs.groupe_reload(groupes[id_groupe][1])
        print "\nServeurs du groupe %s : " % groupes[id_groupe][0]
        return groupe_serv

    # récupération par type de module si pas de groupe demandé
    # si besoin, on peut récupérer la liste des variantes avec zephir_proxy.modules.get_variantes()
    rc, liste_modules = zephir_proxy.modules.get_module()
    print "* modules disponibles *"
    # affichage id et libelle des groupes
    modules = {}
    for module in liste_modules:
        print module['id'], " - ", module['libelle']
        # dictionnaire id_module -> libelle
        modules[module['id']] = module['libelle']
    print ""
    id_module = raw_input('choix du module : ')
    try:
        id_module = int(id_module)
        assert id_module in modules.keys()
    except:
        sys.exit('Erreur, module invalide')
    # critères de séléction des serveurs (d'autres critères sont possibles : rne, variante, libelle ...)
    criteres_selection = {'module_actuel':id_module}
    # récupération du groupe de serveurs correspondants
    rc, groupe_serv = zephir_proxy.serveurs.groupe_serveur(criteres_selection)
    print "\nServeurs de type %s : " % modules[id_module]
    return groupe_serv

def update_conf(zephir_proxy, groupe_serveur):
    """Modifie la configuration de chaque serveur du groupe
    """
    nb_serv = len(groupe_serv)
    print "Mise à jour des configurations"
    for idx, serveur in enumerate(groupe_serv):
        # récupération de la configuration du serveur
        sys.stdout.write('* (%d/%d) Mise à jour du serveur %s (etablissement %s) ...' % (idx+1, nb_serv, serveur['id'], serveur['rne']))
        try:
            rc, config = zephir_proxy.serveurs.get_dico(serveur['id'], 'modif_config')
            # les valeurs de la configuration sont dans le dernier élément de la liste
            # (la liste contient les dictionnaires en base64 et le dictionnaire de valeur sous forme de chaine)
            values = eval(config[-1])
            # suprression des valeurs pour proxy_bypass_domain_eth1
            if "proxy_bypass_domain_eth1" in values:
                del(values["proxy_bypass_domain_eth1"])
            # renvoi de la configuration sur Zéphir
            rc, msg = zephir_proxy.serveurs.save_conf(serveur['id'], [str(values)], 'modif_config')
            if rc == 1:
                print "  OK"
            else:
                print "Erreur remontée par Zéphir : ", str(msg)
        except xmlrpclib.ProtocolError:
            print "Erreur : droits insuffisants"
        except Exception as err:
            print "Erreur : ", str(err)
    print "\n\n Traitement terminé\n"


if __name__ == '__main__':
    # lancé seulement si lancement en ligne de commande (pas en cas d'import dans un programme python)
    user = raw_input("nom de l'utilisateur zephir :")
    pwd = getpass.getpass("mot de passe                :")
    # si appel à distance : utiliser https et remplacer 127.0.0.1:7081 par <adresse_zephir>:7080
    zephir_proxy = xmlrpclib.ServerProxy('http://%s:%s@127.0.0.1:7081' % (user, pwd))

    groupe_serv = selection_serveurs(zephir_proxy)
    update_conf(zephir_proxy, groupe_serv)
