#!/usr/bin/env python3
# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# del_user.py
#
# Utilitaire de suppression d'utilisateurs LDAP pour zephir
#
###########################################################################

import sys, os
from zephir.utils.ldap_user import del_user

if __name__ == '__main__':
    # affichage de la liste des utilisateurs
    cmd = "echo && /usr/share/zephir/utils/list_users.py | column"
    os.system(cmd)

    # on demande le login du compte à supprimer
    login = input("\n nom de connexion de l'utilisateur à supprimer : ")
    if login != "":

        # confirmation
        confirm = input("\n supprimer l'utilisateur '%s' ? (o/N) " % login).lower()
        if confirm != "o":
            sys.exit("\n annulation de la suppression\n")

        # suppession de l'utilisateur
        if del_user(login) == 1:
            sys.exit("\n utilisateur supprimé\n")
        else:
            sys.exit(1)
    else:
        sys.exit("\n aucun utilisateur supprimé\n")
