#!/usr/bin/env python
# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
###########################################################################
import getpass, sys, codecs
try:
    # si disponible, on utilise la librairie modifiée du client Zéphir
    # (n'affiche pas les mots de passe dans l'url en cas de traceback)
    from zephir.eolerpclib import xmlrpclib
except:
    import xmlrpclib

HELP = """

usage: zephir_get_timeouts.py [options]

Ce script permet de récupérer la liste des serveurs
en timeout (perte de contact) sur un ensemble de serveurs Zéphir.

Le résultat est stocké dans un fichier de type CSV nommé
zephir_timeout_<adresse_zephir>.csv contenant les informations suivantes:

    id_serveur|nom_fichier_associé|libellé_serveur|libellé_etablissement
"""

# délimiteur pour le fichier 'CSV'
delimiter = u";"

def get_timeouts (zephir_infos):

    for adresse_zephir in zephir_infos.keys():

        user, pwd = zephir_infos[adresse_zephir]
        # définition du proxy XMLRPC ver le serveur Zéphir
        if adresse_zephir == 'localhost':
            zephir_proxy = xmlrpclib.ServerProxy('http://%s:%s@localhost:7081' % (user, pwd))
        else:
            zephir_proxy = xmlrpclib.ServerProxy('https://%s:%s@%s:7080' % (user, pwd, adresse_zephir))

        # récupération du groupe de serveurs correspondants
        print "\nRécupération des serveurs en alerte pour le serveur Zéphir %s ..." % adresse_zephir
        ret_code, serveurs_alerte = zephir_proxy.serveurs.get_alertes()

        # création d'un fichier de type csv : id_serveur|nom_de_fichier|libelle_etab|libelle_serveur
        csv_data = []
        for serveur in serveurs_alerte:
            # serveurs_alerte est une liste contenant les informations suivantes pour
            # chaque serveur en alerte :
            #   id_etab, libelle_etab, libelle_serveur, module_serveur, id_serveur, status_serveur
            rne, libel_etab, libel_serveur, module, id_serveur, status = serveur
            if status == 2:
                # une valeur 2 pour status_serveur indique une perte de contact avec le serveur
                #
                # stockage sous forme id_serveur|module|libelle|n°etab
                #
                csv_data.append(delimiter.join([str(id_serveur), module, libel_serveur, rne]))
        try:
            # écriture du fichier résultat
            csv_name = 'zephir_timeout_%s.csv' % adresse_zephir
            f = codecs.open(csv_name, 'w', encoding='utf-8')
            f.write(u"\n".join(csv_data))
            f.close()
            print "Fichier sauvegardé (%s)\n" % csv_name
        except:
            import traceback
            traceback.print_exc()
            print "! Erreur à l'écriture du fichier %s !\n" % csv_name


if __name__ == '__main__':

    # affichage aide
    if '-h' in sys.argv or '--help' in sys.argv:
        print HELP
        sys.exit(0)

    # informations sur les serveurs à contacter et les comptes à utiliser pour la lecture

    zephir_infos = {}
    # FIXME : à remplacer par les valeurs réelles. exemple :
    # zephir_infos = {'adresse_zephir1':('utilisateur','mot_de_passe'),
    #                'adresse_zephir2':('utilisateur','mot_de_passe'),
    #               }

    if zephir_infos == {}:
        # saisie manuelle des infos zéphir/utilisateur pour débug du script
        adresse_zephir = raw_input("Entrez l'adresse du serveur Zéphir :")
        # proxy xmlrpc
        user = raw_input("nom de l'utilisateur zephir :")
        pwd = getpass.getpass("mot de passe                :")
        zephir_infos[adresse_zephir] = (user, pwd)

    get_timeouts(zephir_infos)
