/*
 * Decompiled with CFR 0.152.
 */
package com.dosse.upnp;

import java.net.HttpURLConnection;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeIterator;

class Gateway {
    private Inet4Address iface;
    private InetAddress routerip;
    private String serviceType = null;
    private String controlURL = null;

    public Gateway(byte[] data, Inet4Address ip, InetAddress gatewayip) throws Exception {
        this.iface = ip;
        this.routerip = gatewayip;
        String location = null;
        StringTokenizer st = new StringTokenizer(new String(data), "\n");
        while (st.hasMoreTokens()) {
            String val;
            String s = st.nextToken().trim();
            if (s.isEmpty() || s.startsWith("HTTP/1.") || s.startsWith("NOTIFY *")) continue;
            String name = s.substring(0, s.indexOf(58));
            String string = val = s.length() >= name.length() ? s.substring(name.length() + 1).trim() : null;
            if (!name.equalsIgnoreCase("location")) continue;
            location = val;
        }
        if (location == null) {
            throw new Exception("Unsupported Gateway");
        }
        Document d = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(location);
        NodeList services = d.getElementsByTagName("service");
        for (int i = 0; i < services.getLength(); ++i) {
            Node service = services.item(i);
            NodeList n = service.getChildNodes();
            String serviceType = null;
            String controlURL = null;
            for (int j = 0; j < n.getLength(); ++j) {
                Node x = n.item(j);
                if (x.getNodeName().trim().equalsIgnoreCase("serviceType")) {
                    serviceType = x.getFirstChild().getNodeValue();
                    continue;
                }
                if (!x.getNodeName().trim().equalsIgnoreCase("controlURL")) continue;
                controlURL = x.getFirstChild().getNodeValue();
            }
            if (serviceType == null || controlURL == null || !serviceType.trim().toLowerCase().contains(":wanipconnection:") && !serviceType.trim().toLowerCase().contains(":wanpppconnection:")) continue;
            this.serviceType = serviceType.trim();
            this.controlURL = controlURL.trim();
        }
        if (this.controlURL == null) {
            throw new Exception("Unsupported Gateway");
        }
        int slash = location.indexOf("/", 7);
        if (slash == -1) {
            throw new Exception("Unsupported Gateway");
        }
        location = location.substring(0, slash);
        if (!this.controlURL.startsWith("/")) {
            this.controlURL = "/" + this.controlURL;
        }
        this.controlURL = location + this.controlURL;
    }

    private Map<String, String> command(String action, Map<String, String> params) throws Exception {
        Node n;
        HashMap<String, String> ret = new HashMap<String, String>();
        String soap = "<?xml version=\"1.0\"?>\r\n<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\"><SOAP-ENV:Body><m:" + action + " xmlns:m=\"" + this.serviceType + "\">";
        if (params != null) {
            for (Map.Entry<String, String> entry : params.entrySet()) {
                soap = soap + "<" + entry.getKey() + ">" + entry.getValue() + "</" + entry.getKey() + ">";
            }
        }
        soap = soap + "</m:" + action + "></SOAP-ENV:Body></SOAP-ENV:Envelope>";
        byte[] req = soap.getBytes();
        HttpURLConnection conn = (HttpURLConnection)new URL(this.controlURL).openConnection();
        conn.setRequestMethod("POST");
        conn.setDoOutput(true);
        conn.setRequestProperty("Content-Type", "text/xml");
        conn.setRequestProperty("SOAPAction", "\"" + this.serviceType + "#" + action + "\"");
        conn.setRequestProperty("Connection", "Close");
        conn.setRequestProperty("Content-Length", "" + req.length);
        conn.getOutputStream().write(req);
        Document d = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(conn.getInputStream());
        NodeIterator iter = ((DocumentTraversal)((Object)d)).createNodeIterator(d.getDocumentElement(), 1, null, true);
        while ((n = iter.nextNode()) != null) {
            try {
                if (n.getFirstChild().getNodeType() != 3) continue;
                ret.put(n.getNodeName(), n.getTextContent());
            }
            catch (Throwable throwable) {}
        }
        conn.disconnect();
        return ret;
    }

    public String getGatewayIP() {
        return this.routerip.getHostAddress();
    }

    public String getLocalIP() {
        return this.iface.getHostAddress();
    }

    public String getExternalIP() {
        try {
            Map<String, String> r = this.command("GetExternalIPAddress", null);
            return r.get("NewExternalIPAddress");
        }
        catch (Throwable t) {
            return null;
        }
    }

    public boolean openPort(int port, boolean udp, String appName) {
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("Invalid port");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("NewRemoteHost", "");
        params.put("NewProtocol", udp ? "UDP" : "TCP");
        params.put("NewInternalClient", this.iface.getHostAddress());
        params.put("NewExternalPort", "" + port);
        params.put("NewInternalPort", "" + port);
        params.put("NewEnabled", "1");
        params.put("NewPortMappingDescription", appName);
        params.put("NewLeaseDuration", "0");
        try {
            Map<String, String> r = this.command("AddPortMapping", params);
            return r.get("errorCode") == null;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean closePort(int port, boolean udp) {
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("Invalid port");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("NewRemoteHost", "");
        params.put("NewProtocol", udp ? "UDP" : "TCP");
        params.put("NewExternalPort", "" + port);
        try {
            this.command("DeletePortMapping", params);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean isMapped(int port, boolean udp) {
        if (port < 0 || port > 65535) {
            throw new IllegalArgumentException("Invalid port");
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("NewRemoteHost", "");
        params.put("NewProtocol", udp ? "UDP" : "TCP");
        params.put("NewExternalPort", "" + port);
        try {
            Map<String, String> r = this.command("GetSpecificPortMappingEntry", params);
            if (r.get("errorCode") != null) {
                throw new Exception();
            }
            return r.get("NewInternalPort") != null;
        }
        catch (Exception ex) {
            return false;
        }
    }
}

