/*
 * Decompiled with CFR 0.152.
 */
package genj.gedcom;

import ancestris.gedcom.privacy.PrivacyPolicy;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.Property;
import genj.gedcom.PropertyChange;
import genj.gedcom.PropertyComparator2;
import genj.gedcom.PropertyEventDetails;
import genj.gedcom.PropertyXRef;
import java.math.BigInteger;
import java.util.List;
import org.openide.util.Exceptions;

public class Entity
extends Property {
    private Gedcom gedcom;
    private String id;
    private String value;
    private final String tag;

    protected Entity(String tag, String id) {
        super(tag);
        this.id = id;
        this.tag = tag;
    }

    void addNotify(Gedcom ged) {
        this.gedcom = ged;
        ged.propagateEntityAdded(this);
    }

    @Override
    void beforeDelNotify() {
        this.delProperties();
        this.gedcom.propagateEntityDeleted(this);
        this.gedcom = null;
    }

    public PropertyChange getLastChange() {
        Property change = this.getProperty("CHAN");
        return change instanceof PropertyChange ? (PropertyChange)change : null;
    }

    @Override
    public Gedcom getGedcom() {
        return this.gedcom;
    }

    @Override
    public Entity getEntity() {
        return this;
    }

    public boolean isConnected() {
        for (PropertyXRef xref : this.getProperties(PropertyXRef.class)) {
            if (!xref.isValid()) continue;
            return true;
        }
        return false;
    }

    public void setId(String set) throws GedcomException {
        String old = this.id;
        this.id = set;
        if (this.gedcom != null) {
            try {
                this.gedcom.propagateEntityIDChanged(this, old);
            }
            catch (Throwable t) {
                this.id = old;
            }
        }
    }

    public String getId() {
        return this.id;
    }

    public void setNew() {
    }

    public void setOld() {
    }

    @Override
    public String getDisplayTitle() {
        return this.toString();
    }

    public String getDisplayTitle(boolean showid) {
        return this.toString(showid);
    }

    @Override
    public final String toString() {
        return this.toString(true);
    }

    public final String toString(boolean showIds) {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getToStringPrefix(showIds));
        if (buf.length() == 0) {
            buf.append(this.getPropertyName());
        }
        if (showIds && !"HEAD".equals(this.tag)) {
            buf.append(" (");
            buf.append(this.getId());
            buf.append(')');
        }
        return buf.toString();
    }

    protected String getToStringPrefix(boolean showIds) {
        return this.getPropertyName();
    }

    @Override
    public String getValue() {
        return this.value != null ? this.value : "";
    }

    @Override
    public void setValue(String set) {
        this.value = set;
    }

    @Override
    public boolean isValid() {
        return Gedcom.getEntityType(this.tag) != null || "HEAD".equals(this.tag);
    }

    public void moveEntityValue() {
        this.moveEntityValue("NOTE");
    }

    public void moveEntityValue(String tag) {
        if (!this.value.isEmpty()) {
            try {
                this.addProperty(tag, this.value, 0);
                this.setValue("");
            }
            catch (GedcomException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    public boolean isHeader() {
        return this.tag.equals("HEAD");
    }

    private BigInteger getID() throws NumberFormatException {
        int end;
        int start;
        for (start = 0; start < this.id.length() && !Character.isDigit(this.id.charAt(start)); ++start) {
        }
        for (end = start; end < this.id.length() && Character.isDigit(this.id.charAt(end)); ++end) {
        }
        if (end < start) {
            return BigInteger.ZERO;
        }
        return new BigInteger(this.id.substring(start, end));
    }

    public String format(String propertyTag, String format) {
        Property p = this.getProperty(propertyTag);
        return p != null ? p.format(format) : "";
    }

    public String formatReport(String propertyTag, String format) {
        Property p = this.getProperty(propertyTag);
        return p != null ? p.format(format, PrivacyPolicy.getDefault().getAllPublic(), true) : "";
    }

    public List<PropertyEventDetails> getEvents() {
        return null;
    }

    @Override
    void propagateXRefLinked(PropertyXRef property1, PropertyXRef property2) {
        if (this.gedcom != null) {
            this.gedcom.propagateXRefLinked(property1, property2);
        }
    }

    @Override
    void propagateXRefUnlinked(PropertyXRef property1, PropertyXRef property2) {
        if (this.gedcom != null) {
            this.gedcom.propagateXRefUnlinked(property1, property2);
        }
    }

    @Override
    void propagatePropertyAdded(Property container, int pos, Property added) {
        if (this.gedcom != null) {
            this.gedcom.propagatePropertyAdded(this, container, pos, added);
        }
    }

    @Override
    void propagatePropertyDeleted(Property container, int pos, Property deleted) {
        if (this.gedcom != null) {
            this.gedcom.propagatePropertyDeleted(this, container, pos, deleted);
        }
    }

    @Override
    void propagatePropertyChanged(Property property, String oldValue) {
        if (this.gedcom != null) {
            this.gedcom.propagatePropertyChanged(this, property, oldValue);
        }
    }

    @Override
    void propagatePropertyMoved(Property property, Property moved, int from, int to) {
        if (this.gedcom != null) {
            this.gedcom.propagatePropertyMoved(property, moved, from, to);
        }
    }

    @Override
    public void eraseAll() {
        super.eraseAll();
        this.gedcom = null;
        this.id = null;
        this.value = null;
    }

    @Override
    public PropertyComparator2<Entity> getComparator() {
        return ENTITYComparator.getInstance();
    }

    @Override
    public PropertyComparator2<Entity> getDisplayComparator() {
        return ENTITYComparator.getInstance();
    }

    private static class ENTITYComparator
    extends PropertyComparator2.Default<Entity> {
        private static final ENTITYComparator INSTANCE = new ENTITYComparator();

        private ENTITYComparator() {
        }

        public static PropertyComparator2 getInstance() {
            return INSTANCE;
        }

        @Override
        public int compare(Entity i1, Entity i2) {
            int r = this.compareNull(i1, i2);
            if (r == Integer.MAX_VALUE) {
                try {
                    BigInteger big1 = i1.getID();
                    BigInteger big2 = i2.getID();
                    return big1.compareTo(big2);
                }
                catch (NumberFormatException e) {
                    r = i1.id.compareToIgnoreCase(i2.id);
                }
            }
            return r;
        }

        @Override
        public String getSortGroup(Entity p) {
            return "";
        }
    }
}

