/*
 * Decompiled with CFR 0.152.
 */
package genj.io;

import genj.gedcom.GedcomConstants;
import genj.io.AnselCharset;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;

public class GedcomEncodingSniffer
extends BufferedInputStream {
    private static final Logger LOG = Logger.getLogger("ancestris.io");
    static final byte[] BOM_UTF8 = new byte[]{-17, -69, -65};
    static final byte[] BOM_UTF16BE = new byte[]{-2, -1};
    static final byte[] BOM_UTF16LE = new byte[]{-1, -2};
    private boolean deterministic = true;
    private GedcomConstants.Encodings encoding;
    private Charset charset;

    public GedcomEncodingSniffer(InputStream in) throws IOException {
        super(in, 4096);
        super.mark(4096);
        super.read();
        super.reset();
        if (this.matchPrefix(BOM_UTF8)) {
            LOG.info("Found BOM_UTF8 - trying encoding UTF-8");
            this.charset = Charset.forName("UTF-8");
            this.encoding = GedcomConstants.Encodings.UTF8;
            return;
        }
        if (this.matchPrefix(BOM_UTF16BE)) {
            LOG.info("Found BOM_UTF16BE - trying encoding UTF-16BE");
            this.charset = Charset.forName("UTF-16BE");
            this.encoding = GedcomConstants.Encodings.UNICODE;
            return;
        }
        if (this.matchPrefix(BOM_UTF16LE)) {
            LOG.info("Found BOM_UTF16LE - trying encoding UTF-16LE");
            this.charset = Charset.forName("UTF-16LE");
            this.encoding = GedcomConstants.Encodings.UNICODE;
            return;
        }
        if (this.matchCHAR(GedcomConstants.Encodings.UTF8.toString()) || this.matchCHAR("UTF8")) {
            LOG.info("Found " + GedcomConstants.Encodings.UTF8.toString() + " - trying encoding UTF-8");
            this.charset = Charset.forName(GedcomConstants.Encodings.UTF8.toString());
            this.encoding = GedcomConstants.Encodings.UTF8;
            return;
        }
        if (this.matchCHAR(GedcomConstants.Encodings.UNICODE.toString())) {
            LOG.info("Found single byte " + GedcomConstants.Encodings.UNICODE.toString() + " - trying encoding UTF-8");
            this.charset = Charset.forName("UTF-8");
            this.encoding = GedcomConstants.Encodings.UNICODE;
            return;
        }
        if (this.matchCHAR(GedcomConstants.Encodings.UNICODE.toString(), "UTF-16BE")) {
            LOG.info("Found " + GedcomConstants.Encodings.UNICODE.toString() + "/big endian - trying encoding UTF-16BE");
            this.charset = Charset.forName("UTF-16BE");
            this.encoding = GedcomConstants.Encodings.UNICODE;
            return;
        }
        if (this.matchCHAR(GedcomConstants.Encodings.UNICODE.toString(), "UTF-16LE")) {
            LOG.info("Found " + GedcomConstants.Encodings.UNICODE.toString() + "/little endian - trying encoding UTF-16LE");
            this.charset = Charset.forName("UTF-16LE");
            this.encoding = GedcomConstants.Encodings.UNICODE;
            return;
        }
        if (this.matchCHAR(GedcomConstants.Encodings.ASCII.toString())) {
            LOG.info("Found " + GedcomConstants.Encodings.ASCII.toString() + " - trying encoding ISO-8859-1");
            this.charset = Charset.forName("ISO-8859-1");
            this.encoding = GedcomConstants.Encodings.ASCII;
            return;
        }
        if (this.matchCHAR(GedcomConstants.Encodings.ANSEL.toString())) {
            LOG.info("Found " + GedcomConstants.Encodings.ANSEL.toString() + " - trying encoding ANSEL");
            this.charset = new AnselCharset();
            this.encoding = GedcomConstants.Encodings.ANSEL;
            return;
        }
        if (this.matchCHAR(GedcomConstants.Encodings.ANSI.toString())) {
            LOG.info("Found " + GedcomConstants.Encodings.ANSI.toString() + " - trying encoding Windows-1252");
            this.charset = Charset.forName("Windows-1252");
            this.encoding = GedcomConstants.Encodings.ANSI;
            return;
        }
        if (this.matchCHAR(GedcomConstants.Encodings.LATIN1.toString()) || this.matchCHAR("IBMPC")) {
            LOG.info("Found " + GedcomConstants.Encodings.LATIN1.toString() + " or IBMPC - trying encoding ISO-8859-1");
            this.charset = Charset.forName("ISO-8859-1");
            this.encoding = GedcomConstants.Encodings.LATIN1;
            return;
        }
        this.deterministic = false;
        LOG.info("Could not sniff encoding - trying UTF-8");
        this.charset = Charset.forName("UTF-8");
        this.encoding = GedcomConstants.Encodings.UNICODE;
    }

    public boolean isDeterministic() {
        return this.deterministic;
    }

    private boolean matchCHAR(String line) {
        return this.matchCHAR(line, null);
    }

    private boolean matchCHAR(String value, String charset) {
        try {
            String header = charset != null ? new String(this.buf, this.pos, this.count, charset) : new String(this.buf, this.pos, this.count);
            return header.indexOf("1 CHAR " + value) >= 0;
        }
        catch (UnsupportedEncodingException e) {
            LOG.log(Level.WARNING, "Couldn't parse header in charset " + charset, e);
            return false;
        }
    }

    private boolean matchPrefix(byte[] prefix) throws IOException {
        if (this.count < prefix.length) {
            return false;
        }
        for (int i = 0; i < prefix.length; ++i) {
            if (this.buf[this.pos + i] == prefix[i]) continue;
            return false;
        }
        super.skip(prefix.length);
        return true;
    }

    public Charset getCharset() {
        return this.charset;
    }

    public GedcomConstants.Encodings getEncoding() {
        return this.encoding;
    }
}

