/*
 * Decompiled with CFR 0.152.
 */
package genj.renderer.views;

import ancestris.util.Utilities;
import genj.gedcom.Entity;
import genj.gedcom.MultiLineProperty;
import genj.gedcom.Property;
import genj.gedcom.PropertyPlace;
import genj.gedcom.TagPath;
import genj.renderer.BlueprintRenderer;
import genj.renderer.views.MyView;
import genj.util.Dimension2d;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Dimension2D;
import java.io.File;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Element;

public class MarkView
extends MyView {
    private static final Logger LOG = Logger.getLogger("ancestris.renderer");
    private static final Stroke DEBUG_STROKE = new BasicStroke(1.0f, 2, 0, 10.0f, new float[]{1.0f, 2.0f}, 0.0f);
    private static final String POS_SEPA = "?";
    private static final String MARKER = "\u2588";
    private final Map<String, String> attributes = new HashMap<String, String>();
    private String path = null;
    private String elsePath = null;
    private String repetition = null;
    private String value = null;
    private Integer pos;
    private Boolean empty = false;
    private Property cachedProperty = null;
    private Dimension2D cachedSize = null;
    private String cachedDisplayValue = null;

    public MarkView(Element elem, BlueprintRenderer rdr) {
        super(elem, rdr);
        Enumeration<?> as = elem.getAttributes().getAttributeNames();
        while (as.hasMoreElements()) {
            Object key = as.nextElement();
            if (!(key instanceof String)) continue;
            this.attributes.put((String)key, (String)elem.getAttributes().getAttribute(key));
        }
        this.path = this.attributes.get("path");
        this.repetition = this.attributes.get("repeat");
        this.value = this.attributes.get("test");
        this.empty = Boolean.valueOf(this.attributes.get("notpresent"));
        this.elsePath = this.attributes.get("default");
    }

    @Override
    protected Dimension2D getPreferredSpan() {
        if (this.cachedSize != null) {
            return this.cachedSize;
        }
        this.cachedSize = this.getSize();
        return this.cachedSize;
    }

    private Property getProperty() {
        Property prop = this.getProperty(this.path);
        if (prop == null) {
            prop = this.getProperty(this.elsePath);
        }
        return prop;
    }

    private Property getProperty(String thePath) {
        String pathAfter;
        TagPath pathBefore;
        Property entity;
        block11: {
            if (this.cachedProperty != null) {
                return this.cachedProperty;
            }
            entity = this.getRenderer().getEntity();
            if (entity == null || thePath == null || thePath.isEmpty()) {
                return null;
            }
            pathBefore = null;
            pathAfter = null;
            if (thePath.contains(POS_SEPA)) {
                int sepa = thePath.indexOf(POS_SEPA);
                pathBefore = this.createPath(thePath.substring(0, sepa));
                int next = thePath.indexOf(58, sepa);
                try {
                    if (next != -1) {
                        this.pos = Integer.valueOf(thePath.substring(sepa + 1, next));
                        pathAfter = thePath.substring(next + 1);
                    } else {
                        this.pos = Integer.valueOf(thePath.substring(sepa + 1));
                    }
                }
                catch (NumberFormatException e) {
                    if (!LOG.isLoggable(Level.FINER)) break block11;
                    LOG.log(Level.FINER, "Unable to retrieve pos {0}", thePath);
                }
            }
        }
        if (this.pos != null) {
            Integer thePos;
            Property[] props = entity.getProperties(pathBefore);
            if (props.length <= (thePos = Integer.valueOf(this.pos - 1 >= 0 ? this.pos - 1 : 0))) {
                return null;
            }
            this.cachedProperty = props[thePos];
            if (pathAfter != null) {
                this.cachedProperty = this.cachedProperty.getProperty(this.createPath(this.cachedProperty.getTag() + TagPath.SEPARATOR_STRING + pathAfter));
            }
        } else {
            this.cachedProperty = entity.getProperty(this.createPath(thePath));
        }
        return this.cachedProperty;
    }

    private TagPath createPath(String thePath) {
        try {
            return new TagPath(thePath);
        }
        catch (IllegalArgumentException e) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.log(Level.FINER, "got wrong path " + thePath, e);
            }
            return null;
        }
    }

    @Override
    public void paint(Graphics g, Shape allocation) {
        Property prop = this.getProperty();
        if (prop == null) {
            if (!this.empty.booleanValue()) {
                return;
            }
            try {
                Property propParent = this.getProperty(this.createPath(this.path).getParent().toString());
                if (propParent == null && this.elsePath != null) {
                    propParent = this.getProperty(this.createPath(this.elsePath).getParent().toString());
                }
                if (propParent == null) {
                    return;
                }
            }
            catch (NullPointerException e) {
                return;
            }
        }
        if (this.cachedDisplayValue == null) {
            if (prop != null && !this.empty.booleanValue()) {
                this.createDisplayValue(prop);
            } else if (prop == null && this.empty.booleanValue()) {
                this.createDisplayValue("*");
            } else {
                return;
            }
        }
        Graphics2D graphics = (Graphics2D)g;
        Rectangle r = allocation instanceof Rectangle ? (Rectangle)allocation : allocation.getBounds();
        Color fg = this.getForeground();
        if (this.getRenderer().isIsDebug()) {
            Stroke stroke = graphics.getStroke();
            graphics.setStroke(DEBUG_STROKE);
            g.setColor(new Color(fg.getRed(), fg.getGreen(), fg.getBlue(), 32));
            graphics.draw(r);
            graphics.setStroke(stroke);
        }
        Shape old = graphics.getClip();
        graphics.clip(r);
        g.setColor(fg);
        g.setFont(super.getFont());
        this.render(this.cachedDisplayValue, graphics, r);
        g.setClip(old);
    }

    @Override
    public String getHTMLValue(int width, int height, File imageDir) {
        Property prop = this.getProperty();
        if (prop == null) {
            if (!this.empty.booleanValue()) {
                return "";
            }
            try {
                Property propParent = this.getProperty(this.createPath(this.path).getParent().toString());
                if (propParent == null && this.elsePath != null) {
                    propParent = this.getProperty(this.createPath(this.elsePath).getParent().toString());
                }
                if (propParent == null) {
                    return "";
                }
            }
            catch (NullPointerException e) {
                return "";
            }
        }
        if (this.cachedDisplayValue == null) {
            if (prop != null && !this.empty.booleanValue()) {
                this.createDisplayValue(prop);
            } else if (prop == null && this.empty.booleanValue()) {
                this.createDisplayValue("*");
            } else {
                return "";
            }
        }
        return this.cachedDisplayValue;
    }

    private void createDisplayValue(Property prop) {
        String text = this.getText(prop);
        this.createDisplayValue(text);
    }

    private void createDisplayValue(String text) {
        StringBuilder display = new StringBuilder("");
        int nb = 1;
        if (this.repetition != null) {
            try {
                nb = Integer.parseInt(this.repetition);
            }
            catch (NumberFormatException e) {
                nb = 1;
            }
        }
        if (text != null) {
            for (int i = 0; i < nb; ++i) {
                display.append(MARKER);
            }
            if (this.value != null && !text.equals(this.value)) {
                display = new StringBuilder("");
            }
        }
        this.cachedDisplayValue = display.toString();
    }

    private String getText(Property prop) {
        if (prop instanceof Entity) {
            return this.getText((Entity)prop);
        }
        if (prop instanceof PropertyPlace) {
            return this.getText((PropertyPlace)prop);
        }
        if (prop instanceof MultiLineProperty) {
            return prop.getValue();
        }
        if (this.attributes.get("format") != null) {
            return prop.format(this.attributes.get("format"));
        }
        return prop.getDisplayValue();
    }

    private String getText(Entity entity) {
        if (this.attributes.get("format") != null) {
            return entity.format(this.attributes.get("format"));
        }
        return entity.getId();
    }

    private String getText(PropertyPlace place) {
        return Utilities.html2text(place.format(this.attributes.get("format")));
    }

    private Dimension2D getSize() {
        Property prop = this.getProperty();
        if (prop == null && !this.empty.booleanValue()) {
            return new Dimension();
        }
        if (this.cachedDisplayValue == null) {
            if (prop != null && !this.empty.booleanValue()) {
                this.createDisplayValue(prop);
            } else if (prop == null && this.empty.booleanValue()) {
                this.createDisplayValue("*");
            } else {
                return new Dimension();
            }
        }
        return this.getSize(this.cachedDisplayValue);
    }

    private Dimension2D getSize(String txt) {
        double w = 0.0;
        double h = 0.0;
        this.getRenderer().getGraphics().setFont(super.getFont());
        FontMetrics fm = this.getRenderer().getGraphics().getFontMetrics();
        if (txt.length() > 0) {
            w += (double)fm.stringWidth(txt);
            h = Math.max(h, (double)(fm.getAscent() + fm.getDescent()));
        }
        return new Dimension2d(w, h);
    }

    @Override
    public void invalidate() {
        this.cachedProperty = null;
        this.cachedSize = null;
        this.cachedDisplayValue = null;
        super.invalidate();
    }
}

