/*
 * Decompiled with CFR 0.152.
 */
package ancestris.modules.editors.media;

import ancestris.modules.editors.media.BackgroundTask;
import ancestris.modules.editors.media.ButtonColumn;
import ancestris.modules.editors.media.DownloadTaskFactory;
import ancestris.modules.editors.media.FileStats;
import ancestris.modules.editors.media.FilesAnalysisTaskFactory;
import ancestris.modules.editors.media.MediaPathTableModel;
import ancestris.modules.editors.media.PathData;
import ancestris.modules.editors.media.SearchLocalFilePanel;
import ancestris.modules.editors.media.SearchRemoteFilePanel;
import ancestris.modules.viewers.media.MediaChooser;
import ancestris.util.ProgressListener;
import ancestris.util.swing.DialogManager;
import ancestris.util.swing.FileChooserBuilder;
import genj.gedcom.Gedcom;
import genj.gedcom.GedcomException;
import genj.gedcom.GedcomOptions;
import genj.gedcom.PropertyFile;
import genj.util.EnvironmentChecker;
import genj.util.Origin;
import genj.util.Registry;
import genj.util.Trackable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import spin.Spin;

public class MediaManagerActionPanel
extends JPanel {
    protected static String FSLASH = "/";
    private ImageIcon warningIcon = new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/media/ico_Warning.png"));
    private ImageIcon errorIcon = new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/media/ico_Error.png"));
    private Gedcom gedcom;
    private int initialUndoNb;
    private Registry registry = null;
    private Set<String> filesFullnames = null;
    private MediaPathTableModel mediaPathTableModel = null;
    private Set<PathData> pathDataList = null;
    private String relativePathValue = "";
    private boolean mediaTestRemoteExistence = false;
    private boolean mediaTestRemoteExistenceDone = false;
    private FileStats fileStats;
    private JCheckBox absoluteFilterCheckBox;
    private JLabel absolutePathFilesLabel;
    private JLabel absolutePathFilesNumberLabel;
    private JButton changeRelativeButton;
    private JButton clearButton;
    private JLabel distinctCommentLabel;
    private JLabel distinctLabel;
    private JLabel distinctNumberLabel;
    private JButton downloadButton;
    private JPanel editorPanel;
    private JLabel entityFilesLabel;
    private JLabel entityFilesNumberLabel;
    private JLabel filtersLabel;
    private JLabel localFilesCommentLabel;
    private JLabel localFilesLabel;
    private JLabel localFilesNumberLabel;
    private JCheckBox localFilterCheckBox;
    private JButton makeAllRelativeButton;
    private JSpinner nbTimeoutSpinner;
    private JPanel overviewPanel;
    private JLabel propertyFilesCommentLabel;
    private JLabel propertyFilesLabel;
    private JLabel propertyFilesNumberLabel;
    private JButton refreshButton;
    private JCheckBox relativeFilterCheckBox;
    private JLabel relativePathFilesLabel;
    private JLabel relativePathFilesNumberLabel;
    private JLabel relativePathLabel;
    private JLabel relativePathValueLabel;
    private JLabel remoteFilesCommentLabel;
    private JLabel remoteFilesLabel;
    private JLabel remoteFilesNumberLabel;
    private JCheckBox remoteFilterCheckBox;
    private JButton selectAllButtonButton;
    private JCheckBox selectedFilterCheckBox;
    private JButton showAllFilesButton;
    private JLabel subpathLabel;
    private JTextField subpathTextField;
    private JTable table;
    private JScrollPane tableScrollPane;
    private JButton testRemoteExistence;
    private JLabel totalLabel;
    private JLabel totalNumberLabel;
    private JButton undoButton;
    private JCheckBox unfoundFilterCheckBox;

    public MediaManagerActionPanel(Gedcom gedcom) {
        this.gedcom = gedcom;
        this.relativePathValue = gedcom.getOrigin().getFile().getParentFile().getAbsolutePath();
        this.registry = Registry.get(this.getClass());
        this.initialUndoNb = gedcom.getUndoNb();
        this.filesFullnames = new TreeSet<String>();
        this.pathDataList = new TreeSet<PathData>();
        this.fileStats = new FileStats();
        this.initComponents();
        this.nbTimeoutSpinner.setValue(GedcomOptions.getInstance().getURLTimeout());
        this.buildStatsAndTable();
        this.mediaPathTableModel = new MediaPathTableModel(this, this.pathDataList, this.relativePathValue);
        this.table.setModel(this.mediaPathTableModel);
        this.displayStatsAndTable();
    }

    private void clearAll() {
        this.filesFullnames.clear();
        this.pathDataList.clear();
        this.fileStats.reset();
    }

    private void buildStatsAndTable() {
        this.clearAll();
        BackgroundTask task = (BackgroundTask)Spin.off((Object)FilesAnalysisTaskFactory.create(this.gedcom, this.filesFullnames, this.pathDataList, this.fileStats, this.mediaTestRemoteExistence, this.mediaTestRemoteExistenceDone));
        ProgressListener.Dispatcher.processStarted((Trackable)task);
        task.run();
        ProgressListener.Dispatcher.processStopped((Trackable)task);
    }

    private void displayStatsAndTable() {
        this.showAllFilesButton.setText(NbBundle.getMessage(MediaManagerActionPanel.class, (String)"MediaManagerActionPanel.showAllFilesButton.text", (Object)this.fileStats.totalNumber));
        this.totalNumberLabel.setText("" + this.fileStats.totalNumber);
        this.distinctNumberLabel.setText("" + this.fileStats.distinctNumber);
        this.localFilesNumberLabel.setText("" + this.fileStats.localFilesNumber);
        this.relativePathFilesNumberLabel.setText("" + this.fileStats.relativePathFilesNumber);
        this.absolutePathFilesNumberLabel.setText("" + this.fileStats.absolutePathFilesNumber);
        this.remoteFilesNumberLabel.setText("" + this.fileStats.remoteFilesNumber);
        this.entityFilesNumberLabel.setText("" + this.fileStats.entityFilesNumber);
        this.propertyFilesNumberLabel.setText("" + this.fileStats.propertyFilesNumber);
        this.relativePathValueLabel.setText(this.relativePathValue);
        if (this.fileStats.totalNumber > 0) {
            if (this.fileStats.totalNumber == this.fileStats.distinctNumber) {
                this.distinctCommentLabel.setText(NbBundle.getMessage(MediaManagerActionPanel.class, (String)"MediaManagerActionPanel.distinctCommentLabel.text.OK"));
                this.distinctCommentLabel.setIcon(null);
            } else {
                this.distinctCommentLabel.setText(NbBundle.getMessage(MediaManagerActionPanel.class, (String)"MediaManagerActionPanel.distinctCommentLabel.text"));
                this.distinctCommentLabel.setIcon(this.warningIcon);
            }
        } else {
            this.distinctCommentLabel.setText("");
            this.distinctCommentLabel.setIcon(null);
        }
        if (this.fileStats.localFilesNumber > 0) {
            if (this.fileStats.localFilesUnfoundNumber == 0) {
                this.localFilesCommentLabel.setText(NbBundle.getMessage(MediaManagerActionPanel.class, (String)"MediaManagerActionPanel.localFilesCommentLabel.text.OK"));
                this.localFilesCommentLabel.setIcon(null);
            } else {
                this.localFilesCommentLabel.setText(NbBundle.getMessage(MediaManagerActionPanel.class, (String)"MediaManagerActionPanel.localFilesCommentLabel.text", (Object)this.fileStats.localFilesUnfoundNumber));
                this.localFilesCommentLabel.setIcon(this.errorIcon);
            }
        } else {
            this.localFilesCommentLabel.setText("");
            this.localFilesCommentLabel.setIcon(null);
        }
        if (this.fileStats.remoteFilesNumber > 0) {
            if (this.fileStats.remoteFilesUnfoundNumber == 0) {
                if (this.mediaTestRemoteExistenceDone) {
                    this.remoteFilesCommentLabel.setText(NbBundle.getMessage(MediaManagerActionPanel.class, (String)"MediaManagerActionPanel.remoteFilesCommentLabel.text.OK"));
                    this.remoteFilesCommentLabel.setIcon(null);
                } else {
                    this.remoteFilesCommentLabel.setText(NbBundle.getMessage(MediaManagerActionPanel.class, (String)"MediaManagerActionPanel.remoteFilesCommentLabel.text.NotYetTested"));
                    this.remoteFilesCommentLabel.setIcon(this.warningIcon);
                }
            } else {
                this.remoteFilesCommentLabel.setText(NbBundle.getMessage(MediaManagerActionPanel.class, (String)"MediaManagerActionPanel.remoteFilesCommentLabel.text", (Object)this.fileStats.remoteFilesUnfoundNumber));
                this.remoteFilesCommentLabel.setIcon(this.errorIcon);
            }
        } else {
            this.remoteFilesCommentLabel.setText("");
            this.remoteFilesCommentLabel.setIcon(null);
        }
        if (this.fileStats.totalNumber > 0) {
            if (this.fileStats.propertyFilesNumber == 0) {
                this.propertyFilesCommentLabel.setText(NbBundle.getMessage(MediaManagerActionPanel.class, (String)"MediaManagerActionPanel.propertyFilesCommentLabel.text.OK"));
                this.propertyFilesCommentLabel.setIcon(null);
            } else {
                this.propertyFilesCommentLabel.setText(NbBundle.getMessage(MediaManagerActionPanel.class, (String)"MediaManagerActionPanel.propertyFilesCommentLabel.text"));
                this.propertyFilesCommentLabel.setIcon(this.warningIcon);
            }
        } else {
            this.propertyFilesCommentLabel.setText("");
            this.propertyFilesCommentLabel.setIcon(null);
        }
        TableCellRenderer renderer = this.table.getTableHeader().getDefaultRenderer();
        JLabel headerLabel = (JLabel)((Object)renderer);
        headerLabel.setHorizontalAlignment(0);
        AbstractAction action = new AbstractAction(""){

            @Override
            public void actionPerformed(ActionEvent e) {
                JTable localtable = (JTable)e.getSource();
                AbstractTableModel model = (AbstractTableModel)localtable.getModel();
                int row = Integer.valueOf(e.getActionCommand());
                PathData pdRow = MediaManagerActionPanel.this.getPathDataFromRow(row);
                String path = (String)model.getValueAt(row, MediaPathTableModel.NEW_PATH_COLUMN);
                if (pdRow != null) {
                    if (pdRow.local) {
                        Boolean rel = (Boolean)model.getValueAt(row, MediaPathTableModel.REL_COLUMN);
                        MediaManagerActionPanel.this.searchLocalPath(pdRow, path, rel);
                    } else {
                        MediaManagerActionPanel.this.searchRemotePath(pdRow, path);
                    }
                }
            }
        };
        ButtonColumn bc = new ButtonColumn(this.table, action, MediaPathTableModel.ACTION_COLUMN);
        this.table.getColumnModel().getColumn(MediaPathTableModel.FOUND_COLUMN).setCellRenderer(new RadioCellRenderer());
        this.table.getColumnModel().getColumn(MediaPathTableModel.LOCAL_COLUMN).setCellRenderer(new RadioCellRenderer());
        this.table.getColumnModel().getColumn(MediaPathTableModel.ENTITY_COLUMN).setCellRenderer(new RadioCellRenderer());
        this.table.getColumnModel().getColumn(MediaPathTableModel.NBMEDIAS_COLUMN).setCellRenderer(new IntCellRenderer());
        this.table.getColumnModel().getColumn(MediaPathTableModel.REL_COLUMN).setCellRenderer(new CheckBoxCellRenderer());
        this.table.getColumnModel().getColumn(MediaPathTableModel.SELECTION_COLUMN).setCellRenderer(new CheckBoxCellRenderer());
        this.table.getColumnModel().getColumn(MediaPathTableModel.NEW_PATH_COLUMN).setCellRenderer(new TextCellRenderer());
        this.resizeColumns();
        this.resizeLines();
        this.updateButtons();
    }

    private void refreshTable() {
        this.mediaPathTableModel.resetData();
        this.displayStatsAndTable();
        this.mediaPathTableModel.updateHeaders();
    }

    protected void updateHeader(int col, String value) {
        this.table.getColumnModel().getColumn(col).setHeaderValue(value);
        this.table.getTableHeader().repaint();
    }

    private void resizeColumns() {
        Dimension size = this.table.getSize();
        int small = 70;
        int width = Math.max(size.width - small * (MediaPathTableModel.NBCOLUMNS - 1), 200);
        this.table.getColumnModel().getColumn(MediaPathTableModel.NBMEDIAS_COLUMN).setPreferredWidth(small);
        this.table.getColumnModel().getColumn(MediaPathTableModel.FOUND_COLUMN).setPreferredWidth(small);
        this.table.getColumnModel().getColumn(MediaPathTableModel.NEW_PATH_COLUMN).setPreferredWidth(width);
        this.table.getColumnModel().getColumn(MediaPathTableModel.LOCAL_COLUMN).setPreferredWidth(small);
        this.table.getColumnModel().getColumn(MediaPathTableModel.ENTITY_COLUMN).setPreferredWidth(small);
        this.table.getColumnModel().getColumn(MediaPathTableModel.REL_COLUMN).setPreferredWidth(small);
        this.table.getColumnModel().getColumn(MediaPathTableModel.ACTION_COLUMN).setPreferredWidth(small);
        this.table.getColumnModel().getColumn(MediaPathTableModel.SELECTION_COLUMN).setPreferredWidth(small);
    }

    private void resizeLines() {
        int rowHeight = new JButton().getPreferredSize().height * 2;
        this.table.setRowHeight(rowHeight);
        Dimension preferredSize = this.table.getPreferredSize();
        preferredSize.height = rowHeight * this.mediaPathTableModel.getRowCount() + 1;
        this.table.setPreferredSize(preferredSize);
        this.table.revalidate();
        this.table.repaint();
    }

    protected void updateButtons() {
        boolean set = this.mediaPathTableModel.totalSelection > 0;
        this.downloadButton.setEnabled(set);
        this.changeRelativeButton.setEnabled(set);
        if (!set) {
            this.subpathTextField.setText("");
        }
        this.undoButton.setEnabled(this.gedcom.getUndoNb() > this.initialUndoNb);
        this.testRemoteExistence.setEnabled(this.fileStats.remoteFilesNumber > 0);
    }

    private void initComponents() {
        this.overviewPanel = new JPanel();
        this.totalLabel = new JLabel();
        this.totalNumberLabel = new JLabel();
        this.distinctLabel = new JLabel();
        this.distinctNumberLabel = new JLabel();
        this.distinctCommentLabel = new JLabel();
        this.localFilesLabel = new JLabel();
        this.localFilesNumberLabel = new JLabel();
        this.localFilesCommentLabel = new JLabel();
        this.relativePathFilesLabel = new JLabel();
        this.relativePathFilesNumberLabel = new JLabel();
        this.absolutePathFilesLabel = new JLabel();
        this.absolutePathFilesNumberLabel = new JLabel();
        this.remoteFilesLabel = new JLabel();
        this.testRemoteExistence = new JButton();
        this.nbTimeoutSpinner = new JSpinner();
        this.remoteFilesNumberLabel = new JLabel();
        this.remoteFilesCommentLabel = new JLabel();
        this.entityFilesLabel = new JLabel();
        this.entityFilesNumberLabel = new JLabel();
        this.propertyFilesLabel = new JLabel();
        this.propertyFilesNumberLabel = new JLabel();
        this.propertyFilesCommentLabel = new JLabel();
        this.relativePathLabel = new JLabel();
        this.relativePathValueLabel = new JLabel();
        this.refreshButton = new JButton();
        this.showAllFilesButton = new JButton();
        this.editorPanel = new JPanel();
        this.tableScrollPane = new JScrollPane();
        this.table = new JTable();
        this.filtersLabel = new JLabel();
        this.unfoundFilterCheckBox = new JCheckBox();
        this.localFilterCheckBox = new JCheckBox();
        this.remoteFilterCheckBox = new JCheckBox();
        this.relativeFilterCheckBox = new JCheckBox();
        this.absoluteFilterCheckBox = new JCheckBox();
        this.selectedFilterCheckBox = new JCheckBox();
        this.clearButton = new JButton();
        this.selectAllButtonButton = new JButton();
        this.undoButton = new JButton();
        this.subpathLabel = new JLabel();
        this.subpathTextField = new JTextField();
        this.changeRelativeButton = new JButton();
        this.makeAllRelativeButton = new JButton();
        this.downloadButton = new JButton();
        this.overviewPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), NbBundle.getMessage(MediaManagerActionPanel.class, (String)"MediaManagerActionPanel.overviewPanel.border.title")));
        this.totalLabel.setFont(this.totalLabel.getFont());
        this.totalLabel.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/media/ico_File.png")));
        Mnemonics.setLocalizedText((JLabel)this.totalLabel, (String)NbBundle.getMessage(MediaManagerActionPanel.class, (String)"MediaManagerActionPanel.totalLabel.text"));
        this.totalNumberLabel.setFont(this.totalNumberLabel.getFont().deriveFont(this.totalNumberLabel.getFont().getStyle() | 1));
        this.totalNumberLabel.setHorizontalAlignment(4);
        Mnemonics.setLocalizedText((JLabel)this.totalNumberLabel, (String)NbBundle.getMessage(MediaManagerActionPanel.class, (String)"MediaManagerActionPanel.totalNumberLabel.text"));
        this.distinctLabel.setFont(this.distinctLabel.getFont());
        Mnemonics.setLocalizedText((JLabel)this.distinctLabel, (String)NbBundle.getMessage(MediaManagerActionPanel.class, (String)"MediaManagerActionPanel.distinctLabel.text"));
        this.distinctNumberLabel.setFont(this.distinctNumberLabel.getFont());
        this.distinctNumberLabel.setHorizontalAlignment(4);
        Mnemonics.setLocalizedText((JLabel)this.distinctNumberLabel, (String)NbBundle.getMessage(MediaManagerActionPanel.class, (String)"MediaManagerActionPanel.distinctNumberLabel.text"));
        this.distinctCommentLabel.setFont(this.distinctCommentLabel.getFont());
        Mnemonics.setLocalizedText((JLabel)this.distinctCommentLabel, (String)NbBundle.getMessage(MediaManagerActionPanel.class, (String)"MediaManagerActionPanel.distinctCommentLabel.text"));
        this.localFilesLabel.setFont(this.localFilesLabel.getFont());
        this.localFilesLabel.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/media/ico_Local.png")));
        Mnemonics.setLocalizedText((JLabel)this.localFilesLabel, (String)NbBundle.getMessage(MediaManagerActionPanel.class, (String)"MediaManagerActionPanel.localFilesLabel.text"));
        this.localFilesNumberLabel.setFont(this.localFilesNumberLabel.getFont().deriveFont(this.localFilesNumberLabel.getFont().getStyle() | 1));
        this.localFilesNumberLabel.setHorizontalAlignment(4);
        Mnemonics.setLocalizedText((JLabel)this.localFilesNumberLabel, (String)NbBundle.getMessage(MediaManagerActionPanel.class, (String)"MediaManagerActionPanel.localFilesNumberLabel.text"));
        this.localFilesCommentLabel.setFont(this.localFilesCommentLabel.getFont());
        Mnemonics.setLocalizedText((JLabel)this.localFilesCommentLabel, (String)NbBundle.getMessage(MediaManagerActionPanel.class, (String)"MediaManagerActionPanel.localFilesCommentLabel.text"));
        this.relativePathFilesLabel.setFont(this.relativePathFilesLabel.getFont());
        Mnemonics.setLocalizedText((JLabel)this.relativePathFilesLabel, (String)NbBundle.getMessage(MediaManagerActionPanel.class, (String)"MediaManagerActionPanel.relativePathFilesLabel.text"));
        this.relativePathFilesNumberLabel.setFont(this.relativePathFilesNumberLabel.getFont());
        this.relativePathFilesNumberLabel.setHorizontalAlignment(4);
        Mnemonics.setLocalizedText((JLabel)this.relativePathFilesNumberLabel, (String)NbBundle.getMessage(MediaManagerActionPanel.class, (String)"MediaManagerActionPanel.relativePathFilesNumberLabel.text"));
        this.absolutePathFilesLabel.setFont(this.absolutePathFilesLabel.getFont());
        Mnemonics.setLocalizedText((JLabel)this.absolutePathFilesLabel, (String)NbBundle.getMessage(MediaManagerActionPanel.class, (String)"MediaManagerActionPanel.absolutePathFilesLabel.text"));
        this.absolutePathFilesNumberLabel.setFont(this.absolutePathFilesNumberLabel.getFont());
        this.absolutePathFilesNumberLabel.setHorizontalAlignment(4);
        Mnemonics.setLocalizedText((JLabel)this.absolutePathFilesNumberLabel, (String)NbBundle.getMessage(MediaManagerActionPanel.class, (String)"MediaManagerActionPanel.absolutePathFilesNumberLabel.text"));
        this.remoteFilesLabel.setFont(this.remoteFilesLabel.getFont());
        this.remoteFilesLabel.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/media/ico_Remote.png")));
        Mnemonics.setLocalizedText((JLabel)this.remoteFilesLabel, (String)NbBundle.getMessage(MediaManagerActionPanel.class, (String)"MediaManagerActionPanel.remoteFilesLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.testRemoteExistence, (String)NbBundle.getMessage(MediaManagerActionPanel.class, (String)"MediaManagerActionPanel.testRemoteExistence.text"));
        this.testRemoteExistence.setToolTipText(NbBundle.getMessage(MediaManagerActionPanel.class, (String)"MediaManagerActionPanel.testRemoteExistence.toolTipText"));
        this.testRemoteExistence.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MediaManagerActionPanel.this.testRemoteExistenceActionPerformed(evt);
            }
        });
        this.nbTimeoutSpinner.setModel(new SpinnerNumberModel(2, 1, 60, 1));
        this.nbTimeoutSpinner.setToolTipText(NbBundle.getMessage(MediaManagerActionPanel.class, (String)"MediaManagerActionPanel.nbTimeoutSpinner.toolTipText"));
        this.nbTimeoutSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                MediaManagerActionPanel.this.nbTimeoutSpinnerStateChanged(evt);
            }
        });
        this.nbTimeoutSpinner.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                MediaManagerActionPanel.this.nbTimeoutSpinnerPropertyChange(evt);
            }
        });
        this.remoteFilesNumberLabel.setFont(this.remoteFilesNumberLabel.getFont().deriveFont(this.remoteFilesNumberLabel.getFont().getStyle() | 1));
        this.remoteFilesNumberLabel.setHorizontalAlignment(4);
        Mnemonics.setLocalizedText((JLabel)this.remoteFilesNumberLabel, (String)NbBundle.getMessage(MediaManagerActionPanel.class, (String)"MediaManagerActionPanel.remoteFilesNumberLabel.text"));
        this.remoteFilesCommentLabel.setFont(this.remoteFilesCommentLabel.getFont());
        Mnemonics.setLocalizedText((JLabel)this.remoteFilesCommentLabel, (String)NbBundle.getMessage(MediaManagerActionPanel.class, (String)"MediaManagerActionPanel.remoteFilesCommentLabel.text"));
        this.entityFilesLabel.setFont(this.entityFilesLabel.getFont());
        Mnemonics.setLocalizedText((JLabel)this.entityFilesLabel, (String)NbBundle.getMessage(MediaManagerActionPanel.class, (String)"MediaManagerActionPanel.entityFilesLabel.text"));
        this.entityFilesNumberLabel.setFont(this.entityFilesNumberLabel.getFont());
        this.entityFilesNumberLabel.setHorizontalAlignment(4);
        Mnemonics.setLocalizedText((JLabel)this.entityFilesNumberLabel, (String)NbBundle.getMessage(MediaManagerActionPanel.class, (String)"MediaManagerActionPanel.entityFilesNumberLabel.text"));
        this.propertyFilesLabel.setFont(this.propertyFilesLabel.getFont());
        Mnemonics.setLocalizedText((JLabel)this.propertyFilesLabel, (String)NbBundle.getMessage(MediaManagerActionPanel.class, (String)"MediaManagerActionPanel.propertyFilesLabel.text"));
        this.propertyFilesNumberLabel.setFont(this.propertyFilesNumberLabel.getFont());
        this.propertyFilesNumberLabel.setHorizontalAlignment(4);
        Mnemonics.setLocalizedText((JLabel)this.propertyFilesNumberLabel, (String)NbBundle.getMessage(MediaManagerActionPanel.class, (String)"MediaManagerActionPanel.propertyFilesNumberLabel.text"));
        this.propertyFilesCommentLabel.setFont(this.propertyFilesCommentLabel.getFont());
        Mnemonics.setLocalizedText((JLabel)this.propertyFilesCommentLabel, (String)NbBundle.getMessage(MediaManagerActionPanel.class, (String)"MediaManagerActionPanel.propertyFilesCommentLabel.text"));
        this.relativePathLabel.setFont(this.relativePathLabel.getFont());
        this.relativePathLabel.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/media/ico_Root.png")));
        Mnemonics.setLocalizedText((JLabel)this.relativePathLabel, (String)NbBundle.getMessage(MediaManagerActionPanel.class, (String)"MediaManagerActionPanel.relativePathLabel.text"));
        this.relativePathValueLabel.setFont(this.relativePathValueLabel.getFont().deriveFont(this.relativePathValueLabel.getFont().getStyle() | 1));
        Mnemonics.setLocalizedText((JLabel)this.relativePathValueLabel, (String)NbBundle.getMessage(MediaManagerActionPanel.class, (String)"MediaManagerActionPanel.relativePathValueLabel.text"));
        this.refreshButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/media/ico_Refresh.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.refreshButton, (String)NbBundle.getMessage(MediaManagerActionPanel.class, (String)"MediaManagerActionPanel.refreshButton.text"));
        this.refreshButton.setToolTipText(NbBundle.getMessage(MediaManagerActionPanel.class, (String)"MediaManagerActionPanel.refreshButton.toolTipText"));
        this.refreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MediaManagerActionPanel.this.refreshButtonActionPerformed(evt);
            }
        });
        this.showAllFilesButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/media/ico_ShowFiles.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.showAllFilesButton, (String)NbBundle.getMessage(MediaManagerActionPanel.class, (String)"MediaManagerActionPanel.showAllFilesButton.text"));
        this.showAllFilesButton.setToolTipText(NbBundle.getMessage(MediaManagerActionPanel.class, (String)"MediaManagerActionPanel.showAllFilesButton.toolTipText"));
        this.showAllFilesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MediaManagerActionPanel.this.showAllFilesButtonActionPerformed(evt);
            }
        });
        GroupLayout overviewPanelLayout = new GroupLayout(this.overviewPanel);
        this.overviewPanel.setLayout(overviewPanelLayout);
        overviewPanelLayout.setHorizontalGroup(overviewPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(overviewPanelLayout.createSequentialGroup().addGroup(overviewPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(overviewPanelLayout.createSequentialGroup().addGroup(overviewPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(overviewPanelLayout.createSequentialGroup().addContainerGap().addGroup(overviewPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.totalLabel).addGroup(overviewPanelLayout.createSequentialGroup().addGap(16, 16, 16).addGroup(overviewPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.localFilesLabel).addComponent(this.distinctLabel).addComponent(this.entityFilesLabel).addComponent(this.propertyFilesLabel).addGroup(overviewPanelLayout.createSequentialGroup().addComponent(this.remoteFilesLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.testRemoteExistence).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.nbTimeoutSpinner, -2, 49, -2)))).addGroup(overviewPanelLayout.createSequentialGroup().addGap(33, 33, 33).addGroup(overviewPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.absolutePathFilesLabel).addComponent(this.relativePathFilesLabel)))).addGap(9, 9, 9).addGroup(overviewPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.totalNumberLabel, GroupLayout.Alignment.TRAILING).addComponent(this.distinctNumberLabel, GroupLayout.Alignment.TRAILING).addComponent(this.localFilesNumberLabel, GroupLayout.Alignment.TRAILING).addComponent(this.relativePathFilesNumberLabel, GroupLayout.Alignment.TRAILING).addComponent(this.absolutePathFilesNumberLabel, GroupLayout.Alignment.TRAILING).addComponent(this.remoteFilesNumberLabel, GroupLayout.Alignment.TRAILING).addComponent(this.entityFilesNumberLabel, GroupLayout.Alignment.TRAILING).addComponent(this.propertyFilesNumberLabel, GroupLayout.Alignment.TRAILING)).addGap(18, 18, 18).addGroup(overviewPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.remoteFilesCommentLabel).addComponent(this.propertyFilesCommentLabel).addComponent(this.localFilesCommentLabel).addComponent(this.distinctCommentLabel))).addGroup(overviewPanelLayout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.relativePathLabel)).addGroup(overviewPanelLayout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.relativePathValueLabel))).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, overviewPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.refreshButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.showAllFilesButton))).addContainerGap()));
        overviewPanelLayout.setVerticalGroup(overviewPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(overviewPanelLayout.createSequentialGroup().addGroup(overviewPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.totalLabel).addComponent(this.totalNumberLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(overviewPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.distinctLabel).addComponent(this.distinctNumberLabel).addComponent(this.distinctCommentLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(overviewPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.localFilesLabel).addComponent(this.localFilesNumberLabel).addComponent(this.localFilesCommentLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(overviewPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.relativePathFilesLabel).addComponent(this.relativePathFilesNumberLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(overviewPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.absolutePathFilesLabel).addComponent(this.absolutePathFilesNumberLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(overviewPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.remoteFilesLabel).addComponent(this.remoteFilesNumberLabel).addComponent(this.remoteFilesCommentLabel).addComponent(this.testRemoteExistence, -2, 20, -2).addComponent(this.nbTimeoutSpinner, -2, 20, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(overviewPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.entityFilesLabel).addComponent(this.entityFilesNumberLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(overviewPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.propertyFilesLabel).addComponent(this.propertyFilesNumberLabel).addComponent(this.propertyFilesCommentLabel)).addGap(18, 18, 18).addComponent(this.relativePathLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.relativePathValueLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(overviewPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.refreshButton, -1, -1, Short.MAX_VALUE).addComponent(this.showAllFilesButton, -1, -1, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)));
        this.editorPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), NbBundle.getMessage(MediaManagerActionPanel.class, (String)"MediaManagerActionPanel.editorPanel.border.title")));
        this.table.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.table.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent evt) {
                MediaManagerActionPanel.this.tableComponentResized(evt);
            }
        });
        this.tableScrollPane.setViewportView(this.table);
        Mnemonics.setLocalizedText((JLabel)this.filtersLabel, (String)NbBundle.getMessage(MediaManagerActionPanel.class, (String)"MediaManagerActionPanel.filtersLabel.text_1"));
        Mnemonics.setLocalizedText((AbstractButton)this.unfoundFilterCheckBox, (String)NbBundle.getMessage(MediaManagerActionPanel.class, (String)"MediaManagerActionPanel.unfoundFilterCheckBox.text"));
        this.unfoundFilterCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MediaManagerActionPanel.this.unfoundFilterCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.localFilterCheckBox, (String)NbBundle.getMessage(MediaManagerActionPanel.class, (String)"MediaManagerActionPanel.localFilterCheckBox.text"));
        this.localFilterCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MediaManagerActionPanel.this.localFilterCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.remoteFilterCheckBox, (String)NbBundle.getMessage(MediaManagerActionPanel.class, (String)"MediaManagerActionPanel.remoteFilterCheckBox.text"));
        this.remoteFilterCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MediaManagerActionPanel.this.remoteFilterCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.relativeFilterCheckBox, (String)NbBundle.getMessage(MediaManagerActionPanel.class, (String)"MediaManagerActionPanel.relativeFilterCheckBox.text"));
        this.relativeFilterCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MediaManagerActionPanel.this.relativeFilterCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.absoluteFilterCheckBox, (String)NbBundle.getMessage(MediaManagerActionPanel.class, (String)"MediaManagerActionPanel.absoluteFilterCheckBox.text"));
        this.absoluteFilterCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MediaManagerActionPanel.this.absoluteFilterCheckBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.selectedFilterCheckBox, (String)NbBundle.getMessage(MediaManagerActionPanel.class, (String)"MediaManagerActionPanel.selectedFilterCheckBox.text"));
        this.selectedFilterCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MediaManagerActionPanel.this.selectedFilterCheckBoxActionPerformed(evt);
            }
        });
        this.clearButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/media/ico_Clear.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.clearButton, (String)NbBundle.getMessage(MediaManagerActionPanel.class, (String)"MediaManagerActionPanel.clearButton.text"));
        this.clearButton.setToolTipText(NbBundle.getMessage(MediaManagerActionPanel.class, (String)"MediaManagerActionPanel.clearButton.toolTipText"));
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MediaManagerActionPanel.this.clearButtonActionPerformed(evt);
            }
        });
        this.selectAllButtonButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/media/ico_Unselect.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.selectAllButtonButton, (String)NbBundle.getMessage(MediaManagerActionPanel.class, (String)"MediaManagerActionPanel.selectAllButtonButton.text"));
        this.selectAllButtonButton.setToolTipText(NbBundle.getMessage(MediaManagerActionPanel.class, (String)"MediaManagerActionPanel.selectAllButtonButton.toolTipText"));
        this.selectAllButtonButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MediaManagerActionPanel.this.selectAllButtonButtonActionPerformed(evt);
            }
        });
        this.undoButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/media/ico_undo.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.undoButton, (String)NbBundle.getMessage(MediaManagerActionPanel.class, (String)"MediaManagerActionPanel.undoButton.text"));
        this.undoButton.setToolTipText(NbBundle.getMessage(MediaManagerActionPanel.class, (String)"MediaManagerActionPanel.undoButton.toolTipText"));
        this.undoButton.setEnabled(false);
        this.undoButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MediaManagerActionPanel.this.undoButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.subpathLabel, (String)NbBundle.getMessage(MediaManagerActionPanel.class, (String)"MediaManagerActionPanel.subpathLabel.text"));
        this.subpathTextField.setText(NbBundle.getMessage(MediaManagerActionPanel.class, (String)"MediaManagerActionPanel.subpathTextField.text"));
        this.changeRelativeButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/media/ico_ChangeLink.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.changeRelativeButton, (String)NbBundle.getMessage(MediaManagerActionPanel.class, (String)"MediaManagerActionPanel.changeRelativeButton.text"));
        this.changeRelativeButton.setToolTipText(NbBundle.getMessage(MediaManagerActionPanel.class, (String)"MediaManagerActionPanel.changeRelativeButton.toolTipText"));
        this.changeRelativeButton.setEnabled(false);
        this.changeRelativeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MediaManagerActionPanel.this.changeRelativeButtonActionPerformed(evt);
            }
        });
        this.makeAllRelativeButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/media/ico_MakeAbsolute.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.makeAllRelativeButton, (String)NbBundle.getMessage(MediaManagerActionPanel.class, (String)"MediaManagerActionPanel.makeAllRelativeButton.text"));
        this.makeAllRelativeButton.setToolTipText(NbBundle.getMessage(MediaManagerActionPanel.class, (String)"MediaManagerActionPanel.makeAllRelativeButton.toolTipText"));
        this.makeAllRelativeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MediaManagerActionPanel.this.makeAllRelativeButtonActionPerformed(evt);
            }
        });
        this.downloadButton.setIcon(new ImageIcon(this.getClass().getResource("/ancestris/modules/editors/media/ico_Download.png")));
        Mnemonics.setLocalizedText((AbstractButton)this.downloadButton, (String)NbBundle.getMessage(MediaManagerActionPanel.class, (String)"MediaManagerActionPanel.downloadButton.text"));
        this.downloadButton.setToolTipText(NbBundle.getMessage(MediaManagerActionPanel.class, (String)"MediaManagerActionPanel.downloadButton.toolTipText"));
        this.downloadButton.setEnabled(false);
        this.downloadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                MediaManagerActionPanel.this.downloadButtonActionPerformed(evt);
            }
        });
        GroupLayout editorPanelLayout = new GroupLayout(this.editorPanel);
        this.editorPanel.setLayout(editorPanelLayout);
        editorPanelLayout.setHorizontalGroup(editorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tableScrollPane).addGroup(editorPanelLayout.createSequentialGroup().addGroup(editorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(editorPanelLayout.createSequentialGroup().addComponent(this.filtersLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.unfoundFilterCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.localFilterCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.remoteFilterCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.relativeFilterCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.absoluteFilterCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.selectedFilterCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.clearButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.selectAllButtonButton)).addGroup(editorPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.subpathLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.subpathTextField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.changeRelativeButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.makeAllRelativeButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.downloadButton).addGap(18, 18, 18).addComponent(this.undoButton))).addContainerGap()));
        editorPanelLayout.setVerticalGroup(editorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, editorPanelLayout.createSequentialGroup().addGroup(editorPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(editorPanelLayout.createSequentialGroup().addGap(5, 5, 5).addGroup(editorPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.filtersLabel).addComponent(this.localFilterCheckBox).addComponent(this.remoteFilterCheckBox).addComponent(this.unfoundFilterCheckBox).addComponent(this.absoluteFilterCheckBox).addComponent(this.relativeFilterCheckBox).addComponent(this.selectedFilterCheckBox))).addComponent(this.selectAllButtonButton).addComponent(this.clearButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tableScrollPane, -1, 233, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(editorPanelLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.downloadButton).addComponent(this.changeRelativeButton).addComponent(this.subpathTextField, -2, -1, -2).addComponent(this.subpathLabel).addComponent(this.makeAllRelativeButton).addComponent(this.undoButton)).addContainerGap()));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.overviewPanel, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.editorPanel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.overviewPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.editorPanel, -1, -1, Short.MAX_VALUE).addContainerGap()));
        this.overviewPanel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(MediaManagerActionPanel.class, (String)"MediaManagerActionPanel.overviewPanel.AccessibleContext.accessibleName"));
    }

    private void tableComponentResized(ComponentEvent evt) {
        this.resizeColumns();
        this.resizeLines();
    }

    private void unfoundFilterCheckBoxActionPerformed(ActionEvent evt) {
        this.setFilter();
    }

    private void localFilterCheckBoxActionPerformed(ActionEvent evt) {
        if (this.localFilterCheckBox.isSelected() && this.remoteFilterCheckBox.isSelected()) {
            this.remoteFilterCheckBox.setSelected(false);
        }
        this.setFilter();
    }

    private void remoteFilterCheckBoxActionPerformed(ActionEvent evt) {
        if (this.localFilterCheckBox.isSelected() && this.remoteFilterCheckBox.isSelected()) {
            this.localFilterCheckBox.setSelected(false);
        }
        this.setFilter();
    }

    private void relativeFilterCheckBoxActionPerformed(ActionEvent evt) {
        if (this.relativeFilterCheckBox.isSelected() && this.absoluteFilterCheckBox.isSelected()) {
            this.absoluteFilterCheckBox.setSelected(false);
        }
        this.setFilter();
    }

    private void absoluteFilterCheckBoxActionPerformed(ActionEvent evt) {
        if (this.relativeFilterCheckBox.isSelected() && this.absoluteFilterCheckBox.isSelected()) {
            this.relativeFilterCheckBox.setSelected(false);
        }
        this.setFilter();
    }

    private void selectedFilterCheckBoxActionPerformed(ActionEvent evt) {
        this.setFilter();
    }

    private void showAllFilesButtonActionPerformed(ActionEvent evt) {
        this.openMediaViewer();
    }

    private void downloadButtonActionPerformed(ActionEvent evt) {
        this.downloadFilesProcess();
    }

    private void changeRelativeButtonActionPerformed(ActionEvent evt) {
        this.setCommonSubpath();
    }

    private void makeAllRelativeButtonActionPerformed(ActionEvent evt) {
        int nbChanges = 0;
        for (PathData pd : this.pathDataList) {
            if (!this.mediaPathTableModel.validate(pd)) continue;
            nbChanges += this.mediaPathTableModel.switchRelativeAbsolute(pd, !pd.relative);
        }
        this.commitChanges();
        String title = NbBundle.getMessage(MediaManagerActionPanel.class, (String)"MediaManagerActionPanel.makeAllRelativeButton.title");
        String msg = "";
        msg = nbChanges != 0 ? NbBundle.getMessage(MediaManagerActionPanel.class, (String)"MediaManagerActionPanel.makeAllRelativeButton.successMessage", (Object)nbChanges) : NbBundle.getMessage(MediaManagerActionPanel.class, (String)"MediaManagerActionPanel.makeAllRelativeButton.failureMessage");
        DialogManager.create((String)title, (String)msg).setMessageType(1).setOptionType(10).show();
    }

    private void selectAllButtonButtonActionPerformed(ActionEvent evt) {
        boolean selectionExists = this.table.getSelectedRow() >= 0;
        for (PathData pd : this.pathDataList) {
            int row = this.getRowFromPath(pd);
            if (!this.mediaPathTableModel.validate(pd) || selectionExists && !this.table.isRowSelected(row)) continue;
            this.mediaPathTableModel.switchSelected(pd, !pd.selected);
        }
        this.refreshTable();
        this.updateButtons();
        this.updateSubpathTextField();
    }

    private void clearButtonActionPerformed(ActionEvent evt) {
        for (PathData pd : this.pathDataList) {
            if (!this.mediaPathTableModel.validate(pd)) continue;
            this.mediaPathTableModel.switchSelected(pd, false);
        }
        this.refreshTable();
    }

    private void undoButtonActionPerformed(ActionEvent evt) {
        this.undo();
        this.mediaTestRemoteExistenceDone = false;
        this.buildStatsAndTable();
        this.refreshTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testRemoteExistenceActionPerformed(ActionEvent evt) {
        boolean previousCheckValue = GedcomOptions.getInstance().isCheckRemote();
        if (!previousCheckValue) {
            GedcomOptions.getInstance().setCheckRemote(true);
        }
        try {
            if (EnvironmentChecker.isConnected()) {
                this.mediaTestRemoteExistence = true;
                this.buildStatsAndTable();
                this.refreshTable();
                this.mediaTestRemoteExistence = false;
                this.mediaTestRemoteExistenceDone = true;
            } else {
                String title = NbBundle.getMessage(MediaManagerActionPanel.class, (String)"MediaManagerActionPanel.testRemoteExistence.text");
                String msg = NbBundle.getMessage(MediaManagerActionPanel.class, (String)"MediaManagerActionPanel.testRemoteExistence.noConnection");
                DialogManager.create((String)title, (String)msg).setMessageType(0).setOptionType(10).show();
            }
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        finally {
            if (!previousCheckValue) {
                GedcomOptions.getInstance().setCheckRemote(false);
            }
        }
    }

    private void refreshButtonActionPerformed(ActionEvent evt) {
        this.buildStatsAndTable();
        this.refreshTable();
    }

    private void nbTimeoutSpinnerPropertyChange(PropertyChangeEvent evt) {
    }

    private void nbTimeoutSpinnerStateChanged(ChangeEvent evt) {
        GedcomOptions.getInstance().setURLTimeout(((Integer)this.nbTimeoutSpinner.getValue()).intValue());
    }

    protected static String getPathFromFileValue(PropertyFile pFile) {
        Object path = pFile.getValue().trim();
        if (((String)path).isEmpty()) {
            return "";
        }
        int from = 0;
        from = ((String)path).lastIndexOf(FSLASH + FSLASH);
        from = from != -1 ? (from += 2) : 0;
        int i = ((String)path).substring(from).lastIndexOf(FSLASH);
        if (i == -1) {
            return from < 2 ? "" : ((String)path).substring(0, from);
        }
        if (!((String)(path = ((String)path).substring(0, from + i))).endsWith(FSLASH)) {
            path = (String)path + FSLASH;
        }
        return path;
    }

    protected static PathData getPathDataFromKey(Set<PathData> pathDataList, String path, boolean found, boolean ent) {
        String key = PathData.getKey(found, ent, path);
        for (PathData pd : pathDataList) {
            if (!key.equals(pd.getKey())) continue;
            return pd;
        }
        return null;
    }

    protected PathData getPathDataFromRow(int row) {
        String path = (String)this.mediaPathTableModel.getValueAt(row, MediaPathTableModel.NEW_PATH_COLUMN);
        boolean found = (Boolean)this.mediaPathTableModel.getValueAt(row, MediaPathTableModel.FOUND_COLUMN);
        boolean ent = (Boolean)this.mediaPathTableModel.getValueAt(row, MediaPathTableModel.ENTITY_COLUMN);
        return MediaManagerActionPanel.getPathDataFromKey(this.pathDataList, path, found, ent);
    }

    protected int getRowFromPath(PathData pathdata) {
        for (int row = 0; row < this.table.getRowCount(); ++row) {
            PathData pd = this.getPathDataFromRow(row);
            if (!pd.equals(pathdata)) continue;
            return row;
        }
        return 0;
    }

    private void searchLocalPath(PathData pd, String path, Boolean rel) {
        String unschemedPath = rel != false ? this.relativePathValue + FSLASH + Origin.getPath((String)path) : Origin.getPath((String)path);
        SearchLocalFilePanel panel = new SearchLocalFilePanel(pd, unschemedPath);
        Object o = DialogManager.create((String)NbBundle.getMessage(MediaManagerActionPanel.class, (String)"SearchLocalFilePanel.displayPathTitle"), (JComponent)panel).setMessageType(-1).setOptionType(2).setDialogId(SearchLocalFilePanel.class).show();
        if (o == DialogManager.OK_OPTION) {
            this.updatePathDataList(pd, panel.getNewPath(), rel);
        }
    }

    private void searchRemotePath(PathData pd, String path) {
        SearchRemoteFilePanel panel = new SearchRemoteFilePanel(pd, Origin.getPath((String)path));
        DialogManager.create((String)NbBundle.getMessage(MediaManagerActionPanel.class, (String)"SearchRemoteFilePanel.displayPathTitle"), (JComponent)panel).setMessageType(-1).setOptionType(10).setDialogId(SearchRemoteFilePanel.class).show();
        if (panel.hasChanged()) {
            this.commitChanges();
        }
    }

    private void updatePathDataList(PathData pd, String path, boolean rel) {
        Path rootbase = Paths.get(this.relativePathValue, new String[0]);
        Path newpath = Paths.get(path, new String[0]);
        Object newPath = path;
        if (rel) {
            Path relativePath = rootbase.relativize(newpath);
            newPath = relativePath.toString() + FSLASH;
        }
        if (!((String)newPath).endsWith(FSLASH)) {
            newPath = (String)newPath + FSLASH;
        }
        pd.setPath((String)newPath);
        pd.setRelative(rel);
        this.commitChanges();
    }

    private void undo() {
        if (!this.gedcom.isWriteLocked() && this.gedcom.getUndoNb() > this.initialUndoNb && this.gedcom.canUndo()) {
            this.gedcom.undoUnitOfWork(false);
        }
        this.undoButton.setEnabled(this.gedcom.getUndoNb() > this.initialUndoNb);
    }

    protected void updateSubpathTextField() {
        this.subpathTextField.setText(this.getCommonSubpath());
    }

    private String getCommonSubpath() {
        String subpath = "";
        boolean first = true;
        for (PathData pd : this.pathDataList) {
            if (!this.mediaPathTableModel.validate(pd) || !pd.selected) continue;
            if (first) {
                subpath = pd.path;
                first = false;
                continue;
            }
            subpath = this.getLongestCommonSubpath(subpath, pd.path);
        }
        return subpath;
    }

    private void setCommonSubpath() {
        String commonSubPath;
        String newSubPath = this.subpathTextField.getText();
        if (newSubPath.equals(commonSubPath = this.getCommonSubpath())) {
            return;
        }
        for (PathData pd : this.pathDataList) {
            if (!this.mediaPathTableModel.validate(pd) || !pd.selected) continue;
            if (commonSubPath.isEmpty()) {
                pd.path = newSubPath + pd.path;
                continue;
            }
            pd.path = pd.path.replace(commonSubPath, newSubPath);
        }
        this.commitChanges();
    }

    private String getLongestCommonSubpath(String str1, String str2) {
        String[] bits1 = str1.split(FSLASH);
        String[] bits2 = str2.split(FSLASH);
        int m = bits1.length;
        int n = bits2.length;
        int max = 0;
        int[][] dp = new int[m][n];
        int endIndex = -1;
        for (int i = 0; i < m; ++i) {
            for (int j = 0; j < n; ++j) {
                if (!bits1[i].equals(bits2[j])) continue;
                dp[i][j] = i == 0 || j == 0 ? 1 : dp[i - 1][j - 1] + 1;
                if (max >= dp[i][j]) continue;
                max = dp[i][j];
                endIndex = i;
            }
        }
        Object ret = "";
        for (int i = endIndex - max + 1; i < endIndex + 1; ++i) {
            ret = (String)ret + bits1[i] + FSLASH;
        }
        return ret;
    }

    private void setFilter() {
        this.mediaPathTableModel.setFilter(this.unfoundFilterCheckBox.isSelected(), this.localFilterCheckBox.isSelected(), this.remoteFilterCheckBox.isSelected(), this.relativeFilterCheckBox.isSelected(), this.absoluteFilterCheckBox.isSelected(), this.selectedFilterCheckBox.isSelected());
        this.refreshTable();
    }

    private void downloadFilesProcess() {
        long nbDownloadable = 0L;
        for (PathData pd : this.pathDataList) {
            if (!pd.selected || pd.local) continue;
            ++nbDownloadable;
        }
        String title = NbBundle.getMessage(MediaManagerActionPanel.class, (String)"MediaManagerActionPanel.downloadButton.title", (Object)nbDownloadable);
        if (nbDownloadable == 0L) {
            DialogManager.createError((String)title, (String)NbBundle.getMessage(MediaManagerActionPanel.class, (String)"MediaManagerActionPanel.downloadButton.noFileMessage")).show();
            return;
        }
        String defaultDir = this.registry.get("mediaDownloadDir", System.getProperty("user.home"));
        File dir = new FileChooserBuilder(MediaManagerActionPanel.class).setDirectoriesOnly(true).setDefaultBadgeProvider().setTitle(NbBundle.getMessage(MediaManagerActionPanel.class, (String)"FileChooserTitle")).setApproveText(NbBundle.getMessage(MediaManagerActionPanel.class, (String)"FileChooserButton")).setFileFilter(null).setAcceptAllFileFilterUsed(true).setFileHiding(true).setParent((Component)this).setDefaultPreviewer().setSelectedFile(new File(defaultDir)).setDefaultWorkingDirectory(new File(defaultDir)).showOpenDialog();
        if (dir != null) {
            if (!dir.isDirectory()) {
                dir = dir.getParentFile();
            }
        } else {
            String msg = NbBundle.getMessage(MediaManagerActionPanel.class, (String)"MediaManagerActionPanel.downloadButton.nullFolder");
            DialogManager.create((String)title, (String)msg).setMessageType(0).setOptionType(10).show();
            return;
        }
        this.registry.put("mediaDownloadDir", dir.getAbsolutePath());
        BackgroundTask task = (BackgroundTask)Spin.off((Object)DownloadTaskFactory.create(this.pathDataList, dir, nbDownloadable, title));
        ProgressListener.Dispatcher.processStarted((Trackable)task);
        MediaManagerActionPanel.commit(this.gedcom, task);
        ProgressListener.Dispatcher.processStopped((Trackable)task);
        String msg = NbBundle.getMessage(MediaManagerActionPanel.class, (String)"MediaManagerActionPanel.downloadButton.successMessage", (Object)task.getSuccesses(), (Object)dir.getAbsolutePath());
        if (task.getSuccesses() > 0L || task.getErrors() > 0L) {
            this.buildStatsAndTable();
            this.refreshTable();
        }
        if (task.getErrors() > 0L) {
            if (task.getSuccesses() > 0L) {
                msg = NbBundle.getMessage(MediaManagerActionPanel.class, (String)"MediaManagerActionPanel.downloadButton.partialErrorMessage", (Object)task.getSuccesses(), (Object)dir.getAbsolutePath(), (Object)task.getErrors());
            } else {
                this.undo();
                msg = NbBundle.getMessage(MediaManagerActionPanel.class, (String)"MediaManagerActionPanel.downloadButton.totalErrorMessage", (Object)task.getErrors());
            }
        }
        DialogManager.create((String)title, (String)msg).setMessageType(task.getSuccesses() > 0L ? -1 : 0).setOptionType(10).show();
    }

    private void openMediaViewer() {
        MediaChooser mediaChooser = new MediaChooser(this.gedcom);
        int size = mediaChooser.getNbMedia();
        Object o = DialogManager.create((String)NbBundle.getMessage(this.getClass(), (String)"MediaManagerActionPanel.showAllFilesButton.text", (Object)size), (JComponent)mediaChooser).setDialogId("mediaChooser").setMessageType(-1).setOptionType(10).show();
    }

    public void execute() {
        Object o = DialogManager.create((String)NbBundle.getMessage(this.getClass(), (String)"TITLE_update", (Object)this.gedcom.getDisplayName()), (JComponent)this).setMessageType(-1).setOptionType(10).setDialogId("actionMediaManager").show();
    }

    public void commitChanges() {
        Runnable task = () -> {
            boolean error = false;
            for (PathData pd : this.pathDataList) {
                PropertyFile pFile;
                String oldPath;
                String newPath = pd.path;
                Iterator<PropertyFile> iterator = pd.getFiles().iterator();
                while (iterator.hasNext() && !(oldPath = MediaManagerActionPanel.getPathFromFileValue(pFile = iterator.next())).equals(newPath)) {
                    String value = pFile.getValue();
                    File f = new File(value);
                    String filename = f.getName();
                    if (value.endsWith(FSLASH)) {
                        filename = "";
                    }
                    pFile.setValue(newPath + filename);
                    String newValue = pFile.getValue();
                    if (!newValue.equals(value) || !GedcomOptions.getInstance().isForceRelative()) continue;
                    pd.setRelative(true);
                    error = true;
                }
            }
            if (error) {
                DialogManager.createError((String)NbBundle.getMessage(this.getClass(), (String)"MediaManagerActionPanel.makeAllRelativeButton.title"), (String)NbBundle.getMessage(this.getClass(), (String)"MediaManagerActionPanel.relativepathisforced.text")).setMessageType(2).setOptionType(10).setDialogId("actionMediaManagerWarning").show();
            }
        };
        MediaManagerActionPanel.commit(this.gedcom, task);
        this.mediaTestRemoteExistenceDone = false;
        this.buildStatsAndTable();
        this.refreshTable();
    }

    private static void commit(Gedcom gedcom, Runnable task) {
        block5: {
            try {
                if (gedcom.isWriteLocked()) {
                    task.run();
                    break block5;
                }
                gedcom.doUnitOfWork(localGedcom -> task.run());
            }
            catch (GedcomException ge) {
                Exceptions.printStackTrace((Throwable)ge);
            }
        }
    }

    private class RadioCellRenderer
    extends JRadioButton
    implements TableCellRenderer {
        private RadioCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setHorizontalAlignment(0);
            this.setSelected((Boolean)value);
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            }
            this.setOpaque(true);
            return this;
        }
    }

    private class IntCellRenderer
    extends JLabel
    implements TableCellRenderer {
        private IntCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setHorizontalAlignment(0);
            this.setText(String.valueOf((Integer)value));
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            }
            this.setOpaque(true);
            return this;
        }
    }

    private class CheckBoxCellRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private CheckBoxCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setHorizontalAlignment(0);
            this.setSelected((Boolean)value);
            if (column == MediaPathTableModel.REL_COLUMN) {
                boolean isLocal = (Boolean)MediaManagerActionPanel.this.mediaPathTableModel.getValueAt(row, MediaPathTableModel.LOCAL_COLUMN);
                this.setEnabled(isLocal);
            }
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            }
            this.setOpaque(true);
            return this;
        }
    }

    private class TextCellRenderer
    extends JLabel
    implements TableCellRenderer {
        private TextCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setHorizontalAlignment(2);
            this.setText((String)value);
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            }
            this.setOpaque(true);
            return this;
        }
    }
}

