/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.graphicGraph.stylesheet;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import org.graphstream.graph.Edge;
import org.graphstream.graph.Element;
import org.graphstream.graph.Graph;
import org.graphstream.graph.Node;
import org.graphstream.ui.graphicGraph.GraphicSprite;
import org.graphstream.ui.graphicGraph.stylesheet.Color;
import org.graphstream.ui.graphicGraph.stylesheet.Colors;
import org.graphstream.ui.graphicGraph.stylesheet.Rule;
import org.graphstream.ui.graphicGraph.stylesheet.Selector;
import org.graphstream.ui.graphicGraph.stylesheet.Style;
import org.graphstream.ui.graphicGraph.stylesheet.StyleConstants;
import org.graphstream.ui.graphicGraph.stylesheet.StyleSheetListener;
import org.graphstream.ui.graphicGraph.stylesheet.Values;
import org.graphstream.ui.graphicGraph.stylesheet.parser.StyleSheetParser;
import org.graphstream.util.parser.ParseException;

public class StyleSheet {
    public Rule defaultRule;
    public NameSpace graphRules = new NameSpace(Selector.Type.GRAPH);
    public NameSpace nodeRules = new NameSpace(Selector.Type.NODE);
    public NameSpace edgeRules = new NameSpace(Selector.Type.EDGE);
    public NameSpace spriteRules = new NameSpace(Selector.Type.SPRITE);
    public ArrayList<StyleSheetListener> listeners = new ArrayList();

    public StyleSheet() {
        this.initRules();
    }

    public Rule getDefaultGraphRule() {
        return this.graphRules.defaultRule;
    }

    public Rule getDefaultNodeRule() {
        return this.nodeRules.defaultRule;
    }

    public Rule getDefaultEdgeRule() {
        return this.edgeRules.defaultRule;
    }

    public Rule getDefaultSpriteRule() {
        return this.spriteRules.defaultRule;
    }

    public Style getDefaultGraphStyle() {
        return this.getDefaultGraphRule().getStyle();
    }

    public Style getDefaultNodeStyle() {
        return this.getDefaultNodeRule().getStyle();
    }

    public Style getDefaultEdgeStyle() {
        return this.getDefaultEdgeRule().getStyle();
    }

    public Style getDefaultSpriteStyle() {
        return this.getDefaultSpriteRule().getStyle();
    }

    public NameSpace getGraphStyleNameSpace() {
        return this.graphRules;
    }

    public NameSpace getNodeStyleNameSpace() {
        return this.nodeRules;
    }

    public NameSpace getEdgeStyleNameSpace() {
        return this.edgeRules;
    }

    public NameSpace getSpriteStyleNameSpace() {
        return this.spriteRules;
    }

    public ArrayList<Rule> getRulesFor(Element element) {
        ArrayList<Rule> rules = null;
        if (element instanceof Graph) {
            rules = this.graphRules.getRulesFor(element);
        } else if (element instanceof Node) {
            rules = this.nodeRules.getRulesFor(element);
        } else if (element instanceof Edge) {
            rules = this.edgeRules.getRulesFor(element);
        } else if (element instanceof GraphicSprite) {
            rules = this.spriteRules.getRulesFor(element);
        } else {
            rules = new ArrayList();
            rules.add(this.defaultRule);
        }
        return rules;
    }

    public String getStyleGroupIdFor(Element element, ArrayList<Rule> rules) {
        int n;
        StringBuilder builder = new StringBuilder();
        if (element instanceof Graph) {
            builder.append("g");
        } else if (element instanceof Node) {
            builder.append("n");
        } else if (element instanceof Edge) {
            builder.append("e");
        } else if (element instanceof GraphicSprite) {
            builder.append("s");
        } else {
            throw new RuntimeException("What ?");
        }
        if (rules.get((int)0).selector.getId() != null) {
            builder.append('_');
            builder.append(rules.get((int)0).selector.getId());
        }
        if ((n = rules.size()) > 1) {
            builder.append('(');
            builder.append(rules.get((int)1).selector.getClazz());
            int i = 2;
            while (i < n) {
                builder.append(',');
                builder.append(rules.get((int)i).selector.getClazz());
                ++i;
            }
            builder.append(')');
        }
        return builder.toString();
    }

    protected void initRules() {
        this.defaultRule = new Rule(new Selector(Selector.Type.ANY), null);
        this.defaultRule.getStyle().setDefaults();
        this.graphRules.defaultRule = new Rule(new Selector(Selector.Type.GRAPH), this.defaultRule);
        this.nodeRules.defaultRule = new Rule(new Selector(Selector.Type.NODE), this.defaultRule);
        this.edgeRules.defaultRule = new Rule(new Selector(Selector.Type.EDGE), this.defaultRule);
        this.spriteRules.defaultRule = new Rule(new Selector(Selector.Type.SPRITE), this.defaultRule);
        this.graphRules.defaultRule.getStyle().setValue("padding", new Values(StyleConstants.Units.PX, 30.0));
        this.edgeRules.defaultRule.getStyle().setValue("shape", (Object)StyleConstants.Shape.LINE);
        this.edgeRules.defaultRule.getStyle().setValue("size", new Values(StyleConstants.Units.PX, 1.0));
        this.edgeRules.defaultRule.getStyle().setValue("z-index", new Integer(1));
        this.nodeRules.defaultRule.getStyle().setValue("z-index", new Integer(2));
        this.spriteRules.defaultRule.getStyle().setValue("z-index", new Integer(3));
        Colors colors = new Colors();
        colors.add(Color.WHITE);
        this.graphRules.defaultRule.getStyle().setValue("fill-color", colors);
        this.graphRules.defaultRule.getStyle().setValue("stroke-mode", (Object)StyleConstants.StrokeMode.NONE);
        for (StyleSheetListener listener : this.listeners) {
            listener.styleAdded(this.defaultRule, this.defaultRule);
            listener.styleAdded(this.graphRules.defaultRule, this.graphRules.defaultRule);
            listener.styleAdded(this.nodeRules.defaultRule, this.nodeRules.defaultRule);
            listener.styleAdded(this.edgeRules.defaultRule, this.edgeRules.defaultRule);
            listener.styleAdded(this.spriteRules.defaultRule, this.spriteRules.defaultRule);
        }
    }

    public void addListener(StyleSheetListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(StyleSheetListener listener) {
        int index = this.listeners.indexOf(listener);
        if (index >= 0) {
            this.listeners.remove(index);
        }
    }

    public void clear() {
        this.graphRules.clear();
        this.nodeRules.clear();
        this.edgeRules.clear();
        this.spriteRules.clear();
        this.initRules();
        for (StyleSheetListener listener : this.listeners) {
            listener.styleSheetCleared();
        }
    }

    public void parseFromFile(String fileName) throws IOException {
        this.parse(new InputStreamReader(new BufferedInputStream(new FileInputStream(fileName))));
    }

    public void parseFromURL(String url) throws IOException {
        URL u = StyleSheet.class.getClassLoader().getResource(url);
        if (u == null) {
            String fileUrl = url.replace("file://", "");
            File f = new File(fileUrl);
            u = f.exists() ? f.toURI().toURL() : new URL(url);
        }
        this.parse(new InputStreamReader(u.openStream()));
    }

    public void parseFromString(String styleSheet) throws IOException {
        this.parse(new StringReader(styleSheet));
    }

    public void parseStyleFromString(Selector select, String styleString) throws IOException {
        StyleSheetParser parser = new StyleSheetParser(this, new StringReader(styleString));
        Style style = new Style();
        try {
            parser.stylesStart(style);
        }
        catch (ParseException e) {
            throw new IOException(e.getMessage());
        }
        Rule rule = new Rule(select);
        rule.setStyle(style);
        this.addRule(rule);
    }

    public void load(String styleSheetValue) throws IOException {
        if (styleSheetValue.startsWith("url")) {
            int beg = styleSheetValue.indexOf(40);
            int end = styleSheetValue.lastIndexOf(41);
            if (beg >= 0 && end > beg) {
                styleSheetValue = styleSheetValue.substring(beg + 1, end);
            }
            if ((styleSheetValue = styleSheetValue.trim()).startsWith("'")) {
                beg = 0;
                end = styleSheetValue.lastIndexOf(39);
                if (beg >= 0 && end > beg) {
                    styleSheetValue = styleSheetValue.substring(beg + 1, end);
                }
            }
            if ((styleSheetValue = styleSheetValue.trim()).startsWith("\"")) {
                beg = 0;
                end = styleSheetValue.lastIndexOf(34);
                if (beg >= 0 && end > beg) {
                    styleSheetValue = styleSheetValue.substring(beg + 1, end);
                }
            }
            this.parseFromURL(styleSheetValue);
        } else {
            this.parseFromString(styleSheetValue);
        }
    }

    protected void parse(Reader reader) throws IOException {
        StyleSheetParser parser = new StyleSheetParser(this, reader);
        try {
            parser.start();
        }
        catch (ParseException e) {
            throw new IOException(e.getMessage());
        }
    }

    public void addRule(Rule newRule) {
        Rule oldRule = null;
        switch (newRule.selector.getType()) {
            case ANY: {
                throw new RuntimeException("The ANY selector should never be used, it is created automatically.");
            }
            case GRAPH: {
                oldRule = this.graphRules.addRule(newRule);
                break;
            }
            case NODE: {
                oldRule = this.nodeRules.addRule(newRule);
                break;
            }
            case EDGE: {
                oldRule = this.edgeRules.addRule(newRule);
                break;
            }
            case SPRITE: {
                oldRule = this.spriteRules.addRule(newRule);
                break;
            }
            default: {
                throw new RuntimeException("Ho ho ho ?");
            }
        }
        for (StyleSheetListener listener : this.listeners) {
            listener.styleAdded(oldRule, newRule);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("StyleSheet : {\n");
        builder.append("  default styles:\n");
        builder.append(this.defaultRule.toString(1));
        builder.append(this.graphRules.toString(1));
        builder.append(this.nodeRules.toString(1));
        builder.append(this.edgeRules.toString(1));
        builder.append(this.spriteRules.toString(1));
        return builder.toString();
    }

    public class NameSpace {
        public Selector.Type type;
        public Rule defaultRule;
        public HashMap<String, Rule> byId = new HashMap();
        public HashMap<String, Rule> byClass = new HashMap();

        public NameSpace(Selector.Type type) {
            this.type = type;
        }

        public Selector.Type getGraphElementType() {
            return this.type;
        }

        public int getIdRulesCount() {
            return this.byId.size();
        }

        public int getClassRulesCount() {
            return this.byClass.size();
        }

        protected ArrayList<Rule> getRulesFor(Element element) {
            Rule rule = this.byId.get(element.getId());
            ArrayList<Rule> rules = new ArrayList<Rule>();
            if (rule != null) {
                rules.add(rule);
            } else {
                rules.add(this.defaultRule);
            }
            this.getClassRules(element, rules);
            if (rules.isEmpty()) {
                rules.add(this.defaultRule);
            }
            return rules;
        }

        protected void getClassRules(Element element, ArrayList<Rule> rules) {
            Object o = element.getAttribute("ui.class");
            if (o != null) {
                if (o instanceof Object[]) {
                    Object[] objectArray = (Object[])o;
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Rule rule;
                        Object s = objectArray[n2];
                        if (s instanceof CharSequence && (rule = this.byClass.get((CharSequence)s)) != null) {
                            rules.add(rule);
                        }
                        ++n2;
                    }
                } else if (o instanceof CharSequence) {
                    String[] classes;
                    String classList = ((CharSequence)o).toString().trim();
                    String[] stringArray = classes = classList.split("\\s*,\\s*");
                    int n = classes.length;
                    int n3 = 0;
                    while (n3 < n) {
                        String c = stringArray[n3];
                        Rule rule = this.byClass.get(c);
                        if (rule != null) {
                            rules.add(rule);
                        }
                        ++n3;
                    }
                } else {
                    throw new RuntimeException("Oups ! class attribute is of type " + o.getClass().getName());
                }
            }
        }

        protected void clear() {
            this.defaultRule = null;
            this.byId.clear();
            this.byClass.clear();
        }

        protected Rule addRule(Rule newRule) {
            Rule oldRule = null;
            if (newRule.selector.getPseudoClass() != null) {
                oldRule = this.addEventRule(newRule);
            } else if (newRule.selector.getId() != null) {
                oldRule = this.byId.get(newRule.selector.getId());
                if (oldRule != null) {
                    oldRule.getStyle().augment(newRule.getStyle());
                } else {
                    this.byId.put(newRule.selector.getId(), newRule);
                    newRule.getStyle().reparent(this.defaultRule);
                }
            } else if (newRule.selector.getClazz() != null) {
                oldRule = this.byClass.get(newRule.selector.getClazz());
                if (oldRule != null) {
                    oldRule.getStyle().augment(newRule.getStyle());
                } else {
                    this.byClass.put(newRule.selector.getClazz(), newRule);
                    newRule.getStyle().reparent(this.defaultRule);
                }
            } else {
                oldRule = this.defaultRule;
                this.defaultRule.getStyle().augment(newRule.getStyle());
                newRule = this.defaultRule;
            }
            return oldRule;
        }

        protected Rule addEventRule(Rule newRule) {
            Rule parentRule = null;
            if (newRule.selector.getId() != null) {
                parentRule = this.byId.get(newRule.selector.getId());
                if (parentRule == null) {
                    parentRule = this.addRule(new Rule(new Selector(newRule.selector.getType(), newRule.selector.getId(), newRule.selector.getClazz())));
                }
            } else if (newRule.selector.getClazz() != null) {
                parentRule = this.byClass.get(newRule.selector.getClazz());
                if (parentRule == null) {
                    parentRule = this.addRule(new Rule(new Selector(newRule.selector.getType(), newRule.selector.getId(), newRule.selector.getClazz())));
                }
            } else {
                parentRule = this.defaultRule;
            }
            newRule.getStyle().reparent(parentRule);
            parentRule.getStyle().addAlternateStyle(newRule.selector.getPseudoClass(), newRule);
            return parentRule;
        }

        public String toString() {
            return this.toString(-1);
        }

        public String toString(int level) {
            String prefix = "";
            if (level > 0) {
                int i = 0;
                while (i < level) {
                    prefix = String.valueOf(prefix) + "    ";
                    ++i;
                }
            }
            StringBuilder builder = new StringBuilder();
            builder.append(String.format("%s%s default style :%n", new Object[]{prefix, this.type}));
            builder.append(this.defaultRule.toString(level + 1));
            this.toStringRules(level, builder, this.byId, String.format("%s%s id styles", new Object[]{prefix, this.type}));
            this.toStringRules(level, builder, this.byClass, String.format("%s%s class styles", new Object[]{prefix, this.type}));
            return builder.toString();
        }

        protected void toStringRules(int level, StringBuilder builder, HashMap<String, Rule> rules, String title) {
            builder.append(title);
            builder.append(String.format(" :%n", new Object[0]));
            for (Rule rule : rules.values()) {
                builder.append(rule.toString(level + 1));
            }
        }
    }
}

