/*
 * Decompiled with CFR 0.152.
 */
package org.graphstream.ui.layout;

import java.security.AccessControlException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.graphstream.ui.layout.Layout;
import org.graphstream.ui.layout.springbox.implementations.SpringBox;

public class Layouts {
    private static final Logger logger = Logger.getLogger(Layouts.class.getSimpleName());

    public static Layout newLayoutAlgorithm() {
        String layoutClassName;
        try {
            layoutClassName = System.getProperty("gs.ui.layout");
            if (layoutClassName != null) {
                logger.log(Level.WARNING, "\"gs.ui.layout\" is deprecated, use \"org.graphstream.ui.layout\" instead.");
            } else {
                layoutClassName = System.getProperty("org.graphstream.ui.layout");
            }
        }
        catch (AccessControlException e) {
            layoutClassName = null;
        }
        if (layoutClassName != null) {
            try {
                Class<?> c = Class.forName(layoutClassName);
                Object object = c.newInstance();
                if (object instanceof Layout) {
                    return (Layout)object;
                }
                logger.warning(String.format("class '%s' is not a 'GraphRenderer'%n", object));
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Cannot create layout.", e);
            }
        }
        return new SpringBox(false);
    }
}

