# Transmission 4.1.0

This is Transmission 4.1.0. We've been working on this release for over
a year now, and we're excited to finally get it over the finish line!


## What's New in 4.1.0

### Highlights

* Improved µTP download performance. ([#6508](https://github.com/transmission/transmission/pull/6508))
* Added support for IPv6 and dual-stack UDP trackers. ([#6687](https://github.com/transmission/transmission/pull/6687))
* Support trackers that only support the old BEP-7 with `&ipv4=` and `&ipv6=`. ([#7481](https://github.com/transmission/transmission/pull/7481))
* New [JSON-RPC 2.0](https://www.jsonrpc.org/specification)-compliant RPC API. ([#7269](https://github.com/transmission/transmission/pull/7269))
* Added optional sequential downloading. ([#4795](https://github.com/transmission/transmission/pull/4795))
* Use native icons for menus and toolbars: SF Symbols on macOS, Segoe Fluent on Windows 11, Segoe MDL2 on Windows 10, and XDG standard icon names everywhere else. ([#7819](https://github.com/transmission/transmission/pull/7819), Qt Client)
* Fixed `4.0.6` bug where Transmission might spam HTTP tracker announces. ([#7086](https://github.com/transmission/transmission/pull/7086))

### All Platforms

* Improved libtransmission code to use less CPU. ([#4876](https://github.com/transmission/transmission/pull/4876), [#5645](https://github.com/transmission/transmission/pull/5645), [#5715](https://github.com/transmission/transmission/pull/5715), [#5734](https://github.com/transmission/transmission/pull/5734), [#5740](https://github.com/transmission/transmission/pull/5740), [#5792](https://github.com/transmission/transmission/pull/5792), [#6103](https://github.com/transmission/transmission/pull/6103), [#6111](https://github.com/transmission/transmission/pull/6111), [#6325](https://github.com/transmission/transmission/pull/6325), [#6549](https://github.com/transmission/transmission/pull/6549), [#6589](https://github.com/transmission/transmission/pull/6589), [#6712](https://github.com/transmission/transmission/pull/6712), [#7027](https://github.com/transmission/transmission/pull/7027), [#7744](https://github.com/transmission/transmission/pull/7744), [#7800](https://github.com/transmission/transmission/pull/7800))
* Avoid unnecessary heap memory allocations. ([#5519](https://github.com/transmission/transmission/pull/5519), [#5520](https://github.com/transmission/transmission/pull/5520), [#5522](https://github.com/transmission/transmission/pull/5522), [#5527](https://github.com/transmission/transmission/pull/5527), [#5540](https://github.com/transmission/transmission/pull/5540), [#5649](https://github.com/transmission/transmission/pull/5649), [#5666](https://github.com/transmission/transmission/pull/5666), [#5672](https://github.com/transmission/transmission/pull/5672), [#5676](https://github.com/transmission/transmission/pull/5676), [#5720](https://github.com/transmission/transmission/pull/5720), [#5722](https://github.com/transmission/transmission/pull/5722), [#5725](https://github.com/transmission/transmission/pull/5725), [#5726](https://github.com/transmission/transmission/pull/5726), [#5768](https://github.com/transmission/transmission/pull/5768), [#5788](https://github.com/transmission/transmission/pull/5788), [#5830](https://github.com/transmission/transmission/pull/5830), [#6542](https://github.com/transmission/transmission/pull/6542))
* Slightly reduced latency when sending protocol messages to peers. ([#5394](https://github.com/transmission/transmission/pull/5394))
* Added the option `preferred_transport` to `settings.json`, so that users can choose their preference between µTP and TCP. ([#5939](https://github.com/transmission/transmission/pull/5939))
* Return `X-Transmission-Rpc-Version` header in RPC HTTP 409 response to indicate JSON-RPC support. ([#7958](https://github.com/transmission/transmission/pull/7958))
* Added an option to verify a torrent immediately after it finishes downloading. ([#4178](https://github.com/transmission/transmission/pull/4178))
* Feat: add stats for known peers, not just connected ones. ([#4900](https://github.com/transmission/transmission/pull/4900))
* Added support for using a proxy server for web connections. ([#5038](https://github.com/transmission/transmission/pull/5038), [#7486](https://github.com/transmission/transmission/pull/7486))
* Added ability to cache IP addresses used in global communications, and use it to fix UDP6 warning log spam. ([#5329](https://github.com/transmission/transmission/pull/5329), [#5510](https://github.com/transmission/transmission/pull/5510))
* Updated the torrent creator's default piece size to handle very large torrents better. ([#5615](https://github.com/transmission/transmission/pull/5615))
* Added support for sending an `ipv4` parameter during the [Extension Protocol handshake](https://www.bittorrent.org/beps/bep_0010.html#handshake-message). ([#5643](https://github.com/transmission/transmission/pull/5643))
* Setting `"cache-size-mb": 0` in `settings.json` now disables the disk write cache. ([#5668](https://github.com/transmission/transmission/pull/5668))
* Improved libtransmission code to use less CPU and RAM. ([#5801](https://github.com/transmission/transmission/pull/5801))
* The WebUI now does separate port checks for IPv4 and IPv6. ([#5953](https://github.com/transmission/transmission/pull/5953))
* Transmission now checks if local files exists after setting torrent location. ([#5978](https://github.com/transmission/transmission/pull/5978))
* Added forced variant of the "Verify Local Data" context menu item to WebUI. ([#5981](https://github.com/transmission/transmission/pull/5981))
* Improved handling of plaintext and MSE handshakes. ([#6025](https://github.com/transmission/transmission/pull/6025))
* If a torrent contains empty (zero byte) files, create them when starting the torrent. ([#6232](https://github.com/transmission/transmission/pull/6232))
* Added optional sequential downloading. ([#6450](https://github.com/transmission/transmission/pull/6450), [#6746](https://github.com/transmission/transmission/pull/6746), [#6893](https://github.com/transmission/transmission/pull/6893), [#7047](https://github.com/transmission/transmission/pull/7047))
* The Qt and GTK Client now does separate port checks for IPv4 and IPv6. ([#6525](https://github.com/transmission/transmission/pull/6525))
* Improved DHT performance. ([#6569](https://github.com/transmission/transmission/pull/6569), [#6695](https://github.com/transmission/transmission/pull/6695))
* Added advanced `sleep-per-seconds-during-verify` setting to `settings.json`. ([#6572](https://github.com/transmission/transmission/pull/6572))
* Improved µTP download performance. ([#6586](https://github.com/transmission/transmission/pull/6586))
* Added support for IPv6 Local Peer Discovery. ([#6700](https://github.com/transmission/transmission/pull/6700))
* Allow port forwarding state to automatically recover from error. ([#6718](https://github.com/transmission/transmission/pull/6718))
* Save upload/download queue order between sessions. ([#6753](https://github.com/transmission/transmission/pull/6753), [#7332](https://github.com/transmission/transmission/pull/7332))
* Added BEP-21 downloader count to `tr_tracker_view` and RPC. ([#6936](https://github.com/transmission/transmission/pull/6936))
* Make client `reqq` configurable. ([#7030](https://github.com/transmission/transmission/pull/7030))
* Daemon log timestamps are now in local ISO8601 format. ([#7057](https://github.com/transmission/transmission/pull/7057))
* Log the reason when the RPC server rejects requests. ([#7114](https://github.com/transmission/transmission/pull/7114))
* Added peer traffic statistics to `torrent-get` rpc method. ([#7172](https://github.com/transmission/transmission/pull/7172))
* Added bytesCompleted field to torrent-get rpc call. ([#7173](https://github.com/transmission/transmission/pull/7173))
* Deprecate `tcp-enabled` and `udp-enabled` in favour of `preferred_transports`. ([#7473](https://github.com/transmission/transmission/pull/7473))
* Added raw PeerID to RPC interface. ([#7514](https://github.com/transmission/transmission/pull/7514))
* IPv4 patterns in the RPC whitelist can now match with IPv4-mapped IPv6 addresses. ([#7523](https://github.com/transmission/transmission/pull/7523))
* `torrent_get.wanted` is now an array of booleans in the JSON-RPC API. ([#7997](https://github.com/transmission/transmission/pull/7997))
* Encryption mode in `settings.json` and RPC are now serialized to the same set of strings. ([#8032](https://github.com/transmission/transmission/pull/8032))
* Fixed crash in `tr_peerMgrPeerStats()`. ([#5279](https://github.com/transmission/transmission/pull/5279))
* Fixed "no such file or directory" warning when adding a magnet link. ([#5426](https://github.com/transmission/transmission/pull/5426))
* Fixed bug that caused the wrong decimal separator to be used in some locales. ([#5444](https://github.com/transmission/transmission/pull/5444))
* Fixed bug in sending torrent metadata to peers. ([#5460](https://github.com/transmission/transmission/pull/5460))
* Fixed filename collision edge case when renaming files. ([#5563](https://github.com/transmission/transmission/pull/5563))
* Fixed locale errors that broke number rounding when displaying statistics, e.g. upload / download ratios. ([#5587](https://github.com/transmission/transmission/pull/5587))
* In RPC responses, change the default sort order of torrents to match Transmission 3.00. ([#5604](https://github.com/transmission/transmission/pull/5604))
* Improved handling of multiple connections from the same IP address. ([#5619](https://github.com/transmission/transmission/pull/5619))
* Always use a fixed-length key query in tracker announces. This isn't required by the [spec](https://www.bittorrent.org/beps/bep_0007.html), but some trackers rely on that fixed length because it's common practice by other BitTorrent clients. ([#5652](https://github.com/transmission/transmission/pull/5652))
* Fixed minor performance bug that caused disk writes to be made in smaller batches than intended. ([#5671](https://github.com/transmission/transmission/pull/5671))
* Fixed potential Windows crash when [getstdhandle()](https://learn.microsoft.com/en-us/windows/console/getstdhandle) returns `NULL`. ([#5675](https://github.com/transmission/transmission/pull/5675))
* Modified LTEP to advertise PEX support more proactively, and added an sanity check for magnet metadata exchange. ([#5783](https://github.com/transmission/transmission/pull/5783))
* Fixed `4.0.0` bug where the port numbers in LPD announces are sometimes malformed. ([#5825](https://github.com/transmission/transmission/pull/5825))
* Fixed a bug that prevented editing the query part of a tracker URL. ([#5871](https://github.com/transmission/transmission/pull/5871))
* Fixed a bug where Transmission may not announce LPD on its listening interface. ([#5875](https://github.com/transmission/transmission/pull/5875))
* Fixed a bug that prevented editing trackers on magnet links. ([#5957](https://github.com/transmission/transmission/pull/5957))
* Fixed HTTP tracker announces and scrapes sometimes failing after adding a torrent file by HTTPS URL. ([#5969](https://github.com/transmission/transmission/pull/5969))
* Fixed blocklist error seen on some Synology devices due to a bug in `tr_sys_path_copy()`. ([#5974](https://github.com/transmission/transmission/pull/5974))
* Run peerMgrPeerStats in session thread. ([#5992](https://github.com/transmission/transmission/pull/5992))
* In some locales, some JSON stirngs were incorrectly escaped. ([#6005](https://github.com/transmission/transmission/pull/6005))
* If there was some disk error with torrent removal, fail with a user readable error message. ([#6055](https://github.com/transmission/transmission/pull/6055))
* Fixed `1.60` bug where low priority torrents behaved as if they had a normal priority. ([#6079](https://github.com/transmission/transmission/pull/6079))
* Fixed `4.0.4` regression that could cause slower downloads when upload speed limits were enabled. ([#6082](https://github.com/transmission/transmission/pull/6082))
* Fixed `4.0.0` bug where the `IP address` field in UDP announces were not encoded in network byte order. [[BEP-15](https://www.bittorrent.org/beps/bep_0015.html)]. ([#6126](https://github.com/transmission/transmission/pull/6126))
* Improved parsing HTTP tracker announce response. ([#6223](https://github.com/transmission/transmission/pull/6223))
* Fixed `4.0.0` bugs where some RPC methods don't put torrents in `recently-active` anymore. ([#6355](https://github.com/transmission/transmission/pull/6355), [#6405](https://github.com/transmission/transmission/pull/6405))
* Fixed error when using mbedtls crypto backend:  "CTR_DRBG - The requested random buffer length is too big". ([#6379](https://github.com/transmission/transmission/pull/6379))
* Fixed `4.0.0` bug that caused some user scripts to have an invalid `TR_TORRENT_TRACKERS` environment variable. ([#6434](https://github.com/transmission/transmission/pull/6434))
* Fixed a couple of logging issues. ([#6463](https://github.com/transmission/transmission/pull/6463))
* Fixed `4.0.0` bug where `alt-speed-enabled` had no effect in `settings.json`. ([#6483](https://github.com/transmission/transmission/pull/6483))
* Fixed `4.0.0` bug where the GTK client's "Use authentication" option was not saved between's sessions. ([#6514](https://github.com/transmission/transmission/pull/6514))
* Fixed `4.0.0` bug where `secondsDownloading` and `secondsSeeding` will be reset when stopping the torrent. ([#6844](https://github.com/transmission/transmission/pull/6844))
* Fixed `4.0.0` bug where the filename for single-file torrents aren't sanitized. ([#6846](https://github.com/transmission/transmission/pull/6846))
* Partial file suffixes will now be updated after torrent verification. ([#6871](https://github.com/transmission/transmission/pull/6871))
* Limit the number of bad pieces to accept from a webseed before banning it. ([#6875](https://github.com/transmission/transmission/pull/6875))
* Fixed a `4.0.0` bug where `2.20`-`3.00` torrent piece timestamps saved in the resume file aren't loaded correctly. ([#6896](https://github.com/transmission/transmission/pull/6896))
* Fixed a bug that could discard BT messages that immediately followed a handshake. ([#6913](https://github.com/transmission/transmission/pull/6913))
* Various bug fixes and improvements related to PEX flags. ([#6917](https://github.com/transmission/transmission/pull/6917))
* Fixed a bug where the turtle icon is active but not effective on starting Transmission. ([#6937](https://github.com/transmission/transmission/pull/6937))
* Fixed a bug where Transmission does not properly reconnect on handshake error. ([#6950](https://github.com/transmission/transmission/pull/6950))
* Fixed edge cases where `date done` and `recently-active` does not get updated after torrent state change. ([#6992](https://github.com/transmission/transmission/pull/6992))
* Fixed a `4.0.0` bug where the tracker error is not cleared when the tracker is removed from the torrent. ([#7141](https://github.com/transmission/transmission/pull/7141))
* Fixed a bug where torrent progress is not properly updated after verifying. ([#7143](https://github.com/transmission/transmission/pull/7143))
* Disconnect blocklisted peers immediately upon blocklist update. ([#7167](https://github.com/transmission/transmission/pull/7167))
* New files are assigned a file mode per the process _umask_ defined in `settings.json`. ([#7195](https://github.com/transmission/transmission/pull/7195))
* Fixed `1.74` bug where resume files are not saved when shutting down Transmission. ([#7216](https://github.com/transmission/transmission/pull/7216))
* Fixed `4.0.0` bug where the download rate of webseeds are double-counted. ([#7235](https://github.com/transmission/transmission/pull/7235))
* Harden the HTTP tracker response parser. ([#7326](https://github.com/transmission/transmission/pull/7326))
* Fixed an issue where the speed limits are not effective below 16KiB/s. ([#7339](https://github.com/transmission/transmission/pull/7339))
* Added workaround for crashes related to [Curl bug 10936](https://github.com/curl/curl/issues/10936). ([#7416](https://github.com/transmission/transmission/pull/7416))
* Sanitize torrent filenames depending on current OS. ([#3823](https://github.com/transmission/transmission/pull/3823))
* Added a workaround for users affected by [Curl bug 6312](https://github.com/curl/curl/issues/6312). ([#7447](https://github.com/transmission/transmission/pull/7447))
* When downloading in sequential mode, flush pieces to disk as soon as they're completed and pass their checksum test. This helps apps that are trying to use the data in realtime, e.g. streaming media. ([#7489](https://github.com/transmission/transmission/pull/7489))
* Respect the `min interval` and `interval` keys from any tracker responses. ([#7493](https://github.com/transmission/transmission/pull/7493))
* Announce port-forwarded peer port instead of local peer port on DHT. ([#7511](https://github.com/transmission/transmission/pull/7511))
* Reject incoming BT data if they are not selected for download. ([#7866](https://github.com/transmission/transmission/pull/7866))
* Fixed intermittent crashes on macOS and GTK app. ([#7948](https://github.com/transmission/transmission/pull/7948))
* Fixed remote RPC bug where querying `recently_active` torrents missed some torrents. ([#8029](https://github.com/transmission/transmission/pull/8029))
* Fixed a bug where the UDP sockets are not rebound after changing the bind addresses. ([#8106](https://github.com/transmission/transmission/pull/8106))
* Fixed potential use-after-free bug when parsing torrent files on macOS. ([#8146](https://github.com/transmission/transmission/pull/8146))
* Fixed a bug where disk IO rate is much higher than transfer rate. ([#7089](https://github.com/transmission/transmission/pull/7089))
* Dropped jsonsl in favour of RapidJSON as our json lexer. ([#6138](https://github.com/transmission/transmission/pull/6138))
* Easier recovery from temporarily missing data files, no longer needing to remove and re-add torrent. ([#6277](https://github.com/transmission/transmission/pull/6277))
* Better utilize high Internet bandwidth. ([#7029](https://github.com/transmission/transmission/pull/7029))
* Renamed setting to `cache_size_mib` to reflect the correct size units. ([#7971](https://github.com/transmission/transmission/pull/7971))
* Renamed `peer_socket_tos` to `peer_socket_diffserv`. ([#8004](https://github.com/transmission/transmission/pull/8004))
* Use a consistent unit formatting code between clients. ([#5108](https://github.com/transmission/transmission/pull/5108))
* Raised minimum OpenSSL version to 1.1.0. ([#6047](https://github.com/transmission/transmission/pull/6047))
* Refactor: add libtransmission::Values. ([#6215](https://github.com/transmission/transmission/pull/6215))
* Fixed building with older versions of CMake. ([#6418](https://github.com/transmission/transmission/pull/6418))
* Support dual stack by manually creating and binding socket on Windows platform. ([#6548](https://github.com/transmission/transmission/pull/6548))
* Fixed building on macOS 10.14.6, 10.15.7 and 11.7. ([#6590](https://github.com/transmission/transmission/pull/6590))
* Added torrent priority to completion script environment variables. ([#6629](https://github.com/transmission/transmission/pull/6629))
* Dropped support for miniupnpc version below `1.7`. ([#6665](https://github.com/transmission/transmission/pull/6665))
* Default initialize sleep callback duration in tr_verify_worker. ([#6789](https://github.com/transmission/transmission/pull/6789))
* Removed TR_ASSERT(now >= latest). ([#7018](https://github.com/transmission/transmission/pull/7018))
* Deprecated the [RPC](https://github.com/transmission/transmission/blob/main/docs/rpc-spec.md) field `torrent-get.manualAnnounceTime`. ([#7497](https://github.com/transmission/transmission/pull/7497))
* Generate imported targets for MbedTLS. ([#7631](https://github.com/transmission/transmission/pull/7631))
* Added support for libevent 2.2.1-alpha-dev. ([#7765](https://github.com/transmission/transmission/pull/7765))
* Deprecated `session_get.rpc_version` and `session_get.rpc_version_minimum` in favour of `session_get.rpc_version_semver` in RPC. ([#8022](https://github.com/transmission/transmission/pull/8022))

### macOS Client

* Added "Show Toolbar" toggle. ([#4419](https://github.com/transmission/transmission/pull/4419))
* Better dark mode support. ([#6101](https://github.com/transmission/transmission/pull/6101), [#6959](https://github.com/transmission/transmission/pull/6959))
* Feat: support redirects to magnet. ([#6012](https://github.com/transmission/transmission/pull/6012))
* Render file tree in QuickLook plugin for .torrent files. ([#6091](https://github.com/transmission/transmission/pull/6091))
* Added an option to set Transmission as the default app for torrent files. ([#6099](https://github.com/transmission/transmission/pull/6099))
* Support pasting multiple magnets on the same line. ([#6465](https://github.com/transmission/transmission/pull/6465))
* Support multiple URL objects from pasteboard. ([#6467](https://github.com/transmission/transmission/pull/6467))
* Feat: clear the badge when quitting app. ([#7088](https://github.com/transmission/transmission/pull/7088))
* Reimplemented QuickLook previews for torrent files with Quick Look preview extension API on macOS 12+. ([#7213](https://github.com/transmission/transmission/pull/7213))
* Use modern macOS APIs to prevent idle system sleep and add support for Low Power Mode. ([#7543](https://github.com/transmission/transmission/pull/7543))
* Fix: apply i18n to percentage values. ([#5568](https://github.com/transmission/transmission/pull/5568))
* Fixed "Unrecognized colorspace number -1" error message. ([#6049](https://github.com/transmission/transmission/pull/6049))
* Fix: URL cleanup in BlocklistDownloader on macOS. ([#6096](https://github.com/transmission/transmission/pull/6096))
* Fixed early truncation of long group names in groups list. ([#6104](https://github.com/transmission/transmission/pull/6104))
* Use screen.visibleFrame instead of screen.frame. ([#6321](https://github.com/transmission/transmission/pull/6321))
* Fixed dock bug that prevented resizing. ([#7188](https://github.com/transmission/transmission/pull/7188))
* Fixed the context menu's appearance in compact mode. ([#7350](https://github.com/transmission/transmission/pull/7350))
* Fixed missing tooltips for Group rows in Torrent Table View. ([#7828](https://github.com/transmission/transmission/pull/7828))
* Fixed re-opening the filter bar is showing an incorrect selected filter. ([#7844](https://github.com/transmission/transmission/pull/7844))
* Fixed Hide Status Bar/Filter Bar never changing to "Show". ([#8170](https://github.com/transmission/transmission/pull/8170))
* Added alternating row color in QuickLook plugin. ([#5216](https://github.com/transmission/transmission/pull/5216))
* Updated app icon for Liquid Glass. ([#7736](https://github.com/transmission/transmission/pull/7736))
* Removing Liquid Glass icons on older Macs. ([#7994](https://github.com/transmission/transmission/pull/7994))
* Added sort-by-ETA option. ([#4169](https://github.com/transmission/transmission/pull/4169))
* Support localized punctuation for "Port:". ([#4452](https://github.com/transmission/transmission/pull/4452))
* Replace mac app default BindPort with a random port. ([#5102](https://github.com/transmission/transmission/pull/5102))
* Updated code that had been using deprecated API. ([#5633](https://github.com/transmission/transmission/pull/5633))
* Support macOS Sonoma when building from sources. ([#6016](https://github.com/transmission/transmission/pull/6016))
* Chore: replace deprecated NSNamePboardType with NSPasteboardTypeName. ([#6107](https://github.com/transmission/transmission/pull/6107))
* Fixed building on macOS Mojave. ([#6180](https://github.com/transmission/transmission/pull/6180))
* Improved macOS UI code to use less CPU. ([#6452](https://github.com/transmission/transmission/pull/6452))
* Fixed app unable to start when having many torrents and TimeMachine enabled. ([#6523](https://github.com/transmission/transmission/pull/6523))
* Support finding Transmission in Spotlight with keywords "torrent" and "magnet". ([#6578](https://github.com/transmission/transmission/pull/6578))
* Removed warning "don't cut off end". ([#6890](https://github.com/transmission/transmission/pull/6890))
* Opt-in to secure coding explicitly. ([#7020](https://github.com/transmission/transmission/pull/7020))
* Added Afrikaans and Greek translations. ([#7477](https://github.com/transmission/transmission/pull/7477))
* Fixed crash when opening the messages log. ([#8035](https://github.com/transmission/transmission/pull/8035))
* Converted TorrentTableView to view based. ([#5147](https://github.com/transmission/transmission/pull/5147))

### Qt Client

* Use native icons for menus and toolbars: SF Symbols on macOS, Segoe Fluent on Windows 11, Segoe MDL2 on Windows 10, and XDG standard icon names everywhere else. ([#7819](https://github.com/transmission/transmission/pull/7819), Qt Client)
* Added ETA to compact view. ([#3926](https://github.com/transmission/transmission/pull/3926))
* Added the web client's Labels feature. ([#6428](https://github.com/transmission/transmission/pull/6428))
* Added the ability to use a custom URL path when connecting to remote Transmission servers. ([#7561](https://github.com/transmission/transmission/pull/7561))
* Added color-coding to progressbars to differentiate torrent states. ([#7756](https://github.com/transmission/transmission/pull/7756))
* Fixed torrent name rendering when showing magnet links in compact view. ([#5491](https://github.com/transmission/transmission/pull/5491))
* Fixed bug that broke the "Move torrent file to trash" setting. ([#5505](https://github.com/transmission/transmission/pull/5505))
* Fixed poor resolution of the app icon. ([#5570](https://github.com/transmission/transmission/pull/5570))
* Fixed compatibility issue with 4.x clients talking to Transmission 3.x servers. ([#6438](https://github.com/transmission/transmission/pull/6438))
* Fixed `4.0.0` bug where piece size description text and slider state in torrent creation dialog were not always up-to-date. ([#6516](https://github.com/transmission/transmission/pull/6516))
* Use semi-transparent color for inactive torrents. ([#6544](https://github.com/transmission/transmission/pull/6544))
* Correct "Queue for download" last activity. ([#6872](https://github.com/transmission/transmission/pull/6872))
* Fixed build script bug that could cause extra instances of Transmission to launch on Windows. ([#7841](https://github.com/transmission/transmission/pull/7841))
* Fixed a Qt API deprecation warning when building with Qt >= 6.13. ([#7940](https://github.com/transmission/transmission/pull/7940))
* Fixed "sequence not ordered" assertion error in debug builds. ([#8000](https://github.com/transmission/transmission/pull/8000))
* Fix: use URL base path. ([#8078](https://github.com/transmission/transmission/pull/8078))
* Fixed spinbox translation ambiguity. ([#5124](https://github.com/transmission/transmission/pull/5124))
* Improved Qt client's accessibility. ([#6518](https://github.com/transmission/transmission/pull/6518), [#6520](https://github.com/transmission/transmission/pull/6520))
* Fix: QT build missing an icon. ([#6683](https://github.com/transmission/transmission/pull/6683))
* Changed Qt client CLI options parsing to accept Qt options as a separate group. ([#7076](https://github.com/transmission/transmission/pull/7076))
* Modified the "New Torrent" dialog's piece size range to [16 KiB..256 MiB]. ([#6211](https://github.com/transmission/transmission/pull/6211))
* Raised the minimum Qt5 version to 5.15. ([#7943](https://github.com/transmission/transmission/pull/7943))

### GTK Client

* Use native file chooser dialogs (GTK client). ([#6545](https://github.com/transmission/transmission/pull/6545))
* Improved GTK client's accessibility. ([#7119](https://github.com/transmission/transmission/pull/7119))
* Adjust slider limits in GTK. ([#7251](https://github.com/transmission/transmission/pull/7251))
* Fixed file list text size adjustment based on global settings. ([#7096](https://github.com/transmission/transmission/pull/7096))
* Fixed missing 'Remove torrent' tooltip. ([#5777](https://github.com/transmission/transmission/pull/5777))
* Fixed crash when opening torrent file from "Recently used" section in GTK 4. ([#6131](https://github.com/transmission/transmission/pull/6131))
* Fixed `4.0.0` regression causing GTK client to hang in some cases. ([#7097](https://github.com/transmission/transmission/pull/7097))
* Setting default behaviour for GTK dialogs to add torrent from url and add tracker. ([#7102](https://github.com/transmission/transmission/pull/7102))
* Updated progressbar colours to match macOS and Web clients. ([#5906](https://github.com/transmission/transmission/pull/5906))
* Added `developer_name` entry to the Flathub build. ([#6596](https://github.com/transmission/transmission/pull/6596))

### Web Client

* Added support for adding torrents by drag-and-drop. ([#5082](https://github.com/transmission/transmission/pull/5082))
* Added high contrast theme. ([#5470](https://github.com/transmission/transmission/pull/5470))
* Replaced background colors with system color keywords to enable using browser's colors. CSS style adjustments esp. for label and buttons. ([#5897](https://github.com/transmission/transmission/pull/5897))
* Added percent digits into the progress bar. ([#5937](https://github.com/transmission/transmission/pull/5937))
* Improved WebUI responsiveness and made quality of life improvements. ([#5947](https://github.com/transmission/transmission/pull/5947))
* Feat: Only show .torrent files in the web UI. ([#6320](https://github.com/transmission/transmission/pull/6320))
* Added separate port checks for IPv4 and IPv6. ([#6607](https://github.com/transmission/transmission/pull/6607))
* Added new options for web client to filter torrents by their privacy or error status. ([#6977](https://github.com/transmission/transmission/pull/6977))
* The inspector can now be hidden by clicking. ([#6863](https://github.com/transmission/transmission/pull/6863))
* Implemented a context menu for file list in web app making way to rename or copy name of individual file. ([#7389](https://github.com/transmission/transmission/pull/7389))
* Added a new alert message of a problem when renaming torrent or file name. ([#7394](https://github.com/transmission/transmission/pull/7394))
* Added accept torrent files in web. ([#7683](https://github.com/transmission/transmission/pull/7683))
* Don't show `null` as a tier name in the inspector's tier list. ([#5462](https://github.com/transmission/transmission/pull/5462))
* Fixed truncated play / pause icons. ([#5771](https://github.com/transmission/transmission/pull/5771))
* Fixed overflow when rendering peer lists and made speed indicators honor `prefers-color-scheme` media queries. ([#5814](https://github.com/transmission/transmission/pull/5814))
* Made the main menu accessible even on smaller displays. ([#5827](https://github.com/transmission/transmission/pull/5827))
* Fixed graying out inspector. ([#5893](https://github.com/transmission/transmission/pull/5893))
* Fixed updating magnet link after selecting same torrent again. ([#6028](https://github.com/transmission/transmission/pull/6028))
* Added seed progress percentage to compact rows. ([#6034](https://github.com/transmission/transmission/pull/6034))
* Fixed `4.0.0` bug where the WebUI "Set Location" dialogue does not auto fill the selected torrent's current download location. ([#6334](https://github.com/transmission/transmission/pull/6334))
* Fixed `4.0.5` bug where svg and png icons in the WebUI might not be displayed. ([#6409](https://github.com/transmission/transmission/pull/6409), [#6430](https://github.com/transmission/transmission/pull/6430))
* Fixed a `4.0.0` bug where the infinite ratio symbol was displayed incorrectly. ([#6491](https://github.com/transmission/transmission/pull/6491))
* Fix(web): pressing the enter key now submits dialogs. ([#7036](https://github.com/transmission/transmission/pull/7036))
* Fixed a bug inflating per-torrent rows by long torrent names in compact view. ([#7336](https://github.com/transmission/transmission/pull/7336))
* Fixed incorrect text entry sensitivity when sessions changed. ([#7346](https://github.com/transmission/transmission/pull/7346))
* Fixed filtering torrents by tracker after a torrent's tracker list is edited. ([#7761](https://github.com/transmission/transmission/pull/7761))
* Removed excessive `session-set` RPC calls related to WebUI preference dialogue. ([#5994](https://github.com/transmission/transmission/pull/5994))
* Removed modifiers for keyboard shortcuts. ([#5331](https://github.com/transmission/transmission/pull/5331))
* Improved some UI styling and spacing. ([#5466](https://github.com/transmission/transmission/pull/5466))
* Updated WebUI progress bar and highlight colours. ([#5762](https://github.com/transmission/transmission/pull/5762))
* Improved the filterbar for narrowed viewports. ([#5828](https://github.com/transmission/transmission/pull/5828))
* Unified CSS shadow properties. ([#5840](https://github.com/transmission/transmission/pull/5840))
* Updated play/pause monochrome icons. ([#5868](https://github.com/transmission/transmission/pull/5868))
* Improved overflow menu for web client. ([#5895](https://github.com/transmission/transmission/pull/5895))
* Added display and time in torrent detail. ([#5918](https://github.com/transmission/transmission/pull/5918))
* Added touchscreen support in the context menu. ([#5928](https://github.com/transmission/transmission/pull/5928))
* Updated turtle for web app. ([#6940](https://github.com/transmission/transmission/pull/6940))
* Added waiting 1/4 seconds of typing in the search bar before executing and a new button to clear the search. ([#6948](https://github.com/transmission/transmission/pull/6948))
* Added checkbox to delete data while removing torrents. ([#7000](https://github.com/transmission/transmission/pull/7000))
* Fixed truncated hash in inspector page, added name section to inspector page. ([#7014](https://github.com/transmission/transmission/pull/7014))
* Added column mode for viewport unconstrained browsers. ([#7051](https://github.com/transmission/transmission/pull/7051))
* Updated gray color for grayed out objects. ([#7248](https://github.com/transmission/transmission/pull/7248))
* Updated displaying number in new gigabyte per second unit. ([#7279](https://github.com/transmission/transmission/pull/7279))
* Fixed an issue where Transmission web's custom context menu does not close when clicking on some outside element. ([#7296](https://github.com/transmission/transmission/pull/7296))
* Implemented a new popup management system for web client to support multiple popups in a hierarchy-like system. ([#7297](https://github.com/transmission/transmission/pull/7297))
* Updated viewport-sensitive layout and style to uniform across browsers of varying viewport. ([#7328](https://github.com/transmission/transmission/pull/7328))
* Increased base font sizes, and progress bar size in compact view. ([#5340](https://github.com/transmission/transmission/pull/5340))
* Use [`esbuild`](https://esbuild.github.io/) to build the web client. ([#6280](https://github.com/transmission/transmission/pull/6280))
* Gave labels to the mainwin buttons for web client. ([#6985](https://github.com/transmission/transmission/pull/6985))

### Daemon

* Added optional sequential downloading. ([#7048](https://github.com/transmission/transmission/pull/7048))
* Added start_paused to settings and daemon. ([#6728](https://github.com/transmission/transmission/pull/6728))
* More accurate timestamps for daemon logs. ([#7009](https://github.com/transmission/transmission/pull/7009))
* Fixed minor memory leak. ([#5695](https://github.com/transmission/transmission/pull/5695))
* Avoid unnecessary heap memory allocations. ([#5724](https://github.com/transmission/transmission/pull/5724))
* Added documentation key to systemd service file. ([#6781](https://github.com/transmission/transmission/pull/6781))
* Use `Type=notify-reload` in the systemd service file. ([#7570](https://github.com/transmission/transmission/pull/7570))
* Included daemon-specific options in the generated `settings.json`. ([#6499](https://github.com/transmission/transmission/pull/6499))
* Updated transmission-daemon.1 to sync with --help. ([#6059](https://github.com/transmission/transmission/pull/6059))
* Deprecated `tcp-enabled` and `udp-enabled` in favour of `preferred_transports`. ([#7988](https://github.com/transmission/transmission/pull/7988))

### transmission-remote

* Added support to download sequentially from a specific piece. This can enable apps to seek within media files for streaming use cases. ([#6454](https://github.com/transmission/transmission/pull/6454), [#7808](https://github.com/transmission/transmission/pull/7808), [#7809](https://github.com/transmission/transmission/pull/7809))
* Implemented idle seeding limits. ([#2947](https://github.com/transmission/transmission/pull/2947))
* `transmission-remote --blocklist-update` now prints blocklist size after update. ([#8021](https://github.com/transmission/transmission/pull/8021))
* Fixed display bug that failed to show some torrent labels. ([#5572](https://github.com/transmission/transmission/pull/5572))
* Fixed crash in printTorrentList. ([#6819](https://github.com/transmission/transmission/pull/6819))
* Improved error logging. ([#7034](https://github.com/transmission/transmission/pull/7034))
* Added 'months' and 'years' to ETA display for extremely slow torrents. ([#5584](https://github.com/transmission/transmission/pull/5584))
* Added default sorting by date added when listing torrents. ([#5608](https://github.com/transmission/transmission/pull/5608))
* Fixed layout bug that caused columns to be misaligned when transfer speed  was >= 10MB. ([#8019](https://github.com/transmission/transmission/pull/8019))
* Exposed the `torrent-get.percentDone` key in transmission-remote. ([#7622](https://github.com/transmission/transmission/pull/7622))
* Deprecated `--(no-)utp` in transmission-remote. ([#7990](https://github.com/transmission/transmission/pull/7990))

### Everything Else

* Improved libtransmission code to use less CPU. ([#5651](https://github.com/transmission/transmission/pull/5651))
* Improved support for building with the NDK on Android. ([#6024](https://github.com/transmission/transmission/pull/6024))
* Ran all PNG files through lossless compressors to make them smaller. ([#5586](https://github.com/transmission/transmission/pull/5586))
* Fixed RPC spec that confused `torrent-get.wanted` with `torrent-get.fileStats.wanted`. ([#6677](https://github.com/transmission/transmission/pull/6677))
* Updated documentation. ([#5565](https://github.com/transmission/transmission/pull/5565), [#5578](https://github.com/transmission/transmission/pull/5578), [#5688](https://github.com/transmission/transmission/pull/5688), [#5702](https://github.com/transmission/transmission/pull/5702), [#5790](https://github.com/transmission/transmission/pull/5790), [#5831](https://github.com/transmission/transmission/pull/5831), [#6037](https://github.com/transmission/transmission/pull/6037), [#6156](https://github.com/transmission/transmission/pull/6156), [#6196](https://github.com/transmission/transmission/pull/6196), [#6199](https://github.com/transmission/transmission/pull/6199), [#6255](https://github.com/transmission/transmission/pull/6255), [#6367](https://github.com/transmission/transmission/pull/6367), [#6391](https://github.com/transmission/transmission/pull/6391), [#6427](https://github.com/transmission/transmission/pull/6427), [#6676](https://github.com/transmission/transmission/pull/6676), [#6703](https://github.com/transmission/transmission/pull/6703), [#6800](https://github.com/transmission/transmission/pull/6800), [#6814](https://github.com/transmission/transmission/pull/6814), [#7120](https://github.com/transmission/transmission/pull/7120), [#7576](https://github.com/transmission/transmission/pull/7576), [#7826](https://github.com/transmission/transmission/pull/7826), [#7829](https://github.com/transmission/transmission/pull/7829), [#7830](https://github.com/transmission/transmission/pull/7830), [#7836](https://github.com/transmission/transmission/pull/7836), [#7840](https://github.com/transmission/transmission/pull/7840), [#8039](https://github.com/transmission/transmission/pull/8039))
* Updated peer-id documentation to account for post-3.00 changes. ([#6083](https://github.com/transmission/transmission/pull/6083))
* Fixed potential build issue when compiling on macOS with gcc. ([#5632](https://github.com/transmission/transmission/pull/5632))
* Build with -latomic on platforms that need it. ([#6774](https://github.com/transmission/transmission/pull/6774))
* Fixed building with mbedtls 3.X. ([#6822](https://github.com/transmission/transmission/pull/6822))
* Configuring Transmission's CMake project no longer inserts third-party submodules to CMake's user package registry. ([#7648](https://github.com/transmission/transmission/pull/7648))
* Bumping libdeflate/small/utfcpp to newer versions. ([#6709](https://github.com/transmission/transmission/pull/6709))
* Bumped fast-float to 6.1.1 and miniupnpc to 2.2.7 and libdeflate to 1.2.0. ([#6721](https://github.com/transmission/transmission/pull/6721))
* Bumped miniupnpc to 2.2.8. ([#6907](https://github.com/transmission/transmission/pull/6907))
* Apply Xcode 26.0 recommendations. ([#7823](https://github.com/transmission/transmission/pull/7823))

## Thank You!

Last but certainly not least, a big ***Thank You*** to these people who contributed to this release:

* @ckerr ([Charles Kerr](https://github.com/ckerr)) - Too many to list
* @tearfur ([Yat Ho](https://github.com/tearfur)) - Too many to list
* @Coeur ([Cœur](https://github.com/Coeur)): [#3823](https://github.com/transmission/transmission/pull/3823), [#4169](https://github.com/transmission/transmission/pull/4169), [#4178](https://github.com/transmission/transmission/pull/4178), [#4419](https://github.com/transmission/transmission/pull/4419), [#4452](https://github.com/transmission/transmission/pull/4452), [#4850](https://github.com/transmission/transmission/pull/4850), [#4876](https://github.com/transmission/transmission/pull/4876), [#4900](https://github.com/transmission/transmission/pull/4900), [#4919](https://github.com/transmission/transmission/pull/4919), [#4931](https://github.com/transmission/transmission/pull/4931), [#5090](https://github.com/transmission/transmission/pull/5090), [#5102](https://github.com/transmission/transmission/pull/5102), [#5108](https://github.com/transmission/transmission/pull/5108), [#5118](https://github.com/transmission/transmission/pull/5118), [#5147](https://github.com/transmission/transmission/pull/5147), [#5216](https://github.com/transmission/transmission/pull/5216), [#5221](https://github.com/transmission/transmission/pull/5221), [#5263](https://github.com/transmission/transmission/pull/5263), [#5282](https://github.com/transmission/transmission/pull/5282), [#5392](https://github.com/transmission/transmission/pull/5392), [#5521](https://github.com/transmission/transmission/pull/5521), [#5568](https://github.com/transmission/transmission/pull/5568), [#5624](https://github.com/transmission/transmission/pull/5624), [#5632](https://github.com/transmission/transmission/pull/5632), [#5633](https://github.com/transmission/transmission/pull/5633), [#5844](https://github.com/transmission/transmission/pull/5844), [#5846](https://github.com/transmission/transmission/pull/5846), [#5856](https://github.com/transmission/transmission/pull/5856), [#5980](https://github.com/transmission/transmission/pull/5980), [#5991](https://github.com/transmission/transmission/pull/5991), [#5992](https://github.com/transmission/transmission/pull/5992), [#6005](https://github.com/transmission/transmission/pull/6005), [#6012](https://github.com/transmission/transmission/pull/6012), [#6016](https://github.com/transmission/transmission/pull/6016), [#6024](https://github.com/transmission/transmission/pull/6024), [#6029](https://github.com/transmission/transmission/pull/6029), [#6053](https://github.com/transmission/transmission/pull/6053), [#6054](https://github.com/transmission/transmission/pull/6054), [#6055](https://github.com/transmission/transmission/pull/6055), [#6082](https://github.com/transmission/transmission/pull/6082), [#6091](https://github.com/transmission/transmission/pull/6091), [#6096](https://github.com/transmission/transmission/pull/6096), [#6099](https://github.com/transmission/transmission/pull/6099), [#6101](https://github.com/transmission/transmission/pull/6101), [#6102](https://github.com/transmission/transmission/pull/6102), [#6104](https://github.com/transmission/transmission/pull/6104), [#6107](https://github.com/transmission/transmission/pull/6107), [#6120](https://github.com/transmission/transmission/pull/6120), [#6180](https://github.com/transmission/transmission/pull/6180), [#6184](https://github.com/transmission/transmission/pull/6184), [#6187](https://github.com/transmission/transmission/pull/6187), [#6196](https://github.com/transmission/transmission/pull/6196), [#6197](https://github.com/transmission/transmission/pull/6197), [#6203](https://github.com/transmission/transmission/pull/6203), [#6207](https://github.com/transmission/transmission/pull/6207), [#6214](https://github.com/transmission/transmission/pull/6214), [#6232](https://github.com/transmission/transmission/pull/6232), [#6242](https://github.com/transmission/transmission/pull/6242), [#6251](https://github.com/transmission/transmission/pull/6251), [#6255](https://github.com/transmission/transmission/pull/6255), [#6290](https://github.com/transmission/transmission/pull/6290), [#6292](https://github.com/transmission/transmission/pull/6292), [#6298](https://github.com/transmission/transmission/pull/6298), [#6299](https://github.com/transmission/transmission/pull/6299), [#6300](https://github.com/transmission/transmission/pull/6300), [#6307](https://github.com/transmission/transmission/pull/6307), [#6311](https://github.com/transmission/transmission/pull/6311), [#6321](https://github.com/transmission/transmission/pull/6321), [#6340](https://github.com/transmission/transmission/pull/6340), [#6364](https://github.com/transmission/transmission/pull/6364), [#6379](https://github.com/transmission/transmission/pull/6379), [#6383](https://github.com/transmission/transmission/pull/6383), [#6391](https://github.com/transmission/transmission/pull/6391), [#6394](https://github.com/transmission/transmission/pull/6394), [#6418](https://github.com/transmission/transmission/pull/6418), [#6452](https://github.com/transmission/transmission/pull/6452), [#6453](https://github.com/transmission/transmission/pull/6453), [#6459](https://github.com/transmission/transmission/pull/6459), [#6465](https://github.com/transmission/transmission/pull/6465), [#6466](https://github.com/transmission/transmission/pull/6466), [#6467](https://github.com/transmission/transmission/pull/6467), [#6470](https://github.com/transmission/transmission/pull/6470), [#6475](https://github.com/transmission/transmission/pull/6475), [#6481](https://github.com/transmission/transmission/pull/6481), [#6484](https://github.com/transmission/transmission/pull/6484), [#6486](https://github.com/transmission/transmission/pull/6486), [#6489](https://github.com/transmission/transmission/pull/6489), [#6523](https://github.com/transmission/transmission/pull/6523), [#6527](https://github.com/transmission/transmission/pull/6527), [#6548](https://github.com/transmission/transmission/pull/6548), [#6562](https://github.com/transmission/transmission/pull/6562), [#6578](https://github.com/transmission/transmission/pull/6578), [#6583](https://github.com/transmission/transmission/pull/6583), [#6585](https://github.com/transmission/transmission/pull/6585), [#6586](https://github.com/transmission/transmission/pull/6586), [#6588](https://github.com/transmission/transmission/pull/6588), [#6590](https://github.com/transmission/transmission/pull/6590), [#6591](https://github.com/transmission/transmission/pull/6591), [#6592](https://github.com/transmission/transmission/pull/6592), [#6599](https://github.com/transmission/transmission/pull/6599), [#6600](https://github.com/transmission/transmission/pull/6600), [#6601](https://github.com/transmission/transmission/pull/6601), [#6602](https://github.com/transmission/transmission/pull/6602), [#6606](https://github.com/transmission/transmission/pull/6606), [#6610](https://github.com/transmission/transmission/pull/6610), [#6611](https://github.com/transmission/transmission/pull/6611), [#6612](https://github.com/transmission/transmission/pull/6612), [#6613](https://github.com/transmission/transmission/pull/6613), [#6614](https://github.com/transmission/transmission/pull/6614), [#6615](https://github.com/transmission/transmission/pull/6615), [#6616](https://github.com/transmission/transmission/pull/6616), [#6617](https://github.com/transmission/transmission/pull/6617), [#6625](https://github.com/transmission/transmission/pull/6625), [#6626](https://github.com/transmission/transmission/pull/6626), [#6629](https://github.com/transmission/transmission/pull/6629), [#6631](https://github.com/transmission/transmission/pull/6631), [#6649](https://github.com/transmission/transmission/pull/6649), [#6665](https://github.com/transmission/transmission/pull/6665), [#6676](https://github.com/transmission/transmission/pull/6676), [#6687](https://github.com/transmission/transmission/pull/6687), [#6690](https://github.com/transmission/transmission/pull/6690), [#6698](https://github.com/transmission/transmission/pull/6698), [#6700](https://github.com/transmission/transmission/pull/6700), [#6702](https://github.com/transmission/transmission/pull/6702), [#6703](https://github.com/transmission/transmission/pull/6703), [#6708](https://github.com/transmission/transmission/pull/6708), [#6709](https://github.com/transmission/transmission/pull/6709), [#6715](https://github.com/transmission/transmission/pull/6715), [#6717](https://github.com/transmission/transmission/pull/6717), [#6718](https://github.com/transmission/transmission/pull/6718), [#6721](https://github.com/transmission/transmission/pull/6721), [#6722](https://github.com/transmission/transmission/pull/6722), [#6723](https://github.com/transmission/transmission/pull/6723), [#6725](https://github.com/transmission/transmission/pull/6725), [#6726](https://github.com/transmission/transmission/pull/6726), [#6728](https://github.com/transmission/transmission/pull/6728), [#6733](https://github.com/transmission/transmission/pull/6733), [#6739](https://github.com/transmission/transmission/pull/6739), [#6743](https://github.com/transmission/transmission/pull/6743), [#6745](https://github.com/transmission/transmission/pull/6745), [#6750](https://github.com/transmission/transmission/pull/6750), [#6753](https://github.com/transmission/transmission/pull/6753), [#6759](https://github.com/transmission/transmission/pull/6759), [#6774](https://github.com/transmission/transmission/pull/6774), [#6784](https://github.com/transmission/transmission/pull/6784), [#6788](https://github.com/transmission/transmission/pull/6788), [#6790](https://github.com/transmission/transmission/pull/6790), [#6791](https://github.com/transmission/transmission/pull/6791), [#6800](https://github.com/transmission/transmission/pull/6800), [#6802](https://github.com/transmission/transmission/pull/6802), [#6814](https://github.com/transmission/transmission/pull/6814), [#6815](https://github.com/transmission/transmission/pull/6815), [#6819](https://github.com/transmission/transmission/pull/6819), [#6822](https://github.com/transmission/transmission/pull/6822), [#6827](https://github.com/transmission/transmission/pull/6827), [#6828](https://github.com/transmission/transmission/pull/6828), [#6834](https://github.com/transmission/transmission/pull/6834), [#6846](https://github.com/transmission/transmission/pull/6846), [#6883](https://github.com/transmission/transmission/pull/6883), [#6890](https://github.com/transmission/transmission/pull/6890), [#6891](https://github.com/transmission/transmission/pull/6891), [#6893](https://github.com/transmission/transmission/pull/6893), [#6896](https://github.com/transmission/transmission/pull/6896), [#6901](https://github.com/transmission/transmission/pull/6901), [#6907](https://github.com/transmission/transmission/pull/6907), [#6908](https://github.com/transmission/transmission/pull/6908), [#6911](https://github.com/transmission/transmission/pull/6911), [#6913](https://github.com/transmission/transmission/pull/6913), [#6918](https://github.com/transmission/transmission/pull/6918), [#6922](https://github.com/transmission/transmission/pull/6922), [#6927](https://github.com/transmission/transmission/pull/6927), [#6946](https://github.com/transmission/transmission/pull/6946), [#6949](https://github.com/transmission/transmission/pull/6949), [#6959](https://github.com/transmission/transmission/pull/6959), [#6975](https://github.com/transmission/transmission/pull/6975), [#6976](https://github.com/transmission/transmission/pull/6976), [#6979](https://github.com/transmission/transmission/pull/6979), [#7018](https://github.com/transmission/transmission/pull/7018), [#7020](https://github.com/transmission/transmission/pull/7020), [#7031](https://github.com/transmission/transmission/pull/7031), [#7032](https://github.com/transmission/transmission/pull/7032), [#7068](https://github.com/transmission/transmission/pull/7068), [#7088](https://github.com/transmission/transmission/pull/7088), [#7169](https://github.com/transmission/transmission/pull/7169), [#7184](https://github.com/transmission/transmission/pull/7184), [#7187](https://github.com/transmission/transmission/pull/7187), [#7188](https://github.com/transmission/transmission/pull/7188), [#7213](https://github.com/transmission/transmission/pull/7213), [#7226](https://github.com/transmission/transmission/pull/7226), [#7238](https://github.com/transmission/transmission/pull/7238), [#7251](https://github.com/transmission/transmission/pull/7251), [#7252](https://github.com/transmission/transmission/pull/7252), [#7254](https://github.com/transmission/transmission/pull/7254), [#7273](https://github.com/transmission/transmission/pull/7273), [#7275](https://github.com/transmission/transmission/pull/7275), [#7457](https://github.com/transmission/transmission/pull/7457), [#7499](https://github.com/transmission/transmission/pull/7499), [#7527](https://github.com/transmission/transmission/pull/7527), [#7535](https://github.com/transmission/transmission/pull/7535), [#7536](https://github.com/transmission/transmission/pull/7536), [#7537](https://github.com/transmission/transmission/pull/7537), [#7538](https://github.com/transmission/transmission/pull/7538), [#7555](https://github.com/transmission/transmission/pull/7555), [#7573](https://github.com/transmission/transmission/pull/7573), [#7576](https://github.com/transmission/transmission/pull/7576), [#7615](https://github.com/transmission/transmission/pull/7615), [#7638](https://github.com/transmission/transmission/pull/7638), [#7738](https://github.com/transmission/transmission/pull/7738), [#7754](https://github.com/transmission/transmission/pull/7754), [#7762](https://github.com/transmission/transmission/pull/7762), [#7763](https://github.com/transmission/transmission/pull/7763), [#7764](https://github.com/transmission/transmission/pull/7764), [#7765](https://github.com/transmission/transmission/pull/7765), [#7783](https://github.com/transmission/transmission/pull/7783), [#7792](https://github.com/transmission/transmission/pull/7792), [#7793](https://github.com/transmission/transmission/pull/7793), [#7795](https://github.com/transmission/transmission/pull/7795), [#7802](https://github.com/transmission/transmission/pull/7802), [#7844](https://github.com/transmission/transmission/pull/7844), [#7948](https://github.com/transmission/transmission/pull/7948), [#7994](https://github.com/transmission/transmission/pull/7994), [#8035](https://github.com/transmission/transmission/pull/8035)
* @dareiff ([Derek Reiff](https://github.com/dareiff)): [#5082](https://github.com/transmission/transmission/pull/5082), [#5340](https://github.com/transmission/transmission/pull/5340), [#5814](https://github.com/transmission/transmission/pull/5814), [#5828](https://github.com/transmission/transmission/pull/5828), [#5868](https://github.com/transmission/transmission/pull/5868), [#5897](https://github.com/transmission/transmission/pull/5897), [#5918](https://github.com/transmission/transmission/pull/5918), [#5921](https://github.com/transmission/transmission/pull/5921), [#5928](https://github.com/transmission/transmission/pull/5928), [#5947](https://github.com/transmission/transmission/pull/5947), [#6008](https://github.com/transmission/transmission/pull/6008), [#6034](https://github.com/transmission/transmission/pull/6034)
* @DevilDimon ([Dmitry Serov](https://github.com/DevilDimon)): [#5090](https://github.com/transmission/transmission/pull/5090), [#5118](https://github.com/transmission/transmission/pull/5118), [#5147](https://github.com/transmission/transmission/pull/5147), [#5221](https://github.com/transmission/transmission/pull/5221), [#6120](https://github.com/transmission/transmission/pull/6120), [#6613](https://github.com/transmission/transmission/pull/6613), [#7213](https://github.com/transmission/transmission/pull/7213), [#7543](https://github.com/transmission/transmission/pull/7543)
* @fxcoudert ([FX Coudert](https://github.com/fxcoudert)): [#5282](https://github.com/transmission/transmission/pull/5282), [#6184](https://github.com/transmission/transmission/pull/6184), [#6206](https://github.com/transmission/transmission/pull/6206), [#6214](https://github.com/transmission/transmission/pull/6214), [#7213](https://github.com/transmission/transmission/pull/7213)
* @livings124 ([Mitch Livingston](https://github.com/livings124)): [#5118](https://github.com/transmission/transmission/pull/5118), [#5263](https://github.com/transmission/transmission/pull/5263), [#5568](https://github.com/transmission/transmission/pull/5568), [#6101](https://github.com/transmission/transmission/pull/6101), [#6121](https://github.com/transmission/transmission/pull/6121), [#6467](https://github.com/transmission/transmission/pull/6467), [#6501](https://github.com/transmission/transmission/pull/6501), [#6611](https://github.com/transmission/transmission/pull/6611), [#6612](https://github.com/transmission/transmission/pull/6612), [#6911](https://github.com/transmission/transmission/pull/6911), [#7321](https://github.com/transmission/transmission/pull/7321), [#7327](https://github.com/transmission/transmission/pull/7327), [#7342](https://github.com/transmission/transmission/pull/7342), [#7350](https://github.com/transmission/transmission/pull/7350), [#7402](https://github.com/transmission/transmission/pull/7402), [#7484](https://github.com/transmission/transmission/pull/7484), [#7499](https://github.com/transmission/transmission/pull/7499), [#7736](https://github.com/transmission/transmission/pull/7736), [#7760](https://github.com/transmission/transmission/pull/7760), [#7769](https://github.com/transmission/transmission/pull/7769), [#7782](https://github.com/transmission/transmission/pull/7782), [#7787](https://github.com/transmission/transmission/pull/7787), [#7790](https://github.com/transmission/transmission/pull/7790), [#7792](https://github.com/transmission/transmission/pull/7792), [#7823](https://github.com/transmission/transmission/pull/7823), [#7824](https://github.com/transmission/transmission/pull/7824), [#7826](https://github.com/transmission/transmission/pull/7826), [#7828](https://github.com/transmission/transmission/pull/7828), [#7829](https://github.com/transmission/transmission/pull/7829), [#7830](https://github.com/transmission/transmission/pull/7830), [#7836](https://github.com/transmission/transmission/pull/7836), [#7840](https://github.com/transmission/transmission/pull/7840), [#7844](https://github.com/transmission/transmission/pull/7844), [#7845](https://github.com/transmission/transmission/pull/7845), [#7994](https://github.com/transmission/transmission/pull/7994), [#8055](https://github.com/transmission/transmission/pull/8055), [#8170](https://github.com/transmission/transmission/pull/8170)
* @mikedld ([Mike Gelfand](https://github.com/mikedld)): [#4931](https://github.com/transmission/transmission/pull/4931), [#5124](https://github.com/transmission/transmission/pull/5124), [#5263](https://github.com/transmission/transmission/pull/5263), [#5308](https://github.com/transmission/transmission/pull/5308), [#5329](https://github.com/transmission/transmission/pull/5329), [#5407](https://github.com/transmission/transmission/pull/5407), [#5444](https://github.com/transmission/transmission/pull/5444), [#5587](https://github.com/transmission/transmission/pull/5587), [#5632](https://github.com/transmission/transmission/pull/5632), [#5702](https://github.com/transmission/transmission/pull/5702), [#5845](https://github.com/transmission/transmission/pull/5845), [#5858](https://github.com/transmission/transmission/pull/5858), [#5866](https://github.com/transmission/transmission/pull/5866), [#5906](https://github.com/transmission/transmission/pull/5906), [#5974](https://github.com/transmission/transmission/pull/5974), [#6005](https://github.com/transmission/transmission/pull/6005), [#6024](https://github.com/transmission/transmission/pull/6024), [#6047](https://github.com/transmission/transmission/pull/6047), [#6055](https://github.com/transmission/transmission/pull/6055), [#6100](https://github.com/transmission/transmission/pull/6100), [#6131](https://github.com/transmission/transmission/pull/6131), [#6186](https://github.com/transmission/transmission/pull/6186), [#6192](https://github.com/transmission/transmission/pull/6192), [#6379](https://github.com/transmission/transmission/pull/6379), [#6418](https://github.com/transmission/transmission/pull/6418), [#6453](https://github.com/transmission/transmission/pull/6453), [#6463](https://github.com/transmission/transmission/pull/6463), [#6475](https://github.com/transmission/transmission/pull/6475), [#6501](https://github.com/transmission/transmission/pull/6501), [#6503](https://github.com/transmission/transmission/pull/6503), [#6505](https://github.com/transmission/transmission/pull/6505), [#6508](https://github.com/transmission/transmission/pull/6508), [#6516](https://github.com/transmission/transmission/pull/6516), [#6518](https://github.com/transmission/transmission/pull/6518), [#6519](https://github.com/transmission/transmission/pull/6519), [#6520](https://github.com/transmission/transmission/pull/6520), [#6521](https://github.com/transmission/transmission/pull/6521), [#6523](https://github.com/transmission/transmission/pull/6523), [#6525](https://github.com/transmission/transmission/pull/6525), [#6544](https://github.com/transmission/transmission/pull/6544), [#6545](https://github.com/transmission/transmission/pull/6545), [#6548](https://github.com/transmission/transmission/pull/6548), [#6583](https://github.com/transmission/transmission/pull/6583), [#6590](https://github.com/transmission/transmission/pull/6590), [#6665](https://github.com/transmission/transmission/pull/6665), [#6668](https://github.com/transmission/transmission/pull/6668), [#6683](https://github.com/transmission/transmission/pull/6683), [#6689](https://github.com/transmission/transmission/pull/6689), [#6726](https://github.com/transmission/transmission/pull/6726), [#6743](https://github.com/transmission/transmission/pull/6743), [#6774](https://github.com/transmission/transmission/pull/6774), [#6798](https://github.com/transmission/transmission/pull/6798), [#6832](https://github.com/transmission/transmission/pull/6832), [#6861](https://github.com/transmission/transmission/pull/6861), [#6874](https://github.com/transmission/transmission/pull/6874), [#6881](https://github.com/transmission/transmission/pull/6881), [#6883](https://github.com/transmission/transmission/pull/6883), [#6890](https://github.com/transmission/transmission/pull/6890), [#6896](https://github.com/transmission/transmission/pull/6896), [#6901](https://github.com/transmission/transmission/pull/6901), [#6907](https://github.com/transmission/transmission/pull/6907), [#6908](https://github.com/transmission/transmission/pull/6908), [#6918](https://github.com/transmission/transmission/pull/6918), [#6919](https://github.com/transmission/transmission/pull/6919), [#6920](https://github.com/transmission/transmission/pull/6920), [#6923](https://github.com/transmission/transmission/pull/6923), [#6927](https://github.com/transmission/transmission/pull/6927), [#6929](https://github.com/transmission/transmission/pull/6929), [#6937](https://github.com/transmission/transmission/pull/6937), [#6947](https://github.com/transmission/transmission/pull/6947), [#6959](https://github.com/transmission/transmission/pull/6959), [#6963](https://github.com/transmission/transmission/pull/6963), [#6976](https://github.com/transmission/transmission/pull/6976), [#6979](https://github.com/transmission/transmission/pull/6979), [#6989](https://github.com/transmission/transmission/pull/6989), [#6990](https://github.com/transmission/transmission/pull/6990), [#6997](https://github.com/transmission/transmission/pull/6997), [#7009](https://github.com/transmission/transmission/pull/7009), [#7020](https://github.com/transmission/transmission/pull/7020), [#7025](https://github.com/transmission/transmission/pull/7025), [#7031](https://github.com/transmission/transmission/pull/7031), [#7032](https://github.com/transmission/transmission/pull/7032), [#7034](https://github.com/transmission/transmission/pull/7034), [#7040](https://github.com/transmission/transmission/pull/7040), [#7044](https://github.com/transmission/transmission/pull/7044), [#7049](https://github.com/transmission/transmission/pull/7049), [#7057](https://github.com/transmission/transmission/pull/7057), [#7059](https://github.com/transmission/transmission/pull/7059), [#7060](https://github.com/transmission/transmission/pull/7060), [#7070](https://github.com/transmission/transmission/pull/7070), [#7076](https://github.com/transmission/transmission/pull/7076), [#7092](https://github.com/transmission/transmission/pull/7092), [#7096](https://github.com/transmission/transmission/pull/7096), [#7097](https://github.com/transmission/transmission/pull/7097), [#7102](https://github.com/transmission/transmission/pull/7102), [#7108](https://github.com/transmission/transmission/pull/7108), [#7113](https://github.com/transmission/transmission/pull/7113), [#7115](https://github.com/transmission/transmission/pull/7115), [#7116](https://github.com/transmission/transmission/pull/7116), [#7117](https://github.com/transmission/transmission/pull/7117), [#7119](https://github.com/transmission/transmission/pull/7119), [#7247](https://github.com/transmission/transmission/pull/7247), [#7251](https://github.com/transmission/transmission/pull/7251), [#7288](https://github.com/transmission/transmission/pull/7288), [#7289](https://github.com/transmission/transmission/pull/7289), [#7359](https://github.com/transmission/transmission/pull/7359), [#7362](https://github.com/transmission/transmission/pull/7362), [#7387](https://github.com/transmission/transmission/pull/7387), [#7408](https://github.com/transmission/transmission/pull/7408), [#7416](https://github.com/transmission/transmission/pull/7416), [#7477](https://github.com/transmission/transmission/pull/7477), [#7486](https://github.com/transmission/transmission/pull/7486), [#7496](https://github.com/transmission/transmission/pull/7496), [#7519](https://github.com/transmission/transmission/pull/7519), [#7527](https://github.com/transmission/transmission/pull/7527), [#7529](https://github.com/transmission/transmission/pull/7529), [#7535](https://github.com/transmission/transmission/pull/7535), [#7536](https://github.com/transmission/transmission/pull/7536), [#7537](https://github.com/transmission/transmission/pull/7537), [#7538](https://github.com/transmission/transmission/pull/7538), [#7549](https://github.com/transmission/transmission/pull/7549), [#7555](https://github.com/transmission/transmission/pull/7555), [#7571](https://github.com/transmission/transmission/pull/7571), [#7575](https://github.com/transmission/transmission/pull/7575), [#7576](https://github.com/transmission/transmission/pull/7576), [#7577](https://github.com/transmission/transmission/pull/7577), [#7578](https://github.com/transmission/transmission/pull/7578), [#7582](https://github.com/transmission/transmission/pull/7582), [#7586](https://github.com/transmission/transmission/pull/7586), [#7588](https://github.com/transmission/transmission/pull/7588), [#7590](https://github.com/transmission/transmission/pull/7590), [#7615](https://github.com/transmission/transmission/pull/7615), [#7638](https://github.com/transmission/transmission/pull/7638), [#7742](https://github.com/transmission/transmission/pull/7742), [#7755](https://github.com/transmission/transmission/pull/7755), [#7756](https://github.com/transmission/transmission/pull/7756), [#7757](https://github.com/transmission/transmission/pull/7757), [#7758](https://github.com/transmission/transmission/pull/7758), [#7768](https://github.com/transmission/transmission/pull/7768), [#7931](https://github.com/transmission/transmission/pull/7931), [#8059](https://github.com/transmission/transmission/pull/8059)
* @nevack ([Dzmitry Neviadomski](https://github.com/nevack)): [#3823](https://github.com/transmission/transmission/pull/3823), [#4178](https://github.com/transmission/transmission/pull/4178), [#4419](https://github.com/transmission/transmission/pull/4419), [#4900](https://github.com/transmission/transmission/pull/4900), [#4919](https://github.com/transmission/transmission/pull/4919), [#4931](https://github.com/transmission/transmission/pull/4931), [#5038](https://github.com/transmission/transmission/pull/5038), [#5090](https://github.com/transmission/transmission/pull/5090), [#5102](https://github.com/transmission/transmission/pull/5102), [#5147](https://github.com/transmission/transmission/pull/5147), [#5263](https://github.com/transmission/transmission/pull/5263), [#5282](https://github.com/transmission/transmission/pull/5282), [#5456](https://github.com/transmission/transmission/pull/5456), [#5521](https://github.com/transmission/transmission/pull/5521), [#5632](https://github.com/transmission/transmission/pull/5632), [#5633](https://github.com/transmission/transmission/pull/5633), [#5833](https://github.com/transmission/transmission/pull/5833), [#5844](https://github.com/transmission/transmission/pull/5844), [#5846](https://github.com/transmission/transmission/pull/5846), [#6012](https://github.com/transmission/transmission/pull/6012), [#6091](https://github.com/transmission/transmission/pull/6091), [#6096](https://github.com/transmission/transmission/pull/6096), [#6099](https://github.com/transmission/transmission/pull/6099), [#6101](https://github.com/transmission/transmission/pull/6101), [#6104](https://github.com/transmission/transmission/pull/6104), [#6106](https://github.com/transmission/transmission/pull/6106), [#6107](https://github.com/transmission/transmission/pull/6107), [#6120](https://github.com/transmission/transmission/pull/6120), [#6121](https://github.com/transmission/transmission/pull/6121), [#6131](https://github.com/transmission/transmission/pull/6131), [#6138](https://github.com/transmission/transmission/pull/6138), [#6177](https://github.com/transmission/transmission/pull/6177), [#6179](https://github.com/transmission/transmission/pull/6179), [#6184](https://github.com/transmission/transmission/pull/6184), [#6187](https://github.com/transmission/transmission/pull/6187), [#6195](https://github.com/transmission/transmission/pull/6195), [#6214](https://github.com/transmission/transmission/pull/6214), [#6219](https://github.com/transmission/transmission/pull/6219), [#6224](https://github.com/transmission/transmission/pull/6224), [#6242](https://github.com/transmission/transmission/pull/6242), [#6258](https://github.com/transmission/transmission/pull/6258), [#6290](https://github.com/transmission/transmission/pull/6290), [#6292](https://github.com/transmission/transmission/pull/6292), [#6299](https://github.com/transmission/transmission/pull/6299), [#6334](https://github.com/transmission/transmission/pull/6334), [#6407](https://github.com/transmission/transmission/pull/6407), [#6418](https://github.com/transmission/transmission/pull/6418), [#6452](https://github.com/transmission/transmission/pull/6452), [#6453](https://github.com/transmission/transmission/pull/6453), [#6459](https://github.com/transmission/transmission/pull/6459), [#6465](https://github.com/transmission/transmission/pull/6465), [#6489](https://github.com/transmission/transmission/pull/6489), [#6523](https://github.com/transmission/transmission/pull/6523), [#6578](https://github.com/transmission/transmission/pull/6578), [#6591](https://github.com/transmission/transmission/pull/6591), [#6600](https://github.com/transmission/transmission/pull/6600), [#6601](https://github.com/transmission/transmission/pull/6601), [#6610](https://github.com/transmission/transmission/pull/6610), [#6611](https://github.com/transmission/transmission/pull/6611), [#6612](https://github.com/transmission/transmission/pull/6612), [#6626](https://github.com/transmission/transmission/pull/6626), [#6665](https://github.com/transmission/transmission/pull/6665), [#6672](https://github.com/transmission/transmission/pull/6672), [#6676](https://github.com/transmission/transmission/pull/6676), [#6698](https://github.com/transmission/transmission/pull/6698), [#6728](https://github.com/transmission/transmission/pull/6728), [#6735](https://github.com/transmission/transmission/pull/6735), [#6739](https://github.com/transmission/transmission/pull/6739), [#6784](https://github.com/transmission/transmission/pull/6784), [#6785](https://github.com/transmission/transmission/pull/6785), [#6786](https://github.com/transmission/transmission/pull/6786), [#6787](https://github.com/transmission/transmission/pull/6787), [#6788](https://github.com/transmission/transmission/pull/6788), [#6789](https://github.com/transmission/transmission/pull/6789), [#6791](https://github.com/transmission/transmission/pull/6791), [#6798](https://github.com/transmission/transmission/pull/6798), [#6832](https://github.com/transmission/transmission/pull/6832), [#6883](https://github.com/transmission/transmission/pull/6883), [#6911](https://github.com/transmission/transmission/pull/6911), [#6923](https://github.com/transmission/transmission/pull/6923), [#6949](https://github.com/transmission/transmission/pull/6949), [#6959](https://github.com/transmission/transmission/pull/6959), [#7088](https://github.com/transmission/transmission/pull/7088), [#7169](https://github.com/transmission/transmission/pull/7169), [#7187](https://github.com/transmission/transmission/pull/7187), [#7188](https://github.com/transmission/transmission/pull/7188), [#7192](https://github.com/transmission/transmission/pull/7192), [#7195](https://github.com/transmission/transmission/pull/7195), [#7213](https://github.com/transmission/transmission/pull/7213), [#7214](https://github.com/transmission/transmission/pull/7214), [#7226](https://github.com/transmission/transmission/pull/7226), [#7233](https://github.com/transmission/transmission/pull/7233), [#7252](https://github.com/transmission/transmission/pull/7252), [#7254](https://github.com/transmission/transmission/pull/7254), [#7266](https://github.com/transmission/transmission/pull/7266), [#7268](https://github.com/transmission/transmission/pull/7268), [#7273](https://github.com/transmission/transmission/pull/7273), [#7383](https://github.com/transmission/transmission/pull/7383), [#7389](https://github.com/transmission/transmission/pull/7389), [#7484](https://github.com/transmission/transmission/pull/7484), [#7489](https://github.com/transmission/transmission/pull/7489), [#7496](https://github.com/transmission/transmission/pull/7496), [#7510](https://github.com/transmission/transmission/pull/7510), [#7519](https://github.com/transmission/transmission/pull/7519), [#7520](https://github.com/transmission/transmission/pull/7520), [#7525](https://github.com/transmission/transmission/pull/7525), [#7526](https://github.com/transmission/transmission/pull/7526), [#7535](https://github.com/transmission/transmission/pull/7535), [#7543](https://github.com/transmission/transmission/pull/7543), [#7549](https://github.com/transmission/transmission/pull/7549), [#7557](https://github.com/transmission/transmission/pull/7557), [#7570](https://github.com/transmission/transmission/pull/7570), [#7588](https://github.com/transmission/transmission/pull/7588), [#7595](https://github.com/transmission/transmission/pull/7595), [#7615](https://github.com/transmission/transmission/pull/7615), [#7638](https://github.com/transmission/transmission/pull/7638), [#7683](https://github.com/transmission/transmission/pull/7683), [#7754](https://github.com/transmission/transmission/pull/7754), [#7760](https://github.com/transmission/transmission/pull/7760), [#7762](https://github.com/transmission/transmission/pull/7762), [#7763](https://github.com/transmission/transmission/pull/7763), [#7787](https://github.com/transmission/transmission/pull/7787), [#7792](https://github.com/transmission/transmission/pull/7792), [#7802](https://github.com/transmission/transmission/pull/7802), [#7810](https://github.com/transmission/transmission/pull/7810), [#7823](https://github.com/transmission/transmission/pull/7823), [#7824](https://github.com/transmission/transmission/pull/7824), [#7825](https://github.com/transmission/transmission/pull/7825), [#7826](https://github.com/transmission/transmission/pull/7826), [#7828](https://github.com/transmission/transmission/pull/7828), [#7829](https://github.com/transmission/transmission/pull/7829), [#7830](https://github.com/transmission/transmission/pull/7830), [#7840](https://github.com/transmission/transmission/pull/7840), [#7845](https://github.com/transmission/transmission/pull/7845), [#7917](https://github.com/transmission/transmission/pull/7917)
* @reardonia ([reardonia](https://github.com/reardonia)): [#6891](https://github.com/transmission/transmission/pull/6891), [#6892](https://github.com/transmission/transmission/pull/6892), [#6901](https://github.com/transmission/transmission/pull/6901), [#6913](https://github.com/transmission/transmission/pull/6913), [#6917](https://github.com/transmission/transmission/pull/6917), [#6918](https://github.com/transmission/transmission/pull/6918), [#6922](https://github.com/transmission/transmission/pull/6922), [#6929](https://github.com/transmission/transmission/pull/6929), [#6936](https://github.com/transmission/transmission/pull/6936), [#6946](https://github.com/transmission/transmission/pull/6946), [#6949](https://github.com/transmission/transmission/pull/6949), [#6950](https://github.com/transmission/transmission/pull/6950), [#6957](https://github.com/transmission/transmission/pull/6957), [#6963](https://github.com/transmission/transmission/pull/6963), [#6966](https://github.com/transmission/transmission/pull/6966), [#6969](https://github.com/transmission/transmission/pull/6969), [#6975](https://github.com/transmission/transmission/pull/6975), [#6976](https://github.com/transmission/transmission/pull/6976), [#6981](https://github.com/transmission/transmission/pull/6981), [#6987](https://github.com/transmission/transmission/pull/6987), [#6992](https://github.com/transmission/transmission/pull/6992), [#7027](https://github.com/transmission/transmission/pull/7027), [#7030](https://github.com/transmission/transmission/pull/7030), [#7089](https://github.com/transmission/transmission/pull/7089), [#7143](https://github.com/transmission/transmission/pull/7143), [#7167](https://github.com/transmission/transmission/pull/7167), [#7177](https://github.com/transmission/transmission/pull/7177), [#7195](https://github.com/transmission/transmission/pull/7195), [#7203](https://github.com/transmission/transmission/pull/7203), [#7204](https://github.com/transmission/transmission/pull/7204), [#7355](https://github.com/transmission/transmission/pull/7355), [#7408](https://github.com/transmission/transmission/pull/7408), [#7489](https://github.com/transmission/transmission/pull/7489), [#7519](https://github.com/transmission/transmission/pull/7519), [#7520](https://github.com/transmission/transmission/pull/7520), [#7525](https://github.com/transmission/transmission/pull/7525), [#7580](https://github.com/transmission/transmission/pull/7580), [#7595](https://github.com/transmission/transmission/pull/7595), [#7638](https://github.com/transmission/transmission/pull/7638), [#7785](https://github.com/transmission/transmission/pull/7785), [#7866](https://github.com/transmission/transmission/pull/7866)
* @Rukario: [#5340](https://github.com/transmission/transmission/pull/5340), [#5827](https://github.com/transmission/transmission/pull/5827), [#5828](https://github.com/transmission/transmission/pull/5828), [#5840](https://github.com/transmission/transmission/pull/5840), [#5857](https://github.com/transmission/transmission/pull/5857), [#5893](https://github.com/transmission/transmission/pull/5893), [#5895](https://github.com/transmission/transmission/pull/5895), [#5897](https://github.com/transmission/transmission/pull/5897), [#5911](https://github.com/transmission/transmission/pull/5911), [#5918](https://github.com/transmission/transmission/pull/5918), [#5921](https://github.com/transmission/transmission/pull/5921), [#5928](https://github.com/transmission/transmission/pull/5928), [#5937](https://github.com/transmission/transmission/pull/5937), [#5947](https://github.com/transmission/transmission/pull/5947), [#6028](https://github.com/transmission/transmission/pull/6028), [#6940](https://github.com/transmission/transmission/pull/6940), [#6945](https://github.com/transmission/transmission/pull/6945), [#6948](https://github.com/transmission/transmission/pull/6948), [#6977](https://github.com/transmission/transmission/pull/6977), [#6985](https://github.com/transmission/transmission/pull/6985), [#7000](https://github.com/transmission/transmission/pull/7000), [#7001](https://github.com/transmission/transmission/pull/7001), [#7003](https://github.com/transmission/transmission/pull/7003), [#7014](https://github.com/transmission/transmission/pull/7014), [#7036](https://github.com/transmission/transmission/pull/7036), [#7037](https://github.com/transmission/transmission/pull/7037), [#7051](https://github.com/transmission/transmission/pull/7051), [#7245](https://github.com/transmission/transmission/pull/7245), [#7248](https://github.com/transmission/transmission/pull/7248), [#7263](https://github.com/transmission/transmission/pull/7263), [#7277](https://github.com/transmission/transmission/pull/7277), [#7279](https://github.com/transmission/transmission/pull/7279), [#7285](https://github.com/transmission/transmission/pull/7285), [#7292](https://github.com/transmission/transmission/pull/7292), [#7296](https://github.com/transmission/transmission/pull/7296), [#7297](https://github.com/transmission/transmission/pull/7297), [#7310](https://github.com/transmission/transmission/pull/7310), [#7311](https://github.com/transmission/transmission/pull/7311), [#7328](https://github.com/transmission/transmission/pull/7328), [#7329](https://github.com/transmission/transmission/pull/7329), [#7336](https://github.com/transmission/transmission/pull/7336), [#7340](https://github.com/transmission/transmission/pull/7340), [#7346](https://github.com/transmission/transmission/pull/7346), [#7352](https://github.com/transmission/transmission/pull/7352), [#7354](https://github.com/transmission/transmission/pull/7354), [#7356](https://github.com/transmission/transmission/pull/7356), [#7358](https://github.com/transmission/transmission/pull/7358), [#7369](https://github.com/transmission/transmission/pull/7369), [#7389](https://github.com/transmission/transmission/pull/7389), [#7394](https://github.com/transmission/transmission/pull/7394), [#7651](https://github.com/transmission/transmission/pull/7651)
* @sweetppro ([SweetPPro](https://github.com/sweetppro)): [#5102](https://github.com/transmission/transmission/pull/5102), [#5147](https://github.com/transmission/transmission/pull/5147), [#5221](https://github.com/transmission/transmission/pull/5221), [#5282](https://github.com/transmission/transmission/pull/5282), [#5844](https://github.com/transmission/transmission/pull/5844), [#5846](https://github.com/transmission/transmission/pull/5846), [#5856](https://github.com/transmission/transmission/pull/5856), [#5991](https://github.com/transmission/transmission/pull/5991), [#6012](https://github.com/transmission/transmission/pull/6012), [#6016](https://github.com/transmission/transmission/pull/6016), [#6053](https://github.com/transmission/transmission/pull/6053), [#6207](https://github.com/transmission/transmission/pull/6207), [#6299](https://github.com/transmission/transmission/pull/6299), [#7763](https://github.com/transmission/transmission/pull/7763), [#7828](https://github.com/transmission/transmission/pull/7828)

* @1100101 ([Frank Aurich](https://github.com/1100101)): [#6177](https://github.com/transmission/transmission/pull/6177)
* @aleasto ([Alessandro Astone](https://github.com/aleasto)): [#7070](https://github.com/transmission/transmission/pull/7070)
* @ananthu-sk ([Ananthu](https://github.com/ananthu-sk)): [#5331](https://github.com/transmission/transmission/pull/5331)
* @andreygursky: [#6232](https://github.com/transmission/transmission/pull/6232), [#6277](https://github.com/transmission/transmission/pull/6277), [#6332](https://github.com/transmission/transmission/pull/6332), [#6572](https://github.com/transmission/transmission/pull/6572)
* @Artoria2e5 ([Mingye Wang](https://github.com/Artoria2e5)): [#6321](https://github.com/transmission/transmission/pull/6321)
* @barracuda156 ([Sergey Fedorov](https://github.com/barracuda156)): [#5632](https://github.com/transmission/transmission/pull/5632)
* @basilefff ([Василий Чай](https://github.com/basilefff)): [#5563](https://github.com/transmission/transmission/pull/5563)
* @beyondcompute ([Evgeny Kulikov](https://github.com/beyondcompute)): [#7844](https://github.com/transmission/transmission/pull/7844)
* @bheesham ([Bheesham Persaud](https://github.com/bheesham)): [#7034](https://github.com/transmission/transmission/pull/7034), [#7036](https://github.com/transmission/transmission/pull/7036)
* @bitigchi ([Emir SARI](https://github.com/bitigchi)): [#5568](https://github.com/transmission/transmission/pull/5568), [#7402](https://github.com/transmission/transmission/pull/7402)
* @cdowen: [#7167](https://github.com/transmission/transmission/pull/7167), [#7172](https://github.com/transmission/transmission/pull/7172), [#7173](https://github.com/transmission/transmission/pull/7173), [#7514](https://github.com/transmission/transmission/pull/7514)
* @chantzish: [#5957](https://github.com/transmission/transmission/pull/5957)
* @ChaseKnowlden ([Chase Knowlden](https://github.com/ChaseKnowlden)): [#7924](https://github.com/transmission/transmission/pull/7924)
* @cleberpereiradasilva ([Cleber Pereira da Silva](https://github.com/cleberpereiradasilva)): [#6120](https://github.com/transmission/transmission/pull/6120)
* @cloppingemu ([cloppingemu](https://github.com/cloppingemu)): [#7102](https://github.com/transmission/transmission/pull/7102), [#7247](https://github.com/transmission/transmission/pull/7247)
* @cmo-pomerium: [#5867](https://github.com/transmission/transmission/pull/5867)
* @dechamps ([Etienne Dechamps](https://github.com/dechamps)): [#7110](https://github.com/transmission/transmission/pull/7110), [#7120](https://github.com/transmission/transmission/pull/7120)
* @dmantipov ([Dmitry Antipov](https://github.com/dmantipov)): [#5552](https://github.com/transmission/transmission/pull/5552)
* @fetzu ([Julien](https://github.com/fetzu)): [#4850](https://github.com/transmission/transmission/pull/4850), [#6195](https://github.com/transmission/transmission/pull/6195), [#6196](https://github.com/transmission/transmission/pull/6196), [#6199](https://github.com/transmission/transmission/pull/6199)
* @flowerey ([flower](https://github.com/flowerey)): [#7627](https://github.com/transmission/transmission/pull/7627), [#7649](https://github.com/transmission/transmission/pull/7649)
* @fredo-47: [#5870](https://github.com/transmission/transmission/pull/5870)
* @frozenpandaman ([eli](https://github.com/frozenpandaman)): [#6753](https://github.com/transmission/transmission/pull/6753)
* @G-Ray ([Geoffrey Bonneville](https://github.com/G-Ray)): [#5675](https://github.com/transmission/transmission/pull/5675), [#6024](https://github.com/transmission/transmission/pull/6024), [#7489](https://github.com/transmission/transmission/pull/7489), [#7502](https://github.com/transmission/transmission/pull/7502)
* @GaryElshaw ([Gary Elshaw](https://github.com/GaryElshaw)): [#5340](https://github.com/transmission/transmission/pull/5340), [#5468](https://github.com/transmission/transmission/pull/5468), [#5473](https://github.com/transmission/transmission/pull/5473), [#5475](https://github.com/transmission/transmission/pull/5475), [#5570](https://github.com/transmission/transmission/pull/5570), [#5624](https://github.com/transmission/transmission/pull/5624), [#5762](https://github.com/transmission/transmission/pull/5762), [#5771](https://github.com/transmission/transmission/pull/5771), [#5777](https://github.com/transmission/transmission/pull/5777), [#5868](https://github.com/transmission/transmission/pull/5868), [#5906](https://github.com/transmission/transmission/pull/5906), [#6102](https://github.com/transmission/transmission/pull/6102), [#6283](https://github.com/transmission/transmission/pull/6283), [#6391](https://github.com/transmission/transmission/pull/6391), [#6696](https://github.com/transmission/transmission/pull/6696)
* @Ghost-chu ([Ghost_chu](https://github.com/Ghost-chu)): [#7172](https://github.com/transmission/transmission/pull/7172)
* @github-advanced-security: [#7514](https://github.com/transmission/transmission/pull/7514)
* @H5117: [#7092](https://github.com/transmission/transmission/pull/7092)
* @herbyuan: [#6548](https://github.com/transmission/transmission/pull/6548)
* @hgy59: [#5974](https://github.com/transmission/transmission/pull/5974)
* @hluup ([Hendrik Luup](https://github.com/hluup)): [#6649](https://github.com/transmission/transmission/pull/6649), [#6656](https://github.com/transmission/transmission/pull/6656), [#6657](https://github.com/transmission/transmission/pull/6657), [#6664](https://github.com/transmission/transmission/pull/6664), [#6675](https://github.com/transmission/transmission/pull/6675)
* @htmltiger: [#7561](https://github.com/transmission/transmission/pull/7561)
* @i0ntempest ([Zhenfu Shi](https://github.com/i0ntempest)): [#5456](https://github.com/transmission/transmission/pull/5456)
* @ile6695 ([Ilkka Kallioniemi](https://github.com/ile6695)): [#5866](https://github.com/transmission/transmission/pull/5866), [#6211](https://github.com/transmission/transmission/pull/6211), [#7252](https://github.com/transmission/transmission/pull/7252), [#7457](https://github.com/transmission/transmission/pull/7457), [#7648](https://github.com/transmission/transmission/pull/7648), [#7664](https://github.com/transmission/transmission/pull/7664)
* @ire4ever1190 ([Jake Leahy](https://github.com/ire4ever1190)): [#6320](https://github.com/transmission/transmission/pull/6320)
* @jemadux ([Klearchos-Angelos Gkountras](https://github.com/jemadux)): [#6030](https://github.com/transmission/transmission/pull/6030)
* @jggimi ([Josh Grosse](https://github.com/jggimi)): [#7195](https://github.com/transmission/transmission/pull/7195), [#7282](https://github.com/transmission/transmission/pull/7282)
* @killemov: [#5082](https://github.com/transmission/transmission/pull/5082), [#5584](https://github.com/transmission/transmission/pull/5584), [#6753](https://github.com/transmission/transmission/pull/6753), [#6828](https://github.com/transmission/transmission/pull/6828), [#6872](https://github.com/transmission/transmission/pull/6872), [#6948](https://github.com/transmission/transmission/pull/6948), [#6977](https://github.com/transmission/transmission/pull/6977), [#7014](https://github.com/transmission/transmission/pull/7014), [#7037](https://github.com/transmission/transmission/pull/7037), [#7047](https://github.com/transmission/transmission/pull/7047), [#7092](https://github.com/transmission/transmission/pull/7092), [#7252](https://github.com/transmission/transmission/pull/7252), [#7269](https://github.com/transmission/transmission/pull/7269), [#7285](https://github.com/transmission/transmission/pull/7285), [#7389](https://github.com/transmission/transmission/pull/7389)
* @klevain: [#5470](https://github.com/transmission/transmission/pull/5470)
* @Kljunas2 ([Miha Korenjak](https://github.com/Kljunas2)): [#5124](https://github.com/transmission/transmission/pull/5124)
* @kmikita: [#5490](https://github.com/transmission/transmission/pull/5490)
* @kra-mo ([Laura Kramolis](https://github.com/kra-mo)): [#5660](https://github.com/transmission/transmission/pull/5660)
* @KyleSanderson ([Kyle Sanderson](https://github.com/KyleSanderson)): [#5396](https://github.com/transmission/transmission/pull/5396), [#7030](https://github.com/transmission/transmission/pull/7030)
* @lajp ([Luukas Pörtfors](https://github.com/lajp)): [#2947](https://github.com/transmission/transmission/pull/2947)
* @LaserEyess: [#3823](https://github.com/transmission/transmission/pull/3823), [#5523](https://github.com/transmission/transmission/pull/5523), [#5525](https://github.com/transmission/transmission/pull/5525), [#5665](https://github.com/transmission/transmission/pull/5665), [#6391](https://github.com/transmission/transmission/pull/6391), [#6407](https://github.com/transmission/transmission/pull/6407)
* @laura240406 ([Laura Kirsch](https://github.com/laura240406)): [#6874](https://github.com/transmission/transmission/pull/6874)
* @lighterowl ([Daniel Kamil Kozar](https://github.com/lighterowl)): [#5578](https://github.com/transmission/transmission/pull/5578)
* @luk1337: [#7115](https://github.com/transmission/transmission/pull/7115)
* @luzpaz: [#5980](https://github.com/transmission/transmission/pull/5980)
* @lvd2: [#5584](https://github.com/transmission/transmission/pull/5584), [#5608](https://github.com/transmission/transmission/pull/5608)
* @lvella ([Lucas Clemente Vella](https://github.com/lvella)): [#6055](https://github.com/transmission/transmission/pull/6055)
* @MaddTheSane ([C.W. Betts](https://github.com/MaddTheSane)): [#7213](https://github.com/transmission/transmission/pull/7213)
* @Managor: [#7559](https://github.com/transmission/transmission/pull/7559)
* @mhadam ([Michael Hadam](https://github.com/mhadam)): [#7387](https://github.com/transmission/transmission/pull/7387)
* @michalsrutek ([Michal Šrůtek](https://github.com/michalsrutek)): [#7289](https://github.com/transmission/transmission/pull/7289)
* @midzer: [#4876](https://github.com/transmission/transmission/pull/4876)
* @miltonmiller7879-cloud ([Milton Miller](https://github.com/miltonmiller7879-cloud)): [#6223](https://github.com/transmission/transmission/pull/6223)
* @mrbass21 ([Jason Beck](https://github.com/mrbass21)): [#6683](https://github.com/transmission/transmission/pull/6683)
* @Mrnikifabio ([Mrnikifabio](https://github.com/Mrnikifabio)): [#6572](https://github.com/transmission/transmission/pull/6572)
* @namoen0301: [#7758](https://github.com/transmission/transmission/pull/7758)
* @NickWick13 ([Nick](https://github.com/NickWick13)): [#5481](https://github.com/transmission/transmission/pull/5481), [#8058](https://github.com/transmission/transmission/pull/8058)
* @niol: [#6774](https://github.com/transmission/transmission/pull/6774), [#6781](https://github.com/transmission/transmission/pull/6781), [#6800](https://github.com/transmission/transmission/pull/6800), [#6863](https://github.com/transmission/transmission/pull/6863), [#7613](https://github.com/transmission/transmission/pull/7613), [#7772](https://github.com/transmission/transmission/pull/7772)
* @nmaggioni ([Niccolò Maggioni](https://github.com/nmaggioni)): [#6629](https://github.com/transmission/transmission/pull/6629)
* @nwezecollins21-alt: [#7359](https://github.com/transmission/transmission/pull/7359)
* @orangepizza: [#6822](https://github.com/transmission/transmission/pull/6822)
* @PHLAK ([Chris Kankiewicz](https://github.com/PHLAK)): [#5700](https://github.com/transmission/transmission/pull/5700)
* @pldubouilh ([Pierre Dubouilh](https://github.com/pldubouilh)): [#4795](https://github.com/transmission/transmission/pull/4795)
* @pudymody ([Federico Scodelaro](https://github.com/pudymody)): [#3926](https://github.com/transmission/transmission/pull/3926)
* @qu1ck: [#6450](https://github.com/transmission/transmission/pull/6450)
* @qzydustin ([Zhenyu Qi](https://github.com/qzydustin)): [#5871](https://github.com/transmission/transmission/pull/5871)
* @rafe-s ([Rafe S.](https://github.com/rafe-s)): [#5737](https://github.com/transmission/transmission/pull/5737), [#6059](https://github.com/transmission/transmission/pull/6059)
* @regdos ([Tomasz Regdos](https://github.com/regdos)): [#7037](https://github.com/transmission/transmission/pull/7037)
* @rodiontsev ([Dmitry Rodiontsev](https://github.com/rodiontsev)): [#7040](https://github.com/transmission/transmission/pull/7040)
* @rsekman ([Robin Seth Ekman](https://github.com/rsekman)): [#5572](https://github.com/transmission/transmission/pull/5572), [#6989](https://github.com/transmission/transmission/pull/6989), [#6990](https://github.com/transmission/transmission/pull/6990), [#7241](https://github.com/transmission/transmission/pull/7241)
* @S-Aarab ([Safouane Aarab](https://github.com/S-Aarab)): [#5466](https://github.com/transmission/transmission/pull/5466)
* @sanapci ([Elek, David](https://github.com/sanapci)): [#7796](https://github.com/transmission/transmission/pull/7796), [#7841](https://github.com/transmission/transmission/pull/7841), [#8000](https://github.com/transmission/transmission/pull/8000), [#8019](https://github.com/transmission/transmission/pull/8019)
* @Schlossgeist ([Nick](https://github.com/Schlossgeist)): [#6428](https://github.com/transmission/transmission/pull/6428), [#6438](https://github.com/transmission/transmission/pull/6438), [#6599](https://github.com/transmission/transmission/pull/6599), [#6619](https://github.com/transmission/transmission/pull/6619)
* @sfan5: [#3823](https://github.com/transmission/transmission/pull/3823), [#5505](https://github.com/transmission/transmission/pull/5505)
* @si14 ([Dan Groshev](https://github.com/si14)): [#6083](https://github.com/transmission/transmission/pull/6083)
* @stefanos82 ([stefanos](https://github.com/stefanos82)): [#5688](https://github.com/transmission/transmission/pull/5688)
* @Terentyev ([Alexander Terentyev](https://github.com/Terentyev)): [#5038](https://github.com/transmission/transmission/pull/5038)
* @TheKhanj ([Pooyan Khanjankhani](https://github.com/TheKhanj)): [#6790](https://github.com/transmission/transmission/pull/6790)
* @ThinkChaos: [#5038](https://github.com/transmission/transmission/pull/5038)
* @tiagoboldt ([Tiago Boldt Sousa](https://github.com/tiagoboldt)): [#5082](https://github.com/transmission/transmission/pull/5082)
* @titer ([Eric Petit](https://github.com/titer)): [#5329](https://github.com/transmission/transmission/pull/5329)
* @tobbez ([Torbjörn Lönnemark](https://github.com/tobbez)): [#6920](https://github.com/transmission/transmission/pull/6920)
* @uglygus: [#7555](https://github.com/transmission/transmission/pull/7555)
* @uranix ([Ivan Tsybulin](https://github.com/uranix)): [#7667](https://github.com/transmission/transmission/pull/7667)
* @userwiths ([Bark](https://github.com/userwiths)): [#7313](https://github.com/transmission/transmission/pull/7313)
* @vchimishuk ([Viacheslav Chimishuk](https://github.com/vchimishuk)): [#2947](https://github.com/transmission/transmission/pull/2947)
* @wegood9 ([pathC](https://github.com/wegood9)): [#7447](https://github.com/transmission/transmission/pull/7447)
* @whyvn ([Julia](https://github.com/whyvn)): [#6872](https://github.com/transmission/transmission/pull/6872)
* @winterheart ([Azamat H. Hackimov](https://github.com/winterheart)): [#7631](https://github.com/transmission/transmission/pull/7631)
* @wjt ([Will Thompson](https://github.com/wjt)): [#5407](https://github.com/transmission/transmission/pull/5407), [#6378](https://github.com/transmission/transmission/pull/6378), [#6596](https://github.com/transmission/transmission/pull/6596), [#6720](https://github.com/transmission/transmission/pull/6720)
* @wrrrzr: [#7683](https://github.com/transmission/transmission/pull/7683)
* @wutzi15 ([Benedikt Bergenthal](https://github.com/wutzi15)): [#6096](https://github.com/transmission/transmission/pull/6096)
* @zorgiepoo ([Zorg](https://github.com/zorgiepoo)): [#5263](https://github.com/transmission/transmission/pull/5263)
