# AWS API Gateway monitoring
Amazon API Gateway is an AWS service for creating, publishing, maintaining, monitoring, and securing REST, HTTP, and WebSocket APIs. SkyWalking leverages [AWS Kinesis Data Firehose receiver](./aws-firehose-receiver.md) to transfer the CloudWatch metrics of API Gateway(HTTP and REST APIs) to
[OpenTelemetry receiver](opentelemetry-receiver.md) and into the [Meter System](./../../concepts-and-designs/mal.md).

### Data flow
1. AWS CloudWatch collect metrics for API Gateway(REST and HTTP APIs), refer to [API Gateway HTTP APIs monitoring with CloudWatch](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-metrics.html) and [API Gateway REST APIs monitoring with CloudWatch](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-metrics-and-dimensions.html)
2. [CloudWatch metric streams](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Metric-Streams.html) stream CloudWatch metrics of API Gateway to AWS Kinesis Data Firehose
3. AWS Kinesis Data Firehose delivery metrics to [AWS Kinesis Data Firehose receiver](./aws-firehose-receiver.md) through the HTTP endpoint

### Set up
1. Enable CloudWatch metrics for API Gateway
2. Create an Amazon Kinesis Data Firehose Delivery Stream, and set [AWS Kinesis Data Firehose receiver](./aws-firehose-receiver.md)'s address as HTTP(s) Destination, refer to [Create Delivery Stream](https://docs.aws.amazon.com/firehose/latest/dev/basic-create.html)
3. Create CloudWatch metric stream, and select the Firehose Delivery Stream which has been created above, set `Select namespaces` to `AWS/ApiGateway`, `Select output format` to `OpenTelemetry 0.7`. refer to [CloudWatch Metric Streams](https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Metric-Streams.html)

### Gateway Monitoring

SkyWalking observes CloudWatch metrics of the AWS API Gateway, which is cataloged as a `LAYER: AWS_GATEWAY` `Service` in the OAP. Meanwhile, the routes would be recognized as `LAYER: AWS_GATEWAY` `endpoint`s

#### Supported Metrics

| Monitoring Panel                    | Unit  | Metric Name                              | Catalog    | Description                                                                                                         | Data Source                                                                                                                                                                                                                                                                                         |
|-------------------------------------|-------|------------------------------------------|------------|---------------------------------------------------------------------------------------------------------------------|-----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------|
| Request Count                       | count | aws_gateway_service_count                | Service    | The total number API requests in a given period.                                                                    | [API Gateway HTTP APIs monitoring with CloudWatch](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-metrics.html) and [API Gateway REST APIs monitoring with CloudWatch](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-metrics-and-dimensions.html) |
| 4xx Count                           | count | aws_gateway_service_4xx                  | Service    | The number of client-side errors captured in a given period.                                                        | [API Gateway HTTP APIs monitoring with CloudWatch](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-metrics.html) and [API Gateway REST APIs monitoring with CloudWatch](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-metrics-and-dimensions.html) |
| 5xx Count                           | count | aws_gateway_service_5xx                  | Service    | The number of server-side errors captured in a given period.                                                        | [API Gateway HTTP APIs monitoring with CloudWatch](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-metrics.html) and [API Gateway REST APIs monitoring with CloudWatch](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-metrics-and-dimensions.html) |
| Request Average Latency             | ms    | aws_gateway_service_latency              | Service    | The time between when API Gateway receives a request from a client and when it returns a response to the client.    | [API Gateway HTTP APIs monitoring with CloudWatch](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-metrics.html) and [API Gateway REST APIs monitoring with CloudWatch](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-metrics-and-dimensions.html) |
| Request Average Integration Latency | ms    | aws_gateway_service_integration_latency  | Service    | The time between when API Gateway relays a request to the backend and when it receives a response from the backend. | [API Gateway HTTP APIs monitoring with CloudWatch](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-metrics.html) and [API Gateway REST APIs monitoring with CloudWatch](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-metrics-and-dimensions.html) |
| Data Processed                      | KB    | aws_gateway_service_data_processed       | Service    | The amount of data processed                                                                                        | [API Gateway HTTP APIs monitoring with CloudWatch](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-metrics.html)                                                                                                                                                              |
| Cache Hit Count Rate                | %     | aws_gateway_service_cache_hit_rate       | Service    | The number of requests served from the API cache                                                                    | [API Gateway REST APIs monitoring with CloudWatch](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-metrics-and-dimensions.html)                                                                                                                                            |
| Cache Miss Count Rate               | %     | aws_gateway_service_cache_miss_rate      | Service    | The number of requests served from the backend                                                                      | [API Gateway REST APIs monitoring with CloudWatch](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-metrics-and-dimensions.html)                                                                                                                                            |
| Request Count                       | count | aws_gateway_endpoint_count               | Endpoint   | The total number API requests in a given period.                                                                    | [API Gateway HTTP APIs monitoring with CloudWatch](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-metrics.html) and [API Gateway REST APIs monitoring with CloudWatch](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-metrics-and-dimensions.html) |
| 4xx Count                           | count | aws_gateway_endpoint_4xx                 | Endpoint   | The number of client-side errors captured in a given period.                                                        | [API Gateway HTTP APIs monitoring with CloudWatch](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-metrics.html) and [API Gateway REST APIs monitoring with CloudWatch](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-metrics-and-dimensions.html) |
| 5xx Count                           | count | aws_gateway_endpoint_5xx                 | Endpoint   | The number of server-side errors captured in a given period.                                                        | [API Gateway HTTP APIs monitoring with CloudWatch](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-metrics.html) and [API Gateway REST APIs monitoring with CloudWatch](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-metrics-and-dimensions.html) |
| Request Average Latency             | ms    | aws_gateway_endpoint_latency             | Endpoint   | The time between when API Gateway receives a request from a client and when it returns a response to the client.    | [API Gateway HTTP APIs monitoring with CloudWatch](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-metrics.html) and [API Gateway REST APIs monitoring with CloudWatch](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-metrics-and-dimensions.html) |
| Request Average Integration Latency | ms    | aws_gateway_endpoint_integration_latency | Endpoint   | The time between when API Gateway relays a request to the backend and when it receives a response from the backend. | [API Gateway HTTP APIs monitoring with CloudWatch](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-metrics.html) and [API Gateway REST APIs monitoring with CloudWatch](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-metrics-and-dimensions.html) |
| Data Processed                      | KB    | aws_gateway_endpoint_data_processed      | Endpoint   | The amount of data processed                                                                                        | [API Gateway HTTP APIs monitoring with CloudWatch](https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-metrics.html)                                                                                                                                                              |
| Cache Hit Count Rate                | %     | aws_gateway_endpoint_cache_hit_rate      | Endpoint   | The number of requests served from the API cache                                                                    | [API Gateway REST APIs monitoring with CloudWatch](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-metrics-and-dimensions.html)                                                                                                                                            |
| Cache Miss Count Rate               | %     | aws_gateway_endpoint_cache_miss_rate     | Endpoint   | The number of requests served from the backend                                                                      | [API Gateway REST APIs monitoring with CloudWatch](https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-metrics-and-dimensions.html)                                                                                                                                            |




### Customizations
You can customize your own metrics/expression/dashboard panel.
The metrics definition and expression rules are found in `/config/otel-rules/aws-gateway/`.
The AWS Cloud EKS dashboard panel configurations are found in `/config/ui-initialized-templates/aws_gateway`.
