/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.query.zipkin.handler;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.google.gson.Gson;
import com.google.protobuf.InvalidProtocolBufferException;
import com.linecorp.armeria.common.AggregatedHttpResponse;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.ResponseHeadersBuilder;
import com.linecorp.armeria.server.annotation.Blocking;
import com.linecorp.armeria.server.annotation.Default;
import com.linecorp.armeria.server.annotation.ExceptionHandler;
import com.linecorp.armeria.server.annotation.Get;
import com.linecorp.armeria.server.annotation.Param;
import io.vavr.Tuple;
import io.vavr.Tuple2;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.skywalking.apm.network.common.v3.KeyIntValuePair;
import org.apache.skywalking.apm.network.common.v3.KeyStringValuePair;
import org.apache.skywalking.apm.network.language.agent.v3.SpanAttachedEvent;
import org.apache.skywalking.oap.query.zipkin.ZipkinQueryConfig;
import org.apache.skywalking.oap.query.zipkin.handler.ZipkinQueryExceptionHandler;
import org.apache.skywalking.oap.server.core.analysis.manual.searchtag.TagType;
import org.apache.skywalking.oap.server.core.analysis.manual.spanattach.SpanAttachedEventRecord;
import org.apache.skywalking.oap.server.core.analysis.manual.spanattach.SpanAttachedEventTraceType;
import org.apache.skywalking.oap.server.core.query.TagAutoCompleteQueryService;
import org.apache.skywalking.oap.server.core.query.enumeration.Step;
import org.apache.skywalking.oap.server.core.query.type.debugging.DebuggingSpan;
import org.apache.skywalking.oap.server.core.query.type.debugging.DebuggingTraceContext;
import org.apache.skywalking.oap.server.core.storage.query.ISpanAttachedEventQueryDAO;
import org.apache.skywalking.oap.server.core.storage.query.IZipkinQueryDAO;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.apache.skywalking.oap.server.library.util.CollectionUtils;
import org.apache.skywalking.oap.server.library.util.StringUtil;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.nodes.Tag;
import zipkin2.Span;
import zipkin2.codec.SpanBytesEncoder;
import zipkin2.storage.QueryRequest;

@ExceptionHandler(value=ZipkinQueryExceptionHandler.class)
public class ZipkinQueryHandler {
    private final ZipkinQueryConfig config;
    private final ModuleManager moduleManager;
    private IZipkinQueryDAO zipkinQueryDAO;
    private ISpanAttachedEventQueryDAO spanAttachedEventQueryDAO;
    private TagAutoCompleteQueryService tagQueryService;
    private final long defaultLookback;
    private final int namesMaxAge;
    private static final Gson GSON = new Gson();
    volatile int serviceCount;

    public ZipkinQueryHandler(ZipkinQueryConfig config, ModuleManager moduleManager) {
        this.config = config;
        this.moduleManager = moduleManager;
        this.defaultLookback = config.getLookback();
        this.namesMaxAge = config.getNamesMaxAge();
    }

    private IZipkinQueryDAO getZipkinQueryDAO() {
        if (this.zipkinQueryDAO == null) {
            this.zipkinQueryDAO = (IZipkinQueryDAO)this.moduleManager.find("storage").provider().getService(IZipkinQueryDAO.class);
        }
        return this.zipkinQueryDAO;
    }

    private TagAutoCompleteQueryService getTagQueryService() {
        if (this.tagQueryService == null) {
            this.tagQueryService = (TagAutoCompleteQueryService)this.moduleManager.find("core").provider().getService(TagAutoCompleteQueryService.class);
        }
        return this.tagQueryService;
    }

    private ISpanAttachedEventQueryDAO getSpanAttachedEventQueryDAO() {
        if (this.spanAttachedEventQueryDAO == null) {
            this.spanAttachedEventQueryDAO = (ISpanAttachedEventQueryDAO)this.moduleManager.find("storage").provider().getService(ISpanAttachedEventQueryDAO.class);
        }
        return this.spanAttachedEventQueryDAO;
    }

    @Get(value="/config.json")
    @Blocking
    public AggregatedHttpResponse getUIConfig() throws IOException {
        StringWriter writer = new StringWriter();
        JsonGenerator generator = new JsonFactory().createGenerator((Writer)writer);
        generator.writeStartObject();
        generator.writeStringField("environment", this.config.getUiEnvironment());
        generator.writeNumberField("queryLimit", this.config.getUiQueryLimit());
        generator.writeNumberField("defaultLookback", this.config.getUiDefaultLookback());
        generator.writeBooleanField("searchEnabled", this.config.isUiSearchEnabled());
        generator.writeObjectFieldStart("dependency");
        generator.writeBooleanField("enabled", false);
        generator.writeEndObject();
        generator.writeEndObject();
        generator.close();
        return AggregatedHttpResponse.of((HttpStatus)HttpStatus.OK, (MediaType)MediaType.JSON, (HttpData)HttpData.ofUtf8((String)writer.toString()));
    }

    @Get(value="/api/v2/services")
    @Blocking
    public AggregatedHttpResponse getServiceNames() throws IOException {
        List serviceNames = this.getZipkinQueryDAO().getServiceNames();
        this.serviceCount = serviceNames.size();
        return this.cachedResponse(this.serviceCount > 3, serviceNames);
    }

    @Get(value="/api/v2/remoteServices")
    @Blocking
    public AggregatedHttpResponse getRemoteServiceNames(@Param(value="serviceName") String serviceName) throws IOException {
        List remoteServiceNames = this.getZipkinQueryDAO().getRemoteServiceNames(serviceName);
        return this.cachedResponse(this.serviceCount > 3, remoteServiceNames);
    }

    @Get(value="/api/v2/spans")
    @Blocking
    public AggregatedHttpResponse getSpanNames(@Param(value="serviceName") String serviceName) throws IOException {
        List spanNames = this.getZipkinQueryDAO().getSpanNames(serviceName);
        return this.cachedResponse(this.serviceCount > 3, spanNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Get(value="/api/v2/trace/{traceId}")
    @Blocking
    public AggregatedHttpResponse getTraceById(@Param(value="traceId") String traceId) throws IOException {
        AggregatedHttpResponse aggregatedHttpResponse;
        block10: {
            List trace;
            DebuggingSpan debuggingSpan;
            DebuggingTraceContext traceContext;
            block8: {
                AggregatedHttpResponse aggregatedHttpResponse2;
                block9: {
                    block6: {
                        AggregatedHttpResponse aggregatedHttpResponse3;
                        block7: {
                            traceContext = (DebuggingTraceContext)DebuggingTraceContext.TRACE_CONTEXT.get();
                            debuggingSpan = null;
                            try {
                                StringBuilder builder = new StringBuilder();
                                if (traceContext != null) {
                                    builder.append("Condition: traceId: ").append(traceId);
                                    debuggingSpan = traceContext.createSpan("Query /api/v2/trace/{traceId}");
                                    debuggingSpan.setMsg(builder.toString());
                                }
                                if (!StringUtil.isEmpty((String)traceId)) break block6;
                                aggregatedHttpResponse3 = AggregatedHttpResponse.of((HttpStatus)HttpStatus.BAD_REQUEST, (MediaType)MediaType.ANY_TEXT_TYPE, (String)"traceId is empty or null");
                                if (traceContext == null || debuggingSpan == null) break block7;
                            }
                            catch (Throwable throwable) {
                                if (traceContext != null && debuggingSpan != null) {
                                    traceContext.stopSpan(debuggingSpan);
                                }
                                throw throwable;
                            }
                            traceContext.stopSpan(debuggingSpan);
                        }
                        return aggregatedHttpResponse3;
                    }
                    trace = this.getZipkinQueryDAO().getTraceDebuggable(Span.normalizeTraceId((String)traceId.trim()));
                    if (!CollectionUtils.isEmpty((List)trace)) break block8;
                    aggregatedHttpResponse2 = AggregatedHttpResponse.of((HttpStatus)HttpStatus.NOT_FOUND, (MediaType)MediaType.ANY_TEXT_TYPE, (String)(traceId + " not found"));
                    if (traceContext == null || debuggingSpan == null) break block9;
                    traceContext.stopSpan(debuggingSpan);
                }
                return aggregatedHttpResponse2;
            }
            this.appendEventsDebuggable(trace, this.getSpanAttachedEventQueryDAO().querySpanAttachedEventsDebuggable(SpanAttachedEventTraceType.ZIPKIN, Arrays.asList(traceId)));
            aggregatedHttpResponse = this.response(SpanBytesEncoder.JSON_V2.encodeList(trace));
            if (traceContext == null || debuggingSpan == null) break block10;
            traceContext.stopSpan(debuggingSpan);
        }
        return aggregatedHttpResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Get(value="/api/v2/traces")
    @Blocking
    public AggregatedHttpResponse getTraces(@Param(value="serviceName") Optional<String> serviceName, @Param(value="remoteServiceName") Optional<String> remoteServiceName, @Param(value="spanName") Optional<String> spanName, @Param(value="annotationQuery") Optional<String> annotationQuery, @Param(value="minDuration") Optional<Long> minDuration, @Param(value="maxDuration") Optional<Long> maxDuration, @Param(value="endTs") Optional<Long> endTs, @Param(value="lookback") Optional<Long> lookback, @Default(value="10") @Param(value="limit") int limit) throws IOException {
        AggregatedHttpResponse aggregatedHttpResponse;
        block4: {
            QueryRequest queryRequest = QueryRequest.newBuilder().serviceName((String)serviceName.orElse(null)).remoteServiceName((String)remoteServiceName.orElse(null)).spanName((String)spanName.orElse(null)).parseAnnotationQuery((String)annotationQuery.orElse(null)).minDuration((Long)minDuration.orElse(null)).maxDuration((Long)maxDuration.orElse(null)).endTs(endTs.orElse(System.currentTimeMillis()).longValue()).lookback(lookback.orElse(this.defaultLookback).longValue()).limit(limit).build();
            DebuggingTraceContext traceContext = (DebuggingTraceContext)DebuggingTraceContext.TRACE_CONTEXT.get();
            DebuggingSpan debuggingSpan = null;
            try {
                StringBuilder builder = new StringBuilder();
                if (traceContext != null) {
                    builder.append("Condition: QueryRequest: ").append(queryRequest);
                    debuggingSpan = traceContext.createSpan("Query /api/v2/traces");
                    debuggingSpan.setMsg(builder.toString());
                }
                org.apache.skywalking.oap.server.core.query.input.Duration duration = new org.apache.skywalking.oap.server.core.query.input.Duration();
                duration.setStep(Step.SECOND);
                DateTime endTime = new DateTime(queryRequest.endTs());
                DateTime startTime = endTime.minus((ReadableDuration)Duration.millis((long)queryRequest.lookback()));
                duration.setStart(startTime.toString("yyyy-MM-dd HHmmss"));
                duration.setEnd(endTime.toString("yyyy-MM-dd HHmmss"));
                List traces = this.getZipkinQueryDAO().getTracesDebuggable(queryRequest, duration);
                this.appendEventsToTracesDebuggable(traces);
                aggregatedHttpResponse = this.response(this.encodeTraces(traces));
                if (traceContext == null || debuggingSpan == null) break block4;
            }
            catch (Throwable throwable) {
                if (traceContext != null && debuggingSpan != null) {
                    traceContext.stopSpan(debuggingSpan);
                }
                throw throwable;
            }
            traceContext.stopSpan(debuggingSpan);
        }
        return aggregatedHttpResponse;
    }

    @Get(value="/api/v2/traceMany")
    @Blocking
    public AggregatedHttpResponse getTracesByIds(@Param(value="traceIds") String traceIds) throws IOException {
        String[] traceIdsArr;
        if (StringUtil.isEmpty((String)traceIds)) {
            return AggregatedHttpResponse.of((HttpStatus)HttpStatus.BAD_REQUEST, (MediaType)MediaType.ANY_TEXT_TYPE, (String)"traceIds is empty or null");
        }
        LinkedHashSet<String> normalizeTraceIds = new LinkedHashSet<String>();
        for (String traceId : traceIdsArr = traceIds.split(",", 1000)) {
            if (normalizeTraceIds.add(Span.normalizeTraceId((String)traceId.trim()))) continue;
            return AggregatedHttpResponse.of((HttpStatus)HttpStatus.BAD_REQUEST, (MediaType)MediaType.ANY_TEXT_TYPE, (String)("traceId: " + traceId + " duplicate "));
        }
        List traces = this.getZipkinQueryDAO().getTraces(normalizeTraceIds);
        this.appendEventsToTraces(traces);
        return this.response(this.encodeTraces(traces));
    }

    @Get(value="/api/v2/autocompleteKeys")
    @Blocking
    public AggregatedHttpResponse getAutocompleteKeys() throws IOException {
        org.apache.skywalking.oap.server.core.query.input.Duration duration = new org.apache.skywalking.oap.server.core.query.input.Duration();
        duration.setStep(Step.SECOND);
        DateTime endTime = DateTime.now();
        DateTime startTime = endTime.minus((ReadableDuration)Duration.millis((long)this.defaultLookback));
        duration.setStart(startTime.toString("yyyy-MM-dd HHmmss"));
        duration.setEnd(endTime.toString("yyyy-MM-dd HHmmss"));
        Set autocompleteKeys = this.getTagQueryService().queryTagAutocompleteKeys(TagType.ZIPKIN, duration);
        return this.cachedResponse(true, new ArrayList<String>(autocompleteKeys));
    }

    @Get(value="/api/v2/autocompleteValues")
    @Blocking
    public AggregatedHttpResponse getAutocompleteValues(@Param(value="key") String key) throws IOException {
        org.apache.skywalking.oap.server.core.query.input.Duration duration = new org.apache.skywalking.oap.server.core.query.input.Duration();
        duration.setStep(Step.SECOND);
        DateTime endTime = DateTime.now();
        DateTime startTime = endTime.minus((ReadableDuration)Duration.millis((long)this.defaultLookback));
        duration.setStart(startTime.toString("yyyy-MM-dd HHmmss"));
        duration.setEnd(endTime.toString("yyyy-MM-dd HHmmss"));
        Set autocompleteValues = this.getTagQueryService().queryTagAutocompleteValues(TagType.ZIPKIN, key, duration);
        return this.cachedResponse(autocompleteValues.size() > 3, new ArrayList<String>(autocompleteValues));
    }

    private AggregatedHttpResponse response(byte[] body) {
        return AggregatedHttpResponse.of((ResponseHeaders)ResponseHeaders.builder((HttpStatus)HttpStatus.OK).contentType(MediaType.JSON).build(), (HttpData)HttpData.wrap((byte[])body));
    }

    private AggregatedHttpResponse cachedResponse(boolean shouldCache, List<String> values) {
        Collections.sort(values);
        ResponseHeadersBuilder headers = ResponseHeaders.builder((HttpStatus)HttpStatus.OK).contentType(MediaType.JSON);
        if (shouldCache) {
            headers = headers.add((CharSequence)HttpHeaderNames.CACHE_CONTROL, "max-age=" + this.namesMaxAge + ", must-revalidate");
        }
        return AggregatedHttpResponse.of((ResponseHeaders)headers.build(), (HttpData)HttpData.ofUtf8((String)GSON.toJson(values)));
    }

    private byte[] encodeTraces(List<List<Span>> traces) {
        if (CollectionUtils.isEmpty(traces)) {
            return new byte[]{91, 93};
        }
        ArrayList<byte[]> encodedTraces = new ArrayList<byte[]>(traces.size());
        int tracesSize = traces.size();
        int length = 0;
        for (List<Span> trace : traces) {
            byte[] traceByte = SpanBytesEncoder.JSON_V2.encodeList(trace);
            encodedTraces.add(traceByte);
            length += traceByte.length;
        }
        byte[] allByteArray = new byte[length + 2 + traces.size() - 1];
        ByteBuffer buff = ByteBuffer.wrap(allByteArray);
        buff.put((byte)91);
        for (int i = 0; i < tracesSize; ++i) {
            buff.put((byte[])encodedTraces.get(i));
            if (i >= tracesSize - 1) continue;
            buff.put((byte)44);
        }
        buff.put((byte)93);
        return buff.array();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendEventsToTracesDebuggable(List<List<Span>> traces) throws IOException {
        DebuggingTraceContext traceContext = (DebuggingTraceContext)DebuggingTraceContext.TRACE_CONTEXT.get();
        DebuggingSpan debuggingSpan = null;
        try {
            if (traceContext != null) {
                debuggingSpan = traceContext.createSpan("Query: appendEventsToTraces");
            }
            this.appendEventsToTraces(traces);
        }
        finally {
            if (traceContext != null && debuggingSpan != null) {
                traceContext.stopSpan(debuggingSpan);
            }
        }
    }

    private void appendEventsToTraces(List<List<Span>> traces) throws IOException {
        Map traceIdWithSpans = traces.stream().filter(CollectionUtils::isNotEmpty).collect(Collectors.toMap(s -> ((Span)s.get(0)).traceId(), Function.identity(), (s1, s2) -> s1));
        if (CollectionUtils.isEmpty(traceIdWithSpans)) {
            return;
        }
        List records = this.getSpanAttachedEventQueryDAO().querySpanAttachedEventsDebuggable(SpanAttachedEventTraceType.ZIPKIN, new ArrayList<String>(traceIdWithSpans.keySet()));
        Map<String, List<SpanAttachedEventRecord>> traceEvents = records.stream().collect(Collectors.groupingBy(SpanAttachedEventRecord::getRelatedTraceId));
        for (Map.Entry<String, List<SpanAttachedEventRecord>> entry : traceEvents.entrySet()) {
            this.appendEventsDebuggable((List)traceIdWithSpans.get(entry.getKey()), entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendEventsDebuggable(List<Span> spans, List<SpanAttachedEventRecord> events) throws InvalidProtocolBufferException {
        DebuggingTraceContext traceContext = (DebuggingTraceContext)DebuggingTraceContext.TRACE_CONTEXT.get();
        DebuggingSpan debuggingSpan = null;
        try {
            if (traceContext != null) {
                debuggingSpan = traceContext.createSpan("Query: appendEvents");
            }
            this.appendEvents(spans, events);
        }
        finally {
            if (traceContext != null && debuggingSpan != null) {
                traceContext.stopSpan(debuggingSpan);
            }
        }
    }

    private void appendEvents(List<Span> spans, List<SpanAttachedEventRecord> events) throws InvalidProtocolBufferException {
        if (CollectionUtils.isEmpty(spans) || CollectionUtils.isEmpty(events)) {
            return;
        }
        List spanWithIndex = IntStream.range(0, spans.size()).mapToObj(i -> Tuple.of((Object)i, (Object)((Span)spans.get(i)))).collect(Collectors.toList());
        events.sort((e1, e2) -> {
            int second = Long.compare(e1.getStartTimeSecond(), e2.getStartTimeSecond());
            if (second == 0) {
                return Long.compare(e1.getStartTimeNanos(), e2.getStartTimeNanos());
            }
            return second;
        });
        Map namedEvents = events.stream().collect(Collectors.groupingBy(SpanAttachedEventRecord::getEvent, Collectors.toList()));
        HashMap<String, Tuple2> spanCache = new HashMap<String, Tuple2>();
        for (Map.Entry entry : namedEvents.entrySet()) {
            for (int i2 = 1; i2 <= entry.getValue().size(); ++i2) {
                SpanAttachedEventRecord record = (SpanAttachedEventRecord)entry.getValue().get(i2 - 1);
                String eventName = record.getEvent() + (String)(entry.getValue().size() == 1 ? "" : "-" + i2);
                SpanAttachedEvent event = SpanAttachedEvent.parseFrom((byte[])record.getDataBinary());
                Tuple2 spanBuilder = (Tuple2)spanCache.get(record.getTraceSpanId());
                if (spanBuilder == null) {
                    Tuple2 matchesSpan = spanWithIndex.stream().filter(s -> Objects.equals(((Span)s._2).id(), record.getTraceSpanId())).findFirst().orElse(null);
                    if (matchesSpan == null) continue;
                    String direction = this.getSpanAttachedEventTagValue(event.getTagsList(), "data_direction");
                    String type = this.getSpanAttachedEventTagValue(event.getTagsList(), "data_type");
                    if ("request".equals(type) && "inbound".equals(direction) || "response".equals(type) && "outbound".equals(direction)) {
                        String parentSpanId = ((Span)matchesSpan._2).id();
                        matchesSpan = spanWithIndex.stream().filter(s -> Objects.equals(((Span)s._2).parentId(), parentSpanId) && Objects.equals(((Span)s._2).kind(), Span.Kind.SERVER)).findFirst().orElse(matchesSpan);
                    }
                    spanBuilder = Tuple.of((Object)((Span)matchesSpan._2).toBuilder(), (Object)((Integer)matchesSpan._1));
                    spanCache.put(record.getTraceSpanId(), spanBuilder);
                }
                this.appendEventDebuggable((Span.Builder)spanBuilder._1, eventName, event);
            }
        }
        for (Map.Entry<String, List<Object>> entry : spanCache.entrySet()) {
            spans.set((Integer)((Tuple2)entry.getValue())._2, ((Span.Builder)((Tuple2)entry.getValue())._1).build());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendEventDebuggable(Span.Builder span, String eventName, SpanAttachedEvent event) {
        DebuggingTraceContext traceContext = (DebuggingTraceContext)DebuggingTraceContext.TRACE_CONTEXT.get();
        DebuggingSpan debuggingSpan = null;
        try {
            if (traceContext != null) {
                debuggingSpan = traceContext.createSpan("Query : appendEvent");
            }
            this.appendEvent(span, eventName, event);
        }
        finally {
            if (traceContext != null && debuggingSpan != null) {
                traceContext.stopSpan(debuggingSpan);
            }
        }
    }

    private void appendEvent(Span.Builder span, String eventName, SpanAttachedEvent event) {
        String summary;
        span.addAnnotation(TimeUnit.SECONDS.toMicros(event.getStartTime().getSeconds()) + TimeUnit.NANOSECONDS.toMicros(event.getStartTime().getNanos()), "Start " + eventName);
        span.addAnnotation(TimeUnit.SECONDS.toMicros(event.getEndTime().getSeconds()) + TimeUnit.NANOSECONDS.toMicros(event.getEndTime().getNanos()), "Finished " + eventName);
        Yaml yaml = new Yaml();
        if (event.getSummaryList().size() > 0) {
            Map<String, Long> summaries = event.getSummaryList().stream().collect(Collectors.toMap(KeyIntValuePair::getKey, KeyIntValuePair::getValue, (s1, s2) -> s1));
            summary = yaml.dumpAs(summaries, Tag.MAP, DumperOptions.FlowStyle.AUTO);
            span.putTag(this.formatEventTagKey(eventName + ".summary"), summary);
        }
        if (event.getTagsList().size() > 0) {
            Map<String, String> tags = event.getTagsList().stream().collect(Collectors.toMap(KeyStringValuePair::getKey, KeyStringValuePair::getValue, (s1, s2) -> s1));
            summary = yaml.dumpAs(tags, Tag.MAP, DumperOptions.FlowStyle.AUTO);
            span.putTag(this.formatEventTagKey(eventName + ".tags"), summary);
        }
    }

    private String formatEventTagKey(String name) {
        return name.replaceAll(" ", ".").toLowerCase(Locale.ROOT);
    }

    private String getSpanAttachedEventTagValue(List<KeyStringValuePair> values, String tagKey) {
        for (KeyStringValuePair pair : values) {
            if (!Objects.equals(pair.getKey(), tagKey)) continue;
            return pair.getValue();
        }
        return null;
    }
}

