/* mechinfo.c --- Definition of SCRAM mechanism.
 * Copyright (C) 2009-2025 Simon Josefsson
 *
 * This file is part of GNU SASL Library.
 *
 * GNU SASL Library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * GNU SASL Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with GNU SASL Library; if not, see
 * <https://www.gnu.org/licenses/>.
 *
 */

#include <config.h>

/* Get specification. */
#include "scram.h"

#ifdef USE_SCRAM_SHA1
Gsasl_mechanism _gsasl_scram_sha1_mechanism = {
  GSASL_SCRAM_SHA1_NAME,
  {
   NULL,
   NULL,
# ifdef USE_CLIENT
   _gsasl_scram_sha1_client_start,
   _gsasl_scram_client_step,
   _gsasl_scram_client_finish,
# else
   NULL,
   NULL,
   NULL,
# endif
   NULL,
   NULL}
  ,
  {
   NULL,
   NULL,
# ifdef USE_SERVER
   _gsasl_scram_sha1_server_start,
   _gsasl_scram_server_step,
   _gsasl_scram_server_finish,
# else
   NULL,
   NULL,
   NULL,
# endif
   NULL,
   NULL}
};
#endif


#ifdef USE_SCRAM_SHA1
Gsasl_mechanism _gsasl_scram_sha1_plus_mechanism = {
  GSASL_SCRAM_SHA1_PLUS_NAME,
  {
   NULL,
   NULL,
# ifdef USE_CLIENT
   _gsasl_scram_sha1_plus_client_start,
   _gsasl_scram_client_step,
   _gsasl_scram_client_finish,
# else
   NULL,
   NULL,
   NULL,
# endif
   NULL,
   NULL}
  ,
  {
   NULL,
   NULL,
# ifdef USE_SERVER
   _gsasl_scram_sha1_plus_server_start,
   _gsasl_scram_server_step,
   _gsasl_scram_server_finish,
# else
   NULL,
   NULL,
   NULL,
# endif
   NULL,
   NULL}
};
#endif

#ifdef USE_SCRAM_SHA256
Gsasl_mechanism _gsasl_scram_sha256_mechanism = {
  GSASL_SCRAM_SHA256_NAME,
  {
   NULL,
   NULL,
# ifdef USE_CLIENT
   _gsasl_scram_sha256_client_start,
   _gsasl_scram_client_step,
   _gsasl_scram_client_finish,
# else
   NULL,
   NULL,
   NULL,
# endif
   NULL,
   NULL}
  ,
  {
   NULL,
   NULL,
# ifdef USE_SERVER
   _gsasl_scram_sha256_server_start,
   _gsasl_scram_server_step,
   _gsasl_scram_server_finish,
# else
   NULL,
   NULL,
   NULL,
# endif
   NULL,
   NULL}
};
#endif


#ifdef USE_SCRAM_SHA256
Gsasl_mechanism _gsasl_scram_sha256_plus_mechanism = {
  GSASL_SCRAM_SHA256_PLUS_NAME,
  {
   NULL,
   NULL,
# ifdef USE_CLIENT
   _gsasl_scram_sha256_plus_client_start,
   _gsasl_scram_client_step,
   _gsasl_scram_client_finish,
# else
   NULL,
   NULL,
   NULL,
# endif
   NULL,
   NULL}
  ,
  {
   NULL,
   NULL,
# ifdef USE_SERVER
   _gsasl_scram_sha256_plus_server_start,
   _gsasl_scram_server_step,
   _gsasl_scram_server_finish,
# else
   NULL,
   NULL,
   NULL,
# endif
   NULL,
   NULL}
};
#endif
