# -*- Mode: makefile-gmake; tab-width: 4; indent-tabs-mode: t -*-
#
# This file is part of the LibreOffice project.
#
# This Source Code Form is subject to the terms of the Mozilla Public
# License, v. 2.0. If a copy of the MPL was not distributed with this
# file, You can obtain one at http://mozilla.org/MPL/2.0/.
#

##############################
# DotnetLibrary Target Class #
##############################

####### Constant Strings #########

gb_DotnetLibrary_CS := cs
gb_DotnetLibrary_FS := fs
gb_DotnetLibrary_VB := vb

####### Build and Clean Targets #########

# Template for a target to generate the project file for a DotnetLibrary
define gb_DotnetLibrary__project_target
$$(gb_DotnetLibrary_$(1)_project) :
	$$(shell mkdir -p $$(dir $$@))
	$$(file  >$$@,<Project Sdk="Microsoft.NET.Sdk">)
	$$(file >>$$@,<PropertyGroup>)
	$$(file >>$$@,$$(DOTNET_PROPERTY_ELEMENTS))
	$$(file >>$$@,</PropertyGroup>)
	$$(file >>$$@,<ItemGroup>)
	$$(file >>$$@,$$(DOTNET_ITEM_ELEMENTS))
	$$(file >>$$@,</ItemGroup>)
	$$(file >>$$@,</Project>)

endef

# Template for a target to build a DotnetLibrary
define gb_DotnetLibrary__build_target
$$(call gb_DotnetLibrary_get_target,$(1)) : $$(gb_DotnetLibrary_$(1)_project)
	$$(call gb_Output_announce,$(1),$(true),NET,4)
	$$(call gb_Trace_StartRange,$(1),NET)
	$$(call gb_Helper_abbreviate_dirs,\
		$$(call gb_Helper_print_on_error,\
			"$$(DOTNET)" build $$< $$(DOTNET_BUILD_FLAGS) -o $$(dir $$@),\
			$$(gb_DotnetLibrary_workdir)/$(1)/log))
	$$(call gb_Trace_EndRange,$(1),NET)

endef

# Template for a target to clean a DotnetLibrary
define gb_DotnetLibrary__clean_target
$$(call gb_DotnetLibrary_get_clean_target,$(1)) :
	$$(call gb_Output_announce,$(1),$(false),NET,4)
	$$(call gb_Helper_abbreviate_dirs,\
		rm -rf $$(gb_DotnetLibrary_$(1)_project) $$(call gb_DotnetLibrary_get_target,$(1)))

endef

####### Library Target Constructor #########

# Generates one project file for the given language, instantiating 
# the project file, build and clean targets from above templates
# call gb_DotnetLibrary_DotnetLibrary,targetname,language
define gb_DotnetLibrary_DotnetLibrary
gb_DotnetLibrary_$(1)_language := $(2)
gb_DotnetLibrary_$(1)_project := $(gb_DotnetLibrary_workdir)/$(1)/$(1).$(2)proj

$$(gb_DotnetLibrary_$(1)_project) : DOTNET_PROPERTY_ELEMENTS := <TargetFramework>netstandard2.0</TargetFramework> 
$$(gb_DotnetLibrary_$(1)_project) : DOTNET_PROPERTY_ELEMENTS += <AssemblyName>$(1)</AssemblyName>
$$(gb_DotnetLibrary_$(1)_project) : DOTNET_ITEM_ELEMENTS :=
$$(eval $$(call gb_DotnetLibrary__project_target,$(1)))

$$(call gb_DotnetLibrary_get_target,$(1)) : DOTNET_BUILD_FLAGS := $(if $(ENABLE_DEBUG),-c Debug,-c Release)
$$(eval $$(call gb_DotnetLibrary__build_target,$(1)))

.PHONY : $$(call gb_DotnetLibrary_get_clean_target,$(1))
$$(eval $$(call gb_DotnetLibrary__clean_target,$(1)))

$$(eval $$(call gb_Module_register_target, \
	$(call gb_DotnetLibrary_get_target,$(1)), \
	$(call gb_DotnetLibrary_get_clean_target,$(1))))
$(call gb_Helper_make_userfriendly_targets,$(1),DotnetLibrary)

endef

####### Target Property Setters #########

# Add flags used for compilation
# call gb_DotnetLibrary_add_build_flags,target,flags
define gb_DotnetLibrary_add_build_flags
$(call gb_DotnetLibrary_get_target,$(1)) : DOTNET_BUILD_FLAGS += $(2)

endef

# Add <PropertyGroup> elements to the project file
# call gb_DotnetLibrary_add_properties,target,properties
define gb_DotnetLibrary_add_properties
$(gb_DotnetLibrary_$(1)_project) : DOTNET_PROPERTY_ELEMENTS += $(2)

endef

# Add <ItemGroup> elements to the project file
# call gb_DotnetLibrary_add_items,target,items
define gb_DotnetLibrary_add_items
$(gb_DotnetLibrary_$(1)_project) : DOTNET_ITEM_ELEMENTS += $(2)

endef

# Add one source file to the project file
# This adds it to the project, and makes it a build dependency
# so the library is rebuilt if the source changes
# call gb_DotnetLibrary_add_source,target,source
define gb_DotnetLibrary_add_source
$(gb_DotnetLibrary_$(1)_project) : $(SRCDIR)/$(2).$(gb_DotnetLibrary_$(1)_language)
$(call gb_DotnetLibrary_add_items,$(1),<Compile Include="$(SRCDIR)/$(2).$(gb_DotnetLibrary_$(1)_language)"/>)

endef

# Add source files to the project file
# This adds them to the project, and makes it them build dependency
# so the library is rebuilt if the sources change
# call gb_DotnetLibrary_add_sources,target,sources
define gb_DotnetLibrary_add_sources
$(foreach source,$(2),$(call gb_DotnetLibrary_add_source,$(1),$(source)))

endef

# Add source files generated by the given CustomTarget.
# This adds the CustomTarget as a build dependency
# so if the CustomTarget is rebuilt, this library is too.
# call gb_DotnetLibrary_use_customtarget,target,customtarget
define gb_DotnetLibrary_use_customtarget
$(gb_DotnetLibrary_$(1)_project) : $(call gb_CustomTarget_get_target,$(2))
$(call gb_DotnetLibrary_add_items,$(1),<Compile Include="$(gb_CustomTarget_workdir)/$(2)/**/*.$(gb_DotnetLibrary_$(1)_language)"/>)

endef

# Link to another DotnetLibrary target
# call gb_DotnetLibrary_link_library,target,library
define gb_DotnetLibrary_link_library
$(gb_DotnetLibrary_$(1)_project) : $(call gb_DotnetLibrary_get_target,$(2))
$(call gb_DotnetLibrary_add_items,$(1),<ProjectReference Include="$(gb_DotnetLibrary_$(2)_project)"/>)

endef

# vim: set noet sw=4 ts=4:
