/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontology.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.enhanced.EnhNode;
import org.apache.jena.enhanced.Implementation;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.ontology.AllDifferent;
import org.apache.jena.ontology.AnnotationProperty;
import org.apache.jena.ontology.ConversionException;
import org.apache.jena.ontology.DataRange;
import org.apache.jena.ontology.DatatypeProperty;
import org.apache.jena.ontology.Individual;
import org.apache.jena.ontology.ObjectProperty;
import org.apache.jena.ontology.OntClass;
import org.apache.jena.ontology.OntModel;
import org.apache.jena.ontology.OntProperty;
import org.apache.jena.ontology.OntResource;
import org.apache.jena.ontology.Ontology;
import org.apache.jena.ontology.OntologyException;
import org.apache.jena.ontology.Profile;
import org.apache.jena.ontology.ProfileException;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.NodeIterator;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.rdf.model.impl.NodeIteratorImpl;
import org.apache.jena.rdf.model.impl.RDFListImpl;
import org.apache.jena.rdf.model.impl.ResourceImpl;
import org.apache.jena.reasoner.InfGraph;
import org.apache.jena.reasoner.ReasonerRegistry;
import org.apache.jena.shared.JenaException;
import org.apache.jena.shared.PropertyNotFoundException;
import org.apache.jena.util.ResourceUtils;
import org.apache.jena.util.iterator.ClosableIterator;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.util.iterator.UniqueFilter;
import org.apache.jena.util.iterator.WrappedIterator;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;
import org.apache.jena.vocabulary.ReasonerVocabulary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OntResourceImpl
extends ResourceImpl
implements OntResource {
    public static final String[] KNOWN_LANGUAGES = new String[]{"http://www.w3.org/2002/07/owl#", RDF.getURI(), RDFS.getURI(), "http://www.w3.org/2001/XMLSchema"};
    public static Implementation factory = new Implementation(){

        @Override
        public EnhNode wrap(Node n, EnhGraph eg) {
            if (this.canWrap(n, eg)) {
                return new OntResourceImpl(n, eg);
            }
            throw new ConversionException("Cannot convert node " + n.toString() + " to OntResource");
        }

        @Override
        public boolean canWrap(Node node, EnhGraph eg) {
            return node.isURI() || node.isBlank();
        }
    };
    private static final Logger log = LoggerFactory.getLogger(OntResourceImpl.class);

    public OntResourceImpl(Node n, EnhGraph g) {
        super(n, g);
    }

    @Override
    public OntModel getOntModel() {
        Model m = this.getModel();
        return m instanceof OntModel ? (OntModel)m : null;
    }

    @Override
    public Profile getProfile() {
        try {
            return ((OntModel)this.getModel()).getProfile();
        }
        catch (ClassCastException e) {
            throw new JenaException("Resource " + this.toString() + " is not attached to an OntModel, so cannot access its language profile");
        }
    }

    @Override
    public boolean isOntLanguageTerm() {
        if (!this.isAnon()) {
            for (String KNOWN_LANGUAGE : KNOWN_LANGUAGES) {
                if (!this.getURI().startsWith(KNOWN_LANGUAGE)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void setSameAs(Resource res) {
        this.setPropertyValue(this.getProfile().SAME_AS(), "SAME_AS", res);
    }

    @Override
    public void addSameAs(Resource res) {
        this.addPropertyValue(this.getProfile().SAME_AS(), "SAME_AS", res);
    }

    @Override
    public OntResource getSameAs() {
        return this.objectAsResource(this.getProfile().SAME_AS(), "SAME_AS");
    }

    public ExtendedIterator<OntResource> listSameAs() {
        return this.listAs(this.getProfile().SAME_AS(), "SAME_AS", OntResource.class);
    }

    @Override
    public boolean isSameAs(Resource res) {
        return this.hasPropertyValue(this.getProfile().SAME_AS(), "SAME_AS", res);
    }

    @Override
    public void removeSameAs(Resource res) {
        this.removePropertyValue(this.getProfile().SAME_AS(), "SAME_AS", res);
    }

    @Override
    public void setDifferentFrom(Resource res) {
        this.setPropertyValue(this.getProfile().DIFFERENT_FROM(), "DIFFERENT_FROM", res);
    }

    @Override
    public void addDifferentFrom(Resource res) {
        this.addPropertyValue(this.getProfile().DIFFERENT_FROM(), "DIFFERENT_FROM", res);
    }

    @Override
    public OntResource getDifferentFrom() {
        return this.objectAsResource(this.getProfile().DIFFERENT_FROM(), "DIFFERENT_FROM");
    }

    public ExtendedIterator<OntResource> listDifferentFrom() {
        return this.listAs(this.getProfile().DIFFERENT_FROM(), "DIFFERENT_FROM", OntResource.class);
    }

    @Override
    public boolean isDifferentFrom(Resource res) {
        return this.hasPropertyValue(this.getProfile().DIFFERENT_FROM(), "DIFFERENT_FROM", res);
    }

    @Override
    public void removeDifferentFrom(Resource res) {
        this.removePropertyValue(this.getProfile().DIFFERENT_FROM(), "DIFFERENT_FROM", res);
    }

    @Override
    public void setSeeAlso(Resource res) {
        this.setPropertyValue(this.getProfile().SEE_ALSO(), "SEE_ALSO", res);
    }

    @Override
    public void addSeeAlso(Resource res) {
        this.addPropertyValue(this.getProfile().SEE_ALSO(), "SEE_ALSO", res);
    }

    @Override
    public Resource getSeeAlso() {
        return this.objectAsResource(this.getProfile().SEE_ALSO(), "SEE_ALSO");
    }

    @Override
    public ExtendedIterator<RDFNode> listSeeAlso() {
        this.checkProfile(this.getProfile().SEE_ALSO(), "SEE_ALSO");
        return WrappedIterator.create(this.listProperties(this.getProfile().SEE_ALSO())).mapWith(s -> OntResourceImpl.asOntResource(s.getObject()));
    }

    @Override
    public boolean hasSeeAlso(Resource res) {
        return this.hasPropertyValue(this.getProfile().SEE_ALSO(), "SEE_ALSO", res);
    }

    @Override
    public void removeSeeAlso(Resource res) {
        this.removePropertyValue(this.getProfile().SEE_ALSO(), "SEE_ALSO", res);
    }

    @Override
    public void setIsDefinedBy(Resource res) {
        this.setPropertyValue(this.getProfile().IS_DEFINED_BY(), "IS_DEFINED_BY", res);
    }

    @Override
    public void addIsDefinedBy(Resource res) {
        this.addPropertyValue(this.getProfile().IS_DEFINED_BY(), "IS_DEFINED_BY", res);
    }

    @Override
    public Resource getIsDefinedBy() {
        return this.objectAsResource(this.getProfile().IS_DEFINED_BY(), "IS_DEFINED_BY");
    }

    @Override
    public ExtendedIterator<RDFNode> listIsDefinedBy() {
        this.checkProfile(this.getProfile().IS_DEFINED_BY(), "IS_DEFINED_BY");
        return WrappedIterator.create(this.listProperties(this.getProfile().IS_DEFINED_BY())).mapWith(s -> OntResourceImpl.asOntResource(s.getObject()));
    }

    @Override
    public boolean isDefinedBy(Resource res) {
        return this.hasPropertyValue(this.getProfile().IS_DEFINED_BY(), "IS_DEFINED_BY", res);
    }

    @Override
    public void removeDefinedBy(Resource res) {
        this.removePropertyValue(this.getProfile().IS_DEFINED_BY(), "IS_DEFINED_BY", res);
    }

    @Override
    public void setVersionInfo(String info) {
        this.checkProfile(this.getProfile().VERSION_INFO(), "VERSION_INFO");
        this.removeAll(this.getProfile().VERSION_INFO());
        this.addVersionInfo(info);
    }

    @Override
    public void addVersionInfo(String info) {
        this.checkProfile(this.getProfile().VERSION_INFO(), "VERSION_INFO");
        this.addProperty(this.getProfile().VERSION_INFO(), this.getModel().createLiteral(info));
    }

    @Override
    public String getVersionInfo() {
        this.checkProfile(this.getProfile().VERSION_INFO(), "VERSION_INFO");
        try {
            return this.getRequiredProperty(this.getProfile().VERSION_INFO()).getString();
        }
        catch (PropertyNotFoundException ignore) {
            return null;
        }
    }

    @Override
    public ExtendedIterator<String> listVersionInfo() {
        this.checkProfile(this.getProfile().VERSION_INFO(), "VERSION_INFO");
        return WrappedIterator.create(this.listProperties(this.getProfile().VERSION_INFO())).mapWith(s -> s.getString());
    }

    @Override
    public boolean hasVersionInfo(String info) {
        this.checkProfile(this.getProfile().VERSION_INFO(), "VERSION_INFO");
        return this.hasProperty(this.getProfile().VERSION_INFO(), info);
    }

    @Override
    public void removeVersionInfo(String info) {
        this.checkProfile(this.getProfile().VERSION_INFO(), "VERSION_INFO");
        Literal infoAsLiteral = ResourceFactory.createPlainLiteral(info);
        this.getModel().remove(this, this.getProfile().VERSION_INFO(), infoAsLiteral);
    }

    @Override
    public void setLabel(String label, String lang) {
        this.checkProfile(this.getProfile().LABEL(), "LABEL");
        this.removeAll(this.getProfile().LABEL());
        this.addLabel(label, lang);
    }

    @Override
    public void addLabel(String label, String lang) {
        this.addLabel(this.getModel().createLiteral(label, lang));
    }

    @Override
    public void addLabel(Literal label) {
        this.addPropertyValue(this.getProfile().LABEL(), "LABEL", label);
    }

    @Override
    public String getLabel(String lang) {
        this.checkProfile(this.getProfile().LABEL(), "LABEL");
        if (lang == null || lang.length() == 0) {
            try {
                return this.getRequiredProperty(this.getProfile().LABEL()).getString();
            }
            catch (PropertyNotFoundException ignore) {
                return null;
            }
        }
        return this.selectLang(this.listProperties(this.getProfile().LABEL()), lang);
    }

    @Override
    public ExtendedIterator<RDFNode> listLabels(String lang) {
        this.checkProfile(this.getProfile().LABEL(), "LABEL");
        return WrappedIterator.create(this.listProperties(this.getProfile().LABEL())).filterKeep(new LangTagFilter(lang)).mapWith(s -> s.getObject());
    }

    @Override
    public boolean hasLabel(String label, String lang) {
        return this.hasLabel(this.getModel().createLiteral(label, lang));
    }

    @Override
    public boolean hasLabel(Literal label) {
        boolean found = false;
        ExtendedIterator<RDFNode> i = this.listLabels(label.getLanguage());
        while (!found && i.hasNext()) {
            found = label.equals(i.next());
        }
        i.close();
        return found;
    }

    @Override
    public void removeLabel(String label, String lang) {
        this.removeLabel(this.getModel().createLiteral(label, lang));
    }

    @Override
    public void removeLabel(Literal label) {
        this.removePropertyValue(this.getProfile().LABEL(), "LABEL", label);
    }

    @Override
    public void setComment(String comment, String lang) {
        this.checkProfile(this.getProfile().COMMENT(), "COMMENT");
        this.removeAll(this.getProfile().COMMENT());
        this.addComment(comment, lang);
    }

    @Override
    public void addComment(String comment, String lang) {
        this.addComment(this.getModel().createLiteral(comment, lang));
    }

    @Override
    public void addComment(Literal comment) {
        this.checkProfile(this.getProfile().COMMENT(), "COMMENT");
        this.addProperty(this.getProfile().COMMENT(), comment);
    }

    @Override
    public String getComment(String lang) {
        this.checkProfile(this.getProfile().COMMENT(), "COMMENT");
        if (lang == null) {
            try {
                return this.getRequiredProperty(this.getProfile().COMMENT()).getString();
            }
            catch (PropertyNotFoundException ignore) {
                return null;
            }
        }
        return this.selectLang(this.listProperties(this.getProfile().COMMENT()), lang);
    }

    @Override
    public ExtendedIterator<RDFNode> listComments(String lang) {
        this.checkProfile(this.getProfile().COMMENT(), "COMMENT");
        return WrappedIterator.create(this.listProperties(this.getProfile().COMMENT())).filterKeep(new LangTagFilter(lang)).mapWith(s -> s.getObject());
    }

    @Override
    public boolean hasComment(String comment, String lang) {
        return this.hasComment(this.getModel().createLiteral(comment, lang));
    }

    @Override
    public boolean hasComment(Literal comment) {
        boolean found = false;
        ExtendedIterator<RDFNode> i = this.listComments(comment.getLanguage());
        while (!found && i.hasNext()) {
            found = comment.equals(i.next());
        }
        i.close();
        return found;
    }

    @Override
    public void removeComment(String comment, String lang) {
        this.removeComment(this.getModel().createLiteral(comment, lang));
    }

    @Override
    public void removeComment(Literal comment) {
        this.removePropertyValue(this.getProfile().COMMENT(), "COMMENT", comment);
    }

    @Override
    public void setRDFType(Resource cls) {
        this.setPropertyValue(RDF.type, "rdf:type", cls);
    }

    @Override
    public void addRDFType(Resource cls) {
        this.addPropertyValue(RDF.type, "rdf:type", cls);
    }

    @Override
    public Resource getRDFType() {
        return this.getRDFType(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Resource getRDFType(boolean direct) {
        try (ExtendedIterator<Resource> i = null;){
            i = this.listRDFTypes(direct);
            Resource resource = i.hasNext() ? (Resource)i.next() : null;
            return resource;
        }
    }

    @Override
    public ExtendedIterator<Resource> listRDFTypes(boolean direct) {
        ExtendedIterator<Resource> i = this.listDirectPropertyValues(RDF.type, "rdf:type", Resource.class, this.getProfile().SUB_CLASS_OF(), direct, false);
        return i.filterKeep(new UniqueFilter());
    }

    @Override
    public boolean hasRDFType(String uri) {
        return this.hasRDFType(this.getModel().getResource(uri));
    }

    @Override
    public boolean hasRDFType(Resource ontClass) {
        return this.hasRDFType(ontClass, "unknown", false);
    }

    @Override
    public boolean hasRDFType(Resource ontClass, boolean direct) {
        return this.hasRDFType(ontClass, "unknown", direct);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasRDFType(Resource ontClass, String name, boolean direct) {
        this.checkProfile(ontClass, name);
        if (!direct) {
            return this.hasPropertyValue(RDF.type, "rdf:type", ontClass);
        }
        try (ExtendedIterator<Resource> i = null;){
            i = this.listRDFTypes(true);
            while (i.hasNext()) {
                if (!ontClass.equals(i.next())) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
    }

    @Override
    public void removeRDFType(Resource cls) {
        this.removePropertyValue(RDF.type, "rdf:type", cls);
    }

    @Override
    public int getCardinality(Property p) {
        int n = 0;
        ExtendedIterator i = this.listPropertyValues(p).filterKeep(new UniqueFilter());
        while (i.hasNext()) {
            i.next();
            ++n;
        }
        return n;
    }

    @Override
    public void setPropertyValue(Property property, RDFNode value) {
        this.removeAll(property);
        if (value != null) {
            this.addProperty(property, value);
        }
    }

    @Override
    public RDFNode getPropertyValue(Property property) {
        Statement s = this.getProperty(property);
        if (s == null) {
            return null;
        }
        return OntResourceImpl.asOntResource(s.getObject());
    }

    @Override
    public NodeIterator listPropertyValues(Property property) {
        return new NodeIteratorImpl(this.listProperties(property).mapWith(s -> OntResourceImpl.asOntResource(s.getObject())), null);
    }

    @Override
    public void remove() {
        HashSet stmts = new HashSet();
        ArrayList<Resource> lists = new ArrayList<Resource>();
        ArrayList<Statement> skip = new ArrayList<Statement>();
        Property first = this.getProfile().FIRST();
        StmtIterator i = this.listProperties();
        while (i.hasNext()) {
            stmts.add(i.next());
        }
        i = this.getModel().listStatements(null, null, this);
        while (i.hasNext()) {
            stmts.add(i.next());
        }
        for (Statement s : stmts) {
            Resource obj;
            if (s.getPredicate().equals(first) && s.getObject().equals(this)) {
                log.debug(this.toString() + " is referened from an RDFList, so will not be fully removed");
                skip.add(s);
                continue;
            }
            if (!(s.getObject() instanceof Resource) || !(obj = s.getResource()).canAs(RDFList.class)) continue;
            lists.add(obj);
        }
        for (Resource r : lists) {
            stmts.addAll(((RDFListImpl)r.as(RDFList.class)).collectStatements());
        }
        stmts.removeAll(skip);
        for (Statement stmt : stmts) {
            stmt.remove();
        }
    }

    @Override
    public void removeProperty(Property property, RDFNode value) {
        this.getModel().remove(this, property, value);
    }

    @Override
    public AnnotationProperty asAnnotationProperty() {
        return this.as(AnnotationProperty.class);
    }

    @Override
    public OntProperty asProperty() {
        return this.as(OntProperty.class);
    }

    @Override
    public ObjectProperty asObjectProperty() {
        return this.as(ObjectProperty.class);
    }

    @Override
    public DatatypeProperty asDatatypeProperty() {
        return this.as(DatatypeProperty.class);
    }

    @Override
    public Individual asIndividual() {
        return this.as(Individual.class);
    }

    @Override
    public OntClass asClass() {
        return this.as(OntClass.class);
    }

    @Override
    public Ontology asOntology() {
        return this.as(Ontology.class);
    }

    @Override
    public AllDifferent asAllDifferent() {
        return this.as(AllDifferent.class);
    }

    @Override
    public DataRange asDataRange() {
        return this.as(DataRange.class);
    }

    @Override
    public boolean isAnnotationProperty() {
        return this.getProfile().ANNOTATION_PROPERTY() != null && this.canAs(AnnotationProperty.class);
    }

    @Override
    public boolean isProperty() {
        return this.canAs(OntProperty.class);
    }

    @Override
    public boolean isObjectProperty() {
        return this.getProfile().OBJECT_PROPERTY() != null && this.canAs(ObjectProperty.class);
    }

    @Override
    public boolean isDatatypeProperty() {
        return this.getProfile().DATATYPE_PROPERTY() != null && this.canAs(DatatypeProperty.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isIndividual() {
        OntModel m;
        OntModel ontModel = m = this.getModel() instanceof OntModel ? (OntModel)this.getModel() : null;
        if (m == null) {
            return false;
        }
        boolean useInf = false;
        useInf = m.getProfile().THING() != null && m.getReasoner() != null && m.getReasoner().supportsProperty(ReasonerVocabulary.individualAsThingP);
        StmtIterator i = null;
        ClosableIterator j = null;
        try {
            if (!useInf) {
                i = this.listProperties(RDF.type);
                while (i.hasNext()) {
                    Resource rType = i.nextStatement().getResource();
                    if (rType.equals(m.getProfile().THING())) {
                        boolean bl = true;
                        return bl;
                    }
                    if (rType.equals(this.getProfile().CLASS()) || rType.equals(RDFS.Resource) || rType.equals(RDF.Property) || rType.equals(RDFS.Datatype) || rType.equals(RDF.List)) continue;
                    j = rType.listProperties(RDF.type);
                    while (j.hasNext()) {
                        if (!j.nextStatement().getResource().equals(this.getProfile().CLASS())) continue;
                        boolean bl = true;
                        return bl;
                    }
                }
                boolean bl = false;
                return bl;
            }
            boolean bl = this.hasProperty(RDF.type, this.getProfile().THING());
            return bl;
        }
        finally {
            if (i != null) {
                i.close();
            }
            if (j != null) {
                j.close();
            }
        }
    }

    @Override
    public boolean isClass() {
        return this.canAs(OntClass.class);
    }

    @Override
    public boolean isOntology() {
        return this.getProfile().ONTOLOGY() != null && this.canAs(Ontology.class);
    }

    @Override
    public boolean isDataRange() {
        return this.getProfile().DATARANGE() != null && this.canAs(DataRange.class);
    }

    @Override
    public boolean isAllDifferent() {
        return this.getProfile().ALL_DIFFERENT() != null && this.canAs(AllDifferent.class);
    }

    protected static boolean hasType(Node n, EnhGraph g, Resource type) {
        boolean hasType = false;
        ExtendedIterator<Triple> i = g.asGraph().find(n, RDF.type.asNode(), type.asNode());
        hasType = i.hasNext();
        i.close();
        return hasType;
    }

    protected void checkProfile(Object term, String name) {
        if (term == null) {
            throw new ProfileException(name, this.getProfile());
        }
    }

    protected String selectLang(StmtIterator stmts, String lang) {
        String found = null;
        while (stmts.hasNext()) {
            RDFNode n = stmts.nextStatement().getObject();
            if (!(n instanceof Literal)) continue;
            Literal l = (Literal)n;
            String lLang = l.getLanguage();
            if (lang.equalsIgnoreCase(lLang)) {
                found = l.getString();
                break;
            }
            if (lLang != null && lLang.length() > 1 && lang.equalsIgnoreCase(lLang.substring(0, 2))) {
                found = l.getString();
                continue;
            }
            if (found != null || lLang != null) continue;
            found = l.getString();
        }
        stmts.close();
        return found;
    }

    protected boolean langTagMatch(String desired, String target) {
        return desired == null || desired.equalsIgnoreCase(target) || target.length() > desired.length() && desired.equalsIgnoreCase(target.substring(desired.length()));
    }

    protected <T extends RDFNode> T objectAs(Property p, String name, Class<T> asClass) {
        this.checkProfile(p, name);
        try {
            return this.getRequiredProperty(p).getObject().as(asClass);
        }
        catch (PropertyNotFoundException e) {
            return null;
        }
    }

    protected OntResource objectAsResource(Property p, String name) {
        return this.objectAs(p, name, OntResource.class);
    }

    protected OntProperty objectAsProperty(Property p, String name) {
        return this.objectAs(p, name, OntProperty.class);
    }

    protected int objectAsInt(Property p, String name) {
        this.checkProfile(p, name);
        return this.getRequiredProperty(p).getInt();
    }

    protected <T extends RDFNode> ExtendedIterator<T> listAs(Property p, String name, Class<T> cls) {
        this.checkProfile(p, name);
        return WrappedIterator.create(this.listProperties(p)).mapWith(s -> s.getObject().as(cls));
    }

    protected void addPropertyValue(Property p, String name, RDFNode value) {
        this.checkProfile(p, name);
        this.addProperty(p, value);
    }

    protected void setPropertyValue(Property p, String name, RDFNode value) {
        this.checkProfile(p, name);
        this.removeAll(p);
        this.addProperty(p, value);
    }

    protected boolean hasPropertyValue(Property p, String name, RDFNode value) {
        this.checkProfile(p, name);
        return this.hasProperty(p, value);
    }

    protected void addListPropertyValue(Property p, String name, RDFNode value) {
        this.checkProfile(p, name);
        if (this.hasProperty(p)) {
            RDFList newValues;
            RDFNode cur = this.getRequiredProperty(p).getObject();
            if (!cur.canAs(RDFList.class)) {
                throw new OntologyException("Tried to add a value to a list-valued property " + p + " but the current value is not a list: " + cur);
            }
            RDFList values = cur.as(RDFList.class);
            if (!values.contains(value) && (newValues = values.with(value)) != values) {
                this.removeAll(p);
                this.addProperty(p, newValues);
            }
        } else {
            this.addProperty(p, ((OntModel)this.getModel()).createList(new RDFNode[]{value}));
        }
    }

    protected <T extends RDFNode> T convertToType(Resource type, String name, Class<T> cls) {
        this.checkProfile(type, name);
        if (this.canAs(cls)) {
            return this.as(cls);
        }
        this.addProperty(RDF.type, type);
        return this.as(cls);
    }

    protected <T extends Resource> ExtendedIterator<T> listDirectPropertyValues(Property p, String name, Class<T> cls, Property orderRel, boolean direct, boolean inverse) {
        Iterator<Resource> i = null;
        this.checkProfile(p, name);
        Property sc = p;
        if (direct) {
            sc = this.getModel().getProperty(ReasonerRegistry.makeDirect(sc.asNode()).getURI());
        }
        OntResourceImpl subject = inverse ? null : this;
        OntResourceImpl object = inverse ? this : null;
        Function<Statement, Resource> mapper = inverse ? s -> (Resource)s.getSubject().as(cls) : s -> (Resource)s.getObject().as(cls);
        OntModel m = (OntModel)((Object)this.getGraph());
        InfGraph ig = null;
        if (m.getGraph() instanceof InfGraph) {
            ig = (InfGraph)m.getGraph();
        }
        i = !direct || ig != null && ig.getReasoner().supportsProperty(sc) ? this.getModel().listStatements((Resource)subject, sc, object).mapWith(mapper) : this.computeDirectValues(p, orderRel, inverse, subject, object, mapper);
        return WrappedIterator.create(i).filterKeep(new UniqueFilter());
    }

    private <T extends Resource> Iterator<T> computeDirectValues(Property p, Property orderRel, boolean inverse, Resource subject, Resource object, Function<Statement, T> mapper) {
        ExtendedIterator<T> j = this.getModel().listStatements(subject, p, object).mapWith(mapper);
        List<Resource> s = new ArrayList();
        while (j.hasNext()) {
            s.add((Resource)j.next());
        }
        ResourceUtils.removeEquiv(s, orderRel, this);
        boolean withheld = s.remove(this);
        List partition = ResourceUtils.partition(s, orderRel);
        HashMap equivSets = new HashMap();
        s.clear();
        for (List part : partition) {
            if (part.size() == 1) {
                s.add((Resource)part.get(0));
                continue;
            }
            Resource r = (Resource)part.remove(0);
            equivSets.put(r, part);
            s.add(r);
        }
        s = ResourceUtils.maximalLowerElements(s, orderRel, inverse);
        ArrayList<Resource> s2 = new ArrayList<Resource>();
        for (Resource r : s) {
            s2.add(r);
            if (!equivSets.containsKey(r)) continue;
            s2.addAll((Collection)equivSets.get(r));
        }
        if (withheld) {
            s2.add(this);
        }
        return s2.iterator();
    }

    protected void removePropertyValue(Property prop, String name, RDFNode value) {
        this.checkProfile(prop, name);
        this.getModel().remove(this, prop, value);
    }

    private static RDFNode asOntResource(RDFNode n) {
        return n.isResource() ? n.as(OntResource.class) : n;
    }

    protected class LangTagFilter
    implements Predicate<Statement> {
        protected String m_lang;

        public LangTagFilter(String lang) {
            this.m_lang = lang;
        }

        @Override
        public boolean test(Statement x) {
            RDFNode o = x.getObject();
            return o.isLiteral() && OntResourceImpl.this.langTagMatch(this.m_lang, o.asLiteral().getLanguage());
        }
    }
}

