# ./play.it action-adventure games collection

The codebase is maintained at [https://git.dotslashplay.it/games-action-adventure/]

Bug reports should be sent to [bugs@dotslashplay.it], and support requests to [requests@dotslashplay.it]

[https://git.dotslashplay.it/games-action-adventure/]: https://git.dotslashplay.it/games-action-adventure/
[bugs@dotslashplay.it]: mailto:bugs@dotslashplay.it
[requests@dotslashplay.it]: mailto:requests@dotslashplay.it

## Description

./play.it is a free software building native packages from installers for Windows or Linux, mainly those sold by stores focusing on DRM-free games distribution. The goal is that a game installed via ./play.it is indistinguishable from a game installed via the official repositories of your favourite distribution.

This specific collection includes only action-adventure games. This hybrid genre includes adventure games with action-based gameplay, as well as action games where the focus is more on the story and characters than the gameplay. Unlike pure adventure games, dexterity and speed can be required from the player.

## Installation

### Distributions providing ./play.it

The following distributions provide installation instructions in their official documentation:

- [Debian]
- [Gentoo]
- [Ubuntu] (French article)

[Debian]: https://wiki.debian.org/Games/PlayIt#Installation
[Gentoo]: https://wiki.gentoo.org/wiki/Play.it#Installation
[Ubuntu]: https://doc.ubuntu-fr.org/play.it#installation

In most cases, these instructions should work in the same way for derivatives of these distributions.

### Installation from git

If your distribution does not already have a package for this ./play.it collection, you can install it from this git repository.

```
git clone --branch main --depth 1 https://git.dotslashplay.it/games-action-adventure play.it-action-adventure.git
cd play.it-action-adventure.git
make install
```

## Usage

Usage instructions are provided on the main ./play.it repository: [./play.it: Installer for DRM-free commercial games — Usage]

[./play.it: Installer for DRM-free commercial games — Usage]: https://git.dotslashplay.it/play.it/about/#usage

## Contributing

### First contribution

There is no real rule for your first contribution. You can host your updated code anywhere you like and contact us via any way described in the [Contact information] section below. It is OK to expose your updated code through GitHub or GitLab.com if you have nothing better at hand, but we would be thankful if you would instead use some hosting outside of these big silos.

[Contact information]: #contact-information

We do not enforce any workflow like merge/pull requests or any such thing. We are interested in the result of your work, not in how you got to it. So shatter your shackles, and for once take pleasure in working *however you like*! You are not even required to use git if you do not know or do not like this tool.

Please try to follow these simple guidelines, and your contribution is probably going to be accepted quickly:

- Run `make check` before submitting your code, to ensure you did not break anything by accident;
- Use tabs for indentation. No real developer would ever indent anything with spaces.

### Regular contributions

If you keep contributing on a more regular basis (sending 3 patches in the same year would already make you a regular) we can grant you direct write access to the repositories hosted at git.dotslashplay.it. This is not mandatory, if for some reason you can not or do not want to work with git you can simply keep following the "First contribution" guidelines, and forget about this whole "Regular contributions" section.

To grant you such an access we need nothing but a public SSH key, that you can send us through any way described in the [Contact information] section below.

[Contact information]: #contact-information

Once you have been granted access, you should add the following to your local SSH configuration:

```
Host git.dotslashplay.it
    Port 1962
    User gitolite3
```

You should then update the remote of your local repository, with the following command (assuming a remote named "upstream"):

```
git remote set-url --push upstream ssh://git.dotslashplay.it/games-action-adventure
```

Since these repositories are worked on by several people, there are a couple extra guidelines that you should follow:

- Your work should always be pushed to a dedicated branch, never on the main branch;
- Game script updates, including bug fixes, should be pushed to branches named with a "update/" prefix;
- Addition of new game scripts should be pushed to branches named with a "new/" prefix;
- You are allowed to push code to branches opened by other contributors, but please communicate with them if you plan to do so;
- Force push and branches deletion are not allowed, if you want a branch to be deleted please ask us to do it for you.

## Supported games

- A Juggler's Tale
- A Plague Tale: Innocence
- AER: Memories of Old
- Amnesia: The Dark Descent
- Among the Sleep
- Anodyne
- Aquaria
- Aragami
- Assassin's Creed
- Atone: Heart of the Elder Tree
- Batman: Arkham series:
    - Batman: Arkham Asylum
    - Batman: Arkham City
    - Batman: Arkham Origins
    - Batman: Arkham Knight
- Bee Simulator
- Brothers: A Tale of Two Sons
- Brütal Legend
- Death's Door
- Don't Starve
- Figment series:
    - Figment
    - Figment 2: Creed Valley
- Grow: Song of the Evertree
- Haimrik
- Hammerwatch
- Hellblade: Senua's Sacrifice
- Hitman: Codename 47
- Hob
- Hot Tin Roof: The Cat That Wore a Fedora
- Inner
- Jotun
- Journey to the Savage Planet
- Just Cause 2
- Lego games:
    - Lego Batman: The Videogame
    - Lego Harry Potter: Years 1-4
- Lila's Sky Ark
- Litil Divil
- Little Big Adventure series:
    - Little Big Adventure
    - Little Big Adventure 2
- Man O' War: Corsair - Warhammer Naval Battles
- Medieval Dynasty
- My Memory of Us
- Neverending Nightmares
- No Man's Sky
- Phoning Home
- Pine
- Pirates:
    - Pirates (original version from 1987)
    - Pirates Gold (remake from 1993)
- Pixel Piracy
- Planet Alpha
- Pony Island
- Pulse
- République
- Restless Soul
- Retrace
- Retro City Rampage
- Reventure
- Saints Row: The Third
- Secrets of Raetikon
- Shelter series:
    - Shelter
    - Shelter 2
    - Paws: A Shelter 2 Game
- Soma
- Spooky's Jump Scare Mansion
- SteamWorld Heist
- Styx: Shards of Darkness
- Terraria
- The Aquatic Adventure of the Last Human
- The Coma: Recut
- The Fall
- The Flame in the Flood
- The Last Tinker: City of Colors
- The Subject
- Tunic
- Turnip Boy Commits Tax Evasion
- Typing Chronicles series:
    - Epistory - Typing Chronicles
    - Nanotale - Typing Chronicles
- Unsung Warriors
- Yono and the Celestial Elephants

## Contact information

### IRC channel

Some ./play.it developers and users can be reached on IRC, channel is `#play.it` on network `irc.oftc.net`. The main language on this IRC channel is English, but most of us can speak French too.

### E-mail

A contact e-mail for feedback can usually be found in each ./play.it game script, as well as in the library. Open one of these files with any text editor to see the contact e-mail.
