!{\src2tex{textfont=tt}}
!!****f* ABINIT/cchi0
!! NAME
!! cchi0
!!
!! FUNCTION
!! Main calculation of the independent-particle susceptibility chi0 for qq!=0
!!
!! COPYRIGHT
!! Copyright (C) 1999-2007 ABINIT group (GMR, VO, LR, RWG, MG, RShaltaf)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~abinit/doc/developers/contributors.txt .
!!
!! INPUTS
!!  energy(nkibz,nbnds,nsppol)=KS energies
!!  gwenergy(nkibzm,nbnds,nsppol)=GW energies, for self-consistency purposes
!!  grottbm1(npwvec,2,nop)=  contains the index  (IR)**-1 G 
!!  igfft(npwvec,5,5,5)=index of G-G0 planewaves (see cigfft routine)
!!  kbz(3,nkbz)=k-point coordinates, full Brillouin zone
!!  ktab(nkbz)=mapping between a k-point in the BZ (array kbz) and the
!!   corresponding irreducible point in the array kibz
!!  ktabi(nkbz)= -1 if inversion has to be considerd, 1 if not
!!  ktabr(nr,nkbz)= index of (R**-1)r in the FFT array where the (improper)
!!    rotation R is defined by: k= IR k_irred (I may be the identy or the inversion operator)
!!  nbnds=number of bands
!!  nbv=number of valence bands
!!  ngfft1,ngfft1a,ngfft2,ngfft3=FFT grid dimensions
!!  nkbz=number of k points in full Brillouin zone
!!  nkibz=number of k points in irreducible Brillouin zone
!!  nkibzm=maximum number of k points in irreducible Brillouin zone
!!  nomega=number of frequencies
!!  nop=number of symmetries 
!!  npwsigx=number of planewaves for sigma exchange (input variable)
!!  npwvec=dimension of igfft
!!  npwwfn=number of planewaves for wavefunctions (input variable)
!!  nsppol=1 for unpolarized, 2 for spin-polarized
!!  nr=number of points of FFT grid
!!  occ(nkibzm,nbnds,nsppol)=occupation numbers, for each k point in IBZ, each band and spin
!!  omega(nomega)=frequencies
!!  qq(3)=reciprocal space coordinates of the q wavevector
!!  lt_q= little group datatype
!!
!! OUTPUT
!!  chi0(npwsigx,npwsigx,nomega)=independent-particle susceptibility matrix for wavevector qq,
!!   and frequencies defined by omega
!!
!! TODO
!!  suppress the use of nkibzm, should be actually equal to nkibz
!!  eliminate energy (superceded by gwenergy)
!!
!! PARENTS
!!      screening
!!
!! CHILDREN
!!      assemblychi0,leave_new,rho_tw_g,timab,wrtout,xcomm_init
!!      xmaster_init,xme_init,xsum_master
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine cchi0(qq,nomega,omega,npwvec,npwsigx,npwwfn,nkibz,nkibzm,nbnds,&
& nbv,nsppol,occ,ktab,ktabr,ktabi,kbz,nkbz,ngfft1,ngfft1a,ngfft2,ngfft3,igfft,&
& nr,energy,gwenergy,etadelta,chi0,mpi_enreg,nop,grottbm1,lt_q,min_band_proc,max_band_proc,&
& parallelism_is_on_kpoints,parallelism_is_on_bands,nbnds_per_proc,distributed,nonlocal,wfr)

 use defs_basis
 use defs_datatypes

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_01manage_mpi
 use interfaces_15gw, except_this_one => cchi0
 use interfaces_lib01hidempi
#else
 use defs_xfuncmpi
#endif
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!MG FIXME This variable is not used anymore 
!scalars
 integer,intent(in) :: max_band_proc,min_band_proc,nbnds,nbnds_per_proc,ngfft1
 integer,intent(in) :: ngfft1a,ngfft2,ngfft3,nkbz,nkibz,nkibzm,nomega,nop
 integer,intent(in) :: npwsigx,npwvec,npwwfn,nr,nsppol
 real(dp),intent(in) :: etadelta
 logical,intent(in) :: distributed,parallelism_is_on_bands,nonlocal
 logical,intent(in) :: parallelism_is_on_kpoints
 type(MPI_type),intent(inout) :: mpi_enreg
 type(little_group),intent(in) :: lt_q
!arrays
 integer,intent(in) :: grottbm1(npwvec,2,nop),igfft(npwvec,5,5,5),ktab(nkibzm)
 integer,intent(in) :: ktabi(nkibzm),ktabr(nr,nkibzm),nbv(nsppol)
 real(dp),intent(in) :: energy(nkibz,min_band_proc:max_band_proc,nsppol)
 real(dp),intent(in) :: gwenergy(nkibz,min_band_proc:max_band_proc,nsppol)
 real(dp),intent(in) :: kbz(3,nkbz)
 real(dp),intent(in) :: occ(nkibz,min_band_proc:max_band_proc,nsppol),qq(3)
 complex,intent(in) :: omega(nomega)
 complex,intent(in),optional :: wfr(nr,min_band_proc:max_band_proc,nkibz,nsppol)
 complex,intent(out) :: chi0(npwsigx,npwsigx,nomega)

!Local variables ------------------------------
!scalars
 integer,parameter :: unitwfr=26
 integer :: i,ib,ibc,ibv,ig,ig01a,ig02a,ig03a,igp,ik,ikibz,ikp,ikpibz,io,ir,is
 integer :: istat,jb_proc_rank,max_con,max_val,min_con,min_val,nrb,tim_fourdp
 real(dp) :: eckp,f_occ,factocc,ockp,weight
 complex :: dd
 logical :: wfnr_not_in_memory,i_can_read,master_must_cast_data
!arrays
 integer :: g0(3)
 real(dp) :: kmq(3),tsec(2)
 real(dp),allocatable :: gwenergy_temp(:,:,:),oc_temp(:,:,:)
 complex,allocatable :: rhotw(:),rhotwg(:),rhotwgs(:),wfr_temp(:,:,:,:)
 complex,allocatable,target :: wfnr(:,:,:,:),wfnrk(:,:),wfnrkp(:,:)
 complex,pointer :: wfnrckp(:),wfnrvk(:)
!no_abirules
 complex (kind(0.0_dp)) :: ediff,egwdiff
 complex (kind(0.0_dp)),allocatable :: den(:)
 character(len=500)::message
 integer::master,spaceComm,ierr,me

! *************************************************************************
!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifndef HAVE_FORTRAN_INTERFACES
 logical :: findkp
#endif
!End of the abilint section

 write(message,'(a)') ' cchi0 : enter '
 call wrtout(06,message,'COLL')
 
 !Init mpi_comm
 !These lines added by Shaltaf for parallelization 10/08/05
 !parallization is on k points only, one must include the bands too in the future

 if(mpi_enreg%me==0)then 
  write(6,*)' symmetrization flag = ',lt_q%sym_flag
 end if 

 call xcomm_init(mpi_enreg,spaceComm) !Init mpi_comm 
 call xme_init(mpi_enreg,me)          !Init me 
 call xmaster_init(mpi_enreg,master)  !Init master

 call timab(331,1,tsec)

 tim_fourdp=1
 
 if( mpi_enreg%nproc==1 .or. (.not.nonlocal) .or. me==0 )then
  i_can_read=.true.
 else
  i_can_read=.false.
 end if

  if(mpi_enreg%nproc>1.and.nonlocal)then
   master_must_cast_data=.true.
  else
   master_must_cast_data=.false.
  end if


 allocate(den(nomega),rhotw(nr),rhotwg(npwsigx),rhotwgs(npwsigx))
 write(message,'(a,a)')' calculating chi0(q,omega,G,G")',ch10
 call wrtout(06,message,'COLL')


 if (present(wfr)) then

! Rshaltaf:
!! This case correspond to the situation where the wave functions were not wriiten to a disk file, and 
!! they were passed as an argument to this subroutine case (mkmem =/0)
!! here we have two cases
!! the first case: the wave functions are distributed among the proc 
!! the second case every proc has all set of wave functions
!! in the first case we have to be aware of
!1) Not every proc may have the wavefunctions that corrspond to the block of valence bands
!2) every Proc has to verfy that it contains the correpondent bands, if not
!3) it must cominicate with a proc that does have them
  if(mpi_enreg%nproc>1.and.parallelism_is_on_bands.and.distributed)then
   allocate(wfr_temp(nr,nbv(1),nkibz,nsppol))
   allocate(gwenergy_temp(nkibz,nbv(1),nsppol))
   allocate(oc_temp(nkibz,nbv(1),nsppol))
!! this is the first case 
   do ibv=1,nbv(1)
    jb_proc_rank=minval(abs(mpi_enreg%proc_distrb(ibv,:,:)))
    if(me==jb_proc_rank)then
     wfr_temp(:,ibv,:,:)=wfr(:,ibv,:,:)
     gwenergy_temp(:,ibv,:)=gwenergy(:,ibv,:)
     oc_temp(:,ibv,:)=occ(:,ibv,:)
    end if
    call xcast_mpi(wfr_temp(:,ibv,:,:),jb_proc_rank,spaceComm,ierr)
    call xcast_mpi(gwenergy_temp(:,ibv,:),jb_proc_rank,spaceComm,ierr)
    call xcast_mpi(oc_temp(:,ibv,:),jb_proc_rank,spaceComm,ierr)
   end do ! ibv
  end if

 else  ! present(wfr) 

!! here is the second case where the wave functions are written to a disk file
  write(message,'(a)')' cchi0 : trying to allocate wavefunctions in real space'
  call wrtout(06,message,'COLL')

  allocate(wfnr(nr,nbnds,nkibz,nsppol),stat=istat)
  if(istat==0) then
   write(message,'(a)')' allocated'
   call wrtout(06,message,'COLL')
   wfnr_not_in_memory=.false.
   !MG060915 Added external loop on spin
   do is=1,nsppol
    do ikibz=1,nkibz
      if(i_can_read)then
     read(unitwfr,rec=ikibz+nkibz*(is-1)) ((wfnr(ir,ib,ikibz,is),ir=1,nr),ib=1,nbnds)
      end if
      if(master_must_cast_data)then
      call xcast_mpi(wfnr,master,spaceComm,ierr)
      end if
    end do
   end do 

   write(message,'(a)')' cchi0 : real space wavefunctions are now in memory '
   call wrtout(06,message,'COLL')

  else
   write(message,'(3a)')&
&   ' not allocated',ch10,&
&   ' allocate only for each k-point'
   call wrtout(06,message,'COLL')
   wfnr_not_in_memory=.true.
   allocate(wfnrk(nr,nbnds),stat=istat)
   if(istat/=0) then
    write(message,'(a)')' cchi0: out of memory wfnrk'
    call wrtout(06,message,'COLL') ; call leave_new('COLL')
   end if
   allocate(wfnrkp(nr,nbnds),stat=istat)
   if(istat/=0)then
    write(message,'(a)')' cchi0: out of memory wfnrkp'
    call wrtout(06,message,'COLL') ; call leave_new('COLL')
   end if
  end if
 end if ! istat==0

 nrb=ngfft1*ngfft2*ngfft3 !set up fft factor

 chi0(:,:,:)=(0.0,0.0) !zero chi0

!weight (2 for spin unpolarized sistem, 1 for polarized)
!f_occ is used to normalize the occupation factors to one
 if (nsppol==1) then 
  weight=2.0/nkbz
  f_occ=0.5     
 else if (nsppol==2) then 
  weight=1.0/nkbz
  f_occ=1.0
 else 
  write(message,'(a)')&
&  ' cchi0: BUG - ',&
&  ' wrong value for nsppol '
  call wrtout(06,message,'COLL') 
  call leave_new('COLL')
 end if

!MG060915 Added internal loop on spin
!NOTE    The loop over is placed after the loop over k-points to optimize
!        the code since we need the *total polarizability* $\Chi_{up} + \Chi_{down}$

 do ik=1,nkbz !loop over k-points in BZ
  if(mpi_enreg%nproc>1.and.parallelism_is_on_kpoints)then 
   if(minval(abs(mpi_enreg%proc_distrb(ik,:,:)-mpi_enreg%me))/=0)cycle
  end if
  
! MG added for symmetrization
! this coding is safer since lt_q%ibzq(ik) might be not allocated 
  if (lt_q%sym_flag/=0 ) then 
   if (lt_q%ibzq(ik)/=1) cycle !only k in IBZq   
  end if 

  ikibz=ktab(ik)
  !identify k' and G0 where k'=k-q-G0
  !form k-q
  kmq(:)=kbz(:,ik)-qq(:)
  !find k''=k-q-G0 and G0 also

  if(.not.findkp(nkbz,kbz,ikp,kmq,g0)) then
   write(message,'(3a)')&
&   ' cchi0 : WARNING - ',ch10,&
&   ' k"=k-q-g0 not found'
   call wrtout(06,message,'COLL')
   write(message,'(a,i4,a,3f12.6,2a,6x,3f12.6)')&
&   ' ik = ',ik,' k = ',(kbz(i,ik),i=1,3),ch10,' k-q = ',(kmq(i),i=1,3)
   call wrtout(06,message,'COLL')
   cycle
  end if

  ikpibz=ktab(ikp)
  ig01a=g0(1)+3
  ig02a=g0(2)+3
  ig03a=g0(3)+3
  
  do is=1,nsppol !loop over spins

   write(message,'(a,2i6)')' cchi0 : ik,is=',ik,is
   call wrtout(06,message,'COLL')

   if(distributed)then
    min_val=1
    max_val=nbv(is)
    min_con=nbv(is)+1
    max_con=nbnds
!  this will lead to a faster algorithm
!  this algorithm might be used in serial case
!  at the moment (for testing+debugging) we only use it in case of band para
   else
    min_val=1
    max_val=nbnds
    min_con=1
    max_con=nbnds
   end if
   if(wfnr_not_in_memory) then
    if(i_can_read)then
    read(unitwfr,rec=ikibz + nkibz*(is-1)) ((wfnrk(ir,ib),ir=1,nr),ib=1,nbnds)
    read(unitwfr,rec=ikpibz+ nkibz*(is-1)) ((wfnrkp(ir,ib),ir=1,nr),ib=1,nbnds)
    end if
     if(master_must_cast_data)then
      call xcast_mpi(wfnrk,master,spaceComm,ierr)
      call xcast_mpi(wfnrkp,master,spaceComm,ierr)
   end if
   end if
!DEBUG
!  if(ik==1 .and. is==1) write(6,*)' cchi0 : will enter ibc loop '
!ENDDEBUG

   do ibc=min_con,max_con

!DEBUG
!   if(ik==1 .and. is==1) write(6,*)' cchi0 : ibc=',ibc
!ENDDEBUG


    if(mpi_enreg%nproc>1.and.parallelism_is_on_bands)then
     if(minval(abs(mpi_enreg%proc_distrb(ibc,:,:)-mpi_enreg%me))/=0) cycle
    end if

    if(distributed)then
     eckp=gwenergy(ikibz,ibc,is)
     ockp=occ(ikibz,ibc,is)
    else
     eckp=gwenergy(ikpibz,ibc,is)
     ockp=occ(ikpibz,ibc,is)
    end if

    if(.not.(present(wfr)))then
     if(wfnr_not_in_memory) then
      wfnrckp=>wfnrkp(:,ibc)
     else
      wfnrckp=>wfnr(:,ibc,ikpibz,is)
     end if
    end if

    do ibv=min_val,max_val
      !MG060915 in case of nsppol==2  the correct expression is
      !        factocc=(ockp-occ(ikibz,ibv,is)) since  occ \in [0,1]
     if(distributed)then
      factocc=f_occ*(oc_temp(ikpibz,ibv,is)-ockp)
     else
      factocc=f_occ*(ockp-occ(ikibz,ibv,is))
     end if

     !we continue the loop only if abs(factocc)/=0. 
     if(abs(factocc)<0.01) cycle

     if(distributed)then
      egwdiff=gwenergy_temp(ikpibz,ibv,is)-eckp
     else
      egwdiff=eckp-gwenergy(ikibz,ibv,is)
!     egwdiff=gwenergy(ikpibz,ibv,is)-eckp
     end if

!    Add the small imaginary of the time-ordered response function
     if(distributed)then
!     XG070106 : Here, I do not know how to mix Riad and Fabien contributions
      egwdiff= egwdiff + (0.,1.)*etadelta
      den(:)=factocc/(omega(:)+egwdiff)-factocc/(omega(:)-egwdiff)
     else
!     egwdiff= egwdiff - (0.,1.)*egwdiff/abs(egwdiff)*etadelta
!     XG070106 : Could Riad and Fabien check that this is correct ?
      do io=1,nomega
       if(real(omega(io))>0.001) then
        den(io)=factocc/(omega(io)+egwdiff-(0.,1.)*egwdiff/abs(egwdiff)*etadelta)
       else
        den(io)=factocc/(omega(io)+egwdiff)
       end if
      end do
!     den(:)=factocc/(omega(:)+egwdiff)
     end if

     if(.not.(present(wfr)))then
      if(wfnr_not_in_memory) then
       wfnrvk=>wfnrk(:,ibv)
      else
       wfnrvk=>wfnr(:,ibv,ikibz,is)
      end if
     end if

!    The calls to timab inside these loops are very time-consuming !
!    one will rely only on the timing inside rho_tw_g, when calling fourdp.
!    call timab(332,1,tsec)

!    Form rho-twiddle(r)=u^*_ck''(r)*u_vk(r)
     if(present(wfr))then
      if(distributed)then
       call rho_tw_g(npwsigx,nr,nrb,ngfft1a,ngfft1,ngfft2,ngfft3,&
&       igfft(:,ig01a,ig02a,ig03a),wfr_temp(:,ibv,ikpibz,is),ktabi(ikp),ktabr(:,ikp),&
&       wfr(:,ibc,ikibz,is),ktabi(ik),ktabr(:,ik),rhotwg,tim_fourdp)
      else
       call rho_tw_g(npwsigx,nr,nrb,ngfft1a,ngfft1,ngfft2,ngfft3,&
&       igfft(:,ig01a,ig02a,ig03a),wfr(:,ibc,ikpibz,is),ktabi(ikp),ktabr(:,ikp),&
&       wfr(:,ibv,ikibz,is),ktabi(ik),ktabr(:,ik),rhotwg,tim_fourdp)
      end if
     else
      call rho_tw_g(npwsigx,nr,nrb,ngfft1a,ngfft1,ngfft2,ngfft3,&
&      igfft(:,ig01a,ig02a,ig03a),wfnrckp,ktabi(ikp),ktabr(:,ikp),&
&      wfnrvk,ktabi(ik),ktabr(:,ik),rhotwg,tim_fourdp)
     end if
!    call timab(332,2,tsec)
!    call timab(333,1,tsec)

!    MG Symmetrization 
     if (lt_q%sym_flag/=0) then 
      call assemblychi0_sym(npwvec,npwsigx,lt_q%ninv,lt_q%nop,lt_q%nkbz,lt_q%wtksym(:,:,ik),&
&      grottbm1,nomega,chi0,rhotwg,den) 
     else 
      !chi0(G,G'',io)=chi0(G,G'',io)+(rhotwg(G)*rhotwg(G''))*den(io)
      call assemblychi0(npwsigx,nomega,chi0,rhotwg,den)
     end if

     !One could call immediately cgerc : Rank-1 update of chi0
     !do io=1,nomega
     ! dd=den(io)
     ! call cgerc(npwsigx,npwsigx,dd,rhotwg,1,rhotwg,1,chi0(:,:,io),npwsigx)
     !end do
     !call timab(333,2,tsec)

    end do !ibc
   end do !ibv
  end do !is
 end do !ik

 !These lines added by Shaltaf for parallelization 10/08/05
 !Rewritten using upper level primitives by MB 20060830
 call xsum_master(chi0,master,spaceComm,ierr)

 chi0(:,:,:)=weight*chi0(:,:,:)

 !fill in the missing half of chi (G,G'') using Hermiticity
 !Hermitianness is no longer valid for omega complex (not 0 not pure imag)
!MG060925 I do not understand this part since we are calculating all the Fourier components
!This means that we are imposing Hermiticity
 do io=1,nomega
  if(real(omega(io))<0.00001) then
   do igp=1,npwsigx
    do ig=1,igp-1
     chi0(igp,ig,io)=conjg(chi0(ig,igp,io))
    end do
   end do
  end if
 end do ! io
 !now we have chi0(q,G,G'',omega)


!now we have chi0(q,G,G'',omega)
 if(allocated(wfr_temp))deallocate(wfr_temp)
 if(allocated(gwenergy_temp))deallocate(gwenergy_temp)
 if(allocated(oc_temp))deallocate(oc_temp)
 if(allocated(wfnrk))deallocate(wfnrk)
 if(allocated(wfnrkp))deallocate(wfnrkp)
 if(allocated(wfnr))deallocate(wfnr)
 if(allocated(rhotw))deallocate(rhotw)
 if(allocated(rhotwg))deallocate(rhotwg)
 if(allocated(rhotwgs))deallocate(rhotwgs)
 if(allocated(den))deallocate(den)  !added by MM
 if(allocated(wfnrk))deallocate(wfnrk)  !added by MM
 if(allocated(wfnrkp))deallocate(wfnrkp)  !added by MM
 if(allocated(wfnr))deallocate(wfnr)  !added by MM

 call timab(331,2,tsec)

 write(message,'(a)')' cchi0 : exit '
 call wrtout(06,message,'COLL')

 end subroutine cchi0
!!***
