// This file is part of the AspectC++ compiler 'ac++'.
// Copyright (C) 1999-2003  The 'ac++' developers (see aspectc.org)
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#ifndef __IntroductionUnit_h__
#define __IntroductionUnit_h__

#include <string.h>

#include "ACUnit.h"

#ifdef ACMODEL
class ACM_Introduction;
#else
class JPL_Introduction;
#endif

class IntroductionUnit : public ACUnit {
  Unit *_target_unit;
  int _nesting_level;
#ifdef ACMODEL
  ACM_Introduction *_intro;
#else
  JPL_Introduction *_intro;
#endif
  void update_nesting_level () {
    IntroductionUnit *outer = cast (_target_unit);
    if (outer)
      _nesting_level = outer->_nesting_level + 1;
  }
public:
  IntroductionUnit (ErrorSink &e, Unit *t = 0) : ACUnit (e), _target_unit (t),
    _nesting_level (0) {
    name ("intro");
    update_nesting_level ();
  }
  void target_unit (Unit *t) { _target_unit = t; update_nesting_level (); }
  Unit *target_unit () const { return _target_unit; }
  Unit *final_target_unit () const {
    Unit *result = _target_unit;
    const IntroductionUnit *intro_unit = 0;
    do {
      intro_unit = IntroductionUnit::cast (result);
      if (intro_unit)
        result = intro_unit->target_unit ();
    } while (intro_unit);
    return result;
  }
  int nesting_level () const { return _nesting_level; }
#ifdef ACMODEL
  void intro (ACM_Introduction *i) { _intro = i; }
  ACM_Introduction *intro () const { return _intro; }
#else
  void intro (JPL_Introduction *i) { _intro = i; }
  JPL_Introduction *intro () const { return _intro; }
#endif
  static IntroductionUnit *cast (const Unit* u) {
    return (u->name () && strcmp (u->name (), "intro") == 0) ? (IntroductionUnit*)u : 0;
  }
};

#endif // __IntroductionUnit_h__

