# do not use directly, it is better to edit the file 'myenv.ksh'

if [ -e ../../contrib/avs/$0.ksh -o -e ../../contrib/avs/$0 ]
then
else
   echo Wrong dir, must run \'$0\' from noweb/contrib/avs dir
   exit 1
fi

if [ -z "$7" ] 
then 
	echo Usage: $0 BIN LIB MAN TEXINPUTS GMAKEPATH TMP ICONTRANSLATORPATH
	echo If your environment is OK installs noweb27 in your PC386
	echo "(icont.exe, iconx.exe, ixhdr.exe in dir e:\\b), e.g."
	echo "  $0 i:/b g:/usr/local/lib/noweb g:/man h:/emtex/texinputs/local j:/djgpp/bin/make.exe d:/tmp e:/b/icont.exe"
	echo "(the '.exe' in make.exe and icont.exe is not necessary)"
	exit 1
fi

cd ../..
# now one is at ./noweb

echo "Renaming src/makefile src/icon/makefile src/install src/xdoc/makefile src/lib/makefile src/awkname to *.old:"
for f in src/makefile src/icon/makefile src/install src/xdoc/makefile src/lib/makefile src/awkname
do
   if [ -e $f.old ]
   then
      echo File \'$f.old\' already exists, skipped
   else
      mv $f $f.old
   fi
done
echo Done!

echo "Adding Dos specific makefiles and scripts for the combination MKS/DJGPP/ICONT:"
awk -f contrib/avs/make_ico.awk src/icon/makefile.old > src/icon/makefile
awk -f contrib/avs/make_src.awk src/makefile.old > src/makefile
awk -f contrib/avs/make_xdo.awk src/xdoc/makefile.old > src/xdoc/makefile
awk -f contrib/avs/make_lib.awk src/lib/makefile.old > src/lib/makefile
cp -p contrib/avs/nw_c.bat src
cp -p contrib/avs/nwinst.ksh src
cp -p contrib/avs/nwicon.bat src
echo Done!

cd src
echo "Adapting awkname for Dos and changing the awk name to 'awk' in all scripts:"
sed "s@new=/tmp/\$\$.new; old=/tmp/\$\$.old@new=$6/\$\$.new; old=$6/\$\$.old@" <awkname.old >awkname
# because the script has no '.ksh' extension one has to use 'awkname.'
sh -c "./awkname. awk"
echo Done!

echo "Touch'ing all *.nw source code to avoid potential date/time problems:"
echo "(all of it gets dummy date 12:00 23-Feb-95)"
find . -name "*.nw" -exec touch -t 9502231200 "{}" \;
echo Done!

echo "Touch'ing all *.1 man pages to avoid potential date/time problems:"
echo "(all of it gets dummy date 12:00 24-Feb-95)"
find xdoc -name "*.1" -exec touch -t 9502241200 "{}" \;
echo Done!

cd ../contrib/avs
echo "Generating 'contrib/avs/automate.bat' (to avoid out of memory errors):"
echo "@echo off" >automate.bat
echo "REM This file was generated by $0" >>automate.bat
echo "cd ..\\\\..\\\\src" >> automate.bat

echo "echo ***" >>automate.bat
echo "echo *** Make icon code" >>automate.bat
echo "echo ***" >>automate.bat

# Trying to get something like: 
#	call nwicon i:/b g:/usr/local/lib/noweb j:\djgpp\bin\make.exe e:\\\\b\\\\icont.exe
# The '\c' arg to echo means not to add a \n at the end
# Careful not to allow echo to interpret e.g. djgpp\bin as having an embedded backspace (\b)
# 'sed' adds a \n line to its output, that's why tr was needed
echo call nwicon $1 $2 \\c >>automate.bat
echo $5 \\c | sed 's#/#\\#g' | tr -d '\015\012' >>automate.bat
echo $7 | sed 's#/#\\\\\\\\#g' >>automate.bat

echo if errorlevel 1 goto FAILURE >>automate.bat
echo "echo ***" >>automate.bat
echo "echo *** Make C code" >>automate.bat
echo "echo ***" >>automate.bat
echo set DJGPPMAKE=$5 >>automate.bat
echo call nw_c $5 | sed 's@/@\\@g' >>automate.bat
echo if errorlevel 1 goto FAILURE >>automate.bat
echo "echo ***" >>automate.bat
echo "echo *** Installing noweb" >>automate.bat
echo "echo ***" >>automate.bat
echo sh -c \"./nwinst.ksh $1 $2 $3 $4\" >>automate.bat
echo if errorlevel 1 goto FAILURE >>automate.bat
echo "echo ***" >>automate.bat
echo "echo *** Fixing $1/cpif.ksh and $1/noweb.ksh as documented in 'howto386.txt'" >>automate.bat
echo "echo ***" >>automate.bat
echo "cd ..\\\\contrib\\\\avs" >>automate.bat
echo sh -c \"./mksfixes.ksh $1 $6\" >>automate.bat
echo if errorlevel 1 goto FAILURE >>automate.bat
echo "echo Success, noweb 2.7a built & installed! Now use 'man noweb'" >>automate.bat
echo 'echo Noweb 2.7| banner -c n | sed' "'s/[ ]$//'" >>automate.bat
echo goto THEEND >>automate.bat
echo :FAILURE >>automate.bat
echo "echo Previous command failed (non 0 exit code), out of memory?" >>automate.bat
echo echo Aborting... sorry you have to manually fix the problem >>automate.bat
echo "echo (and after that go to noweb/contrib/avs and rerun automate.bat)" >>automate.bat
echo :THEEND >>automate.bat

echo "****"
echo "The file 'automate.bat' has been generated, now LEAVE the Korn shell (to avoid"
echo "out of memory errors) and run it. If 'automate.bat' fails at some point, e.g."
echo "out of memory, then you may try to fix the problem by hand e.g. calling the C"
echo "compiler directly by looking at the previous output from Make, and then to"
echo "rerun 'automate'. You can run 'automate.bat' as many times as you need until"
echo "you reach the end with success"
