{$INCLUDE Switches.inc}
unit Back;

interface

uses
  LCLIntf, LCLType, SysUtils, Classes, Graphics, Forms, Controls;

type

  { TBackground }

  TBackground = class(TForm)
    procedure FormDestroy(Sender: TObject);
    procedure FormPaint(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    Img: TBitmap;
  public
    procedure UpdateInterface;
  end;

var
  Background: TBackground;

implementation

uses
  Directories, ScreenTools, Start;

{$R *.lfm}

procedure TBackground.FormCreate(Sender: TObject);
begin
  Img := nil;
  Hide;
end;

procedure TBackground.FormShow(Sender: TObject);
begin
  Hide;
end;

procedure TBackground.FormDestroy(Sender: TObject);
begin
  if Assigned(Img) then FreeAndNil(Img);
end;

procedure TBackground.FormPaint(Sender: TObject);
begin
  Hide;
end;

procedure TBackground.FormClose(Sender: TObject; var Action: TCloseAction);
begin
end;

procedure TBackground.UpdateInterface;
begin
  Hide;
end;

end.
