/*
** (c) 1996-2000 The Regents of the University of California (through
** E.O. Lawrence Berkeley National Laboratory), subject to approval by
** the U.S. Department of Energy.  Your use of this software is under
** license -- the license agreement is attached and included in the
** directory as license.txt or you may contact Berkeley Lab's Technology
** Transfer Department at TTD@lbl.gov.  NOTICE OF U.S. GOVERNMENT RIGHTS.
** The Software was developed under funding from the U.S. Government
** which consequently retains certain rights as follows: the
** U.S. Government has been granted for itself and others acting on its
** behalf a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, and perform publicly
** and display publicly.  Beginning five (5) years after the date
** permission to assert copyright is obtained from the U.S. Department of
** Energy, and subject to any subsequent five (5) year renewals, the
** U.S. Government is granted for itself and others acting on its behalf
** a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, distribute copies to
** the public, perform publicly and display publicly, and to permit
** others to do so.
*/

#ifndef _MACPROJ_F_H
#define _MACPROJ_F_H

/*
** $Id: MACPROJ_F.H,v 1.9 2002/04/26 22:10:02 lijewski Exp $
*/

#ifdef BL_LANG_FORT
#    define FORT_MACDIV      macdiv
#    define FORT_UCORUPDT    ucorupdt
#else
#  if defined(BL_FORT_USE_UPPERCASE)
#    define FORT_MACDIV      MACDIV
#    define FORT_UCORUPDT    UCORUPDT
#  elif defined(BL_FORT_USE_LOWERCASE)
#    define FORT_MACDIV      macdiv
#    define FORT_UCORUPDT    ucorupdt
#  elif defined(BL_FORT_USE_UNDERSCORE)
#    define FORT_MACDIV      macdiv_
#    define FORT_UCORUPDT    ucorupdt_
#  endif

#include <ArrayLim.H>

extern "C" {
#if (BL_SPACEDIM == 2)
    void FORT_MACDIV (Real* dmac, ARLIM_P(dlo), ARLIM_P(dhi),
                      const int* lo, const int* hi,
                      const Real* ux, ARLIM_P(ux_lo), ARLIM_P(ux_hi),
                      const Real* uy, ARLIM_P(uy_lo), ARLIM_P(uy_hi),
                      const Real* ax, ARLIM_P(ax_lo), ARLIM_P(ax_hi),
                      const Real* ay, ARLIM_P(ay_lo), ARLIM_P(ay_hi),
                      const Real* vol,ARLIM_P(vol_lo), ARLIM_P(vol_hi));
#endif
#if (BL_SPACEDIM == 3)
    void FORT_MACDIV (Real* dmac, ARLIM_P(dlo), ARLIM_P(dhi),
                      const int* lo, const int* hi,
                      const Real* ux, ARLIM_P(ux_lo), ARLIM_P(ux_hi),
                      const Real* uy, ARLIM_P(uy_lo), ARLIM_P(uy_hi),
                      const Real* uz, ARLIM_P(uz_lo), ARLIM_P(uz_hi),
                      const Real* ax, ARLIM_P(ax_lo), ARLIM_P(ax_hi),
                      const Real* ay, ARLIM_P(ay_lo), ARLIM_P(ay_hi),
                      const Real* az, ARLIM_P(az_lo), ARLIM_P(az_hi),
                      const Real* vol,ARLIM_P(vol_lo), ARLIM_P(vol_hi));
#endif

    void FORT_UCORUPDT (Real* snew, const Real* sold,
                        ARLIM_P(s_lo), ARLIM_P(s_hi),
                        const int* nvar,
                        const int* lo, const int* hi,
                        const Real* dmac, ARLIM_P(dmac_lo), ARLIM_P(dmac_hi),
                        const Real* mult);

}

#endif
#endif /*_MACPROJ_F_H*/
