#include "backend"

void Backend::check() {
    debugmsg(Mstr("About to check back end ") + description() + ". " +
	     Mstr(backendcheck().description()) + "\n");

    ostringstream o;
    Backend tester;
    Httpbuffer httpbuffer;
    
    switch (backendcheck().checktype()) {
    case BackendCheck::c_connect:
	if (backendcheck().server() == "" && backendcheck().port() == 0) {
	    // Most common: TCP connect to the actual back end
	    connect();
	    socketclose(sock());
	} else {
	    // TCP connects to an alternative server or port.
	    // We instantiate a dummy backend and let it connect to the "other"
	    // values.
	    tester = *this;
	    if (backendcheck().server() != "")
		tester.server(backendcheck().server());
	    if (backendcheck().port() != 0)
		tester.port(backendcheck().port());
	    tester.connect();
	    socketclose (tester.sock());
	    live(tester.live());
	    msg (Mstr("Alternative back end for testing ") +
		 tester.description() + " is " + livestr() + "\n");
	}
	break;
	
    case BackendCheck::c_get:
	// HTTP GET to stated server, port, uri
	tester.server(backendcheck().server());
	tester.port(backendcheck().port());
	tester.connect();
	if (! tester.live()) {
	    warnmsg((Mstr("HTTP GET checker: host ") +
		     backendcheck().server()) +
		    (Mstr(", port ") + backendcheck().port()) +
		    " not responding\n");
	    live(false);
	} else {
	    o << "GET " << backendcheck().uri() << " HTTP/1.0\r\n"
		 "Host: " << backendcheck().server() << "\r\n"
		 "Connection: close\r\n"
		"\r\n";
	    httpbuffer.setstring (o.str());
	    httpbuffer.netwrite(tester.sock(), config.backend_write_timeout());
	    httpbuffer.reset();
	    while (!httpbuffer.headersreceived())
		httpbuffer.netread(tester.sock(),
				   config.backend_read_timeout());
	    msg((Mstr("HTTP GET checker got answer: '") +
		 httpbuffer.firstline()) + "'\n");
	    if (httpbuffer.stringat(9, 3) == "200")
		live(true);
	    else 
		debugmsg("Back end assumed dead.\n");
	}
	socketclose(tester.sock());
	break;
	
    case BackendCheck::c_external:
	// External program to be called, with arguments:
	// IP:PORT availability current-connections
	o << backendcheck().program() << ' ' << description() << ' '
	  << availablestr() << ' ' << connections();
	FILE *f;
	int result;
	if (! (f = popen(o.str().c_str(), "r")) ) {
	    live(false);
	    warnmsg(Mstr("Failed to start external checker '") + o.str() +
		    "': " + strerror(errno) + "\n");
	} else {
	    if (fscanf(f, "%d", &result) < 1) {
		live(false);
		warnmsg(Mstr("External checker '") + o.str() +
			Mstr("' did not reply with a number\n"));
	    } else {
		msg((Mstr("External checker '") + o.str()) +
		    (Mstr("' replied: ") + result) + '\n');
		live(result == 0);
	    }
	    if (pclose(f)) {
		warnmsg((Mstr("External checker '") + o.str()) +
			"' terminated with error\n");
		live(false);
	    }
	}
	break;
	
    default:
	throw Error("Internal fry in Backend::check()");
    }
}
