import pickle
from typing import Any

from rdflib.events import Event

Pickler = pickle.Pickler
Unpickler = pickle.Unpickler
UnpicklingError = pickle.UnpicklingError

class StoreCreatedEvent(Event): ...
class TripleAddedEvent(Event): ...
class TripleRemovedEvent(Event): ...

class NodePickler:
    def __init__(self) -> None: ...
    def register(self, object, id) -> None: ...
    def loads(self, s): ...
    def dumps(self, obj, protocol: Any | None = ..., bin: Any | None = ...): ...

class Store:
    context_aware: bool
    formula_aware: bool
    transaction_aware: bool
    graph_aware: bool
    dispatcher: Any
    def __init__(
        self, configuration: Any | None = ..., identifier: Any | None = ...
    ) -> None: ...
    node_pickler: Any
    def create(self, configuration) -> None: ...
    def open(self, configuration, create: bool = ...): ...
    def close(self, commit_pending_transaction: bool = ...) -> None: ...
    def destroy(self, configuration) -> None: ...
    def gc(self) -> None: ...
    def add(self, triple, context, quoted: bool = ...) -> None: ...
    def addN(self, quads) -> None: ...
    def remove(self, triple, context: Any | None = ...) -> None: ...
    def triples_choices(self, triple, context: Any | None = ...) -> None: ...
    def triples(self, triple_pattern, context: Any | None = ...) -> None: ...
    def __len__(self, context: Any | None = ...) -> None: ...
    def contexts(self, triple: Any | None = ...) -> None: ...
    def query(self, query, initNs, initBindings, queryGraph, **kwargs) -> None: ...
    def update(self, update, initNs, initBindings, queryGraph, **kwargs) -> None: ...
    def bind(self, prefix, namespace) -> None: ...
    def prefix(self, namespace) -> None: ...
    def namespace(self, prefix) -> None: ...
    def namespaces(self) -> None: ...
    def commit(self) -> None: ...
    def rollback(self) -> None: ...
    def add_graph(self, graph) -> None: ...
    def remove_graph(self, graph) -> None: ...
