/*
 * $Id: sig_integer.c,v 1.20 2012-07-05 21:09:31 potyra Exp $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>
#include <string.h>

#include "glue.h"

#include "sig_integer.h"

static void
sig_integer_flush(struct sig_integer *b)
{
	int new_val;
	unsigned int nr;

	if (0 < b->out_count) {
		new_val = b->out[0].out;
	} else {
		new_val = 0;
	}

	for (nr = 0; nr < b->in_count; nr++) {
		void (*func)(void *, int);

		func = b->in[nr].f->set;
		if (func
		 /* && b->in[nr].in != new_val */) {
			b->in[nr].in = new_val;
			func(b->in[nr].s, new_val);
		}
	}
}

void
sig_integer_set(struct sig_integer *b, void *s, int val)
{
	unsigned int nr;

again:	;
	for (nr = 0; ; nr++) {
		if (nr == b->out_count) {
			fprintf(stderr, "WARNING: late registration of integer driver of %p!\n", s);
			sig_integer_connect_out(b, s, 0);
			goto again;
		}
		assert(nr < b->out_count);
		if (b->out[nr].s == s) {
			b->out[nr].out = val;
			break;
		}
	}

	sig_integer_flush(b);
}

void
sig_integer_connect_in(
	struct sig_integer *b,
	void *s,
	const struct sig_integer_funcs *f
)
{
	assert(b);
	assert(b->type == SIG_GEN_INTEGER);
	assert(b->in_count < sizeof(b->in) / sizeof(b->in[0]));
	assert(s);
	assert(f);

	b->in[b->in_count].s = s;
	b->in[b->in_count].f = f;
	b->in[b->in_count].in = 0;
	b->in_count++;

	sig_integer_flush(b);
}

void
sig_integer_connect_out(struct sig_integer *b, void *s, int val)
{
	assert(b);
	assert(b->type == SIG_GEN_INTEGER);
	assert(b->out_count < sizeof(b->out) / sizeof(b->out[0]));
	// assert(s);
	
	if (! s) {
		fprintf(stderr, "WARNING: %s: s is NULL pointer!\n",
				__FUNCTION__);
	}

	b->out[b->out_count].s = s;
	b->out[b->out_count].out = val;
	b->out_count++;

	sig_integer_flush(b);
}

struct sig_integer *
sig_integer_create(const char *name)
{
	struct sig_integer *b;

	b = shm_alloc(sizeof(*b));
	assert(b);
	memset(b, 0, sizeof(*b));

	b->type = SIG_GEN_INTEGER;
	b->in_count = 0;
	b->out_count = 0;

	return b;
}

void
sig_integer_destroy(struct sig_integer *sig)
{
	assert(sig);
	assert(sig->type == SIG_GEN_INTEGER);

	shm_free(sig);
}

void
sig_integer_suspend(struct sig_integer *b, FILE *fSig)
{
	size_t size = sizeof(*b);
	
	generic_suspend(b, size, fSig);
}

void
sig_integer_resume(struct sig_integer *b, FILE *fSig)
{
	size_t size = sizeof(*b);
	
	generic_resume(b, size, fSig);
}
