/*
 * $Id: sig_mem_bus.c,v 1.18 2012-07-05 21:09:31 potyra Exp $
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#include <assert.h>
#include <stdio.h>

#include "glue.h"

#include "sig_mem_bus.h"

struct sig_mem_bus_main *
sig_mem_bus_main_create(const char *name)
{
	return (struct sig_mem_bus_main *) 0;
}

void
sig_mem_bus_main_destroy(struct sig_mem_bus_main *sig)
{
	assert(sig == NULL);
}

void
sig_mem_bus_main_suspend(struct sig_mem_bus_main *b, FILE *fSig)
{
	size_t size = sizeof(*b);
	
	generic_suspend(b, size, fSig);
}

void
sig_mem_bus_main_resume(struct sig_mem_bus_main *b, FILE *fSig)
{
	size_t size = sizeof(*b);
	
	generic_resume(b, size, fSig);
}

struct sig_mem_bus *
sig_mem_bus_create(const char *name)
{
	struct sig_mem_bus *b;
	char n[1000];
	
	b = shm_alloc(sizeof(*b));
	assert(b);

	b->type = SIG_GEN_MEM_BUS;

	sprintf(n, "%s-power", name);
	b->power = sig_boolean_create(n);
	sprintf(n, "%s-cs0", name);
	b->cs0 = sig_cs_create(n);
	sprintf(n, "%s-cs1", name);
	b->cs1 = sig_cs_create(n);
	sprintf(n, "%s-i2cbus", name);
	b->i2cbus = sig_i2c_bus_create(n);
	sprintf(n, "%s-id0", name);
	b->id0 = sig_boolean_create(n);
	sprintf(n, "%s-id1", name);
	b->id1 = sig_boolean_create(n);
	sprintf(n, "%s-id2", name);
	b->id2 = sig_boolean_create(n);

	return b;
}

void
sig_mem_bus_destroy(struct sig_mem_bus *sig)
{
	assert(sig);
	assert(sig->type == SIG_GEN_MEM_BUS);

	sig_boolean_destroy(sig->power);
	sig_cs_destroy(sig->cs0);
	sig_cs_destroy(sig->cs1);
	sig_i2c_bus_destroy(sig->i2cbus);
	sig_boolean_destroy(sig->id0);
	sig_boolean_destroy(sig->id1);
	sig_boolean_destroy(sig->id2);

	shm_free(sig);
}

void
sig_mem_bus_suspend(struct sig_mem_bus *b, FILE *fSig)
{
	size_t size = sizeof(*b);
	
	generic_suspend(b, size, fSig);
	
	sig_boolean_suspend(b->power, fSig);
	sig_cs_suspend(b->cs0, fSig);
	sig_cs_suspend(b->cs1, fSig);	
	sig_i2c_bus_suspend(b->i2cbus, fSig);
	sig_boolean_suspend(b->id0, fSig);
	sig_boolean_suspend(b->id1, fSig);
	sig_boolean_suspend(b->id2, fSig);
}

void
sig_mem_bus_resume(struct sig_mem_bus *b, FILE *fSig)
{
	size_t size = sizeof(*b);
	
	generic_resume(b, size, fSig);
	
	sig_boolean_resume(b->power, fSig);
	sig_cs_resume(b->cs0, fSig);
	sig_cs_resume(b->cs1, fSig);	
	sig_i2c_bus_resume(b->i2cbus, fSig);
	sig_boolean_resume(b->id0, fSig);
	sig_boolean_resume(b->id1, fSig);
	sig_boolean_resume(b->id2, fSig);
}
