!** Copyright (c) 1989, NVIDIA CORPORATION.  All rights reserved.
!**
!** Licensed under the Apache License, Version 2.0 (the "License");
!** you may not use this file except in compliance with the License.
!** You may obtain a copy of the License at
!**
!**     http://www.apache.org/licenses/LICENSE-2.0
!**
!** Unless required by applicable law or agreed to in writing, software
!** distributed under the License is distributed on an "AS IS" BASIS,
!** WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
!** See the License for the specific language governing permissions and
!** limitations under the License.

!* Tests for runtime library MATMUL routines

program p
  
  parameter(NbrTests=2112)
  parameter(o_extent=2)
  parameter(n_extent=6)
  parameter(m_extent=4)
  parameter(k_extent=8)
  
  integer*1, dimension(n_extent,m_extent) :: arr1
  integer*1, dimension(m_extent,k_extent) :: arr2
  integer*1, dimension(n_extent,k_extent) :: arr3
  integer*1, dimension(n_extent,m_extent,o_extent) :: arr4
  integer*1, dimension(n_extent,o_extent,m_extent) :: arr5
  integer*1, dimension(o_extent,n_extent,m_extent) :: arr6
  
  integer*1, dimension(o_extent,m_extent,k_extent) :: arr7
  integer*1, dimension(m_extent,o_extent,k_extent) :: arr8
  integer*1, dimension(m_extent,k_extent,o_extent) :: arr9
  
  integer*1, dimension(n_extent,k_extent,o_extent) :: arr10
  integer*1, dimension(n_extent,o_extent,k_extent) :: arr11
  integer*1, dimension(o_extent,n_extent,k_extent) :: arr12
  
  integer*1, dimension(2:n_extent+1,m_extent) :: arr13
  integer*1, dimension(2:m_extent+1,k_extent) :: arr14
  integer*1, dimension(2:n_extent+1,k_extent) :: arr15
  integer*1, dimension(n_extent,2:m_extent+1) :: arr16
  integer*1, dimension(m_extent,2:k_extent+1) :: arr17
  integer*1, dimension(n_extent,2:k_extent+1) :: arr18
  integer*1, dimension(n_extent,k_extent) :: arr19
  
  integer*4 :: expect(NbrTests) 
  integer*4 :: results(NbrTests)
  
  integer:: i,j
  
  data arr1 /0,1,2,3,4,5,6,7,8,9,10,11,			&
             12,13,14,15,16,17,18,19,20,22,22,23/
  data arr2 /0,1,2,3,4,5,6,7,8,9,10,11,			&
             12,13,14,15,16,17,18,19,20,21,22,23,		&
             24,25,26,27,28,29,30,31/
  data arr3 /0,1,2,3,4,5,6,7,8,9,10,11, 			&
             12,13,14,15,16,17,18,19,20,21,22,23,		&
             24,25,26,27,28,29,30,31,32,33,34,35,		&
             36,37,38,39,40,41,42,43,44,45,46,47/
  data arr4 /0,1,2,3,4,5,6,7,8,9,10,11, 			&
             12,13,14,15,16,17,18,19,20,21,22,23,		&
             24,25,26,27,28,29,30,31,32,33,34,35,		&
             36,37,38,39,40,41,42,43,44,45,46,47/
  data arr5 /0,1,2,3,4,5,6,7,8,9,10,11, 			&
             12,13,14,15,16,17,18,19,20,21,22,23,		&
             24,25,26,27,28,29,30,31,32,33,34,35,		&
             36,37,38,39,40,41,42,43,44,45,46,47/
  data arr6 /0,1,2,3,4,5,6,7,8,9,10,11, 			&
             12,13,14,15,16,17,18,19,20,21,22,23,		&
             24,25,26,27,28,29,30,31,32,33,34,35,		&
             36,37,38,39,40,41,42,43,44,45,46,47/
  data arr7 /0,1,2,3,4,5,6,7,8,9,10,11, 			&
             12,13,14,15,16,17,18,19,20,21,22,23,		&
             24,25,26,27,28,29,30,31,32,33,34,35,		&
             36,37,38,39,40,41,42,43,44,45,46,47,		&
             48,49,50,51,52,53,54,55,56,57,58,59,		&
             60,61,62,63/
  data arr8 /0,1,2,3,4,5,6,7,8,9,10,11, 			&
             12,13,14,15,16,17,18,19,20,21,22,23,		&
             24,25,26,27,28,29,30,31,32,33,34,35,		&
             36,37,38,39,40,41,42,43,44,45,46,47,		&
             48,49,50,51,52,53,54,55,56,57,58,59,		&
             60,61,62,63/
  data arr9 /0,1,2,3,4,5,6,7,8,9,10,11, 			&
             12,13,14,15,16,17,18,19,20,21,22,23,		&
             24,25,26,27,28,29,30,31,32,33,34,35,		&
             36,37,38,39,40,41,42,43,44,45,46,47,		&
             48,49,50,51,52,53,54,55,56,57,58,59,		&
             60,61,62,63/
  data arr10 /0,1,2,3,4,5,6,7,8,9,10,11,	 		&
             12,13,14,15,16,17,18,19,20,21,22,23,		&
             24,25,26,27,28,29,30,31,32,33,34,35,		&
             36,37,38,39,40,41,42,43,44,45,46,47,		&
             48,49,50,51,52,53,54,55,56,57,58,59,		&
             60,61,62,63,64,65,66,67,68,69,70,71,		&
             72,73,74,75,76,77,78,79,80,81,82,83,		&
             84,85,86,87,88,89,90,91,92,93,94,95/
  data arr11 /0,1,2,3,4,5,6,7,8,9,10,11,	 		&
             12,13,14,15,16,17,18,19,20,21,22,23,		&
             24,25,26,27,28,29,30,31,32,33,34,35,		&
             36,37,38,39,40,41,42,43,44,45,46,47,		&
             48,49,50,51,52,53,54,55,56,57,58,59,		&
             60,61,62,63,64,65,66,67,68,69,70,71,		&
             72,73,74,75,76,77,78,79,80,81,82,83,		&
             84,85,86,87,88,89,90,91,92,93,94,95/
  data arr12 /0,1,2,3,4,5,6,7,8,9,10,11,	 		&
             12,13,14,15,16,17,18,19,20,21,22,23,		&
             24,25,26,27,28,29,30,31,32,33,34,35,		&
             36,37,38,39,40,41,42,43,44,45,46,47,		&
             48,49,50,51,52,53,54,55,56,57,58,59,		&
             60,61,62,63,64,65,66,67,68,69,70,71,		&
             72,73,74,75,76,77,78,79,80,81,82,83,		&
             84,85,86,87,88,89,90,91,92,93,94,95/
  data arr13 /0,1,2,3,4,5,6,7,8,9,10,11,                        &
             12,13,14,15,16,17,18,19,20,22,22,23/
  data arr14 /0,1,2,3,4,5,6,7,8,9,10,11,                        &
             12,13,14,15,16,17,18,19,20,21,22,23,               &
             24,25,26,27,28,29,30,31/
  data arr15 /0,1,2,3,4,5,6,7,8,9,10,11,                        &
             12,13,14,15,16,17,18,19,20,21,22,23,               &
             24,25,26,27,28,29,30,31,32,33,34,35,               &
             36,37,38,39,40,41,42,43,44,45,46,47/
  data arr16 /0,1,2,3,4,5,6,7,8,9,10,11,                        &
             12,13,14,15,16,17,18,19,20,22,22,23/
  data arr17 /0,1,2,3,4,5,6,7,8,9,10,11,                        &
             12,13,14,15,16,17,18,19,20,21,22,23,               &
             24,25,26,27,28,29,30,31/
  data arr18 /0,1,2,3,4,5,6,7,8,9,10,11,                        &
             12,13,14,15,16,17,18,19,20,21,22,23,               &
             24,25,26,27,28,29,30,31,32,33,34,35,               &
             36,37,38,39,40,41,42,43,44,45,46,47/
  
  data expect /   &
  !test 1-48
     84,    90,    96,   105,   108,   114,   -28,    -6,    16,    45,    60,    82,   116, &
   -102,   -64,   -15,    12,    50,     4,    58,   112,   -75,   -36,    18,  -108,   -38, &
     32,   121,   -84,   -14,    36,   122,   -48,    61,   124,   -46,   -76,    26,  -128, &
      1,    76,   -78,    68,   -70,    48,   -59,    28,  -110, &
  !test 49-96
      0,    90,    96,   105,   108,   114,     0,    -6,    16,    45,    60,    82,     0, &
   -102,   -64,   -15,    12,    50,     0,    58,   112,   -75,   -36,    18,     0,   -38, &
     32,   121,   -84,   -14,     0,   122,   -48,    61,   124,   -46,     0,    26,  -128, &
      1,    76,   -78,     0,   -70,    48,   -59,    28,  -110, &
  !test 97-144
     84,    90,    96,   105,   108,     0,   -28,    -6,    16,    45,    60,     0,   116, &
   -102,   -64,   -15,    12,     0,     4,    58,   112,   -75,   -36,     0,  -108,   -38, &
     32,   121,   -84,     0,    36,   122,   -48,    61,   124,     0,   -76,    26,  -128, &
      1,    76,     0,    68,   -70,    48,   -59,    28,     0, &
  !test 145-192
     84,    90,    96,   105,   108,   114,   -28,   -10,     8,    33,    44,    62,   116, &
   -110,   -80,   -39,   -20,    10,     4,    46,    88,  -111,   -84,   -42,  -108,   -54, &
      0,    73,   108,   -94,    36,   102,   -88,     1,    44,   110,   -76,     2,    80, &
    -71,   -20,    58,    68,   -98,    -8,   113,   -84,     6, &
  !test 193-240
     84,    90,    96,   105,   108,   114,   -28,   -10,     8,    33,    44,    62,   116, &
   -110,   -80,   -39,   -20,    10,     4,    46,    88,  -111,   -84,   -42,  -108,   -54, &
      0,    73,   108,   -94,    36,   102,   -88,     1,    44,   110,   -76,     2,    80, &
    -71,   -20,    58,    68,   -98,    -8,   113,   -84,     6, &
  !test 241-288
     30,    33,    36,    39,    42,    45,   102,   117,  -124,  -109,   -94,   -79,   -82, &
    -55,   -28,    -1,    26,    53,   -10,    29,    68,   107,  -110,   -71,    62,   113, &
    -92,   -41,    10,    61,  -122,   -59,     4,    67,  -126,   -63,   -50,    25,   100, &
    -81,    -6,    69,    22,   109,   -60,    27,   114,   -55, &
  !test 289-336
     30,    33,    36,     0,     0,     0,   102,   117,  -124,     0,     0,     0,   -82, &
    -55,   -28,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
      0,     0,     0,     0,     0,     0,     0,     0,     0, &
  !test 337-384
      0,     0,     0,     0,     0,     0,     0,   -10,     8,    33,     0,     0,     0, &
   -110,   -80,   -39,     0,     0,     0,    46,    88,  -111,     0,     0,     0,     0, &
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
      0,     0,     0,     0,     0,     0,     0,     0,     0, &
  !test 385-432
     30,    33,    36,    39,    42,    45,     0,     0,     0,     0,     0,     0,   -82, &
    -55,   -28,    -1,    26,    53,     0,     0,     0,     0,     0,     0,    62,   113, &
    -92,   -41,    10,    61,     0,     0,     0,     0,     0,     0,   -50,    25,   100, &
    -81,    -6,    69,     0,     0,     0,     0,     0,     0, &
  !test 433-480
     48,     0,    54,     0,    60,     0,   -64,     0,   -34,     0,    -4,     0,    80, &
      0,  -122,     0,   -68,     0,   -32,     0,    46,     0,   124,     0,   112,     0, &
    -42,     0,    60,     0,     0,     0,   126,     0,    -4,     0,  -112,     0,    38, &
      0,   -68,     0,    32,     0,   -50,     0,   124,     0, &
  !test 481-528
     30,     0,    36,     0,    42,     0,     0,     0,     0,     0,     0,     0,   -82, &
      0,   -28,     0,    26,     0,     0,     0,     0,     0,     0,     0,    62,     0, &
    -92,     0,    10,     0,     0,     0,     0,     0,     0,     0,   -50,     0,   100, &
      0,    -6,     0,     0,     0,     0,     0,     0,     0, &
  !test 529-576
     48,     0,    54,     0,    60,     0,     0,     0,     0,     0,     0,     0,    80, &
      0,  -122,     0,   -68,     0,     0,     0,     0,     0,     0,     0,   112,     0, &
    -42,     0,    60,     0,     0,     0,     0,     0,     0,     0,  -112,     0,    38, &
      0,   -68,     0,     0,     0,     0,     0,     0,     0, &
  !test 577-624
      0,     0,     0,     0,     0,     0,     0,  -118,     0,   -82,     0,   -46,     0, &
      0,     0,     0,     0,     0,     0,    50,     0,  -122,     0,   -38,     0,     0, &
      0,     0,     0,     0,     0,   -38,     0,    94,     0,   -30,     0,     0,     0, &
      0,     0,     0,     0,  -126,     0,    54,     0,   -22, &
  !test 625-672
      0,   109,     0,    27,     0,   -55,     0,     0,     0,     0,     0,     0,     0, &
    -59,     0,    67,     0,   -63,     0,     0,     0,     0,     0,     0,     0,    29, &
      0,   107,     0,   -71,     0,     0,     0,     0,     0,     0,     0,   117,     0, &
   -109,     0,   -79,     0,     0,     0,     0,     0,     0, &
  !test 673-720
   -112,     0,    38,     0,   -68,     0,     0,     0,     0,     0,     0,     0,   112, &
      0,   -42,     0,    60,     0,     0,     0,     0,     0,     0,     0,    80,     0, &
   -122,     0,   -68,     0,     0,     0,     0,     0,     0,     0,    48,     0,    54, &
      0,    60,     0,     0,     0,     0,     0,     0,     0, &
  !test 721-768
      0,     0,     0,     0,     0,     0,     0,  -118,     0,   -82,     0,   -46,     0, &
      0,     0,     0,     0,     0,     0,    50,     0,  -122,     0,   -38,     0,     0, &
      0,     0,     0,     0,     0,   -38,     0,    94,     0,   -30,     0,     0,     0, &
      0,     0,     0,     0,  -126,     0,    54,     0,   -22, &
  !test 769-864
      0,     0,     0,     0,     0,     0,     0,   -20,    16,    52,     0,     0,     0, &
     36,    96,  -100,     0,     0,     0,    92,   -80,     4,     0,     0,     0,     0, &
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
      0,     0,     0,     0,     0, &
  !test 865-960
    102,   105,   108,   111,   114,   117,     0,     0,     0,     0,     0,     0,     0, &
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     6,    57, &
    108,   -97,   -46,     5,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
      0,     0,     0,     0,     0,     0,     0,     0,     0,   -90,     9,   108,   -49, &
     50,  -107,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
      0,     0,     0,     0,     0,     0,     0,    70,   -39,   108,    -1,  -110,    37, &
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
      0,     0,     0,     0,     0, &
  !test 961-1056
      0,    -8,     0,     0,     0,   -66,     0,     0,     0,  -124,     0,     0,     0, &
    -88,     0,     0,     0,  -122,     0,     0,     0,   100,     0,     0,     0,    88, &
      0,     0,     0,    78,     0,     0,     0,    68,     0,     0,     0,     8,     0, &
      0,     0,    22,     0,     0,     0,    36,     0,     0,     0,   -72,     0,     0, &
      0,   -34,     0,     0,     0,     4,     0,     0,     0,   104,     0,     0,     0, &
    -90,     0,     0,     0,   -28,     0,     0,     0,    24,     0,     0,     0,   110, &
      0,     0,     0,   -60,     0,     0,     0,   -56,     0,     0,     0,    54,     0, &
      0,     0,   -92,     0,     0, &
  !test 1057-1152
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
      0,     0,     0,     0,     0,     0,     0,     0,     0,    38,     0,    68,     0, &
     98,     0,     0,     0,     0,     0,     0,     0,  -122,     0,     4,     0,  -126, &
      0,     0,     0,     0,     0,     0,     0,   -26,     0,   -60,     0,   -94,     0, &
      0,     0,     0,     0,     0,     0,    70,     0,  -124,     0,   -62,     0,     0, &
      0,     0,     0,     0,     0, &
  !test 1153-1248
      0,     0,     0,     0,     0,     0,    96,     0,   102,     0,   108,     0,     0, &
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
      0,     0,     0,     0,   -96,     0,   -42,     0,    12,     0,     0,     0,     0, &
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
      0,     0,   -32,     0,    70,     0,   -84,     0,     0,     0,     0,     0,     0, &
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
     32,     0,   -74,     0,    76,     0,     0,     0,     0,     0,     0,     0,     0, &
      0,     0,     0,     0,     0, &
  !test 1249-1344
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
      0,    21,     0,     0,     0,    99,     0,     0,     0,   -79,     0,     0,     0, &
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   -91, &
      0,     0,     0,    83,     0,     0,     0,     1,     0,     0,     0,     0,     0, &
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,    53,     0,     0, &
      0,    67,     0,     0,     0,    81,     0,     0,     0,     0,     0,     0,     0, &
      0,     0,     0,     0,     0,     0,     0,     0,   -59,     0,     0,     0,    51, &
      0,     0,     0,   -95,     0, &
  !test 1345-1440
      0,   -47,     0,   -83,     0,  -119,     0,     0,     0,     0,     0,     0,     0, &
    105,     0,   -27,     0,    97,     0,     0,     0,     0,     0,     0,     0,     1, &
      0,    29,     0,    57,     0,     0,     0,     0,     0,     0,     0,  -103,     0, &
     85,     0,    17,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
      0,     0,     0,     0,     0, &
  !test 1441-1536
      0,     0,     0,     0,     0,     0,  -120,     0,   -20,     0,    80,     0,     0, &
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
      0,     0,     0,     0,     8,     0,   -84,     0,    80,     0,     0,     0,     0, &
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
      0,     0,  -120,     0,   108,     0,    80,     0,     0,     0,     0,     0,     0, &
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
      8,     0,    44,     0,    80,     0,     0,     0,     0,     0,     0,     0,     0, &
      0,     0,     0,     0,     0, &
  !test 1537-1632
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
      0,     0,   -38,     0,     0,     0,    82,     0,     0,     0,   -54,     0,     0, &
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
    -86,     0,     0,     0,   -30,     0,     0,     0,    26,     0,     0,     0,     0, &
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,   122,     0, &
      0,     0,   114,     0,     0,     0,   106,     0,     0,     0,     0,     0,     0, &
      0,     0,     0,     0,     0,     0,     0,     0,     0,    74,     0,     0,     0, &
      2,     0,     0,     0,   -70, &
  ! test 1633-1680
     84,    90,    96,   105,   108,   114,   -28,    -6,    16,    45,    60,    82,   116, &
   -102,   -64,   -15,    12,    50,     4,    58,   112,   -75,   -36,    18,  -108,   -38, &
     32,   121,   -84,   -14,    36,   122,   -48,    61,   124,   -46,   -76,    26,  -128, &
      1,    76,   -78,    68,   -70,    48,   -59,    28,  -110, &
  ! test 1681-1728
     84,    90,    96,   105,   108,   114,   -28,    -6,    16,    45,    60,    82,   116, &
   -102,   -64,   -15,    12,    50,     4,    58,   112,   -75,   -36,    18,  -108,   -38, &
     32,   121,   -84,   -14,    36,   122,   -48,    61,   124,   -46,   -76,    26,  -128, &
      1,    76,   -78,    68,   -70,    48,   -59,    28,  -110, &
  ! test 1729-1776
     84,    90,    96,   105,   108,     0,   -28,    -6,    16,    45,    60,     0,   116, &
   -102,   -64,   -15,    12,     0,     4,    58,   112,   -75,   -36,     0,  -108,   -38, &
     32,   121,   -84,     0,    36,   122,   -48,    61,   124,     0,   -76,    26,  -128, &
      1,    76,     0,    68,   -70,    48,   -59,    28,     0, &
  ! test 1777-1824
     84,    90,    96,   105,   108,   114,   -28,   -10,     8,    33,    44,    62,   116, &
   -110,   -80,   -39,   -20,    10,     4,    46,    88,  -111,   -84,   -42,  -108,   -54, &
      0,    73,   108,   -94,    36,   102,   -88,     1,    44,   110,   -76,     2,    80, &
    -71,   -20,    58,    68,   -98,    -8,   113,   -84,     6, &
  ! test 1825-1872
     84,    90,    96,   105,   108,   114,   -28,   -10,     8,    33,    44,    62,   116, &
   -110,   -80,   -39,   -20,    10,     4,    46,    88,  -111,   -84,   -42,  -108,   -54, &
      0,    73,   108,   -94,    36,   102,   -88,     1,    44,   110,   -76,     2,    80, &
    -71,   -20,    58,    68,   -98,    -8,   113,   -84,     6, &
  ! test 1873-1920
     30,    33,    36,    39,    42,    45,   102,   117,  -124,  -109,   -94,   -79,   -82, &
    -55,   -28,    -1,    26,    53,   -10,    29,    68,   107,  -110,   -71,    62,   113, &
    -92,   -41,    10,    61,  -122,   -59,     4,    67,  -126,   -63,   -50,    25,   100, &
    -81,    -6,    69,    22,   109,   -60,    27,   114,   -55, &
  !test 1921-1968
     30,    33,    36,     0,     0,     0,   102,   117,  -124,     0,     0,     0,   -82, &
    -55,   -28,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
      0,     0,     0,     0,     0,     0,     0,     0,     0, &
  ! test 1969-2016
      0,     0,     0,     0,     0,     0,     0,   -10,     8,    33,     0,     0,     0, &
   -110,   -80,   -39,     0,     0,     0,    46,    88,  -111,     0,     0,     0,     0, &
      0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0,     0, &
      0,     0,     0,     0,     0,     0,     0,     0,     0, &
  ! test 2017-2064
     30,    33,    36,    39,    42,    45,     0,     0,     0,     0,     0,     0,   -82, &
    -55,   -28,    -1,    26,    53,     0,     0,     0,     0,     0,     0,    62,   113, &
    -92,   -41,    10,    61,     0,     0,     0,     0,     0,     0,   -50,    25,   100, &
    -81,    -6,    69,     0,     0,     0,     0,     0,     0, &
  ! test 2065-2112
     48,     0,    54,     0,    60,     0,   -64,     0,   -34,     0,    -4,     0,    80, &
      0,  -122,     0,   -68,     0,   -32,     0,    46,     0,   124,     0,   112,     0, &
    -42,     0,    60,     0,     0,     0,   126,     0,    -4,     0,  -112,     0,    38, &
      0,   -68,     0,    32,     0,   -50,     0,   124,     0/

  
  ! test 1-48
  arr3=0
  arr3 = matmul(arr1,arr2)
  call assign_result(1,48,arr3,results)
  !print *,"test 1-48"
  !print *,arr3
  
  ! test 49-96
  arr3=0
  arr3(2:n_extent,:) = matmul(arr1(2:n_extent,:),arr2)
  call assign_result(49,96,arr3,results)
  !print *,"test 49-96"
  !print *,arr3
  
  ! test 97-144
  arr3=0
  arr3(1:n_extent-1,:) = matmul(arr1(1:n_extent-1,:),arr2)
  call assign_result(97,144,arr3,results)
  !print *,"test 97-144"
  !print *,arr3
  
  ! test 145-192
  arr3=0
  arr3 = matmul(arr1(:,2:m_extent),arr2(2:m_extent,:))
  call assign_result(145,192,arr3,results)
  !print *,"test 145-192"
  !print *,arr3
  
  ! test 193-240
  arr3=0
  arr3 = matmul(arr1(:,2:m_extent),arr2(2:m_extent,:))
  call assign_result(193,240,arr3,results)
  !print *,"test 193-240"
  !print *,arr3
  
  ! test 241-288
  arr3=0
  arr3 = matmul(arr1(:,1:m_extent-1),arr2(1:m_extent-1,:))
  call assign_result(241,288,arr3,results)
  !print *,"test 241-288"
  !print *,arr3
  
  ! test 289-336
  arr3=0
  arr3(1:3,1:3) = matmul(arr1(1:3,1:3),arr2(1:3,1:3))
  call assign_result(289,336,arr3,results)
  !print *,"test 289-336"
  !print *,arr3
  
  ! test 337-384
  arr3=0
  arr3(2:4,2:4) = matmul(arr1(2:4,2:4),arr2(2:4,2:4))
  call assign_result(337,384,arr3,results)
  !print *,"test 337-384"
  !print *,arr3
  
  ! test 385-432
  arr3=0
  arr3(:,1:k_extent:2) = matmul(arr1(:,1:m_extent-1),arr2(1:m_extent-1,1:k_extent:2))
  call assign_result(385,432,arr3,results)
  !print *,"test 385-432"
  !print *,arr3
  
  ! test 433-480
  arr3=0
  arr3(1:n_extent:2,:) = matmul(arr1(1:n_extent:2,2:m_extent),arr2(1:m_extent-1,:))
  call assign_result(433,480,arr3,results)
  !print *,"test 433-480"
  !print *,arr3
  
  ! test 481-528
  arr3=0
  arr3(1:n_extent:2,1:k_extent:2) = matmul(arr1(1:n_extent:2,1:m_extent-1),      &
                                           arr2(1:m_extent-1,1:k_extent:2))
  call assign_result(481,528,arr3,results)
  !print *,"test 481-528"
  !print *,arr3
  
  ! test 529-576
  arr3=0
  arr3(1:n_extent-1:2,1:k_extent-1:2) = matmul(arr1(1:n_extent-1:2,2:m_extent),	&
                                               arr2(1:m_extent-1,1:k_extent:2))
  call assign_result(529,576,arr3,results)
  !print *,"test 529-576"
  !print *,arr3
  
  ! test 577-624
  arr3=0
  arr3(2:n_extent:2,2:k_extent:2) = matmul(arr1(2:n_extent:2,1:m_extent-1),	&
                                               arr2(2:m_extent,2:k_extent:2))
  call assign_result(577,624,arr3,results)
  !print *,"test 577-624"
  !print *,arr3
  
  ! test 625-672
  arr3=0
  arr3(n_extent:1:-2,1:k_extent:2) = matmul(arr1(n_extent:1:-2,1:m_extent-1),      &
                                           arr2(1:m_extent-1,k_extent:1:-2))
  call assign_result(625,672,arr3,results)
  !print *,"test 625-672"
  !print *,arr3
  
  ! test 673-720
  arr3=0
  arr3(1:n_extent-1:2,k_extent-1:1:-2) = matmul(arr1(1:n_extent-1:2,m_extent:2:-1),	&
                                               arr2(m_extent-1:1:-1,1:k_extent:2))
  call assign_result(673,720,arr3,results)
  !print *,"test 673-720"
  !print *,arr3
  
  ! test 721-768
  arr3=0
  arr3(n_extent:2:-2,k_extent:2:-2) = matmul(arr1(n_extent:2:-2,m_extent-1:1:-1),	&
                                               arr2(m_extent:2:-1,k_extent:2:-2))
  call assign_result(721,768,arr3,results)
  !print *,"test 721-768"
  !print *,arr3
  
  ! test 769-864
  arr10=0
  arr10(2:4,2:4:1) = matmul(arr4(2:4,2:4,1),arr7(1,2:4,2:4))
  call assign_result(769,864,arr10,results)
  !print *,"test 769-864"
  !print *,arr10
  
  ! test 865-960
  arr11=0
  arr11(:,1,1:k_extent:2) = matmul(arr4(:,1:m_extent-1,2),arr8(1:m_extent-1,1,1:k_extent:2))
  call assign_result(865,960,arr11,results)
  !print *,"test 865-960"
  !print *,arr11
  
  ! test 961-1056
  arr12=0
  arr12(2,1:n_extent:2,:) = matmul(arr4(1:n_extent:2,2:m_extent,2),arr9(1:m_extent-1,:,2))
  call assign_result(961,1056,arr12,results)
  !print *,"test 961-1056"
  !print *,arr12
  
  ! test 1057-1152
  arr10=0
  arr10(1:n_extent:2,1:k_extent:2,2) = matmul(arr5(1:n_extent:2,2,1:m_extent-1),      &
                                           arr8(1:m_extent-1,2,1:k_extent:2))
  call assign_result(1057,1152,arr10,results)
  !print *,"test 1057-1152"
  !print *,arr10
  
  ! test 1153-1248
  arr11=0
  arr11(1:n_extent-1:2,2,1:k_extent-1:2) = matmul(arr5(1:n_extent-1:2,1,2:m_extent),	&
                                               arr9(1:m_extent-1,1:k_extent:2,1))
  call assign_result(1153,1248,arr11,results)
  !print *,"test 1153-1248"
  !print *,arr11
  
  ! test 1249-1344
  arr12=0
  arr12(1,2:n_extent:2,2:k_extent:2) = matmul(arr5(2:n_extent:2,2,1:m_extent-1),	&
                                               arr7(2,2:m_extent,2:k_extent:2))
  call assign_result(1249,1344,arr12,results)
  !print *,"test 1249-1344"
  !print *,arr12
  
  ! test 1345-1440
  arr10=0
  arr10(n_extent:1:-2,1:k_extent:2,1) = matmul(arr6(2,n_extent:1:-2,1:m_extent-1),      &
                                           arr9(1:m_extent-1,k_extent:1:-2,2))
  call assign_result(1345,1440,arr10,results)
  !print *,"test 1345-1440"
  !print *,arr10
  
  ! test 1441-1536
  arr11=0
  arr11(1:n_extent-1:2,2,k_extent-1:1:-2) = matmul(arr6(1,1:n_extent-1:2,m_extent:2:-1),	&
                                               arr7(2,m_extent-1:1:-1,1:k_extent:2))
  call assign_result(1441,1536,arr11,results)
  !print *,"test 1441-1536"
  !print *,arr11
  
  ! test 1537-163
  arr12=0
  arr12(2,n_extent:2:-2,k_extent:2:-2) = matmul(arr6(2,n_extent:2:-2,m_extent-1:1:-1),	&
                                               arr8(m_extent:2:-1,1,k_extent:2:-2))
  call assign_result(1537,1632,arr12,results)
  !print *,"test 1537-1632"
  !print *,arr12
  
  arr19 = 0

  ! test 1633-1680
  arr15=0
  arr15 =  arr19 + matmul(arr13,arr14)
  call assign_result(1633,1680,arr15,results)
  ! print *,arr15


  ! test 1681-1728
  arr18=0
  arr18 = arr19 +  matmul(arr16,arr17)
  call assign_result(1681,1728,arr18,results)
  ! print *,arr15

  ! test 1729-1776
  arr15=0
  arr15(2:n_extent,:) = matmul(arr13(2:n_extent,:),arr14)
  call assign_result(1729,1776,arr15,results)
  ! print *,arr15

  ! test 1777-1824
  arr15=0
  arr15 = arr19 + matmul(arr13(:,2:m_extent),arr14(3:m_extent+1,:))
  call assign_result(1777,1824,arr15,results)
  ! print *,arr15

  ! test 1825-1872
  arr15=0
  arr15 = arr19 + matmul(arr13(:,2:m_extent),arr14(3:m_extent+1,:))
  call assign_result(1825,1872,arr15,results)
  ! print *,arr15

  ! test 1873-1920
  arr15=0
  arr15 = arr19 + matmul(arr13(:,1:m_extent-1),arr14(2:m_extent,:))
  call assign_result(1873,1920,arr15,results)
  !print *,arr15

  !test 1921-1968
  arr15=0
  arr15(2:4,1:3) = arr19(2:4,1:3) + matmul(arr13(2:4,1:3),arr14(2:4,1:3))
  call assign_result(1921,1968,arr15,results)
  ! print *,arr15

  ! test 1969-2016
  arr15=0
  arr15(3:5,2:4) = arr19(3:5,2:4) + matmul(arr13(3:5,2:4),arr14(3:5,2:4))
  call assign_result(1969,2016,arr15,results)
  ! print *,arr15

  ! test 2017-2064
  arr15=0
  arr15(:,1:k_extent:2) = arr19(:,1:k_extent:2) +  &
                         matmul(arr13(:,1:m_extent-1),arr14(2:m_extent,1:k_extent:2))
  call assign_result(2017,2064,arr15,results)
  ! print *,arr15

  ! test 2065-2112
  arr15=0
  arr15(2:n_extent+1:2,:) = arr19(2:n_extent+1:2,:) +   &
                           matmul(arr13(2:n_extent+1:2,2:m_extent),arr14(2:m_extent,:))
  call assign_result(2065,2112,arr15,results)
  ! print *,arr15

  call check(results, expect, NbrTests)
end program

subroutine assign_result(s_idx, e_idx , arr, rslt)
  integer*1, dimension(1:e_idx-s_idx+1) :: arr
  integer*4, dimension(e_idx) :: rslt
  integer:: s_idx, e_idx

  rslt(s_idx:e_idx) = arr

end subroutine
