/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.media;

import android.content.Intent;
import android.media.MediaDescription;
import android.media.browse.MediaBrowser;
import android.os.Build;
import android.os.Bundle;
import android.os.IBinder;
import android.os.Parcel;
import android.os.RemoteException;
import android.os.ResultReceiver;
import android.support.v4.media.IMediaBrowserServiceAdapterApi21;
import android.support.v4.media.IMediaBrowserServiceCallbacksAdapterApi21;
import android.support.v4.media.ParceledListSliceAdapterApi21;
import java.util.ArrayList;
import java.util.List;

class MediaBrowserServiceCompatApi21 {
    MediaBrowserServiceCompatApi21() {
    }

    public static Object createService() {
        return new MediaBrowserServiceAdaptorApi21();
    }

    public static void onCreate(Object serviceObj, ServiceImplApi21 serviceImpl) {
        ((MediaBrowserServiceAdaptorApi21)serviceObj).onCreate(serviceImpl);
    }

    public static IBinder onBind(Object serviceObj, Intent intent) {
        return ((MediaBrowserServiceAdaptorApi21)serviceObj).onBind(intent);
    }

    static class MediaBrowserServiceAdaptorApi21 {
        ServiceBinderProxyApi21 mBinder;

        MediaBrowserServiceAdaptorApi21() {
        }

        public void onCreate(ServiceImplApi21 serviceImpl) {
            this.mBinder = new ServiceBinderProxyApi21(serviceImpl);
        }

        public IBinder onBind(Intent intent) {
            if ("android.media.browse.MediaBrowserService".equals(intent.getAction())) {
                return this.mBinder;
            }
            return null;
        }

        static class ServiceBinderProxyApi21
        extends IMediaBrowserServiceAdapterApi21.Stub {
            final ServiceImplApi21 mServiceImpl;

            ServiceBinderProxyApi21(ServiceImplApi21 serviceImpl) {
                this.mServiceImpl = serviceImpl;
            }

            @Override
            public void connect(String pkg, Bundle rootHints, Object callbacks) {
                this.mServiceImpl.connect(pkg, rootHints, new ServiceCallbacksApi21(callbacks));
            }

            @Override
            public void disconnect(Object callbacks) {
                this.mServiceImpl.disconnect(new ServiceCallbacksApi21(callbacks));
            }

            @Override
            public void addSubscription(String id, Object callbacks) {
                this.mServiceImpl.addSubscription(id, new ServiceCallbacksApi21(callbacks));
            }

            @Override
            public void removeSubscription(String id, Object callbacks) {
                this.mServiceImpl.removeSubscription(id, new ServiceCallbacksApi21(callbacks));
            }

            @Override
            public void getMediaItem(String mediaId, ResultReceiver receiver) {
            }
        }
    }

    public static class ServiceCallbacksApi21
    implements ServiceCallbacks {
        private static Object sNullParceledListSliceObj;
        private final IMediaBrowserServiceCallbacksAdapterApi21 mCallbacks;

        ServiceCallbacksApi21(Object callbacksObj) {
            this.mCallbacks = new IMediaBrowserServiceCallbacksAdapterApi21(callbacksObj);
        }

        @Override
        public IBinder asBinder() {
            return this.mCallbacks.asBinder();
        }

        @Override
        public void onConnect(String root, Object session, Bundle extras) throws RemoteException {
            this.mCallbacks.onConnect(root, session, extras);
        }

        @Override
        public void onConnectFailed() throws RemoteException {
            this.mCallbacks.onConnectFailed();
        }

        @Override
        public void onLoadChildren(String mediaId, List<Parcel> list) throws RemoteException {
            ArrayList<MediaBrowser.MediaItem> itemList = null;
            if (list != null) {
                itemList = new ArrayList<MediaBrowser.MediaItem>();
                for (Parcel parcel : list) {
                    parcel.setDataPosition(0);
                    itemList.add((MediaBrowser.MediaItem)MediaBrowser.MediaItem.CREATOR.createFromParcel(parcel));
                    parcel.recycle();
                }
            }
            Object pls = Build.VERSION.SDK_INT > 23 ? (itemList == null ? null : ParceledListSliceAdapterApi21.newInstance(itemList)) : (itemList == null ? sNullParceledListSliceObj : ParceledListSliceAdapterApi21.newInstance(itemList));
            this.mCallbacks.onLoadChildren(mediaId, pls);
        }

        static {
            MediaDescription nullDescription = new MediaDescription.Builder().setMediaId("android.support.v4.media.MediaBrowserCompat.NULL_MEDIA_ITEM").build();
            MediaBrowser.MediaItem nullMediaItem = new MediaBrowser.MediaItem(nullDescription, 0);
            ArrayList<MediaBrowser.MediaItem> nullMediaItemList = new ArrayList<MediaBrowser.MediaItem>();
            nullMediaItemList.add(nullMediaItem);
            sNullParceledListSliceObj = ParceledListSliceAdapterApi21.newInstance(nullMediaItemList);
        }
    }

    public static interface ServiceCallbacks {
        public IBinder asBinder();

        public void onConnect(String var1, Object var2, Bundle var3) throws RemoteException;

        public void onConnectFailed() throws RemoteException;

        public void onLoadChildren(String var1, List<Parcel> var2) throws RemoteException;
    }

    public static interface ServiceImplApi21 {
        public void connect(String var1, Bundle var2, ServiceCallbacks var3);

        public void disconnect(ServiceCallbacks var1);

        public void addSubscription(String var1, ServiceCallbacks var2);

        public void removeSubscription(String var1, ServiceCallbacks var2);
    }
}

