#!/usr/bin/env python
# -*- coding: utf-8 -*-

# Copyright (C) 2008-2009 Alessio Treglia
# Copyright (C) 2008 Andrea Gasparini <gaspa@yattaweb.it>
#
# This file is part of installation-report-generator.
#
# installation-report-generator is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# installation-report-generator is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with installation-report-generator.  If not, see <http://www.gnu.org/licenses/>.


AUTHOR = "Alessio Treglia"
AUTHOR_EMAIL = "quadrispro@ubuntu.com"
SHORT_APPNAME = "installation-report-generator"
VERSION = (0,2,3)

get_version = lambda: '.'.join(map(str, list(VERSION)))

__doc__ = """\
This file is part of installation-report-generator

installation-report-generator v%s - A simple application to
help in the generation of the installation report of Ubuntu on
laptops.

Copyright © 2008-2009  Alessio Treglia <quadrispro@ubuntu.com>
This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 3
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
""" % get_version()

LICENSE = """
This program is free software; you can redistribute it and/or \
modify it under the terms of the GNU General Public License \
as published by the Free Software Foundation; either version 3 \
of the License, or (at your option) any later version. \

This program is distributed in the hope that it will be useful, \
but WITHOUT ANY WARRANTY; without even the implied warranty of \
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the \
GNU General Public License for more details.

You should have received a copy of the GNU General Public License \
along with this program; if not, write to the Free Software \
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
"""

MAINTAINER_MODE_ON = 0

APP_PATH = ("/usr/share/installation-report-generator/",
        "/home/alessio/Documenti/devel/0.2/")[MAINTAINER_MODE_ON]


get_app_path = lambda x: ''.join([APP_PATH, x])

LANG_PATH = ("/usr/share/locale", get_app_path("po/"))[MAINTAINER_MODE_ON]
GLADE_PATH = get_app_path("glade/")
PIXMAPS_PATH = ("/usr/share/pixmaps/installation-report-generator/",
    get_app_path("images/"))[MAINTAINER_MODE_ON]
PLUGINS_PATH = get_app_path("plugins/")

GLADE_MAIN_WINDOW = ''.join([GLADE_PATH, 'main_window.glade'])
GLADE_ABOUT_DIALOG = ''.join([GLADE_PATH, 'about_dialog.glade'])

LOGO_PNG = ''.join([PIXMAPS_PATH, 'installation-report-generator.png'])
LOGO_SVG = ''.join([PIXMAPS_PATH, 'installation-report-generator.svg'])

HEADER_PNG = ''.join([PIXMAPS_PATH, 'header.png'])

RCFILE = ".irgenerator.rc"
