/*
 *  data.h - counts the data exchanged
 *
 *  (c) 1999-2001 Robert Cheramy <tibob@via.ecp.fr>
 *  (c) 1999      Andres Krapf <dae@via.ecp.fr>
 *  (c) 2001      Loc Tortay & IN2P3 Computing Center <tortay@cc.in2p3.fr>
 *
 */

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef DATA_H
#define DATA_H

#include "filter.h"

#define MAX_DATA_SIZE 100

struct ipfm_data {
  struct ipfm_data *prev, *next;
  u_int32_t ip;
  /* NOTE : the type "unsigned long long" may not work with your compiler.
     please do write us <ipfm@via.ecp.fr> if you are experiencing problems
     with the following line */
  unsigned long long in, out;
};


void data_add(struct AllLogsType *pLog, u_int32_t ip, int in, int out);
void data_dump(struct AllLogsType *pLog);
void data_clear(struct AllLogsType *pLog);
void DataSort(struct AllLogsType *pLog);
int DataCompareOut(const void *ptr1, const void *ptr2);
int DataCompareIn(const void *ptr1, const void *ptr2);
int DataCompareTotal(const void *ptr1, const void *ptr2);
void DataFormat(struct AllLogsType *pLog, struct ipfm_data *pData,
                char *pFormatedData, int BufLen);

#endif
