/***************************************************************************
                      kraftview.h  - view of kraft documents
                             -------------------
    begin                : Mit Dez 31 19:24:05 CET 2003
    copyright            : (C) 2003 by Klaas Freitag
    email                : freitag@kde.org
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KRAFTVIEW_RO_H
#define KRAFTVIEW_RO_H

// include files for Qt
#include <qwidget.h>
#include <qmap.h>
#include <QResizeEvent>
#include <QLabel>

#include <kdialog.h>
#include <kabc/addressee.h>

#include "kraftdoc.h"

/** The KraftViewRO class provides the read only view widget for Kraft documents.
 * The View instance inherits QWidget as a base class and represents
 * the view object of a KTMainWindow. As KraftView is part of the
 * docuement-view model, it needs a reference to the document object
 * connected with it by the KraftApp class to manipulate and display
 * the document structure provided by the KraftDoc class.
 *
 * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
 * @version KDevelop version 0.4 code generation
 */

#include "positionviewwidget.h"
#include "catalogtemplate.h"
#include "kraftview.h"

class DocHeaderEdit;
class DocFooterEdit;
class PositionViewWidget;
class DocPosition;
class QLabel;
class QResizeEvent;
class QSignalMapper;
class KVBox;
class QSplitter;
class DocPostCard;
class QTimer;
class CatalogSelection;
class KPushButton;
class DocAssistant;
class CalcPartList;
class HtmlView;

class Katalog;

class KraftViewRO : public KraftViewBase
{
public:
    /** Constructor for the main view */
    KraftViewRO(QWidget *parent, const char *name=0);
    /** Destructor for the main view */
    virtual ~KraftViewRO();

    void setup( DocGuardedPtr doc );

protected slots:
    void done( int );

signals:
    void positionSelected( Katalog*, void* );


private:
    KVBox *mGlobalVBox;
    HtmlView *mHtmlView;
};

#endif // KRAFTVIEW_RO_H
