<?php
/**
 * Internationalisation file for extension ParserFunctions.
 *
 * @file
 * @ingroup Extensions
 */

$messages = array();

$messages['en'] = array(
	'pfunc_desc'                            => 'Enhance parser with logical functions',
	'pfunc_time_error'                      => 'Error: Invalid time.',
	'pfunc_time_too_long'                   => 'Error: Too many #time calls.',
	'pfunc_time_too_big'                    => 'Error: #time only supports years up to 9999.',
	'pfunc_rel2abs_invalid_depth'           => 'Error: Invalid depth in path: "$1" (tried to access a node above the root node).',
	'pfunc_expr_stack_exhausted'            => 'Expression error: Stack exhausted.',
	'pfunc_expr_unexpected_number'          => 'Expression error: Unexpected number.',
	'pfunc_expr_preg_match_failure'         => 'Expression error: Unexpected preg_match failure.',
	'pfunc_expr_unrecognised_word'          => 'Expression error: Unrecognised word "$1".',
	'pfunc_expr_unexpected_operator'        => 'Expression error: Unexpected $1 operator.',
	'pfunc_expr_missing_operand'            => 'Expression error: Missing operand for $1.',
	'pfunc_expr_unexpected_closing_bracket' => 'Expression error: Unexpected closing bracket.',
	'pfunc_expr_unrecognised_punctuation'   => 'Expression error: Unrecognised punctuation character "$1".',
	'pfunc_expr_unclosed_bracket'           => 'Expression error: Unclosed bracket.',
	'pfunc_expr_division_by_zero'           => 'Division by zero.',
	'pfunc_expr_invalid_argument'           => 'Invalid argument for $1: < -1 or > 1.',
	'pfunc_expr_invalid_argument_ln'        => 'Invalid argument for ln: <= 0.',
	'pfunc_expr_unknown_error'              => 'Expression error: Unknown error ($1).',
	'pfunc_expr_not_a_number'               => 'In $1: Result is not a number.',
	'pfunc_string_too_long'                 => 'Error: String exceeds $1 character limit.',
	'pfunc-convert-dimensionmismatch'       => 'Error: Cannot convert between units of "$1" and "$2".',
	'pfunc-convert-unknownunit'             => 'Error: Unknown unit "$1".',
	'pfunc-convert-unknowndimension'        => 'Error: Unknown dimension "$1".',
	'pfunc-convert-invalidcompoundunit'     => 'Error: Invalid compound unit "$1".',
	'pfunc-convert-nounit'                  => 'Error: No source unit given.',
	'pfunc-convert-doublecompoundunit'      => 'Error: Cannot parse double compound units like "$1".',

	# DIMENSION NAMES
	'pfunc-convert-dimension-length'                 => 'length',
	'pfunc-convert-dimension-area'                   => 'area',
	'pfunc-convert-dimension-volume'                 => 'volume',
	'pfunc-convert-dimension-time'                   => 'time',
	'pfunc-convert-dimension-timesquared'            => 'time<sup>2</sup>',
	'pfunc-convert-dimension-mass'                   => 'mass',
	'pfunc-convert-dimension-speed'                  => 'speed',
	'pfunc-convert-dimension-temperature'            => 'temperature',
	'pfunc-convert-dimension-acceleration'           => 'acceleration',
	'pfunc-convert-dimension-force'                  => 'force',
	'pfunc-convert-dimension-torque'                 => 'torque',
	'pfunc-convert-dimension-energy'                 => 'energy',
	'pfunc-convert-dimension-power'                  => 'power',
	'pfunc-convert-dimension-pressure'               => 'pressure',
	'pfunc-convert-dimension-density'                => 'density',
	'pfunc-convert-dimension-fuelefficiencypositive' => 'fuelefficiencypositive',
	'pfunc-convert-dimension-fuelefficiencynegative' => 'fuelefficiencynegative',

	# SI PREFIXES

	'pfunc-convert-prefix-yotta' => 'yotta',
	'pfunc-convert-prefix-zetta' => 'zetta',
	'pfunc-convert-prefix-exa'   => 'exa',
	'pfunc-convert-prefix-peta'  => 'peta',
	'pfunc-convert-prefix-tera'  => 'tera',
	'pfunc-convert-prefix-giga'  => 'giga',
	'pfunc-convert-prefix-mega'  => 'mega',
	'pfunc-convert-prefix-kilo'  => 'kilo',
	'pfunc-convert-prefix-hecto' => 'hecto',
	'pfunc-convert-prefix-deca'  => 'deca',
	'pfunc-convert-prefix-deci'  => 'deci',
	'pfunc-convert-prefix-centi' => 'centi',
	'pfunc-convert-prefix-milli'  => 'milli',
	'pfunc-convert-prefix-micro' => 'micro',
	'pfunc-convert-prefix-nano'  => 'nano',
	'pfunc-convert-prefix-pico'  => 'pico',
	'pfunc-convert-prefix-femto' => 'femto',
	'pfunc-convert-prefix-atto'  => 'atto',
	'pfunc-convert-prefix-zepto' => 'zepto',
	'pfunc-convert-prefix-yocto' => 'yocto', 
	
	'pfunc-convert-prefix-yotta-abbr' => 'Y',
	'pfunc-convert-prefix-zetta-abbr' => 'Z',
	'pfunc-convert-prefix-exa-abbr'   => 'E',
	'pfunc-convert-prefix-peta-abbr'  => 'P',
	'pfunc-convert-prefix-tera-abbr'  => 'T',
	'pfunc-convert-prefix-giga-abbr'  => 'G',
	'pfunc-convert-prefix-mega-abbr'  => 'M',
	'pfunc-convert-prefix-kilo-abbr'  => 'k',
	'pfunc-convert-prefix-hecto-abbr' => 'h',
	'pfunc-convert-prefix-deca-abbr'  => 'da',
	'pfunc-convert-prefix-deci-abbr'  => 'd',
	'pfunc-convert-prefix-centi-abbr' => 'c',
	'pfunc-convert-prefix-milli-abbr'  => 'm',
	'pfunc-convert-prefix-micro-abbr' => 'μ',
	'pfunc-convert-prefix-nano-abbr'  => 'n',
	'pfunc-convert-prefix-pico-abbr'  => 'p',
	'pfunc-convert-prefix-femto-abbr' => 'f',
	'pfunc-convert-prefix-atto-abbr'  => 'a',
	'pfunc-convert-prefix-zepto-abbr' => 'z',
	'pfunc-convert-prefix-yocto-abbr' => 'y',

	# LENGTH
	'pfunc-convert-unit-length-metre' => '$1{{PLURAL:$2|$3meter|$3meters}}',
	'pfunc-convert-unit-length-angstrom' => '$1{{PLURAL:$2|angstrom|angstroms}}',
	'pfunc-convert-unit-length-mile' => '$1{{PLURAL:$2|mile|miles}}',
	'pfunc-convert-unit-length-furlong' => '$1{{PLURAL:$2|furlong|furlongs}}',
	'pfunc-convert-unit-length-chain' => '$1{{PLURAL:$2|chain|chains}}',
	'pfunc-convert-unit-length-rod' => '$1{{PLURAL:$2|rod|rods}}',
	'pfunc-convert-unit-length-fathom' => '$1{{PLURAL:$2|fathom|fathoms}}',
	'pfunc-convert-unit-length-yard' => '$1{{PLURAL:$2|yard|yards}}',
	'pfunc-convert-unit-length-foot' => '$1{{PLURAL:$2|foot|feet}}',
	'pfunc-convert-unit-length-hand' => '$1{{PLURAL:$2|hand|hands}}',
	'pfunc-convert-unit-length-inch' => '$1{{PLURAL:$2|inch|inches}}',
	'pfunc-convert-unit-length-nauticalmile' => '$1{{PLURAL:$2|nautical mile|nautical miles}}',
	'pfunc-convert-unit-length-nauticalmileuk' => '$1{{PLURAL:$2|nautical mile (pre-1970 British)|nautical miles (pre-1970 British)}}',
	'pfunc-convert-unit-length-nauticalmileus' => '$1{{PLURAL:$2|nautical mile (pre-1954 US)|nautical miles (pre-1954 US)}}',
	'pfunc-convert-unit-length-parsec' => '$1{{PLURAL:$2|$3parsec|$3parsecs}}',
	'pfunc-convert-unit-length-lightyear' => '$1{{PLURAL:$2|$3lightyear|$3lightyears}}',
	'pfunc-convert-unit-length-astronomicalunit' => '$1{{PLURAL:$2|astronomical unit|astronomical units}}',

	'pfunc-convert-unit-length-metre-abbr' => '$1$3m',
	'pfunc-convert-unit-length-angstrom-abbr' => '$1Å',
	'pfunc-convert-unit-length-mile-abbr' => '$1mi',
	'pfunc-convert-unit-length-furlong-abbr' => '$1furlong',
	'pfunc-convert-unit-length-chain-abbr' => '$1chain',
	'pfunc-convert-unit-length-rod-abbr' => '$1rd',
	'pfunc-convert-unit-length-fathom-abbr' => '$1fathom',
	'pfunc-convert-unit-length-yard-abbr' => '$1yd',
	'pfunc-convert-unit-length-foot-abbr' => '$1ft',
	'pfunc-convert-unit-length-hand-abbr' => '$1h',
	'pfunc-convert-unit-length-inch-abbr' => '$1in',
	'pfunc-convert-unit-length-nauticalmile-abbr' => '$1nmi',
	'pfunc-convert-unit-length-nauticalmileuk-abbr' => '$1nmi (Brit)',
	'pfunc-convert-unit-length-nauticalmileus-abbr' => '$1nmi (pre-1954 US)',
	'pfunc-convert-unit-length-parsec-abbr' => '$1$3pc',
	'pfunc-convert-unit-length-lightyear-abbr' => '$1$3ly',
	'pfunc-convert-unit-length-astronomicalunit-abbr' => '$1AU',

	# AREA #
	'pfunc-convert-unit-area-squarekilometre' => '$1{{PLURAL:$2|square kilometer|square kilometers}}',
	'pfunc-convert-unit-area-squaremetre' => '$1{{PLURAL:$2|square meter|square meters}}',
	'pfunc-convert-unit-area-squarecentimetre' => '$1{{PLURAL:$2|square centimeter|square centimeters}}',
	'pfunc-convert-unit-area-squaremillimetre' => '$1{{PLURAL:$2|square millimeter|square millimeters}}',
	'pfunc-convert-unit-area-hectare' => '$1{{PLURAL:$2|hectare|hectares}}',
	'pfunc-convert-unit-area-squaremile' => '$1{{PLURAL:$2|square mile|square miles}}',
	'pfunc-convert-unit-area-acre' => '$1{{PLURAL:$2|acre|acres}}',
	'pfunc-convert-unit-area-squareyard' => '$1{{PLURAL:$2|square yard|square yards}}',
	'pfunc-convert-unit-area-squarefoot' => '$1{{PLURAL:$2|square foot|square feet}}',
	'pfunc-convert-unit-area-squareinch' => '$1{{PLURAL:$2|square inch|square inches}}',
	'pfunc-convert-unit-area-squarenauticalmile' => '$1{{PLURAL:$2|square nautical mile|square nautical miles}}',
	'pfunc-convert-unit-area-dunam' => '$1{{PLURAL:$2|dunam|dunams}}',
	'pfunc-convert-unit-area-tsubo' => '$1{{PLURAL:$2|tsubo|tsubo}}',

	'pfunc-convert-unit-area-squarekilometre-abbr' => '$1km<sup>2</sup>',
	'pfunc-convert-unit-area-squaremetre-abbr' => '$1m<sup>2</sup>',
	'pfunc-convert-unit-area-squarecentimetre-abbr' => '$1cm<sup>2</sup>',
	'pfunc-convert-unit-area-squaremillimetre-abbr' => '$1mm<sup>2</sup>',
	'pfunc-convert-unit-area-hectare-abbr' => '$1ha',
	'pfunc-convert-unit-area-squaremile-abbr' => '$1sq mi',
	'pfunc-convert-unit-area-acre-abbr' => '$1acre',
	'pfunc-convert-unit-area-squareyard-abbr' => '$1sq yd',
	'pfunc-convert-unit-area-squarefoot-abbr' => '$1sq ft',
	'pfunc-convert-unit-area-squareinch-abbr' => '$1sq in',
	'pfunc-convert-unit-area-squarenauticalmile-abbr' => '$1sq nmi',
	'pfunc-convert-unit-area-dunam-abbr' => '$1dunam',
	'pfunc-convert-unit-area-tsubo-abbr' => '$1tsubo',

	# TIME #
	'pfunc-convert-unit-time-second' => '$1{{PLURAL:$2|second|seconds}}',
	'pfunc-convert-unit-time-year' => '$1{{PLURAL:$2|$3year|$3years}}',
	'pfunc-convert-unit-time-day' => '$1{{PLURAL:$2|day|days}}',
	'pfunc-convert-unit-time-hour' => '$1{{PLURAL:$2|hour|hours}}',
	'pfunc-convert-unit-time-minute' => '$1{{PLURAL:$2|minute|minutes}}',

	'pfunc-convert-unit-time-second-abbr' => '$1s',
	'pfunc-convert-unit-time-year-abbr' => '$1$3yr',
	'pfunc-convert-unit-time-day-abbr' => '$1day',
	'pfunc-convert-unit-time-hour-abbr' => '$1hr',
	'pfunc-convert-unit-time-minute-abbr' => '$1min',
	
	# VOLUME #
	'pfunc-convert-unit-volume-cubicmetre'      => '$1{{PLURAL:$2|cubic meter|cubic meters}}',
	'pfunc-convert-unit-volume-cubiccentimetre' => '$1{{PLURAL:$2|cubic centimeter|cubic centimeters}}',
	'pfunc-convert-unit-volume-cubicmillimetre' => '$1{{PLURAL:$2|cubic millimeter|cubic millimeters}}',
	'pfunc-convert-unit-volume-kilolitre'       => '$1{{PLURAL:$2|kiloliter|kiloliters}}',
	'pfunc-convert-unit-volume-litre'           => '$1{{PLURAL:$2|liter|liters}}',
	'pfunc-convert-unit-volume-centilitre'      => '$1{{PLURAL:$2|centiliter|centiliters}}',
	'pfunc-convert-unit-volume-millilitre'      => '$1{{PLURAL:$2|milliliter|milliliters}}',
	'pfunc-convert-unit-volume-cubicyard'       => '$1{{PLURAL:$2|cubic yard|cubic yards}}',
	'pfunc-convert-unit-volume-cubicfoot'       => '$1{{PLURAL:$2|cubic foot|cubic feet}}',
	'pfunc-convert-unit-volume-cubicinch'       => '$1{{PLURAL:$2|cubic inch|cubic inches}}',
	'pfunc-convert-unit-volume-barrel'          => '$1{{PLURAL:$2|barrel|barrels}}',
	'pfunc-convert-unit-volume-bushel'          => '$1{{PLURAL:$2|bushel|bushels}}',
	'pfunc-convert-unit-volume-gallon'          => '$1{{PLURAL:$2|gallon|gallons}}',
	'pfunc-convert-unit-volume-quart'           => '$1{{PLURAL:$2|quart|quarts}}',
	'pfunc-convert-unit-volume-pint'            => '$1{{PLURAL:$2|pint|pints}}',
	'pfunc-convert-unit-volume-fluidounce'      => '$1{{PLURAL:$2|fluid ounce|fluid ounces}}',
	'pfunc-convert-unit-volume-barrelus'        => '$1{{PLURAL:$2|US barrel|US barrels}}',
	'pfunc-convert-unit-volume-barreloil'       => '$1{{PLURAL:$2|barrel|barrel}}',
	'pfunc-convert-unit-volume-barrelbeer'      => '$1{{PLURAL:$2|barrel|barrel}}',
	'pfunc-convert-unit-volume-usgallon'        => '$1{{PLURAL:$2|US gallon|US gallons}}',
	'pfunc-convert-unit-volume-usquart'         => '$1{{PLURAL:$2|US quart|US quarts}}',
	'pfunc-convert-unit-volume-uspint'          => '$1{{PLURAL:$2|US pint|US pints}}',
	'pfunc-convert-unit-volume-usfluidounce'    => '$1{{PLURAL:$2|US fluid ounce|US fluid ounces}}',
	'pfunc-convert-unit-volume-usdrybarrel'     => '$1{{PLURAL:$2|US dry barrel|US dry barrels}}',
	'pfunc-convert-unit-volume-usbushel'        => '$1{{PLURAL:$2|US bushel|US bushels}}',
	'pfunc-convert-unit-volume-usdrygallon'     => '$1{{PLURAL:$2|US dry gallon|US dry gallons}}',
	'pfunc-convert-unit-volume-usdryquart'      => '$1{{PLURAL:$2|US dry quart|US dry quarts}}',
	'pfunc-convert-unit-volume-usdrypint'       => '$1{{PLURAL:$2|US dry pint|US dry pints}}',

	'pfunc-convert-unit-volume-cubicmetre-abbr'      => '$1m<sup>3</sup>',
	'pfunc-convert-unit-volume-cubiccentimetre-abbr' => '$1cm<sup>3</sup>',
	'pfunc-convert-unit-volume-cubicmillimetre-abbr' => '$1mm<sup>3</sup>',
	'pfunc-convert-unit-volume-litre-abbr'           => '$1$3l',
	'pfunc-convert-unit-volume-cubicyard-abbr'       => '$1cu yd',
	'pfunc-convert-unit-volume-cubicfoot-abbr'       => '$1cu ft',
	'pfunc-convert-unit-volume-cubicinch-abbr'       => '$1cu in',
	'pfunc-convert-unit-volume-barrel-abbr'          => '$1bbl',
	'pfunc-convert-unit-volume-bushel-abbr'          => '$1bsh',
	'pfunc-convert-unit-volume-gallon-abbr'          => '$1gal',
	'pfunc-convert-unit-volume-quart-abbr'           => '$1qt',
	'pfunc-convert-unit-volume-pint-abbr'            => '$1pt',
	'pfunc-convert-unit-volume-fluidounce-abbr'      => '$1fl oz',
	'pfunc-convert-unit-volume-barrelus-abbr'        => '$1US bbl',
	'pfunc-convert-unit-volume-barreloil-abbr'       => '$1bbl',
	'pfunc-convert-unit-volume-barrelbeer-abbr'      => '$1bbl',
	'pfunc-convert-unit-volume-usgallon-abbr'        => '$1US gal',
	'pfunc-convert-unit-volume-usquart-abbr'         => '$1US qt',
	'pfunc-convert-unit-volume-uspint-abbr'          => '$1US pt',
	'pfunc-convert-unit-volume-usfluidounce-abbr'    => '$1US fl oz',
	'pfunc-convert-unit-volume-usdrybarrel-abbr'     => '$1US bbl',
	'pfunc-convert-unit-volume-usbushel-abbr'        => '$1US bsh',
	'pfunc-convert-unit-volume-usdrygallon-abbr'     => '$1US dry gal',
	'pfunc-convert-unit-volume-usdryquart-abbr'      => '$1US dry qt',
	'pfunc-convert-unit-volume-usdrypint-abbr'       => '$1US dry pt',

	# SPEED
	'pfunc-convert-unit-speed-mile-hour'             => '$1miles per hour',
	'pfunc-convert-unit-speed-speedoflight'          => '$1c',

	'pfunc-convert-unit-speed-mile-hour-abbr'        => '$1mph',
	'pfunc-convert-unit-speed-speedoflight-abbr'     => '$1c',
	
	# PRESSURE
	'pfunc-convert-unit-pressure-pascal'            => '$1{{PLURAL:$2|$3pascal|$3pascals}}',
	'pfunc-convert-unit-pressure-bar'               => '$1bar',
	'pfunc-convert-unit-pressure-decibar'           => '$1decibar',
	'pfunc-convert-unit-pressure-millibar'          => '$1millibar',
	'pfunc-convert-unit-pressure-kilobarye'         => '$1kilobarye',
	'pfunc-convert-unit-pressure-barye'             => '$1barye',
	'pfunc-convert-unit-pressure-atmosphere'        => '$1{{PLURAL:$2|atmosphere|atmospheres}}',
	'pfunc-convert-unit-pressure-torr'              => '$1{{PLURAL:$2|Torr|Torr}}',
	'pfunc-convert-unit-pressure-mmhg'              => '$1{{PLURAL:$2|millimeter of mercury|millimeters of mercury}}',
	'pfunc-convert-unit-pressure-inhg'              => '$1{{PLURAL:$2|inch of mercury|inches of mercury}}',
	'pfunc-convert-unit-pressure-psi'               => '$1{{PLURAL:$2|pound per square-inch|pounds per square-inch}}',

	'pfunc-convert-unit-pressure-pascal-abbr'            => '$1$3Pa',
	'pfunc-convert-unit-pressure-bar-abbr'               => '$1bar',
	'pfunc-convert-unit-pressure-decibar-abbr'           => '$1dbar',
	'pfunc-convert-unit-pressure-millibar-abbr'          => '$1mbar',
	'pfunc-convert-unit-pressure-kilobarye-abbr'         => '$1kBa',
	'pfunc-convert-unit-pressure-barye-abbr'             => '$1Ba',
	'pfunc-convert-unit-pressure-atmosphere-abbr'        => '$1atm',
	'pfunc-convert-unit-pressure-torr-abbr'              => '$1Torr',
	'pfunc-convert-unit-pressure-mmhg-abbr'              => '$1mmHg',
	'pfunc-convert-unit-pressure-inhg-abbr'              => '$1inHg',
	'pfunc-convert-unit-pressure-psi-abbr'               => '$1psi',
);

/** Message documentation (Message documentation)
 * @author Jon Harald Søby
 * @author Kghbln
 * @author Meno25
 * @author Siebrand
 * @author The Evil IP address
 */
$messages['qqq'] = array(
	'pfunc_desc' => '{{desc}}',
	'pfunc_expr_division_by_zero' => '{{Identical|Divizion by zero}}',
	'pfunc_string_too_long' => 'PLURAL is supported for $1.',
	'pfunc-convert-unit-length-parsec-abbr' => 'The $3 is directly connected to the abbreviated unit to hold abbreviations like "kilo", "milli", "pico", etc.',
	'pfunc-convert-unit-length-lightyear-abbr' => 'The $3 is directly connected to the abbreviated unit to hold abbreviations like "kilo", "milli", "pico", etc.',
);

/** Afrikaans (Afrikaans)
 * @author Naudefj
 */
$messages['af'] = array(
	'pfunc_desc' => 'Verryk die ontleder met logiese funksies',
	'pfunc_time_error' => 'Fout: ongeldige tyd',
	'pfunc_time_too_long' => 'Fout: #time te veel kere geroep',
	'pfunc_rel2abs_invalid_depth' => 'Fout: Ongeldige diepte in pad: "$1" (probeer \'n node bo die wortelnode te roep)',
	'pfunc_expr_stack_exhausted' => 'Fout in uitdrukking: stack uitgeput',
	'pfunc_expr_unexpected_number' => 'Fout in uitdrukking: onverwagte getal',
	'pfunc_expr_preg_match_failure' => 'Fout in uitdrukking: onverwagte faling van preg_match',
	'pfunc_expr_unrecognised_word' => 'Fout in uitdrukking: woord "$1" nie herken',
	'pfunc_expr_unexpected_operator' => 'Fout in uitdrukking: onverwagte operateur $1',
	'pfunc_expr_missing_operand' => 'Fout in uitdrukking: geen operand vir $1',
	'pfunc_expr_unexpected_closing_bracket' => 'Fout in uitdrukking: hakkie onverwags gesluit',
	'pfunc_expr_unrecognised_punctuation' => 'Fout in uitdrukking: onbekende leesteken "$1"',
	'pfunc_expr_unclosed_bracket' => 'Fout in uitdrukking: hakkie nie gesluit nie',
	'pfunc_expr_division_by_zero' => 'Deling deur nul',
	'pfunc_expr_invalid_argument' => 'Ongeldige argument vir $1: < -1 of > 1',
	'pfunc_expr_invalid_argument_ln' => 'Ongeldige argument vir ln: <= 0',
	'pfunc_expr_unknown_error' => 'Fout in uitdrukking: onbekende fout ($1)',
	'pfunc_expr_not_a_number' => "In $1: resultaat is nie 'n getal nie",
	'pfunc_string_too_long' => 'Fout: String oorskry $1 karakter limiet',
);

/** Gheg Albanian (Gegë)
 * @author Mdupont
 */
$messages['aln'] = array(
	'pfunc_desc' => 'Enhance parser me funksione logjike',
	'pfunc_time_error' => 'Gabim: koha e pavlefshme',
	'pfunc_time_too_long' => 'Gabim: kohë shumë # thirrjet',
	'pfunc_rel2abs_invalid_depth' => 'Gabim: thellësia e pavlefshme në rrugën: "$1" (u përpoq për të hyrë në një nyjë mbi nyjen e rrënjë)',
	'pfunc_expr_stack_exhausted' => 'gabim Shprehja: qipi rraskapitur',
	'pfunc_expr_unexpected_number' => 'gabim Shprehja: Numri i papritur',
);

/** Aragonese (Aragonés)
 * @author Juanpabl
 */
$messages['an'] = array(
	'pfunc_desc' => 'Amillorar o parseyador con funcions lochicas',
	'pfunc_time_error' => 'Error: tiempo incorreuto',
	'pfunc_time_too_long' => 'Error: masiadas cridas #time',
	'pfunc_rel2abs_invalid_depth' => 'Error: Fondura incorreuta en o camín: "$1" (ha prebato d\'acceder ta un nodo por dencima d\'o nodo radiz)',
	'pfunc_expr_stack_exhausted' => "Error d'expresión: Pila acotolada",
	'pfunc_expr_unexpected_number' => "Error d'expresión: numero no asperato",
	'pfunc_expr_preg_match_failure' => "Error d'expresión: fallo de preg_match no asperato",
	'pfunc_expr_unrecognised_word' => 'Error d\'expresión: parola "$1" no reconoixita',
	'pfunc_expr_unexpected_operator' => "Error d'expresión: operador $1 no asperato",
	'pfunc_expr_missing_operand' => "Error d'expresión: a $1 li falta un operando",
	'pfunc_expr_unexpected_closing_bracket' => "Error d'expresión: zarradura d'o gafet no asperata",
	'pfunc_expr_unrecognised_punctuation' => 'Error d\'expresión: carácter de puntuación "$1" no reconoixito',
	'pfunc_expr_unclosed_bracket' => "Error d'expresión: gafet sin zarrar",
	'pfunc_expr_division_by_zero' => 'División por zero',
	'pfunc_expr_invalid_argument' => 'Argumento no conforme ta $1: < -1 u > 1',
	'pfunc_expr_invalid_argument_ln' => 'Argumento no conforme ta ln: <=0',
	'pfunc_expr_unknown_error' => "Error d'expresión: error esconoixito ($1)",
	'pfunc_expr_not_a_number' => 'En $1: o resultau no ye un numero',
);

/** Arabic (العربية)
 * @author Aiman titi
 * @author Meno25
 */
$messages['ar'] = array(
	'pfunc_desc' => 'محلل ممدد بدوال منطقية',
	'pfunc_time_error' => 'خطأ: زمن غير صحيح',
	'pfunc_time_too_long' => 'خطأ: استدعاءات #time كثيرة جدا',
	'pfunc_time_too_big' => 'خطأ : # الوقت يدعم فقط حتى 9999 سنة',
	'pfunc_rel2abs_invalid_depth' => 'خطأ: عمق غير صحيح في المسار: "$1" (حاول دخول عقدة فوق العقدة الجذرية)',
	'pfunc_expr_stack_exhausted' => 'خطأ في التعبير: ستاك مجهد',
	'pfunc_expr_unexpected_number' => 'خطأ في التعبير: رقم غير متوقع',
	'pfunc_expr_preg_match_failure' => 'خطأ في التعبير: فشل preg_match غير متوقع',
	'pfunc_expr_unrecognised_word' => 'خطأ في التعبير: كلمة غير متعرف عليها "$1"',
	'pfunc_expr_unexpected_operator' => 'خطأ في التعبير: عامل $1 غير متوقع',
	'pfunc_expr_missing_operand' => 'خطأ في التعبير: operand مفقود ل$1',
	'pfunc_expr_unexpected_closing_bracket' => 'خطأ في التعبير: قوس إغلاق غير متوقع',
	'pfunc_expr_unrecognised_punctuation' => 'خطأ في التعبير: علامة ترقيم غير متعرف عليها "$1"',
	'pfunc_expr_unclosed_bracket' => 'خطأ في التعبير: قوس غير مغلق',
	'pfunc_expr_division_by_zero' => 'القسمة على صفر',
	'pfunc_expr_invalid_argument' => 'مدخلة غير صحيحة ل $1: < -1 أو > 1',
	'pfunc_expr_invalid_argument_ln' => 'مدخلة غير صحيحة ل ln: <= 0',
	'pfunc_expr_unknown_error' => 'خطأ في التعبير: خطأ غير معروف ($1)',
	'pfunc_expr_not_a_number' => 'في $1: النتيجة ليست رقما',
	'pfunc_string_too_long' => 'خطأ: السلسلة تتجاوز الحد $1 حرف',
);

/** Aramaic (ܐܪܡܝܐ)
 * @author Basharh
 */
$messages['arc'] = array(
	'pfunc_time_error' => 'ܦܘܕܐ: ܥܕܢܐ ܠܐ ܬܪܝܨܬܐ',
);

/** Egyptian Spoken Arabic (مصرى)
 * @author Ghaly
 * @author Meno25
 * @author Ramsis II
 */
$messages['arz'] = array(
	'pfunc_desc' => 'محلل متدعم ب دوال منطقية',
	'pfunc_time_error' => 'غلطه:وقت مش صحيح',
	'pfunc_time_too_long' => 'غلط: استدعاءات #time كتيرة قوى',
	'pfunc_rel2abs_invalid_depth' => 'غلط: عمق مش صحيح فى المسار: "$1" (حاول دخول عقدة فوق العقدة الجزرية)',
	'pfunc_expr_stack_exhausted' => 'غلط فى التعبير: ستاك مجهد',
	'pfunc_expr_unexpected_number' => 'غلط فى التعبير: رقم مش متوقع',
	'pfunc_expr_preg_match_failure' => 'غلط تعبيري: فشل مش متوقع فى preg_match',
	'pfunc_expr_unrecognised_word' => 'غلط تعبيري: كلمة مش متعرف عليها "$1"',
	'pfunc_expr_unexpected_operator' => 'غلط تعبيري: عامل $1 مش متوقع',
	'pfunc_expr_missing_operand' => 'غلط تعبيري: operand بتاع $1 ضايع',
	'pfunc_expr_unexpected_closing_bracket' => 'غلط تعبيري:قوس قفل مش متوقع',
	'pfunc_expr_unrecognised_punctuation' => 'غلط تعبيري:علامة الترقيم "$1" مش متعرف عليها',
	'pfunc_expr_unclosed_bracket' => 'غلط تعبيري:قوس مش مقفول',
	'pfunc_expr_division_by_zero' => 'القسمه على صفر',
	'pfunc_expr_invalid_argument' => 'مدخلة مش صحيحة لـ $1: < -1 or > 1',
	'pfunc_expr_invalid_argument_ln' => 'مدخلة مش صحيحة لـ ln: <= 0',
	'pfunc_expr_unknown_error' => '($1)غلط تعبيري: غلط مش معروف',
	'pfunc_expr_not_a_number' => 'فى $1: النتيجه مش رقم',
);

/** Assamese (অসমীয়া)
 * @author Rajuonline
 */
$messages['as'] = array(
	'pfunc_time_error' => 'ভুল: অযোগ্য সময়',
);

/** Asturian (Asturianu)
 * @author Esbardu
 * @author Xuacu
 */
$messages['ast'] = array(
	'pfunc_desc' => "Ameyora l'análisis sintáuticu con funciones llóxiques",
	'pfunc_time_error' => 'Error: tiempu non válidu',
	'pfunc_time_too_long' => 'Error: demasiaes llamaes #time',
	'pfunc_rel2abs_invalid_depth' => 'Error: Nivel de subdireutoriu non válidu: "$1" (intentu d\'accesu penriba del direutoriu raíz)',
	'pfunc_expr_stack_exhausted' => "Error d'espresión: Pila escosada",
	'pfunc_expr_unexpected_number' => "Error d'espresión: Númberu inesperáu",
	'pfunc_expr_preg_match_failure' => "Error d'espresión: Fallu inesperáu de preg_match",
	'pfunc_expr_unrecognised_word' => 'Error d\'espresión: Pallabra "$1" non reconocida',
	'pfunc_expr_unexpected_operator' => "Error d'espresión: Operador $1 inesperáu",
	'pfunc_expr_missing_operand' => "Error d'espresión: Falta operador en $1",
	'pfunc_expr_unexpected_closing_bracket' => "Error d'espresión: Paréntesis final inesperáu",
	'pfunc_expr_unrecognised_punctuation' => 'Error d\'espresión: Caráuter de puntuación "$1" non reconocíu',
	'pfunc_expr_unclosed_bracket' => "Error d'espresión: Paréntesis non zarráu",
	'pfunc_expr_division_by_zero' => 'División por cero',
	'pfunc_expr_invalid_argument' => 'Argumentu non válidu pa $1: < -1 o > 1',
	'pfunc_expr_invalid_argument_ln' => 'Argumentu non válidu pa ln: <= 0',
	'pfunc_expr_unknown_error' => "Error d'espresión: Error desconocíu ($1)",
	'pfunc_expr_not_a_number' => 'En $1: el resultáu nun ye un númberu',
	'pfunc_string_too_long' => 'Error: la cadena pasa la llende de $1 caráuteres',
	'pfunc-convert-unit-length-metre' => '{{PLURAL:$1|$2metru|$2metros}}',
	'pfunc-convert-unit-length-angstrom' => '{{PLURAL:$1|angstrom|angstroms}}',
	'pfunc-convert-unit-length-mile' => '{{PLURAL:$1|milla|milles}}',
	'pfunc-convert-unit-length-yard' => '{{PLURAL:$1|yarda|yardes}}',
	'pfunc-convert-unit-length-foot' => '{{PLURAL:$1|pie|pies}}',
	'pfunc-convert-unit-area-squarekilometre' => '{{PLURAL:$1|quilómetru cuadráu|quilómetros cuadraos}}',
	'pfunc-convert-unit-area-squaremetre' => '{{PLURAL:$1|metru cuadráu|metros cuadraos}}',
	'pfunc-convert-unit-area-squarekilometre-abbr' => 'km<sup>2</sup>',
	'pfunc-convert-unit-area-squaremetre-abbr' => 'm<sup>2</sup>',
	'pfunc-convert-unit-area-squarecentimetre-abbr' => 'cm<sup>2</sup>',
	'pfunc-convert-unit-area-squaremillimetre-abbr' => 'mm<sup>2</sup>',
	'pfunc-convert-unit-area-hectare-abbr' => 'ha',
	'pfunc-convert-unit-time-second' => '{{PLURAL:$1|segundu|segundos}}',
	'pfunc-convert-unit-time-year' => '{{PLURAL:$1|$2añu|$2años}}',
	'pfunc-convert-unit-time-day' => '{{PLURAL:$1|día|díes}}',
	'pfunc-convert-unit-time-hour' => '{{PLURAL:$1|hora|hores}}',
	'pfunc-convert-unit-time-minute' => '{{PLURAL:$1|minutu|minutos}}',
	'pfunc-convert-unit-time-second-abbr' => 's',
	'pfunc-convert-unit-time-year-abbr' => '$2añ',
	'pfunc-convert-unit-time-day-abbr' => 'día',
	'pfunc-convert-unit-time-hour-abbr' => 'h',
	'pfunc-convert-unit-time-minute-abbr' => 'min',
	'pfunc-convert-unit-volume-cubicmetre' => '{{PLURAL:$1|metru cúbicu|metros cúbicos}}',
	'pfunc-convert-unit-volume-cubiccentimetre' => '{{PLURAL:$1|centímetru cúbicu|centímetros cúbicos}}',
	'pfunc-convert-unit-volume-cubicmillimetre' => '{{PLURAL:$1|milímetru cúbicu|milímetros cúbicos}}',
	'pfunc-convert-unit-volume-kilolitre' => '{{PLURAL:$1|kilollitru|kilollitros}}',
	'pfunc-convert-unit-volume-litre' => '{{PLURAL:$1|llitru|llitros}}',
	'pfunc-convert-unit-volume-centilitre' => '{{PLURAL:$1|centillitru|centillitros}}',
	'pfunc-convert-unit-volume-millilitre' => '{{PLURAL:$1|milillitru|milillitros}}',
	'pfunc-convert-unit-volume-cubicmetre-abbr' => 'm<sup>3</sup>',
	'pfunc-convert-unit-volume-cubiccentimetre-abbr' => 'cm<sup>3</sup>',
	'pfunc-convert-unit-volume-cubicmillimetre-abbr' => 'mm<sup>3</sup>',
	'pfunc-convert-unit-volume-litre-abbr' => '$2l',
	'pfunc-convert-unit-speed-mile-hour' => 'milles por hora',
	'pfunc-convert-unit-pressure-pascal' => '{{PLURAL:$1|$2pascal|$2pascales}}',
	'pfunc-convert-unit-pressure-bar' => 'bar',
	'pfunc-convert-unit-pressure-decibar' => 'decibar',
	'pfunc-convert-unit-pressure-millibar' => 'milibar',
	'pfunc-convert-unit-pressure-kilobarye' => 'kilobario',
	'pfunc-convert-unit-pressure-barye' => 'bario',
	'pfunc-convert-unit-pressure-atmosphere' => '{{PLURAL:$1|atmósfera|atmósferes}}',
	'pfunc-convert-unit-pressure-pascal-abbr' => '$2Pa',
	'pfunc-convert-unit-pressure-bar-abbr' => 'bar',
	'pfunc-convert-unit-pressure-decibar-abbr' => 'dbar',
	'pfunc-convert-unit-pressure-millibar-abbr' => 'mbar',
	'pfunc-convert-unit-pressure-kilobarye-abbr' => 'kBa',
	'pfunc-convert-unit-pressure-barye-abbr' => 'Ba',
	'pfunc-convert-unit-pressure-atmosphere-abbr' => 'atm',
);

/** Azerbaijani (Azərbaycanca)
 * @author Cekli829
 */
$messages['az'] = array(
	'pfunc_time_error' => 'Xəta: yanlış zaman',
);

/** Bashkir (Башҡортса)
 * @author Assele
 */
$messages['ba'] = array(
	'pfunc_desc' => 'Логик функциялар менән яҡшыртылған уҡыу ҡоралы',
	'pfunc_time_error' => 'Хата: ваҡыт дөрөҫ түгел',
	'pfunc_time_too_long' => 'Хата: #time функцияһы бигерәк күп саҡырылған',
	'pfunc_rel2abs_invalid_depth' => 'Хата: "$1" юлының тәрәнлеге дөрөҫ түгел (тәүге төйөндән өҫтәрәк торған төйөндө асырға тырышыу)',
	'pfunc_expr_stack_exhausted' => 'Аңлатма хатаһы: Стек тулған',
	'pfunc_expr_unexpected_number' => 'Аңлатма хатаһы: Көтөлмәгән һан',
	'pfunc_expr_preg_match_failure' => 'Аңлатма хатаһы: Көтөлмәгән preg_match хатаһы',
	'pfunc_expr_unrecognised_word' => 'Аңлатма хатаһы: Танылмаған "$1" һүҙе',
	'pfunc_expr_unexpected_operator' => 'Аңлатма хатаһы: Көтөлмәгән $1 операторы',
	'pfunc_expr_missing_operand' => 'Аңлатма хатаһы: $1 аңлатмаһы өсөн операнд етмәй',
	'pfunc_expr_unexpected_closing_bracket' => 'Аңлатма хатаһы: Көтөлмәгән ябыу йәйәһе',
	'pfunc_expr_unrecognised_punctuation' => 'Аңлатма хатаһы: Танылмаған "$1" тыныш билдәһе',
	'pfunc_expr_unclosed_bracket' => 'Аңлатма хатаһы: Ябылмаған йәйә',
	'pfunc_expr_division_by_zero' => 'Нулгә бүлеү хатаһы',
	'pfunc_expr_invalid_argument' => '$1 өсөн аргумент дөрөҫ түгел: < -1 йәки > 1',
	'pfunc_expr_invalid_argument_ln' => 'ln өсөн аргумент дөрөҫ түгел: <= 0',
	'pfunc_expr_unknown_error' => 'Аңлатма хатаһы: Билдәһеҙ хата ($1)',
	'pfunc_expr_not_a_number' => '$1: һөҙөмтә — һан түгел',
	'pfunc_string_too_long' => 'Хата: Юл оҙонлоғо билдәләнгән сиктән — $1 хәрефтән — ашҡан',
);

/** Southern Balochi (بلوچی مکرانی)
 * @author Mostafadaneshvar
 */
$messages['bcc'] = array(
	'pfunc_desc' => 'تجزیه کنوکء بهتر کن گون عملگر آن منطقی',
	'pfunc_time_error' => 'حطا: نامعتبر وهد',
	'pfunc_time_too_long' => 'حطا: بازگین #زمان سوج',
	'pfunc_rel2abs_invalid_depth' => 'حطا: نامعتبر عمق ته مسیر: "$1"(سعی کتن په یک بالادی گرهنی چه ریشگی گرهنانا برسیت)',
	'pfunc_expr_stack_exhausted' => 'حطا اصطلاح: توده حالیک',
	'pfunc_expr_unexpected_number' => 'حطا اصطلاح: غیر منظرین شماره',
	'pfunc_expr_preg_match_failure' => 'حطا اصطلاح: غیرمنتظره این preg_ همسانی پروش وارت',
	'pfunc_expr_unrecognised_word' => 'حطا اصطلاح: نا شناسین کلمه  "$1"',
	'pfunc_expr_unexpected_operator' => 'حطا اصطلاح:نه لوٹتین  $1 اپراتور',
	'pfunc_expr_missing_operand' => 'حطا اصطلاح: گارین عملوند په $1',
	'pfunc_expr_unexpected_closing_bracket' => 'حطا اصطلاح: نه لوٹتگین براکت بندگ',
	'pfunc_expr_unrecognised_punctuation' => 'حطا اصطلاح: ناشناسین کاراکتر نشانه هلگی "$1"',
	'pfunc_expr_unclosed_bracket' => 'حطا اصطلاح: نه بسته گین براکت',
	'pfunc_expr_division_by_zero' => 'تقسیم بر صفر',
	'pfunc_expr_invalid_argument' => 'نامعتبر آرگومان په  $1: < -1 یا > 1',
	'pfunc_expr_invalid_argument_ln' => 'نامعتبر آرگومان ته شی : <= 0',
	'pfunc_expr_unknown_error' => 'حطا اصطلاح :ناشناسین حطا ($1)',
	'pfunc_expr_not_a_number' => 'ته $1: نتیجه یک عددی نهنت',
);

/** Belarusian (Taraškievica orthography) (‪Беларуская (тарашкевіца)‬)
 * @author EugeneZelenko
 * @author Jim-by
 * @author Red Winged Duck
 */
$messages['be-tarask'] = array(
	'pfunc_desc' => 'Палепшаны парсэр зь лягічнымі функцыямі',
	'pfunc_time_error' => 'Памылка: няслушны час',
	'pfunc_time_too_long' => 'Памылка: зашмат выклікаў функцыі #time',
	'pfunc_time_too_big' => 'Памылка: #time падтрымлівае гады толькі ў дыяпазоне да 9999',
	'pfunc_rel2abs_invalid_depth' => 'Памылка: няслушная глыбіня шляху: «$1» (спроба доступу да вузла, які знаходзіцца вышэй карэннага)',
	'pfunc_expr_stack_exhausted' => 'Памылка выразу: стэк перапоўнены',
	'pfunc_expr_unexpected_number' => 'Памылка выразу: нечаканая лічба',
	'pfunc_expr_preg_match_failure' => 'Памылка выразу: нечаканая памылка preg_match',
	'pfunc_expr_unrecognised_word' => 'Памылка выразу: нераспазнанае слова «$1»',
	'pfunc_expr_unexpected_operator' => 'Памылка выразу: нечаканы апэратар $1',
	'pfunc_expr_missing_operand' => 'Памылка выразу: няма апэранду $1',
	'pfunc_expr_unexpected_closing_bracket' => 'Памылка выразу: нечаканая закрываючая дужка',
	'pfunc_expr_unrecognised_punctuation' => 'Памылка выразу: нераспазнаны сымбаль пунктуацыі «$1»',
	'pfunc_expr_unclosed_bracket' => 'Памылка выразу: незакрытая дужка',
	'pfunc_expr_division_by_zero' => 'Дзяленьне на нуль',
	'pfunc_expr_invalid_argument' => 'Памылковы аргумэнт для $1: < -1 ці > 1',
	'pfunc_expr_invalid_argument_ln' => 'Памылковы аргумэнт для ln: <= 0',
	'pfunc_expr_unknown_error' => 'Памылка выразу: невядомая памылка ($1)',
	'pfunc_expr_not_a_number' => 'У $1: вынік не зьяўляецца лічбай',
	'pfunc_string_too_long' => 'Памылка: у радку перавышаны ліміт $1 {{PLURAL:$1|сымбаль|сымбалі|сымбаляў}}',
);

/** Bulgarian (Български)
 * @author DCLXVI
 * @author Spiritia
 */
$messages['bg'] = array(
	'pfunc_desc' => 'Подобряване на парсера с логически функции',
	'pfunc_time_error' => 'Грешка: невалидно време',
	'pfunc_time_too_long' => 'Грешка: Твърде много извиквания на #time',
	'pfunc_rel2abs_invalid_depth' => 'Грешка: Невалидна дълбочина в път: "$1" (опит за достъп на възел над корена)',
	'pfunc_expr_stack_exhausted' => 'Грешка в записа: Стекът е изчерпан',
	'pfunc_expr_unexpected_number' => 'Грешка в записа: Неочаквано число',
	'pfunc_expr_preg_match_failure' => 'Грешка в израза: Неочакван проблем с preg_match',
	'pfunc_expr_unrecognised_word' => 'Грешка в записа: Неразпозната дума "$1"',
	'pfunc_expr_unexpected_operator' => 'Грешка в записа: Неочакван оператор $1',
	'pfunc_expr_missing_operand' => 'Грешка в записа: Липсващ операнд в $1',
	'pfunc_expr_unexpected_closing_bracket' => 'Грешка в записа: Една затваряща скоба в повече',
	'pfunc_expr_unrecognised_punctuation' => 'Грешка в записа: Неразпознат пунктуационен знак "$1"',
	'pfunc_expr_unclosed_bracket' => 'Грешка в записа: Незатворена скоба',
	'pfunc_expr_division_by_zero' => 'Деление на нула',
	'pfunc_expr_invalid_argument' => 'Невалиден аргумент за $1: < -1 или > 1',
	'pfunc_expr_invalid_argument_ln' => 'Невалиден аргумент за ln: <= 0',
	'pfunc_expr_unknown_error' => 'Грешка в записа: Неразпозната грешка ($1)',
	'pfunc_expr_not_a_number' => 'В $1: резултатът не е число',
	'pfunc_string_too_long' => 'Грешка: Низът превишава лимита от $1 знака',
);

/** Bengali (বাংলা)
 * @author Bellayet
 * @author Zaheen
 */
$messages['bn'] = array(
	'pfunc_desc' => 'লজিকাল ফাংশন দিয়ে পার্সারকে উন্নত করুন',
	'pfunc_time_error' => 'ত্রুটি: অবৈধ সময়',
	'pfunc_time_too_long' => 'ত্রুটি: অত্যধিক সংখ্যক #time কল',
	'pfunc_rel2abs_invalid_depth' => 'ত্রুটি: পাথে অবৈধ গভীরতা: "$1" (মূল নোডের উপরের একটি নোড অ্যাক্সেস করতে চেষ্টা করেছিল)',
	'pfunc_expr_stack_exhausted' => 'এক্সপ্রেশন ত্রুটি: স্ট্যাক শেষ হয়ে গেছে',
	'pfunc_expr_unexpected_number' => 'এক্সপ্রেশন ত্রুটি: অযাচিত সংখ্যা',
	'pfunc_expr_preg_match_failure' => 'এক্সপ্রেশন ত্রুটি: অযাচিত preg_match ব্যর্থতা',
	'pfunc_expr_unrecognised_word' => 'এক্সপ্রেশন ত্রুটি: অপরিচিত শব্দ "$1"',
	'pfunc_expr_unexpected_operator' => 'এক্সপ্রেশন ত্রুটি: অযাচিত $1 অপারেটর',
	'pfunc_expr_missing_operand' => 'এক্সপ্রেশন ত্রুটি: $1-এর জন্য অপারেন্ড নেই।',
	'pfunc_expr_unexpected_closing_bracket' => 'এক্সপ্রেশন ত্রুটি: অযাচিত সমাপ্তকারী বন্ধনী',
	'pfunc_expr_unrecognised_punctuation' => 'এক্সপ্রেশন ত্রুটি: অপরিচিত বিরামচিহ্ন ক্যারেক্টার "$1"',
	'pfunc_expr_unclosed_bracket' => 'এক্সপ্রেশন ত্রুটি: উন্মুক্ত বন্ধনী',
	'pfunc_expr_division_by_zero' => 'শূন্য দ্বারা ভাগ করা হয়েছে',
	'pfunc_expr_invalid_argument' => '$1 এর জন্য ভুল শর্ত: < -1 অথবা > 1',
	'pfunc_expr_invalid_argument_ln' => 'ln এর জন্য অসিদ্ধ শর্ত: <= 0',
	'pfunc_expr_unknown_error' => 'এক্সপ্রেশন ত্রুটি: অজানা ত্রুটি ($1)',
	'pfunc_expr_not_a_number' => '$1: এ ফলাফল কোন সংখ্যা নয়',
);

/** Breton (Brezhoneg)
 * @author Fulup
 */
$messages['br'] = array(
	'pfunc_desc' => "Gwellaat a ra ar parser gant arc'hwelioù poellek",
	'pfunc_time_error' => 'Fazi : pad direizh',
	'pfunc_time_too_long' => 'Fazi : betek re eo bet galvet #time',
	'pfunc_time_too_big' => 'Fazi: #time ne skor nemet bloazioù betek 9999',
	'pfunc_rel2abs_invalid_depth' => "Fazi : Donder direizh evit an hent : \"\$1\" (klasket ez eus bet mont d'ul live a-us d'ar c'havlec'h-mamm)",
	'pfunc_expr_stack_exhausted' => 'Kemennad faziek : pil riñset',
	'pfunc_expr_unexpected_number' => "Kemennad faziek : niver dic'hortoz",
	'pfunc_expr_preg_match_failure' => "Kemennad faziek : c'hwitadenn dic'hortoz evit <code>preg_match</code>",
	'pfunc_expr_unrecognised_word' => 'Kemennad faziek : Ger dianav "$1"',
	'pfunc_expr_unexpected_operator' => 'Kemennad faziek : Oberier $1 dianav',
	'pfunc_expr_missing_operand' => 'Kemennad faziek : Dianav eo operand $1',
	'pfunc_expr_unexpected_closing_bracket' => "Kemennad faziek : Krommell zehoù dic'hortoz",
	'pfunc_expr_unrecognised_punctuation' => 'Kemennad faziek : arouezenn boentadouiñ dianav "$1"',
	'pfunc_expr_unclosed_bracket' => 'Kemennad faziek : Krommell zigor',
	'pfunc_expr_division_by_zero' => 'Rannañ dre mann',
	'pfunc_expr_invalid_argument' => 'Talvoudenn direizh evit $1: < -1 pe > 1',
	'pfunc_expr_invalid_argument_ln' => 'Talvoudenn direizh evit ln: <= 0',
	'pfunc_expr_unknown_error' => 'Kemennad faziek : Fazi dianav ($1)',
	'pfunc_expr_not_a_number' => "E $1: An disoc'h n'eo ket un niver",
	'pfunc_string_too_long' => "Fazi : Dreist d'ar vevenn uhelañ a $1 arouezenn eo an neudennad",
);

/** Bosnian (Bosanski)
 * @author CERminator
 * @author Seha
 */
$messages['bs'] = array(
	'pfunc_desc' => 'Povisi parser sa logičnim funkcijama',
	'pfunc_time_error' => 'Greška: vrijeme nije valjano',
	'pfunc_time_too_long' => 'Greška: previše poziva funkcije #time',
	'pfunc_time_too_big' => 'Greška: #time samo podržava godine do 9999',
	'pfunc_rel2abs_invalid_depth' => 'Graška: Nevrijedeća dubina u putu: "$1" (pokušaj dolaska na nula tačku iza korijenske nula tačke)',
	'pfunc_expr_stack_exhausted' => 'Greška izraza: Stok potrošen',
	'pfunc_expr_unexpected_number' => 'Greška izraza: Neočekivani broj',
	'pfunc_expr_preg_match_failure' => 'Razvojna greška: Neočekivana greška preg-pogotka',
	'pfunc_expr_unrecognised_word' => 'Greška izraza: Nepoznata riječ "$1"',
	'pfunc_expr_unexpected_operator' => 'Greška izraza: Neočekivani $1 operator',
	'pfunc_expr_missing_operand' => 'Greška izraza: Nedostaje operator za $1',
	'pfunc_expr_unexpected_closing_bracket' => 'Greška izraza: Neočekivana zagrada zatvaranja',
	'pfunc_expr_unrecognised_punctuation' => 'Razvojna greška: Nije prepoznat karakter punktacije "$1"',
	'pfunc_expr_unclosed_bracket' => 'Greška izraza: Nezatvorena zagrada',
	'pfunc_expr_division_by_zero' => 'Dijeljenje s nulom',
	'pfunc_expr_invalid_argument' => 'Nevažeći argument za $1: : < -1 ili > 1',
	'pfunc_expr_invalid_argument_ln' => 'Nevažeći argument za ln: <= 0',
	'pfunc_expr_unknown_error' => 'Razvojna greška: Nepoznata greška ($1)',
	'pfunc_expr_not_a_number' => 'u $1: rezultat nije broj',
	'pfunc_string_too_long' => 'Greška: Niz prelazi limit od $1 znakova',
);

/** Catalan (Català)
 * @author Jordi Roqué
 * @author Qllach
 * @author SMP
 */
$messages['ca'] = array(
	'pfunc_desc' => 'Millora el processat amb funcions lògiques',
	'pfunc_time_error' => 'Error: temps invàlid',
	'pfunc_time_too_long' => 'Error: massa crides #time',
	'pfunc_rel2abs_invalid_depth' => "Error: Adreça invàlida al directori: «$1» (s'intentava accedir a un node superior de l'arrel)",
	'pfunc_expr_stack_exhausted' => "Error de l'expressió: Pila exhaurida",
	'pfunc_expr_unexpected_number' => "Error de l'expressió: Nombre inesperat",
	'pfunc_expr_preg_match_failure' => "Error de l'expressió: Error de funció no compresa i inesperada",
	'pfunc_expr_unrecognised_word' => 'Error de l\'expressió: Paraula no reconeguda "$1"',
	'pfunc_expr_unexpected_operator' => "Error de l'expressió: Operador $1 inesperat",
	'pfunc_expr_missing_operand' => "Error de l'expressió: Falta l'operand de $1",
	'pfunc_expr_unexpected_closing_bracket' => "Error de l'expressió: Parèntesi inesperat",
	'pfunc_expr_unrecognised_punctuation' => 'Error de l\'expressió: Signe de puntuació no reconegut "$1"',
	'pfunc_expr_unclosed_bracket' => "Error de l'expressió: Parèntesi no tancat",
	'pfunc_expr_division_by_zero' => 'Divisió entre zero',
	'pfunc_expr_invalid_argument' => 'Valor no vàlid per a $1: < -1 ó > 1',
	'pfunc_expr_invalid_argument_ln' => 'Valor no vàlid per a ln: <= 0',
	'pfunc_expr_unknown_error' => "Error de l'expressió: Desconegut ($1)",
	'pfunc_expr_not_a_number' => 'A $1: el resultat no és un nombre',
	'pfunc_string_too_long' => 'Error: La cadena és $1 caràcters massa llarga',
);

/** Chechen (Нохчийн)
 * @author Sasan700
 */
$messages['ce'] = array(
	'pfunc_time_error' => 'Гlалато: хан нийса яц',
	'pfunc_expr_stack_exhausted' => 'Яздарехь гlалат ду: хьаладуьззина татол',
	'pfunc_expr_unrecognised_word' => 'Яздарехь гlалат ду: дойзуш доцу дош «$1»',
);

/** Czech (Česky)
 * @author Danny B.
 * @author Li-sung
 * @author Matěj Grabovský
 * @author Mormegil
 * @author Sp5uhe
 */
$messages['cs'] = array(
	'pfunc_desc' => 'Rozšíření parseru o logické funkce',
	'pfunc_time_error' => 'Chyba: neplatný čas',
	'pfunc_time_too_long' => 'Chyba: příliš mnoho volání #time',
	'pfunc_time_too_big' => 'Chyba: #time nepodporuje roky nad 9999',
	'pfunc_rel2abs_invalid_depth' => 'Chyba: Neplatná hloubka v cestě: "$1" (pokus o přístup do uzlu vyššího než kořen)',
	'pfunc_expr_stack_exhausted' => 'Chyba ve výrazu: Zásobník plně obsazen',
	'pfunc_expr_unexpected_number' => 'Chyba ve výrazu: Očekáváno číslo',
	'pfunc_expr_preg_match_failure' => 'Chyba ve výrazu: Neočekávaná chyba funkce preg_match',
	'pfunc_expr_unrecognised_word' => 'Chyba ve výrazu: Nerozpoznané slovo „$1“',
	'pfunc_expr_unexpected_operator' => 'Chyba ve výrazu: Neočekávaný operátor $1',
	'pfunc_expr_missing_operand' => 'Chyba ve výrazu: Chybí operand pro $1',
	'pfunc_expr_unexpected_closing_bracket' => 'Chyba ve výrazu: Neočekávaná uzavírací závorka',
	'pfunc_expr_unrecognised_punctuation' => 'Chyba ve výrazu: Nerozpoznaný interpunkční znak „$1“',
	'pfunc_expr_unclosed_bracket' => 'Chyba ve výrazu: Neuzavřené závorky',
	'pfunc_expr_division_by_zero' => 'Dělení nulou',
	'pfunc_expr_invalid_argument' => 'Neplatný argument pro $1: < -1 nebo > 1',
	'pfunc_expr_invalid_argument_ln' => 'Neplatný argument pro ln: <= 0',
	'pfunc_expr_unknown_error' => 'Chyba ve výrazu: Neznámá chyba ($1)',
	'pfunc_expr_not_a_number' => 'V $1: výsledkem není číslo',
	'pfunc_string_too_long' => 'Chyba: Řetězec je delší než $1 {{PLURAL:$1|znak|znaky|znaků}}, což je limit',
	'pfunc-convert-dimensionmismatch' => 'Chyba: Nelze převést mezi jednotkami „$1“ a „$2“.',
	'pfunc-convert-unknownunit' => 'Chyba: Neznámá jednotka „$1“.',
	'pfunc-convert-unknowndimension' => 'Chyba: Neznámý rozměr „$1“',
	'pfunc-convert-invalidcompoundunit' => 'Chyba: Neplatná složená jednotka „$1“.',
	'pfunc-convert-nounit' => 'Chyba: Nebyla zadána zdrojová jednotka.',
	'pfunc-convert-doublecompoundunit' => 'Chyba: Nelze zpracovat dvojitě složené jednotky, jako je „$1“.',
	'pfunc-convert-dimension-length' => 'délka',
	'pfunc-convert-dimension-area' => 'plocha',
	'pfunc-convert-dimension-volume' => 'objem',
	'pfunc-convert-dimension-time' => 'čas',
	'pfunc-convert-dimension-timesquared' => 'čas²',
	'pfunc-convert-dimension-mass' => 'hmotnost',
	'pfunc-convert-dimension-speed' => 'rychlost',
	'pfunc-convert-dimension-temperature' => 'teplota',
	'pfunc-convert-dimension-acceleration' => 'zrychlení',
	'pfunc-convert-dimension-force' => 'síla',
	'pfunc-convert-dimension-torque' => 'točivý moment',
	'pfunc-convert-dimension-energy' => 'energie',
	'pfunc-convert-dimension-power' => 'výkon',
	'pfunc-convert-dimension-pressure' => 'tlak',
	'pfunc-convert-dimension-density' => 'hustota',
	'pfunc-convert-dimension-fuelefficiencynegative' => 'spotřeba',
	'pfunc-convert-prefix-yotta' => 'yotta',
	'pfunc-convert-prefix-zetta' => 'zetta',
	'pfunc-convert-prefix-exa' => 'exa',
	'pfunc-convert-prefix-peta' => 'peta',
	'pfunc-convert-prefix-tera' => 'tera',
	'pfunc-convert-prefix-giga' => 'giga',
	'pfunc-convert-prefix-mega' => 'mega',
	'pfunc-convert-prefix-kilo' => 'kilo',
	'pfunc-convert-prefix-hecto' => 'hekto',
	'pfunc-convert-prefix-deca' => 'deka',
	'pfunc-convert-prefix-deci' => 'deci',
	'pfunc-convert-prefix-centi' => 'centi',
	'pfunc-convert-prefix-milli' => 'mili',
	'pfunc-convert-prefix-micro' => 'mikro',
	'pfunc-convert-prefix-nano' => 'nano',
	'pfunc-convert-prefix-pico' => 'piko',
	'pfunc-convert-prefix-femto' => 'femto',
	'pfunc-convert-prefix-atto' => 'atto',
	'pfunc-convert-prefix-zepto' => 'zepto',
	'pfunc-convert-prefix-yocto' => 'yokto',
	'pfunc-convert-prefix-milli-abbr' => 'm',
	'pfunc-convert-unit-length-metre' => '$1{{PLURAL:$2|$3metr|$3metry|$3metrů}}',
	'pfunc-convert-unit-length-mile' => '$1{{PLURAL:$2|míle|míle|mil}}',
	'pfunc-convert-unit-length-foot' => '$1{{PLURAL:$2|stopa|stopy|stop}}',
	'pfunc-convert-unit-length-inch' => '$1{{PLURAL:$2|palec|palce|palců}}',
	'pfunc-convert-unit-length-parsec' => '$1{{PLURAL:$2|$3parsek|$3parseky|$3parseků}}',
	'pfunc-convert-unit-length-astronomicalunit' => '$1{{PLURAL:$2|astronomická jednotka|astronomické jednotky|astronomických jednotek}}',
	'pfunc-convert-unit-area-squarekilometre' => '$1{{PLURAL:$2|kilometr čtvereční|kilometry čtvereční|kilometrů čtverečních}}',
	'pfunc-convert-unit-area-hectare' => '$1{{PLURAL:$2|hektar|hektary|hektarů}}',
	'pfunc-convert-unit-area-acre' => '$1{{PLURAL:$2|akr|akry|akrů}}',
	'pfunc-convert-unit-area-squarefoot' => '$1{{PLURAL:$2|čtvereční stopa|čtvereční stopy|čtverečních stop}}',
	'pfunc-convert-unit-area-squareinch' => '$1{{PLURAL:$2|čtvereční palec|čtvereční palce|čtverečních palců}}',
	'pfunc-convert-unit-area-squarekilometre-abbr' => '$1km²',
	'pfunc-convert-unit-area-squaremetre-abbr' => '$1m²',
	'pfunc-convert-unit-area-squarecentimetre-abbr' => '$1cm²',
	'pfunc-convert-unit-area-squaremillimetre-abbr' => '$1mm²',
	'pfunc-convert-unit-volume-cubicmetre-abbr' => '$1m³',
	'pfunc-convert-unit-volume-cubiccentimetre-abbr' => '$1cm³',
	'pfunc-convert-unit-volume-litre-abbr' => '$1$3l',
	'pfunc-convert-unit-pressure-pascal' => '$1{{PLURAL:$2|$3pascal|$3pascaly|$3pascalů}}',
	'pfunc-convert-unit-pressure-atmosphere' => '$1{{PLURAL:$2|atmosféra|atmosféry|atmosfér}}',
	'pfunc-convert-unit-pressure-torr' => '$1{{PLURAL:$2|torr|torry|torrů}}',
	'pfunc-convert-unit-pressure-pascal-abbr' => '$1$3Pa',
);

/** Danish (Dansk)
 * @author Byrial
 * @author Morten LJ
 * @author Peter Alberti
 */
$messages['da'] = array(
	'pfunc_desc' => 'Udvider parser med logiske funktioner',
	'pfunc_time_error' => 'Fejl: Ugyldig tid',
	'pfunc_time_too_long' => 'Fejl: for mange kald af #time',
	'pfunc_time_too_big' => 'Fejl: #time understøtter kun årstal frem til 9999',
	'pfunc_rel2abs_invalid_depth' => 'Fejl: Ugyldig dybde i sti: "$1" (prøvede at tilgå en knude over rodknuden)',
	'pfunc_expr_stack_exhausted' => 'Udtryksfejl: Stak tømt',
	'pfunc_expr_unexpected_number' => 'Fejl: Uventet tal',
	'pfunc_expr_preg_match_failure' => 'Udtryksfejl: Uventet fejl i preg_match',
	'pfunc_expr_unrecognised_word' => 'Udtryksfejl: Uventet ord "$1"',
	'pfunc_expr_unexpected_operator' => 'Udtryksfejl: Uventet "$1"-operator',
	'pfunc_expr_missing_operand' => 'Udtryksfejl: Manglende operand til $1',
	'pfunc_expr_unexpected_closing_bracket' => 'Udtryksfejl: Uventet lukkende parentes',
	'pfunc_expr_unrecognised_punctuation' => 'Udtryksfejl: Uventet tegnsætning-tegn: "$1"',
	'pfunc_expr_unclosed_bracket' => 'Udtryksfejl: Uafsluttet kantet parantes',
	'pfunc_expr_division_by_zero' => 'Division med nul',
	'pfunc_expr_invalid_argument' => 'Ugyldigt argument for $1: < -1 eller > 1',
	'pfunc_expr_invalid_argument_ln' => 'Ugyldigt argument for ln: <= 0',
	'pfunc_expr_unknown_error' => 'Udtryksfejl: Ukendt fejl ($1)',
	'pfunc_expr_not_a_number' => 'I $1: Resultatet er ikke et tal',
	'pfunc_string_too_long' => 'Fejl: Strengen overskrider grænsen på $1 tegn',
);

/** German (Deutsch)
 * @author Kghbln
 * @author LWChris
 * @author Metalhead64
 * @author Raimond Spekking
 * @author Rentenirer
 * @author Rillke
 */
$messages['de'] = array(
	'pfunc_desc' => 'Erweitert den Parser um logische Funktionen',
	'pfunc_time_error' => 'Fehler: Ungültige Zeitangabe',
	'pfunc_time_too_long' => 'Fehler: Zu viele #time-Aufrufe',
	'pfunc_time_too_big' => 'Fehler: #time unterstützt nur Jahre bis 9999',
	'pfunc_rel2abs_invalid_depth' => 'Fehler: Ungültige Pfadtiefe: „$1“ (Zugriff auf einen Knotenpunkt oberhalb des Hauptknotenpunktes ist empfohlen)',
	'pfunc_expr_stack_exhausted' => 'Expression-Fehler: Stacküberlauf',
	'pfunc_expr_unexpected_number' => 'Expression-Fehler: Unerwartete Zahl',
	'pfunc_expr_preg_match_failure' => 'Expression-Fehler: Unerwartete „preg_match“-Fehlfunktion',
	'pfunc_expr_unrecognised_word' => 'Expression-Fehler: Unerkanntes Wort „$1“',
	'pfunc_expr_unexpected_operator' => 'Expression-Fehler: Unerwarteter Operator <tt>$1</tt>',
	'pfunc_expr_missing_operand' => 'Expression-Fehler: Fehlender Operand für <tt>$1</tt>',
	'pfunc_expr_unexpected_closing_bracket' => 'Expression-Fehler: Unerwartete schließende eckige Klammer',
	'pfunc_expr_unrecognised_punctuation' => 'Expression-Fehler: Unerkanntes Satzzeichen „$1“',
	'pfunc_expr_unclosed_bracket' => 'Expression-Fehler: Nicht geschlossene eckige Klammer',
	'pfunc_expr_division_by_zero' => 'Division durch Null',
	'pfunc_expr_invalid_argument' => 'Ungültiges Argument für $1: < -1 oder > 1',
	'pfunc_expr_invalid_argument_ln' => 'Ungültiges Argument für ln: <= 0',
	'pfunc_expr_unknown_error' => 'Expression-Fehler: Unbekannter Fehler ($1)',
	'pfunc_expr_not_a_number' => 'In $1: Ergebnis ist keine Zahl',
	'pfunc_string_too_long' => 'Fehler: Zeichenkette überschreitet Zeichenlimit von $1',
	'pfunc-convert-dimensionmismatch' => 'Fehler: Die Einheiten „$1“ und „$2“ sind nicht untereinander konvertierbar',
	'pfunc-convert-unknownunit' => 'Fehler: Unbekannte Einheit „$1“',
	'pfunc-convert-unknowndimension' => 'Fehler: Unbekannte Dimension „$1“',
	'pfunc-convert-invalidcompoundunit' => 'Fehler: Ungültige Einheitenkombination „$1“',
	'pfunc-convert-nounit' => 'Fehler: Ausgangseinheit fehlt',
	'pfunc-convert-doublecompoundunit' => 'Fehler: Doppelte Einheitenkombinationen wie „$1“ können nicht verarbeitet werden',
	'pfunc-convert-dimension-length' => 'Länge',
	'pfunc-convert-dimension-area' => 'Fläche',
	'pfunc-convert-dimension-volume' => 'Volumen',
	'pfunc-convert-dimension-time' => 'Zeit',
	'pfunc-convert-dimension-timesquared' => 'Zeit<sup>2</sup>',
	'pfunc-convert-dimension-mass' => 'Masse',
	'pfunc-convert-dimension-speed' => 'Geschwindigkeit',
	'pfunc-convert-dimension-temperature' => 'Temperatur',
	'pfunc-convert-dimension-acceleration' => 'Beschleunigung',
	'pfunc-convert-dimension-force' => 'Kraft',
	'pfunc-convert-dimension-torque' => 'Drehmoment',
	'pfunc-convert-dimension-energy' => 'Energie',
	'pfunc-convert-dimension-power' => 'Leistung',
	'pfunc-convert-dimension-pressure' => 'Druck',
	'pfunc-convert-dimension-density' => 'Dichte',
	'pfunc-convert-dimension-fuelefficiencypositive' => 'Positive Kraftstoffeffizienz',
	'pfunc-convert-dimension-fuelefficiencynegative' => 'Negative Kraftstoffeffizienz',
	'pfunc-convert-prefix-yotta' => 'Yotta',
	'pfunc-convert-prefix-zetta' => 'Zetta',
	'pfunc-convert-prefix-exa' => 'Exa',
	'pfunc-convert-prefix-peta' => 'Peta',
	'pfunc-convert-prefix-tera' => 'Tera',
	'pfunc-convert-prefix-giga' => 'Giga',
	'pfunc-convert-prefix-mega' => 'Mega',
	'pfunc-convert-prefix-kilo' => 'Kilo',
	'pfunc-convert-prefix-hecto' => 'Hekto',
	'pfunc-convert-prefix-deca' => 'Deka',
	'pfunc-convert-prefix-deci' => 'Dezi',
	'pfunc-convert-prefix-centi' => 'Zenti',
	'pfunc-convert-prefix-milli' => 'Milli',
	'pfunc-convert-prefix-micro' => 'Mikro',
	'pfunc-convert-prefix-nano' => 'Nano',
	'pfunc-convert-prefix-pico' => 'Piko',
	'pfunc-convert-prefix-femto' => 'Femto',
	'pfunc-convert-prefix-atto' => 'Atto',
	'pfunc-convert-prefix-zepto' => 'Zepto',
	'pfunc-convert-prefix-yocto' => 'Yokto',
	'pfunc-convert-prefix-milli-abbr' => 'm',
	'pfunc-convert-unit-length-metre' => '$1{{PLURAL:$2|Meter|Meter}}',
	'pfunc-convert-unit-length-angstrom' => '$1{{PLURAL:$2|Ångström|Ångström}}',
	'pfunc-convert-unit-length-mile' => '$1{{PLURAL:$2|Meile|Meilen}}',
	'pfunc-convert-unit-length-furlong' => '$1{{PLURAL:$2|Furlong|Furlong}}',
	'pfunc-convert-unit-length-chain' => '$1{{PLURAL:$2|Chain|Chain}}',
	'pfunc-convert-unit-length-rod' => '$1{{PLURAL:$2|Rute|Ruten}}',
	'pfunc-convert-unit-length-fathom' => '$1{{PLURAL:$2|Fathom|Fathom}}',
	'pfunc-convert-unit-length-yard' => '$1{{PLURAL:$2|Yard|Yard}}',
	'pfunc-convert-unit-length-foot' => '$1{{PLURAL:$2|Fuß|Fuß}}',
	'pfunc-convert-unit-length-hand' => '$1{{PLURAL:$2|Hand|Hand}}',
	'pfunc-convert-unit-length-inch' => '$1{{PLURAL:$2|Zoll|Zoll}}',
	'pfunc-convert-unit-length-nauticalmile' => '$1{{PLURAL:$2|Seemeile|Seemeilen}}',
	'pfunc-convert-unit-length-nauticalmileuk' => '$1{{PLURAL:$2|britische Seemeile (vor 1970)|britische Seemeilen (vor 1970)}}',
	'pfunc-convert-unit-length-nauticalmileus' => '$1{{PLURAL:$2|US-Seemeile (vor 1954)|US-Seemeilen (vor 1954)}}',
	'pfunc-convert-unit-length-parsec' => '$1{{PLURAL:$2|$3parsec|$3parsec}}',
	'pfunc-convert-unit-length-lightyear' => '$1{{PLURAL:$2|$3 Lichtjahr|$3 Lichtjahre}}',
	'pfunc-convert-unit-length-astronomicalunit' => '$1{{PLURAL:$2|astronomische Einheit|astronomische Einheiten}}',
	'pfunc-convert-unit-length-furlong-abbr' => '$1furlong',
	'pfunc-convert-unit-length-chain-abbr' => '$1Chain',
	'pfunc-convert-unit-length-rod-abbr' => '$1rd',
	'pfunc-convert-unit-length-fathom-abbr' => '$1Faden',
	'pfunc-convert-unit-length-yard-abbr' => '$1yd',
	'pfunc-convert-unit-length-foot-abbr' => '$1ft',
	'pfunc-convert-unit-length-hand-abbr' => '$1h',
	'pfunc-convert-unit-length-inch-abbr' => '$1″',
	'pfunc-convert-unit-length-nauticalmile-abbr' => '$1nmi',
	'pfunc-convert-unit-length-nauticalmileuk-abbr' => '$1nmi (Brit)',
	'pfunc-convert-unit-length-nauticalmileus-abbr' => '$1nmi (US, vor 1954)',
	'pfunc-convert-unit-length-parsec-abbr' => '$1$3pc',
	'pfunc-convert-unit-length-lightyear-abbr' => '$1$3lj',
	'pfunc-convert-unit-length-astronomicalunit-abbr' => '$1AE',
	'pfunc-convert-unit-area-squarekilometre' => '$1{{PLURAL:$2|Quadratkilometer|Quadratkilometer}}',
	'pfunc-convert-unit-area-squaremetre' => '$1{{PLURAL:$2|Quadratmeter|Quadratmeter}}',
	'pfunc-convert-unit-area-squarecentimetre' => '$1{{PLURAL:$2|Quadratzentimeter|Quadratzentimeter}}',
	'pfunc-convert-unit-area-squaremillimetre' => '$1{{PLURAL:$2|Quadratmillimeter|Quadratmillimeter}}',
	'pfunc-convert-unit-area-hectare' => '$1{{PLURAL:$2|Hektar|Hektar}}',
	'pfunc-convert-unit-area-squaremile' => '$1{{PLURAL:$2|Quadratmeile|Quadratmeilen}}',
	'pfunc-convert-unit-area-acre' => '$1{{PLURAL:$2|Acre|Acre}}',
	'pfunc-convert-unit-area-squareyard' => '$1{{PLURAL:$2|Quadratyard|Quadratyard}}',
	'pfunc-convert-unit-area-squarefoot' => '$1{{PLURAL:$2|Quadratfuß|Quadratfuß}}',
	'pfunc-convert-unit-area-squareinch' => '$1{{PLURAL:$2|Quadratzoll|Quadratzoll}}',
	'pfunc-convert-unit-area-squarenauticalmile' => '$1{{PLURAL:$2|Quadratseemeilen|Quadratseemeilen}}',
	'pfunc-convert-unit-area-dunam' => '$1{{PLURAL:$2|Dunam|Dunam}}',
	'pfunc-convert-unit-area-tsubo' => '$1{{PLURAL:$2|Tsubo|Tsubo}}',
	'pfunc-convert-unit-area-squarekilometre-abbr' => '$1km<sup>2</sup>',
	'pfunc-convert-unit-area-squaremetre-abbr' => '$1m<sup>2</sup>',
	'pfunc-convert-unit-area-squarecentimetre-abbr' => '$1cm<sup>2</sup>',
	'pfunc-convert-unit-area-squaremillimetre-abbr' => '$1mm<sup>2</sup>',
	'pfunc-convert-unit-area-hectare-abbr' => '$1ha',
	'pfunc-convert-unit-area-squaremile-abbr' => '$1mi²',
	'pfunc-convert-unit-area-acre-abbr' => '$1acre',
	'pfunc-convert-unit-area-squareyard-abbr' => '$1yd²',
	'pfunc-convert-unit-area-squarefoot-abbr' => '$1ft²',
	'pfunc-convert-unit-area-squareinch-abbr' => '$1inch²',
	'pfunc-convert-unit-area-squarenauticalmile-abbr' => '$1sm<sup>2</sup>',
	'pfunc-convert-unit-area-dunam-abbr' => '$1dunam',
	'pfunc-convert-unit-area-tsubo-abbr' => '$1tsubo',
	'pfunc-convert-unit-time-second' => '$1{{PLURAL:$2|Sekunde|Sekunden}}',
	'pfunc-convert-unit-time-year' => '$1{{PLURAL:$2|$3 Jahr|$3 Jahre}}',
	'pfunc-convert-unit-time-day' => '$1{{PLURAL:$2|Tag|Tage}}',
	'pfunc-convert-unit-time-hour' => '$1{{PLURAL:$2|Stunde|Stunden}}',
	'pfunc-convert-unit-time-minute' => '$1{{PLURAL:$2|Minute|Minuten}}',
	'pfunc-convert-unit-time-second-abbr' => '$1sek',
	'pfunc-convert-unit-time-year-abbr' => '$1$3a',
	'pfunc-convert-unit-time-day-abbr' => '$1d',
	'pfunc-convert-unit-time-hour-abbr' => '$1h',
	'pfunc-convert-unit-time-minute-abbr' => '$1min',
	'pfunc-convert-unit-volume-cubicmetre' => '$1{{PLURAL:$2|Kubikmeter|Kubikmeter}}',
	'pfunc-convert-unit-volume-cubiccentimetre' => '$1{{PLURAL:$2|Kubikzentimeter|Kubikzentimeter}}',
	'pfunc-convert-unit-volume-cubicmillimetre' => '$1{{PLURAL:$2|Kubikmillimeter|Kubikmillimeter}}',
	'pfunc-convert-unit-volume-kilolitre' => '$1{{PLURAL:$2|Kiloliter|Kiloliter}}',
	'pfunc-convert-unit-volume-litre' => '$1{{PLURAL:$2|Liter|Liter}}',
	'pfunc-convert-unit-volume-centilitre' => '$1{{PLURAL:$2|Zentiliter|Zentiliter}}',
	'pfunc-convert-unit-volume-millilitre' => '$1{{PLURAL:$2|Milliliter|Milliliter}}',
	'pfunc-convert-unit-volume-cubicyard' => '$1{{PLURAL:$2|Kubikyard|Kubikyard}}',
	'pfunc-convert-unit-volume-cubicfoot' => '$1{{PLURAL:$2|Kubikfuß|Kubikfuß}}',
	'pfunc-convert-unit-volume-cubicinch' => '$1{{PLURAL:$2|Kubikzoll|Kubikzoll}}',
	'pfunc-convert-unit-volume-barrel' => '$1{{PLURAL:$2|Barrel|Barrel}}',
	'pfunc-convert-unit-volume-bushel' => '$1{{PLURAL:$2|Bushel|Bushel}}',
	'pfunc-convert-unit-volume-gallon' => '$1{{PLURAL:$2|Gallone|Gallonen}}',
	'pfunc-convert-unit-volume-quart' => '$1{{PLURAL:$2|Quart|Quart}}',
	'pfunc-convert-unit-volume-pint' => '$1{{PLURAL:$2|Pinte|Pinten}}',
	'pfunc-convert-unit-volume-fluidounce' => '$1{{PLURAL:$2|Flüssigunze|Flüssigunzen}}',
	'pfunc-convert-unit-volume-barrelus' => '$1{{PLURAL:$2|US-Barrel|US-Barrel}}',
	'pfunc-convert-unit-volume-barreloil' => '$1{{PLURAL:$2|Barrel|Barrel}}',
	'pfunc-convert-unit-volume-barrelbeer' => '$1{{PLURAL:$2|Barrel|Barrel}}',
	'pfunc-convert-unit-volume-usgallon' => '$1{{PLURAL:$2|US-Gallone|US-Gallonen}}',
	'pfunc-convert-unit-volume-usquart' => '$1{{PLURAL:$2|US-Quart|US-Quart}}',
	'pfunc-convert-unit-volume-uspint' => '$1{{PLURAL:$2|US-Pinte|US-Pinten}}',
	'pfunc-convert-unit-volume-usfluidounce' => '$1{{PLURAL:$2|US-Flüssigunze|US-Flüssigunzen}}',
	'pfunc-convert-unit-volume-usdrybarrel' => '$1{{PLURAL:$2|US-Trockenbarrel|US-Trockenbarrel}}',
	'pfunc-convert-unit-volume-usbushel' => '$1{{PLURAL:$2|US-Bushel|US-Bushel}}',
	'pfunc-convert-unit-volume-usdrygallon' => '$1{{PLURAL:$2|US-Trockengallone|US-Trockengallonen}}',
	'pfunc-convert-unit-volume-usdryquart' => '$1{{PLURAL:$2|US-Trockenquart|US-Trockenquart}}',
	'pfunc-convert-unit-volume-usdrypint' => '$1{{PLURAL:$2|US-Trockenpinte|US-Trockenpinten}}',
	'pfunc-convert-unit-volume-cubicmetre-abbr' => '$1m<sup>3</sup>',
	'pfunc-convert-unit-volume-cubiccentimetre-abbr' => '$1cm<sup>3</sup>',
	'pfunc-convert-unit-volume-cubicmillimetre-abbr' => '$1mm<sup>3</sup>',
	'pfunc-convert-unit-volume-litre-abbr' => '$1$3 l',
	'pfunc-convert-unit-volume-cubicyard-abbr' => '$1yd<sup>3</sup>',
	'pfunc-convert-unit-volume-cubicfoot-abbr' => '$1ft<sup>3</sup>',
	'pfunc-convert-unit-volume-cubicinch-abbr' => '$1in<sup>3</sup>',
	'pfunc-convert-unit-volume-barrel-abbr' => '$1bbl.',
	'pfunc-convert-unit-volume-bushel-abbr' => '$1bsh.',
	'pfunc-convert-unit-volume-gallon-abbr' => '$1gal.',
	'pfunc-convert-unit-volume-quart-abbr' => '$1qt.',
	'pfunc-convert-unit-volume-pint-abbr' => '$1pt.',
	'pfunc-convert-unit-volume-fluidounce-abbr' => '$1fl.oz.',
	'pfunc-convert-unit-volume-barrelus-abbr' => '$1US bbl.',
	'pfunc-convert-unit-volume-barreloil-abbr' => '$1bbl.',
	'pfunc-convert-unit-volume-barrelbeer-abbr' => '$1bbl.',
	'pfunc-convert-unit-volume-usgallon-abbr' => '$1US gal.',
	'pfunc-convert-unit-volume-usquart-abbr' => '$1US qt.',
	'pfunc-convert-unit-volume-uspint-abbr' => '$1US pt.',
	'pfunc-convert-unit-volume-usfluidounce-abbr' => '$1US fl.oz.',
	'pfunc-convert-unit-volume-usdrybarrel-abbr' => '$1US bbl.',
	'pfunc-convert-unit-volume-usbushel-abbr' => '$1US bsh.',
	'pfunc-convert-unit-volume-usdrygallon-abbr' => '$1US dry gal.',
	'pfunc-convert-unit-volume-usdryquart-abbr' => '$1US dry qt.',
	'pfunc-convert-unit-volume-usdrypint-abbr' => '$1US dry pt.',
	'pfunc-convert-unit-speed-mile-hour' => '$1Meilen pro Stunde',
	'pfunc-convert-unit-speed-speedoflight' => '$1c',
	'pfunc-convert-unit-speed-mile-hour-abbr' => '$1mph',
	'pfunc-convert-unit-speed-speedoflight-abbr' => '$1c',
	'pfunc-convert-unit-pressure-pascal' => '$1{{PLURAL:$2|$3 Pascal|$3 Pascal}}',
	'pfunc-convert-unit-pressure-bar' => '$1Bar',
	'pfunc-convert-unit-pressure-decibar' => '$1Dezibar',
	'pfunc-convert-unit-pressure-millibar' => '$1Millibar',
	'pfunc-convert-unit-pressure-kilobarye' => '$1Kilobarye',
	'pfunc-convert-unit-pressure-barye' => '$1Barye',
	'pfunc-convert-unit-pressure-atmosphere' => '$1{{PLURAL:$2|Atmosphäre|Atmosphären}}',
	'pfunc-convert-unit-pressure-torr' => '$1{{PLURAL:$2|Torr|Torr}}',
	'pfunc-convert-unit-pressure-mmhg' => '$1{{PLURAL:$2|Millimeter-Quecksilbersäule|Millimeter-Quecksilbersäule}}',
	'pfunc-convert-unit-pressure-inhg' => '$1{{PLURAL:$2|Zoll Quecksilber|Zoll Quecksilber}}',
	'pfunc-convert-unit-pressure-psi' => '$1{{PLURAL:$2|Pfund pro Quadratzoll|Pfund pro Quadratzoll}}',
	'pfunc-convert-unit-pressure-pascal-abbr' => '$1$3 Pa',
	'pfunc-convert-unit-pressure-bar-abbr' => '$1Bar',
	'pfunc-convert-unit-pressure-decibar-abbr' => '$1dbar',
	'pfunc-convert-unit-pressure-millibar-abbr' => '$1mbar',
	'pfunc-convert-unit-pressure-kilobarye-abbr' => '$1kBa',
	'pfunc-convert-unit-pressure-barye-abbr' => '$1Ba',
	'pfunc-convert-unit-pressure-atmosphere-abbr' => '$1atm',
	'pfunc-convert-unit-pressure-torr-abbr' => '$1Torr',
	'pfunc-convert-unit-pressure-mmhg-abbr' => '$1mmHg',
	'pfunc-convert-unit-pressure-inhg-abbr' => '$1inHg',
	'pfunc-convert-unit-pressure-psi-abbr' => '$1psi',
);

/** Swiss High German (Schweizer Hochdeutsch)
 * @author MichaelFrey
 */
$messages['de-ch'] = array(
	'pfunc_expr_unexpected_closing_bracket' => 'Expression-Fehler: Unerwartete schliessende eckige Klammer',
);

/** Zazaki (Zazaki)
 * @author Aspar
 */
$messages['diq'] = array(
	'pfunc_desc' => 'Enhance parser with logical functions',
	'pfunc_time_error' => 'xeta: zemano nemeqbul',
	'pfunc_time_too_long' => 'xeta:zaf zêd mesajê #timeyi',
	'pfunc_rel2abs_invalid_depth' => 'Hata: Yolda geçersiz derinlik: "$1" (kök düğümünün üstünde bir düğüme erişmeye çalıştı)',
	'pfunc_expr_stack_exhausted' => 'xetaya ifadeyi: stack qediya',
	'pfunc_expr_unexpected_number' => 'xetaya ifadeyi: amaro bêtexmin',
	'pfunc_expr_preg_match_failure' => 'xetaya ifadeyi: arızaya preg_matchi yo bêtexmin',
	'pfunc_expr_unrecognised_word' => 'xetaya ifadeyi: çekuya "$1"i nêşinasiyeno',
	'pfunc_expr_unexpected_operator' => 'xetaya ifadeyi: operatorê $1i yo bêtexmin',
	'pfunc_expr_missing_operand' => 'xetaya ifadeyi: qey $1i termo kêm',
	'pfunc_expr_unexpected_closing_bracket' => 'xetaya ifadeyi: parantez bıqefelno bêtexmin',
	'pfunc_expr_unrecognised_punctuation' => 'xetaya ifadeyi: karakterê noqtakerdışê "$1"i yo ke nêşınasiyeno',
	'pfunc_expr_unclosed_bracket' => 'xetaya ifadeyi: parantezo nêqefelnaye',
	'pfunc_expr_division_by_zero' => 'pê sıfır teqsim ker',
	'pfunc_expr_invalid_argument' => 'Invalid argument for $1: < -1 or > 1',
	'pfunc_expr_invalid_argument_ln' => 'Invalid argument for ln: <= 0',
	'pfunc_expr_unknown_error' => 'xetaya ifadeyi: neticeya ke nêzaniyena ($1)',
	'pfunc_expr_not_a_number' => '$1 de: netice yew amar niyo',
	'pfunc_string_too_long' => 'xeta: rêze heddê karakteri yo $1i veciyaya',
);

/** Lower Sorbian (Dolnoserbski)
 * @author Michawiki
 */
$messages['dsb'] = array(
	'pfunc_desc' => 'Rozšyrja parser wó logiske funkcije',
	'pfunc_time_error' => 'Zmólka: njepłaśiwy cas',
	'pfunc_time_too_long' => 'Zmólka: pśewjele zawołanjow #time',
	'pfunc_rel2abs_invalid_depth' => 'Zmólka: Njepłaśiwy dłym w sćažce: "$1" (wopyt na suk pśistup měś, kótaryž jo wušej kórjenjowego suka)',
	'pfunc_expr_stack_exhausted' => 'Wurazowa zmólka: Stack wupócerany',
	'pfunc_expr_unexpected_number' => 'Wurazowa zmólka: Njewócakana licba',
	'pfunc_expr_preg_match_failure' => 'Wurazowa zmólka: Njewócakana zmólkata funkcija preg_match',
	'pfunc_expr_unrecognised_word' => 'Wurazowa zmólka: Njespóznane słowo "$1"',
	'pfunc_expr_unexpected_operator' => 'Wurazowa zmólka: Njewócakany opeator $1',
	'pfunc_expr_missing_operand' => 'Wurazowa zmólka: Felujucy operand za $1',
	'pfunc_expr_unexpected_closing_bracket' => 'Wurazowa zmólka: Njewócakana kóńcajuca rožkata spinka',
	'pfunc_expr_unrecognised_punctuation' => 'Wurazowa zmólka: Njespóznane interpunkciske znamuško "$1"',
	'pfunc_expr_unclosed_bracket' => 'Wurazowa zmólka: Žedna kóńcajuca spinka',
	'pfunc_expr_division_by_zero' => 'Diwizija pśez nul',
	'pfunc_expr_invalid_argument' => 'Njepłaśiwy argument $1: < -1 abo > 1',
	'pfunc_expr_invalid_argument_ln' => 'Njepłaśiwy argument za ln: <= 0',
	'pfunc_expr_unknown_error' => 'Wurazowa zmólka: Njeznata zmólka ($1)',
	'pfunc_expr_not_a_number' => 'W $1: wuslědk njejo licba',
	'pfunc_string_too_long' => 'Zmólka: Znamješkowy rěd pśekčaca limit $1 znamješkow',
);

/** Greek (Ελληνικά)
 * @author Consta
 * @author Dead3y3
 * @author Omnipaedista
 * @author Απεργός
 */
$messages['el'] = array(
	'pfunc_desc' => 'Βελτιώνει το συντακτικό αναλυτή με λογικές συναρτήσεις',
	'pfunc_time_error' => 'Σφάλμα: άκυρος χρόνος',
	'pfunc_time_too_long' => 'Σφάλμα: πάρα πολλές κλήσεις της #time',
	'pfunc_rel2abs_invalid_depth' => 'Σφάλμα: Άκυρο βάθος στη διαδρομή: «$1» (έγινε προσπάθεια για πρόσβαση σε έναν κόμβο πάνω από τον ριζικό κόμβο)',
	'pfunc_expr_stack_exhausted' => 'Σφάλμα έκφρασης: Η στοίβα εξαντλήθηκε',
	'pfunc_expr_unexpected_number' => 'Σφάλμα έκφρασης: Μη αναμενόμενος αριθμός',
	'pfunc_expr_preg_match_failure' => 'Σφάλμα έκφρασης: Μη αναμενόμενη αποτυχία preg_match',
	'pfunc_expr_unrecognised_word' => 'Σφάλμα έκφρασης: Μη αναγνωρίσιμη λέξη "$1"',
	'pfunc_expr_unexpected_operator' => 'Σφάλμα έκφρασης: Μη αναμενόμενος τελεστής $1',
	'pfunc_expr_missing_operand' => 'Σφάλμα έκφρασης: Λείπει ο τελεστέος για την έκφραση $1',
	'pfunc_expr_unexpected_closing_bracket' => 'Σφάλμα έκφρασης: Μη αναμενόμενη αγκύλη κλεισίματος',
	'pfunc_expr_unrecognised_punctuation' => 'Σφάλμα έκφρασης: Μη αναγνρίσμος χαρακτήρας στίξης "$1"',
	'pfunc_expr_unclosed_bracket' => 'Σφάλμα έκφρασης: Αγκύλη χωρίς κλείσιμο',
	'pfunc_expr_division_by_zero' => 'Διαίρεση με το μηδέν',
	'pfunc_expr_invalid_argument' => 'Άκυρη παράμετρος για το $1: < -1 ή > 1',
	'pfunc_expr_invalid_argument_ln' => 'Άκυρη παράμετρος για το ln: <= 0',
	'pfunc_expr_unknown_error' => 'Σφάλμα έκφρασης: Άγνωστο σφάλμα ($1)',
	'pfunc_expr_not_a_number' => 'Στο $1: το αποτέλεσμα δεν είναι αριθμός',
	'pfunc_string_too_long' => 'Σφάλμα: ο ορμαθός υπερβαίνει $1 το όριο χαρακτήρων',
);

/** British English (British English)
 * @author Happy-melon
 */
$messages['en-gb'] = array(
	'pfunc-convert-unit-length-metre' => '$1{{PLURAL:$2|$3metre|$3metres}}',
	'pfunc-convert-unit-area-squarekilometre' => '$1{{PLURAL:$2|square kilometre|square kilometres}}',
	'pfunc-convert-unit-area-squaremetre' => '$1{{PLURAL:$2|square metre|square metres}}',
	'pfunc-convert-unit-area-squarecentimetre' => '$1{{PLURAL:$2|square centimetre|square centimetres}}',
	'pfunc-convert-unit-area-squaremillimetre' => '$1{{PLURAL:$2|square millimetre|square millimetres}}',
	'pfunc-convert-unit-volume-cubicmetre' => '$1{{PLURAL:$2|cubic metre|cubic metres}}',
	'pfunc-convert-unit-volume-cubiccentimetre' => '$1{{PLURAL:$2|cubic centimetre|cubic centimetres}}',
	'pfunc-convert-unit-volume-cubicmillimetre' => '$1{{PLURAL:$2|cubic millimetre|cubic millimetres}}',
	'pfunc-convert-unit-volume-litre' => '$1{{PLURAL:$2|$3litre|$3litres}}',
	'pfunc-convert-unit-pressure-mmhg' => '$1{{PLURAL:$2|millimetre of mercury|millimetres of mercury}}',
);

/** Esperanto (Esperanto)
 * @author Yekrats
 */
$messages['eo'] = array(
	'pfunc_desc' => 'Etendi sintaksan analizilon kun logikaj funkcioj',
	'pfunc_time_error' => 'Eraro: malvalida tempo',
	'pfunc_time_too_long' => "Eraro: tro da vokoj ''#time''",
	'pfunc_rel2abs_invalid_depth' => 'Eraro: Malvalida profundo en vojo: "$1" (provis atingi nodon super la radika nodo)',
	'pfunc_expr_stack_exhausted' => 'Esprima eraro: Stako estis malplenigita',
	'pfunc_expr_unexpected_number' => 'Esprima eraro: Neatendita numeralo',
	'pfunc_expr_preg_match_failure' => 'Esprima eraro: Neatendita preg_match malsukceso',
	'pfunc_expr_unrecognised_word' => 'Esprima eraro: Nekonata vorto "$1"',
	'pfunc_expr_unexpected_operator' => 'Esprima eraro: Neatendita operacisimbolo $1',
	'pfunc_expr_missing_operand' => 'Esprima eraro: Mankas operando por $1',
	'pfunc_expr_unexpected_closing_bracket' => 'Esprima eraro: Neatendita ferma krampo',
	'pfunc_expr_unrecognised_punctuation' => 'Esprima eraro: Nekonata interpunkcia simbolo "$1"',
	'pfunc_expr_unclosed_bracket' => 'Esprima eraro: Malferma krampo',
	'pfunc_expr_division_by_zero' => 'Divido per nulo',
	'pfunc_expr_invalid_argument' => 'Malvalida argumento por $1: < -1 or > 1',
	'pfunc_expr_invalid_argument_ln' => 'Malvalida argumento por ln: <= 0',
	'pfunc_expr_unknown_error' => 'Esprima eraro: Nekonata eraro ($1)',
	'pfunc_expr_not_a_number' => 'En $1: rezulto ne estas nombro',
	'pfunc_string_too_long' => 'Eraro: Ĉeno preterpasas signo-limon $1',
);

/** Spanish (Español)
 * @author Crazymadlover
 * @author Muro de Aguas
 * @author Remember the dot
 * @author Sanbec
 */
$messages['es'] = array(
	'pfunc_desc' => 'Mejora el analizador lógico con funciones.',
	'pfunc_time_error' => 'Error con la expresión: Tiempo no válido',
	'pfunc_time_too_long' => 'Error con la expresión: se están utilizando demasiados "#time"',
	'pfunc_rel2abs_invalid_depth' => 'Error: Profundidad no válida en la ruta: «$1» (trataste de acceder a un nodo por encima de la raíz)',
	'pfunc_expr_stack_exhausted' => 'Error de expresión: Pila agotada',
	'pfunc_expr_unexpected_number' => 'Error con la expresión: Número no esperado',
	'pfunc_expr_preg_match_failure' => 'Error de expresión: Fracaso preg_match no esperado',
	'pfunc_expr_unrecognised_word' => 'Error con la expresión: La palabra "$1" no se reconoce',
	'pfunc_expr_unexpected_operator' => 'Error con la expresión: Operador $1 no esperado',
	'pfunc_expr_missing_operand' => 'Error con la expresión: Falta un operador para $1',
	'pfunc_expr_unexpected_closing_bracket' => 'Error con la expresión: Paréntesis de cierre no esperado',
	'pfunc_expr_unrecognised_punctuation' => 'Error con la expresión: Carácter de puntuación no reconocido "$1"',
	'pfunc_expr_unclosed_bracket' => 'Error con la expresión: Paréntesis sin cerrar',
	'pfunc_expr_division_by_zero' => 'División entre cero',
	'pfunc_expr_invalid_argument' => 'Argumento incorrecto para $1: < -1 ó > 1',
	'pfunc_expr_invalid_argument_ln' => 'Argumento incorrecto para ln: <= 0',
	'pfunc_expr_unknown_error' => 'Error con la expresión: Error desconocido ($1)',
	'pfunc_expr_not_a_number' => 'En $1: el resultado no es un número',
	'pfunc_string_too_long' => 'Error: la cadena excede el límite de $1 caracteres',
);

/** Estonian (Eesti)
 * @author Pikne
 */
$messages['et'] = array(
	'pfunc_desc' => 'Laiendab parserit loogiliste funktsioonidega.',
	'pfunc_time_error' => 'Tõrge: Vigane aeg',
	'pfunc_expr_division_by_zero' => 'Nulliga jagamine',
);

/** Basque (Euskara)
 * @author An13sa
 * @author Kobazulo
 */
$messages['eu'] = array(
	'pfunc_time_error' => 'Errorea: baliogabeko ordua',
	'pfunc_time_too_long' => 'Errorea: #time dei gehiegi',
	'pfunc_time_too_big' => 'Errorea: #time funtzioak 9999 urtera arte funtzionatzen du bakarrik',
	'pfunc_rel2abs_invalid_depth' => 'Errorea: Baliogabeko sakonera fitxategi bidean: "$1" (root puntutik gora sartzen saiatu da)',
	'pfunc_expr_unexpected_number' => 'Adierazpen errorea: Ustekabeko zenbakia',
	'pfunc_expr_unrecognised_word' => 'Adierazpen errorea: Hitz ezezaguna "$1"',
	'pfunc_expr_unexpected_operator' => 'Adierazpen errorea: Ustekabeko $1 eragilea',
	'pfunc_expr_unexpected_closing_bracket' => 'Adierazpen errorea: Ustekabeko kortxete itxiera',
	'pfunc_expr_unrecognised_punctuation' => 'Adierazpen errorea: puntuazio karaktere ezezaguna "$1"',
	'pfunc_expr_unclosed_bracket' => 'Adierazpen errorea: Itxi gabeko kortxetea',
	'pfunc_expr_division_by_zero' => 'Zeroz zatitu',
	'pfunc_expr_invalid_argument' => 'Argumentu okerra ondorengoarentzat: $1: < -1 edo > 1',
	'pfunc_expr_invalid_argument_ln' => 'Argumentu okerra ondorengoarentzat: ln: <= 0',
	'pfunc_expr_unknown_error' => 'Adierazpen errorea: errore ezezaguna ($1)',
	'pfunc_expr_not_a_number' => '$1-(e)n: emaitza ez da zenbaki bat',
	'pfunc_string_too_long' => 'Errorea: hitzak $1 karaktereko muga gainditzen du',
);

/** Persian (فارسی)
 * @author Ebraminio
 * @author Huji
 * @author Wayiran
 */
$messages['fa'] = array(
	'pfunc_desc' => 'به تجزیه‌گر، دستورهای منطقی می‌افزاید',
	'pfunc_time_error' => 'خطا: زمان غیرمجاز',
	'pfunc_time_too_long' => 'خطا: فراخوانی بیش از حد #time',
	'pfunc_time_too_big' => 'خطا: <span style="direction: ltr; unicode-bidi: bidi-override;">#time</span> تا سال ۹۹۹۹ را فقط حمایت می‌کند.',
	'pfunc_rel2abs_invalid_depth' => 'خطا: عمق غیر مجاز در نشانی «$1» (تلاش برای دسترسی به یک نشانی فراتر از نشانی ریشه)',
	'pfunc_expr_stack_exhausted' => 'خطای عبارت: پشته از دست رفته',
	'pfunc_expr_unexpected_number' => 'خطای عبارت: عدد دور از انتظار',
	'pfunc_expr_preg_match_failure' => 'خطای عبارت: خطای preg_match دور از انتظار',
	'pfunc_expr_unrecognised_word' => 'خطای عبارت: کلمه ناشناخته «$1»',
	'pfunc_expr_unexpected_operator' => 'خطای عبارت: عملگر $1 دور از انتظار',
	'pfunc_expr_missing_operand' => 'خطای عبارت: عملگر گمشده برای $1',
	'pfunc_expr_unexpected_closing_bracket' => 'خطای عبارت: پرانتز بسته اضافی',
	'pfunc_expr_unrecognised_punctuation' => 'خطای عبارت: نویسه نقطه‌گذاری شناخته نشده «$1»',
	'pfunc_expr_unclosed_bracket' => 'خطای عبارت: پرانتز بسته‌نشده',
	'pfunc_expr_division_by_zero' => 'تقسیم بر صفر',
	'pfunc_expr_invalid_argument' => 'پارامتر غیر مجاز برای $1: < -۱ یا > ۱',
	'pfunc_expr_invalid_argument_ln' => 'پارامتر غیر مجاز برای لگاریتم طبیعی: <= صفر',
	'pfunc_expr_unknown_error' => 'خطای عبارت: خطای ناشناخته ($1)',
	'pfunc_expr_not_a_number' => 'در $1: نتیجه عدد نیست',
	'pfunc_string_too_long' => 'خطا: رشته از محدودیت نویسه‌ای $1 تجاوز می‌کند',
);

/** Finnish (Suomi)
 * @author Agony
 * @author Cimon Avaro
 * @author Nike
 */
$messages['fi'] = array(
	'pfunc_desc' => 'Laajentaa jäsennintä loogisilla funktiolla.',
	'pfunc_time_error' => 'Virhe: kelvoton aika',
	'pfunc_time_too_long' => 'Virhe: liian monta #time-kutsua',
	'pfunc_rel2abs_invalid_depth' => 'Virhe: Virheellinen syvyys polussa: $1 (ei juurisolmun sisällä)',
	'pfunc_expr_stack_exhausted' => 'Virhe lausekkeessa: pino loppui',
	'pfunc_expr_unexpected_number' => 'Virhe lausekkeessa: odottamaton numero',
	'pfunc_expr_preg_match_failure' => 'Virhe lausekkeessa: <tt>preg_match</tt> palautti virheen',
	'pfunc_expr_unrecognised_word' => 'Virhe lausekkeessa: tunnistamaton sana ”$1”',
	'pfunc_expr_unexpected_operator' => 'Virhe lausekkeessa: odottamaton $1-operaattori',
	'pfunc_expr_missing_operand' => 'Virhe lausekkeessa: operaattorin $1 edellyttämä operandi puuttuu',
	'pfunc_expr_unexpected_closing_bracket' => 'Virhe lausekkeessa: odottamaton sulkeva sulkumerkki',
	'pfunc_expr_unrecognised_punctuation' => 'Virhe lausekkeessa: tunnistamaton välimerkki ”$1”',
	'pfunc_expr_unclosed_bracket' => 'Virhe ilmauksessa: sulkeva sulkumerkki puuttuu',
	'pfunc_expr_division_by_zero' => 'Virhe: Jako nollalla',
	'pfunc_expr_invalid_argument' => 'Virheellinen arvo $1: < -1 tai > 1',
	'pfunc_expr_invalid_argument_ln' => 'Virheellinen arvo funktiolle ln: <= 0',
	'pfunc_expr_unknown_error' => 'Virhe lausekkeessa: tuntematon virhe ($1)',
	'pfunc_expr_not_a_number' => 'Lausekkeessa $1: tulos ei ole luku',
	'pfunc_string_too_long' => 'Virhe: Merkkijono ylittää $1 merkin ylärajan',
);

/** French (Français)
 * @author Crochet.david
 * @author Gomoko
 * @author Grondin
 * @author Hashar
 * @author IAlex
 * @author Od1n
 * @author Sherbrooke
 * @author Urhixidur
 * @author Verdy p
 */
$messages['fr'] = array(
	'pfunc_desc' => 'Améliore le parseur avec des fonctions logiques',
	'pfunc_time_error' => 'Erreur : durée invalide.',
	'pfunc_time_too_long' => 'Erreur : appels trop nombreux à <code>#time</code>.',
	'pfunc_time_too_big' => 'Erreur : #time prend uniquement en charge des années jusqu’à 9999.',
	'pfunc_rel2abs_invalid_depth' => 'Erreur : profondeur invalide dans le chemin « $1 » (a essayé d’accéder à un niveau au-dessus du nœud racine).',
	'pfunc_expr_stack_exhausted' => 'Erreur d’expression : pile épuisée.',
	'pfunc_expr_unexpected_number' => 'Erreur d’expression : nombre inattendu.',
	'pfunc_expr_preg_match_failure' => 'Erreur d’expression : échec inattendu de <code>preg_match</code>.',
	'pfunc_expr_unrecognised_word' => 'Erreur d’expression : mot « $1 » non reconnu.',
	'pfunc_expr_unexpected_operator' => "Erreur d’expression : opérateur '''$1''' inattendu.",
	'pfunc_expr_missing_operand' => "Erreur d’expression : opérande manquant pour '''$1'''.",
	'pfunc_expr_unexpected_closing_bracket' => 'Erreur d’expression : parenthèse fermante inattendue.',
	'pfunc_expr_unrecognised_punctuation' => 'Erreur d’expression : caractère de ponctuation « $1 » non reconnu.',
	'pfunc_expr_unclosed_bracket' => 'Erreur d’expression : parenthèse non fermée.',
	'pfunc_expr_division_by_zero' => 'Division par zéro.',
	'pfunc_expr_invalid_argument' => "Paramètre incorrect pour '''$1''' : < -1 ou > 1.",
	'pfunc_expr_invalid_argument_ln' => "Paramètre incorrect pour '''ln''' : ≤ 0.",
	'pfunc_expr_unknown_error' => 'Erreur d’expression : erreur inconnue ($1).',
	'pfunc_expr_not_a_number' => 'Dans $1 : le résultat n’est pas un nombre.',
	'pfunc_string_too_long' => 'Erreur : La chaîne dépasse la limite maximale de $1 caractère{{PLURAL:$1||s}}.',
	'pfunc-convert-dimensionmismatch' => 'Erreur: Impossible de faire une conversion entre les unités de "$1" et "$2".',
	'pfunc-convert-unknownunit' => 'Erreur : "$1" est une unité inconnue.',
	'pfunc-convert-unknowndimension' => 'Erreur : "$1" est une dimension inconnue.',
	'pfunc-convert-invalidcompoundunit' => 'Erreur: Unité composée "$1" invalide.',
	'pfunc-convert-nounit' => 'Erreur: Aucune unité source fournie.',
	'pfunc-convert-doublecompoundunit' => 'Erreur: Impossible d\'analyser des unités doublement composées comme "$1".',
	'pfunc-convert-dimension-length' => 'longueur',
	'pfunc-convert-dimension-area' => 'aire',
	'pfunc-convert-dimension-volume' => 'volume',
	'pfunc-convert-dimension-time' => 'temps',
	'pfunc-convert-dimension-timesquared' => 'temps<sup>2</sup>',
	'pfunc-convert-dimension-mass' => 'masse',
	'pfunc-convert-dimension-speed' => 'vitesse',
	'pfunc-convert-dimension-temperature' => 'température',
	'pfunc-convert-dimension-acceleration' => 'accélération',
	'pfunc-convert-dimension-force' => 'force',
	'pfunc-convert-dimension-torque' => 'couple',
	'pfunc-convert-dimension-energy' => 'énergie',
	'pfunc-convert-dimension-power' => 'puissance',
	'pfunc-convert-dimension-pressure' => 'pression',
	'pfunc-convert-dimension-density' => 'densité',
	'pfunc-convert-dimension-fuelefficiencypositive' => 'fuelefficiencypositive',
	'pfunc-convert-dimension-fuelefficiencynegative' => 'fuelefficiencynegative',
	'pfunc-convert-prefix-yotta' => 'yotta',
	'pfunc-convert-prefix-zetta' => 'zetta',
	'pfunc-convert-prefix-exa' => 'exa',
	'pfunc-convert-prefix-peta' => 'peta',
	'pfunc-convert-prefix-tera' => 'tera',
	'pfunc-convert-prefix-giga' => 'giga',
	'pfunc-convert-prefix-mega' => 'mega',
	'pfunc-convert-prefix-kilo' => 'kilo',
	'pfunc-convert-prefix-hecto' => 'hecto',
	'pfunc-convert-prefix-deca' => 'deca',
	'pfunc-convert-prefix-deci' => 'deci',
	'pfunc-convert-prefix-centi' => 'centi',
	'pfunc-convert-prefix-milli' => 'mili',
	'pfunc-convert-prefix-micro' => 'micro',
	'pfunc-convert-prefix-nano' => 'nano',
	'pfunc-convert-prefix-pico' => 'pico',
	'pfunc-convert-prefix-femto' => 'femto',
	'pfunc-convert-prefix-atto' => 'atto',
	'pfunc-convert-prefix-zepto' => 'zepto',
	'pfunc-convert-prefix-yocto' => 'yocto',
	'pfunc-convert-prefix-milli-abbr' => 'm',
	'pfunc-convert-unit-length-metre' => '$1{{PLURAL:$2|$3 mètre|$3 mètres}}',
	'pfunc-convert-unit-length-angstrom' => '$1{{PLURAL:$2|angström|angströms}}',
	'pfunc-convert-unit-length-mile' => '$1{{PLURAL:$2|mile|miles}}',
	'pfunc-convert-unit-length-furlong' => '$1{{PLURAL:$2|furlong|furlongs}}',
	'pfunc-convert-unit-length-chain' => '$1{{PLURAL:$2|chaîne|chaînes}}',
	'pfunc-convert-unit-length-rod' => '$1{{PLURAL:$2|tige|tiges}}',
	'pfunc-convert-unit-length-fathom' => '$1{{PLURAL:$2|brasse|brasses}}',
	'pfunc-convert-unit-length-yard' => '$1{{PLURAL:$2|yard|yards}}',
	'pfunc-convert-unit-length-foot' => '$1{{PLURAL:$2|pied|pieds}}',
	'pfunc-convert-unit-length-hand' => '$1{{PLURAL:$2|main|mains}}',
	'pfunc-convert-unit-length-inch' => '$1{{PLURAL:$2|pouce|pouces}}',
	'pfunc-convert-unit-length-nauticalmile' => '$1{{PLURAL:$2|mile nautique|miles nautiques}}',
	'pfunc-convert-unit-length-nauticalmileuk' => '$1{{PLURAL:$2|mile nautique (britannique, avant 1970)|miles nautiques (britanniques, avant 1970)}}',
	'pfunc-convert-unit-length-nauticalmileus' => '$1{{PLURAL:$2|mile nautique (États-Unis, avant 1954)|miles nautiques (États-Unis, avant 1954)}}',
	'pfunc-convert-unit-length-parsec' => '$1{{PLURAL:$2|$3parsec|$3parsecs}}',
	'pfunc-convert-unit-length-lightyear' => '$1{{PLURAL:$2|$3 année-lumière|$3 années-lumière}}',
	'pfunc-convert-unit-length-astronomicalunit' => '$1{{PLURAL:$2|unité astronomique|unités astronomiques}}',
	'pfunc-convert-unit-length-furlong-abbr' => '$1furlong',
	'pfunc-convert-unit-length-chain-abbr' => '$1chaîne',
	'pfunc-convert-unit-length-rod-abbr' => '$1rd',
	'pfunc-convert-unit-length-fathom-abbr' => '$1brasse',
	'pfunc-convert-unit-length-yard-abbr' => '$1yd',
	'pfunc-convert-unit-length-foot-abbr' => '$1ft',
	'pfunc-convert-unit-length-hand-abbr' => '$1h',
	'pfunc-convert-unit-length-inch-abbr' => '$1in',
	'pfunc-convert-unit-length-nauticalmile-abbr' => '$1nmi',
	'pfunc-convert-unit-length-nauticalmileuk-abbr' => '$1nmi (Brit.)',
	'pfunc-convert-unit-length-nauticalmileus-abbr' => '$1nmi (États-Unis avant 1954)',
	'pfunc-convert-unit-length-parsec-abbr' => '$1$3 pc',
	'pfunc-convert-unit-length-lightyear-abbr' => '$1$3 ly',
	'pfunc-convert-unit-length-astronomicalunit-abbr' => '$1AU',
	'pfunc-convert-unit-area-squarekilometre' => '$1{{PLURAL:$2|kilomètre carré|kilomètres carrés}}',
	'pfunc-convert-unit-area-squaremetre' => '$1{{PLURAL:$2|mètre carré|mètres carrés}}',
	'pfunc-convert-unit-area-squarecentimetre' => '$1{{PLURAL:$2|centimètre carré|centimètres carrés}}',
	'pfunc-convert-unit-area-squaremillimetre' => '$1{{PLURAL:$2|millimètre carré|millimètres carrés}}',
	'pfunc-convert-unit-area-hectare' => '$1{{PLURAL:$2|hectare|hectares}}',
	'pfunc-convert-unit-area-squaremile' => '$1{{PLURAL:$2|mile carré|miles carrés}}',
	'pfunc-convert-unit-area-acre' => '$1{{PLURAL:$2|acre|acres}}',
	'pfunc-convert-unit-area-squareyard' => '$1{{PLURAL:$2|yard carré|yards carrés}}',
	'pfunc-convert-unit-area-squarefoot' => '$1{{PLURAL:$2|pied carré|pieds carrés}}',
	'pfunc-convert-unit-area-squareinch' => '$1{{PLURAL:$2|pouce carré|pouces carrés}}',
	'pfunc-convert-unit-area-squarenauticalmile' => '$1{{PLURAL:$2|mile nautique carré|miles nautiques carrés}}',
	'pfunc-convert-unit-area-dunam' => '$1{{PLURAL:$2|dunam|dunams}}',
	'pfunc-convert-unit-area-tsubo' => '$1{{PLURAL:$2|tsubo|tsubos}}',
	'pfunc-convert-unit-area-squarekilometre-abbr' => '$1km<sup>2</sup>',
	'pfunc-convert-unit-area-squaremetre-abbr' => '$1m<sup>2</sup>',
	'pfunc-convert-unit-area-squarecentimetre-abbr' => '$1cm<sup>2</sup>',
	'pfunc-convert-unit-area-squaremillimetre-abbr' => '$1mm<sup>2</sup>',
	'pfunc-convert-unit-area-hectare-abbr' => '$1ha',
	'pfunc-convert-unit-area-squaremile-abbr' => '$1mi^2',
	'pfunc-convert-unit-area-acre-abbr' => '$1acre',
	'pfunc-convert-unit-area-squareyard-abbr' => '$1yd^2',
	'pfunc-convert-unit-area-squarefoot-abbr' => '$1ft^2',
	'pfunc-convert-unit-area-squareinch-abbr' => '$1in^2',
	'pfunc-convert-unit-area-squarenauticalmile-abbr' => '$1nmi^2',
	'pfunc-convert-unit-area-dunam-abbr' => '$1dunam',
	'pfunc-convert-unit-area-tsubo-abbr' => '$1tsubo',
	'pfunc-convert-unit-time-second' => '$1{{PLURAL:$2|seconde|secondes}}',
	'pfunc-convert-unit-time-year' => '$1{{PLURAL:$2|$3 an|$3 ans}}',
	'pfunc-convert-unit-time-day' => '$1{{PLURAL:$2|jour|jours}}',
	'pfunc-convert-unit-time-hour' => '$1{{PLURAL:$2|heure|heures}}',
	'pfunc-convert-unit-time-minute' => '$1{{PLURAL:$2|minute|minutes}}',
	'pfunc-convert-unit-time-second-abbr' => '$1s',
	'pfunc-convert-unit-time-year-abbr' => '$1$3an',
	'pfunc-convert-unit-time-day-abbr' => '$1j',
	'pfunc-convert-unit-time-hour-abbr' => '$1h',
	'pfunc-convert-unit-time-minute-abbr' => '$1m',
	'pfunc-convert-unit-volume-cubicmetre' => '$1{{PLURAL:$2|mètre cube|mètres cubes}}',
	'pfunc-convert-unit-volume-cubiccentimetre' => '$1{{PLURAL:$2|centimètre cube|centimètres cubes}}',
	'pfunc-convert-unit-volume-cubicmillimetre' => '$1{{PLURAL:$2|millimètre cube|millimètres cubes}}',
	'pfunc-convert-unit-volume-kilolitre' => '$1{{PLURAL:$2|kilolitre|kilolitres}}',
	'pfunc-convert-unit-volume-litre' => '$1{{PLURAL:$2|litre|litres}}',
	'pfunc-convert-unit-volume-centilitre' => '$1{{PLURAL:$2|centilitre|centilitres}}',
	'pfunc-convert-unit-volume-millilitre' => '$1{{PLURAL:$2|millilitre|millilitres}}',
	'pfunc-convert-unit-volume-cubicyard' => '$1{{PLURAL:$2|yard cube|yards cubes}}',
	'pfunc-convert-unit-volume-cubicfoot' => '$1{{PLURAL:$2|pied cube|pieds cubes}}',
	'pfunc-convert-unit-volume-cubicinch' => '$1{{PLURAL:$2|pouce cube|pouces cubes}}',
	'pfunc-convert-unit-volume-barrel' => '$1{{PLURAL:$2|baril|barils}}',
	'pfunc-convert-unit-volume-bushel' => '$1{{PLURAL:$2|boisseau|boisseaux}}',
	'pfunc-convert-unit-volume-gallon' => '$1{{PLURAL:$2|gallon|gallons}}',
	'pfunc-convert-unit-volume-quart' => '$1{{PLURAL:$2|litre|litres}}',
	'pfunc-convert-unit-volume-pint' => '$1{{PLURAL:$2|pinte|pintes}}',
	'pfunc-convert-unit-volume-fluidounce' => '$1{{PLURAL:$2|once liquide|onces liquides}}',
	'pfunc-convert-unit-volume-barrelus' => '$1{{PLURAL:$2|baril US|barils US}}',
	'pfunc-convert-unit-volume-barreloil' => '$1{{PLURAL:$2|baril|barils}}',
	'pfunc-convert-unit-volume-barrelbeer' => '$1{{PLURAL:$2|baril|barils}}',
	'pfunc-convert-unit-volume-usgallon' => '$1{{PLURAL:$2|gallon US|gallons US}}',
	'pfunc-convert-unit-volume-usquart' => '$1{{PLURAL:$2|litre US|litres US}}',
	'pfunc-convert-unit-volume-uspint' => '$1{{PLURAL:$2|pinte US|pintes US}}',
	'pfunc-convert-unit-volume-usfluidounce' => '$1{{PLURAL:$2|once liquide US|onces liquides US}}',
	'pfunc-convert-unit-volume-usdrybarrel' => '$1{{PLURAL:$2|baril sec US|barils secs US}}',
	'pfunc-convert-unit-volume-usbushel' => '$1{{PLURAL:$2|boisseau US|boisseaux US}}',
	'pfunc-convert-unit-volume-usdrygallon' => '$1{{PLURAL:$2|gallon sec US|gallons secs US}}',
	'pfunc-convert-unit-volume-usdryquart' => '$1{{PLURAL:$2|litre sec US|litres secs US}}',
	'pfunc-convert-unit-volume-usdrypint' => '$1{{PLURAL:$2|pinte sèche US|pintes sèches US}}',
	'pfunc-convert-unit-volume-cubicmetre-abbr' => '$1m<sup>3</sup>',
	'pfunc-convert-unit-volume-cubiccentimetre-abbr' => '$1cm<sup>3</sup>',
	'pfunc-convert-unit-volume-cubicmillimetre-abbr' => '$1mm<sup>3</sup>',
	'pfunc-convert-unit-volume-litre-abbr' => '$1$3l',
	'pfunc-convert-unit-volume-cubicyard-abbr' => '$1yd^3',
	'pfunc-convert-unit-volume-cubicfoot-abbr' => '$1ft^3',
	'pfunc-convert-unit-volume-cubicinch-abbr' => '$1in^3',
	'pfunc-convert-unit-volume-barrel-abbr' => '$1bbl',
	'pfunc-convert-unit-volume-bushel-abbr' => '$1bsh',
	'pfunc-convert-unit-volume-gallon-abbr' => '$1gal',
	'pfunc-convert-unit-volume-quart-abbr' => '$1qt',
	'pfunc-convert-unit-volume-pint-abbr' => '$1pt',
	'pfunc-convert-unit-volume-fluidounce-abbr' => '$1fl oz',
	'pfunc-convert-unit-volume-barrelus-abbr' => '$1US bbl',
	'pfunc-convert-unit-volume-barreloil-abbr' => '$1bbl',
	'pfunc-convert-unit-volume-barrelbeer-abbr' => '$1bbl',
	'pfunc-convert-unit-volume-usgallon-abbr' => '$1US gal',
	'pfunc-convert-unit-volume-usquart-abbr' => '$1US qt',
	'pfunc-convert-unit-volume-uspint-abbr' => '$1US pt',
	'pfunc-convert-unit-volume-usfluidounce-abbr' => '$1US fl oz',
	'pfunc-convert-unit-volume-usdrybarrel-abbr' => '$1US bbl',
	'pfunc-convert-unit-volume-usbushel-abbr' => '$1US bsh',
	'pfunc-convert-unit-volume-usdrygallon-abbr' => '$1US gal sec',
	'pfunc-convert-unit-volume-usdryquart-abbr' => '$1US qt sec',
	'pfunc-convert-unit-volume-usdrypint-abbr' => '$1US pt sec',
	'pfunc-convert-unit-speed-mile-hour' => '$1miles par heure',
	'pfunc-convert-unit-speed-speedoflight' => '$1c',
	'pfunc-convert-unit-speed-mile-hour-abbr' => '$1m/h',
	'pfunc-convert-unit-speed-speedoflight-abbr' => '$1c',
	'pfunc-convert-unit-pressure-pascal' => '$1{{PLURAL:$2|$3 pascal|$3 pascals}}',
	'pfunc-convert-unit-pressure-bar' => '$1bar',
	'pfunc-convert-unit-pressure-decibar' => '$1decibar',
	'pfunc-convert-unit-pressure-millibar' => '$1millibar',
	'pfunc-convert-unit-pressure-kilobarye' => '$1kilobar',
	'pfunc-convert-unit-pressure-barye' => '$1barye',
	'pfunc-convert-unit-pressure-atmosphere' => '$1{{PLURAL:$2|atmosphère|atmosphères}}',
	'pfunc-convert-unit-pressure-torr' => '$1{{PLURAL:$2|torr|torrs}}',
	'pfunc-convert-unit-pressure-mmhg' => '$1{{PLURAL:$2|millimètre de mercure|millimètres de mercure}}',
	'pfunc-convert-unit-pressure-inhg' => '$1{{PLURAL:$2|pouce de mercure|pouces de mercure}}',
	'pfunc-convert-unit-pressure-psi' => '$1{{PLURAL:$2|livre par pouce carré|livres par pouce carré}}',
	'pfunc-convert-unit-pressure-pascal-abbr' => '$1$3 Pa',
	'pfunc-convert-unit-pressure-bar-abbr' => '$1bar',
	'pfunc-convert-unit-pressure-decibar-abbr' => '$1dbar',
	'pfunc-convert-unit-pressure-millibar-abbr' => '$1mbar',
	'pfunc-convert-unit-pressure-kilobarye-abbr' => '$1kBa',
	'pfunc-convert-unit-pressure-barye-abbr' => '$1Ba',
	'pfunc-convert-unit-pressure-atmosphere-abbr' => '$1atm',
	'pfunc-convert-unit-pressure-torr-abbr' => '$1Torr',
	'pfunc-convert-unit-pressure-mmhg-abbr' => '$1mmHg',
	'pfunc-convert-unit-pressure-inhg-abbr' => '$1inHg',
	'pfunc-convert-unit-pressure-psi-abbr' => '$1psi',
);

/** Franco-Provençal (Arpetan)
 * @author ChrisPtDe
 */
$messages['frp'] = array(
	'pfunc_desc' => 'Mèlyore lo parsor avouéc des fonccions logiques.',
	'pfunc_time_error' => 'Èrror : temps envalido',
	'pfunc_time_too_long' => 'Èrror : trop grant nombro d’apèls a <code>#time</code>',
	'pfunc_rel2abs_invalid_depth' => 'Èrror : provondior envalida dens lo chemin « $1 » (at tâchiê d’arrevar a un nivél en-dessus du nuod racena)',
	'pfunc_expr_stack_exhausted' => 'Èrror d’èxprèssion : pila èpouesiê',
	'pfunc_expr_unexpected_number' => 'Èrror d’èxprèssion : nombro emprèvu',
	'pfunc_expr_preg_match_failure' => 'Èrror d’èxprèssion : falyita emprèvua de <code>preg_match</code>',
	'pfunc_expr_unrecognised_word' => 'Èrror d’èxprèssion : mot « $1 » pas recognu',
	'pfunc_expr_unexpected_operator' => 'Èrror d’èxprèssion : opèrator « $1 » emprèvu',
	'pfunc_expr_missing_operand' => 'Èrror d’èxprèssion : opèrando manquent por « $1 »',
	'pfunc_expr_unexpected_closing_bracket' => 'Èrror d’èxprèssion : parentèsa cllosenta emprèvua',
	'pfunc_expr_unrecognised_punctuation' => 'Èrror d’èxprèssion : caractèro de ponctuacion « $1 » pas recognu',
	'pfunc_expr_unclosed_bracket' => 'Èrror d’èxprèssion : parentèsa pas cllôsa',
	'pfunc_expr_division_by_zero' => 'Division per zérô',
	'pfunc_expr_invalid_argument' => 'Argument fôx por « $1 » : < -1 ou ben > 1',
	'pfunc_expr_invalid_argument_ln' => 'Argument fôx por « ln » : ≤ 0',
	'pfunc_expr_unknown_error' => 'Èrror d’èxprèssion : èrror encognua ($1)',
	'pfunc_expr_not_a_number' => 'Dens $1 : lo rèsultat est pas un nombro',
	'pfunc_string_too_long' => 'Èrror : la chêna dèpâsse la limita d’amont de $1 caractèro{{PLURAL:$1||s}}',
	'pfunc-convert-unknownunit' => 'Èrror : « $1 » est una unitât encognua.',
	'pfunc-convert-unknowndimension' => 'Èrror : « $1 » est una dimension encognua.',
	'pfunc-convert-dimension-length' => 'longior',
	'pfunc-convert-dimension-area' => 'surface',
	'pfunc-convert-dimension-volume' => 'cubâjo',
	'pfunc-convert-dimension-time' => 'temps',
	'pfunc-convert-dimension-timesquared' => 'temps<sup>2</sup>',
	'pfunc-convert-dimension-mass' => 'massa',
	'pfunc-convert-dimension-speed' => 'vitèsse',
	'pfunc-convert-dimension-temperature' => 'tempèratura',
	'pfunc-convert-dimension-acceleration' => 'accèlèracion',
	'pfunc-convert-dimension-force' => 'fôrce',
	'pfunc-convert-dimension-torque' => 'cobla',
	'pfunc-convert-dimension-energy' => 'nèrf',
	'pfunc-convert-dimension-power' => 'pouessience',
	'pfunc-convert-dimension-pressure' => 'prèssion',
	'pfunc-convert-dimension-density' => 'densitât',
	'pfunc-convert-prefix-yotta' => 'yota',
	'pfunc-convert-prefix-zetta' => 'zèta',
	'pfunc-convert-prefix-exa' => 'ègza',
	'pfunc-convert-prefix-peta' => 'pèta',
	'pfunc-convert-prefix-tera' => 'tèra',
	'pfunc-convert-prefix-giga' => 'giga',
	'pfunc-convert-prefix-mega' => 'mèga',
	'pfunc-convert-prefix-kilo' => 'kilo',
	'pfunc-convert-prefix-hecto' => 'hècto',
	'pfunc-convert-prefix-deca' => 'dèca',
	'pfunc-convert-prefix-deci' => 'dèci',
	'pfunc-convert-prefix-centi' => 'centi',
	'pfunc-convert-prefix-milli' => 'mili',
	'pfunc-convert-prefix-micro' => 'micro',
	'pfunc-convert-prefix-nano' => 'nano',
	'pfunc-convert-prefix-pico' => 'pico',
	'pfunc-convert-prefix-femto' => 'femto',
	'pfunc-convert-prefix-atto' => 'ato',
	'pfunc-convert-prefix-zepto' => 'zèpto',
	'pfunc-convert-prefix-yocto' => 'yocto',
	'pfunc-convert-prefix-milli-abbr' => 'm',
	'pfunc-convert-unit-length-metre' => '$1$3mètre{{PLURAL:$2||s}}',
	'pfunc-convert-unit-length-angstrom' => '$1ångström{{PLURAL:$2||s}}',
	'pfunc-convert-unit-length-mile' => '$1mile{{PLURAL:$2||s}}',
	'pfunc-convert-unit-length-furlong' => '$1furlong{{PLURAL:$2||s}}',
	'pfunc-convert-unit-length-chain' => '$1chên{{PLURAL:$2|a|es}}',
	'pfunc-convert-unit-length-rod' => '$1pèrche{{PLURAL:$2||s}}',
	'pfunc-convert-unit-length-fathom' => '$1braciê{{PLURAL:$2||s}}',
	'pfunc-convert-unit-length-yard' => '$1vèrge{{PLURAL:$2||s}}',
	'pfunc-convert-unit-length-foot' => '$1pied{{PLURAL:$2||s}}',
	'pfunc-convert-unit-length-hand' => '$1man{{PLURAL:$2||s}}',
	'pfunc-convert-unit-length-inch' => '$1pôjo{{PLURAL:$2||s}}',
	'pfunc-convert-unit-length-nauticalmile' => '$1{{PLURAL:$2|mile marin|miles marins}}',
	'pfunc-convert-unit-length-nauticalmileuk' => '$1{{PLURAL:$2|mile marin (prè-1970 britanico)|miles marins (prè-1970 britanicos)}}',
	'pfunc-convert-unit-length-nauticalmileus' => '$1{{PLURAL:$2|mile marin (prè-1954 des Ètats-Unis)|miles marins (prè-1954 des Ètats-Unis)}}',
	'pfunc-convert-unit-length-parsec' => '$1$3parsec{{PLURAL:$2||s}}',
	'pfunc-convert-unit-length-lightyear' => '$1{{PLURAL:$2|$3an|$3ans}}-lumiére',
	'pfunc-convert-unit-length-astronomicalunit' => '$1{{PLURAL:$2|unitât astronomica|unitâts astronomiques}}',
	'pfunc-convert-unit-length-furlong-abbr' => '$1furlong',
	'pfunc-convert-unit-length-chain-abbr' => '$1chêna',
	'pfunc-convert-unit-length-rod-abbr' => '$1pèrche',
	'pfunc-convert-unit-length-fathom-abbr' => '$1braciê',
	'pfunc-convert-unit-length-yard-abbr' => '$1vg',
	'pfunc-convert-unit-length-foot-abbr' => '$1ft',
	'pfunc-convert-unit-length-hand-abbr' => '$1h',
	'pfunc-convert-unit-length-inch-abbr' => '$1po',
	'pfunc-convert-unit-length-nauticalmile-abbr' => '$1nmi',
	'pfunc-convert-unit-length-parsec-abbr' => '$1$3pc',
	'pfunc-convert-unit-length-lightyear-abbr' => '$1$3al',
	'pfunc-convert-unit-length-astronomicalunit-abbr' => '$1UA',
	'pfunc-convert-unit-area-hectare' => '$1hèctâre{{PLURAL:$2||s}}',
	'pfunc-convert-unit-area-squaremile' => '$1{{PLURAL:$2|mile carrâ|miles carrâs}}',
	'pfunc-convert-unit-area-squareyard' => '$1{{PLURAL:$2|vèrge carrâ|vèrges carrâs}}',
	'pfunc-convert-unit-area-squareinch' => '$1{{PLURAL:$2|pôjo carrâ|pôjos carrâs}}',
	'pfunc-convert-unit-area-squarekilometre-abbr' => '$1km<sup>2</sup>',
	'pfunc-convert-unit-area-squaremetre-abbr' => '$1m<sup>2</sup>',
	'pfunc-convert-unit-area-squarecentimetre-abbr' => '$1cm<sup>2</sup>',
	'pfunc-convert-unit-area-squaremillimetre-abbr' => '$1mm<sup>2</sup>',
	'pfunc-convert-unit-area-hectare-abbr' => '$1ha',
	'pfunc-convert-unit-area-squaremile-abbr' => '$1mi<sup>2</sup>',
	'pfunc-convert-unit-area-squareyard-abbr' => '$1vg<sup>2</sup>',
	'pfunc-convert-unit-area-squareinch-abbr' => '$1po<sup>2</sup>',
	'pfunc-convert-unit-area-squarenauticalmile-abbr' => '$1nmi<sup>2</sup>',
	'pfunc-convert-unit-time-second' => '$1second{{PLURAL:$2|a|es}}',
	'pfunc-convert-unit-time-year' => '$1$3an{{PLURAL:$2||s}}',
	'pfunc-convert-unit-time-day' => '$1jorn{{PLURAL:$2||s}}',
	'pfunc-convert-unit-time-hour' => '$1hor{{PLURAL:$2|a|es}}',
	'pfunc-convert-unit-time-minute' => '$1menut{{PLURAL:$2|a|es}}',
	'pfunc-convert-unit-time-second-abbr' => '$1s',
	'pfunc-convert-unit-time-year-abbr' => '$1$3a',
	'pfunc-convert-unit-time-day-abbr' => '$1j',
	'pfunc-convert-unit-time-hour-abbr' => '$1h',
	'pfunc-convert-unit-time-minute-abbr' => '$1min',
	'pfunc-convert-unit-volume-cubicmetre-abbr' => '$1m<sup>3</sup>',
	'pfunc-convert-unit-volume-cubiccentimetre-abbr' => '$1cm<sup>3</sup>',
	'pfunc-convert-unit-volume-cubicmillimetre-abbr' => '$1mm<sup>3</sup>',
	'pfunc-convert-unit-volume-litre-abbr' => '$1$3l',
	'pfunc-convert-unit-speed-mile-hour' => '$1miles per hora',
	'pfunc-convert-unit-speed-speedoflight' => '$1c',
	'pfunc-convert-unit-speed-mile-hour-abbr' => '$1mph',
	'pfunc-convert-unit-speed-speedoflight-abbr' => '$1c',
	'pfunc-convert-unit-pressure-pascal' => '$1{{PLURAL:$2|$3pascâl|$3pascâls}}',
	'pfunc-convert-unit-pressure-bar' => '$1bar',
	'pfunc-convert-unit-pressure-decibar' => '$1dècibar',
	'pfunc-convert-unit-pressure-millibar' => '$1milibar',
	'pfunc-convert-unit-pressure-kilobarye' => '$1kilobarye',
	'pfunc-convert-unit-pressure-barye' => '$1barye',
	'pfunc-convert-unit-pressure-atmosphere' => '$1atmosfér{{PLURAL:$2|a|es}}',
	'pfunc-convert-unit-pressure-torr' => '$1torr{{PLURAL:$2||s}}',
	'pfunc-convert-unit-pressure-mmhg' => '$1milimètre{{PLURAL:$2||s}} de mèrcure',
	'pfunc-convert-unit-pressure-inhg' => '$1pôjo{{PLURAL:$2||s}} de mèrcure',
	'pfunc-convert-unit-pressure-psi' => '$1livr{{PLURAL:$2|a|es}} per pôjo carrâ',
	'pfunc-convert-unit-pressure-pascal-abbr' => '$1$3Pa',
	'pfunc-convert-unit-pressure-bar-abbr' => '$1bar',
	'pfunc-convert-unit-pressure-decibar-abbr' => '$1dbar',
	'pfunc-convert-unit-pressure-millibar-abbr' => '$1mbar',
	'pfunc-convert-unit-pressure-kilobarye-abbr' => '$1kBa',
	'pfunc-convert-unit-pressure-barye-abbr' => '$1Ba',
	'pfunc-convert-unit-pressure-atmosphere-abbr' => '$1atm',
	'pfunc-convert-unit-pressure-torr-abbr' => '$1Torr',
	'pfunc-convert-unit-pressure-mmhg-abbr' => '$1mmHg',
	'pfunc-convert-unit-pressure-inhg-abbr' => '$1inHg',
	'pfunc-convert-unit-pressure-psi-abbr' => '$1psi',
);

/** Galician (Galego)
 * @author Alma
 * @author Elisardojm
 * @author Toliño
 * @author Xosé
 */
$messages['gl'] = array(
	'pfunc_desc' => 'Mellora o analizador con funcións lóxicas',
	'pfunc_time_error' => 'Erro: Hora non válida.',
	'pfunc_time_too_long' => 'Erro: Demasiadas chamadas #time.',
	'pfunc_time_too_big' => 'Erro: #time só permite anos ata o 9999.',
	'pfunc_rel2abs_invalid_depth' => 'Erro: Profundidade da ruta non válida: "$1" (intentouse acceder a un nodo por riba do nodo raíz).',
	'pfunc_expr_stack_exhausted' => 'Erro de expresión: Pila esgotada.',
	'pfunc_expr_unexpected_number' => 'Erro de expresión: Número inesperado.',
	'pfunc_expr_preg_match_failure' => 'Erro de expresión: Fallo de preg_match inesperado.',
	'pfunc_expr_unrecognised_word' => 'Erro de expresión: Descoñécese a palabra "$1".',
	'pfunc_expr_unexpected_operator' => 'Erro de expresión: Operador "$1" inesperado.',
	'pfunc_expr_missing_operand' => 'Erro de expresión: Falta un operador para $1.',
	'pfunc_expr_unexpected_closing_bracket' => 'Erro de expresión: Corchete de peche inesperado.',
	'pfunc_expr_unrecognised_punctuation' => 'Erro de expresión: Descoñécese o signo de puntuación "$1".',
	'pfunc_expr_unclosed_bracket' => 'Erro de expresión: Paréntese sen pechar.',
	'pfunc_expr_division_by_zero' => 'División por cero.',
	'pfunc_expr_invalid_argument' => 'Argumento inválido para $1: < -1 ou > 1.',
	'pfunc_expr_invalid_argument_ln' => 'Argumento inválido para ln: <= 0.',
	'pfunc_expr_unknown_error' => 'Erro de expresión: Erro descoñecido ($1).',
	'pfunc_expr_not_a_number' => 'En $1: O resultado non é un número.',
	'pfunc_string_too_long' => 'Erro: A cadea excede o límite de $1 caracteres.',
	'pfunc-convert-dimensionmismatch' => 'Erro: Non se pode converter entre as unidades "$1" e "$2".',
	'pfunc-convert-unknownunit' => 'Erro: Descoñécese a unidade "$1".',
	'pfunc-convert-unknowndimension' => 'Erro: Descoñécese a dimensión "$1".',
	'pfunc-convert-invalidcompoundunit' => 'Erro: A unidade composta "$1" é inválida.',
	'pfunc-convert-nounit' => 'Erro: Non se deu ningunha unidade de orixe.',
	'pfunc-convert-doublecompoundunit' => 'Erro: Non se poden analizar as unidades compostas dobres como "$1".',
	'pfunc-convert-dimension-length' => 'lonxitude',
	'pfunc-convert-dimension-area' => 'área',
	'pfunc-convert-dimension-volume' => 'volume',
	'pfunc-convert-dimension-time' => 'tempo',
	'pfunc-convert-dimension-timesquared' => 'tempo<sup>2</sup>',
	'pfunc-convert-dimension-mass' => 'masa',
	'pfunc-convert-dimension-speed' => 'velocidade',
	'pfunc-convert-dimension-temperature' => 'temperatura',
	'pfunc-convert-dimension-acceleration' => 'aceleración',
	'pfunc-convert-dimension-force' => 'forza',
	'pfunc-convert-dimension-torque' => 'torque',
	'pfunc-convert-dimension-energy' => 'enerxía',
	'pfunc-convert-dimension-power' => 'potencia',
	'pfunc-convert-dimension-pressure' => 'presión',
	'pfunc-convert-dimension-density' => 'densidade',
	'pfunc-convert-prefix-yotta' => 'yotta',
	'pfunc-convert-prefix-zetta' => 'zetta',
	'pfunc-convert-prefix-exa' => 'exa',
	'pfunc-convert-prefix-peta' => 'peta',
	'pfunc-convert-prefix-tera' => 'tera',
	'pfunc-convert-prefix-giga' => 'xiga',
	'pfunc-convert-prefix-mega' => 'mega',
	'pfunc-convert-prefix-kilo' => 'quilo',
	'pfunc-convert-prefix-hecto' => 'hecto',
	'pfunc-convert-prefix-deca' => 'deca',
	'pfunc-convert-prefix-deci' => 'deci',
	'pfunc-convert-prefix-centi' => 'centi',
	'pfunc-convert-prefix-milli' => 'mili',
	'pfunc-convert-prefix-micro' => 'micro',
	'pfunc-convert-prefix-nano' => 'nano',
	'pfunc-convert-prefix-pico' => 'pico',
	'pfunc-convert-prefix-femto' => 'femto',
	'pfunc-convert-prefix-atto' => 'atto',
	'pfunc-convert-prefix-zepto' => 'zepto',
	'pfunc-convert-prefix-yocto' => 'yocto',
	'pfunc-convert-prefix-milli-abbr' => 'm',
	'pfunc-convert-unit-length-metre' => '$1{{PLURAL:$2|$3metro|$3metros}}',
	'pfunc-convert-unit-length-angstrom' => '$1{{PLURAL:$2|angstrom|angstroms}}',
	'pfunc-convert-unit-length-mile' => '$1{{PLURAL:$2|milla|millas}}',
	'pfunc-convert-unit-length-furlong' => '$1{{PLURAL:$2|furlong|furlongs}}',
	'pfunc-convert-unit-length-chain' => '$1{{PLURAL:$2|cadea|cadeas}}',
	'pfunc-convert-unit-length-rod' => '$1{{PLURAL:$2|rod|rods}}',
	'pfunc-convert-unit-length-fathom' => '$1{{PLURAL:$2|braza|brazas}}',
	'pfunc-convert-unit-length-yard' => '$1{{PLURAL:$2|iarda|iardas}}',
	'pfunc-convert-unit-length-foot' => '$1{{PLURAL:$2|pé|pés}}',
	'pfunc-convert-unit-length-hand' => '$1{{PLURAL:$2|palmo|palmos}}',
	'pfunc-convert-unit-length-inch' => '$1{{PLURAL:$2|polgada|polgadas}}',
	'pfunc-convert-unit-length-nauticalmile' => '$1{{PLURAL:$2|milla náutica|millas náuticas}}',
	'pfunc-convert-unit-length-parsec' => '$1{{PLURAL:$2|$3parsec|$3parsecs}}',
	'pfunc-convert-unit-length-lightyear' => '$1{{PLURAL:$2|$3ano luz|$3anos luz}}',
	'pfunc-convert-unit-length-astronomicalunit' => '$1{{PLURAL:$2|unidade astronómica|unidades astronómicas}}',
	'pfunc-convert-unit-length-furlong-abbr' => '$1furlong',
	'pfunc-convert-unit-length-chain-abbr' => '$1cadea',
	'pfunc-convert-unit-length-rod-abbr' => '$1rod',
	'pfunc-convert-unit-length-fathom-abbr' => '$1braza',
	'pfunc-convert-unit-length-yard-abbr' => '$1iarda',
	'pfunc-convert-unit-length-foot-abbr' => '$1pé',
	'pfunc-convert-unit-length-hand-abbr' => '$1palmo',
	'pfunc-convert-unit-length-inch-abbr' => '$1polgada',
	'pfunc-convert-unit-length-nauticalmile-abbr' => '$1milla náutica',
	'pfunc-convert-unit-length-parsec-abbr' => '$1$3parsec',
	'pfunc-convert-unit-length-lightyear-abbr' => '$1$3ano luz',
	'pfunc-convert-unit-length-astronomicalunit-abbr' => '$1UA',
	'pfunc-convert-unit-area-squarekilometre' => '$1{{PLURAL:$2|quilómetro cadrado|quilómetros cadrados}}',
	'pfunc-convert-unit-area-squaremetre' => '$1{{PLURAL:$2|metro cadrado|metros cadrados}}',
	'pfunc-convert-unit-area-squarecentimetre' => '$1{{PLURAL:$2|centímetro cadrado|centímetros cadrados}}',
	'pfunc-convert-unit-area-squaremillimetre' => '$1{{PLURAL:$2|milímetro cadrado|milímetros cadrados}}',
	'pfunc-convert-unit-area-hectare' => '$1{{PLURAL:$2|hectárea|hectáreas}}',
	'pfunc-convert-unit-area-squarekilometre-abbr' => '$1km<sup>2</sup>',
	'pfunc-convert-unit-area-squaremetre-abbr' => '$1m<sup>2</sup>',
	'pfunc-convert-unit-area-squarecentimetre-abbr' => '$1cm<sup>2</sup>',
	'pfunc-convert-unit-area-squaremillimetre-abbr' => '$1mm<sup>2</sup>',
	'pfunc-convert-unit-area-hectare-abbr' => '$1ha',
	'pfunc-convert-unit-time-second' => '$1{{PLURAL:$2|segundo|segundos}}',
	'pfunc-convert-unit-time-year' => '$1{{PLURAL:$2|$3ano|$3anos}}',
	'pfunc-convert-unit-time-day' => '$1{{PLURAL:$2|día|días}}',
	'pfunc-convert-unit-time-hour' => '$1{{PLURAL:$2|hora|horas}}',
	'pfunc-convert-unit-time-minute' => '$1{{PLURAL:$2|minuto|minutos}}',
	'pfunc-convert-unit-time-second-abbr' => '$1s',
	'pfunc-convert-unit-time-year-abbr' => '$1$3ano',
	'pfunc-convert-unit-time-day-abbr' => '$1día',
	'pfunc-convert-unit-time-hour-abbr' => '$1h',
	'pfunc-convert-unit-time-minute-abbr' => '$1min',
	'pfunc-convert-unit-volume-cubicmetre' => '$1{{PLURAL:$2|metro cúbico|metros cúbicos}}',
	'pfunc-convert-unit-volume-cubiccentimetre' => '$1{{PLURAL:$2|centímetro cúbico|centímetros cúbicos}}',
	'pfunc-convert-unit-volume-cubicmillimetre' => '$1{{PLURAL:$2|milímetro cúbico|milímetros cúbicos}}',
	'pfunc-convert-unit-volume-kilolitre' => '$1{{PLURAL:$2|quilolitro|quilolitros}}',
	'pfunc-convert-unit-volume-litre' => '$1{{PLURAL:$2|litro|litros}}',
	'pfunc-convert-unit-volume-centilitre' => '$1{{PLURAL:$2|centilitro|centilitros}}',
	'pfunc-convert-unit-volume-millilitre' => '$1{{PLURAL:$2|mililitro|mililitros}}',
	'pfunc-convert-unit-volume-cubicmetre-abbr' => '$1m<sup>3</sup>',
	'pfunc-convert-unit-volume-cubiccentimetre-abbr' => '$1cm<sup>3</sup>',
	'pfunc-convert-unit-volume-cubicmillimetre-abbr' => '$1mm<sup>3</sup>',
	'pfunc-convert-unit-volume-litre-abbr' => '$1$3L',
	'pfunc-convert-unit-speed-mile-hour' => '$1millas por hora',
	'pfunc-convert-unit-speed-speedoflight' => '$1c',
	'pfunc-convert-unit-speed-speedoflight-abbr' => '$1c',
	'pfunc-convert-unit-pressure-pascal' => '$1{{PLURAL:$2|$3pascal|$3pascais}}',
	'pfunc-convert-unit-pressure-bar' => '$1bar',
	'pfunc-convert-unit-pressure-decibar' => '$1decibar',
	'pfunc-convert-unit-pressure-millibar' => '$1milibar',
	'pfunc-convert-unit-pressure-atmosphere' => '$1{{PLURAL:$2|atmosfera|atmosferas}}',
	'pfunc-convert-unit-pressure-mmhg' => '$1{{PLURAL:$2|milímetro de mercurio|milímetros de mercurio}}',
	'pfunc-convert-unit-pressure-pascal-abbr' => '$1$3Pa',
	'pfunc-convert-unit-pressure-bar-abbr' => '$1bar',
	'pfunc-convert-unit-pressure-decibar-abbr' => '$1dbar',
	'pfunc-convert-unit-pressure-millibar-abbr' => '$1mbar',
	'pfunc-convert-unit-pressure-atmosphere-abbr' => '$1atm',
	'pfunc-convert-unit-pressure-mmhg-abbr' => '$1mmHg',
);

/** Ancient Greek (Ἀρχαία ἑλληνικὴ)
 * @author Omnipaedista
 */
$messages['grc'] = array(
	'pfunc_expr_division_by_zero' => 'Διαίρεσις διὰ τοῦ μηδενός',
);

/** Swiss German (Alemannisch)
 * @author Als-Holder
 */
$messages['gsw'] = array(
	'pfunc_desc' => 'Erwyteret dr Parser um logischi Funktione',
	'pfunc_time_error' => 'Fähler: uugiltigi Zytaagab',
	'pfunc_time_too_long' => 'Fähler: z vyyl #time-Ufruef',
	'pfunc_time_too_big' => 'Fähler: #time unterstitzt nume Johr bis 9999',
	'pfunc_rel2abs_invalid_depth' => 'Fähler: uugültigi Tiefi im Pfad: „$1“ (Versuech, uf e Chnotepunkt oberhalb vum Hauptchnotepunkt zuezgryfe)',
	'pfunc_expr_stack_exhausted' => 'Expression-Fähler: Stackiberlauf',
	'pfunc_expr_unexpected_number' => 'Expression-Fähler: Nit erwarteti Zahl',
	'pfunc_expr_preg_match_failure' => 'Expression-Fähler: Nit erwarteti „preg_match“-Fählfunktion',
	'pfunc_expr_unrecognised_word' => 'Expression-Fähler: Nit erkannt Wort „$1“',
	'pfunc_expr_unexpected_operator' => 'Expression-Fähler: Nit erwartete Operator: <tt>$1</tt>',
	'pfunc_expr_missing_operand' => 'Expression-Fähler: Operand fir <tt>$1</tt> fählt',
	'pfunc_expr_unexpected_closing_bracket' => 'Expression-Fähler: Nit erwarteti schließendi eckigi Chlammere',
	'pfunc_expr_unrecognised_punctuation' => 'Expression-Fähler: Nit erkannt Satzzeiche „$1“',
	'pfunc_expr_unclosed_bracket' => 'Expression-Fähler: Nit gschlosseni eckige Chlammere',
	'pfunc_expr_division_by_zero' => 'Expression-Fähler: Division dur Null',
	'pfunc_expr_invalid_argument' => 'Nit giltig Argument fir $1: < -1 oder > 1',
	'pfunc_expr_invalid_argument_ln' => 'Nit giltig Argument fir ln: <= 0',
	'pfunc_expr_unknown_error' => 'Expression-Fähler: Nit bekannte Fehler ($1)',
	'pfunc_expr_not_a_number' => 'Expression-Fähler: In $1: Ergebnis isch kei Zahl',
	'pfunc_string_too_long' => 'Fähler: d Zeichechette het meh wie di zuelässig Zahl vu $1 Zeiche',
);

/** Hebrew (עברית)
 * @author Amire80
 */
$messages['he'] = array(
	'pfunc_desc' => 'הוספת פונקציות לוגיות למפענח',
	'pfunc_time_error' => 'שגיאה: זמן שגוי',
	'pfunc_time_too_long' => 'שגיאה: שימוש ב"#זמן" פעמים רבות מדי',
	'pfunc_time_too_big' => 'שגיאה: #זמן תומכת רק בשנים עד 9999',
	'pfunc_rel2abs_invalid_depth' => 'שגיאה: עומק שגוי בנתיב: "$1" (ניסיון כניסה לצומת מעל צומת השורש)',
	'pfunc_expr_stack_exhausted' => 'שגיאה בביטוי: המחסנית מלאה',
	'pfunc_expr_unexpected_number' => 'שגיאה בביטוי: מספר בלתי צפוי',
	'pfunc_expr_preg_match_failure' => 'שגיאה בביטוי: כישלון בלתי צפוי של התאמת ביטוי רגולרי',
	'pfunc_expr_unrecognised_word' => 'שגיאה בביטוי: מילה בלתי מזוהה, "$1"',
	'pfunc_expr_unexpected_operator' => 'שגיאה בביטוי: אופרנד $1 בלתי צפוי',
	'pfunc_expr_missing_operand' => 'שגיאה בביטוי: חסר אופרנד ל־$1',
	'pfunc_expr_unexpected_closing_bracket' => 'שגיאה בביטוי: סוגריים סוגרים בלתי צפויים',
	'pfunc_expr_unrecognised_punctuation' => 'שגיאה בביטוי: תו פיסוק בלתי מזוהה, "$1"',
	'pfunc_expr_unclosed_bracket' => 'שגיאה בביטוי: סוגריים בלתי סגורים',
	'pfunc_expr_division_by_zero' => 'חלוקה באפס',
	'pfunc_expr_invalid_argument' => 'ארגומנט בלתי תקין לפונקציה $1: < -1 או > 1',
	'pfunc_expr_invalid_argument_ln' => 'ארגומנט בלתי תקין לפונקציה ln: <= 0',
	'pfunc_expr_unknown_error' => 'שגיאה בביטוי: שגיאה בלתי ידועה ($1)',
	'pfunc_expr_not_a_number' => 'התוצאה של $1 אינה מספר',
	'pfunc_string_too_long' => 'שגיאה: המחרוזת עוברת את גבול התווים המותר, $1',
	'pfunc-convert-dimensionmismatch' => 'שגיאה: לא ניתן להמיר בין יחידות של "$1" ושל "$2".',
	'pfunc-convert-unknownunit' => 'שגיאה: יחידה לא ידועה "$1".',
	'pfunc-convert-unknowndimension' => 'שגיאה: ממד לא ידוע "$1".',
	'pfunc-convert-invalidcompoundunit' => 'שגיאה: יחידה מורכבת לא ידועה "$1".',
	'pfunc-convert-nounit' => 'שגיאה: לא ניתנה יחידה התחלתית.',
	'pfunc-convert-doublecompoundunit' => 'שגיאה: לא ניתן לפענח יחידות מורכבות כפולות כמו "$1".',
	'pfunc-convert-dimension-length' => 'אורך',
	'pfunc-convert-dimension-area' => 'שטח',
	'pfunc-convert-dimension-volume' => 'נפח',
	'pfunc-convert-dimension-time' => 'זמן',
	'pfunc-convert-dimension-timesquared' => 'זמן<sup>2</sup>',
	'pfunc-convert-dimension-mass' => 'מסה',
	'pfunc-convert-dimension-speed' => 'מהירות',
	'pfunc-convert-dimension-temperature' => 'חום',
	'pfunc-convert-dimension-acceleration' => 'תאוצה',
	'pfunc-convert-dimension-force' => 'כוח',
	'pfunc-convert-dimension-torque' => 'מומנט הסיבוב',
	'pfunc-convert-dimension-energy' => 'אנרגיה',
	'pfunc-convert-dimension-power' => 'הספק',
	'pfunc-convert-dimension-pressure' => 'לחץ',
	'pfunc-convert-dimension-density' => 'צפיפות',
	'pfunc-convert-prefix-yotta' => 'יוטא',
	'pfunc-convert-prefix-zetta' => 'זטא',
	'pfunc-convert-prefix-exa' => 'אקסה',
	'pfunc-convert-prefix-peta' => 'פטה',
	'pfunc-convert-prefix-tera' => 'טרה',
	'pfunc-convert-prefix-giga' => 'גיגה',
	'pfunc-convert-prefix-mega' => 'מגה',
	'pfunc-convert-prefix-kilo' => 'קילו',
	'pfunc-convert-prefix-hecto' => 'הקטו',
	'pfunc-convert-prefix-deca' => 'דקה',
	'pfunc-convert-prefix-deci' => 'דצי',
	'pfunc-convert-prefix-centi' => 'סנטי',
	'pfunc-convert-prefix-milli' => 'מילי',
	'pfunc-convert-prefix-micro' => 'מיקרו',
	'pfunc-convert-prefix-nano' => 'ננו',
	'pfunc-convert-prefix-pico' => 'פיקו',
	'pfunc-convert-prefix-femto' => 'פמטו',
	'pfunc-convert-prefix-atto' => 'אטו',
	'pfunc-convert-prefix-zepto' => 'זפטו',
	'pfunc-convert-prefix-yocto' => 'יוקטו',
	'pfunc-convert-unit-length-furlong-abbr' => '$1פרלונג',
	'pfunc-convert-unit-length-chain-abbr' => '$1שלשלת',
	'pfunc-convert-unit-length-rod-abbr' => '$1מַטֶּה',
	'pfunc-convert-unit-length-fathom-abbr' => '$1פאתום',
	'pfunc-convert-unit-length-yard-abbr' => '$1יארד',
	'pfunc-convert-unit-length-foot-abbr' => '$1רגל',
	'pfunc-convert-unit-length-hand-abbr' => '$1כף־יד',
	'pfunc-convert-unit-length-inch-abbr' => '$1אינץ׳',
	'pfunc-convert-unit-length-nauticalmile-abbr' => '$1מיל ימי',
	'pfunc-convert-unit-length-nauticalmileuk-abbr' => '$1מיל ימי (אנגלי)',
	'pfunc-convert-unit-length-nauticalmileus-abbr' => '$1מיל ימי (ארה״ב לפני 1954)',
	'pfunc-convert-unit-length-parsec-abbr' => '$1$3 פארסק',
	'pfunc-convert-unit-length-lightyear-abbr' => '$1$3 שנות אור',
	'pfunc-convert-unit-length-astronomicalunit-abbr' => '$1יחידה אסטרונומית',
	'pfunc-convert-unit-area-squarekilometre-abbr' => '$1קמ״ר',
	'pfunc-convert-unit-area-squaremetre-abbr' => '$1מ״ר',
	'pfunc-convert-unit-area-squarecentimetre-abbr' => '$1סמ״ר',
	'pfunc-convert-unit-area-squaremillimetre-abbr' => '$1ממ״ר',
	'pfunc-convert-unit-area-hectare-abbr' => '$1הקטאר',
	'pfunc-convert-unit-area-squaremile-abbr' => '$1מיל רבוע',
	'pfunc-convert-unit-area-acre-abbr' => '$1אקר',
	'pfunc-convert-unit-area-squareyard-abbr' => '$1יארד רבוע',
	'pfunc-convert-unit-area-squarefoot-abbr' => '$1רגל רבועה',
	'pfunc-convert-unit-area-squareinch-abbr' => '$1אינץ׳ רבוע',
	'pfunc-convert-unit-area-squarenauticalmile-abbr' => '$1מיל ימי רבוע',
	'pfunc-convert-unit-area-dunam-abbr' => '$1דונם',
	'pfunc-convert-unit-area-tsubo-abbr' => '$1צובו',
	'pfunc-convert-unit-time-second-abbr' => '$1שנייה',
	'pfunc-convert-unit-time-day-abbr' => '$1יום',
	'pfunc-convert-unit-time-hour-abbr' => '$1שעה',
	'pfunc-convert-unit-time-minute-abbr' => '$1דקה',
	'pfunc-convert-unit-volume-cubicmetre-abbr' => '$1מטר מעוקב',
	'pfunc-convert-unit-volume-cubiccentimetre-abbr' => '$1ס״מ מעוקב',
	'pfunc-convert-unit-volume-cubicmillimetre-abbr' => '$1מ״מ מעוקב',
	'pfunc-convert-unit-volume-litre-abbr' => '$1$3 ל׳',
	'pfunc-convert-unit-volume-cubicyard-abbr' => '$1יארד מעוקב',
	'pfunc-convert-unit-volume-cubicfoot-abbr' => '$1רגל מעוקבת',
	'pfunc-convert-unit-volume-cubicinch-abbr' => '$1אינץ׳ מעוקב',
	'pfunc-convert-unit-volume-barrel-abbr' => '$1חבית',
	'pfunc-convert-unit-volume-bushel-abbr' => '$1בושל',
	'pfunc-convert-unit-volume-gallon-abbr' => '$1גלון',
	'pfunc-convert-unit-volume-quart-abbr' => '$1קווארטה',
	'pfunc-convert-unit-volume-pint-abbr' => '$1פיינט',
	'pfunc-convert-unit-volume-fluidounce-abbr' => '$1אונקייה',
	'pfunc-convert-unit-volume-barrelus-abbr' => '$1חבית אמריקאית',
	'pfunc-convert-unit-volume-barreloil-abbr' => '$1חבית',
	'pfunc-convert-unit-volume-barrelbeer-abbr' => '$1חבית',
	'pfunc-convert-unit-volume-usgallon-abbr' => '$1גלון אמריקאי',
	'pfunc-convert-unit-volume-usquart-abbr' => '$1קווארטה אמריקאית',
	'pfunc-convert-unit-volume-uspint-abbr' => '$1פיינט אמריקאי',
	'pfunc-convert-unit-volume-usfluidounce-abbr' => '$1אונקייה אמריקאית',
	'pfunc-convert-unit-volume-usdrybarrel-abbr' => '$1חבית אמריקאית',
	'pfunc-convert-unit-volume-usbushel-abbr' => '$1בושל אמריקאי',
	'pfunc-convert-unit-volume-usdrygallon-abbr' => '$1גלון יבש אמריקאי',
	'pfunc-convert-unit-volume-usdryquart-abbr' => '$1קווארטה יבשה אמריקאית',
	'pfunc-convert-unit-volume-usdrypint-abbr' => '$1פיינט יבש אמריקאי',
	'pfunc-convert-unit-speed-mile-hour' => '$1מיל לשעה',
	'pfunc-convert-unit-speed-speedoflight' => '$1c',
	'pfunc-convert-unit-speed-mile-hour-abbr' => '$1מיל לשעה',
	'pfunc-convert-unit-speed-speedoflight-abbr' => '$1c',
	'pfunc-convert-unit-pressure-bar' => '$1בר',
	'pfunc-convert-unit-pressure-decibar' => '$1דציבר',
	'pfunc-convert-unit-pressure-millibar' => '$1מיליבר',
	'pfunc-convert-unit-pressure-kilobarye' => '$1קילובָּרְיֶה',
	'pfunc-convert-unit-pressure-barye' => '$1בָּרְיֶה',
	'pfunc-convert-unit-pressure-bar-abbr' => '$1בר',
	'pfunc-convert-unit-pressure-decibar-abbr' => '$1דציבר',
	'pfunc-convert-unit-pressure-millibar-abbr' => '$1מיליבר',
	'pfunc-convert-unit-pressure-kilobarye-abbr' => '$1קילובָּרְיֶה',
	'pfunc-convert-unit-pressure-barye-abbr' => '$1בָּרְיֶה',
	'pfunc-convert-unit-pressure-atmosphere-abbr' => '$1אטמ׳',
	'pfunc-convert-unit-pressure-torr-abbr' => '$1טור',
	'pfunc-convert-unit-pressure-mmhg-abbr' => '$1מ״מ כספית',
	'pfunc-convert-unit-pressure-inhg-abbr' => '$1אינץ׳ כספית',
	'pfunc-convert-unit-pressure-psi-abbr' => '$1psi',
);

/** Hindi (हिन्दी)
 * @author Kaustubh
 * @author Shyam
 */
$messages['hi'] = array(
	'pfunc_desc' => 'लॉजिकल कार्योंका इस्तेमाल करके पार्सर बढायें',
	'pfunc_time_error' => 'गलती: गलत समय',
	'pfunc_time_too_long' => 'गलती: बहुत सारे #time कॉल',
	'pfunc_rel2abs_invalid_depth' => 'गलती: पाथ में गलत गहराई: "$1" (रूट नोडके उपर वाले नोड खोजने की कोशीश की)',
	'pfunc_expr_stack_exhausted' => 'एक्स्प्रेशनमें गलती: स्टॅक खतम हो गया',
	'pfunc_expr_unexpected_number' => 'एक्स्प्रेशनमें गलती: अनपेक्षित संख्या',
	'pfunc_expr_preg_match_failure' => 'एक्स्प्रेशन गलती: अनपेक्षित preg_match रद्दीकरण',
	'pfunc_expr_unrecognised_word' => 'एक्स्प्रेशन गलती: अनिश्चित शब्द "$1"',
	'pfunc_expr_unexpected_operator' => 'एक्स्प्रेशन गलती: अनपेक्षित $1 ओपरेटर',
	'pfunc_expr_missing_operand' => 'एक्स्प्रेशन गलती: $1 का घटक मिला नहीं',
	'pfunc_expr_unexpected_closing_bracket' => 'एक्स्प्रेशन गलती: अनपेक्षित समाप्ति ब्रैकेट',
	'pfunc_expr_unrecognised_punctuation' => 'एक्स्प्रेशन गलती: अनपेक्षित उद्गार चिन्ह "$1"',
	'pfunc_expr_unclosed_bracket' => 'एक्स्प्रेशन गलती: ब्रैकेट बंद नहीं किया',
	'pfunc_expr_division_by_zero' => 'शून्य से भाग',
	'pfunc_expr_invalid_argument' => '$1: < -1 or > 1 के लिए अमान्य कथन',
	'pfunc_expr_invalid_argument_ln' => 'ln: <= 0 के लिए अमान्य कथन',
	'pfunc_expr_unknown_error' => 'एक्स्प्रेशन गलती: अज्ञात गलती ($1)',
	'pfunc_expr_not_a_number' => '$1 में: रिज़ल्ट संख्यामें नहीं हैं',
);

/** Croatian (Hrvatski)
 * @author Dalibor Bosits
 * @author Dnik
 * @author Ex13
 * @author SpeedyGonsales
 */
$messages['hr'] = array(
	'pfunc_desc' => 'Mogućnost proširivanja parsera logičkim funkcijama',
	'pfunc_time_error' => 'Greška: oblik vremena nije valjan',
	'pfunc_time_too_long' => 'Greška: prevelik broj #time (vremenskih) poziva',
	'pfunc_rel2abs_invalid_depth' => 'Greška: Nevaljana dubina putanje: "$1" (pokušaj pristupanja čvoru iznad korijenskog)',
	'pfunc_expr_stack_exhausted' => 'Greška u predlošku: prepunjen stog',
	'pfunc_expr_unexpected_number' => 'Greška u predlošku: Neočekivan broj',
	'pfunc_expr_preg_match_failure' => 'Greška u predlošku: Neočekivana preg_match greška',
	'pfunc_expr_unrecognised_word' => 'Greška u predlošku: Nepoznata riječ "$1"',
	'pfunc_expr_unexpected_operator' => 'Greška u predlošku: Neočekivani operator $1',
	'pfunc_expr_missing_operand' => 'Greška u predlošku: Operator $1 nedostaje',
	'pfunc_expr_unexpected_closing_bracket' => 'Greška u predlošku: Neočekivana zatvorena zagrada',
	'pfunc_expr_unrecognised_punctuation' => 'Greška u predlošku: Nepoznat interpunkcijski znak "$1"',
	'pfunc_expr_unclosed_bracket' => 'Greška u predlošku: Nezatvorene zagrade',
	'pfunc_expr_division_by_zero' => 'Dijeljenje s nulom',
	'pfunc_expr_invalid_argument' => 'Nevaljani argumenti za $1: < -1 ili > 1',
	'pfunc_expr_invalid_argument_ln' => 'Nevaljani argument za ln: <= 0',
	'pfunc_expr_unknown_error' => 'Greška u predlošku: Nepoznata greška ($1)',
	'pfunc_expr_not_a_number' => 'U $1: rezultat nije broj',
	'pfunc_string_too_long' => 'Greška: Niz prelazi ograničenje od $1 znakova',
);

/** Upper Sorbian (Hornjoserbsce)
 * @author Michawiki
 */
$messages['hsb'] = array(
	'pfunc_desc' => 'Parser wo logiske funkcije rozšěrić',
	'pfunc_time_error' => 'Zmylk: njepłaćiwe časowe podaće',
	'pfunc_time_too_long' => 'Zmylk: přewjele zawołanjow #time',
	'pfunc_rel2abs_invalid_depth' => 'Zmylk: Njepłaćiwa hłubokosć w pućiku: "$1" (Pospyt, zo by na suk wyše hłowneho suka dohrabnyło)',
	'pfunc_expr_stack_exhausted' => 'Wurazowy zmylk: Staplowy skład wučerpany',
	'pfunc_expr_unexpected_number' => 'Wurazowy zmylk: Njewočakowana ličba',
	'pfunc_expr_preg_match_failure' => 'Wurazowy zmylk: Njewočakowana zmylna funkcija "preg_match"',
	'pfunc_expr_unrecognised_word' => 'Wurazowy zmylk: Njespóznate słowo "$1"',
	'pfunc_expr_unexpected_operator' => 'Wurazowy zmylk: Njewočakowany operator $1',
	'pfunc_expr_missing_operand' => 'Wurazowy zmylk: Falowacy operand za $1',
	'pfunc_expr_unexpected_closing_bracket' => 'Wurazowy zmylk: Njewočakowana kónčna róžkata spinka',
	'pfunc_expr_unrecognised_punctuation' => 'Wurazowy zmylk: Njespóznate interpunkciske znamješko "$1"',
	'pfunc_expr_unclosed_bracket' => 'Wurazowy zmylk: Njewotzamknjena róžkata spinka',
	'pfunc_expr_division_by_zero' => 'Diwizija přez nulu',
	'pfunc_expr_invalid_argument' => 'Njepłaćiwy argument za $1: < -1 abo > 1',
	'pfunc_expr_invalid_argument_ln' => 'Njepłaćiwy argument za ln: <= 0',
	'pfunc_expr_unknown_error' => 'Wurazowy zmylk: Njeznaty zmylk ($1)',
	'pfunc_expr_not_a_number' => 'W $1: Wuslědk ličba njeje',
	'pfunc_string_too_long' => 'Zmylk: Znamješkowy slěd překročuje limit $1 znamješkow',
	'pfunc-convert-dimensionmismatch' => 'Zmylk: Konwertowanje mjez "$1" a "$2" njemóžno',
	'pfunc-convert-unknownunit' => 'Zmylk: Njeznata jednotka "$1"',
	'pfunc-convert-unknowndimension' => 'Zmylk: Njeznata dimensija "$1"',
	'pfunc-convert-nounit' => 'Zmylk: žórłowa jednotka faluje',
	'pfunc-convert-dimension-length' => 'Dołhosć',
	'pfunc-convert-dimension-area' => 'přestrjeń',
	'pfunc-convert-dimension-volume' => 'wolumen',
	'pfunc-convert-dimension-time' => 'čas',
	'pfunc-convert-dimension-timesquared' => 'čas <sup>2</sup>',
	'pfunc-convert-dimension-mass' => 'Masa',
	'pfunc-convert-dimension-speed' => 'spěšnosć',
	'pfunc-convert-dimension-temperature' => 'temperatura',
	'pfunc-convert-dimension-acceleration' => 'pospěšenje',
	'pfunc-convert-dimension-force' => 'móc',
	'pfunc-convert-dimension-torque' => 'wjertny moment',
	'pfunc-convert-dimension-energy' => 'energija',
	'pfunc-convert-dimension-power' => 'wukon',
	'pfunc-convert-dimension-pressure' => 'ćišć',
	'pfunc-convert-dimension-density' => 'hustota',
	'pfunc-convert-dimension-fuelefficiencypositive' => 'Pozitiwna ćěriwowa eficienca',
	'pfunc-convert-dimension-fuelefficiencynegative' => 'Negatiwna ćěriwowa eficienca',
	'pfunc-convert-unit-length-metre' => '$1{{PLURAL:$2|meter|metraj|metry|metrow}}',
	'pfunc-convert-unit-length-astronomicalunit' => '$1{{PLURAL:$2|astronomiska jednotka|astronomiskej jednotce|astronomiske jednotki|astronomiskich jednotkow}}',
	'pfunc-convert-unit-length-metre-abbr' => '$1m',
	'pfunc-convert-unit-length-angstrom-abbr' => '$1Å',
	'pfunc-convert-unit-area-squarekilometre-abbr' => '$1km<sup>2</sup>',
	'pfunc-convert-unit-area-squaremetre-abbr' => '$1m<sup>2</sup>',
	'pfunc-convert-unit-area-squarecentimetre-abbr' => '$1cm<sup>2</sup>',
	'pfunc-convert-unit-area-squaremillimetre-abbr' => '$1mm<sup>2</sup>',
	'pfunc-convert-unit-area-hectare-abbr' => '$1ha',
	'pfunc-convert-unit-area-squarenauticalmile-abbr' => '$1sm<sup>2</sup>',
	'pfunc-convert-unit-time-second' => '$1{{PLURAL:$2|sekunda|sekundźe|sekundy|sekundow}}',
	'pfunc-convert-unit-time-year' => '$1{{PLURAL:$2|lěto|lěće|lěta|lět}}',
	'pfunc-convert-unit-time-day' => '$1{{PLURAL:$2|dźeń|dnjej|dny|dnjow}}',
	'pfunc-convert-unit-time-hour' => '$1{{PLURAL:$2|hodźina|hodźinje|hodźiny|hodźin}}',
	'pfunc-convert-unit-time-minute' => '$1{{PLURAL:$2|mjeńšina|mjeńšinje|mjeńšiny|mjeńšin}}',
	'pfunc-convert-unit-time-second-abbr' => '$1s',
	'pfunc-convert-unit-time-year-abbr' => '$1lěto',
	'pfunc-convert-unit-time-day-abbr' => '$1dźeń',
	'pfunc-convert-unit-time-hour-abbr' => '$1hodź.',
	'pfunc-convert-unit-time-minute-abbr' => '$1min',
	'pfunc-convert-unit-volume-cubicmetre-abbr' => '$1m<sup>3</sup>',
	'pfunc-convert-unit-volume-cubiccentimetre-abbr' => '$1cm<sup>3</sup>',
	'pfunc-convert-unit-volume-cubicmillimetre-abbr' => '$1mm<sup>3</sup>',
	'pfunc-convert-unit-volume-litre-abbr' => '$1l',
);

/** Hungarian (Magyar)
 * @author Dani
 */
$messages['hu'] = array(
	'pfunc_desc' => 'Az értelmező kiegészítése logikai funkciókkal',
	'pfunc_time_error' => 'Hiba: érvénytelen idő',
	'pfunc_time_too_long' => 'Hiba: a #time túl sokszor lett meghívva',
	'pfunc_time_too_big' => 'Hiba: a #time csak 9999-ig támogatja az éveket',
	'pfunc_rel2abs_invalid_depth' => 'Hiba: nem megfelelő a mélység az elérési útban: „$1” (egy olyan csomópontot akartál elérni, amely a gyökércsomópont felett van)',
	'pfunc_expr_stack_exhausted' => 'Hiba a kifejezésben: a verem kiürült',
	'pfunc_expr_unexpected_number' => 'Hiba a kifejezésben: nem várt szám',
	'pfunc_expr_preg_match_failure' => 'Hiba a kifejezésben: a preg_match váratlanul hibát jelzett',
	'pfunc_expr_unrecognised_word' => 'Hiba a kifejezésben: ismeretlen „$1” szó',
	'pfunc_expr_unexpected_operator' => 'Hiba a kifejezésben: nem várt $1 operátor',
	'pfunc_expr_missing_operand' => 'Hiba a kifejezésben: $1 egyik operandusa hiányzik',
	'pfunc_expr_unexpected_closing_bracket' => 'Hiba a kifejezésben: nem várt zárójel',
	'pfunc_expr_unrecognised_punctuation' => 'Hiba a kifejezésben: ismeretlen „$1” központozó karakter',
	'pfunc_expr_unclosed_bracket' => 'Hiba a kifejezésben: lezáratlan zárójel',
	'pfunc_expr_division_by_zero' => 'Nullával való osztás',
	'pfunc_expr_invalid_argument' => '$1 érvénytelen paramétert kapott: < -1 vagy > 1',
	'pfunc_expr_invalid_argument_ln' => 'Az ln érvénytelen paramétert kapott: <= 0',
	'pfunc_expr_unknown_error' => 'Hiba a kifejezésben: ismeretlen hiba ($1)',
	'pfunc_expr_not_a_number' => '$1: az eredmény nem szám',
	'pfunc_string_too_long' => 'Hiba: a sztring túllépte a(z) $1 karakteres határt',
	'pfunc-convert-dimensionmismatch' => 'Hiba: „$1” és „$2” mértékegységek között nem lehet átváltani.',
	'pfunc-convert-unknownunit' => 'Hiba: ismeretlen mértékegység: „$1”',
	'pfunc-convert-nounit' => 'Hiba: nincs megadva a forrásmértékegység.',
	'pfunc-convert-dimension-length' => 'hossz',
	'pfunc-convert-dimension-area' => 'terület',
	'pfunc-convert-dimension-volume' => 'térfogat',
	'pfunc-convert-dimension-time' => 'idő',
	'pfunc-convert-dimension-timesquared' => 'idő<sup>2</sup>',
	'pfunc-convert-dimension-mass' => 'tömeg',
	'pfunc-convert-dimension-speed' => 'sebesség',
	'pfunc-convert-dimension-temperature' => 'hőmérséklet',
	'pfunc-convert-dimension-acceleration' => 'gyorsulás',
	'pfunc-convert-dimension-force' => 'erő',
	'pfunc-convert-dimension-torque' => 'nyomaték',
	'pfunc-convert-dimension-energy' => 'energia',
	'pfunc-convert-dimension-pressure' => 'nyomás',
	'pfunc-convert-dimension-density' => 'sűrűség',
	'pfunc-convert-prefix-yotta' => 'yotta',
	'pfunc-convert-prefix-zetta' => 'zetta',
	'pfunc-convert-prefix-exa' => 'exa',
	'pfunc-convert-prefix-peta' => 'peta',
	'pfunc-convert-prefix-tera' => 'tera',
	'pfunc-convert-prefix-giga' => 'giga',
	'pfunc-convert-prefix-mega' => 'mega',
	'pfunc-convert-prefix-kilo' => 'kilo',
	'pfunc-convert-prefix-hecto' => 'hekto',
	'pfunc-convert-prefix-deca' => 'deka',
	'pfunc-convert-prefix-deci' => 'deci',
	'pfunc-convert-prefix-centi' => 'centi',
	'pfunc-convert-prefix-milli' => 'milli',
	'pfunc-convert-prefix-micro' => 'mikro',
	'pfunc-convert-prefix-nano' => 'nano',
	'pfunc-convert-prefix-pico' => 'piko',
	'pfunc-convert-prefix-femto' => 'femto',
	'pfunc-convert-prefix-atto' => 'atto',
	'pfunc-convert-prefix-zepto' => 'zepto',
	'pfunc-convert-prefix-yocto' => 'yokto',
	'pfunc-convert-unit-length-metre' => '$1$3méter',
	'pfunc-convert-unit-length-mile' => '$1mérföld',
	'pfunc-convert-unit-length-foot' => '$1láb',
	'pfunc-convert-unit-length-nauticalmile' => '$1tengeri mérföld',
	'pfunc-convert-unit-length-lightyear' => '$1$3fényév',
	'pfunc-convert-unit-length-astronomicalunit' => '$1csillagászati egység',
	'pfunc-convert-unit-area-hectare' => '$1hektár',
);

/** Interlingua (Interlingua)
 * @author McDutchie
 */
$messages['ia'] = array(
	'pfunc_desc' => 'Meliorar le analysator syntactic con functiones logic',
	'pfunc_time_error' => 'Error: tempore invalide',
	'pfunc_time_too_long' => 'Error: troppo de appellos a #time',
	'pfunc_time_too_big' => 'Error: #time supporta solmente annos usque a 9999',
	'pfunc_rel2abs_invalid_depth' => 'Error: Profunditate invalide in cammino: "$1" (essayava acceder a un nodo superior al radice)',
	'pfunc_expr_stack_exhausted' => 'Error in expression: Pila exhaurite',
	'pfunc_expr_unexpected_number' => 'Error in expression: Numero non expectate',
	'pfunc_expr_preg_match_failure' => 'Error in expression: Fallimento non expectate in preg_match',
	'pfunc_expr_unrecognised_word' => 'Error in expression: Parola "$1" non recognoscite',
	'pfunc_expr_unexpected_operator' => 'Error in expression: Operator $1 non expectate',
	'pfunc_expr_missing_operand' => 'Error in expression: Manca un operando pro $1',
	'pfunc_expr_unexpected_closing_bracket' => 'Error in expression: Accollada clause non expectate',
	'pfunc_expr_unrecognised_punctuation' => 'Error in expression: Character de punctuation "$1" non recognoscite',
	'pfunc_expr_unclosed_bracket' => 'Error in expression: Accollada non claudite',
	'pfunc_expr_division_by_zero' => 'Division per zero',
	'pfunc_expr_invalid_argument' => 'Argumento invalide pro $1: < -1 o > 1',
	'pfunc_expr_invalid_argument_ln' => 'Argumento invalide pro ln: ≤ 0',
	'pfunc_expr_unknown_error' => 'Error de expression: Error incognite ($1)',
	'pfunc_expr_not_a_number' => 'In $1: le resultato non es un numero',
	'pfunc_string_too_long' => 'Error: Le catena excede le limite de $1 {{PLURAL:$1|character|characteres}}',
	'pfunc-convert-dimensionmismatch' => 'Error: Impossibile converter inter unitates de "$1" e "$2".',
	'pfunc-convert-unknownunit' => 'Error: Unitate "$1" incognite.',
	'pfunc-convert-unknowndimension' => 'Error: Dimension "$1" incognite.',
	'pfunc-convert-invalidcompoundunit' => 'Error: Unitate composite "$1" invalide.',
	'pfunc-convert-nounit' => 'Error: Nulle unitate de origine specificate.',
	'pfunc-convert-doublecompoundunit' => 'Error: Non pote processar unitates composite duplice como "$1".',
	'pfunc-convert-dimension-length' => 'longitude',
	'pfunc-convert-dimension-area' => 'area',
	'pfunc-convert-dimension-volume' => 'volumine',
	'pfunc-convert-dimension-time' => 'tempore',
	'pfunc-convert-dimension-timesquared' => 'tempore<sup>2</sup>',
	'pfunc-convert-dimension-mass' => 'massa',
	'pfunc-convert-dimension-speed' => 'velocitate',
	'pfunc-convert-dimension-temperature' => 'temperatura',
	'pfunc-convert-dimension-acceleration' => 'acceleration',
	'pfunc-convert-dimension-force' => 'fortia',
	'pfunc-convert-dimension-torque' => 'torsion',
	'pfunc-convert-dimension-energy' => 'energia',
	'pfunc-convert-dimension-power' => 'potentia',
	'pfunc-convert-dimension-pressure' => 'pression',
	'pfunc-convert-dimension-density' => 'densitate',
	'pfunc-convert-dimension-fuelefficiencypositive' => 'efficientiaenergeticpositive',
	'pfunc-convert-dimension-fuelefficiencynegative' => 'efficientiaenergeticnegative',
	'pfunc-convert-prefix-yotta' => 'yotta',
	'pfunc-convert-prefix-zetta' => 'zetta',
	'pfunc-convert-prefix-exa' => 'exa',
	'pfunc-convert-prefix-peta' => 'peta',
	'pfunc-convert-prefix-tera' => 'tera',
	'pfunc-convert-prefix-giga' => 'giga',
	'pfunc-convert-prefix-mega' => 'mega',
	'pfunc-convert-prefix-kilo' => 'kilo',
	'pfunc-convert-prefix-hecto' => 'hecto',
	'pfunc-convert-prefix-deca' => 'deca',
	'pfunc-convert-prefix-deci' => 'deci',
	'pfunc-convert-prefix-centi' => 'centi',
	'pfunc-convert-prefix-milli' => 'milli',
	'pfunc-convert-prefix-micro' => 'micro',
	'pfunc-convert-prefix-nano' => 'nano',
	'pfunc-convert-prefix-pico' => 'pico',
	'pfunc-convert-prefix-femto' => 'femto',
	'pfunc-convert-prefix-atto' => 'atto',
	'pfunc-convert-prefix-zepto' => 'zepto',
	'pfunc-convert-prefix-yocto' => 'yocto',
	'pfunc-convert-unit-length-metre' => '$1{{PLURAL:$2|$3metro|$3metros}}',
	'pfunc-convert-unit-length-angstrom' => '$1{{PLURAL:$2|ångström|ångströmes}}',
	'pfunc-convert-unit-length-mile' => '$1{{PLURAL:$2|millia|millias}}',
	'pfunc-convert-unit-length-furlong' => '$1{{PLURAL:$2|furlong|furlongs}}',
	'pfunc-convert-unit-length-chain' => '$1{{PLURAL:$2|catena|catenas}}',
	'pfunc-convert-unit-length-rod' => '$1{{PLURAL:$2|pertica|perticas}}',
);

/** Indonesian (Bahasa Indonesia)
 * @author IvanLanin
 * @author Meursault2004
 * @author Rex
 */
$messages['id'] = array(
	'pfunc_desc' => 'Mengembangkan parser dengan fungsi logis',
	'pfunc_time_error' => 'Kesalahan: waktu tidak valid',
	'pfunc_time_too_long' => 'Kesalahan: Pemanggilan #time terlalu banyak',
	'pfunc_time_too_big' => 'Galat: #time hanya mendukung tahun hingga 9999',
	'pfunc_rel2abs_invalid_depth' => 'Kesalahan: Kedalaman path tidak valid: "$1" (mencoba mengakses simpul di atas simpul akar)',
	'pfunc_expr_stack_exhausted' => 'Kesalahan ekspresi: Stack habis',
	'pfunc_expr_unexpected_number' => 'Kesalahan ekspresi: Angka yang tak terduga',
	'pfunc_expr_preg_match_failure' => 'Kesalahan ekspresi: Kegagalan preg_match tak terduga',
	'pfunc_expr_unrecognised_word' => 'Kesalahan ekspresi: Kata "$1" tak dikenal',
	'pfunc_expr_unexpected_operator' => 'Kesalahan ekspresi: Operator $1 tak terduga',
	'pfunc_expr_missing_operand' => 'Kesalahan ekspresi: Operand tak ditemukan untuk $1',
	'pfunc_expr_unexpected_closing_bracket' => 'Kesalahan ekspresi: Kurung tutup tak terduga',
	'pfunc_expr_unrecognised_punctuation' => 'Kesalahan ekspresi: Karakter tanda baca "$1" tak dikenali',
	'pfunc_expr_unclosed_bracket' => 'Kesalahan ekspresi: Kurung tanpa tutup',
	'pfunc_expr_division_by_zero' => 'Pembagian oleh nol',
	'pfunc_expr_invalid_argument' => 'Argumen tidak berlaku untuk $1: < -1 or > 1',
	'pfunc_expr_invalid_argument_ln' => 'Argumen tidak berlaku untuk ln: <= 0',
	'pfunc_expr_unknown_error' => 'Kesalahan ekspresi: Kesalahan tak dikenal ($1)',
	'pfunc_expr_not_a_number' => 'Pada $1: hasilnya bukan angka',
	'pfunc_string_too_long' => 'Kesalahan: String melebihi limit $1 karakter',
);

/** Ido (Ido)
 * @author Malafaya
 */
$messages['io'] = array(
	'pfunc_time_error' => 'Eroro: ne-valida tempo',
	'pfunc_expr_division_by_zero' => 'Divido per zero',
);

/** Italian (Italiano)
 * @author Beta16
 * @author BrokenArrow
 * @author Darth Kule
 * @author Pietrodn
 */
$messages['it'] = array(
	'pfunc_desc' => 'Aggiunge al parser una serie di funzioni logiche',
	'pfunc_time_error' => 'Errore: orario non valido',
	'pfunc_time_too_long' => 'Errore: troppe chiamate a #time',
	'pfunc_time_too_big' => "Errore: #time supporta solo fino all'anno 9999",
	'pfunc_rel2abs_invalid_depth' => 'Errore: profondità non valida nel percorso "$1" (si è tentato di accedere a un nodo superiore alla radice)',
	'pfunc_expr_stack_exhausted' => "Errore nell'espressione: stack esaurito",
	'pfunc_expr_unexpected_number' => "Errore nell'espressione: numero inatteso",
	'pfunc_expr_preg_match_failure' => "Errore nell'espressione: errore inatteso in preg_match",
	'pfunc_expr_unrecognised_word' => 'Errore nell\'espressione: parola "$1" non riconosciuta',
	'pfunc_expr_unexpected_operator' => "Errore nell'espressione: operatore $1 inatteso",
	'pfunc_expr_missing_operand' => "Errore nell'espressione: operando mancante per $1",
	'pfunc_expr_unexpected_closing_bracket' => "Errore nell'espressione: parentesi chiusa inattesa",
	'pfunc_expr_unrecognised_punctuation' => 'Errore nell\'espressione: carattere di punteggiatura "$1" non riconosciuto',
	'pfunc_expr_unclosed_bracket' => "Errore nell'espressione: parentesi non chiusa",
	'pfunc_expr_division_by_zero' => 'Divisione per zero',
	'pfunc_expr_invalid_argument' => 'Argomento non valido per $1: < -1 o > 1',
	'pfunc_expr_invalid_argument_ln' => 'Argomento non valido per ln: <= 0',
	'pfunc_expr_unknown_error' => "Errore nell'espressione: errore sconosciuto ($1)",
	'pfunc_expr_not_a_number' => 'In $1: il risultato non è un numero',
	'pfunc_string_too_long' => 'Errore: la stringa supera il limite di $1 {{PLURAL:$1|carattere|caratteri}}',
	'pfunc-convert-unknownunit' => 'Errore: Unità sconosciuta "$1".',
	'pfunc-convert-unknowndimension' => 'Errore: Dimensione sconosciuta "$1".',
	'pfunc-convert-dimension-length' => 'lunghezza',
	'pfunc-convert-dimension-area' => 'area',
	'pfunc-convert-dimension-volume' => 'volume',
	'pfunc-convert-dimension-time' => 'tempo',
	'pfunc-convert-dimension-timesquared' => 'tempo<sup>2</sup>',
	'pfunc-convert-dimension-mass' => 'massa',
	'pfunc-convert-dimension-speed' => 'velocità',
	'pfunc-convert-dimension-temperature' => 'temperatura',
	'pfunc-convert-dimension-acceleration' => 'accelerazione',
	'pfunc-convert-dimension-force' => 'forza',
	'pfunc-convert-dimension-torque' => 'coppia',
	'pfunc-convert-dimension-energy' => 'energia',
	'pfunc-convert-dimension-power' => 'potenza',
	'pfunc-convert-dimension-pressure' => 'pressione',
	'pfunc-convert-dimension-density' => 'densità',
	'pfunc-convert-prefix-yotta' => 'yotta',
	'pfunc-convert-prefix-zetta' => 'zetta',
	'pfunc-convert-prefix-exa' => 'exa',
	'pfunc-convert-prefix-peta' => 'peta',
	'pfunc-convert-prefix-tera' => 'tera',
	'pfunc-convert-prefix-giga' => 'giga',
	'pfunc-convert-prefix-mega' => 'mega',
	'pfunc-convert-prefix-hecto' => 'etto',
	'pfunc-convert-prefix-deca' => 'deca',
	'pfunc-convert-prefix-deci' => 'deci',
	'pfunc-convert-prefix-centi' => 'centi',
	'pfunc-convert-prefix-milli' => 'milli',
	'pfunc-convert-prefix-micro' => 'micro',
	'pfunc-convert-prefix-nano' => 'nano',
	'pfunc-convert-prefix-pico' => 'pico',
	'pfunc-convert-prefix-femto' => 'femto',
	'pfunc-convert-prefix-atto' => 'atto',
	'pfunc-convert-prefix-zepto' => 'zepto',
	'pfunc-convert-prefix-yocto' => 'yocto',
	'pfunc-convert-prefix-milli-abbr' => 'm',
	'pfunc-convert-unit-length-metre' => '$1{{PLURAL:$2|$3metro|$3metri}}',
	'pfunc-convert-unit-length-foot' => '$1{{PLURAL:$2|piede|piedi}}',
	'pfunc-convert-unit-length-inch' => '$1{{PLURAL:$2|pollice|pollici}}',
	'pfunc-convert-unit-length-lightyear' => '$1{{PLURAL:$2|$3anno luce|$3anni luce}}',
	'pfunc-convert-unit-area-squarekilometre-abbr' => '$1km<sup>2</sup>',
	'pfunc-convert-unit-area-squaremetre-abbr' => '$1m<sup>2</sup>',
	'pfunc-convert-unit-area-squarecentimetre-abbr' => '$1cm<sup>2</sup>',
	'pfunc-convert-unit-area-squaremillimetre-abbr' => '$1mm<sup>2</sup>',
	'pfunc-convert-unit-time-second' => '$1{{PLURAL:$2|secondo|secondi}}',
	'pfunc-convert-unit-time-year' => '$1{{PLURAL:$2|$3anno|$3anni}}',
	'pfunc-convert-unit-time-day' => '$1{{PLURAL:$2|giorno|giorni}}',
	'pfunc-convert-unit-time-hour' => '$1{{PLURAL:$2|ora|ore}}',
	'pfunc-convert-unit-time-minute' => '$1{{PLURAL:$2|minuto|minuti}}',
	'pfunc-convert-unit-time-second-abbr' => '$1s',
	'pfunc-convert-unit-time-minute-abbr' => '$1min',
	'pfunc-convert-unit-volume-cubicmetre' => '$1{{PLURAL:$2|metro cubo|metri cubi}}',
	'pfunc-convert-unit-volume-litre' => '$1{{PLURAL:$2|litro|litri}}',
	'pfunc-convert-unit-volume-cubicmetre-abbr' => '$1m<sup>3</sup>',
	'pfunc-convert-unit-volume-cubiccentimetre-abbr' => '$1cm<sup>3</sup>',
	'pfunc-convert-unit-volume-cubicmillimetre-abbr' => '$1mm<sup>3</sup>',
	'pfunc-convert-unit-speed-speedoflight' => '$1c',
	'pfunc-convert-unit-speed-speedoflight-abbr' => '$1c',
	'pfunc-convert-unit-pressure-bar' => '$1bar',
	'pfunc-convert-unit-pressure-millibar' => '$1millibar',
	'pfunc-convert-unit-pressure-mmhg' => '$1{{PLURAL:$2|millimetro di mercurio|millimetri di mercurio}}',
	'pfunc-convert-unit-pressure-bar-abbr' => '$1bar',
	'pfunc-convert-unit-pressure-millibar-abbr' => '$1mbar',
	'pfunc-convert-unit-pressure-atmosphere-abbr' => '$1atm',
	'pfunc-convert-unit-pressure-torr-abbr' => '$1Torr',
	'pfunc-convert-unit-pressure-mmhg-abbr' => '$1mmHg',
);

/** Japanese (日本語)
 * @author Aotake
 * @author Fryed-peach
 * @author JtFuruhata
 * @author Ohgi
 * @author 青子守歌
 */
$messages['ja'] = array(
	'pfunc_desc' => 'パーサーに論理関数を追加して拡張する',
	'pfunc_time_error' => 'エラー: 時刻が不正です',
	'pfunc_time_too_long' => 'エラー: #time 呼び出しが多すぎます',
	'pfunc_time_too_big' => 'エラー: #timeは最大で9999年までです。',
	'pfunc_rel2abs_invalid_depth' => 'エラー: パス "$1" の階層が不正です(ルート階層からのアクセスをお試しください)',
	'pfunc_expr_stack_exhausted' => '構文エラー: スタックが空です',
	'pfunc_expr_unexpected_number' => '構文エラー: 予期せぬ数字です',
	'pfunc_expr_preg_match_failure' => '構文エラー: 予期せぬ形で preg_match に失敗しました',
	'pfunc_expr_unrecognised_word' => '構文エラー: "$1" は認識できません',
	'pfunc_expr_unexpected_operator' => '構文エラー: 予期せぬ演算子 $1 があります',
	'pfunc_expr_missing_operand' => '構文エラー: $1 の演算対象がありません',
	'pfunc_expr_unexpected_closing_bracket' => '構文エラー: 予期せぬ閉じ括弧です',
	'pfunc_expr_unrecognised_punctuation' => '構文エラー: 認識できない区切り文字 "$1" があります',
	'pfunc_expr_unclosed_bracket' => '構文エラー: 括弧が閉じられていません',
	'pfunc_expr_division_by_zero' => '0で除算しました',
	'pfunc_expr_invalid_argument' => '$1の引数が無効です: < -1 または > 1',
	'pfunc_expr_invalid_argument_ln' => 'ln の引数が無効です: <= 0',
	'pfunc_expr_unknown_error' => '構文エラー: 予期せぬエラー($1)',
	'pfunc_expr_not_a_number' => '$1: 結果が数字ではありません',
	'pfunc_string_too_long' => 'エラー: 文字列が文字数制限 $1 を超えました',
);

/** Javanese (Basa Jawa)
 * @author Meursault2004
 */
$messages['jv'] = array(
	'pfunc_desc' => 'Kembangna parser mawa fungsi logis',
	'pfunc_time_error' => 'Kaluputan: wektu ora absah',
	'pfunc_time_too_long' => 'Kaluputan: Olèhé nyeluk #time kakèhan',
	'pfunc_rel2abs_invalid_depth' => 'Kaluputan: Kajeroané path ora absah: "$1" (nyoba ngakses simpul sadhuwuring simpul oyot)',
	'pfunc_expr_stack_exhausted' => 'Kaluputan èksprèsi: Stack entèk',
	'pfunc_expr_unexpected_number' => 'Kaluputan èksprèsi: Angka ora kaduga',
	'pfunc_expr_preg_match_failure' => 'Kaluputan èksprèsi: Kaluputan preg_match sing ora kaduga',
	'pfunc_expr_unrecognised_word' => 'Kaluputan èksprèsi: Tembung "$1" ora ditepungi',
	'pfunc_expr_unexpected_operator' => 'Kaluputan èksprèsi: Operator $1 ora kaduga',
	'pfunc_expr_missing_operand' => 'Kaluputan èksprèsi: Operand ora ditemokaké kanggo $1',
	'pfunc_expr_unexpected_closing_bracket' => 'Kaluputan èksprèsi: Kurung tutup ora kaduga',
	'pfunc_expr_unrecognised_punctuation' => 'Kaluputan èksprèsi: Karakter tandha wacan "$1" ora ditepungi',
	'pfunc_expr_unclosed_bracket' => 'Kaluputan èksprèsi: Kurung tanpa tutup',
	'pfunc_expr_division_by_zero' => 'Dipara karo das (nol)',
	'pfunc_expr_invalid_argument' => 'Argumèn ora absah kanggo $1: < -1 utawa > 1',
	'pfunc_expr_invalid_argument_ln' => 'Argumèn ora absah kanggo ln: <= 0',
	'pfunc_expr_unknown_error' => 'Kaluputan èksprèsi: Kaluputan ora ditepungi ($1)',
	'pfunc_expr_not_a_number' => 'Ing $1: pituwasé dudu angka',
);

/** Georgian (ქართული)
 * @author BRUTE
 * @author Dawid Deutschland
 */
$messages['ka'] = array(
	'pfunc_time_error' => 'შეცდომა: არასწორი დრო',
	'pfunc_expr_division_by_zero' => 'გაყოფა ნულით',
	'pfunc_expr_invalid_argument' => 'მცდარი არგუმენტი $1: < -1 ან > 1',
	'pfunc_expr_invalid_argument_ln' => 'მცდარი არგუმენტი ln: <= 0',
	'pfunc_expr_not_a_number' => '$1: შედექში ციფრი არაა',
	'pfunc_string_too_long' => 'შეცდომა: სტრიქონის ზომა აღემატება $1 სიმბოლოს ლიმიტს',
);

/** Kazakh (Arabic script) (‫قازاقشا (تٴوتە)‬) */
$messages['kk-arab'] = array(
	'pfunc_time_error' => 'قاتە: جارامسىز ۋاقىت',
	'pfunc_time_too_long' => 'قاتە: #time شاقىرۋى تىم كوپ',
	'pfunc_rel2abs_invalid_depth' => 'قاتە: مىنا جولدىڭ جارامسىز تەرەندىگى «$1» (تامىر ٴتۇيىننىڭ ۇستىندەگى تۇيىنگە قاتىناۋ تالابى)',
	'pfunc_expr_stack_exhausted' => 'ايتىلىم قاتەسى: ستەك سارقىلدى',
	'pfunc_expr_unexpected_number' => 'ايتىلىم قاتەسى: كۇتىلمەگەن سان',
	'pfunc_expr_preg_match_failure' => 'ايتىلىم قاتەسى: كۇتىلمەگەن preg_match ساتسىزدىگى',
	'pfunc_expr_unrecognised_word' => 'ايتىلىم قاتەسى: تانىلماعان ٴسوز «$1»',
	'pfunc_expr_unexpected_operator' => 'ايتىلىم قاتەسى: كۇتىلمەگەن وپەراتور $1',
	'pfunc_expr_missing_operand' => 'ايتىلىم قاتەسى: $1 ٴۇشىن جوعالعان وپەراند',
	'pfunc_expr_unexpected_closing_bracket' => 'ايتىلىم قاتەسى: كۇتىلمەگەن جاباتىن جاقشا',
	'pfunc_expr_unrecognised_punctuation' => 'ايتىلىم قاتەسى: تانىلماعان تىنىس بەلگىسى «$1»',
	'pfunc_expr_unclosed_bracket' => 'ايتىلىم قاتەسى: جابىلماعان جاقشا',
	'pfunc_expr_division_by_zero' => 'نولگە ٴبولىنۋى',
	'pfunc_expr_unknown_error' => 'ايتىلىم قاتەسى: بەلگىسىز قاتە ($1)',
	'pfunc_expr_not_a_number' => '$1 دەگەندە: ناتىيجە سان ەمەس',
);

/** Kazakh (Cyrillic) (Қазақша (Cyrillic)) */
$messages['kk-cyrl'] = array(
	'pfunc_time_error' => 'Қате: жарамсыз уақыт',
	'pfunc_time_too_long' => 'Қате: #time шақыруы тым көп',
	'pfunc_rel2abs_invalid_depth' => 'Қате: Мына жолдың жарамсыз терендігі «$1» (тамыр түйіннің үстіндегі түйінге қатынау талабы)',
	'pfunc_expr_stack_exhausted' => 'Айтылым қатесі: Стек сарқылды',
	'pfunc_expr_unexpected_number' => 'Айтылым қатесі: Күтілмеген сан',
	'pfunc_expr_preg_match_failure' => 'Айтылым қатесі: Күтілмеген preg_match сәтсіздігі',
	'pfunc_expr_unrecognised_word' => 'Айтылым қатесі: Танылмаған сөз «$1»',
	'pfunc_expr_unexpected_operator' => 'Айтылым қатесі: Күтілмеген оператор $1',
	'pfunc_expr_missing_operand' => 'Айтылым қатесі: $1 үшін жоғалған операнд',
	'pfunc_expr_unexpected_closing_bracket' => 'Айтылым қатесі: Күтілмеген жабатын жақша',
	'pfunc_expr_unrecognised_punctuation' => 'Айтылым қатесі: Танылмаған тыныс белгісі «$1»',
	'pfunc_expr_unclosed_bracket' => 'Айтылым қатесі: Жабылмаған жақша',
	'pfunc_expr_division_by_zero' => 'Нөлге бөлінуі',
	'pfunc_expr_unknown_error' => 'Айтылым қатесі: Белгісіз қате ($1)',
	'pfunc_expr_not_a_number' => '$1 дегенде: нәтиже сан емес',
);

/** Kazakh (Latin) (Қазақша (Latin)) */
$messages['kk-latn'] = array(
	'pfunc_time_error' => 'Qate: jaramsız waqıt',
	'pfunc_time_too_long' => 'Qate: #time şaqırwı tım köp',
	'pfunc_rel2abs_invalid_depth' => 'Qate: Mına joldıñ jaramsız terendigi «$1» (tamır tüýinniñ üstindegi tüýinge qatınaw talabı)',
	'pfunc_expr_stack_exhausted' => 'Aýtılım qatesi: Stek sarqıldı',
	'pfunc_expr_unexpected_number' => 'Aýtılım qatesi: Kütilmegen san',
	'pfunc_expr_preg_match_failure' => 'Aýtılım qatesi: Kütilmegen preg_match sätsizdigi',
	'pfunc_expr_unrecognised_word' => 'Aýtılım qatesi: Tanılmağan söz «$1»',
	'pfunc_expr_unexpected_operator' => 'Aýtılım qatesi: Kütilmegen operator $1',
	'pfunc_expr_missing_operand' => 'Aýtılım qatesi: $1 üşin joğalğan operand',
	'pfunc_expr_unexpected_closing_bracket' => 'Aýtılım qatesi: Kütilmegen jabatın jaqşa',
	'pfunc_expr_unrecognised_punctuation' => 'Aýtılım qatesi: Tanılmağan tınıs belgisi «$1»',
	'pfunc_expr_unclosed_bracket' => 'Aýtılım qatesi: Jabılmağan jaqşa',
	'pfunc_expr_division_by_zero' => 'Nölge bölinwi',
	'pfunc_expr_unknown_error' => 'Aýtılım qatesi: Belgisiz qate ($1)',
	'pfunc_expr_not_a_number' => '$1 degende: nätïje san emes',
);

/** Khmer (ភាសាខ្មែរ)
 * @author Lovekhmer
 * @author Thearith
 * @author គីមស៊្រុន
 */
$messages['km'] = array(
	'pfunc_time_error' => 'កំហុស៖ ពេលវេលាមិនត្រឹមត្រូវ',
	'pfunc_expr_division_by_zero' => 'ចែកនឹងសូន្យ',
	'pfunc_expr_not_a_number' => 'ក្នុង $1: លទ្ធផល​មិន​មែន​ជា​លេខ​ទេ',
);

/** Korean (한국어)
 * @author Klutzy
 * @author Kwj2772
 * @author ToePeu
 * @author Yknok29
 */
$messages['ko'] = array(
	'pfunc_desc' => '파서에 논리 함수를 추가',
	'pfunc_time_error' => '오류: 시간이 잘못되었습니다.',
	'pfunc_time_too_long' => '오류: #time을 너무 많이 썼습니다.',
	'pfunc_time_too_big' => '오류: #time 함수는 9999년까지만을 지원합니다.',
	'pfunc_rel2abs_invalid_depth' => '오류: 경로 구조가 잘못되었습니다: "$1" (루트 노드 위의 노드에 접속을 시도했습니다)',
	'pfunc_expr_stack_exhausted' => '표현 오류: 스택이 비어 있습니다.',
	'pfunc_expr_unexpected_number' => '표현식 오류: 예상치 못한 값',
	'pfunc_expr_preg_match_failure' => '표현식 오류: 예상치 못한 preg_match 오류',
	'pfunc_expr_unrecognised_word' => '표현식 오류: 알 수 없는 단어 ‘$1’',
	'pfunc_expr_unexpected_operator' => '표현 오류: 잘못된 $1 연산자',
	'pfunc_expr_missing_operand' => '표현 오류: $1의 피연산자가 없습니다.',
	'pfunc_expr_unexpected_closing_bracket' => '표현 오류: 예상치 못한 괄호 닫기',
	'pfunc_expr_unrecognised_punctuation' => '표현 오류: 알 수 없는 문자 "$1"',
	'pfunc_expr_unclosed_bracket' => '표현 오류: 괄호를 닫지 않았습니다.',
	'pfunc_expr_division_by_zero' => '0으로 나눔',
	'pfunc_expr_invalid_argument' => '$1 함수의 변수가 잘못되었습니다: < -1 또는 > 1',
	'pfunc_expr_invalid_argument_ln' => '자연로그의 진수가 잘못되었습니다: <= 0',
	'pfunc_expr_unknown_error' => '표현 오류: 알려지지 않은 오류 ($1)',
	'pfunc_expr_not_a_number' => '$1: 결과가 숫자가 아닙니다.',
	'pfunc_string_too_long' => '오류: $1자 제한을 초과하였습니다.',
);

/** Colognian (Ripoarisch)
 * @author Purodha
 * @author Rentenirer
 */
$messages['ksh'] = array(
	'pfunc_desc' => 'Deit em Wiki Funxione för Entscheidunge un esu dobei.',
	'pfunc_time_error' => 'Fähler: Onjöltijje Zick.',
	'pfunc_time_too_long' => 'Fähler: <code>#time</code> weed zo öff jebruch.',
	'pfunc_time_too_big' => 'Ene Fähleres opjefalle: <code lang="en">#time</code> kann bloß bes nohm Johr 9999 jonn.',
	'pfunc_rel2abs_invalid_depth' => 'Fähler: Zo fill „retuur“ em Pahdt „$1“ — mer wöre wigger wi för der Aanfang zeröck jejange.',
	'pfunc_expr_stack_exhausted' => 'Fähler en enem Ußdrock: Dä löht der <i lang="en">stack</i> övverloufe.',
	'pfunc_expr_unexpected_number' => 'Fähler en enem Ußdrock: En Zahl dom_mer nit äwaade.',
	'pfunc_expr_preg_match_failure' => 'Fähler en enem Ußdrock: Esu ene Fähler en „<i lang="en">preg_match</i>“ dum_mer nit äwade.',
	'pfunc_expr_unrecognised_word' => 'Fähler en enem Ußdrock: Dat Woot „$1“ es unbikannt.',
	'pfunc_expr_unexpected_operator' => 'Fähler en enem Ußdrock: Dat Räschezeiche „$1“ dom_mer hee nit äwaade.',
	'pfunc_expr_missing_operand' => 'Fähler en enem Ußdrock: För dat Räschezeiche „$1“ dom_mer ävver ene Operand äwaade.',
	'pfunc_expr_unexpected_closing_bracket' => 'Fähler en enem Ußdrock: En eckijje Klammer-Zoh dom_mer esu nit äwaade.',
	'pfunc_expr_unrecognised_punctuation' => 'Fähler en enem Ußdrock: Dat Satzzeiche „$1“ dom_mer esu nit äwaade.',
	'pfunc_expr_unclosed_bracket' => 'Fähler en enem Ußdrock: Do fählt en eckijje Klammer-Zoh.',
	'pfunc_expr_division_by_zero' => 'Fähler en enem Ußdrock: Dorsch Noll jedeilt.',
	'pfunc_expr_invalid_argument' => 'Fähler: Dä Parrameeter för <code>$1</code> moß -1 udder 1 sin, udder dozwesche lijje.',
	'pfunc_expr_invalid_argument_ln' => 'Fähler: Dä Parrameeter för <code>ln</code> moß 0 udder kleiner wi 0 sin.',
	'pfunc_expr_unknown_error' => 'Fähler en enem Ußdrock: Unbikannt ($1)',
	'pfunc_expr_not_a_number' => 'Fähler en enem Ußdrock: En <code>$1</code> es dat wat erus kütt kein Zahl.',
	'pfunc_string_too_long' => 'Fähler en enem Ußdrock: En Zeijshereih es länger wi $1 Zeijshe.',
	'pfunc-convert-dimension-length' => 'Längemohß',
	'pfunc-convert-dimension-area' => 'Flächemohß',
	'pfunc-convert-dimension-volume' => 'Hohlmohß',
	'pfunc-convert-dimension-time' => 'Ziggmohß',
	'pfunc-convert-dimension-timesquared' => 'Zigg<sup>2</sup>-Mohß',
	'pfunc-convert-dimension-mass' => 'Mohß för de  Mass',
	'pfunc-convert-dimension-speed' => 'Jeschwendechkeit',
	'pfunc-convert-dimension-pressure' => 'Drock',
	'pfunc-convert-prefix-yotta' => 'Yotta',
	'pfunc-convert-prefix-zetta' => 'Zetta',
	'pfunc-convert-prefix-exa' => 'Exa',
	'pfunc-convert-prefix-tera' => 'Tera',
	'pfunc-convert-prefix-giga' => 'Giga',
	'pfunc-convert-prefix-mega' => 'Mega',
	'pfunc-convert-prefix-kilo' => 'Killo',
	'pfunc-convert-prefix-hecto' => 'Häkto',
	'pfunc-convert-prefix-deca' => 'Dekka',
	'pfunc-convert-prefix-deci' => 'Dezi',
	'pfunc-convert-prefix-centi' => 'Cänti',
	'pfunc-convert-prefix-milli' => 'Milli',
	'pfunc-convert-prefix-micro' => 'Mikro',
	'pfunc-convert-prefix-nano' => 'Nanno',
	'pfunc-convert-prefix-pico' => 'Picko',
	'pfunc-convert-prefix-femto' => 'Fämto',
	'pfunc-convert-prefix-atto' => 'Atto',
	'pfunc-convert-prefix-zepto' => 'Zäpto',
	'pfunc-convert-prefix-yocto' => 'Jokto',
	'pfunc-convert-unit-length-metre' => '$1Meeter',
	'pfunc-convert-unit-length-mile' => '$1{{PLURAL:$2|Meil|Meile|Meile}}',
	'pfunc-convert-unit-area-squarekilometre' => '$1Quadraatkillomeetere',
	'pfunc-convert-unit-area-squarekilometre-abbr' => '$1km<sup>2</sup>',
	'pfunc-convert-unit-area-squaremetre-abbr' => '$1m²',
);

/** Luxembourgish (Lëtzebuergesch)
 * @author Robby
 */
$messages['lb'] = array(
	'pfunc_desc' => 'Erweidert Parser mat logesche Fonctiounen',
	'pfunc_time_error' => 'Feeler: ongëlteg Zäit',
	'pfunc_time_too_long' => 'Feeler: ze dacks #time opgeruff',
	'pfunc_time_too_big' => 'Feeler: #time ënnerstëtzt nëmme Jore bis 9999',
	'pfunc_expr_stack_exhausted' => 'Expressiouns-Feeler: Stack iwwergelaf',
	'pfunc_expr_unexpected_number' => 'Expressiouns-Feeler: Onerwarten Zuel',
	'pfunc_expr_unrecognised_word' => 'Expressiouns-Feeler: Onerkantent Wuert "$1"',
	'pfunc_expr_unexpected_operator' => 'Expression-Feeler: Onerwarten Operateur: <tt>$1</tt>',
	'pfunc_expr_missing_operand' => 'Expression-Feeler: Et feelt en Operand fir <tt>$1</tt>',
	'pfunc_expr_unexpected_closing_bracket' => 'Expressiouns-Feeler: Onerwarte Klammer déi zougemaach gëtt',
	'pfunc_expr_unrecognised_punctuation' => 'Expressiouns-Feeler: D\'Sazzeechen "$1" gouf net erkannt',
	'pfunc_expr_unclosed_bracket' => 'Expressiouns-Feeler: Eckeg Klammer net zougemaach',
	'pfunc_expr_division_by_zero' => 'Divisioun duerch Null',
	'pfunc_expr_invalid_argument' => 'Ongültege Wäert fir $1: < -1 oder > 1',
	'pfunc_expr_invalid_argument_ln' => 'Ongültege Wäert fir ln: <= 0',
	'pfunc_expr_unknown_error' => 'Expression-Feeler: Onbekannte Feeler ($1)',
	'pfunc_expr_not_a_number' => "An $1: D'Resultat ass keng Zuel",
	'pfunc_string_too_long' => "Feeler: D'Zeecheketten ass méi laang wéi d'Limit vu(n) $1 Zeechen",
	'pfunc-convert-dimensionmismatch' => 'Feeler: Et kann net vun der Eenheet "$1" an d\'Eenheet "$2" konvertéiert ginn',
	'pfunc-convert-unknownunit' => 'Feeler: Onbekannten Eenheet "$1".',
	'pfunc-convert-unknowndimension' => 'Feeler: Onbekannten Dimensioun "$1".',
	'pfunc-convert-dimension-length' => 'Längt',
	'pfunc-convert-dimension-area' => 'Fläch',
	'pfunc-convert-dimension-volume' => 'Volume',
	'pfunc-convert-dimension-time' => 'Zäit',
	'pfunc-convert-dimension-mass' => 'Mass',
	'pfunc-convert-dimension-speed' => 'Vitesse',
	'pfunc-convert-dimension-temperature' => 'Temperatur',
	'pfunc-convert-dimension-acceleration' => 'Beschleunegung',
	'pfunc-convert-dimension-force' => 'Kraaft',
	'pfunc-convert-dimension-torque' => 'Dréimoment',
	'pfunc-convert-dimension-energy' => 'Energie',
	'pfunc-convert-dimension-power' => 'Leeschtung',
	'pfunc-convert-dimension-pressure' => 'Drock',
	'pfunc-convert-dimension-density' => 'Densitéit',
	'pfunc-convert-unit-length-metre' => '$1{{PLURAL:$2|Meter|Meter}}',
	'pfunc-convert-unit-length-mile' => '$1{{PLURAL:$2|Meil|Meilen}}',
	'pfunc-convert-unit-length-foot' => '$1{{PLURAL:$2|Fouss|Féiss}}',
	'pfunc-convert-unit-length-nauticalmile' => '$1{{PLURAL:$2|nautesch Meil|nautesch Meilen}}',
	'pfunc-convert-unit-length-lightyear' => '$1{{PLURAL:$2|$3 Liichtjoer|$3 Liichtjoer}}',
	'pfunc-convert-unit-length-astronomicalunit' => '$1{{PLURAL:$2|astronomesch Eenheet|astronomesch Eenheeten}}',
	'pfunc-convert-unit-area-squarekilometre' => '$1{{PLURAL:$2|Quadratkilometer|Quadratkilometer}}',
	'pfunc-convert-unit-area-squaremetre' => '$1{{PLURAL:$2|Quadratmeter|Quadratmeter}}',
	'pfunc-convert-unit-area-squarecentimetre' => '$1{{PLURAL:$2|Quadratzentimeter|Quadratzentimeter}}',
	'pfunc-convert-unit-area-squaremillimetre' => '$1{{PLURAL:$2|Quadratmillimeter|Quadratmillimeter}}',
	'pfunc-convert-unit-area-hectare' => '$1{{PLURAL:$2|Hektar|Hektar}}',
	'pfunc-convert-unit-time-second' => '$1{{PLURAL:$2|Sekonn|Sekonnen}}',
	'pfunc-convert-unit-time-year' => '$1{{PLURAL:$2|Joer|Joer}}',
	'pfunc-convert-unit-time-day' => '$1{{PLURAL:$2|Dag|Deeg}}',
	'pfunc-convert-unit-time-hour' => '$1{{PLURAL:$2|Stonn|Stonnen}}',
	'pfunc-convert-unit-time-minute' => '$1{{PLURAL:$2|Minutt|Minutten}}',
	'pfunc-convert-unit-time-day-abbr' => '$1Dag',
	'pfunc-convert-unit-volume-cubicmetre' => '$1{{PLURAL:$2|Kubikmeter|Kubikmeter}}',
	'pfunc-convert-unit-volume-kilolitre' => '$1{{PLURAL:$2|Fudder|Fudder}}',
	'pfunc-convert-unit-volume-litre' => '$1{{PLURAL:$2|Liter|Liter}}',
	'pfunc-convert-unit-volume-millilitre' => '$1{{PLURAL:$2|Milliliter|Milliliter}}',
	'pfunc-convert-unit-speed-mile-hour' => '$1Meile pro Stonn',
	'pfunc-convert-unit-pressure-atmosphere' => '$1{{PLURAL:$2|Atmosphäre|Atmosphären}}',
);

/** Limburgish (Limburgs)
 * @author Matthias
 * @author Ooswesthoesbes
 */
$messages['li'] = array(
	'pfunc_desc' => 'Verrijkt de parser met logische functies',
	'pfunc_time_error' => 'Fout: ongeldige tied',
	'pfunc_time_too_long' => 'Fout: #time te vaok aangerope',
	'pfunc_rel2abs_invalid_depth' => 'Fout: ongeldige diepte in pad: "$1" (probeerde \'n node bove de stamnode aan te rope)',
	'pfunc_expr_stack_exhausted' => 'Fout in oetdrukking: stack oetgeput',
	'pfunc_expr_unexpected_number' => 'Fout in oetdrukking: onverwacht getal',
	'pfunc_expr_preg_match_failure' => 'Fout in oetdrukking: onverwacht fale van preg_match',
	'pfunc_expr_unrecognised_word' => 'Fout in oetdrukking: woord "$1" neet herkend',
	'pfunc_expr_unexpected_operator' => 'Fout in oetdrukking: neet verwachte operator $1',
	'pfunc_expr_missing_operand' => 'Fout in oetdrukking: operand veur $1 mist',
	'pfunc_expr_unexpected_closing_bracket' => 'Fout in oetdrukking: haakje sloete op onverwachte plaats',
	'pfunc_expr_unrecognised_punctuation' => 'Fout in oetdrukking: neet herkend leesteke "$1"',
	'pfunc_expr_unclosed_bracket' => 'Fout in oetdrukking: neet geslote haakje opene',
	'pfunc_expr_division_by_zero' => 'Deiling door nul',
	'pfunc_expr_invalid_argument' => 'Ongeldige paramaeter veur $1: < -1 of > 1',
	'pfunc_expr_invalid_argument_ln' => 'Ongeldige paramaeter veur ln: <= 0',
	'pfunc_expr_unknown_error' => 'Fout in oetdrukking: ónbekindje fout ($1)',
	'pfunc_expr_not_a_number' => 'In $1: rezultaot is gein getal',
	'pfunc_string_too_long' => 'Fout: De teks is lenger es de limiet van $1 {{PLURAL:$1|teike|teikes}}',
);

/** Lithuanian (Lietuvių)
 * @author Hugo.arg
 */
$messages['lt'] = array(
	'pfunc_time_error' => 'Klaida: neteisingas laikas',
);

/** Latvian (Latviešu)
 * @author Papuass
 */
$messages['lv'] = array(
	'pfunc_time_error' => 'Kļūda: nederīgs laiks',
	'pfunc_time_too_long' => 'Kļūda: pārāk daudz #time izsaukumu',
	'pfunc_expr_division_by_zero' => 'Dalīšana ar nulli',
);

/** Macedonian (Македонски)
 * @author Bjankuloski06
 * @author Brest
 */
$messages['mk'] = array(
	'pfunc_desc' => 'Проширување на можностите на парсерот со логички функции',
	'pfunc_time_error' => 'Грешка: погрешен формат за време',
	'pfunc_time_too_long' => 'Грешка: премногу повикувања на функцијата #time',
	'pfunc_time_too_big' => 'Грешка: #time поддржува само години до 9999',
	'pfunc_rel2abs_invalid_depth' => 'Грешка: Неважечка длабочина во патеката: „$1“ (обид за пристап до јазол кој се наоѓа повисоко од коренитиот)',
	'pfunc_expr_stack_exhausted' => 'Грешка во изразот: Складот е преполн',
	'pfunc_expr_unexpected_number' => 'Грешка во изразот: Неочекуван број',
	'pfunc_expr_preg_match_failure' => 'Грешка во изразот: Неочекуван проблем со preg_match',
	'pfunc_expr_unrecognised_word' => 'Грешка во изразот: Непрепознаен збор „$1“',
	'pfunc_expr_unexpected_operator' => 'Грешка во изразот: Неочекуван оператор $1',
	'pfunc_expr_missing_operand' => 'Грешка во изразот: Недостасува операнд за $1',
	'pfunc_expr_unexpected_closing_bracket' => 'Грешка во изразот: Неочекувано затворање на заграда',
	'pfunc_expr_unrecognised_punctuation' => 'Грешка во изразот: Непрепознаен интерпункциски знак „$1“',
	'pfunc_expr_unclosed_bracket' => 'Грешка во изразот: Незатворена заграда',
	'pfunc_expr_division_by_zero' => 'Делење со нула',
	'pfunc_expr_invalid_argument' => 'Неважечки аргумент за $1: < -1 или > 1',
	'pfunc_expr_invalid_argument_ln' => 'Неважечки аргумент за ln: <= 0',
	'pfunc_expr_unknown_error' => 'Грешка во изразот: Непозната грешка ($1)',
	'pfunc_expr_not_a_number' => 'Во $1: резултатот не е број',
	'pfunc_string_too_long' => 'Грешка: низата го надминува ограничувањето од $1 знаци',
	'pfunc-convert-dimensionmismatch' => 'Грешка: претворањето од единицата „$1“ во единицата „$2“ е невозможно',
	'pfunc-convert-unknownunit' => 'Грешка: непозната единица „$1“',
	'pfunc-convert-unknowndimension' => 'Грешка: непозната димензија „$1“',
	'pfunc-convert-invalidcompoundunit' => 'Грешка: неважечка мешовита единица „$1“',
	'pfunc-convert-nounit' => 'Грешка: нема наведено изворна единица',
	'pfunc-convert-doublecompoundunit' => 'Грешка: не можам да парсирам двојни мешовити единици како „$1“',
	'pfunc-convert-dimension-length' => 'должина',
	'pfunc-convert-dimension-area' => 'плоштина',
	'pfunc-convert-dimension-volume' => 'волумен',
	'pfunc-convert-dimension-time' => 'време',
	'pfunc-convert-dimension-timesquared' => 'време<sup>2</sup>',
	'pfunc-convert-dimension-mass' => 'маса',
	'pfunc-convert-dimension-speed' => 'брзина',
	'pfunc-convert-dimension-temperature' => 'температура',
	'pfunc-convert-dimension-acceleration' => 'забрзување',
	'pfunc-convert-dimension-force' => 'сила',
	'pfunc-convert-dimension-torque' => 'момент на сила',
	'pfunc-convert-dimension-energy' => 'енергија',
	'pfunc-convert-dimension-power' => 'моќ',
	'pfunc-convert-dimension-pressure' => 'притисок',
	'pfunc-convert-dimension-density' => 'густина',
	'pfunc-convert-dimension-fuelefficiencypositive' => 'позитивна горивна ефикасност',
	'pfunc-convert-dimension-fuelefficiencynegative' => 'негативна горивна ефикасност',
	'pfunc-convert-prefix-yotta' => 'јота',
	'pfunc-convert-prefix-zetta' => 'зета',
	'pfunc-convert-prefix-exa' => 'екса',
	'pfunc-convert-prefix-peta' => 'пета',
	'pfunc-convert-prefix-tera' => 'тера',
	'pfunc-convert-prefix-giga' => 'гига',
	'pfunc-convert-prefix-mega' => 'мега',
	'pfunc-convert-prefix-kilo' => 'кило',
	'pfunc-convert-prefix-hecto' => 'хекто',
	'pfunc-convert-prefix-deca' => 'дека',
	'pfunc-convert-prefix-deci' => 'деци',
	'pfunc-convert-prefix-centi' => 'санти',
	'pfunc-convert-prefix-milli' => 'мили',
	'pfunc-convert-prefix-micro' => 'микро',
	'pfunc-convert-prefix-nano' => 'нано',
	'pfunc-convert-prefix-pico' => 'пико',
	'pfunc-convert-prefix-femto' => 'фемто',
	'pfunc-convert-prefix-atto' => 'ато',
	'pfunc-convert-prefix-zepto' => 'зепто',
	'pfunc-convert-prefix-yocto' => 'јокто',
	'pfunc-convert-prefix-yotta-abbr' => 'Ј',
	'pfunc-convert-prefix-zetta-abbr' => 'З',
	'pfunc-convert-prefix-exa-abbr' => 'Е',
	'pfunc-convert-prefix-peta-abbr' => 'П',
	'pfunc-convert-prefix-tera-abbr' => 'Т',
	'pfunc-convert-prefix-giga-abbr' => 'Г',
	'pfunc-convert-prefix-mega-abbr' => 'М',
	'pfunc-convert-prefix-kilo-abbr' => 'к',
	'pfunc-convert-prefix-hecto-abbr' => 'х',
	'pfunc-convert-prefix-deca-abbr' => 'да',
	'pfunc-convert-prefix-deci-abbr' => 'д',
	'pfunc-convert-prefix-centi-abbr' => 'с',
	'pfunc-convert-prefix-milli-abbr' => 'м',
	'pfunc-convert-prefix-micro-abbr' => 'μ',
	'pfunc-convert-prefix-nano-abbr' => 'н',
	'pfunc-convert-prefix-pico-abbr' => 'п',
	'pfunc-convert-prefix-femto-abbr' => 'ф',
	'pfunc-convert-prefix-atto-abbr' => 'а',
	'pfunc-convert-prefix-zepto-abbr' => 'з',
	'pfunc-convert-prefix-yocto-abbr' => 'ј',
	'pfunc-convert-unit-length-metre' => '$1{{PLURAL:$2|метар|метри}}',
	'pfunc-convert-unit-length-angstrom' => '$1{{PLURAL:$2|ангстрем|ангстреми}}',
	'pfunc-convert-unit-length-mile' => '$1{{PLURAL:$2|милја|милји}}',
	'pfunc-convert-unit-length-furlong' => '$1{{PLURAL:$2|фурлонг|фурлонзи}}',
	'pfunc-convert-unit-length-chain' => '$1{{PLURAL:$2|ланец|ланци}}',
	'pfunc-convert-unit-length-rod' => '$1{{PLURAL:$2|прачка|прачки}}',
	'pfunc-convert-unit-length-fathom' => '$1{{PLURAL:$2|фатом|фатоми}}',
	'pfunc-convert-unit-length-yard' => '$1{{PLURAL:$2|јарда|јарди}}',
	'pfunc-convert-unit-length-foot' => '$1{{PLURAL:$2|стапка|стапки}}',
	'pfunc-convert-unit-length-hand' => '$1{{PLURAL:$2|дланка|дланки}}',
	'pfunc-convert-unit-length-inch' => '$1{{PLURAL:$2|инч|инчи}}',
	'pfunc-convert-unit-length-nauticalmile' => '$1{{PLURAL:$2|наутичка милја|наутички милји}}',
	'pfunc-convert-unit-length-nauticalmileuk' => '$1{{PLURAL:$2|наутичка милја (британска, пред 1970)|наутички милји (британска, пред 1970)}}',
	'pfunc-convert-unit-length-nauticalmileus' => '$1{PLURAL:$2|наутичка милја (американска, пред 1954)|наутички милји (американски, пред 1954)}}',
	'pfunc-convert-unit-length-parsec' => '$1{{PLURAL:$2|$3 парсек|$3 парсеци}}',
	'pfunc-convert-unit-length-lightyear' => '$1{{PLURAL:$2|светлосна година|светлосни години}}',
	'pfunc-convert-unit-length-astronomicalunit' => '$1{{PLURAL:$2|астрономска единица|астрономски единици}}',
	'pfunc-convert-unit-length-metre-abbr' => '$1$3 м',
	'pfunc-convert-unit-length-mile-abbr' => '$1ми',
	'pfunc-convert-unit-length-furlong-abbr' => '$1фурлонг',
	'pfunc-convert-unit-length-chain-abbr' => '$1ланец',
	'pfunc-convert-unit-length-rod-abbr' => '$1пр',
	'pfunc-convert-unit-length-fathom-abbr' => '$1фатом',
	'pfunc-convert-unit-length-yard-abbr' => '$1јд',
	'pfunc-convert-unit-length-foot-abbr' => '$1ст',
	'pfunc-convert-unit-length-hand-abbr' => '$1дл',
	'pfunc-convert-unit-length-inch-abbr' => '$1ин',
	'pfunc-convert-unit-length-nauticalmile-abbr' => '$1нми',
	'pfunc-convert-unit-length-nauticalmileuk-abbr' => '$1нми (брит)',
	'pfunc-convert-unit-length-nauticalmileus-abbr' => '$1нми (амер. пред 1954)',
	'pfunc-convert-unit-length-parsec-abbr' => '$1$3 пс',
	'pfunc-convert-unit-length-lightyear-abbr' => '$1$3 сг',
	'pfunc-convert-unit-length-astronomicalunit-abbr' => '$1ae',
	'pfunc-convert-unit-area-squarekilometre' => '$1{{PLURAL:$2|квадратен километар|квадратни километри}}',
	'pfunc-convert-unit-area-squaremetre' => '$1{{PLURAL:$2|квадратен метар|квадратни метри}}',
	'pfunc-convert-unit-area-squarecentimetre' => '$1{{PLURAL:$2|квадратен сантиметар|квадратни сантиметри}}',
	'pfunc-convert-unit-area-squaremillimetre' => '$1{{PLURAL:$2|квадратен милиметар|квадратни милиметри}}',
	'pfunc-convert-unit-area-hectare' => '$1{{PLURAL:$2|хектар|хектари}}',
	'pfunc-convert-unit-area-squaremile' => '$1{{PLURAL:$2|квадратна милја|квадратни милји}}',
	'pfunc-convert-unit-area-acre' => '$1{{PLURAL:$2|акр|акри}}',
	'pfunc-convert-unit-area-squareyard' => '$1{{PLURAL:$2|квадратна јарда|квадратни јарди}}',
	'pfunc-convert-unit-area-squarefoot' => '$1{{PLURAL:$2|квадратна стапка|квадратни стапки}}',
	'pfunc-convert-unit-area-squareinch' => '$1{{PLURAL:$2|квадратен инч|квадратни инчи}}',
	'pfunc-convert-unit-area-squarenauticalmile' => '$1{{PLURAL:$2|квадратна наутичка милја|квадратни наутички милји}}',
	'pfunc-convert-unit-area-dunam' => '$1{{PLURAL:$2|дунум|дунуми}}',
	'pfunc-convert-unit-area-tsubo' => '$1{{PLURAL:$2|цубо|цуба}}',
	'pfunc-convert-unit-area-squarekilometre-abbr' => '$1км<sup>2</sup>',
	'pfunc-convert-unit-area-squaremetre-abbr' => '$1м<sup>2</sup>',
	'pfunc-convert-unit-area-squarecentimetre-abbr' => '$1см<sup>2</sup>',
	'pfunc-convert-unit-area-squaremillimetre-abbr' => '$1мм<msup>2</sup>',
	'pfunc-convert-unit-area-hectare-abbr' => '$1ха',
	'pfunc-convert-unit-area-squaremile-abbr' => '$1ми<sup>2</sup>',
	'pfunc-convert-unit-area-acre-abbr' => '$1акр',
	'pfunc-convert-unit-area-squareyard-abbr' => '$1јд<sup>2</sup>',
	'pfunc-convert-unit-area-squarefoot-abbr' => '$1ст<sup>2</sup>',
	'pfunc-convert-unit-area-squareinch-abbr' => '$1ин<sup>2</sup>',
	'pfunc-convert-unit-area-squarenauticalmile-abbr' => '$1нми<sup>2</sup>',
	'pfunc-convert-unit-area-dunam-abbr' => '$1дунум',
	'pfunc-convert-unit-area-tsubo-abbr' => '$1цубо',
	'pfunc-convert-unit-time-second' => '$1{{PLURAL:$2|секунда|секунди}}',
	'pfunc-convert-unit-time-year' => '$1{{PLURAL:$2|година|години}}',
	'pfunc-convert-unit-time-day' => '$1{{PLURAL:$2|ден|дена}}',
	'pfunc-convert-unit-time-hour' => '$1{{PLURAL:$2|час|часа}}',
	'pfunc-convert-unit-time-minute' => '$1{{PLURAL:$2|минута|минути}}',
	'pfunc-convert-unit-time-second-abbr' => '$1с',
	'pfunc-convert-unit-time-year-abbr' => '$1$3 г',
	'pfunc-convert-unit-time-day-abbr' => '$1ден',
	'pfunc-convert-unit-time-hour-abbr' => '$1ч',
	'pfunc-convert-unit-time-minute-abbr' => '$1мин',
	'pfunc-convert-unit-volume-cubicmetre' => '$1{{PLURAL:$2|кубен метар|кубни метри}}',
	'pfunc-convert-unit-volume-cubiccentimetre' => '$1{{PLURAL:$2|кубен сантиметар|кубни сантиметри}}',
	'pfunc-convert-unit-volume-cubicmillimetre' => '$1{{PLURAL:$2|кубен милиметар|кубни милиметри}}',
	'pfunc-convert-unit-volume-kilolitre' => '$1{{PLURAL:$2|килолитар|килолитри}}',
	'pfunc-convert-unit-volume-litre' => '$1{{PLURAL:$2|литар|литри}}',
	'pfunc-convert-unit-volume-centilitre' => '$1{{PLURAL:$2|центилитар|центилитри}}',
	'pfunc-convert-unit-volume-millilitre' => '$1{{PLURAL:$2|милилитар|милилитри}}',
	'pfunc-convert-unit-volume-cubicyard' => '$1{{PLURAL:$2|кубна јарда|кубни јарди}}',
	'pfunc-convert-unit-volume-cubicfoot' => '$1{{PLURAL:$2|кубна стапка|кубни стапки}}',
	'pfunc-convert-unit-volume-cubicinch' => '$1{{PLURAL:$2|кубен инч|кубни инчи}}',
	'pfunc-convert-unit-volume-barrel' => '$1{{PLURAL:$2|барел|барели}}',
	'pfunc-convert-unit-volume-bushel' => '$1{{PLURAL:$2|бушел|бушели}}',
	'pfunc-convert-unit-volume-gallon' => '$1{{PLURAL:$2|галон|галони}}',
	'pfunc-convert-unit-volume-quart' => '$1{{PLURAL:$2|кварта|кварти}}',
	'pfunc-convert-unit-volume-pint' => '$1{{PLURAL:$2|пинта|пинти}}',
	'pfunc-convert-unit-volume-fluidounce' => '$1{{PLURAL:$2|течна унца|течни унци}}',
	'pfunc-convert-unit-volume-barrelus' => '$1{{PLURAL:$2|американски барел|американски барели}}',
	'pfunc-convert-unit-volume-barreloil' => '$1{{PLURAL:$2|барел|барели}}',
	'pfunc-convert-unit-volume-barrelbeer' => '$1{{PLURAL:$2|барел|барели}}',
	'pfunc-convert-unit-volume-usgallon' => '$1{{PLURAL:$2|американски галон|американски галони}}',
	'pfunc-convert-unit-volume-usquart' => '$1{{PLURAL:$2|американска кварта|американски кварти}}',
	'pfunc-convert-unit-volume-uspint' => '$1{{PLURAL:$2|американска пинта|американски пинти}}',
	'pfunc-convert-unit-volume-usfluidounce' => '$1{{PLURAL:$2|американска течна унца|американски течни унци}}',
	'pfunc-convert-unit-volume-usdrybarrel' => '$1{{PLURAL:$2|американски сув барел|американски суви барели}}',
	'pfunc-convert-unit-volume-usbushel' => '$1{{PLURAL:$2|американски бушел|американски бушели}}',
	'pfunc-convert-unit-volume-usdrygallon' => '$1{{PLURAL:$2|американски сув галон|американски суви галони}}',
	'pfunc-convert-unit-volume-usdryquart' => '$1{{PLURAL:$2|американска сува кварта|американски суви кварти}}',
	'pfunc-convert-unit-volume-usdrypint' => '$1{{PLURAL:$2|американска сува пинта|американски суви пинти}}',
	'pfunc-convert-unit-volume-cubicmetre-abbr' => '$1м<sup>3</sup>',
	'pfunc-convert-unit-volume-cubiccentimetre-abbr' => '$1см<sup>3</sup>',
	'pfunc-convert-unit-volume-cubicmillimetre-abbr' => '$1мм<sup>3</sup>',
	'pfunc-convert-unit-volume-litre-abbr' => '$1$3 л',
	'pfunc-convert-unit-volume-cubicyard-abbr' => '$1јд<sup>3</sup>',
	'pfunc-convert-unit-volume-cubicfoot-abbr' => '$1ст<sup>3</sup>',
	'pfunc-convert-unit-volume-cubicinch-abbr' => '$1ин<sup>3</sup>',
	'pfunc-convert-unit-volume-barrel-abbr' => '$1ббл',
	'pfunc-convert-unit-volume-bushel-abbr' => '$1бш',
	'pfunc-convert-unit-volume-gallon-abbr' => '$1гал',
	'pfunc-convert-unit-volume-quart-abbr' => '$1кт',
	'pfunc-convert-unit-volume-pint-abbr' => '$1пт',
	'pfunc-convert-unit-volume-fluidounce-abbr' => '$1тч уц',
	'pfunc-convert-unit-volume-barrelus-abbr' => '$1ббл (САД)',
	'pfunc-convert-unit-volume-barreloil-abbr' => '$1ббл',
	'pfunc-convert-unit-volume-barrelbeer-abbr' => '$1ббл',
	'pfunc-convert-unit-volume-usgallon-abbr' => '$1гал (САД)',
	'pfunc-convert-unit-volume-usquart-abbr' => '$1кт (САД)',
	'pfunc-convert-unit-volume-uspint-abbr' => '$1пт (САД)',
	'pfunc-convert-unit-volume-usfluidounce-abbr' => '$1тч уц (САД)',
	'pfunc-convert-unit-volume-usdrybarrel-abbr' => '$1ббл (САД)',
	'pfunc-convert-unit-volume-usbushel-abbr' => '$1бш (САД)',
	'pfunc-convert-unit-volume-usdrygallon-abbr' => '$1сув гал (САД)',
	'pfunc-convert-unit-volume-usdryquart-abbr' => '$1сув кт (САД)',
	'pfunc-convert-unit-volume-usdrypint-abbr' => '$1сув пт (САД)',
	'pfunc-convert-unit-speed-mile-hour' => '$1милји на час',
	'pfunc-convert-unit-speed-speedoflight' => '$1c',
	'pfunc-convert-unit-speed-mile-hour-abbr' => '$1ми/ч',
	'pfunc-convert-unit-speed-speedoflight-abbr' => '$1c',
	'pfunc-convert-unit-pressure-pascal' => '$1{{PLURAL:$2|паскал|паскали}}',
	'pfunc-convert-unit-pressure-bar' => '$1бар',
	'pfunc-convert-unit-pressure-decibar' => '$1децибар',
	'pfunc-convert-unit-pressure-millibar' => '$1милибар',
	'pfunc-convert-unit-pressure-kilobarye' => '$1килобарија',
	'pfunc-convert-unit-pressure-barye' => '$1барија',
	'pfunc-convert-unit-pressure-atmosphere' => '$1{{PLURAL:$2|атмосфера|атмосфери}}',
	'pfunc-convert-unit-pressure-torr' => '$1{{PLURAL:$2|тор|тора}}',
	'pfunc-convert-unit-pressure-mmhg' => '$1{{PLURAL:$2|милиметар живин столб|милиметри живин столб}}',
	'pfunc-convert-unit-pressure-inhg' => '$1{{PLURAL:$2|инч живин столб|инчи живин столб}}',
	'pfunc-convert-unit-pressure-psi' => '$1{{PLURAL:$2|фунта на квадратен инч|фунти на квадратен инч}}',
	'pfunc-convert-unit-pressure-pascal-abbr' => '$1$3 Па',
	'pfunc-convert-unit-pressure-bar-abbr' => '$1бар',
	'pfunc-convert-unit-pressure-decibar-abbr' => '$1дбар',
	'pfunc-convert-unit-pressure-millibar-abbr' => '$1мбар',
	'pfunc-convert-unit-pressure-kilobarye-abbr' => '$1кБа',
	'pfunc-convert-unit-pressure-barye-abbr' => '$1Ба',
	'pfunc-convert-unit-pressure-atmosphere-abbr' => '$1атм',
	'pfunc-convert-unit-pressure-torr-abbr' => '$1тор',
	'pfunc-convert-unit-pressure-mmhg-abbr' => '$1ммHg',
	'pfunc-convert-unit-pressure-inhg-abbr' => '$1инHg',
	'pfunc-convert-unit-pressure-psi-abbr' => '$1psi',
);

/** Malayalam (മലയാളം)
 * @author Praveenp
 * @author Shijualex
 */
$messages['ml'] = array(
	'pfunc_desc' => 'ലോജിക്കൽ ഫങ്ഷൻസ് ഉപയോഗിച്ച് പാർസർ വിപുലപ്പെടുത്തുക',
	'pfunc_time_error' => 'പിഴവ്:അസാധുവായ സമയം',
	'pfunc_time_too_long' => 'പിഴവ്: വളരെയധികം #സമയ കാളുകൾ',
	'pfunc_time_too_big' => 'പിഴവ്: 9999 വരെയുള്ള വർഷങ്ങൾ മാത്രമേ #time പിന്തുണയ്ക്കുന്നുള്ളു',
	'pfunc_rel2abs_invalid_depth' => 'പിഴവ്: പഥത്തിൽ അസാധുവായ ആഴം: "$1" (റൂട്ട് തലത്തിനും മുകളിലുള്ള തലം എടുക്കാനുള്ള ശ്രമം)',
	'pfunc_expr_stack_exhausted' => 'എക്സ്‌പ്രെഷൻ പിഴവ്: സ്റ്റാക്ക് പുറന്തള്ളിയിരിക്കുന്നു',
	'pfunc_expr_unexpected_number' => 'പ്രയോഗരീതിയിൽ പിഴവ്: പ്രതീക്ഷിക്കാത്ത സംഖ്യ',
	'pfunc_expr_preg_match_failure' => 'പ്രയോഗരീതിയിൽ പിഴവ്: അപ്രതീക്ഷിതമായ preg_match പരാജയം',
	'pfunc_expr_unrecognised_word' => 'പ്രയോഗരീതിയിൽ പിഴവ്: "$1" എന്ന തിരിച്ചറിയാൻ സാധിക്കാഞ്ഞ വാക്ക്',
	'pfunc_expr_unexpected_operator' => 'പ്രയോഗരീതിയിൽ പിഴവ്: അപ്രതീക്ഷിതമായ $1 ഓപ്പറേറ്റർ',
	'pfunc_expr_missing_operand' => 'എക്സ്പ്രെഷൻ പിഴവ്: $1 എന്നതിനുള്ള പ്രവർത്തനഘടകം നൽകിയിട്ടില്ല',
	'pfunc_expr_unexpected_closing_bracket' => 'പ്രയോഗരീതിയിൽ പിഴവ്: അപ്രതീക്ഷിതമായി കോഷ്ഠകം അടച്ചിരിക്കുന്നു',
	'pfunc_expr_unrecognised_punctuation' => 'പ്രയോഗരീതിയിൽ പിഴവ്: തിരിച്ചറിയാൻ കഴിയാത്ത വിരാമചിഹ്നം "$1"',
	'pfunc_expr_unclosed_bracket' => 'പ്രയോഗരീതിയിൽ പിഴവ്: അടയ്ക്കാത്ത കോഷ്ഠകം',
	'pfunc_expr_division_by_zero' => 'പൂജ്യം കൊണ്ടുള്ള ഹരണം',
	'pfunc_expr_invalid_argument' => '$1:< -1 അല്ലെങ്കിൽ > 1 എന്നതിനു നൽകിയ അസാധുവായ ആർഗ്യുമെന്റ്',
	'pfunc_expr_invalid_argument_ln' => 'ln: <= 0 എന്നതിനു നൽകിയ അസാധുവായ ആർഗ്യുമെന്റ്',
	'pfunc_expr_unknown_error' => 'പ്രയോഗരീതിയിൽ പിഴവ്: കാരണം അജ്ഞാതമായ പിഴവ് ($1)',
	'pfunc_expr_not_a_number' => '$1-ൽ: ഫലം ഒരു സംഖ്യയല്ല',
	'pfunc_string_too_long' => 'പിഴവ്: പദം ലിപികളുടെ പരിധിയായ $1 അതിലംഘിക്കുന്നു',
	'pfunc-convert-dimensionmismatch' => 'പിഴവ്: "$1", "$2" എന്നീ ഏകകങ്ങൾ തമ്മിൽ പരിവർത്തിപ്പിക്കാനാവില്ല.',
	'pfunc-convert-unknownunit' => 'പിഴവ്: അപരിചിതമായ ഏകകം "$1".',
	'pfunc-convert-unknowndimension' => 'പിഴവ്: അപരിചിതമായ പരിമാണം "$1".',
	'pfunc-convert-invalidcompoundunit' => 'പിഴവ്: അസാധുവായ സംയുക്ത ഏകകം "$1".',
	'pfunc-convert-nounit' => 'പിഴവ്: സ്രോതസ്സ് ഏകകം നൽകിയിട്ടില്ല.',
	'pfunc-convert-dimension-length' => 'നീളം',
	'pfunc-convert-dimension-area' => 'വിസ്തീർണ്ണം',
	'pfunc-convert-dimension-volume' => 'വ്യാപ്തം',
	'pfunc-convert-dimension-time' => 'സമയം',
	'pfunc-convert-dimension-timesquared' => 'സമയം<sup>2</sup>',
	'pfunc-convert-dimension-mass' => 'പിണ്ഡം',
	'pfunc-convert-dimension-speed' => 'വേഗം',
	'pfunc-convert-dimension-temperature' => 'താപനില',
	'pfunc-convert-dimension-acceleration' => 'ത്വരണം',
	'pfunc-convert-dimension-force' => 'ബലം',
	'pfunc-convert-dimension-torque' => 'ടോർക്ക്',
	'pfunc-convert-dimension-energy' => 'ഊർജ്ജം',
	'pfunc-convert-dimension-power' => 'ശക്തി',
	'pfunc-convert-dimension-pressure' => 'മർദ്ദം',
	'pfunc-convert-dimension-density' => 'സാന്ദ്രത',
	'pfunc-convert-prefix-yotta' => 'യോട്ട',
	'pfunc-convert-prefix-zetta' => 'സീറ്റ',
	'pfunc-convert-prefix-exa' => 'എക്സാ',
	'pfunc-convert-prefix-peta' => 'പെറ്റാ',
	'pfunc-convert-prefix-tera' => 'ടെറാ',
	'pfunc-convert-prefix-giga' => 'ഗിഗാ',
	'pfunc-convert-prefix-mega' => 'മെഗാ',
	'pfunc-convert-prefix-kilo' => 'കിലോ',
	'pfunc-convert-prefix-hecto' => 'ഹെക്ടോ',
	'pfunc-convert-prefix-deca' => 'ഡെക്കാ',
	'pfunc-convert-prefix-deci' => 'ഡെസി',
	'pfunc-convert-prefix-centi' => 'സെന്റി',
	'pfunc-convert-prefix-milli' => 'മില്ലി',
	'pfunc-convert-prefix-micro' => 'മൈക്രോ',
	'pfunc-convert-prefix-nano' => 'നാനോ',
	'pfunc-convert-prefix-pico' => 'പൈകോ',
	'pfunc-convert-prefix-femto' => 'ഫെംറ്റോ',
	'pfunc-convert-prefix-atto' => 'അറ്റോ',
	'pfunc-convert-prefix-zepto' => 'സെപ്റ്റോ',
	'pfunc-convert-prefix-yocto' => 'യോക്റ്റോ',
	'pfunc-convert-prefix-milli-abbr' => 'മി.',
	'pfunc-convert-unit-length-metre' => '$1{{PLURAL:$2|$3മീറ്റർ|$3 മീറ്ററുകൾ}}',
	'pfunc-convert-unit-length-angstrom' => '$1{{PLURAL:$2|ആംസ്ട്രോം|ആംസ്ട്രോം}}',
	'pfunc-convert-unit-length-mile' => '$1{{PLURAL:$2|മൈൽ|മൈൽ}}',
	'pfunc-convert-unit-length-yard' => '$1{{PLURAL:$2|ഗജം|ഗജം}}',
	'pfunc-convert-unit-length-foot' => '$1{{PLURAL:$2|അടി|അടി}}',
	'pfunc-convert-unit-length-inch' => '$1{{PLURAL:$2|ഇഞ്ച്|ഇഞ്ച്}}',
	'pfunc-convert-unit-length-nauticalmile' => '$1{{PLURAL:$2|നോട്ടിക്കൽ മൈൽ|നോട്ടിക്കൽ മൈൽ}}',
	'pfunc-convert-unit-length-parsec' => '$1{{PLURAL:$2|$3പാർസെക്|$3പാർസെക്}}',
	'pfunc-convert-unit-length-lightyear' => '$1{{PLURAL:$2|$3പ്രകാശവർഷം|$3പ്രകാശവർഷങ്ങൾ}}',
	'pfunc-convert-unit-length-yard-abbr' => '$1ഗജം',
	'pfunc-convert-unit-length-foot-abbr' => '$1അടി',
	'pfunc-convert-unit-length-inch-abbr' => '$1ഇഞ്ച്',
	'pfunc-convert-unit-length-parsec-abbr' => '$1$3പാ.സെ.',
	'pfunc-convert-unit-length-lightyear-abbr' => '$1$3പ്ര.വ.',
	'pfunc-convert-unit-area-squarekilometre' => '$1{{PLURAL:$2|ചതുരശ്ര കിലോമീറ്റർ|ചതുരശ്ര കിലോമീറ്റർ}}',
	'pfunc-convert-unit-area-squaremetre' => '$1{{PLURAL:$2|ചതുരശ്ര മീറ്റർ|ചതുരശ്ര മീറ്റർ}}',
	'pfunc-convert-unit-area-squarecentimetre' => '$1{{PLURAL:$2|ചതുരശ്ര സെന്റീമീറ്റർ|ചതുരശ്ര സെന്റീമീറ്റർ}}',
	'pfunc-convert-unit-area-squaremillimetre' => '$1{{PLURAL:$2|ചതുരശ്ര മില്ലിമീറ്റർ|ചതുരശ്ര മില്ലിമീറ്റർ}}',
	'pfunc-convert-unit-area-hectare' => '$1{{PLURAL:$2|ഹെക്ടർ|ഹെക്ടർ}}',
	'pfunc-convert-unit-area-squaremile' => '$1{{PLURAL:$2|ചതുരശ്ര മൈൽ|ചതുരശ്ര മൈൽ}}',
	'pfunc-convert-unit-area-acre' => '$1{{PLURAL:$2|ഏക്കർ|ഏക്കർ}}',
	'pfunc-convert-unit-area-squareyard' => '$1{{PLURAL:$2|ചതുരശ്ര ഗജം|ചതുരശ്ര ഗജം}}',
	'pfunc-convert-unit-area-squarefoot' => '$1{{PLURAL:$2|ചതുരശ്ര അടി|ചതുരശ്ര അടി}}',
	'pfunc-convert-unit-area-squareinch' => '$1{{PLURAL:$2|ചതുരശ്ര ഇഞ്ച്|ചതുരശ്ര ഇഞ്ച്}}',
	'pfunc-convert-unit-area-squarenauticalmile' => '$1{{PLURAL:$2|ചതുരശ്ര നോട്ടിക്കൽ മൈൽ|ചതുരശ്ര നോട്ടിക്കൽ മൈൽ}}',
	'pfunc-convert-unit-area-squarekilometre-abbr' => '$1കി.മീ.<sup>2</sup>',
	'pfunc-convert-unit-area-squaremetre-abbr' => '$1മീ.<sup>2</sup>',
	'pfunc-convert-unit-area-squarecentimetre-abbr' => '$1സെ.മീ.<sup>2</sup>',
	'pfunc-convert-unit-area-squaremillimetre-abbr' => '$1മി.മീ.<sup>2</sup>',
	'pfunc-convert-unit-area-hectare-abbr' => '$1ഹെ.',
	'pfunc-convert-unit-area-squaremile-abbr' => '$1ചതു.മൈൽ',
	'pfunc-convert-unit-area-acre-abbr' => '$1ഏക്കർ',
	'pfunc-convert-unit-area-squareyard-abbr' => '$1ചതു.വാര',
	'pfunc-convert-unit-area-squarefoot-abbr' => '$1ചതു.അടി',
	'pfunc-convert-unit-area-squareinch-abbr' => '$1ചതു.ഇഞ്ച്',
	'pfunc-convert-unit-time-second' => '$1{{PLURAL:$2|സെക്കന്റ്|സെക്കന്റ്}}',
	'pfunc-convert-unit-time-year' => '$1{{PLURAL:$2|ഒരു വർഷം|$3 വർഷം}}',
	'pfunc-convert-unit-time-day' => '$1{{PLURAL:$2|ദിവസം|ദിവസം}}',
	'pfunc-convert-unit-time-hour' => '$1{{PLURAL:$2|മണിക്കൂർ|മണിക്കൂർ}}',
	'pfunc-convert-unit-time-minute' => '$1{{PLURAL:$2|മിനിറ്റ്|മിനിറ്റ്}}',
	'pfunc-convert-unit-time-second-abbr' => '$1സെ.',
	'pfunc-convert-unit-time-year-abbr' => '$1$3വർഷം',
	'pfunc-convert-unit-time-day-abbr' => '$1ദിവസം',
	'pfunc-convert-unit-time-hour-abbr' => '$1മണി.',
	'pfunc-convert-unit-time-minute-abbr' => '$1മിനി.',
	'pfunc-convert-unit-volume-cubicmetre' => '$1{{PLURAL:$2|ഘന മീറ്റർ|ഘന മീറ്റർ}}',
	'pfunc-convert-unit-volume-cubiccentimetre' => '$1{{PLURAL:$2|ഘന സെന്റീമീറ്റർ|ഘന സെന്റീമീറ്റർ}}',
	'pfunc-convert-unit-volume-cubicmillimetre' => '$1{{PLURAL:$2|ഘന മില്ലീമീറ്റർ|ഘന മില്ലീമീറ്റർ}}',
	'pfunc-convert-unit-volume-kilolitre' => '$1{{PLURAL:$2|കിലോലിറ്റർ|കിലോലിറ്റർ}}',
	'pfunc-convert-unit-volume-litre' => '$1{{PLURAL:$2|ലിറ്റർ|ലിറ്റർ}}',
	'pfunc-convert-unit-volume-centilitre' => '$1{{PLURAL:$2|സെന്റിലിറ്റർ|സെന്റിലിറ്റർ}}',
	'pfunc-convert-unit-volume-millilitre' => '$1{{PLURAL:$2|മില്ലിലിറ്റർ|മില്ലിലിറ്റർ}}',
	'pfunc-convert-unit-volume-cubicyard' => '$1{{PLURAL:$2|ഘന ഗജം|ഘന ഗജം}}',
	'pfunc-convert-unit-volume-cubicfoot' => '$1{{PLURAL:$2|ഘന അടി|ഘന അടി}}',
	'pfunc-convert-unit-volume-cubicinch' => '$1{{PLURAL:$2|ഘന ഇഞ്ച്|ഘന ഇഞ്ച്}}',
	'pfunc-convert-unit-volume-barrel' => '$1{{PLURAL:$2|ബാരൽ|ബാരൽ}}',
	'pfunc-convert-unit-volume-barreloil' => '$1{{PLURAL:$2|ബാരൽ|ബാരൽ}}',
	'pfunc-convert-unit-volume-barrelbeer' => '$1{{PLURAL:$2|ബാരൽ|ബാരൽ}}',
	'pfunc-convert-unit-volume-cubicmetre-abbr' => '$1മീ.<sup>3</sup>',
	'pfunc-convert-unit-volume-cubiccentimetre-abbr' => '$1സെ.മീ.<sup>3</sup>',
	'pfunc-convert-unit-volume-cubicmillimetre-abbr' => '$1മി.മീ.<sup>3</sup>',
	'pfunc-convert-unit-volume-litre-abbr' => '$1$3ലി.',
	'pfunc-convert-unit-volume-cubicyard-abbr' => '$1ഘന ഗജം',
	'pfunc-convert-unit-volume-cubicfoot-abbr' => '$1ഘ. അടി.',
	'pfunc-convert-unit-volume-cubicinch-abbr' => '$1ഘ. ഇഞ്ച്.',
	'pfunc-convert-unit-volume-barrel-abbr' => '$1ബാരൽ',
	'pfunc-convert-unit-volume-gallon-abbr' => '$1ഗാലൺ',
	'pfunc-convert-unit-volume-barreloil-abbr' => '$1ബാരൽ',
	'pfunc-convert-unit-speed-mile-hour' => '$1മൈൽ/മണിക്കൂർ',
	'pfunc-convert-unit-speed-mile-hour-abbr' => '$1മൈ./മണി.',
	'pfunc-convert-unit-pressure-pascal' => '$1{{PLURAL:$2|$3പാസ്കൽ|$3പാസ്കൽ}}',
	'pfunc-convert-unit-pressure-bar' => '$1ബാർ',
	'pfunc-convert-unit-pressure-decibar' => '$1ഡെസിബാർ',
	'pfunc-convert-unit-pressure-millibar' => '$1മില്ലിബാർ',
	'pfunc-convert-unit-pressure-mmhg' => '$1{{PLURAL:$2|രസം മില്ലിമീറ്ററിൽ|രസം മില്ലിമീറ്ററിൽ}}',
	'pfunc-convert-unit-pressure-inhg' => '$1{{PLURAL:$2|രസം ഇഞ്ചിൽ|രസം ഇഞ്ചിൽ}}',
	'pfunc-convert-unit-pressure-pascal-abbr' => '$1$3പാസ്ക.',
);

/** Marathi (मराठी)
 * @author Htt
 * @author Kaustubh
 */
$messages['mr'] = array(
	'pfunc_desc' => 'तार्किक कार्ये वापरून पार्सर वाढवा',
	'pfunc_time_error' => 'त्रुटी: चुकीचा वेळ',
	'pfunc_time_too_long' => 'त्रुटी: खूप जास्त #time कॉल्स',
	'pfunc_time_too_big' => 'चूक: #वेळ फक्त ९९९९ सालापर्यंतच्या वर्षांना समर्थन देते',
	'pfunc_rel2abs_invalid_depth' => 'त्रुटी: मार्गामध्ये चुकीची गहनता: "$1" (रूट नोडच्या वरील नोड शोधायचा प्रयत्न केला)',
	'pfunc_expr_stack_exhausted' => 'एक्स्प्रेशन त्रुटी: स्टॅक संपला',
	'pfunc_expr_unexpected_number' => 'एक्स्प्रेशन त्रुटी: अनपेक्षित क्रमांक',
	'pfunc_expr_preg_match_failure' => 'एक्स्प्रेशन त्रुटी: अनपेक्षित preg_match रद्दीकरण',
	'pfunc_expr_unrecognised_word' => 'एक्स्प्रेशन त्रुटी: अनोळखी शब्द "$1"',
	'pfunc_expr_unexpected_operator' => 'एक्स्प्रेशन त्रुटी: अनोळखी $1 कार्यवाहक',
	'pfunc_expr_missing_operand' => 'एक्स्प्रेशन त्रुटी: $1 चा घटक सापडला नाही',
	'pfunc_expr_unexpected_closing_bracket' => 'एक्स्प्रेशन त्रुटी: अनपेक्षित समाप्ती कंस',
	'pfunc_expr_unrecognised_punctuation' => 'एक्स्प्रेशन त्रुटी: अनोळखी उद्गारवाचक चिन्ह "$1"',
	'pfunc_expr_unclosed_bracket' => 'एक्स्प्रेशन त्रुटी: कंस समाप्त केलेला नाही',
	'pfunc_expr_division_by_zero' => 'शून्य ने भागाकार',
	'pfunc_expr_invalid_argument' => '$1 साठी अवैध अर्ग्युमेंट: < -1 किंवा > 1',
	'pfunc_expr_invalid_argument_ln' => 'ln करिता अवैध अर्ग्युमेंट: <= 0',
	'pfunc_expr_unknown_error' => 'एक्स्प्रेशन त्रुटी: अनोळखी त्रुटी ($1)',
	'pfunc_expr_not_a_number' => '$1 मध्ये: निकाल संख्येत नाही',
);

/** Malay (Bahasa Melayu)
 * @author Anakmalaysia
 * @author Aurora
 * @author Aviator
 * @author Kurniasan
 */
$messages['ms'] = array(
	'pfunc_desc' => 'Meningkatkan penghurai dengan fungsi-fungsi logik',
	'pfunc_time_error' => 'Ralat: waktu tidak sah',
	'pfunc_time_too_long' => 'Ralat: terlalu banyak panggilan #time',
	'pfunc_time_too_big' => 'Ralat: #time hanya menyokong tahun sehingga 9999',
	'pfunc_rel2abs_invalid_depth' => 'Ralat: Kedalaman tidak sah dalam laluan: "$1" (cubaan mencapai nod di atas nod induk)',
	'pfunc_expr_stack_exhausted' => 'Ralat ungkapan: Tindanan tuntas',
	'pfunc_expr_unexpected_number' => 'Ralat ungkapan: Nombor tidak dijangka',
	'pfunc_expr_preg_match_failure' => 'Ralat ungkapan: Kegagalan preg_match tidak dijangka',
	'pfunc_expr_unrecognised_word' => 'Ralat ungkapan: Perkataan "$1" tidak dikenali',
	'pfunc_expr_unexpected_operator' => 'Ralat ungkapan: Pengendali $1 tidak dijangka',
	'pfunc_expr_missing_operand' => 'Ralat ungkapan: Kendalian bagi $1 tiada',
	'pfunc_expr_unexpected_closing_bracket' => 'Ralat ungkapan: Penutup kurungan tidak dijangka',
	'pfunc_expr_unrecognised_punctuation' => 'Ralat ungkapan: Aksara tanda baca "$1" tidak dikenali',
	'pfunc_expr_unclosed_bracket' => 'Ralat ungkapan: Tanda kurung tidak ditutup',
	'pfunc_expr_division_by_zero' => 'Pembahagian dengan sifar',
	'pfunc_expr_invalid_argument' => 'Argumen bagi $1 tidak sah: < -1 atau > 1',
	'pfunc_expr_invalid_argument_ln' => 'Argumen bagi ln tidak sah: <= 0',
	'pfunc_expr_unknown_error' => 'Ralat ungkapan: Ralat tidak diketahui ($1)',
	'pfunc_expr_not_a_number' => 'Dalam $1: hasil bukan nombor',
	'pfunc_string_too_long' => 'Ralat: Rentetan melampaui batas aksara $1',
	'pfunc-convert-dimensionmismatch' => 'Ralat: Tidak boleh menukar antara unit-unit "$1" dan "$2".',
	'pfunc-convert-unknownunit' => 'Ralat: Unit "$1" tidak dikenali.',
	'pfunc-convert-unknowndimension' => 'Ralat: Matra "$1" tidak dikenali.',
	'pfunc-convert-invalidcompoundunit' => 'Ralat: Unit majmuk "$1" tidak sah.',
	'pfunc-convert-nounit' => 'Ralat: Tiada unit sumber yang diberikan.',
	'pfunc-convert-doublecompoundunit' => 'Ralat: Unit majmuk berganda seperti "$1" tidak boleh dihuraikan.',
	'pfunc-convert-dimension-length' => 'panjang',
	'pfunc-convert-dimension-area' => 'luas',
	'pfunc-convert-dimension-volume' => 'isipadu',
	'pfunc-convert-dimension-time' => 'masa',
	'pfunc-convert-dimension-timesquared' => 'masa<sup>2</sup>',
	'pfunc-convert-dimension-mass' => 'jisim',
	'pfunc-convert-dimension-speed' => 'kelajuan',
	'pfunc-convert-dimension-temperature' => 'suhu',
	'pfunc-convert-dimension-acceleration' => 'pecutan',
	'pfunc-convert-dimension-force' => 'daya',
	'pfunc-convert-dimension-torque' => 'tork',
	'pfunc-convert-dimension-energy' => 'tenaga',
	'pfunc-convert-dimension-power' => 'kuasa',
	'pfunc-convert-dimension-pressure' => 'tekanan',
	'pfunc-convert-dimension-density' => 'ketumpatan',
	'pfunc-convert-dimension-fuelefficiencypositive' => 'kecekapanbahanapipositif',
	'pfunc-convert-dimension-fuelefficiencynegative' => 'kecekapanbahanapinegatif',
	'pfunc-convert-prefix-yotta' => 'yotta',
	'pfunc-convert-prefix-zetta' => 'zetta',
	'pfunc-convert-prefix-exa' => 'eksa',
	'pfunc-convert-prefix-peta' => 'peta',
	'pfunc-convert-prefix-tera' => 'tera',
	'pfunc-convert-prefix-giga' => 'giga',
	'pfunc-convert-prefix-mega' => 'mega',
	'pfunc-convert-prefix-kilo' => 'kilo',
	'pfunc-convert-prefix-hecto' => 'hekto',
	'pfunc-convert-prefix-deca' => 'deka',
	'pfunc-convert-prefix-deci' => 'desi',
	'pfunc-convert-prefix-centi' => 'senti',
	'pfunc-convert-prefix-milli' => 'mili',
	'pfunc-convert-prefix-micro' => 'mikro',
	'pfunc-convert-prefix-nano' => 'nano',
	'pfunc-convert-prefix-pico' => 'piko',
	'pfunc-convert-prefix-femto' => 'femto',
	'pfunc-convert-prefix-atto' => 'atto',
	'pfunc-convert-prefix-zepto' => 'zepto',
	'pfunc-convert-prefix-yocto' => 'yokto',
	'pfunc-convert-prefix-milli-abbr' => 'm',
	'pfunc-convert-unit-length-metre' => '$1{{PLURAL:$2|$3meter|$3meter}}',
	'pfunc-convert-unit-length-angstrom' => '$1{{PLURAL:$2|angstrom|angstrom}}',
	'pfunc-convert-unit-length-mile' => '$1{{PLURAL:$2|batu|batu}}',
	'pfunc-convert-unit-length-furlong' => '$1{{PLURAL:$2|furlong|furlong}}',
	'pfunc-convert-unit-length-chain' => '$1{{PLURAL:$2|rantai|rantai}}',
	'pfunc-convert-unit-length-rod' => '$1{{PLURAL:$2|pol|pol}}',
	'pfunc-convert-unit-length-fathom' => '$1{{PLURAL:$2|fatom|fatom}}',
	'pfunc-convert-unit-length-yard' => '$1{{PLURAL:$2|ela|ela}}',
	'pfunc-convert-unit-length-foot' => '$1{{PLURAL:$2|kaki|kaki}}',
	'pfunc-convert-unit-length-hand' => '$1{{PLURAL:$2|tangan|tangan}}',
	'pfunc-convert-unit-length-inch' => '$1{{PLURAL:$2|inci|inci}}',
	'pfunc-convert-unit-length-nauticalmile' => '$1{{PLURAL:$2|batu nautika|batu nautika}}',
	'pfunc-convert-unit-length-nauticalmileuk' => '$1{{PLURAL:$2|batu nautika (British pra-1970)|batu nautika (British pra-1970)}}',
	'pfunc-convert-unit-length-nauticalmileus' => '$1{{PLURAL:$2|batu nautika (AS pra-1954)|batu nautika (AS pra-1954)}}',
	'pfunc-convert-unit-length-parsec' => '$1{{PLURAL:$2|$3parsek|$3parsek}}',
	'pfunc-convert-unit-length-lightyear' => '$1{{PLURAL:$2|$3tahun cahaya|$3tahun cahaya}}',
	'pfunc-convert-unit-length-astronomicalunit' => '$1{{PLURAL:$2|unit astronomi|unit astronomi}}',
	'pfunc-convert-unit-length-furlong-abbr' => '$1furlong',
	'pfunc-convert-unit-length-chain-abbr' => '$1rantai',
	'pfunc-convert-unit-length-rod-abbr' => '$1pol',
	'pfunc-convert-unit-length-fathom-abbr' => '$1fatom',
	'pfunc-convert-unit-length-yard-abbr' => '$1ela',
	'pfunc-convert-unit-length-foot-abbr' => '$1kaki',
	'pfunc-convert-unit-length-hand-abbr' => '$1tgn',
	'pfunc-convert-unit-length-inch-abbr' => '$1in',
	'pfunc-convert-unit-length-nauticalmile-abbr' => '$1batu n',
	'pfunc-convert-unit-length-nauticalmileuk-abbr' => '$1batu n (Brit)',
	'pfunc-convert-unit-length-nauticalmileus-abbr' => '$1batu n (AS pra-1954)',
	'pfunc-convert-unit-length-parsec-abbr' => '$1$3pc',
	'pfunc-convert-unit-length-lightyear-abbr' => '$1$3tc',
	'pfunc-convert-unit-length-astronomicalunit-abbr' => '$1AU',
	'pfunc-convert-unit-area-squarekilometre' => '$1{{PLURAL:$2|kilometer persegi|kilometer persegi}}',
	'pfunc-convert-unit-area-squaremetre' => '$1{{PLURAL:$2|meter persegi|meter persegi}}',
	'pfunc-convert-unit-area-squarecentimetre' => '$1{{PLURAL:$2|sentimeter persegi|sentimeter persegi}}',
	'pfunc-convert-unit-area-squaremillimetre' => '$1{{PLURAL:$2|milimeter persegi|milimeter persegi}}',
	'pfunc-convert-unit-area-hectare' => '$1{{PLURAL:$2|hektar|hektar}}',
	'pfunc-convert-unit-area-squaremile' => '$1{{PLURAL:$2|batu persegi|batu persegi}}',
	'pfunc-convert-unit-area-acre' => '$1{{PLURAL:$2|ekar|ekar}}',
	'pfunc-convert-unit-area-squareyard' => '$1{{PLURAL:$2|ela persegi|ela persegi}}',
	'pfunc-convert-unit-area-squarefoot' => '$1{{PLURAL:$2|kaki persegi|kaki persegi}}',
	'pfunc-convert-unit-area-squareinch' => '$1{{PLURAL:$2|inci persegi|inci persegi}}',
	'pfunc-convert-unit-area-squarenauticalmile' => '$1{{PLURAL:$2|batu nautika persegi|batu nautika persegi}}',
	'pfunc-convert-unit-area-dunam' => '$1{{PLURAL:$2|dunam|dunam}}',
	'pfunc-convert-unit-area-tsubo' => '$1{{PLURAL:$2|tsubo|tsubo}}',
	'pfunc-convert-unit-area-squarekilometre-abbr' => '$1km<sup>2</sup>',
	'pfunc-convert-unit-area-squaremetre-abbr' => '$1m<sup>2</sup>',
	'pfunc-convert-unit-area-squarecentimetre-abbr' => '$1cm<sup>2</sup>',
	'pfunc-convert-unit-area-squaremillimetre-abbr' => '$1mm<sup>2</sup>',
	'pfunc-convert-unit-area-hectare-abbr' => '$1ha',
	'pfunc-convert-unit-area-squaremile-abbr' => '$1batu<sup>2</sup>',
	'pfunc-convert-unit-area-acre-abbr' => '$1ekar',
	'pfunc-convert-unit-area-squareyard-abbr' => '$1ela<sup>2</sup>',
	'pfunc-convert-unit-area-squarefoot-abbr' => '$1kaki<sup>2</sup>',
	'pfunc-convert-unit-area-squareinch-abbr' => '$1inci<sup>2</sup>',
	'pfunc-convert-unit-area-squarenauticalmile-abbr' => '$1batu n<sup>2</sup>',
	'pfunc-convert-unit-area-dunam-abbr' => '$1dunam',
	'pfunc-convert-unit-area-tsubo-abbr' => '$1tsubo',
	'pfunc-convert-unit-time-second' => '$1{{PLURAL: $2|saat|saat}}',
	'pfunc-convert-unit-time-year' => '$1{{PLURAL: $2|$3tahun|$3tahun}}',
	'pfunc-convert-unit-time-day' => '$1{{PLURAL:$2|hari|hari}}',
	'pfunc-convert-unit-time-hour' => '$1{{PLURAL:$2|jam|jam}}',
	'pfunc-convert-unit-time-minute' => '$1{{PLURAL:$2|minit|minit}}',
	'pfunc-convert-unit-time-second-abbr' => '$1s',
	'pfunc-convert-unit-time-year-abbr' => '$1$3thn',
	'pfunc-convert-unit-time-day-abbr' => '$1hari',
	'pfunc-convert-unit-time-hour-abbr' => '$1jam',
	'pfunc-convert-unit-time-minute-abbr' => '$1min',
	'pfunc-convert-unit-volume-cubicmetre' => '$1{{PLURAL:$2|meter padu|meter padu}}',
	'pfunc-convert-unit-volume-cubiccentimetre' => '$1{{PLURAL:$2|sentimeter padu|sentimeter padu}}',
	'pfunc-convert-unit-volume-cubicmillimetre' => '$1{{PLURAL:$2|milimeter padu|milimeter padu}}',
	'pfunc-convert-unit-volume-kilolitre' => '$1{{PLURAL:$2|kilolite|kiloliter}}',
	'pfunc-convert-unit-volume-litre' => '$1{{PLURAL:$2|liter|liter}}',
	'pfunc-convert-unit-volume-centilitre' => '$1{{PLURAL:$2|sentiliter|sentiliter}}',
	'pfunc-convert-unit-volume-millilitre' => '$1{{PLURAL:$2|mililiter|mililiter}}',
	'pfunc-convert-unit-volume-cubicyard' => '$1{{PLURAL:$2|ela padu|ela padu}}',
	'pfunc-convert-unit-volume-cubicfoot' => '$1{{PLURAL:$2|kaki padu|kaki padu}}',
	'pfunc-convert-unit-volume-cubicinch' => '$1{{PLURAL:$2|inci padu|inci padu}}',
	'pfunc-convert-unit-volume-barrel' => '$1{{PLURAL:$2|tong|tong}}',
	'pfunc-convert-unit-volume-bushel' => '$1{{PLURAL:$2|busyel|busyel}}',
	'pfunc-convert-unit-volume-gallon' => '$1{{PLURAL:$2|gelen|gelen}}',
	'pfunc-convert-unit-volume-quart' => '$1{{PLURAL:$2|kuart|kuart}}',
	'pfunc-convert-unit-volume-pint' => '$1{{PLURAL:$2|pain|pain}}',
	'pfunc-convert-unit-volume-fluidounce' => '$1{{PLURAL:$2|auns bendalir|auns bendalir}}',
	'pfunc-convert-unit-volume-barrelus' => '$1{{PLURAL:$2|tong AS|tong AS}}',
	'pfunc-convert-unit-volume-barreloil' => '$1{{PLURAL:$2|tong|tong}}',
	'pfunc-convert-unit-volume-barrelbeer' => '$1{{PLURAL:$2|tong|tong}}',
	'pfunc-convert-unit-volume-usgallon' => '$1{{PLURAL:$2|gelen AS|gelen AS}}',
	'pfunc-convert-unit-volume-usquart' => '$1{{PLURAL:$2|kuart AS|kuart AS}}',
	'pfunc-convert-unit-volume-uspint' => '$1{{PLURAL:$2|pain AS|pain AS}}',
	'pfunc-convert-unit-volume-usfluidounce' => '$1{{PLURAL:$2|auns bendalir AS|auns bendalir AS}}',
	'pfunc-convert-unit-volume-usdrybarrel' => '$1{{PLURAL:$2|tong kering AS|tong kering AS}}',
	'pfunc-convert-unit-volume-usbushel' => '$1{{PLURAL:$2|busyel AS|busyel AS}}',
	'pfunc-convert-unit-volume-usdrygallon' => '$1{{PLURAL:$2|gelen kering AS|gelen kering AS}}',
	'pfunc-convert-unit-volume-usdryquart' => '$1{{PLURAL:$2|kuart kering AS|kuart kering AS}}',
	'pfunc-convert-unit-volume-usdrypint' => '$1{{PLURAL:$2|pain kering AS|pain kering AS}}',
	'pfunc-convert-unit-volume-cubicmetre-abbr' => '$1m<sup>3</sup>',
	'pfunc-convert-unit-volume-cubiccentimetre-abbr' => '$1cm<sup>3</sup>',
	'pfunc-convert-unit-volume-cubicmillimetre-abbr' => '$1mm<sup>3</sup>',
	'pfunc-convert-unit-volume-litre-abbr' => '$1$3l',
	'pfunc-convert-unit-volume-cubicyard-abbr' => '$1ela<sup>3</sup>',
	'pfunc-convert-unit-volume-cubicfoot-abbr' => '$1kaki<sup>3</sup>',
	'pfunc-convert-unit-volume-cubicinch-abbr' => '$1inci<sup>3</sup>',
	'pfunc-convert-unit-volume-barrel-abbr' => '$1tong',
	'pfunc-convert-unit-volume-bushel-abbr' => '$1bsh',
	'pfunc-convert-unit-volume-gallon-abbr' => '$1gal',
	'pfunc-convert-unit-volume-quart-abbr' => '$1qt',
	'pfunc-convert-unit-volume-pint-abbr' => '$1pt',
	'pfunc-convert-unit-volume-fluidounce-abbr' => '$1fl oz',
	'pfunc-convert-unit-volume-barrelus-abbr' => '$1tong AS',
	'pfunc-convert-unit-volume-barreloil-abbr' => '$1tong',
	'pfunc-convert-unit-volume-barrelbeer-abbr' => '$1tong',
	'pfunc-convert-unit-volume-usgallon-abbr' => '$1gal AS',
	'pfunc-convert-unit-volume-usquart-abbr' => '$1qt AS',
	'pfunc-convert-unit-volume-uspint-abbr' => '$1pt AS',
	'pfunc-convert-unit-volume-usfluidounce-abbr' => '$1fl oz AS',
	'pfunc-convert-unit-volume-usdrybarrel-abbr' => '$1tong AS',
	'pfunc-convert-unit-volume-usbushel-abbr' => '$1bsh AS',
	'pfunc-convert-unit-volume-usdrygallon-abbr' => '$1gal kering AS',
	'pfunc-convert-unit-volume-usdryquart-abbr' => '$1qt kering AS',
	'pfunc-convert-unit-volume-usdrypint-abbr' => '$1pt kering AS',
	'pfunc-convert-unit-speed-mile-hour' => '$1batu sejam',
	'pfunc-convert-unit-speed-speedoflight' => '$1c',
	'pfunc-convert-unit-speed-mile-hour-abbr' => '$1bsj',
	'pfunc-convert-unit-speed-speedoflight-abbr' => '$1c',
	'pfunc-convert-unit-pressure-pascal' => '$1{{PLURAL:$2|$3pascal|$3pascal}}',
	'pfunc-convert-unit-pressure-bar' => '$1bar',
	'pfunc-convert-unit-pressure-decibar' => '$1desibar',
	'pfunc-convert-unit-pressure-millibar' => '$1milibar',
	'pfunc-convert-unit-pressure-kilobarye' => '$1kilobarye',
	'pfunc-convert-unit-pressure-barye' => '$1barye',
	'pfunc-convert-unit-pressure-atmosphere' => '$1{{PLURAL:$2|atmosfera|atmosfera}}',
	'pfunc-convert-unit-pressure-torr' => '$1{{PLURAL:$2|Torr|Torr}}',
	'pfunc-convert-unit-pressure-mmhg' => '$1{{PLURAL:$2|milimeter raksa|milimeter raksa}}',
	'pfunc-convert-unit-pressure-inhg' => '$1{{PLURAL:$2|inci raksa|inci raksa}}',
	'pfunc-convert-unit-pressure-psi' => '$1{{PLURAL:$2|paun seinci persegi|paun seinci persegi}}',
	'pfunc-convert-unit-pressure-pascal-abbr' => '$1$3Pa',
	'pfunc-convert-unit-pressure-bar-abbr' => '$1bar',
	'pfunc-convert-unit-pressure-decibar-abbr' => '$1dbar',
	'pfunc-convert-unit-pressure-millibar-abbr' => '$1mbar',
	'pfunc-convert-unit-pressure-kilobarye-abbr' => '$1kBa',
	'pfunc-convert-unit-pressure-barye-abbr' => '$1Ba',
	'pfunc-convert-unit-pressure-atmosphere-abbr' => '$1atm',
	'pfunc-convert-unit-pressure-torr-abbr' => '$1Torr',
	'pfunc-convert-unit-pressure-mmhg-abbr' => '$1mmHg',
	'pfunc-convert-unit-pressure-inhg-abbr' => '$1inHg',
	'pfunc-convert-unit-pressure-psi-abbr' => '$1psi',
);

/** Erzya (Эрзянь)
 * @author Botuzhaleny-sodamo
 */
$messages['myv'] = array(
	'pfunc_time_error' => 'Ильведевксэсь: амаштовикс шкась',
	'pfunc_expr_stack_exhausted' => 'Ёвтавкссонть ильведевкс: стекесь тыц пешксе',
	'pfunc_expr_division_by_zero' => 'Нольсэ йавома',
);

/** Nahuatl (Nāhuatl)
 * @author Fluence
 */
$messages['nah'] = array(
	'pfunc_time_error' => 'Ahcuallōtl: ahcualli cāhuitl',
);

/** Low German (Plattdüütsch)
 * @author Slomox
 */
$messages['nds'] = array(
	'pfunc_desc' => 'Beriekert den Parser mit logische Funkschonen',
	'pfunc_time_error' => 'Fehler: mit de Tiet stimmt wat nich',
	'pfunc_time_too_long' => 'Fehler: #time warrt to faken opropen',
	'pfunc_rel2abs_invalid_depth' => 'Fehler: Mit den Padd „$1“ stimmt wat nich, liggt nich ünner den Wuddelorner',
	'pfunc_expr_stack_exhausted' => 'Fehler in’n Utdruck: Stack överlopen',
	'pfunc_expr_unexpected_number' => 'Fehler in’n Utdruck: Unverwacht Tall',
	'pfunc_expr_preg_match_failure' => 'Fehler in’n Utdruck: Unverwacht Fehler bi „preg_match“',
	'pfunc_expr_unrecognised_word' => 'Fehler in’n Utdruck: Woort „$1“ nich kennt',
	'pfunc_expr_unexpected_operator' => 'Fehler in’n Utdruck: Unverwacht Operator $1',
	'pfunc_expr_missing_operand' => 'Fehler in’n Utdruck: Operand för $1 fehlt',
	'pfunc_expr_unexpected_closing_bracket' => 'Fehler in’n Utdruck: Unverwacht Klammer to',
	'pfunc_expr_unrecognised_punctuation' => 'Fehler in’n Utdruck: Satzteken „$1“ nich kennt',
	'pfunc_expr_unclosed_bracket' => 'Fehler in’n Utdruck: Nich slatene Klammer',
	'pfunc_expr_division_by_zero' => 'Delen dör Null',
	'pfunc_expr_invalid_argument' => 'Ungüllig Argument för $1: < -1 oder > 1',
	'pfunc_expr_invalid_argument_ln' => 'Ungüllig Argument för ln: <= 0',
	'pfunc_expr_unknown_error' => 'Fehler in’n Utdruck: Unbekannten Fehler ($1)',
	'pfunc_expr_not_a_number' => 'In $1: wat rutkamen is, is kene Tall',
);

/** Nepali (नेपाली) */
$messages['ne'] = array(
	'pfunc_time_error' => 'त्रुटी: गलत/वा हुदैनहुने समय',
	'pfunc_time_too_long' => 'त्रुटी: एकदम धेरै #time callहरु',
	'pfunc_rel2abs_invalid_depth' => 'त्रुटी: पाथमा (इनभ्यालिड)गलत गहिराइ(डेप्थ) भयो: "$1" (ले रुट नोड भन्दापनि माथिको नोडलाइ चलाउन(एकसेस) गर्न खोज्यो)',
);

/** Dutch (Nederlands)
 * @author SPQRobin
 * @author Siebrand
 */
$messages['nl'] = array(
	'pfunc_desc' => 'Verrijkt de parser met logische functies',
	'pfunc_time_error' => 'Fout: ongeldige tijd',
	'pfunc_time_too_long' => 'Fout: #time te vaak aangeroepen',
	'pfunc_time_too_big' => 'Fout: #time ondersteunt jaren tot maximaal 9999',
	'pfunc_rel2abs_invalid_depth' => 'Fout: ongeldige diepte in pad: "$1" (probeerde een node boven de stamnode aan te roepen)',
	'pfunc_expr_stack_exhausted' => 'Fout in uitdrukking: stack uitgeput',
	'pfunc_expr_unexpected_number' => 'Fout in uitdrukking: onverwacht getal',
	'pfunc_expr_preg_match_failure' => 'Fout in uitdrukking: onverwacht falen van preg_match',
	'pfunc_expr_unrecognised_word' => 'Fout in uitdrukking: woord "$1" niet herkend',
	'pfunc_expr_unexpected_operator' => 'Fout in uitdrukking: niet verwachte operator $1',
	'pfunc_expr_missing_operand' => 'Fout in uitdrukking: operand voor $1 mist',
	'pfunc_expr_unexpected_closing_bracket' => 'Fout in uitdrukking: haakje sluiten op onverwachte plaats',
	'pfunc_expr_unrecognised_punctuation' => 'Fout in uitdrukking: niet herkend leesteken "$1"',
	'pfunc_expr_unclosed_bracket' => 'Fout in uitdrukking: niet gesloten haakje openen',
	'pfunc_expr_division_by_zero' => 'Deling door nul',
	'pfunc_expr_invalid_argument' => 'Ongeldige parameter voor $1: < -1 of > 1',
	'pfunc_expr_invalid_argument_ln' => 'Ongeldige parameter voor ln: <= 0',
	'pfunc_expr_unknown_error' => 'Fout in uitdrukking: onbekende fout ($1)',
	'pfunc_expr_not_a_number' => 'In $1: resultaat is geen getal',
	'pfunc_string_too_long' => 'Fout: De tekst is langer dan de limiet van $1 {{PLURAL:$1|karakter|karakters}}',
	'pfunc-convert-dimensionmismatch' => 'Fout: het is niet mogelijk te converteren tussen de eenheden van "$1" en "$2".',
	'pfunc-convert-unknownunit' => 'Fout: onbekende eenheid "$1".',
	'pfunc-convert-unknowndimension' => 'Fout: Onbekende afmeting "$1".',
	'pfunc-convert-invalidcompoundunit' => 'Fout: Ongeldige samengestelde eenheid "$1".',
	'pfunc-convert-nounit' => 'Fout: Geen broneenheid opgegeven.',
	'pfunc-convert-doublecompoundunit' => 'Fout: het is niet mogelijk samengestelde eenheden zoals "$1" te verwerken.',
	'pfunc-convert-dimension-length' => 'lengte',
	'pfunc-convert-dimension-area' => 'oppervlakte',
	'pfunc-convert-dimension-volume' => 'inhoud',
	'pfunc-convert-dimension-time' => 'tijd',
	'pfunc-convert-dimension-timesquared' => 'tijd<sup>2</sup>',
	'pfunc-convert-dimension-mass' => 'massa',
	'pfunc-convert-dimension-speed' => 'snelheid',
	'pfunc-convert-dimension-temperature' => 'temperatuur',
	'pfunc-convert-dimension-acceleration' => 'versnelling',
	'pfunc-convert-dimension-force' => 'kracht',
	'pfunc-convert-dimension-torque' => 'koppel',
	'pfunc-convert-dimension-energy' => 'energie',
	'pfunc-convert-dimension-power' => 'vermogen',
	'pfunc-convert-dimension-pressure' => 'druk',
	'pfunc-convert-dimension-density' => 'dichtheid',
	'pfunc-convert-dimension-fuelefficiencypositive' => 'brandstofefficientiepositief',
	'pfunc-convert-dimension-fuelefficiencynegative' => 'brandstofefficientienegatief',
	'pfunc-convert-prefix-yotta' => 'yotta',
	'pfunc-convert-prefix-zetta' => 'zetta',
	'pfunc-convert-prefix-exa' => 'exa',
	'pfunc-convert-prefix-peta' => 'peta',
	'pfunc-convert-prefix-tera' => 'tera',
	'pfunc-convert-prefix-giga' => 'giga',
	'pfunc-convert-prefix-mega' => 'mega',
	'pfunc-convert-prefix-kilo' => 'kilo',
	'pfunc-convert-prefix-hecto' => 'hecto',
	'pfunc-convert-prefix-deca' => 'deca',
	'pfunc-convert-prefix-deci' => 'deci',
	'pfunc-convert-prefix-centi' => 'centi',
	'pfunc-convert-prefix-milli' => 'milli',
	'pfunc-convert-prefix-micro' => 'micro',
	'pfunc-convert-prefix-nano' => 'nano',
	'pfunc-convert-prefix-pico' => 'pico',
	'pfunc-convert-prefix-femto' => 'femto',
	'pfunc-convert-prefix-atto' => 'atto',
	'pfunc-convert-prefix-zepto' => 'zepto',
	'pfunc-convert-prefix-yocto' => 'yocto',
	'pfunc-convert-prefix-milli-abbr' => 'm',
	'pfunc-convert-unit-length-metre' => '$1{{PLURAL:$2|meter|meter}}',
	'pfunc-convert-unit-length-angstrom' => '$1{{PLURAL:$2|angstrom|angstrom}}',
	'pfunc-convert-unit-length-mile' => '$1{{PLURAL:$2|mijl|mijl}}',
	'pfunc-convert-unit-length-furlong' => '$1{{PLURAL:$2|furlong|furlong}}',
	'pfunc-convert-unit-length-chain' => '$1{{PLURAL:$2|chain|chains}}',
	'pfunc-convert-unit-length-rod' => '$1{{PLURAL:$2|roede|roede}}',
	'pfunc-convert-unit-length-fathom' => '$1{{PLURAL:$2|vadem|vadem}}',
	'pfunc-convert-unit-length-yard' => '$1{{PLURAL:$2|yard|yards}}',
	'pfunc-convert-unit-length-foot' => '$1{{PLURAL:$2|voet|voet}}',
	'pfunc-convert-unit-length-hand' => '$1{{PLURAL:$2|hand|handen}}',
	'pfunc-convert-unit-length-inch' => '$1{{PLURAL:$2|inch|inches}}',
	'pfunc-convert-unit-length-nauticalmile' => '$1{{PLURAL:$2|nautische mijl|nautische mijlen}}',
	'pfunc-convert-unit-length-nauticalmileuk' => '$1{{PLURAL:$2|nautische mijl (Brits, voor 1970)|nautische mijlen (Brits, voor 1970)}}',
	'pfunc-convert-unit-length-nauticalmileus' => '$1{{PLURAL:$2|nautische mijl (VS, voor 1954)|nautische mijlen (VS, voor 1954)}}',
	'pfunc-convert-unit-length-parsec' => '$1{{PLURAL:$2|$3 parsec|$3 parsecs}}',
	'pfunc-convert-unit-length-lightyear' => '$1{{PLURAL:$2|$3 lichtjaar|$3 lichtjaren}}',
	'pfunc-convert-unit-length-astronomicalunit' => '$1{{PLURAL:$2|astronomische eenheid|astronomische eenheden}}',
	'pfunc-convert-unit-length-furlong-abbr' => '$1furlong',
	'pfunc-convert-unit-length-chain-abbr' => '$1chain',
	'pfunc-convert-unit-length-rod-abbr' => '$1rd',
	'pfunc-convert-unit-length-fathom-abbr' => '$1fath',
	'pfunc-convert-unit-length-yard-abbr' => '$1yd',
	'pfunc-convert-unit-length-foot-abbr' => '$1ft',
	'pfunc-convert-unit-length-hand-abbr' => '$1h',
	'pfunc-convert-unit-length-inch-abbr' => '$1in',
	'pfunc-convert-unit-length-nauticalmile-abbr' => '$1NM',
	'pfunc-convert-unit-length-nauticalmileuk-abbr' => '$1MN (Brits)',
	'pfunc-convert-unit-length-nauticalmileus-abbr' => '$1MN (VS voor 1954)',
	'pfunc-convert-unit-length-parsec-abbr' => '$1$3pc',
	'pfunc-convert-unit-length-lightyear-abbr' => '$1$3lj',
	'pfunc-convert-unit-length-astronomicalunit-abbr' => '$1AE',
	'pfunc-convert-unit-area-squarekilometre' => '$1{{PLURAL:$2|vierkante kilometer|vierkante kilometer}}',
	'pfunc-convert-unit-area-squaremetre' => '$1{{PLURAL:$2|vierkante meter|vierkante meter}}',
	'pfunc-convert-unit-area-squarecentimetre' => '$1{{PLURAL:$2|vierkante centimeter|vierkante centimeter}}',
	'pfunc-convert-unit-area-squaremillimetre' => '$1{{PLURAL:$2|vierkante millimeter|vierkante millimeter}}',
	'pfunc-convert-unit-area-hectare' => '$1{{PLURAL:$2|hectare|hectare}}',
	'pfunc-convert-unit-area-squaremile' => '$1{{PLURAL:$2|vierkante mijl|vierkante mijl}}',
	'pfunc-convert-unit-area-acre' => '$1{{PLURAL:$2|acre|acres}}',
	'pfunc-convert-unit-area-squareyard' => '$1{{PLURAL:$2|vierkante yard|vierkante yards}}',
	'pfunc-convert-unit-area-squarefoot' => '$1{{PLURAL:$2|voerkante foot|vierkante foot}}',
	'pfunc-convert-unit-area-squareinch' => '$1{{PLURAL:$2|vierkante inch|vierkante inches}}',
	'pfunc-convert-unit-area-squarenauticalmile' => '$1{{PLURAL:$2|vierkante nautische mijl|vierkante nautische mijlen}}',
	'pfunc-convert-unit-area-dunam' => '$1{{PLURAL:$2|dunam|dunams}}',
	'pfunc-convert-unit-area-tsubo' => '$1{{PLURAL:$2|tsubo|tsubo}}',
	'pfunc-convert-unit-area-squarekilometre-abbr' => '$1km<sup>2</sup>',
	'pfunc-convert-unit-area-squaremetre-abbr' => '$1m<sup>2</sup>',
	'pfunc-convert-unit-area-squarecentimetre-abbr' => '$1cm<sup>2</sup>',
	'pfunc-convert-unit-area-squaremillimetre-abbr' => '$1mm<sup>2</sup>',
	'pfunc-convert-unit-area-hectare-abbr' => '$1ha',
	'pfunc-convert-unit-area-squaremile-abbr' => '$1sq mi',
	'pfunc-convert-unit-area-acre-abbr' => '$1acre',
	'pfunc-convert-unit-area-squareyard-abbr' => '$1sq yd',
	'pfunc-convert-unit-area-squarefoot-abbr' => '$1sq ft',
	'pfunc-convert-unit-area-squareinch-abbr' => '$1sq in',
	'pfunc-convert-unit-area-squarenauticalmile-abbr' => '$1vierkante mijl',
	'pfunc-convert-unit-area-dunam-abbr' => '$1dunam',
	'pfunc-convert-unit-area-tsubo-abbr' => '$1tsubo',
	'pfunc-convert-unit-time-second' => '$1{{PLURAL:$2|seconde|seconden}}',
	'pfunc-convert-unit-time-year' => '$1{{PLURAL:$2|$3jaar|$3jaren}}',
	'pfunc-convert-unit-time-day' => '$1{{PLURAL:$2|dag|dagen}}',
	'pfunc-convert-unit-time-hour' => '$1{{PLURAL:$2|uur|uur}}',
	'pfunc-convert-unit-time-minute' => '$1{{PLURAL:$2|minuut|minuten}}',
	'pfunc-convert-unit-time-second-abbr' => '$1sec.',
	'pfunc-convert-unit-time-year-abbr' => '$1$3jaar',
	'pfunc-convert-unit-time-day-abbr' => '$1dag',
	'pfunc-convert-unit-time-hour-abbr' => '$1uur',
	'pfunc-convert-unit-time-minute-abbr' => '$1min',
	'pfunc-convert-unit-volume-cubicmetre' => '$1{{PLURAL:$2| kubieke meter|kubieke meter}}',
	'pfunc-convert-unit-volume-cubiccentimetre' => '$1{{PLURAL:$2|kubieke centimeter|kubieke centimeter}}',
	'pfunc-convert-unit-volume-cubicmillimetre' => '$1{{PLURAL:$2|kubieke millimeter|kubieke millimeter}}',
	'pfunc-convert-unit-volume-kilolitre' => '$1{{PLURAL:$2|kiloliter|kiloliter}}',
	'pfunc-convert-unit-volume-litre' => '$1{{PLURAL:$2|liter|liter}}',
	'pfunc-convert-unit-volume-centilitre' => '$1{{PLURAL:$2|centiliters|centiliter}}',
	'pfunc-convert-unit-volume-millilitre' => '$1{{PLURAL:$2|milliliter|milliliter}}',
	'pfunc-convert-unit-volume-cubicyard' => '$1{{PLURAL:$2|kubieke yard|kubieke yard}}',
	'pfunc-convert-unit-volume-cubicfoot' => '$1{{PLURAL:$2|kubieke voet|kubieke voet}}',
	'pfunc-convert-unit-volume-cubicinch' => '$1{{PLURAL:$2|kubieke inch|kubieke inch}}',
	'pfunc-convert-unit-volume-barrel' => '$1{{PLURAL:$2|vat|vaten}}',
	'pfunc-convert-unit-volume-bushel' => '$1{{PLURAL:$2|bushel|bushels}}',
	'pfunc-convert-unit-volume-gallon' => '$1{{PLURAL:$2|gallon|gallon}}',
	'pfunc-convert-unit-volume-quart' => '$1{{PLURAL:$2|quart|quart}}',
	'pfunc-convert-unit-volume-pint' => '$1{{PLURAL:$2|pint|pints}}',
	'pfunc-convert-unit-volume-fluidounce' => '$1{{PLURAL:$2|fluid ounce|fluid ounces}}',
	'pfunc-convert-unit-volume-barrelus' => '$1{{PLURAL:$2|VS-vat|VS-vaten}}',
	'pfunc-convert-unit-volume-barreloil' => '$1{{PLURAL:$2|vat|vaten}}',
	'pfunc-convert-unit-volume-barrelbeer' => '$1{{PLURAL:$2|vat|vaten}}',
	'pfunc-convert-unit-volume-usgallon' => '$1{{PLURAL:$2|VS-gallon|VS-gallon}}',
	'pfunc-convert-unit-volume-usquart' => '$1{{PLURAL:$2|VS-quart|VS-quart}}',
	'pfunc-convert-unit-volume-uspint' => '$1{{PLURAL:$2|VS-pint|VS-pints}}',
	'pfunc-convert-unit-volume-usfluidounce' => '$1{{PLURAL:$2|VS-fluid ounce|VS-fluid ounces}}',
	'pfunc-convert-unit-volume-usdrybarrel' => '$1{{PLURAL:$2|VS-droog vat|VS-droge vaten}}',
	'pfunc-convert-unit-volume-usbushel' => '$1{{PLURAL:$2|VS-bushel|VS-bushels}}',
	'pfunc-convert-unit-volume-usdrygallon' => '$1{{PLURAL:$2|VS-droge gallon|VS-droge gallon}}',
	'pfunc-convert-unit-volume-usdryquart' => '$1{{PLURAL:$2|VS-droge quart|VS-droge quart}}',
	'pfunc-convert-unit-volume-usdrypint' => '$1{{PLURAL:$2|VS-droge pint|VS-droge pints}}',
	'pfunc-convert-unit-volume-cubicmetre-abbr' => '$1m<sup>3</sup>',
	'pfunc-convert-unit-volume-cubiccentimetre-abbr' => '$1cm<sup>3</sup>',
	'pfunc-convert-unit-volume-cubicmillimetre-abbr' => '$1mm<sup>3</sup>',
	'pfunc-convert-unit-volume-litre-abbr' => '$1l',
	'pfunc-convert-unit-volume-cubicyard-abbr' => '$1yd<sup>3</sup>',
	'pfunc-convert-unit-volume-cubicfoot-abbr' => '$1ft<sup>3</sup>',
	'pfunc-convert-unit-volume-cubicinch-abbr' => '$1in<sup>3</sup>',
	'pfunc-convert-unit-volume-barrel-abbr' => '$1bbl',
	'pfunc-convert-unit-volume-bushel-abbr' => '$1bsh',
	'pfunc-convert-unit-volume-gallon-abbr' => '$1gal',
	'pfunc-convert-unit-volume-quart-abbr' => '$1qt',
	'pfunc-convert-unit-volume-pint-abbr' => '$1pt',
	'pfunc-convert-unit-volume-fluidounce-abbr' => '$1fl.oz.',
	'pfunc-convert-unit-volume-barrelus-abbr' => '$1VS bbl',
	'pfunc-convert-unit-volume-barreloil-abbr' => '$1bbl',
	'pfunc-convert-unit-volume-barrelbeer-abbr' => '$1bbl',
	'pfunc-convert-unit-volume-usgallon-abbr' => '$1VS gal',
	'pfunc-convert-unit-volume-usquart-abbr' => '$1VS qt',
	'pfunc-convert-unit-volume-uspint-abbr' => '$1VS pt',
	'pfunc-convert-unit-volume-usfluidounce-abbr' => '$1VS fl.oz.',
	'pfunc-convert-unit-volume-usdrybarrel-abbr' => '$1VS bbl',
	'pfunc-convert-unit-volume-usbushel-abbr' => '$1VS bsh',
	'pfunc-convert-unit-volume-usdrygallon-abbr' => '$1VS drg.gal',
	'pfunc-convert-unit-volume-usdryquart-abbr' => '$1VS drg.qt',
	'pfunc-convert-unit-volume-usdrypint-abbr' => '$1VS drg.pt',
	'pfunc-convert-unit-speed-mile-hour' => '$1mijl per uur',
	'pfunc-convert-unit-speed-speedoflight' => '$1c',
	'pfunc-convert-unit-speed-mile-hour-abbr' => '$1mpu',
	'pfunc-convert-unit-speed-speedoflight-abbr' => '$1c',
	'pfunc-convert-unit-pressure-pascal' => '$1{{PLURAL:$2|$3pascal|$3pascal}}',
	'pfunc-convert-unit-pressure-bar' => '$1bar',
	'pfunc-convert-unit-pressure-decibar' => '$1decibar',
	'pfunc-convert-unit-pressure-millibar' => '$1millibar',
	'pfunc-convert-unit-pressure-kilobarye' => '$1kilobarn',
	'pfunc-convert-unit-pressure-barye' => '$1barye',
	'pfunc-convert-unit-pressure-atmosphere' => '$1{{PLURAL:$2|atmosfeer|atmosfeer}}',
	'pfunc-convert-unit-pressure-torr' => '$1{{PLURAL:$2|Torr|Torr}}',
	'pfunc-convert-unit-pressure-mmhg' => '$1{{PLURAL:$2|millimeter kwik|millimeter kwik}}',
	'pfunc-convert-unit-pressure-inhg' => '$1{{PLURAL:$2|duim kwik|duimen kwik}}',
	'pfunc-convert-unit-pressure-psi' => '$1{{PLURAL:$2|pond per vierkante inch|pond per vierkante inch}}',
	'pfunc-convert-unit-pressure-pascal-abbr' => '$1$3Pa',
	'pfunc-convert-unit-pressure-bar-abbr' => '$1bar',
	'pfunc-convert-unit-pressure-decibar-abbr' => '$1dbar',
	'pfunc-convert-unit-pressure-millibar-abbr' => '$1mbar',
	'pfunc-convert-unit-pressure-kilobarye-abbr' => '$1kBa',
	'pfunc-convert-unit-pressure-barye-abbr' => '$1Ba',
	'pfunc-convert-unit-pressure-atmosphere-abbr' => '$1atm',
	'pfunc-convert-unit-pressure-torr-abbr' => '$1Torr',
	'pfunc-convert-unit-pressure-mmhg-abbr' => '$1mmHg',
	'pfunc-convert-unit-pressure-inhg-abbr' => '$1inHg',
	'pfunc-convert-unit-pressure-psi-abbr' => '$1psi',
);

/** Norwegian Nynorsk (‪Norsk (nynorsk)‬)
 * @author Eirik
 * @author Frokor
 * @author Gunnernett
 * @author Harald Khan
 */
$messages['nn'] = array(
	'pfunc_desc' => 'Legg til logiske funksjonar i parseren.',
	'pfunc_time_error' => 'Feil: Ugyldig tid',
	'pfunc_time_too_long' => 'Feil: #time er kalla for mange gonger',
	'pfunc_rel2abs_invalid_depth' => 'Feil: Ugyldig djupn i stien: «$1» (prøvde å nå ein node ovanfor rotnoden)',
	'pfunc_expr_stack_exhausted' => 'Feil i uttrykket: Stacken er tømd',
	'pfunc_expr_unexpected_number' => 'Feil i uttrykket: Uventa tal',
	'pfunc_expr_preg_match_failure' => 'Feil i uttrykket: Uventa feil i preg_match',
	'pfunc_expr_unrecognised_word' => 'Feil i uttrykket: Ukjent ord, «$1»',
	'pfunc_expr_unexpected_operator' => 'Feil i uttrykket: Uventa operatør, $1',
	'pfunc_expr_missing_operand' => 'Feil i uttrykket: Operand for $1 manglar',
	'pfunc_expr_unexpected_closing_bracket' => 'Feil i uttrykket: Uventa avsluttande parentes',
	'pfunc_expr_unrecognised_punctuation' => 'Feil i uttrykket: Ukjent punktumsteikn, «$1»',
	'pfunc_expr_unclosed_bracket' => 'Feil i uttrykket: Ein parentes er ikkje avslutta',
	'pfunc_expr_division_by_zero' => 'Divisjon med null',
	'pfunc_expr_invalid_argument' => 'Ugyldig argument for $1: < -1 eller > 1',
	'pfunc_expr_invalid_argument_ln' => 'Ugyldig argument for ln: <= 0',
	'pfunc_expr_unknown_error' => 'Feil i uttrykket: Ukjend feil ($1)',
	'pfunc_expr_not_a_number' => 'Resultatet i $1 er ikkje eit tal',
	'pfunc_string_too_long' => 'Feil: Strengen går over grensa på $1 teikn',
);

/** Norwegian (bokmål)‬ (‪Norsk (bokmål)‬)
 * @author Event
 * @author Jon Harald Søby
 * @author Laaknor
 */
$messages['nb'] = array(
	'pfunc_desc' => 'Utvid parser med logiske funksjoner',
	'pfunc_time_error' => 'Feil: ugyldig tid',
	'pfunc_time_too_long' => 'Feil: #time brukt for mange ganger',
	'pfunc_time_too_big' => 'Feil: #time støtter kun år opp til 9999',
	'pfunc_rel2abs_invalid_depth' => 'Feil: Ugyldig dybde i sti: «$1» (prøvde å få tilgang til en node over rotnoden)',
	'pfunc_expr_stack_exhausted' => 'Uttrykksfeil: Stakk utbrukt',
	'pfunc_expr_unexpected_number' => 'Uttrykksfeil: Uventet nummer',
	'pfunc_expr_preg_match_failure' => 'Uttrykksfeil: Uventet preg_match-feil',
	'pfunc_expr_unrecognised_word' => 'Uttrykksfeil: Ugjenkjennelig ord «$1»',
	'pfunc_expr_unexpected_operator' => 'Uttrykksfeil: Uventet $1-operator',
	'pfunc_expr_missing_operand' => 'Uttrykksfeil: Mangler operand for $1',
	'pfunc_expr_unexpected_closing_bracket' => 'Uttrykksfeil: Uventet lukkende parentes',
	'pfunc_expr_unrecognised_punctuation' => 'Uttrykksfeil: Ugjenkjennelig tegn «$1»',
	'pfunc_expr_unclosed_bracket' => 'Uttrykksfeil: Åpen parentes',
	'pfunc_expr_division_by_zero' => 'Deling på null',
	'pfunc_expr_invalid_argument' => 'Ugyldig argument for $1: < -1 eller > 1',
	'pfunc_expr_invalid_argument_ln' => 'Ugyldig argument for ln: <= 0',
	'pfunc_expr_unknown_error' => 'Uttrykksfeil: Ukjent feil ($1)',
	'pfunc_expr_not_a_number' => 'I $1: resultat er ikke et tall',
	'pfunc_string_too_long' => 'Feil: Strengen går over grensen på $1 tegn',
	'pfunc-convert-unit-pressure-bar' => 'bar',
	'pfunc-convert-unit-pressure-decibar' => 'decibar',
	'pfunc-convert-unit-pressure-millibar' => 'millibar',
	'pfunc-convert-unit-pressure-atmosphere' => '{{PLURAL:$1|atmosfære|atmosfærer}',
	'pfunc-convert-unit-pressure-torr' => '{{PLURAL:$1|Torr|Torr}}',
	'pfunc-convert-unit-pressure-mmhg' => '{{PLURAL:$1|mmHg|mmHg}}',
);

/** Occitan (Occitan)
 * @author Cedric31
 */
$messages['oc'] = array(
	'pfunc_desc' => 'Augmenta lo parser amb de foncions logicas',
	'pfunc_time_error' => 'Error: durada invalida',
	'pfunc_time_too_long' => 'Error: parser #time apelat tròp de còps',
	'pfunc_rel2abs_invalid_depth' => 'Error: nivèl de repertòri invalid dins lo camin : "$1" (a ensajat d’accedir a un nivèl al-dessús del repertòri raiç)',
	'pfunc_expr_stack_exhausted' => 'Expression erronèa : pila agotada',
	'pfunc_expr_unexpected_number' => 'Expression erronèa : nombre pas esperat',
	'pfunc_expr_preg_match_failure' => 'Expression erronèa : una expression pas compresa a pas capitat',
	'pfunc_expr_unrecognised_word' => "Error d'expression : lo mot '''$1''' es pas reconegut",
	'pfunc_expr_unexpected_operator' => "Error d'expression : l'operador '''$1''' es pas reconegut",
	'pfunc_expr_missing_operand' => "Error d'expression : l'operanda '''$1''' es pas reconeguda",
	'pfunc_expr_unexpected_closing_bracket' => "Error d'expression : parentèsi tampanta pas prevista",
	'pfunc_expr_unrecognised_punctuation' => "Error d'expression : caractèr de ponctuacion « $1 » pas reconegut",
	'pfunc_expr_unclosed_bracket' => 'Error d’expression : parentèsi pas tampada',
	'pfunc_expr_division_by_zero' => 'Division per zèro',
	'pfunc_expr_invalid_argument' => 'Valor incorrècta per $1 : < -1 o > 1',
	'pfunc_expr_invalid_argument_ln' => 'Valor incorrècta per ln : ≤ 0',
	'pfunc_expr_unknown_error' => "Error d'expression : error desconeguda ($1)",
	'pfunc_expr_not_a_number' => 'Dins $1 : lo resultat es pas un nombre',
	'pfunc_string_too_long' => 'Error : La cadena depassa lo limit maximal de $1 caractèr{{PLURAL:$1||s}}',
);

/** Polish (Polski)
 * @author Derbeth
 * @author Grzechooo
 * @author Sp5uhe
 * @author Woytecr
 */
$messages['pl'] = array(
	'pfunc_desc' => 'Rozszerza analizator składni o funkcje logiczne',
	'pfunc_time_error' => 'Błąd – niepoprawny czas',
	'pfunc_time_too_long' => 'Błąd – zbyt wiele wywołań funkcji #time',
	'pfunc_time_too_big' => 'Błąd – rok w #time nie może być większy niż 9999',
	'pfunc_rel2abs_invalid_depth' => 'Błąd – nieprawidłowa głębokość w ścieżce „$1” (próba dostępu do węzła powyżej korzenia)',
	'pfunc_expr_stack_exhausted' => 'Błąd w wyrażeniu – stos wyczerpany',
	'pfunc_expr_unexpected_number' => 'Błąd w wyrażeniu – nieoczekiwana liczba',
	'pfunc_expr_preg_match_failure' => 'Błąd w wyrażeniu – nieoczekiwany błąd preg_match',
	'pfunc_expr_unrecognised_word' => 'Błąd w wyrażeniu – nierozpoznane słowo „$1”',
	'pfunc_expr_unexpected_operator' => 'Błąd w wyrażeniu – nieoczekiwany operator $1',
	'pfunc_expr_missing_operand' => 'Błąd w wyrażeniu – brak argumentu funkcji $1',
	'pfunc_expr_unexpected_closing_bracket' => 'Błąd w wyrażeniu – nieoczekiwany nawias zamykający',
	'pfunc_expr_unrecognised_punctuation' => 'Błąd w wyrażeniu – nierozpoznany znak interpunkcyjny „$1”',
	'pfunc_expr_unclosed_bracket' => 'Błąd w wyrażeniu – niedomknięty nawias',
	'pfunc_expr_division_by_zero' => 'Dzielenie przez zero',
	'pfunc_expr_invalid_argument' => 'Nieprawidłowy argument funkcji $1 – mniejszy od -1 lub większy od 1',
	'pfunc_expr_invalid_argument_ln' => 'Nieprawidłowy argument funkcji ln – mniejszy lub równy 0',
	'pfunc_expr_unknown_error' => 'Błąd w wyrażeniu – nieznany błąd ($1)',
	'pfunc_expr_not_a_number' => 'W $1 – wynik nie jest liczbą',
	'pfunc_string_too_long' => 'Błąd – długość ciągu znaków przekracza dopuszczalne $1',
	'pfunc-convert-dimensionmismatch' => 'Błąd – nie można konwertować pomiędzy jednostkami „$1” i „$2”',
	'pfunc-convert-unknownunit' => 'Błąd – nieznana jednostka „$1”',
	'pfunc-convert-unknowndimension' => 'Błąd – nieznana jednostka „$1”',
	'pfunc-convert-invalidcompoundunit' => 'Błąd – nieprawidłowa jednostka złożona „$1”',
	'pfunc-convert-nounit' => 'Błąd – brak jednostki źródłowej',
	'pfunc-convert-doublecompoundunit' => 'Błąd – nie można przetworzyć jednostki podwójnie złożonej jak „$1”',
	'pfunc-convert-dimension-length' => 'długość',
	'pfunc-convert-dimension-area' => 'powierzchnia',
	'pfunc-convert-dimension-volume' => 'objętość',
	'pfunc-convert-dimension-time' => 'czas',
	'pfunc-convert-dimension-timesquared' => 'czas<sup>2</sup>',
	'pfunc-convert-dimension-mass' => 'masa',
	'pfunc-convert-dimension-speed' => 'prędkość',
	'pfunc-convert-dimension-temperature' => 'temperatura',
	'pfunc-convert-dimension-acceleration' => 'przyspieszenie',
	'pfunc-convert-dimension-force' => 'siła',
	'pfunc-convert-dimension-torque' => 'moment obrotowy',
	'pfunc-convert-dimension-energy' => 'energia',
	'pfunc-convert-dimension-power' => 'moc',
	'pfunc-convert-dimension-pressure' => 'ciśnienie',
	'pfunc-convert-dimension-density' => 'gęstość',
	'pfunc-convert-dimension-fuelefficiencypositive' => 'bezwzględne zużycie paliwa',
	'pfunc-convert-dimension-fuelefficiencynegative' => 'nieprawidłowe zużycie paliwa',
	'pfunc-convert-prefix-yotta' => 'jotta',
	'pfunc-convert-prefix-zetta' => 'zetta',
	'pfunc-convert-prefix-exa' => 'eksa',
	'pfunc-convert-prefix-peta' => 'peta',
	'pfunc-convert-prefix-tera' => 'tera',
	'pfunc-convert-prefix-giga' => 'giga',
	'pfunc-convert-prefix-mega' => 'mega',
	'pfunc-convert-prefix-kilo' => 'kilo',
	'pfunc-convert-prefix-hecto' => 'hekto',
	'pfunc-convert-prefix-deca' => 'deka',
	'pfunc-convert-prefix-deci' => 'decy',
	'pfunc-convert-prefix-centi' => 'centy',
	'pfunc-convert-prefix-milli' => 'mili',
	'pfunc-convert-prefix-micro' => 'mikro',
	'pfunc-convert-prefix-nano' => 'nano',
	'pfunc-convert-prefix-pico' => 'piko',
	'pfunc-convert-prefix-femto' => 'femto',
	'pfunc-convert-prefix-atto' => 'atto',
	'pfunc-convert-prefix-zepto' => 'zepto',
	'pfunc-convert-prefix-yocto' => 'jokto',
	'pfunc-convert-prefix-milli-abbr' => 'm',
	'pfunc-convert-unit-length-metre' => '$1{{PLURAL:$2|$3 metr|$3 metry|$3 metrów}}',
	'pfunc-convert-unit-length-angstrom' => '$1{{PLURAL:$2|angstrem|angstremy|angstremów}}',
	'pfunc-convert-unit-length-mile' => '$1{{PLURAL:$2|mila|mile|mil}}',
	'pfunc-convert-unit-length-furlong' => '$1{{PLURAL:$2|furlong|furlongi|furlongów}}',
	'pfunc-convert-unit-length-chain' => '$1{{PLURAL:$2|łańcuch|łańcuchy|łańcuchów}}',
	'pfunc-convert-unit-length-rod' => '$1{{PLURAL:$2|pręt|pręty|prętów}}',
	'pfunc-convert-unit-length-fathom' => '$1{{PLURAL:$2|sążeń|sążnie|sążni}}',
	'pfunc-convert-unit-length-yard' => '$1{{PLURAL:$2|jard|jardy|jardów}}',
	'pfunc-convert-unit-length-foot' => '$1{{PLURAL:$2|stopa|stopy|stóp}}',
	'pfunc-convert-unit-length-hand' => '$1{{PLURAL:$2|dłoń|dłonie|dłoni}}',
	'pfunc-convert-unit-length-inch' => '$1{{PLURAL:$2|cal|cale|cali}}',
	'pfunc-convert-unit-length-nauticalmile' => '$1{{PLURAL:$2|mila morska|mile morskie|mil morskich}}',
	'pfunc-convert-unit-length-nauticalmileuk' => '$1{{PLURAL:$2|mila morska brytyjska|mile morskie brytyjskie|mil morskich brytyjskich}} sprzed 1970 roku',
	'pfunc-convert-unit-length-nauticalmileus' => '$1{{PLURAL:$2|mila morska amerykańska|mile morskie amerykańskie|mil morskich amerykańskich}} sprzed 1954 roku',
	'pfunc-convert-unit-length-parsec' => '$1{{PLURAL:$2|$3 parsek|$3 parseki|$3 parseków}}',
	'pfunc-convert-unit-length-lightyear' => '$1{{PLURAL:$2|$3 rok świetlny|$3 lata świetlne|$3 lat świetlnych}}',
	'pfunc-convert-unit-length-astronomicalunit' => '$1{{PLURAL:$2|jednostka astronomiczna|jednostki astronomiczne|jednostek astronomicznych}}',
	'pfunc-convert-unit-length-furlong-abbr' => '$1furlong',
	'pfunc-convert-unit-length-chain-abbr' => '$1łańcuch',
	'pfunc-convert-unit-length-rod-abbr' => '$1rd',
	'pfunc-convert-unit-length-fathom-abbr' => '$1sążeń',
	'pfunc-convert-unit-length-yard-abbr' => '$1jard',
	'pfunc-convert-unit-length-foot-abbr' => '$1stopa',
	'pfunc-convert-unit-length-hand-abbr' => '$1dłoń',
	'pfunc-convert-unit-length-inch-abbr' => '$1cal',
	'pfunc-convert-unit-length-nauticalmile-abbr' => '$1INM',
	'pfunc-convert-unit-length-nauticalmileuk-abbr' => '$1angielska mila morska',
	'pfunc-convert-unit-length-nauticalmileus-abbr' => '$1amerykańska mila morska sprzed 1954 roku',
	'pfunc-convert-unit-length-parsec-abbr' => '$1$3 pc',
	'pfunc-convert-unit-length-lightyear-abbr' => '$1$3 lat świetlnych',
	'pfunc-convert-unit-length-astronomicalunit-abbr' => '$1j.a.',
	'pfunc-convert-unit-area-squarekilometre' => '$1{{PLURAL:$2|kilometr kwadratowy|kilometry kwadratowe|kilometrów kwadratowych}}',
	'pfunc-convert-unit-area-squaremetre' => '$1{{PLURAL:$2|metr kwadratowy|metry kwadratowe|metrów kwadratowych}}',
	'pfunc-convert-unit-area-squarecentimetre' => '$1{{PLURAL:$2|centymetr kwadratowy|centymetry kwadratowe|centymetrów kwadratowych}}',
	'pfunc-convert-unit-area-squaremillimetre' => '$1{{PLURAL:$2|milimetr kwadratowy|milimetry kwadratowe|milimetrów kwadratowych}}',
	'pfunc-convert-unit-area-hectare' => '$1{{PLURAL:$2|hektar|hektary|hektarów}}',
	'pfunc-convert-unit-area-squaremile' => '$1{{PLURAL:$2|mila kwadratowa|mile kwadratowe|mil kwadratowych}}',
	'pfunc-convert-unit-area-acre' => '$1{{PLURAL:$2|akr|akry|akrów}}',
	'pfunc-convert-unit-area-squareyard' => '$1{{PLURAL:$2|jard kwadratowy|jardy kwadratowe|jardów kwadratowych}}',
	'pfunc-convert-unit-area-squarefoot' => '$1{{PLURAL:$2|stopa kwadratowa|stopy kwadratowe|stóp kwadratowych}}',
	'pfunc-convert-unit-area-squareinch' => '$1{{PLURAL:$2|cal kwadratowy|cale kwadratowe|cali kwadratowych}}',
	'pfunc-convert-unit-area-squarenauticalmile' => '$1{{PLURAL:$2|mila morska kwadratowa|mile morskie kwadratowe|mil morskich kwadratowych}}',
	'pfunc-convert-unit-area-dunam' => '$1{{PLURAL:$2|dunam|dunamy|dunamów}}',
	'pfunc-convert-unit-area-tsubo' => '$1{{PLURAL:$2|tsubo|tsubo|tsubo}}',
	'pfunc-convert-unit-area-squarekilometre-abbr' => '$1km<sup>2</sup>',
	'pfunc-convert-unit-area-squaremetre-abbr' => '$1m<sup>2</sup>',
	'pfunc-convert-unit-area-squarecentimetre-abbr' => '$1cm<sup>2</sup>',
	'pfunc-convert-unit-area-squaremillimetre-abbr' => '$1mm<sup>2</sup>',
	'pfunc-convert-unit-area-hectare-abbr' => '$1ha',
	'pfunc-convert-unit-area-squaremile-abbr' => '$1mila<sup>2</sup>',
	'pfunc-convert-unit-area-acre-abbr' => '$1akr',
	'pfunc-convert-unit-area-squareyard-abbr' => '$1jard<sup>2</sup>',
	'pfunc-convert-unit-area-squarefoot-abbr' => '$1stopa<sup>2</sup>',
	'pfunc-convert-unit-area-squareinch-abbr' => '$1cal<sup>2</sup>',
	'pfunc-convert-unit-area-squarenauticalmile-abbr' => '$1mila morska<sup>2</sup>',
	'pfunc-convert-unit-area-dunam-abbr' => '$1dunam',
	'pfunc-convert-unit-area-tsubo-abbr' => '$1tsubo',
	'pfunc-convert-unit-time-second' => '$1{{PLURAL:$2|sekunda|sekundy|sekund}}',
	'pfunc-convert-unit-time-year' => '$1{{PLURAL:$2|$3 rok|$3 lata|$3 lat}}',
	'pfunc-convert-unit-time-day' => '$1{{PLURAL:$2|dzień|dni}}',
	'pfunc-convert-unit-time-hour' => '$1{{PLURAL:$2|godzina|godziny|godzin}}',
	'pfunc-convert-unit-time-minute' => '$1{{PLURAL:$2|minuta|minuty|minut}}',
	'pfunc-convert-unit-time-second-abbr' => '$1s',
	'pfunc-convert-unit-time-year-abbr' => '$1$3 jard',
	'pfunc-convert-unit-time-day-abbr' => '$1doba',
	'pfunc-convert-unit-time-hour-abbr' => '$1h',
	'pfunc-convert-unit-time-minute-abbr' => '$1min',
	'pfunc-convert-unit-volume-cubicmetre' => '$1{{PLURAL:$2|metr sześcienny|metry sześcienne|metrów sześciennych}}',
	'pfunc-convert-unit-volume-cubiccentimetre' => '$1{{PLURAL:$2|centymetr sześcienny|centymetry sześcienne|centymetrów sześciennych}}',
	'pfunc-convert-unit-volume-cubicmillimetre' => '$1{{PLURAL:$2|milimetr sześcienny|milimetry sześcienne|milimetrów sześciennych}}',
	'pfunc-convert-unit-volume-kilolitre' => '$1{{PLURAL:$2|tysiąc litrów|tysiące litrów|tysięcy litrów}}',
	'pfunc-convert-unit-volume-litre' => '$1{{PLURAL:$2|litr|litry|litrów}}',
	'pfunc-convert-unit-volume-centilitre' => '$1{{PLURAL:$2|dziesiąta część|dziesiąte części|dziesiątych części}} litra',
	'pfunc-convert-unit-volume-millilitre' => '$1{{PLURAL:$2|mililitr|mililitry|mililitrów}}',
	'pfunc-convert-unit-volume-quart' => '$1{{PLURAL:$2|jard|jardów}}',
	'pfunc-convert-unit-volume-cubicmetre-abbr' => '$1m<sup>3</sup>',
	'pfunc-convert-unit-volume-cubiccentimetre-abbr' => '$1cm<sup>3</sup>',
	'pfunc-convert-unit-volume-cubicmillimetre-abbr' => '$1mm<sup>3</sup>',
	'pfunc-convert-unit-volume-litre-abbr' => '$1$3 l',
	'pfunc-convert-unit-speed-mile-hour' => '$1mil na godzinę',
	'pfunc-convert-unit-pressure-pascal' => '$1{{PLURAL:$2|$3paskal|$3paskali}}',
	'pfunc-convert-unit-pressure-bar' => '$1barów',
	'pfunc-convert-unit-pressure-decibar' => '$1decybarów',
	'pfunc-convert-unit-pressure-millibar' => '$1millibarów',
	'pfunc-convert-unit-pressure-kilobarye' => '$1kilobarów',
	'pfunc-convert-unit-pressure-atmosphere' => '$1{{PLURAL:$2|atmosfera|atmosfer}}',
	'pfunc-convert-unit-pressure-mmhg' => '$1{{PLURAL:$2|milimtr słupka rtęci|milimetrów słupka rtęci}}',
	'pfunc-convert-unit-pressure-inhg' => '$1{{PLURAL:$2|cal słupka rtęci|cali słupka rtęci}}',
	'pfunc-convert-unit-pressure-pascal-abbr' => '$1$3Pa',
	'pfunc-convert-unit-pressure-bar-abbr' => '$1bar.',
	'pfunc-convert-unit-pressure-decibar-abbr' => '$1dbar',
	'pfunc-convert-unit-pressure-barye-abbr' => '$1Ba',
	'pfunc-convert-unit-pressure-atmosphere-abbr' => '$1atm',
	'pfunc-convert-unit-pressure-mmhg-abbr' => '$1mmHg',
);

/** Piedmontese (Piemontèis)
 * @author Bèrto 'd Sèra
 * @author Dragonòt
 */
$messages['pms'] = array(
	'pfunc_desc' => 'Mijora ël parse con funsion lògiche',
	'pfunc_time_error' => 'Eror: temp nen bon',
	'pfunc_time_too_long' => 'Eror: #time a ven ciamà tròpe vire',
	'pfunc_time_too_big' => 'Eror: #time a përmëtt mach agn fin al 9999',
	'pfunc_rel2abs_invalid_depth' => 'Eror: profondità nen bon-a ant ël përcors: "$1" (a l\'é provasse a ciamé un grop dzora a la rèis)',
	'pfunc_expr_stack_exhausted' => "Eror ëd l'espression: stach esaurìa",
	'pfunc_expr_unexpected_number' => "Eror ëd l'espression: nùmer pa spetà",
	'pfunc_expr_preg_match_failure' => "Eror ëd l'espression: eror pa spetà an preg_match",
	'pfunc_expr_unrecognised_word' => 'Eror ëd l\'espression: paròla "$1" pa arconossùa',
	'pfunc_expr_unexpected_operator' => "Eror ëd l'espression: operator $1 pa spetà",
	'pfunc_expr_missing_operand' => "Eror ëd l'espression: Operand për $1 mancant",
	'pfunc_expr_unexpected_closing_bracket' => "Eror ëd l'espression: paréntesi pa sarà",
	'pfunc_expr_unrecognised_punctuation' => 'Eror ëd l\'espression: caràter ëd puntegiadura "$1" pa arconossù',
	'pfunc_expr_unclosed_bracket' => "Eror ëd l'espression: paréntesi pa sarà",
	'pfunc_expr_division_by_zero' => 'Division për zero',
	'pfunc_expr_invalid_argument' => 'Argoment pa bon për $1: < -1 o > 1',
	'pfunc_expr_invalid_argument_ln' => 'Argoment pa bon për ln: <= 0',
	'pfunc_expr_unknown_error' => "Eror ëd l'espression: Eror pa conossù ($1)",
	'pfunc_expr_not_a_number' => "An $1: l'arzultà a l'é pa un nùmer",
	'pfunc_string_too_long' => 'Eror: la stringa a passa ël lìmit ëd $1 caràter',
);

/** Western Punjabi (پنجابی)
 * @author Khalid Mahmood
 */
$messages['pnb'] = array(
	'pfunc_time_error' => 'غلطی: ویلہ ٹھیک نئیں۔',
	'pfunc_time_too_long' => 'غلطی: بعوت ساریاں # کالاں',
	'pfunc-convert-dimension-length' => 'لمبائی',
	'pfunc-convert-dimension-area' => 'تھاں',
	'pfunc-convert-dimension-volume' => 'والیوم',
	'pfunc-convert-dimension-time' => 'ویلہ',
	'pfunc-convert-dimension-timesquared' => 'واری<sup>2</sup>',
	'pfunc-convert-dimension-mass' => 'ماس',
	'pfunc-convert-dimension-speed' => 'دوڑ',
	'pfunc-convert-dimension-temperature' => 'گرمی ناپ',
	'pfunc-convert-dimension-acceleration' => 'سدی دوڑ',
	'pfunc-convert-dimension-force' => 'زور',
	'pfunc-convert-dimension-torque' => 'ٹارک',
	'pfunc-convert-dimension-energy' => 'انرجی',
	'pfunc-convert-dimension-power' => 'پاور',
	'pfunc-convert-dimension-pressure' => 'دبآ',
	'pfunc-convert-dimension-density' => 'گوڑا',
	'pfunc-convert-prefix-yotta' => 'یوٹا',
	'pfunc-convert-prefix-zetta' => 'زیٹا',
	'pfunc-convert-prefix-exa' => 'ایکسا',
	'pfunc-convert-prefix-peta' => 'پیٹا',
	'pfunc-convert-prefix-tera' => 'ٹیرا',
	'pfunc-convert-prefix-giga' => 'گیگا',
	'pfunc-convert-prefix-mega' => 'میگا',
	'pfunc-convert-prefix-kilo' => 'کلو',
	'pfunc-convert-prefix-hecto' => 'ہیکٹو',
	'pfunc-convert-prefix-deca' => 'ڈیکا',
	'pfunc-convert-prefix-deci' => 'ڈیسی',
	'pfunc-convert-prefix-centi' => 'سنٹی',
	'pfunc-convert-prefix-milli' => 'ملی',
	'pfunc-convert-prefix-micro' => 'مائکرو',
	'pfunc-convert-prefix-nano' => 'نینو',
	'pfunc-convert-prefix-pico' => 'پکو',
	'pfunc-convert-prefix-femto' => 'فمٹو',
	'pfunc-convert-prefix-atto' => 'اٹو',
	'pfunc-convert-prefix-zepto' => 'زپٹو',
	'pfunc-convert-prefix-yocto' => 'یوکٹو',
	'pfunc-convert-unit-length-metre' => '$1{{PLURAL:$2|$3میٹر}}',
	'pfunc-convert-unit-length-furlong-abbr' => '$1فرلانگ',
	'pfunc-convert-unit-length-chain-abbr' => '$1زنجیر',
	'pfunc-convert-unit-length-rod-abbr' => '$1رداس',
	'pfunc-convert-unit-length-fathom-abbr' => '$1فیدم',
	'pfunc-convert-unit-length-yard-abbr' => '$1گز',
	'pfunc-convert-unit-length-foot-abbr' => '$1فٹ',
	'pfunc-convert-unit-length-hand-abbr' => '$1کینٹہ',
	'pfunc-convert-unit-length-inch-abbr' => '$1انچ',
	'pfunc-convert-unit-length-nauticalmile-abbr' => '$1سمندری میل',
	'pfunc-convert-unit-length-nauticalmileuk-abbr' => '$1سمندری میل (برطانیہ)',
	'pfunc-convert-unit-length-nauticalmileus-abbr' => '$1سمندری میل (امریکہ 1954 توں پہلے)',
	'pfunc-convert-unit-length-parsec-abbr' => '$1$3کمپیوٹر',
	'pfunc-convert-unit-length-lightyear-abbr' => '$1$3ly',
	'pfunc-convert-unit-length-astronomicalunit-abbr' => '$1اسمانی ناپ',
	'pfunc-convert-unit-area-squarekilometre' => '$1{{PLURAL:$2|مربع کلومیٹر|مربع کلومیٹر}}',
	'pfunc-convert-unit-area-squaremetre' => '$1{{PLURAL:$2|مربع میٹر|مربع میٹر}}',
	'pfunc-convert-unit-area-squarecentimetre' => '$1{{PLURAL:$2|مربع سینٹیمیٹر|مربع سینٹیمیٹر}}',
	'pfunc-convert-unit-area-squaremillimetre' => '$1{{PLURAL:$2|مربع میلیمیٹر|مربع میلیمیٹر}}',
	'pfunc-convert-unit-area-hectare' => '$1{{PLURAL:$2|ہیکٹر|ہیکٹر}}',
	'pfunc-convert-unit-area-squaremile' => '$1{{PLURAL:$2|مربع میلیمیٹر|مربع میل}}',
	'pfunc-convert-unit-area-acre' => '$1{{PLURAL:$2|ایکڑ|ایکڑ}}',
	'pfunc-convert-unit-area-squareyard' => '$1{{PLURAL:$2|مربع گز|مربع گز}}',
	'pfunc-convert-unit-area-squarefoot' => '$1{{PLURAL:$2|مربع فٹ|مربع فٹ}}',
	'pfunc-convert-unit-area-squareinch' => '$1{{PLURAL:$2|مربع انچ|مربع انچ}}',
	'pfunc-convert-unit-area-squarenauticalmile' => '$1{{PLURAL:$2|مربع سمندری میل|مربع سمندری میل}}',
	'pfunc-convert-unit-area-dunam' => '$1{{PLURAL:$2|ڈنام|ڈنام}}',
	'pfunc-convert-unit-area-tsubo' => '$1{{PLURAL:$2|زوبو|زوبو}}',
	'pfunc-convert-unit-area-squarekilometre-abbr' => '$1کلومیٹر<sup>2</sup>',
	'pfunc-convert-unit-area-squaremetre-abbr' => '$1m<sup>2</sup>',
	'pfunc-convert-unit-area-squarecentimetre-abbr' => '$1cm<sup>2</sup>',
	'pfunc-convert-unit-area-squaremillimetre-abbr' => '$1mm<sup>2</sup>',
	'pfunc-convert-unit-area-hectare-abbr' => '$1ہیکٹر',
	'pfunc-convert-unit-area-squaremile-abbr' => '$1مربع میل',
	'pfunc-convert-unit-area-acre-abbr' => '$1ایکڑ',
	'pfunc-convert-unit-area-squareyard-abbr' => '$1مربع گز',
	'pfunc-convert-unit-area-squarefoot-abbr' => '$1مربع فٹ',
	'pfunc-convert-unit-area-squareinch-abbr' => '$1مربع انچ',
	'pfunc-convert-unit-area-squarenauticalmile-abbr' => '$1مربع سمندری میل',
	'pfunc-convert-unit-area-dunam-abbr' => '$1دونام',
	'pfunc-convert-unit-area-tsubo-abbr' => '$1سوبو',
	'pfunc-convert-unit-time-second' => '$1$2 {{PLURAL:$2|سکنٹ|سکنٹاں}}',
	'pfunc-convert-unit-time-year' => '$1{{PLURAL:$2|$3ورہ|$3ورے}}',
	'pfunc-convert-unit-time-day' => '$1 {{PLURAL:$2|دن|دناں}}',
	'pfunc-convert-unit-time-hour' => '$1 {{PLURAL:$2|کینٹا|کینٹے}}',
	'pfunc-convert-unit-time-minute' => '$1 {{PLURAL:$2|منٹ|منٹاں}}',
	'pfunc-convert-unit-time-second-abbr' => '$1سکنث',
	'pfunc-convert-unit-time-year-abbr' => '$1$3ورہ',
	'pfunc-convert-unit-time-day-abbr' => '$1دیاڑھ',
	'pfunc-convert-unit-time-hour-abbr' => '$1کینٹہ',
	'pfunc-convert-unit-time-minute-abbr' => '$1منٹ',
	'pfunc-convert-unit-volume-cubicmetre' => '$1{{PLURAL:$2|مربع میٹر|مربع میٹر}}',
	'pfunc-convert-unit-volume-cubiccentimetre' => '$1{{PLURAL:$2|مربع سینٹیمیٹر|مربع سینٹیمیٹر}}',
	'pfunc-convert-unit-volume-cubicmillimetre' => '$1{{PLURAL:$2|مربع میلیمیٹر|مربع میلیمیٹر}}',
	'pfunc-convert-unit-volume-kilolitre' => '$1{{PLURAL:$2|کلولٹر|کلولٹر}}',
	'pfunc-convert-unit-volume-litre' => '$1{{PLURAL:$2|لٹر|لٹر}}',
	'pfunc-convert-unit-volume-centilitre' => '$1{{PLURAL:$2|سینٹیلٹر}}',
	'pfunc-convert-unit-volume-millilitre' => '$1{{PLURAL:$2|ملیلٹر}}',
	'pfunc-convert-unit-volume-cubicyard' => '$1{{PLURAL:$2|مربع گز}}',
	'pfunc-convert-unit-volume-cubicfoot' => '$1{{PLURAL:$2|مربع فٹ}}',
	'pfunc-convert-unit-volume-cubicinch' => '$1{{PLURAL:$2|مربع انچ}}',
	'pfunc-convert-unit-volume-barrel' => '$1{{PLURAL:$2|بیرل}}',
	'pfunc-convert-unit-volume-bushel' => '$1{{PLURAL:$2|بشل}}',
	'pfunc-convert-unit-volume-gallon' => '$1{{PLURAL:$2|گیلن}}',
	'pfunc-convert-unit-volume-quart' => '$1{{PLURAL:$2|کوارٹز}}',
	'pfunc-convert-unit-volume-pint' => '$1{{PLURAL:$2|پنٹ}}',
	'pfunc-convert-unit-volume-fluidounce' => '$1{{PLURAL:$2|پانیسر اونس}}',
	'pfunc-convert-unit-volume-barrelus' => '$1{{PLURAL:$2|بیرل}}',
	'pfunc-convert-unit-volume-barreloil' => '$1{{PLURAL:$2|بیرل}}',
	'pfunc-convert-unit-volume-barrelbeer' => '$1{{PLURAL:$2|بیرل}}',
	'pfunc-convert-unit-volume-usgallon' => '$1{{PLURAL:$2|گیلن}}',
	'pfunc-convert-unit-volume-usquart' => '$1{{PLURAL:$2|کوارٹز}}',
	'pfunc-convert-unit-volume-uspint' => '$1{{PLURAL:$2|پنٹ}}',
	'pfunc-convert-unit-volume-usfluidounce' => '$1{{PLURAL:$2|پانیسر اونس}}',
	'pfunc-convert-unit-volume-usdrybarrel' => '$1{{PLURAL:$2|بیرل}}',
	'pfunc-convert-unit-volume-usbushel' => '$1{{PLURAL:$2|بشل}}',
	'pfunc-convert-unit-volume-usdrygallon' => '$1{{PLURAL:$2|گیلن}}',
	'pfunc-convert-unit-volume-usdryquart' => '$1{{PLURAL:$2|کوارٹز}}',
	'pfunc-convert-unit-volume-usdrypint' => '$1{{PLURAL:$2|پنٹ}}',
	'pfunc-convert-unit-volume-cubicmetre-abbr' => '$1m<sup>2</sup>',
	'pfunc-convert-unit-volume-cubiccentimetre-abbr' => '$1سینٹی میٹر<sup>3</sup>',
	'pfunc-convert-unit-volume-cubicmillimetre-abbr' => '$1ملی میٹر<sup>3</sup>',
	'pfunc-convert-unit-volume-litre-abbr' => '$1$3ly',
	'pfunc-convert-unit-volume-cubicyard-abbr' => '$1مربع گز',
	'pfunc-convert-unit-volume-cubicfoot-abbr' => '$1مربع فٹ',
	'pfunc-convert-unit-volume-cubicinch-abbr' => '$1مکعب انچ',
	'pfunc-convert-unit-volume-barrel-abbr' => '$1bbl',
);

/** Pashto (پښتو)
 * @author Ahmed-Najib-Biabani-Ibrahimkhel
 */
$messages['ps'] = array(
	'pfunc_time_error' => 'ستونزه: ناسم وخت',
	'pfunc_expr_division_by_zero' => 'وېش په صفر',
);

/** Portuguese (Português)
 * @author Hamilton Abreu
 * @author Malafaya
 */
$messages['pt'] = array(
	'pfunc_desc' => 'Adiciona funções lógicas ao analisador sintáctico',
	'pfunc_time_error' => 'Erro: tempo inválido',
	'pfunc_time_too_long' => 'Erro: demasiadas chamadas a #time',
	'pfunc_time_too_big' => 'Erro: #time só lida com anos até 9999',
	'pfunc_rel2abs_invalid_depth' => 'Erro: Profundidade inválida no caminho: "$1" (foi tentado o acesso a um nó acima do nó raiz)',
	'pfunc_expr_stack_exhausted' => 'Erro de expressão: Pilha esgotada',
	'pfunc_expr_unexpected_number' => 'Erro de expressão: Número inesperado',
	'pfunc_expr_preg_match_failure' => 'Erro de expressão: Falha em preg_match inesperada',
	'pfunc_expr_unrecognised_word' => 'Erro de expressão: Palavra "$1" não reconhecida',
	'pfunc_expr_unexpected_operator' => 'Erro de expressão: Operador $1 inesperado',
	'pfunc_expr_missing_operand' => 'Erro de expressão: Falta operando para $1',
	'pfunc_expr_unexpected_closing_bracket' => 'Erro de expressão: Parêntese de fecho inesperado',
	'pfunc_expr_unrecognised_punctuation' => 'Erro de expressão: Carácter de pontuação "$1" não reconhecido',
	'pfunc_expr_unclosed_bracket' => 'Erro de expressão: Parêntese não fechado',
	'pfunc_expr_division_by_zero' => 'Divisão por zero',
	'pfunc_expr_invalid_argument' => 'Argumento inválido para $1: < -1 or > 1',
	'pfunc_expr_invalid_argument_ln' => 'Argumento inválido para ln: <= 0',
	'pfunc_expr_unknown_error' => 'Erro de expressão: Erro desconhecido ($1)',
	'pfunc_expr_not_a_number' => 'Em $1: resultado não é um número',
	'pfunc_string_too_long' => 'Erro: Texto excede o limite de $1 caracteres',
);

/** Brazilian Portuguese (Português do Brasil)
 * @author Eduardo.mps
 * @author Giro720
 */
$messages['pt-br'] = array(
	'pfunc_desc' => 'Melhora o analisador (parser) com funções lógicas',
	'pfunc_time_error' => 'Erro: tempo inválido',
	'pfunc_time_too_long' => 'Erro: muitas chamadas a #time',
	'pfunc_time_too_big' => 'Erro: #time só lida com anos até 9999',
	'pfunc_rel2abs_invalid_depth' => 'Erro: Profundidade inválida no caminho: "$1" (foi tentado o acesso a um nó acima do nó raiz)',
	'pfunc_expr_stack_exhausted' => 'Erro de expressão: Pilha esgotada',
	'pfunc_expr_unexpected_number' => 'Erro de expressão: Número inesperado',
	'pfunc_expr_preg_match_failure' => 'Erro de expressão: Falha em preg_match inesperada',
	'pfunc_expr_unrecognised_word' => 'Erro de expressão: Palavra "$1" não reconhecida',
	'pfunc_expr_unexpected_operator' => 'Erro de expressão: Operador $1 inesperado',
	'pfunc_expr_missing_operand' => 'Erro de expressão: Falta operando para $1',
	'pfunc_expr_unexpected_closing_bracket' => 'Erro de expressão: Parêntese de fechamento inesperado',
	'pfunc_expr_unrecognised_punctuation' => 'Erro de expressão: Caractere de pontuação "$1" não reconhecido',
	'pfunc_expr_unclosed_bracket' => 'Erro de expressão: Parêntese não fechado',
	'pfunc_expr_division_by_zero' => 'Divisão por zero',
	'pfunc_expr_invalid_argument' => 'Argumento inválido para $1: < -1 or > 1',
	'pfunc_expr_invalid_argument_ln' => 'Argumento inválido para ln: <= 0',
	'pfunc_expr_unknown_error' => 'Erro de expressão: Erro desconhecido ($1)',
	'pfunc_expr_not_a_number' => 'Em $1: resultado não é um número',
	'pfunc_string_too_long' => 'Erro: cadeia de caracteres excede o limite de $1 caracteres',
	'pfunc-convert-unit-length-metre' => '{{PLURAL:$1| $2 metros | $2 metros}}',
	'pfunc-convert-unit-length-angstrom' => '{{PLURAL:$1| ångström | ångströms}}',
	'pfunc-convert-unit-length-mile' => '{{PLURAL:$1|milhas| milhas}}',
	'pfunc-convert-unit-length-furlong' => '{{PLURAL:$1| furlong | estádios}}',
	'pfunc-convert-unit-length-chain' => '{{PLURAL:$1| corrente | correntes}}',
	'pfunc-convert-unit-length-rod' => '{{PLURAL:$1| vara | varas}}',
	'pfunc-convert-unit-length-fathom' => '{{PLURAL:$1| fathom | braças}}',
	'pfunc-convert-unit-length-yard' => '{{PLURAL:$1|jarda|jardas}}',
	'pfunc-convert-unit-length-foot' => '{{PLURAL:$1| pé | pés}}',
	'pfunc-convert-unit-length-hand' => '{{PLURAL:$1| mão | mãos}}',
	'pfunc-convert-unit-length-inch' => '{{PLURAL:$1| polegada | polegadas}}',
	'pfunc-convert-unit-length-nauticalmile' => '{{PLURAL:$1| milha náutica | milhas náuticas}}',
	'pfunc-convert-unit-length-nauticalmileuk' => '{{PLURAL:$1| milhas náuticas (pré-1970 britânico) | milhas náuticas (pré-1970 britânico)}}',
	'pfunc-convert-unit-length-nauticalmileus' => '{{PLURAL:$1| milhas náuticas (pré-1954 dos EUA) | milhas náuticas (pré-1954 dos EUA)}}',
	'pfunc-convert-unit-length-parsec' => '{{PLURAL:$1| $2 parsec | $2 parsecs}}',
	'pfunc-convert-unit-length-lightyear' => '{{PLURAL:$1| $2 ano-luz | $2 anos-luz}}',
	'pfunc-convert-unit-length-astronomicalunit' => '{{PLURAL:$1| unidade astronômica | UA}}',
	'pfunc-convert-unit-length-furlong-abbr' => 'furlong',
	'pfunc-convert-unit-length-chain-abbr' => 'corrente',
	'pfunc-convert-unit-length-rod-abbr' => 'rd',
	'pfunc-convert-unit-length-fathom-abbr' => 'fathom',
	'pfunc-convert-unit-length-yard-abbr' => 'yd',
	'pfunc-convert-unit-length-foot-abbr' => 'ft',
);

/** Quechua (Runa Simi)
 * @author AlimanRuna
 */
$messages['qu'] = array(
	'pfunc_desc' => 'Parser nisqata sullwa ruranakunawan allinchay',
	'pfunc_time_error' => 'Pantasqa: Pachaqa manam allinchu',
	'pfunc_time_too_long' => 'Pantasqa: nisyu "#time" (pacha)',
	'pfunc_time_too_big' => "Pantasqa: #time nisqaqa 9999 watallakamam watakunata q'imin",
	'pfunc_rel2abs_invalid_depth' => 'Pantasqa: ñanpa ukhu kayninqa manam allinchu: "$1" (saphi khipu hawanpi kaq khiputam aypayta munaspa)',
	'pfunc_expr_stack_exhausted' => 'Rikuchikuypi pantasqa: Nisyu tawqa',
	'pfunc_expr_unexpected_number' => 'Rikuchikuypi pantasqa: Mana suyakusqa yupay',
	'pfunc_expr_preg_match_failure' => 'Rikuchikuypi pantasqa: Mana suyakusqa preg_match alqa',
	'pfunc_expr_unrecognised_word' => 'Rikuchikuypi pantasqa: Mana riqsisqa rima "$1"',
	'pfunc_expr_unexpected_operator' => 'Rikuchikuypi pantasqa: Mana suyakusqa ruraq "$1"',
	'pfunc_expr_missing_operand' => 'Rikuchikuypi pantasqa: Manam kanchu $1-paq ruraq',
	'pfunc_expr_unexpected_closing_bracket' => "Rikuchikuypi pantasqa: Nisyu wichq'aq qinchaq",
	'pfunc_expr_unrecognised_punctuation' => 'Rikuchikuypi pantasqa: Mana riqsisqa qillqa unancha "$1"',
	'pfunc_expr_unclosed_bracket' => "Rikuchikuypi pantasqa: Manam kanchu wichq'aq qinchaq",
	'pfunc_expr_division_by_zero' => "Ch'usaqwan rakisqa",
	'pfunc_expr_invalid_argument' => '$1-paq mana allin ninakuy: : < -1 icha > 1',
	'pfunc_expr_invalid_argument_ln' => 'ln-paq mana allin ninakuy: <= 0',
	'pfunc_expr_unknown_error' => 'Rikuchikuypi pantasqa: Mana riqsisqa pantasqa ($1)',
	'pfunc_expr_not_a_number' => '$1-pi: lluqsiyninqa manam yupaychu',
	'pfunc_string_too_long' => 'Pantasqa: Qillqa tiwlliqa $1 sanampa saywatam llallin',
);

/** Romanian (Română)
 * @author KlaudiuMihaila
 * @author Minisarm
 * @author Stelistcristi
 */
$messages['ro'] = array(
	'pfunc_desc' => 'Îmbunătățește parserul cu funcții logice',
	'pfunc_time_error' => 'Eroare: timp incorect',
	'pfunc_time_too_long' => 'Eroare: prea multe apeluri #time',
	'pfunc_time_too_big' => 'Eroare: #time acceptă doar ani până la 9999',
	'pfunc_rel2abs_invalid_depth' => 'Eroare: adâncime incorectă în cale: „$1” (încercat accesarea unui nod deasupra nodului rădăcină)',
	'pfunc_expr_stack_exhausted' => 'Eroare de expresie: stivă epuizată',
	'pfunc_expr_unexpected_number' => 'Eroare de expresie: număr neașteptat',
	'pfunc_expr_preg_match_failure' => 'Eroare de expresie: eșuare preg_match neașteptată',
	'pfunc_expr_unrecognised_word' => 'Eroare de expresie: „$1” este un cuvânt nerecunoscut',
	'pfunc_expr_unexpected_operator' => 'Eroare de expresie: operator $1 neașteptat',
	'pfunc_expr_missing_operand' => 'Eroare de expresie: operand lipsă pentru $1',
	'pfunc_expr_unexpected_closing_bracket' => 'Eroare de expresie: paranteză închisă neașteptată',
	'pfunc_expr_unrecognised_punctuation' => 'Eroare de expresie: caracter de punctuație „$1” necunoscut',
	'pfunc_expr_unclosed_bracket' => 'Eroare de expresie: paranteză neînchisă',
	'pfunc_expr_division_by_zero' => 'Împărțire la zero',
	'pfunc_expr_invalid_argument' => 'Argument incorect pentru $1: < -1 sau > 1',
	'pfunc_expr_invalid_argument_ln' => 'Argument incorect pentru ln: <= 0',
	'pfunc_expr_unknown_error' => 'Eroare de expresie: eroare necunoscută ($1)',
	'pfunc_expr_not_a_number' => 'În $1: rezultatul nu este un număr',
	'pfunc_string_too_long' => 'Eroare: șirul depășește limita de caractere de $1',
);

/** Tarandíne (Tarandíne)
 * @author Joetaras
 */
$messages['roa-tara'] = array(
	'pfunc_desc' => "L'analizzatore avanzate cu le funziune loggeche",
	'pfunc_time_error' => 'Errore: Orarie invalide',
	'pfunc_time_too_long' => 'Errore: stonne troppe #time chiamate',
	'pfunc_time_too_big' => "Errore: #time vole sulamende valore de anne 'mbonde a 9999",
	'pfunc_rel2abs_invalid_depth' => "Errore: Profondità invalide jndr'à 'u percorse: \"\$1\" (s'à pruvate a pigghià 'nu node sus a 'u node radice)",
	'pfunc_expr_stack_exhausted' => 'Espressione in errore: Stack anghiute',
	'pfunc_expr_unexpected_number' => 'Espressione in errore: Numere inaspettate',
	'pfunc_expr_preg_match_failure' => 'Espressione in errore: preg_match inaspettate e fallite',
	'pfunc_expr_unrecognised_word' => 'Espressione in errore: Parola scanusciute "$1"',
	'pfunc_expr_unexpected_operator' => 'Espressione in errore: Operatore $1 inaspettate',
	'pfunc_expr_missing_operand' => 'Espressione in errore: Operande zumbate pe $1',
	'pfunc_expr_unexpected_closing_bracket' => "Espressione in errore: Non g'onne state achiuse le parendesi",
	'pfunc_expr_unrecognised_punctuation' => 'Espressione in errore: Carattere de punde "$1" scanusciute',
	'pfunc_expr_unclosed_bracket' => 'Espressione in errore: Parendesi non achiuse',
	'pfunc_expr_division_by_zero' => 'Divisione pe zero',
	'pfunc_expr_invalid_argument' => 'Argomende invalide pe $1: < -1 o > 1',
	'pfunc_expr_invalid_argument_ln' => 'Argomende invalide pe ln: <= 0',
	'pfunc_expr_unknown_error' => 'Espressione in errore: Errore scanusciute ($1)',
	'pfunc_expr_not_a_number' => "In $1: 'u resultate non g'è 'nu numere",
	'pfunc_string_too_long' => "Errore: 'A stringhe supranesce 'u limite de $1 carattere",
);

/** Russian (Русский)
 * @author G0rn
 * @author Александр Сигачёв
 */
$messages['ru'] = array(
	'pfunc_desc' => 'Улучшенный синтаксический анализатор с логическими функциями',
	'pfunc_time_error' => 'Ошибка: неправильное время',
	'pfunc_time_too_long' => 'Ошибка: слишком много вызовов функции #time',
	'pfunc_time_too_big' => 'Ошибка. Параметр #time не может превышать 9999',
	'pfunc_rel2abs_invalid_depth' => 'Ошибка: ошибочная глубина пути: «$1» (попытка доступа к узлу, находящемуся выше, чем корневой)',
	'pfunc_expr_stack_exhausted' => 'Ошибка выражения: переполнение стека',
	'pfunc_expr_unexpected_number' => 'Ошибка выражения: неожидаемое число',
	'pfunc_expr_preg_match_failure' => 'Ошибка выражения: сбой preg_match',
	'pfunc_expr_unrecognised_word' => 'Ошибка выражения: неопознанное слово «$1»',
	'pfunc_expr_unexpected_operator' => 'Ошибка выражения: неожидаемый оператор $1',
	'pfunc_expr_missing_operand' => 'Ошибка выражения: $1 не хватает операнда',
	'pfunc_expr_unexpected_closing_bracket' => 'Ошибка выражения: неожидаемая закрывающая скобка',
	'pfunc_expr_unrecognised_punctuation' => 'Ошибка выражения: неопознанный символ пунктуации «$1»',
	'pfunc_expr_unclosed_bracket' => 'Ошибка выражения: незакрытая скобка',
	'pfunc_expr_division_by_zero' => 'Деление на ноль',
	'pfunc_expr_invalid_argument' => 'Ошибочный аргумент $1: < -1 или > 1',
	'pfunc_expr_invalid_argument_ln' => 'Ошибочный аргумент ln: <= 0',
	'pfunc_expr_unknown_error' => 'Ошибка выражения: неизвестная ошибка ($1)',
	'pfunc_expr_not_a_number' => 'В $1: результат не является числом',
	'pfunc_string_too_long' => 'Ошибка: строка превышает ограничение в $1 символов',
	'pfunc-convert-dimensionmismatch' => 'Ошибка. Не удается преобразовать единицы измерения «$1» и «$2».',
	'pfunc-convert-unknownunit' => 'Ошибка. Неизвестная единица «$1».',
	'pfunc-convert-unknowndimension' => 'Ошибка. Неизвестная размерность «$1».',
	'pfunc-convert-invalidcompoundunit' => 'Ошибка. Недопустимая составная единица «$1».',
	'pfunc-convert-nounit' => 'Ошибка. Не указана исходная единица.',
	'pfunc-convert-doublecompoundunit' => 'Ошибка. Невозможно разобрать двойные составные единицы вида «$1».',
	'pfunc-convert-dimension-length' => 'длина',
	'pfunc-convert-dimension-area' => 'площадь',
	'pfunc-convert-dimension-volume' => 'объём',
	'pfunc-convert-dimension-time' => 'время',
	'pfunc-convert-dimension-timesquared' => 'время<sup>2</sup>',
	'pfunc-convert-dimension-mass' => 'масса',
	'pfunc-convert-dimension-speed' => 'скорость',
	'pfunc-convert-dimension-temperature' => 'температура',
	'pfunc-convert-dimension-acceleration' => 'ускорение',
	'pfunc-convert-dimension-force' => 'сила',
	'pfunc-convert-dimension-torque' => 'крутящий момент',
	'pfunc-convert-dimension-energy' => 'энергия',
	'pfunc-convert-dimension-power' => 'мощность',
	'pfunc-convert-dimension-pressure' => 'давление',
	'pfunc-convert-dimension-density' => 'плотность',
	'pfunc-convert-dimension-fuelefficiencypositive' => 'позитивная топливная эффективность',
	'pfunc-convert-dimension-fuelefficiencynegative' => 'негативная топливная эффективность',
	'pfunc-convert-prefix-yotta' => 'йотта',
	'pfunc-convert-prefix-zetta' => 'зетта',
	'pfunc-convert-prefix-exa' => 'экса',
	'pfunc-convert-prefix-peta' => 'пета',
	'pfunc-convert-prefix-tera' => 'тера',
	'pfunc-convert-prefix-giga' => 'гига',
	'pfunc-convert-prefix-mega' => 'мега',
	'pfunc-convert-prefix-kilo' => 'кило',
	'pfunc-convert-prefix-hecto' => 'гекто',
	'pfunc-convert-prefix-deca' => 'дека',
	'pfunc-convert-prefix-deci' => 'деци',
	'pfunc-convert-prefix-centi' => 'санти',
	'pfunc-convert-prefix-milli' => 'милли',
	'pfunc-convert-prefix-micro' => 'микро',
	'pfunc-convert-prefix-nano' => 'нано',
	'pfunc-convert-prefix-pico' => 'пико',
	'pfunc-convert-prefix-femto' => 'фемто',
	'pfunc-convert-prefix-atto' => 'атто',
	'pfunc-convert-prefix-zepto' => 'зепто',
	'pfunc-convert-prefix-yocto' => 'йокто',
	'pfunc-convert-prefix-milli-abbr' => 'м',
	'pfunc-convert-unit-length-metre' => '$1{{PLURAL:$2|$3метр|$3метра|$3метров}}',
	'pfunc-convert-unit-length-angstrom' => '$1{{PLURAL:$2|ангстрем|ангстрема|ангстрем}}',
	'pfunc-convert-unit-length-mile' => '$1{{PLURAL:$2|миля|мили|миль}}',
	'pfunc-convert-unit-length-furlong' => '$1{{PLURAL:$2|фурлонг|фурлонга|фурлонгов}}',
	'pfunc-convert-unit-length-chain' => '$1{{PLURAL:$2|чейн|чейна|чейнов}}',
	'pfunc-convert-unit-length-rod' => '$1{{PLURAL:$2|род|рода|родов}}',
	'pfunc-convert-unit-length-fathom' => '$1{{PLURAL:$2|фатом|фатома|фатомов}}',
	'pfunc-convert-unit-length-yard' => '$1{{PLURAL:$2|ярд|ярда|ярдов}}',
	'pfunc-convert-unit-length-foot' => '$1{{PLURAL:$2|фут|фута|футов}}',
	'pfunc-convert-unit-length-hand' => '$1{{PLURAL:$2|хэнд|хэнда|хэндов}}',
	'pfunc-convert-unit-length-inch' => '$1{{PLURAL:$2|дюйм|дюйма|дюймов}}',
	'pfunc-convert-unit-length-nauticalmile' => '$1{{PLURAL:$2|морская миля|морские мили|морских милей}}',
	'pfunc-convert-unit-length-nauticalmileuk' => '$1{{PLURAL:$2|морская миля (британская до 1970)|морские мили (британских до 1970)|морских миль (британских до 1970)}}',
	'pfunc-convert-unit-length-nauticalmileus' => '$1{{PLURAL:$2|морская миля (США до 1970)|морские мили (США до 1970)|морских миль (США до 1970)}}',
	'pfunc-convert-unit-length-parsec' => '$1{{PLURAL:$2|$3парсек|$3парсека|$3парсек}}',
	'pfunc-convert-unit-length-lightyear' => '$1{{PLURAL:$2|$3 световой год|$3 световых года|$3 световых лет}}',
	'pfunc-convert-unit-length-astronomicalunit' => '$1{{PLURAL:$2|астрономическая единица|астрономические единицы|астрономических единиц}}',
	'pfunc-convert-unit-length-furlong-abbr' => '$1фурлонг',
	'pfunc-convert-unit-length-chain-abbr' => '$1чейн',
	'pfunc-convert-unit-length-rod-abbr' => '$1род',
	'pfunc-convert-unit-length-fathom-abbr' => '$1фатом',
	'pfunc-convert-unit-length-yard-abbr' => '$1ярд',
	'pfunc-convert-unit-length-foot-abbr' => '$1фут',
	'pfunc-convert-unit-length-hand-abbr' => '$1хэнд',
	'pfunc-convert-unit-length-inch-abbr' => '$1дюйм',
	'pfunc-convert-unit-length-nauticalmile-abbr' => '$1морская миля',
	'pfunc-convert-unit-length-nauticalmileuk-abbr' => '$1брит. морская миля',
	'pfunc-convert-unit-length-nauticalmileus-abbr' => '$1морская миля (США до 1954)',
	'pfunc-convert-unit-length-parsec-abbr' => '$1$3 пк',
	'pfunc-convert-unit-length-lightyear-abbr' => '$1$3 св. г.',
	'pfunc-convert-unit-length-astronomicalunit-abbr' => '$1а. е.',
	'pfunc-convert-unit-area-squarekilometre' => '$1{{PLURAL:$2|квадратный километр|квадратных километра|квадратных километров}}',
	'pfunc-convert-unit-area-squaremetre' => '$1{{PLURAL:$2|квадратный метр|квадратных метра|квадратных метров}}',
	'pfunc-convert-unit-area-squarecentimetre' => '$1{{PLURAL:$2|квадратный сантиметр|квадратных сантиметра|квадратных сантиметров}}',
	'pfunc-convert-unit-area-squaremillimetre' => '$1{{PLURAL:$2|квадратный миллиметр|квадратных миллиметра|квадратных миллиметров}}',
	'pfunc-convert-unit-area-hectare' => '$1{{PLURAL:$2|гектар|гектара|гектар}}',
	'pfunc-convert-unit-area-squaremile' => '$1{{PLURAL:$2|квадратная миля|квадратных мили|квадратных миль}}',
	'pfunc-convert-unit-area-acre' => '$1{{PLURAL:$2|акр|акра|акров}}',
	'pfunc-convert-unit-area-squareyard' => '$1{{PLURAL:$2|квадратный ярд|квадратных ярда|квадратных ярдов}}',
	'pfunc-convert-unit-area-squarefoot' => '$1{{PLURAL:$2|квадратный фут|квадратных фута|квадратных футов}}',
	'pfunc-convert-unit-area-squareinch' => '$1{{PLURAL:$2|квадратный дюйм|квадратных дюйма|квадратных дюймов}}',
	'pfunc-convert-unit-area-squarenauticalmile' => '$1{{PLURAL:$2|квадратная морская миля|квадратные морские мили|квадратных морских миль}}',
	'pfunc-convert-unit-area-dunam' => '$1{{PLURAL:$2|дунам|дунама|дунамов}}',
	'pfunc-convert-unit-area-tsubo' => '$1{{PLURAL:$2|цубо|цубо|цубо}}',
	'pfunc-convert-unit-area-squarekilometre-abbr' => '$1км<sup>2</sup>',
	'pfunc-convert-unit-area-squaremetre-abbr' => '$1м<sup>2</sup>',
	'pfunc-convert-unit-area-squarecentimetre-abbr' => '$1см<sup>2</sup>',
	'pfunc-convert-unit-area-squaremillimetre-abbr' => '$1мм<sup>2</sup>',
	'pfunc-convert-unit-area-hectare-abbr' => '$1га',
	'pfunc-convert-unit-area-squaremile-abbr' => '$1кв. ми',
	'pfunc-convert-unit-area-acre-abbr' => '$1акр',
	'pfunc-convert-unit-area-squareyard-abbr' => '$1кв. ярд',
	'pfunc-convert-unit-area-squarefoot-abbr' => '$1кв. м',
	'pfunc-convert-unit-area-squareinch-abbr' => '$1кв. дюйм',
	'pfunc-convert-unit-area-squarenauticalmile-abbr' => '$1кв. м. ми',
	'pfunc-convert-unit-area-dunam-abbr' => '$1дунам',
	'pfunc-convert-unit-area-tsubo-abbr' => '$1цубо',
	'pfunc-convert-unit-time-second' => '$1{{PLURAL:$2|секунда|секунды|секунд}}',
	'pfunc-convert-unit-time-year' => '$1{{PLURAL:$2|$3год|$3года|$3лет}}',
	'pfunc-convert-unit-time-day' => '$1{{PLURAL:$2|день|дня|дней}}',
	'pfunc-convert-unit-time-hour' => '$1{{PLURAL:$2|час|часа|часов}}',
	'pfunc-convert-unit-time-minute' => '$1{{PLURAL:$2|минута|минуты|минут}}',
	'pfunc-convert-unit-time-second-abbr' => '$1с',
	'pfunc-convert-unit-time-year-abbr' => '$1$3 г',
	'pfunc-convert-unit-time-day-abbr' => '$1дн',
	'pfunc-convert-unit-time-hour-abbr' => '$1ч.',
	'pfunc-convert-unit-time-minute-abbr' => '$1м.',
	'pfunc-convert-unit-volume-cubicmetre' => '$1{{PLURAL:$2|кубический метр|кубических метра|кубических метров}}',
	'pfunc-convert-unit-volume-cubiccentimetre' => '$1{{PLURAL:$2|кубический сантиметр|кубических сантиметра|кубических сантиметров}}',
	'pfunc-convert-unit-volume-cubicmillimetre' => '$1{{PLURAL:$2|кубический миллиметр|кубических миллиметра|кубических миллиметров}}',
	'pfunc-convert-unit-volume-kilolitre' => '$1{{PLURAL:$2|килолитр|килолитра|килолитров}}',
	'pfunc-convert-unit-volume-litre' => '$1{{PLURAL:$2|литр|литра|литров}}',
	'pfunc-convert-unit-volume-centilitre' => '$1{{PLURAL:$2|сантилитр|сантилитра|сантилитров}}',
	'pfunc-convert-unit-volume-millilitre' => '$1{{PLURAL:$2|миллилитр|миллилитра|миллилитров}}',
	'pfunc-convert-unit-volume-cubicyard' => '$1{{PLURAL:$2|кубический ярд|кубических ярда|кубических ярдов}}',
	'pfunc-convert-unit-volume-cubicfoot' => '$1{{PLURAL:$2|кубический фут|кубических фута|кубических футов}}',
	'pfunc-convert-unit-volume-cubicinch' => '$1{{PLURAL:$2|кубический дюйм|кубических дюйма|кубических дюймов}}',
	'pfunc-convert-unit-volume-barrel' => '$1{{PLURAL:$2|баррель|барреля|баррелей}}',
	'pfunc-convert-unit-volume-bushel' => '$1{{PLURAL:$2|бушель|бушеля|бушелей}}',
	'pfunc-convert-unit-volume-gallon' => '$1{{PLURAL:$2|галлон|галлона|галлонов}}',
	'pfunc-convert-unit-volume-quart' => '$1{{PLURAL:$2|кварта|кварты|кварт}}',
	'pfunc-convert-unit-volume-pint' => '$1{{PLURAL:$2|пинта|пинты|пинт}}',
	'pfunc-convert-unit-volume-fluidounce' => '$1{{PLURAL:$2|жидкая унция|жидких унции|жидких унций}}',
	'pfunc-convert-unit-volume-barrelus' => '$1{{PLURAL:$2|баррель США|барреля США|баррелей США}}',
	'pfunc-convert-unit-volume-barreloil' => '$1{{PLURAL:$2|баррель|барреля|баррелей}}',
	'pfunc-convert-unit-volume-barrelbeer' => '$1{{PLURAL:$2|баррель|барреля|баррелей}}',
	'pfunc-convert-unit-volume-usgallon' => '$1{{PLURAL:$2|галлон США|галлона США|галлонов США}}',
	'pfunc-convert-unit-volume-usquart' => '$1{{PLURAL:$2|кварта США|кварты США|кварт США}}',
	'pfunc-convert-unit-volume-uspint' => '$1{{PLURAL:$2|пинта США|пинты США|пинт США}}',
	'pfunc-convert-unit-volume-usfluidounce' => '$1{{PLURAL:$2|жидкая унция США|жидких унции США|жидких унций США}}',
	'pfunc-convert-unit-volume-usdrybarrel' => '$1{{PLURAL:$2|сухой баррель США|сухих барреля США|сухих баррелей США}}',
	'pfunc-convert-unit-volume-usbushel' => '$1{{PLURAL:$2|бушель США|бушеля США|бушелей США}}',
	'pfunc-convert-unit-volume-usdrygallon' => '$1{{PLURAL:$2|сухой галлон США|сухих галлона США|сухих галлонов США}}',
	'pfunc-convert-unit-volume-usdryquart' => '$1{{PLURAL:$2|сухая кварта США|сухие кварты США|сухих кварт США}}',
	'pfunc-convert-unit-volume-usdrypint' => '$1{{PLURAL:$2|сухая пинта США|сухих пинты США|сухих пинт США}}',
	'pfunc-convert-unit-volume-cubicmetre-abbr' => '$1м<sup>3</sup>',
	'pfunc-convert-unit-volume-cubiccentimetre-abbr' => '$1см<sup>3</sup>',
	'pfunc-convert-unit-volume-cubicmillimetre-abbr' => '$1мм<sup>3</sup>',
	'pfunc-convert-unit-volume-litre-abbr' => '$1$3 л',
	'pfunc-convert-unit-volume-cubicyard-abbr' => '$1куб. ярд',
	'pfunc-convert-unit-volume-cubicfoot-abbr' => '$1куб. фут',
	'pfunc-convert-unit-volume-cubicinch-abbr' => '$1куб. дюйм',
	'pfunc-convert-unit-volume-barrel-abbr' => '$1бр.',
	'pfunc-convert-unit-volume-bushel-abbr' => '$1бш.',
	'pfunc-convert-unit-volume-gallon-abbr' => '$1гал.',
	'pfunc-convert-unit-volume-quart-abbr' => '$1кв.',
	'pfunc-convert-unit-volume-pint-abbr' => '$1пт.',
	'pfunc-convert-unit-volume-fluidounce-abbr' => '$1жид. унц.',
	'pfunc-convert-unit-volume-barrelus-abbr' => '$1бр. США',
	'pfunc-convert-unit-volume-barreloil-abbr' => '$1бр.',
	'pfunc-convert-unit-volume-barrelbeer-abbr' => '$1бр.',
	'pfunc-convert-unit-volume-usgallon-abbr' => '$1гал. США',
	'pfunc-convert-unit-volume-usquart-abbr' => '$1кт. США',
	'pfunc-convert-unit-volume-uspint-abbr' => '$1пт. США',
	'pfunc-convert-unit-volume-usfluidounce-abbr' => '$1жид. унц. США',
	'pfunc-convert-unit-volume-usdrybarrel-abbr' => '$1бр. США',
	'pfunc-convert-unit-volume-usbushel-abbr' => '$1вш. США',
	'pfunc-convert-unit-volume-usdrygallon-abbr' => '$1сух. гал. США',
	'pfunc-convert-unit-volume-usdryquart-abbr' => '$1сух. кт. США',
	'pfunc-convert-unit-volume-usdrypint-abbr' => '$1сух. пт. США',
	'pfunc-convert-unit-speed-mile-hour' => '$1миль/час',
	'pfunc-convert-unit-speed-speedoflight' => '$1c',
	'pfunc-convert-unit-speed-mile-hour-abbr' => '$1миль/ч',
	'pfunc-convert-unit-speed-speedoflight-abbr' => '$1c',
	'pfunc-convert-unit-pressure-pascal' => '$1{{PLURAL:$2|$3паскаль|$3паскаля|$3паскалей}}',
	'pfunc-convert-unit-pressure-bar' => '$1бар',
	'pfunc-convert-unit-pressure-decibar' => '$1децибар',
	'pfunc-convert-unit-pressure-millibar' => '$1миллибар',
	'pfunc-convert-unit-pressure-kilobarye' => '$1килобария',
	'pfunc-convert-unit-pressure-barye' => '$1бария',
	'pfunc-convert-unit-pressure-atmosphere' => '$1{{PLURAL:$2|атмосфера|атмосферы|атмосфер}}',
	'pfunc-convert-unit-pressure-torr' => '$1{{PLURAL:$2|торр|торра|торр}}',
	'pfunc-convert-unit-pressure-mmhg' => '$1{{PLURAL:$2|миллиметр ртутного столба|миллиметра ртутного столба|миллиметров ртутного столба}}',
	'pfunc-convert-unit-pressure-inhg' => '$1{{PLURAL:$2|дюйм ртутного столба|дюйма ртутного столба|дюймов ртутного столба}}',
	'pfunc-convert-unit-pressure-psi' => '$1{{PLURAL:$2|фунт на квадратный дюйм|фунта на квадратный дюйм|фунтов на квадратный дюйм}}',
	'pfunc-convert-unit-pressure-pascal-abbr' => '$1$3Па',
	'pfunc-convert-unit-pressure-bar-abbr' => '$1бар',
	'pfunc-convert-unit-pressure-decibar-abbr' => '$1дбар',
	'pfunc-convert-unit-pressure-millibar-abbr' => '$1мбар',
	'pfunc-convert-unit-pressure-kilobarye-abbr' => '$1КБа',
	'pfunc-convert-unit-pressure-barye-abbr' => '$1Ба',
	'pfunc-convert-unit-pressure-atmosphere-abbr' => '$1атм',
	'pfunc-convert-unit-pressure-torr-abbr' => '$1торр',
	'pfunc-convert-unit-pressure-mmhg-abbr' => '$1мм рт. ст.',
	'pfunc-convert-unit-pressure-inhg-abbr' => '$1дюйм. рт. ст.',
	'pfunc-convert-unit-pressure-psi-abbr' => '$1фунт. на кв. дюйм',
);

/** Rusyn (Русиньскый)
 * @author Gazeb
 */
$messages['rue'] = array(
	'pfunc_desc' => 'Росшырїня парсера о лоґічны функції',
	'pfunc_time_error' => 'Хына: неплатный час',
	'pfunc_time_too_long' => 'Хыба: дуже много кликаня #time',
	'pfunc_rel2abs_invalid_depth' => 'Хыба: Неплатна глубка в стежцї: "$1" (проба  о приступ до узла высшого як корїнь)',
	'pfunc_expr_stack_exhausted' => 'Хыба выразу: Засобник переповненый',
	'pfunc_expr_unexpected_number' => 'Хыба выразу: Чекане чісло',
	'pfunc_expr_preg_match_failure' => 'Хыба выразу: Нечекана хыба функції preg_match',
	'pfunc_expr_unrecognised_word' => 'Хыба выразу: Нерозпознане слово „$1“',
	'pfunc_expr_unexpected_operator' => 'Хыба выразу: Нечеканый оператор: $1',
	'pfunc_expr_missing_operand' => 'Хыба выразу: Хыбить операнд про $1',
	'pfunc_expr_unexpected_closing_bracket' => 'Хыба выразу: Нечекана заперача заперка',
	'pfunc_expr_unrecognised_punctuation' => 'Хыба выразу: Нерозпознаный роздїловый знак „$1“',
	'pfunc_expr_unclosed_bracket' => 'Хыба ыразу: Незаперты заперкы',
	'pfunc_expr_division_by_zero' => 'Дїлїня нулов',
	'pfunc_expr_invalid_argument' => 'Неправилный арґумент про $1: < -1 або > 1',
	'pfunc_expr_invalid_argument_ln' => 'Неправилный арґумент про ln: <= 0',
	'pfunc_expr_unknown_error' => 'Хыба выразу: Незнама хыба ($1)',
	'pfunc_expr_not_a_number' => 'У $1: резултат не є чісло',
	'pfunc_string_too_long' => 'Хыба: Ланц є довшый як $1 {{PLURAL:$1|знак|знакы|знаків}}, што є ліміт',
);

/** Sakha (Саха тыла)
 * @author HalanTul
 */
$messages['sah'] = array(
	'pfunc_desc' => 'Логическай функциялаах тупсарыллыбыт синтаксическай анализатор',
	'pfunc_time_error' => 'Алҕас: сыыһа кэм',
	'pfunc_time_too_long' => 'Алҕас: #time функция наһаа элбэхтик хатыламмыт',
	'pfunc_time_too_big' => 'Алҕас: #time  9999-у ааһыа суохтаах',
	'pfunc_rel2abs_invalid_depth' => 'Алҕас: ошибочная глубина пути: «$1» (попытка доступа к узлу, находящемуся выше, чем корневой)',
	'pfunc_expr_stack_exhausted' => 'Ошибка выражения: переполнение стека',
	'pfunc_expr_unexpected_number' => 'Алҕас: кэтэһиллибэтэх чыыһыла',
	'pfunc_expr_preg_match_failure' => 'Алҕас: preg_match моһуоктанна',
	'pfunc_expr_unrecognised_word' => 'Алҕас: биллибэт тыл «$1»',
	'pfunc_expr_unexpected_operator' => 'Алҕас: кэтэһиллибэтэх оператор $1',
	'pfunc_expr_missing_operand' => 'Алҕас: $1 операнда тиийбэт',
	'pfunc_expr_unexpected_closing_bracket' => 'Алҕас: кэтэһиллибэтэх сабар ускуопка',
	'pfunc_expr_unrecognised_punctuation' => 'Алҕас: биллибэт пунктуация бэлиэтэ «$1»',
	'pfunc_expr_unclosed_bracket' => 'Алҕас: сабыллыбатах ускуопка',
	'pfunc_expr_division_by_zero' => 'Нуулга түҥэттии',
	'pfunc_expr_invalid_argument' => '$1 алҕас аргуменнаах: < -1 or > 1',
	'pfunc_expr_invalid_argument_ln' => 'ln аргумена сыыһалаах: <= 0',
	'pfunc_expr_unknown_error' => 'Expression error (ошибка выражения): Биллибэт алҕас ($1)',
	'pfunc_expr_not_a_number' => '$1 иһигэр: эппиэтэ чыыһыла буолбатах',
	'pfunc_string_too_long' => 'Алҕас: Устуруока уһуна $1 бэлиэннэн хааччахха баппат',
);

/** Sicilian (Sicilianu)
 * @author Melos
 * @author Santu
 */
$messages['scn'] = array(
	'pfunc_desc' => 'Ci junci ô parser na sèrii di funzioni lòggichi',
	'pfunc_time_error' => 'Sbàgghiu: uràriu nun vàlidu',
	'pfunc_time_too_long' => 'Sbàgghiu: troppi chiamati a #time',
	'pfunc_rel2abs_invalid_depth' => 'Sbàgghiu: prufunnità non vàlida ntô pircorsu "$1" (si tintau di tràsiri a nu nodu cchiù supra di la ràdica)',
	'pfunc_expr_stack_exhausted' => 'Sbàgghiu nti la sprissioni: lu stack finìu',
	'pfunc_expr_unexpected_number' => 'Sbàgghiu nti la sprissioni: nùmmiru non privistu',
	'pfunc_expr_preg_match_failure' => "Sbàgghiu nti la sprissioni: sbàgghiu non privistu 'n preg_match",
	'pfunc_expr_unrecognised_word' => 'Sbàgghiu nti la sprissioni: palora "$1" non canusciuta',
	'pfunc_expr_unexpected_operator' => 'Sbàgghiu nti la sprissioni: upiraturi $1 non privistu',
	'pfunc_expr_missing_operand' => 'Sbàgghiu nti la sprissioni: upirandu mancanti pi $1',
	'pfunc_expr_unexpected_closing_bracket' => 'Sbàgghiu nti la sprissioni: parèntisi chiusa non aspittata',
	'pfunc_expr_unrecognised_punctuation' => 'Sbàgghiu nti la sprissioni: caràttiri di puntiggiatura "$1" non canusciutu',
	'pfunc_expr_unclosed_bracket' => 'Sbàgghiu nti la sprissioni: parèntisi non chiuruta',
	'pfunc_expr_division_by_zero' => 'Divisioni pi zeru',
	'pfunc_expr_invalid_argument' => 'Argumentu non vàlidu pi $1: < -1 o > 1',
	'pfunc_expr_invalid_argument_ln' => 'Argumentu non vàlidu pi ln: <= 0',
	'pfunc_expr_unknown_error' => 'Sbàgghiu nti la sprissioni: sbàgghiu scanusciutu ($1)',
	'pfunc_expr_not_a_number' => 'Nti $1: lu risurtatu nun è nu nùmmiru',
	'pfunc_string_too_long' => 'Erruri: la stringa supira lu limiti di $1 carattiri',
);

/** Sinhala (සිංහල)
 * @author Budhajeewa
 * @author නන්දිමිතුරු
 */
$messages['si'] = array(
	'pfunc_desc' => 'තාර්කීක ශ්‍රිතයන් උපයෝගී කරගනිමින් ව්‍යාකරණ විග්‍රහකය වර්ධනය කරන්න',
	'pfunc_time_error' => 'දෝෂය: අනීතික වේලාව',
	'pfunc_time_too_long' => 'දෝෂය: වේලා ඇමතුම් # පමණට වැඩිය',
	'pfunc_rel2abs_invalid_depth' => 'දෝෂය: පෙතෙහි ගැඹුර අනීතිකයි: "$1" (මූල මංසලට ඉහළ මංසලක් ප්‍රවේශනයට උත්සාහ දැරිණි)',
	'pfunc_expr_stack_exhausted' => 'ප්‍රකාශන දෝෂය: ඇසිරුම හිස්ව පැවතිණි',
	'pfunc_expr_unexpected_number' => 'ප්‍රකාශන දෝෂය: අනපේක්‍ෂිත සංඛ්‍යාව',
	'pfunc_expr_preg_match_failure' => 'ප්‍රකාශන දෝෂය: බලාපොරොත්තු නොවූ preg_match ඇණහිටුම',
	'pfunc_expr_unrecognised_word' => 'ප්‍රකාශන දෝෂය: හඳුනානොගත් වදන "$1"',
	'pfunc_expr_unexpected_operator' => 'ප්‍රකාශන දෝෂය: අනපේක්‍ෂිත $1 මෙහෙයුම්කාරකය',
	'pfunc_expr_missing_operand' => 'ප්‍රකාශන දෝෂය: $1 සඳහා අස්ථානගත ප්‍රවර්ත්‍යය',
	'pfunc_expr_unexpected_closing_bracket' => 'ප්‍රකාශන දෝෂය: අනපේක්‍ෂිත වැසීම් වරහන',
	'pfunc_expr_unrecognised_punctuation' => 'ප්‍රකාශන දෝෂය: හඳුනානොගත් විරාම අක්ෂරය "$1"',
	'pfunc_expr_unclosed_bracket' => 'ප්‍රකාශන දෝෂය: නොවැසූ වරහන',
	'pfunc_expr_division_by_zero' => 'ශුන්‍යයෙන් බෙදීම',
	'pfunc_expr_invalid_argument' => '$1: < -1 හෝ > 1 සඳහා අනීතික විස්තාරකය',
	'pfunc_expr_invalid_argument_ln' => 'ln: <= 0 සඳහා අනීතික විස්තාරකය',
	'pfunc_expr_unknown_error' => 'ප්‍රකාශන දෝෂය: අඥාත දෝෂය ($1)',
	'pfunc_expr_not_a_number' => '$1: හි ප්‍රතිඵලය සංඛ්‍යාවක් නොවේ',
	'pfunc_string_too_long' => 'Error: වදන් පෙළ අකුරු $1 සීමාව ඉක්මවයි',
);

/** Slovak (Slovenčina)
 * @author Helix84
 */
$messages['sk'] = array(
	'pfunc_desc' => 'Rozšírenie syntaktického analyzátora o logické funkcie',
	'pfunc_time_error' => 'Chyba: Neplatný čas',
	'pfunc_time_too_long' => 'Chyba: príliš veľa volaní #time',
	'pfunc_rel2abs_invalid_depth' => 'Chyba: Neplatná hĺbka v ceste: „$1“ (pokus o prístup k uzlu nad koreňovým uzlom)',
	'pfunc_expr_stack_exhausted' => 'Chyba výrazu: Zásobník vyčerpaný',
	'pfunc_expr_unexpected_number' => 'Chyba výrazu: Neočakávané číslo',
	'pfunc_expr_preg_match_failure' => 'Chyba výrazu: Neočakávané zlyhanie funkcie preg_match',
	'pfunc_expr_unrecognised_word' => 'Chyba výrazu: Nerozpoznané slovo „$1“',
	'pfunc_expr_unexpected_operator' => 'Chyba výrazu: Neočakávaný operátor $1',
	'pfunc_expr_missing_operand' => 'Chyba výrazu: Chýbajúci operand pre $1',
	'pfunc_expr_unexpected_closing_bracket' => 'Chyba výrazu: Neočakávaná zatvárajúca hranatá zátvorka',
	'pfunc_expr_unrecognised_punctuation' => 'Chyba výrazu: Nerozpoznané diakritické znamienko „$1“',
	'pfunc_expr_unclosed_bracket' => 'Chyba výrazu: Neuzavretá hranatá zátvorka',
	'pfunc_expr_division_by_zero' => 'Chyba výrazu: Delenie nulou',
	'pfunc_expr_invalid_argument' => 'Neplatný argument pre $1: < -1 alebo > 1',
	'pfunc_expr_invalid_argument_ln' => 'Neplatný argument pre ln: <= 0',
	'pfunc_expr_unknown_error' => 'Chyba výrazu: Neznáma chyba ($1)',
	'pfunc_expr_not_a_number' => 'V $1: výsledok nie je číslo',
	'pfunc_string_too_long' => 'Chyba: Reťazec prekračuje limit $1 znakov',
);

/** Slovenian (Slovenščina)
 * @author Dbc334
 */
$messages['sl'] = array(
	'pfunc_desc' => 'Izboljša razčlenjevalnik z logičnimi funkcijami',
	'pfunc_time_error' => 'Napaka: neveljaven čas',
	'pfunc_time_too_long' => 'Napaka: preveč klicev #time',
	'pfunc_time_too_big' => 'Napaka: #time podpira samo leta do 9999',
	'pfunc_rel2abs_invalid_depth' => 'Napaka: Neveljavna globina poti: »$1« (poskus dostopanja do vozlišča višjega od korenskega vozlišča)',
	'pfunc_expr_stack_exhausted' => 'Napaka v izrazu: Sklad je izčrpan',
	'pfunc_expr_unexpected_number' => 'Napaka v izrazu: Nepričakovani število',
	'pfunc_expr_preg_match_failure' => 'Napaka v izrazu: Nepričakovan neuspeh preg_match',
	'pfunc_expr_unrecognised_word' => 'Napaka v izrazu: Neprepoznana beseda »$1«',
	'pfunc_expr_unexpected_operator' => 'Napaka v izrazu: Nepričakovan operator $1',
	'pfunc_expr_missing_operand' => 'Napaka v izrazu: Manjkajoč operand za $1',
	'pfunc_expr_unexpected_closing_bracket' => 'Napaka v izrazu: Nepričakovan zaključni oklepaj',
	'pfunc_expr_unrecognised_punctuation' => 'Napaka v izrazu: Nepričakovan znak za ločilo »$1«',
	'pfunc_expr_unclosed_bracket' => 'Napaka v izrazu: Nezaprti oklepaj',
	'pfunc_expr_division_by_zero' => 'Deljenje z ničlo',
	'pfunc_expr_invalid_argument' => 'Napačen argument za $1: < -1 ali > 1',
	'pfunc_expr_invalid_argument_ln' => 'Napačen argument za ln: <= 0',
	'pfunc_expr_unknown_error' => 'Napaka v izrazu: Neznana napaka ($1)',
	'pfunc_expr_not_a_number' => 'V $1: rezultat ni število',
	'pfunc_string_too_long' => 'Napaka: Niz presega omejitev $1 {{PLURAL:$1|znaka|znakov}}',
	'pfunc-convert-dimensionmismatch' => 'Napaka: Ne morem pretvoriti med enotama »$1« in »$2«.',
	'pfunc-convert-unknownunit' => 'Napaka: Neznana enota »$1«.',
	'pfunc-convert-unknowndimension' => 'Napaka: Neznana razsežnost »$1«.',
	'pfunc-convert-invalidcompoundunit' => 'Napaka: Neveljavna sestavljena enota »$1«.',
	'pfunc-convert-nounit' => 'Napaka: Izvirna enota ni podana.',
	'pfunc-convert-doublecompoundunit' => 'Napaka: Ne morem razčleniti dvojne sestavljene enote, kot je »$1«.',
	'pfunc-convert-dimension-length' => 'dolžina',
	'pfunc-convert-dimension-area' => 'ploščina',
	'pfunc-convert-dimension-volume' => 'prostornina',
	'pfunc-convert-dimension-time' => 'čas',
	'pfunc-convert-dimension-timesquared' => 'čas<sup>2</sup>',
	'pfunc-convert-dimension-mass' => 'masa',
	'pfunc-convert-dimension-speed' => 'hitrost',
	'pfunc-convert-dimension-temperature' => 'temperatura',
	'pfunc-convert-dimension-acceleration' => 'pospešek',
	'pfunc-convert-dimension-force' => 'sila',
	'pfunc-convert-dimension-torque' => 'navor',
	'pfunc-convert-dimension-energy' => 'energija',
	'pfunc-convert-dimension-power' => 'moč',
	'pfunc-convert-dimension-pressure' => 'tlak',
	'pfunc-convert-dimension-density' => 'gostota',
	'pfunc-convert-dimension-fuelefficiencypositive' => 'pozitivna učinkovitost goriva',
	'pfunc-convert-dimension-fuelefficiencynegative' => 'negativna učinkovitost goriva',
	'pfunc-convert-prefix-yotta' => 'jota',
	'pfunc-convert-prefix-zetta' => 'zeta',
	'pfunc-convert-prefix-exa' => 'eksa',
	'pfunc-convert-prefix-peta' => 'peta',
	'pfunc-convert-prefix-tera' => 'tera',
	'pfunc-convert-prefix-giga' => 'giga',
	'pfunc-convert-prefix-mega' => 'mega',
	'pfunc-convert-prefix-kilo' => 'kilo',
	'pfunc-convert-prefix-hecto' => 'hekto',
	'pfunc-convert-prefix-deca' => 'deka',
	'pfunc-convert-prefix-deci' => 'deci',
	'pfunc-convert-prefix-centi' => 'centi',
	'pfunc-convert-prefix-milli' => 'mili',
	'pfunc-convert-prefix-micro' => 'mikro',
	'pfunc-convert-prefix-nano' => 'nano',
	'pfunc-convert-prefix-pico' => 'piko',
	'pfunc-convert-prefix-femto' => 'femto',
	'pfunc-convert-prefix-atto' => 'ato',
	'pfunc-convert-prefix-zepto' => 'zepto',
	'pfunc-convert-prefix-yocto' => 'jokto',
	'pfunc-convert-prefix-milli-abbr' => 'm',
	'pfunc-convert-unit-length-metre' => '$1{{PLURAL:$2|meter|metra|metri|metrov}}',
	'pfunc-convert-unit-length-angstrom' => '$1{{PLURAL:$2|angstrem|angstrema|angstremi|angstremov}}',
	'pfunc-convert-unit-length-mile' => '$1{{PLURAL:$2|milja|milji|milje|milj}}',
	'pfunc-convert-unit-length-furlong' => '$1{{PLURAL:$2|furlong|furlonga|furlongi|furlongov}}',
	'pfunc-convert-unit-length-chain' => '$1{{PLURAL:$2|veriga|verigi|verige|verig}}',
	'pfunc-convert-unit-length-rod' => '$1{{PLURAL:$2|palica|palici|palice|palic}}',
	'pfunc-convert-unit-length-fathom' => '$1{{PLURAL:$2|seženj|sežnja|sežnji|sežnjev}}',
	'pfunc-convert-unit-length-yard' => '$1{{PLURAL:$2|jard|jarda|jardi|jardov}}',
	'pfunc-convert-unit-length-foot' => '$1{{PLURAL:$2|čevelj|čevlja|čevlji|čeljev}}',
	'pfunc-convert-unit-length-hand' => '$1{{PLURAL:$2|dlan|dlani}}',
	'pfunc-convert-unit-length-inch' => '$1{{PLURAL:$2|palec|palca|palci|palcev}}',
	'pfunc-convert-unit-length-nauticalmile' => '$1{{PLURAL:$2|navtična milja|navtični milji|navtične milje|navtičnih milj}}',
	'pfunc-convert-unit-length-nauticalmileuk' => '$1{{PLURAL:$2|navtična milja|navtični milji|navtične milje|navtičnih milj}} (britanska, pred 1970)',
	'pfunc-convert-unit-length-nauticalmileus' => '$1{{PLURAL:$2|navtična milja|navtični milji|navtične milje|navtičnih milj}} (ZDA, pred 1954)',
	'pfunc-convert-unit-length-parsec' => '$1{{PLURAL:$2|parsek|parseka|parseki|persekov}}',
	'pfunc-convert-unit-length-lightyear' => '$1$3 {{PLURAL:$2|svetlobno leto|svetlobni leti|svetlobna leta|svetlobnih let}}',
	'pfunc-convert-unit-length-astronomicalunit' => '$1{{PLURAL:$2|astronomska enota|astronomski enoti|astronomske enote|astronomskih enot}}',
	'pfunc-convert-unit-length-metre-abbr' => '$1m',
	'pfunc-convert-unit-length-angstrom-abbr' => '$1Å',
	'pfunc-convert-unit-length-furlong-abbr' => '$1furlong',
	'pfunc-convert-unit-length-chain-abbr' => '$1veriga',
	'pfunc-convert-unit-length-rod-abbr' => '$1rd',
	'pfunc-convert-unit-length-fathom-abbr' => '$1seženj',
	'pfunc-convert-unit-length-yard-abbr' => '$1yd',
	'pfunc-convert-unit-length-foot-abbr' => '$1ft',
	'pfunc-convert-unit-length-hand-abbr' => '$1h',
	'pfunc-convert-unit-length-inch-abbr' => '$1in',
	'pfunc-convert-unit-length-nauticalmile-abbr' => '$1nmi',
	'pfunc-convert-unit-length-nauticalmileuk-abbr' => '$1nmi (Brit)',
	'pfunc-convert-unit-length-nauticalmileus-abbr' => '$1nmi (ZDA, pred 1954)',
	'pfunc-convert-unit-length-parsec-abbr' => '$1$3 pc',
	'pfunc-convert-unit-length-lightyear-abbr' => '$1$3 sv. l.',
	'pfunc-convert-unit-length-astronomicalunit-abbr' => '$1a.e.',
	'pfunc-convert-unit-area-squarekilometre' => '$1{{PLURAL:$2|kvadratni kilometer|kvadratna kilometra|kvadratni kilometri|kvadratnih kilometrov}}',
	'pfunc-convert-unit-area-squaremetre' => '$1{{PLURAL:$2|kvadratni meter|kvadratna metra|kvadratni metri|kvadratnih metrov}}',
	'pfunc-convert-unit-area-squarecentimetre' => '$1{{PLURAL:$2|kvadratni centimeter|kvadratna centimetra|kvadratni centimetri|kvadratnih centimetrov}}',
	'pfunc-convert-unit-area-squaremillimetre' => '$1{{PLURAL:$2|kvadratni milimeter|kvadratna milimetra|kvadratni milimetri|kvadratnih milimetrov}}',
	'pfunc-convert-unit-area-hectare' => '$1{{PLURAL:$2|hektar|hektara|hektare|hektarov}}',
	'pfunc-convert-unit-area-squaremile' => '$1{{PLURAL:$2|kvadratna milja|kvadratni milji|kvadratne milje|kvadratnih milj}}',
	'pfunc-convert-unit-area-acre' => '$1{{PLURAL:$2|aker|akra|akri|akrov}}',
	'pfunc-convert-unit-area-squareyard' => '$1{{PLURAL:$2|kvadratni jard|kvadratna jarda|kvadratni jardi|kvadratnih jardov}}',
	'pfunc-convert-unit-area-squarefoot' => '$1{{PLURAL:$2|kvadratni čevelj|kvadratna čevlja|kvadratni čevlji|kvadratnih čevljev}}',
	'pfunc-convert-unit-area-squareinch' => '$1{{PLURAL:$2|kvadratni palec|kvadratna palca|kvadratni palci|kvadratnih palcev}}',
	'pfunc-convert-unit-area-squarenauticalmile' => '$1{{PLURAL:$2|kvadratna navtična milja|kvadratni navtični milji|kvadratne navtične milje|kvadratnih navtičnih milj}}',
	'pfunc-convert-unit-area-dunam' => '$1{{PLURAL:$2|dunam|dunama|dunami|dunamov}}',
	'pfunc-convert-unit-area-tsubo' => '$1{{PLURAL:$2|tsubo|tsuba|tsubi|tsubov}}',
	'pfunc-convert-unit-area-squarekilometre-abbr' => '$1km<sup>2</sup>',
	'pfunc-convert-unit-area-squaremetre-abbr' => '$1m<sup>2</sup>',
	'pfunc-convert-unit-area-squarecentimetre-abbr' => '$1cm<sup>2</sup>',
	'pfunc-convert-unit-area-squaremillimetre-abbr' => '$1mm<sup>2</sup>',
	'pfunc-convert-unit-area-hectare-abbr' => '$1ha',
	'pfunc-convert-unit-area-squaremile-abbr' => '$1kv. mi',
	'pfunc-convert-unit-area-acre-abbr' => '$1aker',
	'pfunc-convert-unit-area-squareyard-abbr' => '$1kv. yd',
	'pfunc-convert-unit-area-squarefoot-abbr' => '$1kv. ft',
	'pfunc-convert-unit-area-squareinch-abbr' => '$1kv. in',
	'pfunc-convert-unit-area-squarenauticalmile-abbr' => '$1kv nmi',
	'pfunc-convert-unit-area-dunam-abbr' => '$1dunam',
	'pfunc-convert-unit-area-tsubo-abbr' => '$1tsubo',
	'pfunc-convert-unit-time-second' => '$1{{PLURAL:$2|sekunda|sekundi|sekunde|sekund}}',
	'pfunc-convert-unit-time-year' => '$1{{PLURAL:$2|leto|leti|leta|let}}',
	'pfunc-convert-unit-time-day' => '$1{{PLURAL:$2|dan|dneva|dnevi|dni}}',
	'pfunc-convert-unit-time-hour' => '$1{{PLURAL:$2|ura|uri|ure|ur}}',
	'pfunc-convert-unit-time-minute' => '$1{{PLURAL:$2|minuta|minuti|minute|minut}}',
	'pfunc-convert-unit-time-second-abbr' => '$1s',
	'pfunc-convert-unit-time-year-abbr' => '$1leto',
	'pfunc-convert-unit-time-day-abbr' => '$1dan',
	'pfunc-convert-unit-time-hour-abbr' => '$1ura',
	'pfunc-convert-unit-time-minute-abbr' => '$1min',
	'pfunc-convert-unit-volume-cubicmetre' => '$1{{PLURAL:$2|kubični meter|kubična metra|kubični metri|kubičnih metrov}}',
	'pfunc-convert-unit-volume-cubiccentimetre' => '$1{{PLURAL:$2|kubični centimeter|kubična centimetra|kubični centimetri|kubičnih centimetrov}}',
	'pfunc-convert-unit-volume-cubicmillimetre' => '$1{{PLURAL:$2|kubični milimeter|kubična milimetra|kubični milimetri|kubičnih milimetrov}}',
	'pfunc-convert-unit-volume-kilolitre' => '$1kilo{{PLURAL:$2|liter|litra|litri|litrov}}',
	'pfunc-convert-unit-volume-litre' => '$1{{PLURAL:$2|liter|litra|litri|litrov}}',
	'pfunc-convert-unit-volume-centilitre' => '$1centi{{PLURAL:$2|liter|litra|litri|litrov}}',
	'pfunc-convert-unit-volume-millilitre' => '$1mili{{PLURAL:$2|liter|litra|litri|litrov}}',
	'pfunc-convert-unit-volume-cubicyard' => '$1{{PLURAL:$2|kubični jard|kubična jarda|kubični jardi|kubičnih jardov}}',
	'pfunc-convert-unit-volume-cubicfoot' => '$1{{PLURAL:$2|kubični čevelj|kubična čevlja|kubični čevlji|kubičnih čevljev}}',
	'pfunc-convert-unit-volume-cubicinch' => '$1{{PLURAL:$2|kubični palec|kubična palca|kubični palci|kubičnih palcev}}',
	'pfunc-convert-unit-volume-barrel' => '$1{{PLURAL:$2|sod|soda|sodi|sodov}}',
	'pfunc-convert-unit-volume-bushel' => '$1{{PLURAL:$2|bušel|bušla|bušli|bušlov}}',
	'pfunc-convert-unit-volume-gallon' => '$1{{PLURAL:$2|galona|galoni|galone|galon}}',
	'pfunc-convert-unit-volume-quart' => '$1{{PLURAL:$2|kvart|kvarta|kvarti|kvartov}}',
	'pfunc-convert-unit-volume-pint' => '$1{{PLURAL:$2|pint|pinta|pinti|pintov}}',
	'pfunc-convert-unit-volume-fluidounce' => '$1{{PLURAL:$2|tekočinska unča|tekočinski unči|tekočinske unče|tekočinskih unč}}',
	'pfunc-convert-unit-volume-barrelus' => '$1{{PLURAL:$2|ameriški sod|ameriška soda|ameriški sodi|ameriških sodov}}',
	'pfunc-convert-unit-volume-barreloil' => '$1{{PLURAL:$2|sod|soda|sodi|sodov}}',
	'pfunc-convert-unit-volume-barrelbeer' => '$1{{PLURAL:$2|sod|soda|sodi|sodov}}',
	'pfunc-convert-unit-volume-usgallon' => '$1{{PLURAL:$2|ameriška galona|ameriški galoni|ameriške galone|ameriških galon}}',
	'pfunc-convert-unit-volume-usquart' => '$1{{PLURAL:$2|ameriški kvart|ameriška kvarta|ameriški kvarti|ameriških kvartov}}',
	'pfunc-convert-unit-volume-uspint' => '$1{{PLURAL:$2|ameriški pint|ameriška pinta|ameriški pinti|ameriških pintov}}',
	'pfunc-convert-unit-volume-usfluidounce' => '$1{{PLURAL:$2|ameriška tekočinska unča|ameriški tekočinski unči|ameriške tekočinske unče|ameriških tekočinskih unč}}',
	'pfunc-convert-unit-volume-usdrybarrel' => '$1{{PLURAL:$2|ameriški suhi sod|ameriška suha soda|ameriški suhi sodi|ameriških suhih sodov}}',
	'pfunc-convert-unit-volume-usbushel' => '$1{{PLURAL:$2|ameriški bušel|ameriška bušla|ameriški bušli|ameriških bušlov}}',
	'pfunc-convert-unit-volume-usdrygallon' => '$1{{PLURAL:$2|ameriška suha galona|ameriški suhi galoni|ameriške suhe galone|ameriških suhih galon}}',
	'pfunc-convert-unit-volume-usdryquart' => '$1{{PLURAL:$2|ameriški suhi kvart|ameriška suha kvarta|ameriški suhi kvarti|ameriških suhih kvartov}}',
	'pfunc-convert-unit-volume-usdrypint' => '$1{{PLURAL:$2|ameriški suhi pint|ameriška suha pinta|ameriški suhi pinti|ameriških suhih pintov}}',
	'pfunc-convert-unit-volume-cubicmetre-abbr' => '$1m<sup>3</sup>',
	'pfunc-convert-unit-volume-cubiccentimetre-abbr' => '$1cm<sup>3</sup>',
	'pfunc-convert-unit-volume-cubicmillimetre-abbr' => '$1mm<sup>3</sup>',
	'pfunc-convert-unit-volume-litre-abbr' => '$1$3 l',
	'pfunc-convert-unit-volume-cubicyard-abbr' => '$1kub. yd',
	'pfunc-convert-unit-volume-cubicfoot-abbr' => '$1kub. ft',
	'pfunc-convert-unit-volume-cubicinch-abbr' => '$1kub. in',
	'pfunc-convert-unit-volume-barrel-abbr' => '$1bbl',
	'pfunc-convert-unit-volume-bushel-abbr' => '$1bsh',
	'pfunc-convert-unit-volume-gallon-abbr' => '$1gal',
	'pfunc-convert-unit-volume-quart-abbr' => '$1qt',
	'pfunc-convert-unit-volume-pint-abbr' => '$1pt',
	'pfunc-convert-unit-volume-fluidounce-abbr' => '$1fl oz',
	'pfunc-convert-unit-volume-barrelus-abbr' => '$1am. bbl',
	'pfunc-convert-unit-volume-barreloil-abbr' => '$1bbl',
	'pfunc-convert-unit-volume-barrelbeer-abbr' => '$1bbl',
	'pfunc-convert-unit-volume-usgallon-abbr' => '$1am. gal',
	'pfunc-convert-unit-volume-usquart-abbr' => '$1am. qt',
	'pfunc-convert-unit-volume-uspint-abbr' => '$1am. pt',
	'pfunc-convert-unit-volume-usfluidounce-abbr' => '$1am. fl oz',
	'pfunc-convert-unit-volume-usdrybarrel-abbr' => '$1am. bbl',
	'pfunc-convert-unit-volume-usbushel-abbr' => '$1am. bsh',
	'pfunc-convert-unit-volume-usdrygallon-abbr' => '$1am. suha gal',
	'pfunc-convert-unit-volume-usdryquart-abbr' => '$1am. suhi qt',
	'pfunc-convert-unit-volume-usdrypint-abbr' => '$1am. suhi pt',
	'pfunc-convert-unit-speed-mile-hour' => '$1milje na uro',
	'pfunc-convert-unit-speed-speedoflight' => '$1c',
	'pfunc-convert-unit-speed-mile-hour-abbr' => '$1mph',
	'pfunc-convert-unit-speed-speedoflight-abbr' => '$1c',
	'pfunc-convert-unit-pressure-pascal' => '$1{{PLURAL:$2|paskal|paskala|paskali|paskalov}}',
	'pfunc-convert-unit-pressure-bar' => '$1bar',
	'pfunc-convert-unit-pressure-decibar' => '$1decibar',
	'pfunc-convert-unit-pressure-millibar' => '$1milibar',
	'pfunc-convert-unit-pressure-kilobarye' => '$1kilobarye',
	'pfunc-convert-unit-pressure-barye' => '$1barye',
	'pfunc-convert-unit-pressure-atmosphere' => '$1{{PLURAL:$2|atmosfera|atmosferi|atmosfere|atmosfer}}',
	'pfunc-convert-unit-pressure-torr' => '$1{{PLURAL:$2|torr|torra|torri|torrov}}',
	'pfunc-convert-unit-pressure-mmhg' => '$1{{PLURAL:$2|milimeter|milimetra|milimetri|milimetrov}} živega srebra',
	'pfunc-convert-unit-pressure-inhg' => '$1{{PLURAL:$2|palec|palca|palci|palcev}} živega srebra',
	'pfunc-convert-unit-pressure-psi' => '$1{{PLURAL:$2|funt|funta|funti|funtov}} na kvadratni palec',
	'pfunc-convert-unit-pressure-pascal-abbr' => '$1Pa',
	'pfunc-convert-unit-pressure-bar-abbr' => '$1bar',
	'pfunc-convert-unit-pressure-decibar-abbr' => '$1dbar',
	'pfunc-convert-unit-pressure-millibar-abbr' => '$1mbar',
	'pfunc-convert-unit-pressure-kilobarye-abbr' => '$1kBa',
	'pfunc-convert-unit-pressure-barye-abbr' => '$1Ba',
	'pfunc-convert-unit-pressure-atmosphere-abbr' => '$1atm',
	'pfunc-convert-unit-pressure-torr-abbr' => '$1Torr',
	'pfunc-convert-unit-pressure-mmhg-abbr' => '$1mmHg',
	'pfunc-convert-unit-pressure-inhg-abbr' => '$1inHg',
	'pfunc-convert-unit-pressure-psi-abbr' => '$1psi',
);

/** Albanian (Shqip)
 * @author Olsi
 * @author Vinie007
 */
$messages['sq'] = array(
	'pfunc_desc' => 'Enhance parser me funksione logjike',
	'pfunc_time_error' => 'Gabim: kohë e pavlefshme',
	'pfunc_time_too_long' => 'Gabim: shumë #thirrje kohe',
	'pfunc_time_too_big' => 'Gabim: # kohë mbështet vetëm vjet deri në 9999',
	'pfunc_rel2abs_invalid_depth' => 'Gabim: thellësi e pavlefshme në rrugë: "$1" (u përpoq për të hyrë në një nyje mbi nyjen e rrënjës)',
	'pfunc_expr_stack_exhausted' => 'Gabim shprehjeje: Stack exhausted',
	'pfunc_expr_unexpected_number' => 'Gabim shprehjeje: Numër i papritur',
	'pfunc_expr_preg_match_failure' => 'Gabim shprehjeje: Dështim i papritur i preg_match',
	'pfunc_expr_unrecognised_word' => 'Gabim shprehjeje: Fjalë e panjohur: $1',
	'pfunc_expr_unexpected_operator' => 'Gabim shprehjeje: Operator i papritur $1',
	'pfunc_expr_missing_operand' => 'Gabim shprehjej: Operim i munfuar për $1',
	'pfunc_expr_unexpected_closing_bracket' => 'Gabim shprehjeje: Mbyllje e papritur kllapash',
	'pfunc_expr_unrecognised_punctuation' => 'Gabim shprehjeje: Karakater pikësimi i panjohur "$1"',
	'pfunc_expr_unclosed_bracket' => 'Gabim shprehjeje: Mosmbyllje kllapash',
	'pfunc_expr_division_by_zero' => 'Pjesëtim me zero',
	'pfunc_expr_invalid_argument' => 'Argument i pavlefshëm për $1: < -1 ose > 1',
	'pfunc_expr_invalid_argument_ln' => 'Argument i pavlefshëm për ln: <= 0',
	'pfunc_expr_unknown_error' => 'Gabim shprehjeje: Gabim i panjohur ($1)',
	'pfunc_expr_not_a_number' => 'Në $1: rezultati nuk është një numër',
	'pfunc_string_too_long' => 'Gabim: string kalon limit $1 karakter',
);

/** Serbian Cyrillic ekavian (‪Српски (ћирилица)‬)
 * @author Millosh
 * @author Rancher
 * @author Verlor
 */
$messages['sr-ec'] = array(
	'pfunc_desc' => 'Проширује рашчлањивач с логичким функцијама',
	'pfunc_time_error' => 'Грешка: лоше време',
	'pfunc_time_too_long' => 'Грешка: превише #time позива',
	'pfunc_expr_stack_exhausted' => 'Грешка у изразу: стек напуњен',
	'pfunc_expr_unexpected_number' => 'Грешка у изразу: неочекивани број',
	'pfunc_expr_preg_match_failure' => 'Грешка у изразу: Неочекивана preg_match грешка',
	'pfunc_expr_unrecognised_word' => 'Грешка у изразу: непозната реч "$1"',
	'pfunc_expr_unexpected_operator' => 'Грешка у изразу: непознати оператор "$1"',
	'pfunc_expr_missing_operand' => 'Грешка у изразу: недостаје операнд за $1',
	'pfunc_expr_unexpected_closing_bracket' => 'Грешка у изразу: Неочекивано затварање средње заграде.',
	'pfunc_expr_unrecognised_punctuation' => 'Грешка у изразу: Непознати интерпункцијски карактер "$1".',
	'pfunc_expr_unclosed_bracket' => 'Грешка у изразу: Незатворена средња заграда.',
	'pfunc_expr_division_by_zero' => 'Дељење са нулом.',
	'pfunc_expr_invalid_argument' => 'Лош аргумент: $1 је < -1 или > 1',
	'pfunc_expr_invalid_argument_ln' => 'Лош аргумент: ln <= 0',
	'pfunc_expr_unknown_error' => 'Грешка у изразу: Непозната грешка ($1)',
	'pfunc_expr_not_a_number' => 'Резултат у $1 није број.',
	'pfunc_string_too_long' => 'Грешка: реч прекорачује $1  слова, што је постављено ограничење',
);

/** Serbian Latin ekavian (‪Srpski (latinica)‬)
 * @author Michaello
 */
$messages['sr-el'] = array(
	'pfunc_desc' => 'obogati parser logičkim funkcijama',
	'pfunc_time_error' => 'Greška: loše vreme',
	'pfunc_time_too_long' => 'Greška: previše #time poziva',
	'pfunc_expr_stack_exhausted' => 'Greška u izrazu: stek napunjen',
	'pfunc_expr_unexpected_number' => 'Greška u izrazu: neočekivani broj',
	'pfunc_expr_preg_match_failure' => 'Greška u izrazu: Neočekivana preg_match greška',
	'pfunc_expr_unrecognised_word' => 'Greška u izrazu: nepoznata reč "$1"',
	'pfunc_expr_unexpected_operator' => 'Greška u izrazu: nepoznati operator "$1"',
	'pfunc_expr_missing_operand' => 'Greška u izrazu: nedostaje operand za $1',
	'pfunc_expr_unexpected_closing_bracket' => 'Greška u izrazu: Neočekivano zatvaranje srednje zagrade.',
	'pfunc_expr_unrecognised_punctuation' => 'Greška u izrazu: Nepoznati interpunkcijski karakter "$1".',
	'pfunc_expr_unclosed_bracket' => 'Greška u izrazu: Nezatvorena srednja zagrada.',
	'pfunc_expr_division_by_zero' => 'Deljenje sa nulom.',
	'pfunc_expr_invalid_argument' => 'Loš argument: $1 je < -1 ili > 1',
	'pfunc_expr_invalid_argument_ln' => 'Loš argument: ln <= 0',
	'pfunc_expr_unknown_error' => 'Greška u izrazu: Nepoznata greška ($1)',
	'pfunc_expr_not_a_number' => 'Rezultat u $1 nije broj.',
	'pfunc_string_too_long' => 'Greška: reč prekoračuje $1  slova, što je postavljeno ograničenje',
);

/** Seeltersk (Seeltersk)
 * @author Pyt
 */
$messages['stq'] = array(
	'pfunc_desc' => 'Ärwiedert dän Parser uum logiske Funktione',
	'pfunc_time_error' => 'Failer: uungultige Tiedangoawe',
	'pfunc_time_too_long' => 'Failer: tou fuul #time-Aproupe',
	'pfunc_rel2abs_invalid_depth' => 'Failer: uungultige Djüpte in Paad: „$1“ (Fersäik, ap n Knättepunkt buppe dän Haudknättepunkt toutougriepen)',
	'pfunc_expr_stack_exhausted' => 'Expression-Failer: Stack-Uurloop',
	'pfunc_expr_unexpected_number' => 'Expression-Failer: Nit ferwachtede Taal',
	'pfunc_expr_preg_match_failure' => 'Expression-Failer: Uunferwachtede „preg_match“-Failfunktion',
	'pfunc_expr_unrecognised_word' => 'Expression-Failer: Nit wierkoand Woud „$1“',
	'pfunc_expr_unexpected_operator' => 'Expression-Failer: Uunferwachteden Operator: <strong><tt>$1</tt></strong>',
	'pfunc_expr_missing_operand' => 'Expression-Failer: Failenden Operand foar <strong><tt>$1</tt></strong>',
	'pfunc_expr_unexpected_closing_bracket' => 'Expression-Failer: Uunferwachte sluutende kaantige Klammere',
	'pfunc_expr_unrecognised_punctuation' => 'Expression-Failer: Nit wierkoand Satsteeken „$1“',
	'pfunc_expr_unclosed_bracket' => 'Expression-Failer: Nit sleetene kaantige Klammer',
	'pfunc_expr_division_by_zero' => 'Expression-Failer: Division truch Null',
	'pfunc_expr_invalid_argument' => 'Uungultich Argument foar $1: < -1 of > 1',
	'pfunc_expr_invalid_argument_ln' => 'Uungultich Argument foar ln: <= 0',
	'pfunc_expr_unknown_error' => 'Expression-Failer: Uunbekoanden Failer ($1)',
	'pfunc_expr_not_a_number' => 'Expression-Failer: In $1: Resultoat is neen Taal',
	'pfunc_string_too_long' => 'Failer: Teekenkätte is laanger as dät Teekenlimit fon $1',
);

/** Sundanese (Basa Sunda)
 * @author Irwangatot
 * @author Kandar
 */
$messages['su'] = array(
	'pfunc_desc' => 'Ngembangkeun parser kalawan fungsi logis',
	'pfunc_time_error' => 'Éror: titimangsa teu valid',
	'pfunc_expr_division_by_zero' => 'Pambagi ku nol',
);

/** Swedish (Svenska)
 * @author Ainali
 * @author Lejonel
 * @author Lokal Profil
 * @author M.M.S.
 * @author Najami
 * @author WikiPhoenix
 */
$messages['sv'] = array(
	'pfunc_desc' => 'Lägger till logiska funktioner i parsern',
	'pfunc_time_error' => 'Fel: ogiltig tid',
	'pfunc_time_too_long' => 'Fel: för många anrop av #time',
	'pfunc_time_too_big' => 'Fel: # tid stöder endast år fram till 9999',
	'pfunc_rel2abs_invalid_depth' => 'Fel: felaktig djup i sökväg: "$1" (försöker nå en nod ovanför rotnoden)',
	'pfunc_expr_stack_exhausted' => 'Fel i uttryck: Stackutrymmet tog slut',
	'pfunc_expr_unexpected_number' => 'Fel i uttryck: Oväntat tal',
	'pfunc_expr_preg_match_failure' => 'Fel i uttryck: Oväntad fel i preg_match',
	'pfunc_expr_unrecognised_word' => 'Fel i uttryck: Okänt ord "$1"',
	'pfunc_expr_unexpected_operator' => 'Fel i uttryck: Oväntad operator $1',
	'pfunc_expr_missing_operand' => 'Fel i uttryck: Operand saknas för $1',
	'pfunc_expr_unexpected_closing_bracket' => 'Fel i uttryck: Oväntad avslutande parentes',
	'pfunc_expr_unrecognised_punctuation' => 'Fel i uttryck: Okänt interpunktionstecken "$1"',
	'pfunc_expr_unclosed_bracket' => 'Fel i uttryck: Oavslutad parentes',
	'pfunc_expr_division_by_zero' => 'Division med noll',
	'pfunc_expr_invalid_argument' => 'Ogiltigt argument för $1: < -1 eller > 1',
	'pfunc_expr_invalid_argument_ln' => 'Ogiltigt argument för ln: <= 0',
	'pfunc_expr_unknown_error' => 'Fel i uttryck: Okänt fel ($1)',
	'pfunc_expr_not_a_number' => 'I $1: resultatet är inte ett tal',
	'pfunc_string_too_long' => 'Fel: Strängen överskrider gränsen på $1 tecken',
	'pfunc-convert-dimensionmismatch' => 'Fel: Kan inte konvertera mellan enheterna "$1" och "$2".',
	'pfunc-convert-unknownunit' => 'Fel: Okänd enhet "$1".',
	'pfunc-convert-unknowndimension' => 'Fel: Okänd dimension "$1".',
	'pfunc-convert-dimension-length' => 'längd',
	'pfunc-convert-dimension-area' => 'area',
	'pfunc-convert-dimension-volume' => 'volym',
	'pfunc-convert-dimension-time' => 'tid',
	'pfunc-convert-dimension-timesquared' => 'tid <sup>2</sup>',
	'pfunc-convert-dimension-mass' => 'massa',
	'pfunc-convert-dimension-speed' => 'hastighet',
	'pfunc-convert-dimension-temperature' => 'temperatur',
	'pfunc-convert-dimension-acceleration' => 'acceleration',
	'pfunc-convert-dimension-force' => 'kraft',
	'pfunc-convert-dimension-torque' => 'vridmoment',
	'pfunc-convert-dimension-energy' => 'energi',
	'pfunc-convert-dimension-pressure' => 'tryck',
	'pfunc-convert-dimension-density' => 'densitet',
	'pfunc-convert-prefix-yotta' => 'yotta',
	'pfunc-convert-prefix-zetta' => 'zetta',
	'pfunc-convert-prefix-exa' => 'exa',
	'pfunc-convert-prefix-peta' => 'peta',
	'pfunc-convert-prefix-tera' => 'tera',
	'pfunc-convert-prefix-giga' => 'giga',
	'pfunc-convert-prefix-mega' => 'mega',
	'pfunc-convert-prefix-kilo' => 'kilo',
	'pfunc-convert-prefix-hecto' => 'hekto',
	'pfunc-convert-prefix-deca' => 'deka',
	'pfunc-convert-prefix-deci' => 'deci',
	'pfunc-convert-prefix-centi' => 'centi',
	'pfunc-convert-prefix-milli' => 'milli',
	'pfunc-convert-prefix-micro' => 'mikro',
	'pfunc-convert-prefix-nano' => 'nano',
	'pfunc-convert-prefix-pico' => 'piko',
	'pfunc-convert-prefix-femto' => 'femto',
	'pfunc-convert-prefix-atto' => 'atto',
	'pfunc-convert-prefix-zepto' => 'zepto',
	'pfunc-convert-prefix-yocto' => 'yokto',
	'pfunc-convert-unit-length-metre' => '$1{{PLURAL:$2|$3meter|$3meter}}',
	'pfunc-convert-unit-length-angstrom' => '$1{{PLURAL:$2|ångström|ångström}}',
	'pfunc-convert-unit-length-mile' => '$1{{PLURAL:$2|engelsk mil|engelska mil}}',
	'pfunc-convert-unit-length-furlong' => '$1{{PLURAL:$2|furlong|furlonger}}',
	'pfunc-convert-unit-length-chain' => '$1{{PLURAL:$2|chain|chains}}',
	'pfunc-convert-unit-length-rod' => '$1{{PLURAL:$2|stång|stänger}}',
	'pfunc-convert-unit-length-fathom' => '$1{{PLURAL:$2|famn|famnar}}',
	'pfunc-convert-unit-length-yard' => '$1{{PLURAL:$2|yard|yards}}',
	'pfunc-convert-unit-length-foot' => '$1{{PLURAL:$2|fot|fot}}',
	'pfunc-convert-unit-length-hand' => '$1{{PLURAL:$2|hand|händer}}',
	'pfunc-convert-unit-length-inch' => '$1{{PLURAL:$2|tum|tum}}',
	'pfunc-convert-unit-length-nauticalmile' => '$1{{PLURAL:$2|nautisk mil|nautiska mil}}',
	'pfunc-convert-unit-length-nauticalmileuk' => '$1{{PLURAL:$2|nautisk mil (innan 1970, brittisk)|nautiska mil (innan 1970, brittisk)}}',
	'pfunc-convert-unit-length-nauticalmileus' => '$1{{PLURAL:$2|nautisk mil (innan 1954, USA)|nautiska mil (innan 1954, USA)}}',
	'pfunc-convert-unit-length-parsec' => '$1{{PLURAL:$2|$3parsec|$3parsec}}',
	'pfunc-convert-unit-length-lightyear' => '$1{{PLURAL:$2|$3ljusår|$3ljusår}}',
	'pfunc-convert-unit-length-astronomicalunit' => '$1{{PLURAL:$2|astronomisk enhet|astronomiska enheter}}',
	'pfunc-convert-unit-length-furlong-abbr' => '$1furlong',
	'pfunc-convert-unit-length-chain-abbr' => '$1chain',
	'pfunc-convert-unit-length-fathom-abbr' => '$1famn',
	'pfunc-convert-unit-length-yard-abbr' => '$1yd',
	'pfunc-convert-unit-length-foot-abbr' => '$1ft',
	'pfunc-convert-unit-length-hand-abbr' => '$1h',
	'pfunc-convert-unit-length-inch-abbr' => '$1in',
	'pfunc-convert-unit-length-nauticalmile-abbr' => '$1nmi',
	'pfunc-convert-unit-length-nauticalmileuk-abbr' => '$1nmi (Storbr.)',
	'pfunc-convert-unit-length-nauticalmileus-abbr' => '$1nmi (innan 1954, USA)',
	'pfunc-convert-unit-length-parsec-abbr' => '$1$3pc',
	'pfunc-convert-unit-length-astronomicalunit-abbr' => '$1AU',
	'pfunc-convert-unit-area-squarekilometre' => '$1{{PLURAL:$2|kvadratkilometer|kvadratkilometer}}',
	'pfunc-convert-unit-area-squaremetre' => '$1{{PLURAL:$2|kvadratmeter|kvadratmeter}}',
	'pfunc-convert-unit-area-squarecentimetre' => '$1{{PLURAL:$2|kvadratcentimeter|kvadratcentimeter}}',
	'pfunc-convert-unit-area-squaremillimetre' => '$1{{PLURAL:$2|kvadratmillimeter|kvadratmillimeter}}',
	'pfunc-convert-unit-area-hectare' => '$1{{PLURAL:$2|hektar|hektar}}',
	'pfunc-convert-unit-area-squaremile' => '$1{{PLURAL:$2|kvadratmil|kvadratmil}}',
	'pfunc-convert-unit-area-acre' => '$1{{PLURAL:$2|tunnland|tunnland}}',
	'pfunc-convert-unit-area-squareyard' => '$1{{PLURAL:$2|kvadratyard|kvadratyard}}',
	'pfunc-convert-unit-area-squarefoot' => '$1{{PLURAL:$2|kvadratfot|kvadratfötter}}',
	'pfunc-convert-unit-area-squareinch' => '$1{{PLURAL:$2|kvadrattum|kvadrattum}}',
	'pfunc-convert-unit-area-squarenauticalmile' => '$1{{PLURAL:$2|kvadratisk nautisk mil|kvadratiska nautiska mil}}',
	'pfunc-convert-unit-area-dunam' => '$1{{PLURAL:$2|dunam|dunam}}',
	'pfunc-convert-unit-area-tsubo' => '$1{{PLURAL:$2|tsubo|tsubo}}',
	'pfunc-convert-unit-area-squarekilometre-abbr' => '$1km<sup>2</sup>',
	'pfunc-convert-unit-area-squaremetre-abbr' => '$1m<sup>2</sup>',
	'pfunc-convert-unit-area-squarecentimetre-abbr' => '$1cm<sup>2</sup>',
	'pfunc-convert-unit-area-squaremillimetre-abbr' => '$1mm<sup>2</sup>',
	'pfunc-convert-unit-area-hectare-abbr' => '$1ha',
	'pfunc-convert-unit-area-squaremile-abbr' => '$1kv mil',
	'pfunc-convert-unit-area-acre-abbr' => '$1tunnland',
	'pfunc-convert-unit-area-squareyard-abbr' => '$1kv yd',
	'pfunc-convert-unit-area-squarefoot-abbr' => '$1kv ft',
	'pfunc-convert-unit-area-squareinch-abbr' => '$1kv in',
	'pfunc-convert-unit-area-squarenauticalmile-abbr' => '$1kv nmi',
	'pfunc-convert-unit-area-dunam-abbr' => '$1dunam',
	'pfunc-convert-unit-area-tsubo-abbr' => '$1tsubo',
	'pfunc-convert-unit-time-second' => '$1{{PLURAL:$2|sekund|sekunder}}',
	'pfunc-convert-unit-time-year' => '$1{{PLURAL:$2|$3år|$3år}}',
	'pfunc-convert-unit-time-day' => '$1{{PLURAL:$2|dag|dagar}}',
	'pfunc-convert-unit-time-hour' => '$1{{PLURAL:$2|timme|timmar}}',
	'pfunc-convert-unit-time-minute' => '$1{{PLURAL:$2|minut|minuter}}',
	'pfunc-convert-unit-time-second-abbr' => '$1s',
	'pfunc-convert-unit-time-day-abbr' => '$1dag',
	'pfunc-convert-unit-time-hour-abbr' => '$1tim',
	'pfunc-convert-unit-time-minute-abbr' => '$1min',
	'pfunc-convert-unit-volume-cubicmetre' => '$1{{PLURAL:$2|kubikmeter|kubikmeter}}',
	'pfunc-convert-unit-volume-cubiccentimetre' => '$1{{PLURAL:$2|kubikcentimeter|kubikcentimeter}}',
	'pfunc-convert-unit-volume-cubicmillimetre' => '$1{{PLURAL:$2|kubikmillimeter|kubikmillimeter}}',
	'pfunc-convert-unit-volume-kilolitre' => '$1{{PLURAL:$2|kiloliter|kiloliter}}',
	'pfunc-convert-unit-volume-litre' => '$1{{PLURAL:$2|liter|liter}}',
	'pfunc-convert-unit-volume-centilitre' => '$1{{PLURAL:$2|centiliter|centiliter}}',
	'pfunc-convert-unit-volume-millilitre' => '$1{{PLURAL:$2|milliliter|milliliter}}',
	'pfunc-convert-unit-volume-cubicyard' => '$1{{PLURAL:$2|kubikyard|kubikyards}}',
	'pfunc-convert-unit-volume-cubicfoot' => '$1{{PLURAL:$2|kubikfot|kubikfötter}}',
	'pfunc-convert-unit-volume-cubicinch' => '$1{{PLURAL:$2|kubiktum|kubiktum}}',
	'pfunc-convert-unit-volume-barrel' => '$1{{PLURAL:$2|fat|fat}}',
	'pfunc-convert-unit-volume-gallon' => '$1{{PLURAL:$2|gallon|gallons}}',
	'pfunc-convert-unit-volume-quart' => '$1{{PLURAL:$2|quart|quarts}}',
	'pfunc-convert-unit-volume-pint' => '$1{{PLURAL:$2|pint|pints}}',
	'pfunc-convert-unit-volume-usgallon' => '$1{{PLURAL:$2|gallon (USA, våt)|gallon (USA, våt)}}',
	'pfunc-convert-unit-volume-usquart' => '$1{{PLURAL:$2|quart (USA, våt)|quart (USA, våt)}}',
	'pfunc-convert-unit-volume-uspint' => '$1{{PLURAL:$2|pint (USA, våt)|pint (USA, våt)}}',
	'pfunc-convert-unit-volume-usdrygallon' => '$1{{PLURAL:$2|gallon (USA, torr)|gallon (USA, torr)}}',
	'pfunc-convert-unit-volume-usdryquart' => '$1{{PLURAL:$2|quart (USA, torr)|quart (USA, torr)}}',
	'pfunc-convert-unit-volume-usdrypint' => '$1{{PLURAL:$2|pint (USA, torr)|pint (USA, torr)}}',
	'pfunc-convert-unit-volume-cubicmetre-abbr' => '$1m<sup>3</sup>',
	'pfunc-convert-unit-volume-cubiccentimetre-abbr' => '$1cm<sup>3</sup>',
	'pfunc-convert-unit-volume-cubicmillimetre-abbr' => '$1mm<sup>3</sup>',
	'pfunc-convert-unit-volume-litre-abbr' => '$1$3l',
	'pfunc-convert-unit-volume-gallon-abbr' => '$1gal',
	'pfunc-convert-unit-speed-mile-hour' => '$1miles per timme',
	'pfunc-convert-unit-speed-mile-hour-abbr' => '$1mph',
	'pfunc-convert-unit-pressure-pascal' => '$1{{PLURAL:$2|$3pascal|$3pascal}}',
	'pfunc-convert-unit-pressure-bar' => '$1bar',
	'pfunc-convert-unit-pressure-millibar' => '$1millibar',
	'pfunc-convert-unit-pressure-atmosphere' => '$1{{PLURAL:$2|atmosfär|atmosfärer}}',
	'pfunc-convert-unit-pressure-torr' => '$1{{PLURAL:$2|torr|torr}}',
	'pfunc-convert-unit-pressure-mmhg' => '$1{{PLURAL:$2|millimeter kvicksilver|millimeter kvicksilver}}',
	'pfunc-convert-unit-pressure-inhg' => '$1{{PLURAL:$2|tum kvicksilver|tum kvicksilver}}',
	'pfunc-convert-unit-pressure-pascal-abbr' => '$1$3Pa',
	'pfunc-convert-unit-pressure-bar-abbr' => '$1bar',
	'pfunc-convert-unit-pressure-millibar-abbr' => '$1mbar',
	'pfunc-convert-unit-pressure-atmosphere-abbr' => '$1atm',
	'pfunc-convert-unit-pressure-mmhg-abbr' => '$1mmHg',
	'pfunc-convert-unit-pressure-psi-abbr' => '$1psi',
);

/** Telugu (తెలుగు)
 * @author Mpradeep
 * @author Veeven
 */
$messages['te'] = array(
	'pfunc_time_error' => 'లోపం: సమయం సరిగ్గా లేదు',
	'pfunc_time_too_long' => 'లోపం: #timeను చాలా సార్లు ఉపయోగించారు',
	'pfunc_rel2abs_invalid_depth' => 'లోపం: పాత్ యొక్క డెప్తు సరిగ్గాలేదు: "$1" (రూట్ నోడు కంటే పైన ఉన్న నోడు ఉపయోగించటానికి ప్రయత్నం జరిగింది)',
	'pfunc_expr_stack_exhausted' => 'సమాసంలో(Expression) లోపం: స్టాకు మొత్తం అయిపోయింది',
	'pfunc_expr_unexpected_number' => 'సమాసంలో(Expression) లోపం: ఊహించని సంఖ్య వచ్చింది',
	'pfunc_expr_preg_match_failure' => 'సమాసంలో(Expression) లోపం: preg_matchలో ఊహించని విఫలం',
	'pfunc_expr_unrecognised_word' => 'సమాసంలో(Expression) లోపం: "$1" అనే పదాన్ని గుర్తుపట్టలేకపోతున్నాను',
	'pfunc_expr_unexpected_operator' => 'సమాసంలో(Expression) లోపం: $1 పరికర్తను(operator) ఊహించలేదు',
	'pfunc_expr_missing_operand' => 'సమాసంలో(Expression) లోపం: $1కు ఒక ఆపరాండును ఇవ్వలేదు',
	'pfunc_expr_unexpected_closing_bracket' => 'సమాసంలో(Expression) లోపం: ఊహించని బ్రాకెట్టు ముగింపు',
	'pfunc_expr_unrecognised_punctuation' => 'సమాసంలో(Expression) లోపం: "$1" అనే విరామ చిహ్నాన్ని గుర్తించలేకపోతున్నాను',
	'pfunc_expr_unclosed_bracket' => 'సమాసంలో(Expression) లోపం: బ్రాకెట్టును మూయలేదు',
	'pfunc_expr_division_by_zero' => 'సున్నాతో భాగించారు',
	'pfunc_expr_unknown_error' => 'సమాసంలో(Expression) లోపం: తెలియని లోపం ($1)',
	'pfunc_expr_not_a_number' => '$1లో: వచ్చిన ఫలితం సంఖ్య కాదు',
);

/** Tajik (Cyrillic) (Тоҷикӣ (Cyrillic))
 * @author Ibrahim
 */
$messages['tg-cyrl'] = array(
	'pfunc_desc' => 'Ба таҷзеҳкунанда, дастурҳои мантиқӣ меафзояд',
	'pfunc_time_error' => 'Хато: замони ғайримиҷоз',
	'pfunc_time_too_long' => 'Хато: #time фарохонии беш аз ҳад',
	'pfunc_rel2abs_invalid_depth' => 'Хато: Чуқурии ғайримиҷоз дар нишонӣ: "$1" (талош барои дастраси ба як нишонӣ болотар аз нишонии реша)',
	'pfunc_expr_stack_exhausted' => 'Хатои ибора: Пушта аз даст рафтааст',
	'pfunc_expr_unexpected_number' => 'Хатои ибора: Адади ғайримунтазир',
	'pfunc_expr_preg_match_failure' => 'Хатои ибора: Хатои ғайримунтазири preg_match',
	'pfunc_expr_unrecognised_word' => 'Хатои ибора: Калимаи ношинохта "$1"',
	'pfunc_expr_unexpected_operator' => 'Хатои ибора: Амалгари ғайримунтазири $1',
	'pfunc_expr_missing_operand' => 'Хатои ибора: Амалгари гумшуда барои  $1',
	'pfunc_expr_unexpected_closing_bracket' => 'Хатои ибора: Қафси бастаи номунтазир',
	'pfunc_expr_unrecognised_punctuation' => 'Хатои ибора: Аломати нуқтагузории шинохтанашуда "$1"',
	'pfunc_expr_unclosed_bracket' => 'Хатои ибора: Қафси бастанашуда',
	'pfunc_expr_division_by_zero' => 'Тақсим бар сифр',
	'pfunc_expr_unknown_error' => 'Хатои ибора: Хатои ношинос ($1)',
	'pfunc_expr_not_a_number' => 'Дар $1: натиҷа адад нест',
);

/** Tajik (Latin) (Тоҷикӣ (Latin))
 * @author Liangent
 */
$messages['tg-latn'] = array(
	'pfunc_desc' => 'Ba taçzehkunanda, dasturhoi mantiqī meafzojad',
	'pfunc_time_error' => 'Xato: zamoni ƣajrimiçoz',
	'pfunc_time_too_long' => 'Xato: #time faroxoniji beş az had',
	'pfunc_rel2abs_invalid_depth' => 'Xato: Cuquriji ƣajrimiçoz dar nişonī: "$1" (taloş baroi dastrasi ba jak nişonī bolotar az nişoniji reşa)',
	'pfunc_expr_stack_exhausted' => 'Xatoi ibora: Puşta az dast raftaast',
	'pfunc_expr_unexpected_number' => 'Xatoi ibora: Adadi ƣajrimuntazir',
	'pfunc_expr_preg_match_failure' => 'Xatoi ibora: Xatoi ƣajrimuntaziri preg_match',
	'pfunc_expr_unrecognised_word' => 'Xatoi ibora: Kalimai noşinoxta "$1"',
	'pfunc_expr_unexpected_operator' => 'Xatoi ibora: Amalgari ƣajrimuntaziri $1',
	'pfunc_expr_missing_operand' => 'Xatoi ibora: Amalgari gumşuda baroi  $1',
	'pfunc_expr_unexpected_closing_bracket' => 'Xatoi ibora: Qafsi bastai nomuntazir',
	'pfunc_expr_unrecognised_punctuation' => 'Xatoi ibora: Alomati nuqtaguzoriji şinoxtanaşuda "$1"',
	'pfunc_expr_unclosed_bracket' => 'Xatoi ibora: Qafsi bastanaşuda',
	'pfunc_expr_division_by_zero' => 'Taqsim bar sifr',
	'pfunc_expr_unknown_error' => 'Xatoi ibora: Xatoi noşinos ($1)',
	'pfunc_expr_not_a_number' => 'Dar $1: natiça adad nest',
);

/** Thai (ไทย)
 * @author Ans
 */
$messages['th'] = array(
	'pfunc_time_error' => 'เกิดข้อผิดพลาด: ค่าเวลาไม่ถูกต้อง',
	'pfunc_time_too_long' => 'เกิดข้อผิดพลาด: มีการเรียกใช้ #time มากเกินไป',
	'pfunc_rel2abs_invalid_depth' => 'เกิดข้อผิดพลาด: path depth ไม่ถูกต้อง: "$1" (เป็นการพยายามที่จะเข้าถึงตำแหน่งที่อยู่เหนือตำแหน่งราก)',
	'pfunc_expr_stack_exhausted' => 'สูตรเกิดข้อผิดพลาด: มี stack ไม่พอในการคำนวณสูตร',
	'pfunc_expr_unexpected_number' => 'สูตรไม่ถูกต้อง: ค่าตัวเลขอยู่ผิดที่',
	'pfunc_expr_preg_match_failure' => 'สูตรเกิดข้อผิดพลาด: เกิดความล้มเหลวในการสั่ง preg_match โดยไม่ทราบสาเหตุ',
	'pfunc_expr_unrecognised_word' => 'สูตรไม่ถูกต้อง: "$1" เป็นคำที่ไม่รู้จัก',
	'pfunc_expr_unexpected_operator' => 'สูตรไม่ถูกต้อง: $1 อยู่ผิดที่',
	'pfunc_expr_missing_operand' => 'สูตรไม่ถูกต้อง: ได้รับค่าไม่ครบในการคำนวณ $1',
	'pfunc_expr_unexpected_closing_bracket' => 'สูตรไม่ถูกต้อง: ปิดวงเล็บเกิน หรือ ปิดวงเล็บผิดที่',
	'pfunc_expr_unrecognised_punctuation' => 'สูตรไม่ถูกต้อง: "$1" เป็นเครื่องหมายหรือตัวอักษรที่ไม่รู้จัก',
	'pfunc_expr_unclosed_bracket' => 'สูตรไม่ถูกต้อง: ไม่ได้ปิดวงเล็บ',
	'pfunc_expr_division_by_zero' => 'ตัวหารเป็นศูนย์',
	'pfunc_expr_invalid_argument' => 'ค่าตัวแปรไม่ถูกต้อง: $1 ไม่สามารถรับค่าที่น้อยกว่า -1 หรือ มากกว่า 1',
	'pfunc_expr_invalid_argument_ln' => 'ค่าตัวแปรไม่ถูกต้อง: ln ไม่สามารถรับค่าที่น้อยกว่าหรือเท่ากับศูนย์',
	'pfunc_expr_unknown_error' => 'สูตรไม่ถูกต้อง: เกิดความผิดพลาดในสูตรโดยไม่ทราบสาเหตุ ($1)',
	'pfunc_expr_not_a_number' => '$1: ผลลัพธ์ไม่สามารถแทนด้วยจำนวน (NAN or not a number)',
);

/** Turkmen (Türkmençe)
 * @author Hanberke
 */
$messages['tk'] = array(
	'pfunc_desc' => 'Parseri logiki funksiýalar bilen güýçlendir',
	'pfunc_time_error' => 'Säwlik: nädogry wagt',
	'pfunc_time_too_long' => 'Säwlik: aşa köp #time çagyryşlary',
	'pfunc_rel2abs_invalid_depth' => 'Säwlik: Ýolda nädogry çuňluk: "$1" (kök düwüniň üstündäki bir düwüne barjak boldy)',
	'pfunc_expr_stack_exhausted' => 'Aňlatma säwligi: Stek gutardy',
	'pfunc_expr_unexpected_number' => 'Aňlatma säwligi: Garaşylmaýan san',
	'pfunc_expr_preg_match_failure' => 'Aňlatma säwligi: Garaşylmaýan preg_match näsazlygy',
	'pfunc_expr_unrecognised_word' => 'Aňlatma säwligi: Bilinmeýän "$1" sözi',
	'pfunc_expr_unexpected_operator' => 'Aňlatma säwligi: Garaşylmaýan $1 operatory',
	'pfunc_expr_missing_operand' => 'Aňlatma säwligi: $1 üçin kem operand',
	'pfunc_expr_unexpected_closing_bracket' => 'Aňlatma säwligi: Garaşylmaýan ýapyjy ýaý',
	'pfunc_expr_unrecognised_punctuation' => 'Aňlatma säwligi: Bilinmeýän punktuasiýa simwoly "$1"',
	'pfunc_expr_unclosed_bracket' => 'Aňlatma säwligi: Ýapylmadyk ýaý',
	'pfunc_expr_division_by_zero' => 'Nola bölmek',
	'pfunc_expr_invalid_argument' => '$1: < -1 ýa-da > 1 üçin nädogry argument',
	'pfunc_expr_invalid_argument_ln' => 'ln: <= 0 üçin nädogry argument',
	'pfunc_expr_unknown_error' => 'Aňlatma säwligi: Näbelli säwlik ($1)',
	'pfunc_expr_not_a_number' => '$1-de: netije san däl',
	'pfunc_string_too_long' => 'Säwlik: Setir $1 simwol çäginden geçýär',
);

/** Tagalog (Tagalog)
 * @author AnakngAraw
 */
$messages['tl'] = array(
	'pfunc_desc' => 'Pagibayuhin ang katangian ng banghay na may mga tungkuling makatwiran (may lohika)',
	'pfunc_time_error' => 'Kamalian: hindi tanggap na oras',
	'pfunc_time_too_long' => 'Kamalian: napakaraming mga pagtawag sa #oras',
	'pfunc_rel2abs_invalid_depth' => 'Kamalian: Hindi tanggap na sukat ng lalim sa daanan: "$1" (sinubok na puntahan ang isang alimpusong nasa itaas ng bugkol ng ugat)',
	'pfunc_expr_stack_exhausted' => 'Kamalian sa pagpapahayag: Naubos na ang salansan',
	'pfunc_expr_unexpected_number' => 'Kamalian sa pagpapahayag: Hindi inaasahang bilang',
	'pfunc_expr_preg_match_failure' => "Kamalian sa pagpapahayag: Hindi inaasahang pagkabigo ng \"pagtutugma_ng_hibla\" (''preg_match'')",
	'pfunc_expr_unrecognised_word' => 'Kamalian sa pagpapahayag: Hindi nakikilalang salitang "$1"',
	'pfunc_expr_unexpected_operator' => "Kamalian sa pagpapahayag: Hindi inaasahang bantas na tagapagsagawa (''operator'') ng $1",
	'pfunc_expr_missing_operand' => "Kamalian sa pagpapahayag: Nawawalang halaga (''operand'') para sa $1",
	'pfunc_expr_unexpected_closing_bracket' => 'Kamalian sa pagpapahayag: Hindi inaasahang pangpagtatapos na panaklong na kasingay (braket)',
	'pfunc_expr_unrecognised_punctuation' => 'Kamalian sa pagpapahayag: Hindi nakikilalang panitik na pangpalabantasang "$1"',
	'pfunc_expr_unclosed_bracket' => 'Kamalian sa pagpapahayag: Hindi naisarang panaklong na kasingay (braket)',
	'pfunc_expr_division_by_zero' => 'Paghahati sa pamamagitan ng wala (sero)',
	'pfunc_expr_invalid_argument' => 'Hindi tanggap na pangangatwiran (argumento) para sa $1: < -1 o > 1',
	'pfunc_expr_invalid_argument_ln' => 'Hindi tanggap na pangangatwiran (argumento) para sa ln: <= 0',
	'pfunc_expr_unknown_error' => 'Kamalian sa pagpapahayag: Hindi nalalamang kamalian ($1)',
	'pfunc_expr_not_a_number' => 'Sa $1: ang kinalabasan ay hindi isang bilang',
	'pfunc_string_too_long' => 'Kamalian: Lumampas ang bagting sa $1 hangganang panitik',
);

/** Turkish (Türkçe)
 * @author Joseph
 */
$messages['tr'] = array(
	'pfunc_desc' => 'Derleyiciyi mantıksal fonksiyonlarla geliştir',
	'pfunc_time_error' => 'Hata: geçersiz zaman',
	'pfunc_time_too_long' => 'Hata: çok fazla #time çağrısı',
	'pfunc_rel2abs_invalid_depth' => 'Hata: Yolda geçersiz derinlik: "$1" (kök düğümünün üstünde bir düğüme erişmeye çalıştı)',
	'pfunc_expr_stack_exhausted' => 'İfade hatası: Stack bitti',
	'pfunc_expr_unexpected_number' => 'İfade hatası: Beklenmeyen sayı',
	'pfunc_expr_preg_match_failure' => 'İfade hatası: Beklenmedik preg_match arızası',
	'pfunc_expr_unrecognised_word' => 'İfade hatası: Tanınmayan "$1" kelimesi',
	'pfunc_expr_unexpected_operator' => 'İfade hatası: Beklenmedik $1 operatörü',
	'pfunc_expr_missing_operand' => 'İfade hatası: $1 için eksik terim',
	'pfunc_expr_unexpected_closing_bracket' => 'İfade hatası: Beklenmedik kapa parantez',
	'pfunc_expr_unrecognised_punctuation' => 'İfade hatası: Tanınmayan noktalama karakteri "$1"',
	'pfunc_expr_unclosed_bracket' => 'İfade hatası: Kapanmamış parantez',
	'pfunc_expr_division_by_zero' => 'Sıfır ile bölme',
	'pfunc_expr_invalid_argument' => '$1 için geçersiz değişken: < -1 ya da > 1',
	'pfunc_expr_invalid_argument_ln' => 'ln için geçersiz değişken: <= 0',
	'pfunc_expr_unknown_error' => 'İfade hatası: Bilinmeyen hata ($1)',
	'pfunc_expr_not_a_number' => "$1'de: sonuç bir sayı değil",
	'pfunc_string_too_long' => 'Hata: Dize $1 karakter sınırını geçiyor',
);

/** Ukrainian (Українська)
 * @author AS
 * @author Ahonc
 */
$messages['uk'] = array(
	'pfunc_desc' => 'Покращений синтаксичний аналізатор з логічними функціями',
	'pfunc_time_error' => 'Помилка: неправильний час',
	'pfunc_time_too_long' => 'Помилка: забагато викликів функції #time',
	'pfunc_rel2abs_invalid_depth' => 'Помилка: неправильна глибина шляху: «$1» (спроба доступу до вузла, що знаходиться вище, ніж кореневий)',
	'pfunc_expr_stack_exhausted' => 'Помилка виразу: стек переповнений',
	'pfunc_expr_unexpected_number' => 'Помилка виразу: неочікуване число',
	'pfunc_expr_preg_match_failure' => 'Помилка виразу: збій preg_match',
	'pfunc_expr_unrecognised_word' => 'Помилка виразу: незрозуміле слово «$1»',
	'pfunc_expr_unexpected_operator' => 'Помилка виразу: неочікуваний оператор $1',
	'pfunc_expr_missing_operand' => 'Помилка виразу: бракує операнда для $1',
	'pfunc_expr_unexpected_closing_bracket' => 'Помилка виразу: неочікувана закрита дужка',
	'pfunc_expr_unrecognised_punctuation' => 'Помилка виразу: незрозумілий розділовий знак «$1»',
	'pfunc_expr_unclosed_bracket' => 'Помилка виразу: незакрита дужка',
	'pfunc_expr_division_by_zero' => 'Ділення на нуль',
	'pfunc_expr_invalid_argument' => 'Неправильний аргумент для $1: < -1 або > 1',
	'pfunc_expr_invalid_argument_ln' => 'Помилковий аргумент логарифма (має бути більший від нуля)',
	'pfunc_expr_unknown_error' => 'Помилка виразу: невідома помилка ($1)',
	'pfunc_expr_not_a_number' => 'У $1: результат не є числом',
	'pfunc_string_too_long' => 'Помилка: довжина рядка перевищує межу в {{PLURAL:$1|$1 символ|$1 символи|$1 символів}}',
);

/** Vèneto (Vèneto)
 * @author Candalua
 */
$messages['vec'] = array(
	'pfunc_desc' => 'Zonta al parser na serie de funsion logiche',
	'pfunc_time_error' => 'Eror: orario mìa valido',
	'pfunc_time_too_long' => 'Eror: massa chiamate a #time',
	'pfunc_rel2abs_invalid_depth' => 'Eror: profondità mìa valida nel percorso "$1" (se gà proà a accédar a un nodo piassè sora de la raìsa)',
	'pfunc_expr_stack_exhausted' => "Eror ne l'espression: stack esaurìo",
	'pfunc_expr_unexpected_number' => "Eror ne l'espression: xe vegnù fora un nùmaro che no se se spetava",
	'pfunc_expr_preg_match_failure' => "Eror ne l'espression: eror inateso in preg_match",
	'pfunc_expr_unrecognised_word' => 'Eror ne l\'espression: parola "$1" mìa riconossiùa',
	'pfunc_expr_unexpected_operator' => "Eror ne l'espression: operator $1 inateso",
	'pfunc_expr_missing_operand' => "Eror ne l'espression: operando mancante par $1",
	'pfunc_expr_unexpected_closing_bracket' => "Eror ne l'espression: parentesi chiusa inatesa",
	'pfunc_expr_unrecognised_punctuation' => 'Eror ne l\'espression: caràtere de puntegiatura "$1" mìa riconossiùo',
	'pfunc_expr_unclosed_bracket' => "Eror ne l'espression: parentesi verta e mìa sarà",
	'pfunc_expr_division_by_zero' => 'Division par zero',
	'pfunc_expr_invalid_argument' => 'Argomento mìa valido par $1: < -1 or > 1',
	'pfunc_expr_invalid_argument_ln' => 'Argomento mìa valido par ln: <= 0',
	'pfunc_expr_unknown_error' => "Eror ne l'espression: eror sconossiùo ($1)",
	'pfunc_expr_not_a_number' => "In $1: el risultato no'l xe mìa un nùmaro",
	'pfunc_string_too_long' => 'Eròr: la stringa la va fora dal limite de {{PLURAL:$1|1 caràtere|$1 caràteri}}',
);

/** Veps (Vepsan kel')
 * @author Игорь Бродский
 */
$messages['vep'] = array(
	'pfunc_time_error' => 'Petuz: vär aig',
);

/** Vietnamese (Tiếng Việt)
 * @author Minh Nguyen
 * @author Vinhtantran
 */
$messages['vi'] = array(
	'pfunc_desc' => 'Nâng cao bộ xử lý với những hàm cú pháp lôgic',
	'pfunc_time_error' => 'Lỗi: thời gian không hợp lệ',
	'pfunc_time_too_long' => 'Lỗi: quá nhiều lần gọi #time',
	'pfunc_time_too_big' => 'Lỗi: #time chỉ hỗ trợ các năm cho tới 9999',
	'pfunc_rel2abs_invalid_depth' => 'Lỗi: độ sâu không hợp lệ trong đường dẫn “$1” (do cố gắng truy cập nút phía trên nút gốc)',
	'pfunc_expr_stack_exhausted' => 'Lỗi biểu thức: Đã cạn stack',
	'pfunc_expr_unexpected_number' => 'Lỗi biểu thức: Dư số',
	'pfunc_expr_preg_match_failure' => 'Lỗi biểu thức: Hàm preg_match thất bại',
	'pfunc_expr_unrecognised_word' => 'Lỗi biểu thức: Từ “$1” không rõ ràng',
	'pfunc_expr_unexpected_operator' => "Lỗi biểu thức: Dư toán tử '''$1'''",
	'pfunc_expr_missing_operand' => 'Lỗi biểu thức: Thiếu toán hạng trong $1',
	'pfunc_expr_unexpected_closing_bracket' => 'Lỗi biểu thức: Dư dấu đóng ngoặc',
	'pfunc_expr_unrecognised_punctuation' => 'Lỗi biểu thức: Dấu phân cách “$1” không rõ ràng',
	'pfunc_expr_unclosed_bracket' => 'Lỗi biểu thức: Dấu ngoặc chưa được đóng',
	'pfunc_expr_division_by_zero' => 'Chia cho zero',
	'pfunc_expr_invalid_argument' => 'Tham số không hợp lệ cho $1: < −1 hay > 1',
	'pfunc_expr_invalid_argument_ln' => 'Tham số không hợp lệ cho ln: ≤ 0',
	'pfunc_expr_unknown_error' => 'Lỗi biểu thức: Lỗi không rõ nguyên nhân ($1)',
	'pfunc_expr_not_a_number' => 'Trong $1: kết quả không phải là kiểu số',
	'pfunc_string_too_long' => 'Lỗi: Chuỗi vượt quá giới hạn $1 ký tự',
	'pfunc-convert-dimensionmismatch' => 'Lỗi: Không thể chuyển đổi giữa các đơn vị “$1” và “$2”.',
	'pfunc-convert-unknownunit' => 'Lỗi: Không hiểu đơn vị “$1”.',
	'pfunc-convert-unknowndimension' => 'Lỗi: Không hiểu kích thước “$1”.',
	'pfunc-convert-invalidcompoundunit' => 'Lỗi: Đơn vị ghép “$1” không hợp lệ.',
	'pfunc-convert-nounit' => 'Lỗi: Không đưa vào đơn vị nguồn.',
	'pfunc-convert-doublecompoundunit' => 'Lỗi: Không thể phân tích các đơn vị ghép đúp như “$1”.',
	'pfunc-convert-dimension-length' => 'chiều dài',
	'pfunc-convert-dimension-area' => 'diện tích',
	'pfunc-convert-dimension-volume' => 'thể tích',
	'pfunc-convert-dimension-time' => 'thời gian',
	'pfunc-convert-dimension-timesquared' => 'thời gian²',
	'pfunc-convert-dimension-mass' => 'khối lượng',
	'pfunc-convert-dimension-speed' => 'tốc độ',
	'pfunc-convert-dimension-temperature' => 'nhiệt độ',
	'pfunc-convert-dimension-acceleration' => 'gia tốc',
	'pfunc-convert-dimension-force' => 'lực lượng',
	'pfunc-convert-dimension-torque' => 'mô men lực',
	'pfunc-convert-dimension-energy' => 'năng lượng',
	'pfunc-convert-dimension-power' => 'công suất',
	'pfunc-convert-dimension-pressure' => 'áp suất',
	'pfunc-convert-dimension-density' => 'mật độ',
	'pfunc-convert-dimension-fuelefficiencypositive' => 'hiệu quả nhiên liệu dương',
	'pfunc-convert-dimension-fuelefficiencynegative' => 'hiệu quả nhiên liệu âm',
	'pfunc-convert-prefix-yotta' => 'yôta',
	'pfunc-convert-prefix-zetta' => 'zêta',
	'pfunc-convert-prefix-exa' => 'exa',
	'pfunc-convert-prefix-peta' => 'pêta',
	'pfunc-convert-prefix-tera' => 'têra',
	'pfunc-convert-prefix-giga' => 'giga',
	'pfunc-convert-prefix-mega' => 'mêga',
	'pfunc-convert-prefix-kilo' => 'kilô',
	'pfunc-convert-prefix-hecto' => 'hêctô',
	'pfunc-convert-prefix-deca' => 'đềca',
	'pfunc-convert-prefix-deci' => 'đêxi',
	'pfunc-convert-prefix-centi' => 'xenti',
	'pfunc-convert-prefix-milli' => 'mili',
	'pfunc-convert-prefix-micro' => 'micrô',
	'pfunc-convert-prefix-nano' => 'nanô',
	'pfunc-convert-prefix-pico' => 'picô',
	'pfunc-convert-prefix-femto' => 'femtô',
	'pfunc-convert-prefix-atto' => 'atô',
	'pfunc-convert-prefix-zepto' => 'zéptô',
	'pfunc-convert-prefix-yocto' => 'yóctô',
	'pfunc-convert-prefix-milli-abbr' => 'm',
	'pfunc-convert-unit-length-metre' => '$1{{PLURAL:$2}}$3mét',
	'pfunc-convert-unit-length-angstrom' => '$1{{PLURAL:$2}}ångström',
	'pfunc-convert-unit-length-mile' => '$1{{PLURAL:$2}}dặm',
	'pfunc-convert-unit-length-furlong' => '$1{{PLURAL:$2}}furlong',
	'pfunc-convert-unit-length-chain' => '$1{{PLURAL:$2}}chain',
	'pfunc-convert-unit-length-rod' => '$1{{PLURAL:$2}}rod',
	'pfunc-convert-unit-length-fathom' => '$1{{PLURAL:$2}}fathom',
	'pfunc-convert-unit-length-yard' => '$1{{PLURAL:$2}}yard',
	'pfunc-convert-unit-length-foot' => '$1{{PLURAL:$2}}foot',
	'pfunc-convert-unit-length-hand' => '$1{{PLURAL:$2}}hand',
	'pfunc-convert-unit-length-inch' => '$1{{PLURAL:$2}}inch',
	'pfunc-convert-unit-length-nauticalmile' => '$1{{PLURAL:$2}}hải lý',
	'pfunc-convert-unit-length-nauticalmileuk' => '$1{{PLURAL:$2}}hải lý (Anh trước 1970)',
	'pfunc-convert-unit-length-nauticalmileus' => '$1{{PLURAL:$2}}hải lý (Mỹ trước 1954)',
	'pfunc-convert-unit-length-parsec' => '$1{{PLURAL:$2}}$3parsec',
	'pfunc-convert-unit-length-lightyear' => '$1{{PLURAL:$2}}$3 năm ánh sáng',
	'pfunc-convert-unit-length-astronomicalunit' => '$1{{PLURAL:$2}}đơn vị thiên văn',
	'pfunc-convert-unit-length-furlong-abbr' => '$1furlong',
	'pfunc-convert-unit-length-chain-abbr' => '$1chain',
	'pfunc-convert-unit-length-rod-abbr' => '$1rd',
	'pfunc-convert-unit-length-fathom-abbr' => '$1fathom',
	'pfunc-convert-unit-length-yard-abbr' => '$1yd',
	'pfunc-convert-unit-length-foot-abbr' => '$1ft',
	'pfunc-convert-unit-length-hand-abbr' => '$1h',
	'pfunc-convert-unit-length-inch-abbr' => '$1in',
	'pfunc-convert-unit-length-nauticalmile-abbr' => '$1nmi',
	'pfunc-convert-unit-length-nauticalmileuk-abbr' => '$1nmi (Anh)',
	'pfunc-convert-unit-length-nauticalmileus-abbr' => '$1nmi (Mỹ trước 1954)',
	'pfunc-convert-unit-length-parsec-abbr' => '$1$3pc',
	'pfunc-convert-unit-length-lightyear-abbr' => '$1$3ly',
	'pfunc-convert-unit-length-astronomicalunit-abbr' => '$1ua',
	'pfunc-convert-unit-area-squarekilometre' => '$1{{PLURAL:$2}}kilômét vuông',
	'pfunc-convert-unit-area-squaremetre' => '$1{{PLURAL:$2}}mét vuông',
	'pfunc-convert-unit-area-squarecentimetre' => '$1{{PLURAL:$2}}xentimét vuông',
	'pfunc-convert-unit-area-squaremillimetre' => '$1{{PLURAL:$2}}millimét vuông',
	'pfunc-convert-unit-area-hectare' => '$1{{PLURAL:$2}}hecta',
	'pfunc-convert-unit-area-squaremile' => '$1{{PLURAL:$2}}dặm vuông',
	'pfunc-convert-unit-area-acre' => '$1{{PLURAL:$2}}mẫu Anh',
	'pfunc-convert-unit-area-squareyard' => '$1{{PLURAL:$2}}yard vuông',
	'pfunc-convert-unit-area-squarefoot' => '$1{{PLURAL:$2}}foot vuông',
	'pfunc-convert-unit-area-squareinch' => '$1{{PLURAL:$2}}inch vuông',
	'pfunc-convert-unit-area-squarenauticalmile' => '$1{{PLURAL:$2}}hải lý vuông',
	'pfunc-convert-unit-area-dunam' => '$1{{PLURAL:$2}}dunam',
	'pfunc-convert-unit-area-tsubo' => '$1{{PLURAL:$2}}tsubo',
	'pfunc-convert-unit-area-squarekilometre-abbr' => '$1km²',
	'pfunc-convert-unit-area-squaremetre-abbr' => '$1m²',
	'pfunc-convert-unit-area-squarecentimetre-abbr' => '$1cm²',
	'pfunc-convert-unit-area-squaremillimetre-abbr' => '$1mm²',
	'pfunc-convert-unit-area-hectare-abbr' => '$1ha',
	'pfunc-convert-unit-area-squaremile-abbr' => '$1sq mi',
	'pfunc-convert-unit-area-acre-abbr' => '$1mẫu',
	'pfunc-convert-unit-area-squareyard-abbr' => '$1sq yd',
	'pfunc-convert-unit-area-squarefoot-abbr' => '$1sq ft',
	'pfunc-convert-unit-area-squareinch-abbr' => '$1sq in',
	'pfunc-convert-unit-area-squarenauticalmile-abbr' => '$1sq nmi',
	'pfunc-convert-unit-area-dunam-abbr' => '$1dunam',
	'pfunc-convert-unit-area-tsubo-abbr' => '$1tsubo',
	'pfunc-convert-unit-time-second' => '$1{{PLURAL:$2}}giây',
	'pfunc-convert-unit-time-year' => '$1{{PLURAL:$2}}$3 năm',
	'pfunc-convert-unit-time-day' => '$1{{PLURAL:$2}}ngày',
	'pfunc-convert-unit-time-hour' => '$1{{PLURAL:$2}}giờ',
	'pfunc-convert-unit-time-minute' => '$1{{PLURAL:$2}}phút',
	'pfunc-convert-unit-time-second-abbr' => '$1s',
	'pfunc-convert-unit-time-year-abbr' => '$1$3yr',
	'pfunc-convert-unit-time-day-abbr' => '$1ngày',
	'pfunc-convert-unit-time-hour-abbr' => '$1h',
	'pfunc-convert-unit-time-minute-abbr' => '$1min',
	'pfunc-convert-unit-volume-cubicmetre' => '$1{{PLURAL:$2}}mét khối',
	'pfunc-convert-unit-volume-cubiccentimetre' => '$1{{PLURAL:$2}}xentimét khối',
	'pfunc-convert-unit-volume-cubicmillimetre' => '$1{{PLURAL:$2}}milimét khối',
	'pfunc-convert-unit-volume-kilolitre' => '$1{{PLURAL:$2}}kilôlít',
	'pfunc-convert-unit-volume-litre' => '$1{{PLURAL:$2}}lít',
	'pfunc-convert-unit-volume-centilitre' => '$1{{PLURAL:$2}}xentilít',
	'pfunc-convert-unit-volume-millilitre' => '$1{{PLURAL:$2}}mililít',
	'pfunc-convert-unit-volume-cubicyard' => '$1{{PLURAL:$2}}yard khối',
	'pfunc-convert-unit-volume-cubicfoot' => '$1{{PLURAL:$2}}foot khối',
	'pfunc-convert-unit-volume-cubicinch' => '$1{{PLURAL:$2}}inch khối',
	'pfunc-convert-unit-volume-barrel' => '$1{{PLURAL:$2}}thùng',
	'pfunc-convert-unit-volume-bushel' => '$1{{PLURAL:$2}}giạ',
	'pfunc-convert-unit-volume-gallon' => '$1{{PLURAL:$2}}gallon',
	'pfunc-convert-unit-volume-quart' => '$1{{PLURAL:$2}}quart',
	'pfunc-convert-unit-volume-pint' => '$1{{PLURAL:$2}}pint',
	'pfunc-convert-unit-volume-fluidounce' => '$1{{PLURAL:$2}}aoxơ chất lỏng',
	'pfunc-convert-unit-volume-barrelus' => '$1{{PLURAL:$2}}thùng Mỹ',
	'pfunc-convert-unit-volume-barreloil' => '$1{{PLURAL:$2}}thùng',
	'pfunc-convert-unit-volume-barrelbeer' => '$1{{PLURAL:$2}}thùng',
	'pfunc-convert-unit-volume-usgallon' => '$1{{PLURAL:$2}}gallon Mỹ',
	'pfunc-convert-unit-volume-usquart' => '$1{{PLURAL:$2}}quart Mỹ',
	'pfunc-convert-unit-volume-uspint' => '$1{{PLURAL:$2}}pint Mỹ',
	'pfunc-convert-unit-volume-usfluidounce' => '$1{{PLURAL:$2}}aoxơ chất lỏng Mỹ',
	'pfunc-convert-unit-volume-usdrybarrel' => '$1{{PLURAL:$2}}thùng chất khô Mỹ',
	'pfunc-convert-unit-volume-usbushel' => '$1{{PLURAL:$2}}thùng Mỹ',
	'pfunc-convert-unit-volume-usdrygallon' => '$1{{PLURAL:$2}}gallon chất khô Mỹ',
	'pfunc-convert-unit-volume-usdryquart' => '$1{{PLURAL:$2}}quart chất khô Mỹ',
	'pfunc-convert-unit-volume-usdrypint' => '$1{{PLURAL:$2}}pint chất khô Mỹ',
	'pfunc-convert-unit-volume-cubicmetre-abbr' => '$1m³',
	'pfunc-convert-unit-volume-cubiccentimetre-abbr' => '$1cm³',
	'pfunc-convert-unit-volume-cubicmillimetre-abbr' => '$1mm³',
	'pfunc-convert-unit-volume-litre-abbr' => '$1$3l',
	'pfunc-convert-unit-volume-cubicyard-abbr' => '$1cu yd',
	'pfunc-convert-unit-volume-cubicfoot-abbr' => '$1cu ft',
	'pfunc-convert-unit-volume-cubicinch-abbr' => '$1cu in',
	'pfunc-convert-unit-volume-barrel-abbr' => '$1bbl',
	'pfunc-convert-unit-volume-bushel-abbr' => '$1bsh',
	'pfunc-convert-unit-volume-gallon-abbr' => '$1gal',
	'pfunc-convert-unit-volume-quart-abbr' => '$1qt',
	'pfunc-convert-unit-volume-pint-abbr' => '$1pt',
	'pfunc-convert-unit-volume-fluidounce-abbr' => '$1fl oz',
	'pfunc-convert-unit-volume-barrelus-abbr' => '$1bbl Mỹ',
	'pfunc-convert-unit-volume-barreloil-abbr' => '$1bbl',
	'pfunc-convert-unit-volume-barrelbeer-abbr' => '$1bbl',
	'pfunc-convert-unit-volume-usgallon-abbr' => '$1gal Mỹ',
	'pfunc-convert-unit-volume-usquart-abbr' => '$1qt Mỹ',
	'pfunc-convert-unit-volume-uspint-abbr' => '$1pt Mỹ',
	'pfunc-convert-unit-volume-usfluidounce-abbr' => '$1fl oz Mỹ',
	'pfunc-convert-unit-volume-usdrybarrel-abbr' => '$1bbl Mỹ',
	'pfunc-convert-unit-volume-usbushel-abbr' => '$1bsh Mỹ',
	'pfunc-convert-unit-volume-usdrygallon-abbr' => '$1dry gal Mỹ',
	'pfunc-convert-unit-volume-usdryquart-abbr' => '$1dry qt Mỹ',
	'pfunc-convert-unit-volume-usdrypint-abbr' => '$1dry pt Mỹ',
	'pfunc-convert-unit-speed-mile-hour' => '$1dặm một giờ',
	'pfunc-convert-unit-speed-speedoflight' => '$1c',
	'pfunc-convert-unit-speed-mile-hour-abbr' => '$1mph',
	'pfunc-convert-unit-speed-speedoflight-abbr' => '$1c',
	'pfunc-convert-unit-pressure-pascal' => '$1{{PLURAL:$2}}$3pascal',
	'pfunc-convert-unit-pressure-bar' => '$1ba',
	'pfunc-convert-unit-pressure-decibar' => '$1đêxiba',
	'pfunc-convert-unit-pressure-millibar' => '$1miliba',
	'pfunc-convert-unit-pressure-kilobarye' => '$1kilôbarye',
	'pfunc-convert-unit-pressure-barye' => '$1barye',
	'pfunc-convert-unit-pressure-atmosphere' => '$1{{PLURAL:$2}}atmôtphe',
	'pfunc-convert-unit-pressure-torr' => '$1{{PLURAL:$2}}torr',
	'pfunc-convert-unit-pressure-mmhg' => '$1{{PLURAL:$2}}milimét thủy ngân',
	'pfunc-convert-unit-pressure-inhg' => '$1{{PLURAL:$2}}inch thủy ngân',
	'pfunc-convert-unit-pressure-psi' => '$1{{PLURAL:$2}}pound một inch vuông',
	'pfunc-convert-unit-pressure-pascal-abbr' => '$1$3Pa',
	'pfunc-convert-unit-pressure-bar-abbr' => '$1bar',
	'pfunc-convert-unit-pressure-decibar-abbr' => '$1dbar',
	'pfunc-convert-unit-pressure-millibar-abbr' => '$1mbar',
	'pfunc-convert-unit-pressure-kilobarye-abbr' => '$1kBa',
	'pfunc-convert-unit-pressure-barye-abbr' => '$1Ba',
	'pfunc-convert-unit-pressure-atmosphere-abbr' => '$1atm',
	'pfunc-convert-unit-pressure-torr-abbr' => '$1Torr',
	'pfunc-convert-unit-pressure-mmhg-abbr' => '$1mmHg',
	'pfunc-convert-unit-pressure-inhg-abbr' => '$1inHg',
	'pfunc-convert-unit-pressure-psi-abbr' => '$1psi',
);

/** Volapük (Volapük)
 * @author Smeira
 */
$messages['vo'] = array(
	'pfunc_time_error' => 'Pök: tim no lonöföl',
	'pfunc_expr_division_by_zero' => 'Müedam dub ser',
	'pfunc_expr_unknown_error' => 'Notidotapöl: pöl nesevädik ($1)',
	'pfunc_expr_not_a_number' => 'In $1: sek no binon num',
);

/** Yiddish (ייִדיש)
 * @author פוילישער
 */
$messages['yi'] = array(
	'pfunc_time_error' => 'גרײַז: אומגילטיגע צײַט',
	'pfunc_expr_unexpected_operator' => 'אויסדריק גרײַז: אומגעריכטער $1 אפעראַטאר',
	'pfunc_expr_unclosed_bracket' => 'אויסדריק גרײַז: אומגעשלאסענער קלאַמער',
	'pfunc_expr_not_a_number' => 'אין $1: רעזולטאַט איז נישט קיין נומער',
);

/** Yoruba (Yorùbá)
 * @author Demmy
 */
$messages['yo'] = array(
	'pfunc_time_error' => 'Àsìṣe: àsìkò àìtọ́',
	'pfunc_expr_unexpected_number' => 'Àsìṣe ìgbékalẹ̀ọ̀rọ̀: Nọ́mbà àìretí',
	'pfunc_expr_division_by_zero' => 'Pínpín pẹ̀lú òdo',
	'pfunc_expr_not_a_number' => 'Nínú $1: èsì kìí ṣe nọ́mbà',
);

/** Cantonese (粵語)
 * @author Shinjiman
 */
$messages['yue'] = array(
	'pfunc_desc' => '用邏輯功能去加強處理器',
	'pfunc_time_error' => '錯: 唔啱嘅時間',
	'pfunc_time_too_long' => '錯: 太多 #time 呼叫',
	'pfunc_rel2abs_invalid_depth' => '錯: 唔啱路徑嘅深度: "$1" (已經試過由頭點落個點度)',
	'pfunc_expr_stack_exhausted' => '表達錯: 堆叠耗盡',
	'pfunc_expr_unexpected_number' => '表達錯: 未預料嘅數字',
	'pfunc_expr_preg_match_failure' => '表達錯: 未預料嘅 preg_match失敗',
	'pfunc_expr_unrecognised_word' => '表達錯: 未預料嘅字 "$1"',
	'pfunc_expr_unexpected_operator' => '表達錯: 未預料嘅 $1 運算符',
	'pfunc_expr_missing_operand' => '表達錯: 缺少 $1 嘅運算符',
	'pfunc_expr_unexpected_closing_bracket' => '表達錯: 未預料嘅閂括號',
	'pfunc_expr_unrecognised_punctuation' => '表達錯: 未能認得到嘅標點 "$1"',
	'pfunc_expr_unclosed_bracket' => '表達錯: 未閂好嘅括號',
	'pfunc_expr_division_by_zero' => '除以零',
	'pfunc_expr_invalid_argument' => '$1嘅無效參數: < -1 or > 1',
	'pfunc_expr_invalid_argument_ln' => 'ln嘅無效參數: <= 0',
	'pfunc_expr_unknown_error' => '表達錯: 未知嘅錯 ($1)',
	'pfunc_expr_not_a_number' => '響 $1: 結果唔係數字',
);

/** Simplified Chinese (‪中文(简体)‬)
 * @author Hydra
 * @author Liangent
 * @author PhiLiP
 * @author Philip
 * @author Shinjiman
 * @author 阿pp
 */
$messages['zh-hans'] = array(
	'pfunc_desc' => '用逻辑函数加强解析器',
	'pfunc_time_error' => '错误：无效时间',
	'pfunc_time_too_long' => '错误：#time调用次数过多',
	'pfunc_time_too_big' => '错误：#time只支持到9999年',
	'pfunc_rel2abs_invalid_depth' => '错误：无效路径深度：“$1”（尝试访问根节点以上节点）',
	'pfunc_expr_stack_exhausted' => '表达式错误：堆栈耗尽',
	'pfunc_expr_unexpected_number' => '表达式错误：未预料的数字',
	'pfunc_expr_preg_match_failure' => '表达式错误：未预料的preg_match失败',
	'pfunc_expr_unrecognised_word' => '表达式错误：无法识别的词语“$1”',
	'pfunc_expr_unexpected_operator' => '表达式错误：未预料的$1操作符',
	'pfunc_expr_missing_operand' => '表达式错误：缺少$1的操作数',
	'pfunc_expr_unexpected_closing_bracket' => '表达式错误：未预料的反括号',
	'pfunc_expr_unrecognised_punctuation' => '表达式错误：无法识别的标点“$1”',
	'pfunc_expr_unclosed_bracket' => '表达式错误：未封闭的括号',
	'pfunc_expr_division_by_zero' => '零除',
	'pfunc_expr_invalid_argument' => '$1的无效参数：< -1 或 > 1',
	'pfunc_expr_invalid_argument_ln' => 'ln的无效参数：<= 0',
	'pfunc_expr_unknown_error' => '表达式错误：未知错误（$1）',
	'pfunc_expr_not_a_number' => '在$1中：结果不是数字',
	'pfunc_string_too_long' => '错误：字符串超过$1字符限制',
	'pfunc-convert-dimension-time' => '时间',
	'pfunc-convert-dimension-mass' => '重量',
	'pfunc-convert-dimension-speed' => '速度',
	'pfunc-convert-unit-area-squarenauticalmile-abbr' => '$1平方海里',
	'pfunc-convert-unit-volume-cubicmetre-abbr' => '$1m<sup>3</sup>',
);

/** Traditional Chinese (‪中文(繁體)‬)
 * @author Gaoxuewei
 * @author Liangent
 * @author Mark85296341
 * @author Shinjiman
 * @author Waihorace
 */
$messages['zh-hant'] = array(
	'pfunc_desc' => '用邏輯函數加強解析器',
	'pfunc_time_error' => '錯誤：無效時間',
	'pfunc_time_too_long' => '錯誤：過多的 #time 呼叫',
	'pfunc_time_too_big' => '錯誤：#時間只支援至9999年',
	'pfunc_rel2abs_invalid_depth' => '錯誤：無效路徑深度：「$1」（嘗試訪問頂點以上節點）',
	'pfunc_expr_stack_exhausted' => '表達式錯誤：堆疊耗盡',
	'pfunc_expr_unexpected_number' => '表達式錯誤：未預料的數字',
	'pfunc_expr_preg_match_failure' => '表達式錯誤：未預料的 preg_match 失敗',
	'pfunc_expr_unrecognised_word' => '表達式錯誤：無法識別的詞語「$1」',
	'pfunc_expr_unexpected_operator' => '表達式錯誤：未預料的 $1 運算子',
	'pfunc_expr_missing_operand' => '表達式錯誤：缺少 $1 的運算元',
	'pfunc_expr_unexpected_closing_bracket' => '表達式錯誤：未預料的反括號',
	'pfunc_expr_unrecognised_punctuation' => '表達式錯誤：無法識別的標點「$1」',
	'pfunc_expr_unclosed_bracket' => '表達式錯誤：未封閉的括號',
	'pfunc_expr_division_by_zero' => '除以零',
	'pfunc_expr_invalid_argument' => '$1 的無效參量：< -1 或 > 1',
	'pfunc_expr_invalid_argument_ln' => 'ln 的無效參量：<= 0',
	'pfunc_expr_unknown_error' => '表達式錯誤：未知錯誤（$1）',
	'pfunc_expr_not_a_number' => '在 $1 中：結果不是數字',
	'pfunc_string_too_long' => '錯誤：字符串超過$1字符限制',
);

