/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef DECCHARTP_H
#define DECCHARTP_H

#include <Xm/ToggleB.h>

/*
** Class Part
*/

typedef struct _DecChartClassPart 
{
	int	ignore;
} DecChartClassPart;

typedef struct _DecChartClassRec
{
	CoreClassPart		core_class;
	CompositeClassPart	composite_class;
	DecChartClassPart	dec_class;
} DecChartClassRec;

extern DecChartClassRec decChartClassRec;

/*
** Instance part
*/

typedef struct _DecChartPart
{
	/* Compatibility with Motif */

	caddr_t		user_data;

	/* children attributes */

	String	title; 
	Widget	text;

	Boolean	manage_watch;
	Widget	watch;
	String  watch_pixmap_name;
	Pixmap  watch_pixmap;

	int	legend_position;
	Boolean manage_legend;
	unsigned char legend_orientation;

	/* Callbacks */

	XtCallbackList	expose_callback;
	XtCallbackList	help_callback;
	XtCallbackList	value_changed_callback;

	/* Internal resources */

	GC      gc;

} DecChartPart;

typedef struct _DecChartRec
{
	CorePart	core;
	CompositePart	composite;
	DecChartPart	decChart;

} DecChartRec;

#endif
