<elements>
  <summary>
    <attribution license="cc4" from="Microsoft" modified="false" />
    <para>The <see cref="N:System.Web.Profile" /> namespace contains classes that are used to work with ASP.NET user profiles in Web server applications.</para>
  </summary>
  <remarks>
    <attribution license="cc4" from="Microsoft" modified="false" />
    <para>ASP.NET profiles are used to store and retrieve user settings in a data source such as a database. Profile information and property values are managed by using a profile provider. Profile information can be stored in a Microsoft SQL Server database by using the <see cref="T:System.Web.Profile.SqlProfileProvider" /> class, or in a custom data source by using an implementation of the <see cref="T:System.Web.Profile.ProfileProvider" /> abstract class.</para>
    <para>ASP.NET profiles are configured by using the <format type="text/html"><a href="ccb9bf3a-a044-464d-b89b-5cb5a3d389dd">profile</a></format> configuration section.</para>
    <para>When an application starts that has profiles enabled, ASP.NET creates a new class of type ProfileCommon, which inherits from the <see cref="T:System.Web.Profile.ProfileBase" /> class. Strongly typed accessors are added to the ProfileCommon class for each property that is defined in the <format type="text/html"><a href="ccb9bf3a-a044-464d-b89b-5cb5a3d389dd">profile</a></format> configuration section. An instance of the ProfileCommon class is set as the value of the <see cref="P:System.Web.HttpContext.Profile" /> property of the current <see cref="T:System.Web.HttpContext" /> object. You can create a custom profile implementation that inherits from the <see cref="T:System.Web.Profile.ProfileBase" /> abstract class and that defines properties for the user profile that are not specified in the <format type="text/html"><a href="ccb9bf3a-a044-464d-b89b-5cb5a3d389dd">profile</a></format> configuration element.</para>
  </remarks>
  <class name="CustomProviderDataAttribute" fullname="System.Web.Profile.CustomProviderDataAttribute" assembly="System.Web">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Provides a string of custom data to the provider for a profile property.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>The <see cref="T:System.Web.Profile.CustomProviderDataAttribute" /> class is used to supply a string of data with a profile property to a custom profile provider. The custom data string can be set to any string value and is set using the customProviderData attribute of the <format type="text/html"><a href="d3ea033b-751b-4bdc-8917-a5d44560808e">add</a></format> configuration element for adding profile properties. If the customProviderData attribute is set, then the value is placed in the <see cref="P:System.Configuration.SettingsProperty.Attributes" /> collection for the property and is indexed by the name "CustomProviderData."</para>
    </remarks>
  </class>
  <class name="DefaultProfile" fullname="System.Web.Profile.DefaultProfile" assembly="System.Web">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Represents a user-profile instance when no profile properties are defined.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>The <see cref="T:System.Web.Profile.DefaultProfile" /> class is used by ASP.NET to return a default instance of a user profile when the profile feature is enabled but no properties are defined.</para>
    </remarks>
  </class>
  <class name="ProfileAuthenticationOption" fullname="System.Web.Profile.ProfileAuthenticationOption" assembly="System.Web">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Describes the authentication type of user profiles to be searched.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>The <see cref="T:System.Web.Profile.ProfileAuthenticationOption" /> enumeration is used by profile providers and the <see cref="T:System.Web.Profile.ProfileManager" /> class when they search for profiles in the data source and when they delete them. The <see cref="T:System.Web.Profile.ProfileAuthenticationOption" /> enumeration is used to select whether only anonymous, only authenticated, or all profiles are searched.</para>
    </remarks>
  </class>
  <class name="ProfileAutoSaveEventArgs" fullname="System.Web.Profile.ProfileAutoSaveEventArgs" assembly="System.Web">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Provides data for the <see cref="E:System.Web.Profile.ProfileModule.ProfileAutoSaving" /> event of the <see cref="T:System.Web.Profile.ProfileModule" /> class.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>The <see cref="T:System.Web.Profile.ProfileAutoSaveEventHandler" /> delegate is defined for the <see cref="E:System.Web.Profile.ProfileModule.ProfileAutoSaving" /> event of the <see cref="T:System.Web.Profile.ProfileModule" /> class. You can access the <see cref="E:System.Web.Profile.ProfileModule.ProfileAutoSaving" /> event of the <see cref="T:System.Web.Profile.ProfileModule" /> class in the Global.asax file for your ASP.NET application, as shown in the example for this topic. The <see cref="E:System.Web.Profile.ProfileModule.ProfileAutoSaving" /> event is raised at the end of page execution if the <see cref="P:System.Web.Profile.ProfileManager.AutomaticSaveEnabled" /> property is true.</para>
      <para>The <see cref="M:System.Configuration.SettingsBase.Save" /> method automatically determines whether properties that are made up of primitive types, strings, or <see cref="T:System.DateTime" /> objects have been changed, by checking the <see cref="P:System.Configuration.SettingsPropertyValue.IsDirty" /> property value for each <see cref="T:System.Configuration.SettingsPropertyValue" /> in the user profile. The <see cref="M:System.Configuration.SettingsBase.Save" /> method cannot explicitly determine whether a custom class has changed. You can use the <see cref="E:System.Web.Profile.ProfileModule.ProfileAutoSaving" /> event to determine whether a custom object has been modified and then either continue with the automatic save if the object has been modified or cancel the automatic save if the object has not been modified.</para>
      <para>To cancel the automatic profile save operation, set the <see cref="P:System.Web.Profile.ProfileAutoSaveEventArgs.ContinueWithProfileAutoSave" /> property to false in the <see cref="E:System.Web.Profile.ProfileModule.ProfileAutoSaving" /> event; otherwise, set the <see cref="P:System.Web.Profile.ProfileAutoSaveEventArgs.ContinueWithProfileAutoSave" /> property to true.</para>
      <para>There may be multiple subscribers to the <see cref="E:System.Web.Profile.ProfileModule.ProfileAutoSaving" /> event. The <see cref="T:System.Web.Profile.ProfileModule" /> will use the last value that the <see cref="P:System.Web.Profile.ProfileAutoSaveEventArgs.ContinueWithProfileAutoSave" /> property is set to. As a result, it is recommended that you explicitly set the <see cref="P:System.Web.Profile.ProfileAutoSaveEventArgs.ContinueWithProfileAutoSave" /> property in the <see cref="E:System.Web.Profile.ProfileModule.ProfileAutoSaving" /> event regardless of whether you are canceling or continuing with the automatic save, as you may need to overwrite the value set by an earlier subscriber.</para>
    </remarks>
  </class>
  <class name="ProfileAutoSaveEventHandler" fullname="System.Web.Profile.ProfileAutoSaveEventHandler" assembly="System.Web">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Represents the method that will handle the <see cref="E:System.Web.Profile.ProfileModule.ProfileAutoSaving" /> event of a <see cref="T:System.Web.Profile.ProfileModule" />. </para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>The <see cref="T:System.Web.Profile.ProfileAutoSaveEventHandler" /> delegate is defined for the <see cref="E:System.Web.Profile.ProfileModule.ProfileAutoSaving" /> event of the <see cref="T:System.Web.Profile.ProfileModule" /> class. You can access the <see cref="E:System.Web.Profile.ProfileModule.ProfileAutoSaving" /> event of the <see cref="T:System.Web.Profile.ProfileModule" /> class in the Global.asax file for your ASP.NET application, as shown in the example for this topic. The <see cref="E:System.Web.Profile.ProfileModule.ProfileAutoSaving" /> event is raised at the end of page execution if the <see cref="P:System.Web.Profile.ProfileManager.AutomaticSaveEnabled" /> property is true.</para>
      <para>The <see cref="M:System.Configuration.SettingsBase.Save" /> method automatically determines whether properties that are made up of primitive types, strings, or <see cref="T:System.DateTime" /> objects have been changed, by checking the <see cref="P:System.Configuration.SettingsPropertyValue.IsDirty" /> property value for each <see cref="T:System.Configuration.SettingsPropertyValue" /> in the user profile. However, the <see cref="M:System.Configuration.SettingsBase.Save" /> method cannot explicitly determine whether a custom class has changed. You can handle the <see cref="E:System.Web.Profile.ProfileModule.ProfileAutoSaving" /> event to determine whether a custom object has been modified and to continue with the automatic save for modified objects and cancel the automatic save if no objects have been modified.</para>
      <para>To cancel the automatic profile save operation, set the <see cref="P:System.Web.Profile.ProfileAutoSaveEventArgs.ContinueWithProfileAutoSave" /> property to false in the <see cref="E:System.Web.Profile.ProfileModule.ProfileAutoSaving" /> event; otherwise, set the <see cref="P:System.Web.Profile.ProfileAutoSaveEventArgs.ContinueWithProfileAutoSave" /> property to true.</para>
      <para>There may be multiple subscribers to the <see cref="E:System.Web.Profile.ProfileModule.ProfileAutoSaving" /> event. The <see cref="T:System.Web.Profile.ProfileModule" /> will use the last value that the <see cref="P:System.Web.Profile.ProfileAutoSaveEventArgs.ContinueWithProfileAutoSave" /> property is set to. As a result, it is recommended that you explicitly set the <see cref="P:System.Web.Profile.ProfileAutoSaveEventArgs.ContinueWithProfileAutoSave" /> property in the <see cref="E:System.Web.Profile.ProfileModule.ProfileAutoSaving" /> event, regardless of whether you are canceling or continuing with the automatic save, as you may need to overwrite the value set by an earlier subscriber.</para>
    </remarks>
  </class>
  <class name="ProfileBase" fullname="System.Web.Profile.ProfileBase" assembly="System.Web">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Provides untyped access to profile property values and information.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>ASP.NET uses the <see cref="T:System.Web.Profile.ProfileBase" /> class to create the class used for the user profile. When an application that has the user profile enabled is started, ASP.NET creates a new class of type ProfileCommon, which inherits from the <see cref="T:System.Web.Profile.ProfileBase" /> class. Strongly typed accessors are added to the ProfileCommon class for each property defined in the <format type="text/html"><a href="ccb9bf3a-a044-464d-b89b-5cb5a3d389dd">profile</a></format> configuration section. The strongly typed accessors of the ProfileCommon class call the <see cref="M:System.Web.Profile.ProfileBase.GetPropertyValue(System.String)" /> and <see cref="M:System.Web.Profile.ProfileBase.SetPropertyValue(System.String,System.Object)" /> methods of the <see cref="T:System.Web.Profile.ProfileBase" /> base class to retrieve and set profile property values, respectively. An instance of the ProfileCommon class is set as the value of the <see cref="P:System.Web.HttpContext.Profile" /> property for the ASP.NET application.</para>
      <para>To create an instance of a user profile in an ASP.NET application, it is recommended that you use the <see cref="Overload:System.Web.Profile.ProfileBase.Create" /> method.</para>
    </remarks>
  </class>
  <class name="ProfileEventArgs" fullname="System.Web.Profile.ProfileEventArgs" assembly="System.Web">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Provides data for the <see cref="E:System.Web.Profile.ProfileModule.Personalize" /> event of the <see cref="T:System.Web.Profile.ProfileModule" /> class.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>You can use the <see cref="T:System.Web.Profile.ProfileEventArgs" /> class during the <see cref="E:System.Web.Profile.ProfileModule.Personalize" /> event to specify a custom user profile. If, when the <see cref="E:System.Web.Profile.ProfileModule.Personalize" /> event completes, the <see cref="T:System.Web.Profile.ProfileEventArgs" /> parameter of the <see cref="T:System.Web.Profile.ProfileEventHandler" /> has its <see cref="P:System.Web.Profile.ProfileEventArgs.Profile" /> property set to a value that’s not null, then the <see cref="T:System.Web.Profile.ProfileModule" /> uses the value of the <see cref="P:System.Web.Profile.ProfileEventArgs.Profile" /> property in the current <see cref="T:System.Web.HttpContext" />.</para>
    </remarks>
  </class>
  <class name="ProfileEventHandler" fullname="System.Web.Profile.ProfileEventHandler" assembly="System.Web">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Represents the method that will handle the <see cref="E:System.Web.Profile.ProfileModule.Personalize" /> event of a <see cref="T:System.Web.Profile.ProfileModule" />. </para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>The <see cref="T:System.Web.Profile.ProfileEventHandler" /> delegate is defined for the <see cref="E:System.Web.Profile.ProfileModule.Personalize" /> event of the <see cref="T:System.Web.Profile.ProfileModule" /> class. You can access the <see cref="E:System.Web.Profile.ProfileModule.Personalize" /> event of the <see cref="T:System.Web.Profile.ProfileModule" /> class in the Global.asax file for your ASP.NET application using the Profile_Personalize global event, as shown in the example for this topic.</para>
      <para>You can use the <see cref="E:System.Web.Profile.ProfileModule.Personalize" /> event to specify a custom user profile. If the <see cref="P:System.Web.Profile.ProfileEventArgs.Profile" /> property of the <see cref="T:System.Web.Profile.ProfileEventArgs" /> parameter specified for the <see cref="E:System.Web.Profile.ProfileModule.Personalize" /> event's <see cref="T:System.Web.Profile.ProfileEventHandler" /> is set to a non-null value when the <see cref="E:System.Web.Profile.ProfileModule.Personalize" /> event completes, then the <see cref="T:System.Web.Profile.ProfileModule" /> will use that value for the <see cref="P:System.Web.HttpContext.Profile" /> property of the current <see cref="T:System.Web.HttpContext" />.</para>
    </remarks>
  </class>
  <class name="ProfileGroupBase" fullname="System.Web.Profile.ProfileGroupBase" assembly="System.Web">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Provides untyped access to grouped ASP.NET profile property values.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>The <see cref="T:System.Web.Profile.ProfileGroupBase" /> class is used by ASP.NET to create grouped properties in the <see cref="P:System.Web.HttpContext.Profile" /> property for the current <see cref="T:System.Web.HttpContext" />. When properties are specified as a group of properties using the <format type="text/html"><a href="b4e3672f-9653-4034-a178-fb358b02730e">group Element for properties for profile (ASP.NET Settings Schema)</a></format>, ASP.NET creates a new class with strongly typed accessors for each property in the group. The new class inherits the <see cref="T:System.Web.Profile.ProfileGroupBase" /> base class. The strongly typed accessors of the new class call the <see cref="M:System.Web.Profile.ProfileGroupBase.GetPropertyValue(System.String)" /> and <see cref="M:System.Web.Profile.ProfileGroupBase.SetPropertyValue(System.String,System.Object)" /> methods of the <see cref="T:System.Web.Profile.ProfileGroupBase" /> base class to retrieve and set profile property values, respectively.</para>
      <para>The <see cref="T:System.Web.Profile.ProfileGroupBase" /> passes calls to get and set property values to the class that inherits the <see cref="T:System.Web.Profile.ProfileBase" /> class that is supplied to the <see cref="M:System.Web.Profile.ProfileGroupBase.Init(System.Web.Profile.ProfileBase,System.String)" /> method of the <see cref="T:System.Web.Profile.ProfileGroupBase" /> class. See the <see cref="T:System.Web.Profile.ProfileBase" /> class for more information on behaviors, exceptions, and so on.</para>
      <para>This class is not intended to be created from your code.</para>
    </remarks>
  </class>
  <class name="ProfileInfo" fullname="System.Web.Profile.ProfileInfo" assembly="System.Web">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Provides information about a user profile.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>The <see cref="T:System.Web.Profile.ProfileInfo" /> class is used to represent information about a user profile from the data store, including the last date and time when profile properties were retrieved or updated, the user name associated with the profile, and whether the profile is for an anonymous or authenticated user.</para>
      <para>
        <see cref="T:System.Web.Profile.ProfileInfo" /> objects are constructed and returned as part of a <see cref="T:System.Web.Profile.ProfileInfoCollection" /> by the <see cref="M:System.Web.Profile.ProfileProvider.GetAllProfiles(System.Web.Profile.ProfileAuthenticationOption,System.Int32,System.Int32,System.Int32@)" />, <see cref="M:System.Web.Profile.ProfileProvider.GetAllInactiveProfiles(System.Web.Profile.ProfileAuthenticationOption,System.DateTime,System.Int32,System.Int32,System.Int32@)" />, <see cref="M:System.Web.Profile.ProfileProvider.FindProfilesByUserName(System.Web.Profile.ProfileAuthenticationOption,System.String,System.Int32,System.Int32,System.Int32@)" />, and <see cref="M:System.Web.Profile.ProfileProvider.FindInactiveProfilesByUserName(System.Web.Profile.ProfileAuthenticationOption,System.String,System.DateTime,System.Int32,System.Int32,System.Int32@)" /> methods of a <see cref="T:System.Web.Profile.ProfileProvider" />.</para>
    </remarks>
  </class>
  <class name="ProfileInfoCollection" fullname="System.Web.Profile.ProfileInfoCollection" assembly="System.Web">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>A collection of <see cref="T:System.Web.Profile.ProfileInfo" /> objects.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>A <see cref="T:System.Web.Profile.ProfileInfoCollection" /> object contains <see cref="T:System.Web.Profile.ProfileInfo" /> objects that represent user profiles from a data source. A <see cref="T:System.Web.Profile.ProfileInfoCollection" /> is returned from the <see cref="M:System.Web.Profile.ProfileProvider.GetAllProfiles(System.Web.Profile.ProfileAuthenticationOption,System.Int32,System.Int32,System.Int32@)" />, <see cref="M:System.Web.Profile.ProfileProvider.GetAllInactiveProfiles(System.Web.Profile.ProfileAuthenticationOption,System.DateTime,System.Int32,System.Int32,System.Int32@)" />, <see cref="M:System.Web.Profile.ProfileProvider.FindProfilesByUserName(System.Web.Profile.ProfileAuthenticationOption,System.String,System.Int32,System.Int32,System.Int32@)" />, and <see cref="M:System.Web.Profile.ProfileProvider.FindInactiveProfilesByUserName(System.Web.Profile.ProfileAuthenticationOption,System.String,System.DateTime,System.Int32,System.Int32,System.Int32@)" /> methods of a <see cref="T:System.Web.Profile.ProfileProvider" />.</para>
      <para>A <see cref="T:System.Web.Profile.ProfileInfoCollection" /> can be supplied to the <see cref="M:System.Web.Profile.ProfileProvider.DeleteProfiles(System.Web.Profile.ProfileInfoCollection)" /> method to delete profile information and properties from the data source.</para>
    </remarks>
  </class>
  <class name="ProfileManager" fullname="System.Web.Profile.ProfileManager" assembly="System.Web">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Manages user profile data and settings.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>The ASP.NET profile is used to store and retrieve user settings in a data source such as a database. The user profile is accessed using the <see cref="P:System.Web.HttpContext.Profile" /> property of the current <see cref="T:System.Web.HttpContext" />. Profile information and property values are managed using a profile provider.</para>
      <para>The <see cref="T:System.Web.Profile.ProfileManager" /> class is used to manage profile settings, search for user profiles, and delete user profiles that are no longer in use. The <see cref="T:System.Web.Profile.ProfileManager" /> class provides static methods and properties that can be accessed by referencing the <see cref="T:System.Web.Profile.ProfileManager" /> class in your application code. For an example, see the Example section in this topic and additional examples in the topics for members of the <see cref="T:System.Web.Profile.ProfileManager" /> class.</para>
      <para>By default, the user profile is disabled for all ASP.NET applications. To enable the user profile, set the enabled attribute of the <format type="text/html"><a href="ccb9bf3a-a044-464d-b89b-5cb5a3d389dd">profile</a></format> configuration element to true, as shown in the following example.</para>
      <code>&lt;configuration&gt;
  &lt;system.web&gt;
    &lt;profile enabled="true" /&gt;
  &lt;/system.web&gt;
&lt;/configuration&gt;</code>
      <para>For more information about the user profile, see <format type="text/html"><a href="89439440-92ea-48c3-a4bd-dea40307899d">ASP.NET Profile Properties Overview</a></format>.</para>
      <para>A profile provider is used to store and retrieve properties in the user profile. The .NET Framework includes a <see cref="T:System.Web.Profile.SqlProfileProvider" /> class that stores user profile properties in a SQL Server database. A <see cref="T:System.Web.Profile.SqlProfileProvider" /> instance named AspNetSqlProvider is specified in the machine configuration as the default profile provider. The AspNetSqlProvider instance connects to the SQL Server database on the local Web server. You can specify a <see cref="T:System.Web.Profile.SqlProfileProvider" /> that connects to another SQL Server as the default profile provider by using the <format type="text/html"><a href="9e998377-b07f-44c1-ad9b-20a60e83c18f">providers</a></format> configuration element and the defaultProvider attribute of the <format type="text/html"><a href="ccb9bf3a-a044-464d-b89b-5cb5a3d389dd">profile</a></format> configuration element, as shown in the following example.</para>
      <code>&lt;configuration&gt;
  &lt;connectionStrings&gt;
    &lt;add name="SqlServices" connectionString=
      "Data Source=MySqlServer;Integrated Security=SSPI;Initial Catalog=aspnetdb;" /&gt;
  &lt;/connectionStrings&gt;
  &lt;system.web&gt;
    &lt;profile defaultProvider="SqlProvider"&gt;
      &lt;providers&gt;
        &lt;clear /&gt;
        &lt;add name="SqlProvider"
          type="System.Web.Profile.SqlProfileProvider"
          connectionStringName="SqlServices"
          applicationName="MyApplication" /&gt;
      &lt;/providers&gt;
    &lt;/profile&gt;
  &lt;/system.web&gt;
&lt;/configuration&gt;</code>
    </remarks>
  </class>
  <class name="ProfileMigrateEventArgs" fullname="System.Web.Profile.ProfileMigrateEventArgs" assembly="System.Web">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Provides data for the <see cref="E:System.Web.Profile.ProfileModule.MigrateAnonymous" /> event of the <see cref="T:System.Web.Profile.ProfileModule" /> class.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>The <see cref="T:System.Web.Profile.ProfileMigrateEventArgs" /> object provides event information to the <see cref="E:System.Web.Profile.ProfileModule.MigrateAnonymous" /> event of the <see cref="T:System.Web.Profile.ProfileModule" /> class. The <see cref="T:System.Web.Profile.ProfileMigrateEventArgs" /> object provides access to the <see cref="T:System.Web.HttpContext" /> of the current request and the anonymous user identifier for the anonymous profile in the <see cref="P:System.Web.Profile.ProfileMigrateEventArgs.AnonymousID" /> property. </para>
      <para>You can use the <see cref="E:System.Web.Profile.ProfileModule.MigrateAnonymous" /> event to copy profile property values from an anonymous profile to an authenticated profile when a user who has been anonymously using your application logs in.</para>
      <para>When an application that has the user profile enabled is started, ASP.NET creates a new class of type ProfileCommon, which inherits from the <see cref="T:System.Web.Profile.ProfileBase" /> class. When the ProfileCommon class is generated, based on the profile properties specified in the Web.config file, a GetProfile method is added that enables you to retrieve a ProfileCommon object based on a user name. You can use the GetProfile method of the current profile to retrieve the property values of the anonymous profile. The anonymous property values can then be copied to the current profile for the authenticated user.</para>
    </remarks>
  </class>
  <class name="ProfileMigrateEventHandler" fullname="System.Web.Profile.ProfileMigrateEventHandler" assembly="System.Web">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Represents the method that will handle the <see cref="E:System.Web.Profile.ProfileModule.MigrateAnonymous" /> event of the <see cref="T:System.Web.Profile.ProfileModule" /> class.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>The <see cref="T:System.Web.Profile.ProfileMigrateEventHandler" /> delegate is defined for the <see cref="E:System.Web.Profile.ProfileModule.MigrateAnonymous" /> event of the <see cref="T:System.Web.Profile.ProfileModule" /> class. You can access the <see cref="E:System.Web.Profile.ProfileModule.MigrateAnonymous" /> event of the <see cref="T:System.Web.Profile.ProfileModule" /> class in the Global.asax file for your ASP.NET application as shown in the example for this topic.</para>
      <para>You can use the <see cref="E:System.Web.Profile.ProfileModule.MigrateAnonymous" /> event to copy profile property values from an anonymous profile to an authenticated profile when someone who has been anonymously using your application logs in.</para>
      <para>When an application that has the user profile enabled is started, ASP.NET creates a new class of type ProfileCommon, which inherits from the <see cref="T:System.Web.Profile.ProfileBase" /> class. When the ProfileCommon class is generated, based on the profile properties specified in the Web.config file, a GetProfile method is added that enables you to retrieve a ProfileCommon object based on a user name. You can use the GetProfile method of the current profile to retrieve the property values of the anonymous profile. The anonymous property values can then be copied to the current profile for the authenticated user.</para>
    </remarks>
  </class>
  <class name="ProfileModule" fullname="System.Web.Profile.ProfileModule" assembly="System.Web">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Manages the creation of the user profile and profile events. This class cannot be inherited.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>When the user profile is enabled, ASP.NET uses the <see cref="T:System.Web.Profile.ProfileModule" /> to create the user profile and store it in the <see cref="P:System.Web.HttpContext.Profile" /> property of the current <see cref="T:System.Web.HttpContext" />.</para>
      <para>The <see cref="T:System.Web.Profile.ProfileModule" /> exposes the following events you can handle to configure authentication in your application:</para>
      <list type="bullet">
        <item>
          <para>The <see cref="E:System.Web.Profile.ProfileModule.MigrateAnonymous" /> event, to migrate profile settings from an anonymous profile to an authenticated profile when an anonymous user logs in.</para>
        </item>
        <item>
          <para>The <see cref="E:System.Web.Profile.ProfileModule.Personalize" /> event, to customize how the user profile is created.</para>
        </item>
        <item>
          <para>The <see cref="E:System.Web.Profile.ProfileModule.ProfileAutoSaving" /> event, to control how the user profile is saved when the <see cref="P:System.Web.Profile.ProfileManager.AutomaticSaveEnabled" /> property is set to true.</para>
        </item>
      </list>
      <para>For information about enabling the user profile, see <format type="text/html"><a href="ccb9bf3a-a044-464d-b89b-5cb5a3d389dd">&lt;profile&gt; Element for &lt;system.web&gt;</a></format>.</para>
    </remarks>
  </class>
  <class name="ProfileProvider" fullname="System.Web.Profile.ProfileProvider" assembly="System.Web">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Defines the contract that ASP.NET implements to provide profile services using custom profile providers.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>ASP.NET profiles offer persistent storage and retrieval of user-specific properties. Profile property values and information are stored in a data source in a manner determined by the <see cref="T:System.Web.Profile.ProfileProvider" /> implementation. You can use the profile providers that are included with the .NET Framework (represented by the classes that derive from the <see cref="T:System.Web.Profile.ProfileProvider" /> abstract class), or you can implement your own provider by creating a new class that derives from <see cref="T:System.Web.Profile.ProfileProvider" />.</para>
      <para>There are two primary reasons for creating a custom profile provider.</para>
      <list type="bullet">
        <item>
          <para>You need to store profile information in a data source that is not supported by the profile providers included with the .NET Framework, such as a FoxPro database, an Oracle database, or other data stores.</para>
        </item>
        <item>
          <para>You need to manage profile information using a database schema that is different from the database schema used by the providers that ship with the .NET Framework. A common example of this would be user data that already exists in a SQL Server database for a company network or a Web site.</para>
        </item>
      </list>
      <para>The <see cref="T:System.Web.Profile.ProfileProvider" /> abstract class inherits from the <see cref="T:System.Configuration.SettingsProvider" /> abstract class, which inherits from the <see cref="T:System.Configuration.Provider.ProviderBase" /> abstract class. Classes that implement <see cref="T:System.Web.Profile.ProfileProvider" /> must also implement the required members of the <see cref="T:System.Configuration.SettingsProvider" /> and <see cref="T:System.Configuration.Provider.ProviderBase" /> abstract classes. For more information about implementing a profile provider, see <format type="text/html"><a href="58de6e99-31a7-41b9-93ed-51b9b4a67e98">Implementing a Profile Provider</a></format>.</para>
    </remarks>
  </class>
  <class name="ProfileProviderAttribute" fullname="System.Web.Profile.ProfileProviderAttribute" assembly="System.Web">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Identifies the profile provider for a user-profile property.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>The <see cref="T:System.Web.Profile.ProfileProviderAttribute" /> class is used to identify the profile provider for a property of a custom profile implementation. A custom profile implementation is a class that inherits from the <see cref="T:System.Web.Profile.ProfileBase" /> abstract class and defines properties for the user profile that are not specified in the <format type="text/html"><a href="ccb9bf3a-a044-464d-b89b-5cb5a3d389dd">profile</a></format> configuration element. You can specify a custom type for the user profile using the inherits attribute of the <format type="text/html"><a href="ccb9bf3a-a044-464d-b89b-5cb5a3d389dd">profile</a></format> configuration element in the Web.config file for an application, as shown in the following example.</para>
      <code>&lt;configuration&gt;
  &lt;connectionStrings&gt;
    &lt;add name="SqlServices" connectionString=
      "Data Source=localhost;Integrated Security=SSPI;Initial Catalog=aspnetdb;" /&gt;
  &lt;/connectionStrings&gt;

  &lt;system.web&gt;
    &lt;authentication mode="Forms" &gt;
      &lt;forms loginUrl="login.aspx"
        name=".ASPXFORMSAUTH" /&gt;
    &lt;/authentication&gt;

    &lt;authorization&gt;
      &lt;deny users="?" /&gt;
    &lt;/authorization&gt;

    &lt;profile inherits="Samples.AspNet.Profile.EmployeeProfile"
      defaultProvider="SqlProvider"&gt;
      &lt;providers&gt;
        &lt;clear /&gt;
        &lt;add
          name="SqlProvider"
          type="System.Web.Profile.SqlProfileProvider" 
          connectionStringName="SqlServices" 
          description="SQL Profile Provider for Sample"/&gt; 
        &lt;add
          name="EmployeeInfoProvider"
          type="System.Web.Profile.SqlProfileProvider" 
          connectionStringName="SqlServices" 
          description="SQL Profile Provider for Employee Info"/&gt; 
      &lt;/providers&gt;

      &lt;properties&gt;
        &lt;add name="GarmentSize" /&gt;
      &lt;/properties&gt;
    &lt;/profile&gt;
  &lt;/system.web&gt;
&lt;/configuration&gt;</code>
    </remarks>
  </class>
  <class name="ProfileProviderCollection" fullname="System.Web.Profile.ProfileProviderCollection" assembly="System.Web">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>A collection of objects that inherit the <see cref="T:System.Web.Profile.ProfileProvider" /> abstract class.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>The profile providers for an application are exposed as a read-only <see cref="T:System.Web.Profile.ProfileProviderCollection" /> through the <see cref="P:System.Web.Profile.ProfileManager.Providers" /> property of the <see cref="T:System.Web.Profile.ProfileManager" /> class. You can access a specific profile provider in the collection by name and cast it as the specific provider type, such as <see cref="T:System.Web.Profile.SqlProfileProvider" />. This enables you to manage user profile properties from multiple data stores in a single application. It also allows you to access members of a specific profile provider that are not members of the <see cref="T:System.Web.Profile.ProfileProvider" /> abstract class.</para>
    </remarks>
  </class>
  <class name="SettingsAllowAnonymousAttribute" fullname="System.Web.Profile.SettingsAllowAnonymousAttribute" assembly="System.Web">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Identifies whether a profile property can be set or accessed for an anonymous user.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>The <see cref="T:System.Web.Profile.SettingsAllowAnonymousAttribute" /> class is used to identify whether a property of a custom profile implementation can be accessed if the user is an anonymous user. For information about enabling anonymous identification, see the documentation provided for the <format type="text/html"><a href="2bd927ef-9057-4703-9c55-4cfb6d7d0929">anonymousIdentification</a></format> configuration element.</para>
      <para>If no <see cref="T:System.Web.Profile.SettingsAllowAnonymousAttribute" /> is specified for a profile property, anonymous access of the profile property is not allowed.</para>
      <para>A custom profile implementation is a class that inherits from the <see cref="T:System.Web.Profile.ProfileBase" /> abstract class and defines properties for the user profile that are not specified in the <format type="text/html"><a href="ccb9bf3a-a044-464d-b89b-5cb5a3d389dd">profile</a></format> configuration element. You can specify a custom user-profile type in the application's Web.config file with the inherits attribute of the <format type="text/html"><a href="ccb9bf3a-a044-464d-b89b-5cb5a3d389dd">profile</a></format> configuration element as shown in the following example.</para>
      <para>&lt;configuration&gt;</para>
      <para>  &lt;connectionStrings&gt;</para>
      <para>    &lt;add </para>
      <para>      name="SqlServices" </para>
      <para>      connectionString="Data Source=localhost;Integrated Security=SSPI;Initial Catalog=aspnetdb;" /&gt;</para>
      <para>  &lt;/connectionStrings&gt;</para>
      <para />
      <para>  &lt;system.web&gt;</para>
      <para>    &lt;authentication mode="Forms" &gt;</para>
      <para>      &lt;forms </para>
      <para>        loginUrl="login.aspx"</para>
      <para>        name=".ASPXFORMSAUTH" /&gt;</para>
      <para>    &lt;/authentication&gt;</para>
      <para />
      <para>    &lt;authorization&gt;</para>
      <para>      &lt;deny users="?" /&gt;</para>
      <para>    &lt;/authorization&gt;</para>
      <para />
      <para>    &lt;profile inherits="Samples.AspNet.Profile.EmployeeProfile"</para>
      <para>             defaultProvider="SqlProvider"&gt;</para>
      <para>      &lt;providers&gt;</para>
      <para>        &lt;clear /&gt;</para>
      <para>        &lt;add</para>
      <para>          name="SqlProvider"</para>
      <para>          type="System.Web.Profile.SqlProfileProvider" </para>
      <para>          connectionStringName="SqlServices" </para>
      <para>          description="SQL Profile Provider for Sample"/&gt; </para>
      <para>        &lt;add</para>
      <para>          name="EmployeeInfoProvider"</para>
      <para>          type="System.Web.Profile.SqlProfileProvider" </para>
      <para>          connectionStringName="SqlServices" </para>
      <para>          description="SQL Profile Provider for Employee Info"/&gt; </para>
      <para>      &lt;/providers&gt;</para>
      <para />
      <para>      &lt;properties&gt;</para>
      <para>        &lt;add name="GarmentSize" /&gt;</para>
      <para>      &lt;/properties&gt;</para>
      <para>    &lt;/profile&gt;</para>
      <para>  &lt;/system.web&gt;</para>
      <para>&lt;/configuration&gt;</para>
    </remarks>
  </class>
  <class name="SqlProfileProvider" fullname="System.Web.Profile.SqlProfileProvider" assembly="System.Web">
    <summary>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>Manages storage of profile information for an ASP.NET application in a SQL Server database.</para>
    </summary>
    <remarks>
      <attribution license="cc4" from="Microsoft" modified="false" />
      <para>The ASP.NET profile is used to store and retrieve user settings in a data source such as a database. The user profile is accessed using the <see cref="P:System.Web.HttpContext.Profile" /> property of the current <see cref="T:System.Web.HttpContext" />. Profile information and property values are managed using a profile provider.</para>
      <para>The <see cref="T:System.Web.Profile.SqlProfileProvider" /> class is used by ASP.NET to store and retrieve profile settings for an ASP.NET application that is using a SQL Server database. To use a <see cref="T:System.Web.Profile.SqlProfileProvider" />, you must first create the SQL Server database used by the <see cref="T:System.Web.Profile.SqlProfileProvider" />. To create the database used by the <see cref="T:System.Web.Profile.SqlProfileProvider" />, run the aspnet_regsql.exe tool, which is found in the [drive:]\WINDOWS\Microsoft.NET\Framework\<paramref name="2.0versionNumber" /> folder, and specify the <system>-A p</system> option. The following command demonstrates how you might use the aspnet_regsql.exe executable:</para>
      <code>aspnet_regsql.exe -A p</code>
      <para>The example above does not specify a name for the database that is created, so the default name will be used. The default database name is Aspnetdb.</para>
      <para>The machine configuration contains a default <see cref="T:System.Web.Profile.SqlProfileProvider" /> instance named AspNetSqlProvider that connects to the SQL Server on the local machine. You can use this instance of the provider, or specify your own in the Web.config file for your ASP.NET application.</para>
      <block subset="none" type="note">
        <para>If the profile provider is configured with a connection string that uses integrated security, the process account of the ASP.NET application must have rights to connect to the SQL Server database.</para>
      </block>
    </remarks>
  </class>
</elements>