/*
 * This file is part of Flowplayer, http://flowplayer.org
 *
 * By: Daniel Rossi, <electroteque@gmail.com>, Anssi Piirainen Flowplayer Oy
 * Copyright (c) 2008-2011 Flowplayer Oy *
 * Released under the MIT License:
 * http://www.opensource.org/licenses/mit-license.php
 */

package org.flowplayer.bwcheck.config {
import flash.system.Capabilities;

import org.flowplayer.cluster.ClusterConfig;
import org.flowplayer.ui.buttons.TooltipButtonConfig;
import org.flowplayer.util.PropertyBinder;

public class Config extends ClusterConfig {
    private var _switchOnFullscreen:Boolean = true;
    private var _maxWidth:Number = -1;
    private var _rememberBitrate:Boolean = false;
    private var _bitrateProfileName:String = "bitrateProfile";
    private var _dynamicBuffer:Boolean = false;
    private var _dynamic:Boolean = false;
    private var _cacheExpiry:Number = 24 * 60 * 60;
    private var _checkOnStart:Object = null;
    private var _qos:QosRulesConfig = new QosRulesConfig();
    private var _live:Boolean = false;
    private var _provider:String;

    public function set switchOnFullscreen(value:Boolean):void {
        _switchOnFullscreen = value;
    }

    public function get switchOnFullscreen():Boolean {
        return _switchOnFullscreen;
    }

    public function get maxWidth():Number {
        return _maxWidth;
    }

    public function set maxWidth(width:Number):void {
        _maxWidth = width;
    }

    public function set rememberBitrate(value:Boolean):void {
        _rememberBitrate = value;
    }

    public function get rememberBitrate():Boolean {
        return _rememberBitrate;
    }

    public function set dynamic(value:Boolean):void {
        _dynamic = value;
    }

    public function get dynamic():Boolean {
        return Capabilities.version.split(' ')[1].split(",")[0] >= 10 && _dynamic;
    }

    public function set bitrateProfileName(value:String):void {
        _bitrateProfileName = value;
    }

    public function get bitrateProfileName():String {
        return _bitrateProfileName;
    }

    public function set dynamicBuffer(value:Boolean):void {
        _dynamicBuffer = value;
    }

    public function get dynamicBuffer():Boolean {
        return _dynamicBuffer;
    }

    public function get cacheExpiry():Number {
        return _cacheExpiry;
    }

    public function set cacheExpiry(value:Number):void {
        _cacheExpiry = value;
    }


    public function get checkOnStart():Boolean {
        return _checkOnStart;
    }

    public function set checkOnStart(value:Boolean):void {
        _checkOnStart = value;
    }

    public function setQos(value:Object):void {
        new PropertyBinder(_qos).copyProperties(value);
    }

    public function get qos():QosRulesConfig {
        return _qos;
    }

    public function get live():Boolean {
        return _live;
    }

    public function set live(value:Boolean):void {
        _live = value;
    }

    public function get provider():String {
        return _provider;
    }

    public function set provider(value:String):void {
        _provider = value;
    }
}
}
