% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/almostAllAccessors.R
\docType{methods}
\name{nsamples}
\alias{nsamples}
\alias{nsamples,ANY-method}
\alias{nsamples,phyloseq-method}
\alias{nsamples,otu_table-method}
\alias{nsamples,sample_data-method}
\title{Get the number of samples.}
\usage{
nsamples(physeq)

\S4method{nsamples}{ANY}(physeq)

\S4method{nsamples}{phyloseq}(physeq)

\S4method{nsamples}{otu_table}(physeq)

\S4method{nsamples}{sample_data}(physeq)
}
\arguments{
\item{physeq}{A \code{\link{phyloseq-class}}, \code{\link{sample_data}},
or \code{\link{otu_table-class}}.}
}
\value{
An integer indicating the total number of samples.
}
\description{
Get the number of samples.
}
\examples{
#
data("esophagus")
tree <- phy_tree(esophagus)
OTU1 <- otu_table(esophagus)
nsamples(OTU1)
physeq1 <- phyloseq(OTU1, tree)
nsamples(physeq1)
}
\seealso{
\code{\link{taxa_names}}, \code{\link{sample_names}},
 \code{\link{ntaxa}}
}
